# faster-megaparsec

This package defines a MonadParsec instance for 
(a type isomorphic to) `StateT s Maybe`
where `s` is a Megaparsec Stream type such as `String`, `Text` or `ByteString`.
This parser can be faster than Cassava for csv parsing 
but at the cost of no error information whatsoever. 

If, however, you construct your parser in a generic `MonadParsec` fashion, 
then with the help of `Text.Megaparsec.Simple.tryFast` 
you can first attempt to specialize and run the fast parser 
supplied by this package and only on parse error specialize 
the parser to `ParsecT` and parse again, yielding an informative 
error message.  
This buys you speed in the smooth case of successful parsing 
at the cost of double parse when something goes wrong. 

Beware that the behaviour of a `SimpleParser` can differ from its `Parsec` sibling 
because 

 * `SimpleParser` is always backtracking since it does not know whether it has consumed tokens,
 * any fancy parsing that relies on inspecting parser state components such as offset will not work as intended.

