## [_Unreleased_](https://github.com/freckle/freckle-app/compare/freckle-app-v1.24.0.0...main)

## [v1.24.0.0](https://github.com/freckle/freckle-app/compare/freckle-app-v1.23.3.0...freckle-app-v1.24.0.0)

- Update `HttpCache.set` to accept TTL (and use it in memcached implementation)

## [v1.23.3.0](https://github.com/freckle/freckle-app/compare/freckle-app-v1.23.2.0...freckle-app-v1.23.3.0)

- Add to `Freckle.App.Test`: `withFailureDetail`
- Add to `Freckle.App.Test.Yesod`: `statusIs2xx`

## [v1.23.2.0](https://github.com/freckle/freckle-app/compare/freckle-app-v1.23.1.0...freckle-app-v1.23.2.0)

- Add to `Freckle.App.Test`: `expectJust`, `expectRight`, and `expect`

## [v1.23.1.0](https://github.com/freckle/freckle-app/compare/freckle-app-v1.23.0.1...freckle-app-v1.23.1.0)

- Add `pooledMapConcurrently` et-al to `Freckle.App.Async`

## [v1.23.0.1](https://github.com/freckle/freckle-app/compare/freckle-app-v1.23.0.0...freckle-app-v1.23.0.1)

Add more thread context preserving combinators to `Freckle.App.Async`

## [v1.23.0.0](https://github.com/freckle/freckle-app/compare/freckle-app-v1.22.0.0...freckle-app-v1.23.0.0)

Removes `Freckle.App.HttpSpec` which had been included by mistake.

## [v1.22.0.0](https://github.com/freckle/freckle-app/compare/freckle-app-v1.21.0.0...freckle-app-v1.22.0.0)

`Freckle.App.Stats` has moved to a separate package `freckle-stats`.

When migrating to `freckle-stats`, note that the instance

```hs
instance HasStatsClient site => HasStatsClient (HandlerData child site) where
  statsClientL = envL . siteL . statsClientL
```

has been removed. If you are using Yesod, you may need to copy this definition
into your own code.

`Freckle.App.Ecs` has moved to a separate package `freckle-ecs`.

## [v1.21.0.0](https://github.com/freckle/freckle-app/compare/freckle-app-v1.20.3.0...freckle-app-v1.21.0.0)

The following have moved from `Freckle.App.Database` to a new package, `persistent-sql-lifted`:

- `MonadSqlTx (..)`
- `HasSqlBackend (..)`
- `MonadSqlBackend (..)`
- `liftSql`

The definitions in `freckle-app` have been replaced with reëxports,
so no code needs to change for users, except that a dependency on
the `persistent-sql-lifted` package is now required.

## [v1.20.3.0](https://github.com/freckle/freckle-app/compare/freckle-app-v1.20.2.1...freckle-app-v1.20.3.0)

Add `Freckle.App.TextualEnum`

## [v1.20.2.1](https://github.com/freckle/freckle-app/compare/freckle-app-v1.20.2.0...freckle-app-v1.20.2.1)

Adds an OpenTelemetry span called "runSqlPool" within each "runDB" span.

- `runDB` covers the entire action, from the time it requests a connection
  from the pool to the time it returns the connection to the pool.
- The new `runSqlPool` span covers the actions taken while _holding_ a
  connection. This span doesn't start until a connection is obtained.

This makes the trace more explicitly reflect situations where a thread was
blocked by an exhausted connection pool.

## [v1.20.2.0](https://github.com/freckle/freckle-app/compare/freckle-app-v1.20.1.2...freckle-app-v1.20.2.0)

- Add `Freckle.App.Test.Hspec.AnnotatedException.annotateHUnitFailure`
- Improve quality of exceptions rethrown by `unwrapAnnotatedHUnitFailure`.
  Previously any `Annotation`s were discarded. Now they are incorporated into
  the `HUnitFailure`, including pretty-printing of a call stack if present.

## [v1.20.1.1](https://github.com/freckle/freckle-app/compare/freckle-app-v1.20.1.1...freckle-app-v1.20.1.2)

Improve quality of error message output from `getJsonBody` and `getCsvBody`
in `Freckle.App.Test.Yesod`.

## [v1.20.1.1](https://github.com/freckle/freckle-app/compare/freckle-app-v1.20.1.0...freckle-app-v1.20.1.1)

In `Freckle.App.Test.Yesod`, exceptions thrown by `getRawBody`, `getJsonBody`,
and `getCsvBody` are now `HUnitFailure` (what you would normally expect when a
test assertion fails) rather than `IOException`.

## [v1.20.1.0](https://github.com/freckle/freckle-app/compare/freckle-app-v1.20.0.1...freckle-app-v1.20.1.0)

Modules moving between packages:

- `Freckle.App.Prelude` has moved to the `freckle-prelude` package
- `Freckle.App.Exception(.*)` has moved to the `freckle-exception` package
- All moved modules are re-exported from `freckle-app`.

Added `Freckle.App.Test.Hspec.AnnotatedException` (`unwrapAnnotatedHUnitFailure`).
It is recommended that all hspec test suites for packages that use `freckle-prelude`
add this spec hook.

## [v1.20.0.1](https://github.com/freckle/freckle-app/compare/freckle-app-v1.20.0.0...freckle-app-v1.20.0.1)

- Upgrade `Blammo` to 2.1

## [v1.20.0.0](https://github.com/freckle/freckle-app/compare/freckle-app-v1.19.0.0...freckle-app-v1.20.0.0)

Changes affecting users:

- Removed `Freckle.App.Memcached(.*)`; these modules have moved into the
  `freckle-memcached` package.

Changes that do not have to affect users:

- Modules `Freckle.App(.Test?).Http(.*)` are now re-exports from the
  `freckle-http` package.
- Modules `Freckle.App.OpenTelementry(.*)` are now re-exports from the
  `freckle-otel` package.
- Module `Freckle.App.Dotenv` is now a re-export from the `freckle-env`
  package.

## [v1.19.0.0](https://github.com/freckle/freckle-app/compare/freckle-app-v1.18.2.0...freckle-app-v1.19.0.0)

- Removed `Freckle.App.Kafka(.*)`; this is now available from the `freckle-kafka`
  package. If you are using `freckle-app` but not Kafka, you no longer need
  to also install the native Kafka library to build `freckle-app`. Please see
  opening the change log entry in `freckle-kafka` for notes on how to upgrade.
- `Freckle.App.Env` is now a re-export from the new `freckle-env` package.
  Its API has not changed.

## [v1.18.2.0](https://github.com/freckle/freckle-app/compare/v1.18.1.0...freckle-app-v1.18.2.0)

- Add `Freckle.App.Test.Properties.PersistValue` (`prop_roundTripPersistValue`)
- Support and require `Blammo` `>= 2` to accommodate the extraction of the
  `Blammo-wai` package

## [v1.18.1.0](https://github.com/freckle/freckle-app/compare/v1.18.0.0...v1.18.1.0)

- Add `Freckle.App.Http (setRequestMethod)`
- Add `Freckle.App.Async` (`foldConcurrently`, `ThreadContext (..)`,
  `getThreadContext`, `withThreadContext`)
- Bugfix: Utilities in `Freckle.App.Async` now preserve OpenTelemetry context
  (previously were only passing along Blammo logging context)

## [v1.18.0.0](https://github.com/freckle/freckle-app/compare/v1.17.1.0...v1.18.0.0)

- Drop deprecated hs-opentelemetry-datadog functionality
- Remove AWS XRay module

## [v1.17.1.0](https://github.com/freckle/freckle-app/compare/v1.17.0.0...v1.17.1.0)

- Support (and require) `hw-kafka-client` `>= 5`

## [v1.17.0.0](https://github.com/freckle/freckle-app/compare/v1.16.0.0...v1.17.0.0)

- Require Blammo 1.2
- Remove `LoggingT` from the definitions of `AppT` and `AppExample`
- Users are advised to use the new `withLogger` utility available as of Blammo 1.2
  to intialize an application's logger. In places other than the top level of an
  application, most uses of `runLoggerLoggingT` should be replaced with
  `runWithLogger` or `runAppT`.
- Add instance `MonadTrans AppT`

## [v1.16.0.0](https://github.com/freckle/freckle-app/compare/v1.15.5.0...v1.16.0.0)

- Add tracing to HTTP requests made within `AppT`

  This is a potentially breaking change for users of `AppT app` because it now
  requires `HasTracer app`. This instance most likely already exists, since it's
  required to use `runDB` too.

## [v1.15.5.0](https://github.com/freckle/freckle-app/compare/v1.15.4.0...v1.15.5.0)

- Add `Freckle.App.OpenTelemetry.Context` with helpers for propagating trace
  context across services.

## [v1.15.4.0](https://github.com/freckle/freckle-app/compare/v1.15.3.0...v1.15.4.0)

- Add `addThreadContextFromTracing` and deprecate existing middleware

  Migrating away from the deprecated middleware would look like:

  ```diff
  - import Network.Wai.Middleware.OpenTelemetry (newOpenTelemetryWaiMiddleware)
  + import Freckle.App.Wai (addThreadContextFromTracing)
  + import OpenTelemetry.Instrumentation.Wai (newOpenTelemetryWaiMiddleware)

    traceMiddleware <- newOpenTelemetryWaiMiddleware

    run 3000
      . traceMiddleware
  +   . addThreadContextFromTracing
      . ...
      $ app
  ```

- Add `withTraceContext` and deprecate existing datadog-specific functions

## [v1.15.3.0](https://github.com/freckle/freckle-app/compare/v1.15.2.0...v1.15.3.0)

- Add `Freckle.App.OpenTelemetry.addCurrentSpanAttributes`

## [v1.15.2.0](https://github.com/freckle/freckle-app/compare/v1.15.1.0...v1.15.2.0)

- Add `FaktoryProducerPool` and `HasFaktoryProducerPool` for pooling connections to Faktory

## [v1.15.1.0](https://github.com/freckle/freckle-app/compare/v1.15.0.1...v1.15.1.0)

- Add `Freckle.App.Http.Cache`
- Add `disableRequestDecompress`

## [v1.15.0.1](https://github.com/freckle/freckle-app/compare/v1.15.0.0...v1.15.0.1)

- Set `service.name` when tracing Database, Memcached, and Kafka functions.

## [v1.15.0.0](https://github.com/freckle/freckle-app/compare/v1.14.0.0...v1.15.0.0)

- Support `aeson-2.2`
- Support `http-client-0.7.16`

- Drop support for GHC < 9.2, add CI for GHC 9.8

  **BREAKING**. Things may still compile, but we've stopped testing with
  resolvers lower than `lts-20`. Accordingly, `CPP` branches supporting
  dependencies from below that resolver were also removed, and the following
  minimum bounds were raised:

  - `aeson > 2.0`
  - `dotenv > 0.10`
  - `envparse > 0.5`
  - `http-link-header >1.2`
  - `mecache > 0.3.0`
  - `template-haskell > 2.18.0`

- Introduce `MonadHttp`

  **BREAKING**. `Freckle.App.Http` now uses a custom `MonadHttp` class instead
  of `MonadIO`. This allows customizing the behavior of HTTP centrally for your
  entire application stack, including stubbing HTTP requests in tests.

  An `IO` instance exists, so users can either add:

  ```hs
  instance MonadHttp AppM where
    httpLbs = liftIO httpLbs
  ```

  Or replace call-sites,

  ```diff
  - resp <- httpLbs req
  + resp <- liftIO $ httpLbs req
  ```

  To maintain behavior across this upgrade.

## [v1.14.0.0](https://github.com/freckle/freckle-app/compare/v1.13.0.1...v1.14.0.1)

- Reverted changes for explicit offset committing in `runConsumer` back to the auto-commit strategy [breaking]

## [v1.13.0.1](https://github.com/freckle/freckle-app/compare/v1.13.0.0...v1.13.0.1)

- Fixed issue with `runConsumer` synchronously committing offsets after every event

## [v1.13.0.0](https://github.com/freckle/freckle-app/compare/v1.12.0.1...v1.13.0.0)

- Handle committing offsets more intelligently in `Kafka.Consumer` [breaking]

  The autocommit configuration and behavior was removed. Instead, we store and
  commit offsets explicitly such that at-least-once processing is ensured and
  duplicate processing (during deploy scaling) is minimized.

- Add `Freckle.App.Json.Empty` with the `Empty` type.
- Expose data constructors for `Freckle.App.Memcached.Client.MemcachedClient`.

## [v1.12.0.1](https://github.com/freckle/freckle-app/compare/v1.12.0.0...v1.12.0.1)

- Change how `active_pool_connections` metric is calculated.
- Add `queries_enqueued_and_processing` metric.

## [v1.12.0.0](https://github.com/freckle/freckle-app/compare/v1.11.0.0...v1.12.0.0)

- Support `bugsnag-1.1` which now handles `AnnotatedException` well, so we've now
  removed some `BeforeNotify` handlers from this package that are no longer needed.
- Removed `Freckle.App.Bugsnag.MetaData.metaDataAnnotationsBeforeNotify`; what it
  did is now redundant to the default behavior of the `bugsnag` library.
- Removed module `Freckle.App.Bugsnag.CallStack`; what it provided is now redundant
  to the default behavior of the `bugsnag` library.

## [v1.11.0.0](https://github.com/freckle/freckle-app/compare/v1.10.8.0...v1.11.0.0)

- Add `MonadUnliftIO` superclass to `MonadSqlBackend`
- Use `checkpointCallStack` in `liftSql` to help grab more stack frames

## [v1.10.8.0](https://github.com/freckle/freckle-app/compare/v1.10.7.0...v1.10.8.0)

- Reduce logged caching errors to `WARN` and add `error.stack` to them
- Add `Freckle.App.Exception` with `annotatedExceptionMessage` helpers
- Use `withFrozenCallStack` on more exception utilities to reduce noise in call stacks

## [v1.10.7.0](https://github.com/freckle/freckle-app/compare/v1.10.6.0...v1.10.7.0)

- Any Bugsnag `MetaData` in an `AnnotatedException`'s annotations will now be copied
  into the Bugsnag event. This means you can use the `checkpoint` function to add
  context to an action, and this information will be visible in the bug report for
  any unhandled exception thrown from that action.

  e.g. `checkpoint (metaData "tab name" ["key" .= _value]) $ _action`

## [v1.10.6.0](https://github.com/freckle/freckle-app/compare/v1.10.5.0...v1.10.6.0)

- The Bugsnag settings created by `envParseBugsnagSettings` now has a `BeforeNotify`
  that appropriately handles `AnnotatedException`. Its special handling of `SqlError`
  and `HttpException` now works in the presence of annotations. If a `CallStack`
  annotation is present, that will be used as the stacktrace for reported events.

## [v1.10.5.1](https://github.com/freckle/freckle-app/compare/v1.10.5.0...v1.10.5.1)

- Fix decoding bug when caching non-UTF-8 values

## [v1.10.5.0](https://github.com/freckle/freckle-app/compare/v1.10.4.0...v1.10.5.0)

- Add `Freckle.App.Exception...` modules with exception utilities based on the
  `annotated-exception` package.

- The Prelude module is expanded to reexport from `Freckle.App.Exception.MonadUnliftIO`
  the following: `throwM`, `throwString`, `fromJustNoteM`, `catch`, `catchJust`,
  `catches`, `try`, `tryJust`, `impossible`, `ExceptionHandler`, `Exception`,
  `SomeException`. These should be used in place of their relevant counterparts from
  packages `base`, `exceptions`, `safe-exceptions`, or `unliftio`.

- Add `Freckle.App.Random`

## [v1.10.4.0](https://github.com/freckle/freckle-app/compare/v1.10.3.0...v1.10.4.0)

- Use JUnit formatting for test output when `JUNIT_ENABLED` environment
  variable is set.
- Use environment variables to [configure JUnit][junit-env]; always prefix
  source paths with test suite `name` and output tests to `/tmp/junit`.
- Remove using `CIRCLECI` environment variable.

[junit-env]: https://github.com/freckle/hspec-junit-formatter/blob/main/library/Test/Hspec/JUnit/Config/Env.hs

## [v1.10.3.0](https://github.com/freckle/freckle-app/compare/v1.10.2.0...v1.10.3.0)

- Add classes `MonadSqlBackend` and `MonadSqlTx` for being quite nonspecific about the
  context in which you interact with a SQL database.

## [v1.10.2.0](https://github.com/freckle/freckle-app/compare/v1.10.1.0...v1.10.2.0)

- Add module `Freckle.App.Memcached.MD5`
- Add `fiveMinuteTTL` to module `Freckle.App.Memcached.CacheTTL`
- Add `cachingAsCBOR` to module `Freckle.App.Memcached`

## [v1.10.1.1](https://github.com/freckle/freckle-app/compare/v1.10.0.0...v1.10.1.0)

- Use `withTraceIdContext` in `Freckle.App.Kafka.Consumer.runConsumer`, ensuring
  all logging contains the `trace_id` in context.
- Add `getCurrentTraceIdAsDatadog` and `withTraceIdContext` to
  `Freckle.App.OpenTelemetry`.

## [v1.10.0.0](https://github.com/freckle/freckle-app/compare/v1.9.5.1...v1.10.0.0)

- Full support for OpenTelemetry tracing, use it instead of XRay in `runDB`

  This replaces our bespoke, XRay-based `MonadTracer` class to be that of
  `hs-opentelemetry.` This means `Freckle.App.Database.runDB` now traces using
  OpenTelemetry instead of XRay. A compilation error will indicate a missing
  `HasTracer` instance, which you should implement based on the
  `Freckle.App.OpenTelemetry` module documentation.

  Clients who wish to remain on XRay can still upgrade, but must adjust their
  imports so they use `Freckle.App.Database.XRay`, not `Freckle.App.Database`.

## [v1.9.5.1](https://github.com/freckle/freckle-app/compare/v1.9.5.0...v1.9.5.1)

- Fixed mistake in `Freckle.App.Test.Yesod.getResponse` producing nontermination

## [v1.9.5.0](https://github.com/freckle/freckle-app/compare/v1.9.4.0...v1.9.5.0)

- Add module `Freckle.App.Test.Yesod`

## [v1.9.4.0](https://github.com/freckle/freckle-app/compare/v1.9.3.0...v1.9.4.0)

- Add `Freckle.App.Async` (primarily) for correctly managing thread context when
  spawning new threads.

## [v1.9.3.0](https://github.com/freckle/freckle-app/compare/v1.9.2.1...v1.9.3.0)

- Auto-commit offset when consuming Kafka events.

## [v1.9.2.1](https://github.com/freckle/freckle-app/compare/v1.9.2.0...v1.9.2.1)

- Fixed segfault bug in `Freckle.App.Kafka.Consumer`.

## [v1.9.2.0](https://github.com/freckle/freckle-app/compare/v1.9.1.1...v1.9.2.0)

- Add `Freckle.App.Kafka.Consumer` for consuming Kafka events.
- Move producer to `Freckle.App.Kafka.Producer`.
- Re-export both modules in `Freckle.App.Kafka`.

## [v1.9.1.1](https://github.com/freckle/freckle-app/compare/v1.9.1.0...v1.9.1.1)

- Add `KafkaProducerPoolConfig` for controlling Kafka producer pool parameters

## [v1.9.1.0](https://github.com/freckle/freckle-app/compare/v1.9.0.3...v1.9.1.0)

- Add `Freckle.App.Kafka` for producing kafka events

## [v1.9.0.3](https://github.com/freckle/freckle-app/compare/v1.9.0.2...v1.9.0.3)

- Use option `PGSCHEMA` environment variable to set schema at connection start.

## [v1.9.0.2](https://github.com/freckle/freckle-app/compare/v1.9.0.1...v1.9.0.2)

- Fix for not setting ECS Metadata tags in `StatsClient`

## [v1.9.0.1](https://github.com/freckle/freckle-app/compare/v1.9.0.0...v1.9.0.1)

- Report errors getting ECS Metadata during `withStatsClient` initialization

  This does change the type of `getEcsMetadata`, but we consider it a
  patch-level bump because that module is very unlikely to be used directly.

## [v1.9.0.0](https://github.com/freckle/freckle-app/compare/v1.8.1.0...v1.9.0.0)

- Refactor `Freckle.App.Wai` interface
- Add `addThreadContextFromStatsTags`
- Replace `HasXRayVaultData` with `MonadTracer`
- Introduce `AppT`

## [v1.8.1.0](https://github.com/freckle/freckle-app/compare/v1.8.0.0...v1.8.1.0)

- Add `runDBSimple` for use cases where instrumentation is not valuable.

## [v1.8.0.0](https://github.com/freckle/freckle-app/compare/v1.7.1.0...v1.8.0.0)

- Fix bug: gauges not being published.
- Add HasVaultData type class to remove the dependency on Yesod's MonadHandler

## [v1.7.1.0](https://github.com/freckle/freckle-app/compare/v1.7.0.0...v1.7.1.0)

- Add Incremental CSV parsing

## [v1.7.0.0](https://github.com/freckle/freckle-app/compare/v1.6.0.3...v1.7.0.0)

- Add XRay and EKG support to freckle-app's runDB.

  This involves an breaking change in `runDB`'s constraints, thus the major version
  bump.

## [v1.6.0.3](https://github.com/freckle/freckle-app/compare/v1.6.0.2...v1.6.0.3)

- Revert regrouping of `SqlError` by `url`

  Consider `/foos/1` vs `/foos/2`: grouping naively by `url` makes these two
  errors when we wanted them to be one. This can't be solved without knowledge
  of the routing system, so we can't do it from within this library as-is.
  Therefore, we've reverted the feature for now.

## [v1.6.0.2](https://github.com/freckle/freckle-app/compare/v1.6.0.1...v1.6.0.2)

- Strip query string from URLs used to group timeout exceptions in Bugsnag.

## [v1.6.0.1](https://github.com/freckle/freckle-app/compare/v1.6.0.0...v1.6.0.1)

- The built-in Bugsnag `BeforeNotify` will further group `SqlError`s that are
  timeouts (57014) by Request URL (when request info is present in the `Event`)

## [v1.6.0.0](https://github.com/freckle/freckle-app/compare/v1.5.0.1...v1.6.0.0)

- Remove `AppVersion`

  This also removes the `test-git` flag.

  This was over-engineered, in our opinion. If you're making use of the
  conventional `DD_` variables that the `Stats` module expects, you should be
  able to:

  - Replace any `appVersion :: AppVersion` with `appVersion :: Text`
  - Replace `appVersion <- getAppVersion` with `appVersion <- maybe "unknown" pack <$> lookupEnv "DD_VERSION"`
  - Replace `avName appVersion` with `appVersion`
  - Remove uses of `avCreatedAt`

- Add `Freckle.App.Dotenv`, wrapping [`dotenv`](https://hackage.haskell.org/package/dotenv)

  And move `Freckle.App.Test.withApp` to use it instead of `LoadEnv`. This is
  behavior-neutral except:

  - We no longer load `.env` after `.env.test`, we only load `.env.test`

    Missing variables should generate errors prompting you to copy values from
    the former to the latter as required.

  - We will verify the `.env` file against an `.env.example` if present.

- Add `Freckle.App.Bugsnag.Metadata`

## [v1.5.0.1](https://github.com/freckle/freckle-app/compare/v1.5.0.1...v1.5.1.0)

- Export `Freckle.App.Stats.tagsL`

## [v1.5.0.1](https://github.com/freckle/freckle-app/compare/v1.5.0.0...v1.5.0.1)

- Relax lower bound on `primitive`

## [v1.5.0.0](https://github.com/freckle/freckle-app/compare/v1.4.0.0...v1.5.0.0)

- Remove `Freckle.App.Datadog` modules for `Freckle.App.Stats` equivalents

  It's not a drop-in, but the required changes should be mechanical:

  - Instead of `HasDogStats{Client,Tags}`, implement a single `HasStatsClient`
  - Instead of `mkStatsClient` use `withStatsClient` (the new style of `runApp`
    had will enable that)
  - Use `tagged` instead of extra arguments to metric sends
  - Move to the new `Rts`, `Gauge`, and `Middleware.Stats` modules

- Change signature of `runApp` and `withApp`

  Instead of passing a loaded `App` (or a function that loads an `App`) to
  `runApp` and `withApp`, you should now pass a function that _takes a function_
  and calls it on the loaded `App`.

  This is necessary for apps that hold onto values that require cleanup, like
  `withStatsClient`.

  ```hs
  -- This doesn't work
  loadApp :: IO App
  loadApp = do
    -- ...
    withStatsClient $ \appStatsClient -> do
      -- ???

  -- This does
  loadApp :: (App -> IO a) -> IO a
  loadApp f = do
    -- ...
    withStatsClient $ \appStatsClient -> do
      f App { .. }
  ```

  The old form can be trivially converted to the new form like so,

  ```hs
  loadApp :: (App -> IO a) -> IO a
  loadApp f = f =<< loadApp'

  loadApp' :: IO App
  loadApp' = -- old code
  ```

- Add functions that check properties that we like to commonly test.

## [v1.4.0.0](https://github.com/freckle/freckle-app/compare/v1.3.0.0...v1.4.0.0)

- Remove `runCapturedLoggingT`

  We can use `Blammo.Logging.Logger.newTestLogger` instead. See `MemcachedSpec`
  as an example.

- Compatibility down to LTS 12.26 / GHC 8.4

## [v1.3.0.0](https://github.com/freckle/freckle-app/compare/v1.2.0.2...v1.3.0.0)

- Adjust `Freckle.App.Test` interface
  - Remove `runAppTest`
  - Add `appExample` for making a expectation concretely `AppExample`
  - Add `expectationFailure`, and `pending(With)` helpers in `MonadIO`

## [v1.2.0.2](https://github.com/freckle/freckle-app/compare/v1.2.0.1...v1.2.0.2)

- `Env.kept` compatibility with envparse-0.5

## [v1.2.0.1](https://github.com/freckle/freckle-app/compare/v1.2.0.0...v1.2.0.1)

- Use `Env.kept` with parsing that occurs in `makePostgresPool`

  This ensure all `PG` variables are kept in the environment after parsing, to
  again match pre-v1.1 behavior.

  If you would prefer not to keep these variables, parse them yourself (e.g.
  with `envParseDatabaseConf`) and use `makePostgresPoolWith`.

- Add `Freckle.App.Env.kept` to re-define a `Parser` so that all variables are
  kept after reading. Not doing this can break tests if you are re-parsing the
  environment for each example.

  Replace `Env.parse f` with `Env.parse f $ Env.kept` to recover how this module
  behaved prior to v1.1.

## [v1.2.0.0](https://github.com/freckle/freckle-app/compare/v1.1.0.0...v1.2.0.0)

- Remove `Freckle.App.Logging`, integrate with [blammo][] instead.

  This will require the following end-user changes:

  - Remove `HasLogging` instance and add `HasLogger`

    This will require storing a `Logger` on your runtime `App` type, instead of
    a `LogLevel` (et al) in your static `AppSettings` type. (Or move to
    `runSimpleLoggingT`.)

  - Replace WAI middleware with [Blammo integration][blammo-wai]

  - Replace Yesod functions with [Blammo integration][blammo-yesod]

  And changes to environment variable values:

  - If using `LOG_OUTPUT=std(out|err)`, use `LOG_DESTINATION=std(out|err)` (note
    that `stdout` is the default)
  - If using `LOG_OUTPUT=file`, use `LOG_DESTINATION=@fancy.log` (yes, that's
    this option did)
  - If using `LOG_FORMAT=terminal`, use `LOG_FORMAT=tty` (note that this is the
    defualt)

[blammo]: https://hackage.haskell.org/package/Blammo
[blammo-wai]: https://github.com/freckle/blammo/#integration-with-wai
[blammo-yesode]: https://github.com/freckle/blammo/#integration-with-yesod

## [v1.1.0.0](https://github.com/freckle/freckle-app/compare/v1.0.4.0...v1.1.0.0)

- Require `MonadLoggerIO` in `makePostgresPool` (and so respect that logging
  context from DB activities).

  Previous behavior can be recovered by using `runNoLoggingT makePostgresPool`.

- Re-implement `FronRow.App.Env` via external library, `envparse`

  Some conversions will be required:

  - `Reader a` should now be `Reader Error a`
  - `Parser a` should now be `Parser Error a`
  - `parse` should now be `parse id`
  - `var x X nonEmpty` should now be `var (x <=< nonempty) X mempty`

    Note that `(str <=< nonempty)` is redundant.

  - `var (f <$> g) X m` should now be `f <$> var g X m`

    Note that `def` will now need a value the same type as `g`, not `f`.

  - `switch` and `flag` no longer accept `def` (the non-active value is an
    implicit default; the previous behavior was kind of surprising and
    ambiguous).

  - `handleEither` has been removed. Users will have to parse a complete value
    and then further validate/throw externally.

  - Previously, we always behaved as if `keep` was applied. Add that explicitly
    if you need that behavior.

## [v1.0.4.0](https://github.com/freckle/freckle-app/compare/v1.0.3.0...v1.0.4.0)

- Add `Freckle.App.Bugsnag` for Bugsnag logging in applications.
- Increased default PG poolsize to 10.

## [v1.0.3.0](https://github.com/freckle/freckle-app/compare/v1.0.2.10...v1.0.3.0)

- Add `Freckle.App.Memcache` for using memcached in Apps
- Add `Freckle.App.Scientist` for using [scientist][] in Apps

  [scientist]: https://github.com/freckle/scientist-hs#readme

## [v1.0.2.10](https://github.com/freckle/freckle-app/compare/v1.0.2.9...v1.0.2.10)

- Support GHC 9.0 and 9.2

- Change `Wai` function arguments for producing `RouteName` and `TraceId` to
  tags

  To maintain the same behavior, replace

  ```hs
  makeLoggingMiddleware app getRouteName getTraceId ...
  ```

  With

  ```hs
  makeLoggingMiddleware app getTags ...
    where
      getTags req = catMaybes
        [ ("route", ) <$> getRouteName req
        , ("trace_id", ) <$> getTraceId req
        ]
  ```

  And similar for `makeRequestMetricsMiddleware`.

## [v1.0.2.9](https://github.com/freckle/freckle-app/compare/v1.0.2.8...v1.0.2.9)

- Add some common textual encoding functions to prelude

## [v1.0.2.8](https://github.com/freckle/freckle-app/compare/v1.0.2.7...v1.0.2.8)

- Don't allow `aeson-2.0`

## [v1.0.2.7](https://github.com/freckle/freckle-app/compare/v1.0.2.6...v1.0.2.7)

- Remove explicit `--region` in IAM DB token call
- Relax lower-bounds throughout

## [v1.0.2.6](https://github.com/freckle/freckle-app/compare/v1.0.2.5...v1.0.2.6)

- Add a looser lower-bound on `containers`

## [v1.0.2.5](https://github.com/freckle/freckle-app/compare/v1.0.2.4...v1.0.2.5)

- Add a looser lower-bound on `bytestring`
- Add a looser lower-bound on `template-haskell`

## [v1.0.2.4](https://github.com/freckle/freckle-app/compare/v1.0.2.3...v1.0.2.4)

- Add a looser lower-bound on `base`

## [v1.0.2.3](https://github.com/freckle/freckle-app/compare/v1.0.2.2...v1.0.2.3)

- Add Freckle-specific prelude.

## [v1.0.2.2](https://github.com/freckle/freckle-app/compare/v1.0.2.1...v1.0.2.2)

- Target `hspec-junit-formatter-1.0.3.0` (use `1.1.0.0` in development)

## [v1.0.2.1](https://github.com/freckle/freckle-app/compare/v1.0.2.0...v1.0.2.1)

- Add `denyFrameEmbeddingMiddleware` for denying HTML frame embedding.

## [v1.0.2.0](https://github.com/freckle/freckle-app/compare/v1.0.1.0...v1.0.2.0)

- Add 'Freckle.App.Yesod.Route' to allow printing route names.

## [v1.0.1.0](https://github.com/freckle/freckle-app/compare/v1.0.0.4...v1.0.1.0)

- Added `Freckle.App.Datadog.Gauge` for client side stateful gauges.
- Added `Freckle.App.Datadog.Rts` for sending RTS statistics to DataDog.

## [v1.0.0.4](https://github.com/freckle/freckle-app/compare/v1.0.0.3...v1.0.0.4)

- Support seconds or milliseconds in `PGSTATEMENTTIMEOUT`

  NOTE: We consider this a non-breaking change because the environment variable
  interface is backwards-compatible. By normal Haskell rules, it would be major
  since it's changing the type of something exported.

- Add `respondQueryCanceled` Yesod Middlewares

- Add `makeRequestMetricsMiddleware`

## [v1.0.0.3](https://github.com/freckle/freckle-app/compare/v1.0.0.2...v1.0.0.3)

- Add `package.yaml` to `extra-source-files`.

## [v1.0.0.2](https://github.com/freckle/freckle-app/compare/v1.0.0.1...v1.0.0.2)

- Extract tests that require `git` into a new suite.

## [v1.0.0.1](https://github.com/freckle/freckle-app/compare/v1.0.0.0...v1.0.0.1)

- Ensure `release` GitHub Action completes properly.

## [v1.0.0.0](https://github.com/freckle/freckle-app/tree/v1.0.0.0)

First tagged release.
