# from

Note that this package is a part of the "project" that includes from and from-string. For the general rationale behind this idea, see `README.md` under the project root.

This Haskell library package provides the `From` and `TryFrom` typeclasses.

The `From` typeclass provides `from :: a -> b`. It is an interface for types that can be converted from/to each other.

The `TryFrom` typeclass provides `tryFrom :: a -> Maybe b`. It is an interface for types that can be converted from/to each other, with the possibility of a failure.

This package has **1** dependency: base.

## Instances

It is well known that it is difficult to "selectively" import/export typeclass instances. Therefore, we need to be careful about what instances to provide by default.

There are base functions, some of them even in `Prelude`, that basically serve as a less general version of `from`. Examples include `fromIntegral` and `fromEnum`. However, naively defining `instance (Integral a, Num b) => From a b` and `instance (Enum a) => From a Int` will quickly lead us to trouble:

```
    • Overlapping instances for From Int16 Int
        arising from a use of ‘from’
      Matching instances:
        instance (Integral a, Num b) => From a b
        instance Enum a => From a Int
      ...
```

Therefore, this package does not provide such "contextual" instances. (Of course, you may define them in your application project, if you want.)

Instead, concrete instances are provided. For example, all pairs (excluding self to self) of these integral types are instantiated using `fromIntegral`:

- `Int`
- `Integer`
- `Int8`
- `Int16`
- `Int32`
- `Int64`
- `Word8`
- `Word16`
- `Word32`
- `Word64`

Each type can be both source and destination of `from`. Additional types are instantiated as destination-only:

- `Float`
- `Double`
