-- |
-- Module      :  From
-- Copyright   :  (C) 2024-2025 XT et al.
-- License     :  Apache-2.0 (see the LICENSE file)
-- Portability :  FlexibleInstances, MultiParamTypeClasses
--
-- This module provides the 'From' and 'TryFrom' typeclasses.
--
-- The 'From.From' typeclass provides
--
-- @
-- 'From.from' :: a -> b
-- @
--
-- for types that can be converted from/to each other.
--
-- The 'From.TryFrom' typeclass provides
--
-- @
-- 'From.tryFrom' :: a -> 'Prelude.Maybe' b
-- @
--
-- for types that can be converted from/to each other, handling the possibility
-- of a failure.
--
-- == About default instances
--
-- Default 'From' instances are provided for the following types in base:
--
--   * 'Int'
--
--   * 'Integer'
--
--   * t'Data.Int.Int8'
--
--   * t'Data.Int.Int16'
--
--   * t'Data.Int.Int32'
--
--   * t'Data.Int.Int64'
--
--   * t'Data.Word.Word8'
--
--   * t'Data.Word.Word16'
--
--   * t'Data.Word.Word32'
--
--   * t'Data.Word.Word64'
--
-- Any pair of the above types (except self-self) are convertible using 'from'.
-- In addition to that, the above types can also be converted to 'Float' or
-- 'Double' using 'from'. The implementation uses 'fromIntegral'.
--
-- There are other possible default instances, like
--
-- @
-- 'Char' -> 'Int'
-- @
--
-- (using 'Data.Char.chr') or
--
-- @
-- 'Foreign.Ptr.Ptr' a -> 'Foreign.Ptr.Ptr' b
-- @
--
-- (using 'Foreign.Ptr.castPtr'), but we plan to carefully examine and discuss
-- before adding them, as it is difficult to selectively import/export
-- typeclass instances.
--
-- Separate packages will also provide useful instances, like @from-string@.
module From (
  -- ** From
  From (..),

  -- ** TryFrom
  TryFrom (..),
) where

import From.Classes
import From.Num ()
