# Changelog for `from`

All notable changes to this project should be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/), and this project adheres to the [Haskell Package Versioning Policy](https://pvp.haskell.org/).

## 1.0.0.1 - 2025-10-24

### Changed

- Split the test code into ordinary test and code generation test. The code generation test will not be run by default (by Hackage or Stackage, for example).

## 1.0.0.0 - 2025-10-24

Initial release.

### Added

- Typeclasses `From` and `TryFrom`.
- Instances of `From` for some fundamental type-mappings in `base`:
    - All types in `Data.Int` and `Data.Word` can be both the source and the destination of the conversion.
    - The types `Float` and `Double` can be the destination, but not the source. So `from :: Int32 -> Float` exists, while `from :: Float -> Int32` does not.
    - That's it. We begin with minimal instances intentionally. For example, there is no `instance From Int String`. This is because it is tricky (often impossible) to selectively import instances, especially when the module dependency graph is complicated. We'd need to be careful about adding instances.
