# from-string

Note that this package is a part of the "project" that includes from and from-string. For the general rationale behind this idea, see `README.md` under the project root.

This Haskell library package provides the `From` typeclass **instances** for the conversion of following types:

- `String`
- bytestring:
    - Strict `ByteString`
    - Lazy `ByteString`
    - `Builder` for `ByteString`
    - `ShortByteString`
- text:
    - Strict `Text`
    - Lazy `Text`
    - `Builder` for `Text`

Whenever encoding/decoding happens, this library assumes that the aforementioned types internally contains either

- a sequence of Unicode characters, or
- a sequence of bytes in UTF-8.

This should be a reasonable assumption for practical software development. If you need any other assumption, you should specify the accurate conversion in the code, instead of 'from'.

See the `From.String` module documentation for more detail.
