{- FOURMOLU_DISABLE -}
{- Make sure you edit test/Main.hs -}
{-# LANGUAGE FlexibleInstances #-}
{-# LANGUAGE MultiParamTypeClasses #-}
{-# OPTIONS_GHC -Wno-orphans #-}

module From.String.AutoGen () where

import qualified Data.ByteString as B
import qualified Data.ByteString.Builder as BB
import qualified Data.ByteString.Lazy as LB
import qualified Data.ByteString.Short as SB
import qualified Data.Text as T
import qualified Data.Text.Encoding as TE
import qualified Data.Text.Encoding.Error as TEE
import qualified Data.Text.Lazy as LT
import qualified Data.Text.Lazy.Builder as TB
import qualified Data.Text.Lazy.Encoding as LTE
import From (From (..))

-- | 'Data.Text.Encoding.encodeUtf8' '.' 'Data.Text.pack'
instance From String B.ByteString where
  from = TE.encodeUtf8 . T.pack

-- | 'Data.Text.Lazy.Encoding.encodeUtf8' '.' 'Data.Text.Lazy.pack'
instance From String LB.ByteString where
  from = LTE.encodeUtf8 . LT.pack

-- | 'Data.ByteString.Builder.stringUtf8'
instance From String BB.Builder where
  from = BB.stringUtf8

-- | 'Data.ByteString.Short.toShort' '.' 'Data.Text.Encoding.encodeUtf8' '.' 'Data.Text.pack'
instance From String SB.ShortByteString where
  from = SB.toShort . TE.encodeUtf8 . T.pack

-- | 'Data.Text.pack'
instance From String T.Text where
  from = T.pack

-- | 'Data.Text.Lazy.pack'
instance From String LT.Text where
  from = LT.pack

-- | 'Data.Text.Lazy.Builder.fromString'
instance From String TB.Builder where
  from = TB.fromString

-- | 'Data.Text.unpack' '.' 'Data.Text.Encoding.decodeUtf8Lenient'
instance From B.ByteString String where
  from = T.unpack . TE.decodeUtf8Lenient

-- | 'Data.ByteString.Lazy.fromStrict'
instance From B.ByteString LB.ByteString where
  from = LB.fromStrict

-- | 'Data.ByteString.Builder.byteString'
instance From B.ByteString BB.Builder where
  from = BB.byteString

-- | 'Data.ByteString.Short.toShort'
instance From B.ByteString SB.ShortByteString where
  from = SB.toShort

-- | 'Data.Text.Encoding.decodeUtf8Lenient'
instance From B.ByteString T.Text where
  from = TE.decodeUtf8Lenient

-- | 'Data.Text.Lazy.Encoding.decodeUtf8With' 'Data.Text.Encoding.Error.lenientDecode' '.' 'Data.ByteString.Lazy.fromStrict'
instance From B.ByteString LT.Text where
  from = LTE.decodeUtf8With TEE.lenientDecode . LB.fromStrict

-- | 'Data.Text.Lazy.Builder.fromText' '.' 'Data.Text.Encoding.decodeUtf8Lenient'
instance From B.ByteString TB.Builder where
  from = TB.fromText . TE.decodeUtf8Lenient

-- | 'Data.Text.Lazy.unpack' '.' 'Data.Text.Lazy.Encoding.decodeUtf8With' 'Data.Text.Encoding.Error.lenientDecode'
instance From LB.ByteString String where
  from = LT.unpack . LTE.decodeUtf8With TEE.lenientDecode

-- | 'Data.ByteString.Lazy.toStrict'
instance From LB.ByteString B.ByteString where
  from = LB.toStrict

-- | 'Data.ByteString.Builder.lazyByteString'
instance From LB.ByteString BB.Builder where
  from = BB.lazyByteString

-- | 'Data.ByteString.Short.toShort' '.' 'Data.ByteString.Lazy.toStrict'
instance From LB.ByteString SB.ShortByteString where
  from = SB.toShort . LB.toStrict

-- | 'Data.Text.Encoding.decodeUtf8Lenient' '.' 'Data.ByteString.Lazy.toStrict'
instance From LB.ByteString T.Text where
  from = TE.decodeUtf8Lenient . LB.toStrict

-- | 'Data.Text.Lazy.Encoding.decodeUtf8With' 'Data.Text.Encoding.Error.lenientDecode'
instance From LB.ByteString LT.Text where
  from = LTE.decodeUtf8With TEE.lenientDecode

-- | 'Data.Text.Lazy.Builder.fromLazyText' '.' 'Data.Text.Lazy.Encoding.decodeUtf8With' 'Data.Text.Encoding.Error.lenientDecode'
instance From LB.ByteString TB.Builder where
  from = TB.fromLazyText . LTE.decodeUtf8With TEE.lenientDecode

-- | 'Data.Text.Lazy.unpack' '.' 'Data.Text.Lazy.Encoding.decodeUtf8With' 'Data.Text.Encoding.Error.lenientDecode' '.' 'Data.ByteString.Builder.toLazyByteString'
instance From BB.Builder String where
  from = LT.unpack . LTE.decodeUtf8With TEE.lenientDecode . BB.toLazyByteString

-- | 'Data.ByteString.Lazy.toStrict' '.' 'Data.ByteString.Builder.toLazyByteString'
instance From BB.Builder B.ByteString where
  from = LB.toStrict . BB.toLazyByteString

-- | 'Data.ByteString.Builder.toLazyByteString'
instance From BB.Builder LB.ByteString where
  from = BB.toLazyByteString

-- | 'Data.ByteString.Short.toShort' '.' 'Data.ByteString.Lazy.toStrict' '.' 'Data.ByteString.Builder.toLazyByteString'
instance From BB.Builder SB.ShortByteString where
  from = SB.toShort . LB.toStrict . BB.toLazyByteString

-- | 'Data.Text.Encoding.decodeUtf8Lenient' '.' 'Data.ByteString.Lazy.toStrict' '.' 'Data.ByteString.Builder.toLazyByteString'
instance From BB.Builder T.Text where
  from = TE.decodeUtf8Lenient . LB.toStrict . BB.toLazyByteString

-- | 'Data.Text.Lazy.Encoding.decodeUtf8With' 'Data.Text.Encoding.Error.lenientDecode' '.' 'Data.ByteString.Builder.toLazyByteString'
instance From BB.Builder LT.Text where
  from = LTE.decodeUtf8With TEE.lenientDecode . BB.toLazyByteString

-- | 'Data.Text.Lazy.Builder.fromLazyText' '.' 'Data.Text.Lazy.Encoding.decodeUtf8With' 'Data.Text.Encoding.Error.lenientDecode' '.' 'Data.ByteString.Builder.toLazyByteString'
instance From BB.Builder TB.Builder where
  from = TB.fromLazyText . LTE.decodeUtf8With TEE.lenientDecode . BB.toLazyByteString

-- | 'Data.Text.unpack' '.' 'Data.Text.Encoding.decodeUtf8Lenient' '.' 'Data.ByteString.Short.fromShort'
instance From SB.ShortByteString String where
  from = T.unpack . TE.decodeUtf8Lenient . SB.fromShort

-- | 'Data.ByteString.Short.fromShort'
instance From SB.ShortByteString B.ByteString where
  from = SB.fromShort

-- | 'Data.ByteString.Lazy.fromStrict' '.' 'Data.ByteString.Short.fromShort'
instance From SB.ShortByteString LB.ByteString where
  from = LB.fromStrict . SB.fromShort

-- | 'Data.ByteString.Builder.shortByteString'
instance From SB.ShortByteString BB.Builder where
  from = BB.shortByteString

-- | 'Data.Text.Encoding.decodeUtf8Lenient' '.' 'Data.ByteString.Short.fromShort'
instance From SB.ShortByteString T.Text where
  from = TE.decodeUtf8Lenient . SB.fromShort

-- | 'Data.Text.Lazy.Encoding.decodeUtf8With' 'Data.Text.Encoding.Error.lenientDecode' '.' 'Data.ByteString.Lazy.fromStrict' '.' 'Data.ByteString.Short.fromShort'
instance From SB.ShortByteString LT.Text where
  from = LTE.decodeUtf8With TEE.lenientDecode . LB.fromStrict . SB.fromShort

-- | 'Data.Text.Lazy.Builder.fromText' '.' 'Data.Text.Encoding.decodeUtf8Lenient' '.' 'Data.ByteString.Short.fromShort'
instance From SB.ShortByteString TB.Builder where
  from = TB.fromText . TE.decodeUtf8Lenient . SB.fromShort

-- | 'Data.Text.unpack'
instance From T.Text String where
  from = T.unpack

-- | 'Data.Text.Encoding.encodeUtf8'
instance From T.Text B.ByteString where
  from = TE.encodeUtf8

-- | 'Data.Text.Lazy.Encoding.encodeUtf8' '.' 'Data.Text.Lazy.fromStrict'
instance From T.Text LB.ByteString where
  from = LTE.encodeUtf8 . LT.fromStrict

-- | 'Data.Text.Encoding.encodeUtf8Builder'
instance From T.Text BB.Builder where
  from = TE.encodeUtf8Builder

-- | 'Data.ByteString.Short.toShort' '.' 'Data.Text.Encoding.encodeUtf8'
instance From T.Text SB.ShortByteString where
  from = SB.toShort . TE.encodeUtf8

-- | 'Data.Text.Lazy.fromStrict'
instance From T.Text LT.Text where
  from = LT.fromStrict

-- | 'Data.Text.Lazy.Builder.fromText'
instance From T.Text TB.Builder where
  from = TB.fromText

-- | 'Data.Text.Lazy.unpack'
instance From LT.Text String where
  from = LT.unpack

-- | 'Data.ByteString.Lazy.toStrict' '.' 'Data.Text.Lazy.Encoding.encodeUtf8'
instance From LT.Text B.ByteString where
  from = LB.toStrict . LTE.encodeUtf8

-- | 'Data.Text.Lazy.Encoding.encodeUtf8'
instance From LT.Text LB.ByteString where
  from = LTE.encodeUtf8

-- | 'Data.Text.Lazy.Encoding.encodeUtf8Builder'
instance From LT.Text BB.Builder where
  from = LTE.encodeUtf8Builder

-- | 'Data.ByteString.Short.toShort' '.' 'Data.ByteString.Lazy.toStrict' '.' 'Data.Text.Lazy.Encoding.encodeUtf8'
instance From LT.Text SB.ShortByteString where
  from = SB.toShort . LB.toStrict . LTE.encodeUtf8

-- | 'Data.Text.Lazy.toStrict'
instance From LT.Text T.Text where
  from = LT.toStrict

-- | 'Data.Text.Lazy.Builder.fromLazyText'
instance From LT.Text TB.Builder where
  from = TB.fromLazyText

-- | 'Data.Text.Lazy.unpack' '.' 'Data.Text.Lazy.Builder.toLazyText'
instance From TB.Builder String where
  from = LT.unpack . TB.toLazyText

-- | 'Data.ByteString.Lazy.toStrict' '.' 'Data.Text.Lazy.Encoding.encodeUtf8' '.' 'Data.Text.Lazy.Builder.toLazyText'
instance From TB.Builder B.ByteString where
  from = LB.toStrict . LTE.encodeUtf8 . TB.toLazyText

-- | 'Data.Text.Lazy.Encoding.encodeUtf8' '.' 'Data.Text.Lazy.Builder.toLazyText'
instance From TB.Builder LB.ByteString where
  from = LTE.encodeUtf8 . TB.toLazyText

-- | 'Data.Text.Lazy.Encoding.encodeUtf8Builder' '.' 'Data.Text.Lazy.Builder.toLazyText'
instance From TB.Builder BB.Builder where
  from = LTE.encodeUtf8Builder . TB.toLazyText

-- | 'Data.ByteString.Short.toShort' '.' 'Data.ByteString.Lazy.toStrict' '.' 'Data.Text.Lazy.Encoding.encodeUtf8' '.' 'Data.Text.Lazy.Builder.toLazyText'
instance From TB.Builder SB.ShortByteString where
  from = SB.toShort . LB.toStrict . LTE.encodeUtf8 . TB.toLazyText

-- | 'Data.Text.Lazy.toStrict' '.' 'Data.Text.Lazy.Builder.toLazyText'
instance From TB.Builder T.Text where
  from = LT.toStrict . TB.toLazyText

-- | 'Data.Text.Lazy.Builder.toLazyText'
instance From TB.Builder LT.Text where
  from = TB.toLazyText
