module Main (main) where

import qualified Data.ByteString as B
import qualified Data.ByteString.Builder as BB
import qualified Data.ByteString.Lazy as LB
import qualified Data.ByteString.Short as SB
import qualified Data.Text as T
import qualified Data.Text.Lazy as LT
import qualified Data.Text.Lazy.Builder as TB
import From.String
import System.Exit

cB :: B.ByteString
cB = B.pack [0xec, 0x95, 0x88, 0xeb, 0x85, 0x95]
{-# NOINLINE cB #-}

cLB :: LB.ByteString
cLB = LB.pack [0xec, 0x95, 0x88, 0xeb, 0x85, 0x95]
{-# NOINLINE cLB #-}

cBB :: BB.Builder
cBB = BB.byteString cB
{-# NOINLINE cBB #-}

cSB :: SB.ShortByteString
cSB = SB.pack [0xec, 0x95, 0x88, 0xeb, 0x85, 0x95]
{-# NOINLINE cSB #-}

cT :: T.Text
cT = T.pack "\50504\45397"
{-# NOINLINE cT #-}

cLT :: LT.Text
cLT = LT.pack "\50504\45397"
{-# NOINLINE cLT #-}

cTB :: TB.Builder
cTB = TB.fromString "\50504\45397"
{-# NOINLINE cTB #-}

assertEq :: (Eq term) => String -> term -> term -> IO ()
assertEq comment leftTerm rightTerm
  | leftTerm == rightTerm = report
  | otherwise = report >> exitFailure
 where
  report = putStrLn comment

-- TODO: More test cases
-- NOTE: Data.ByteString.Builder.Builder does not have Eq
main :: IO ()
main = do
  assertEq " cB == from cLB" cB (from cLB)
  assertEq " cB == from cBB" cB (from cBB)
  assertEq " cB == from cSB" cB (from cSB)
  assertEq " cB == from cT" cB (from cT)
  assertEq " cB == from cLT" cB (from cLT)
  assertEq " cB == from cTB" cB (from cTB)
  assertEq "cLB == from cB" cLB (from cB)
  assertEq "cLB == from cBB" cLB (from cBB)
  assertEq "cLB == from cSB" cLB (from cSB)
  assertEq "cLB == from cT" cLB (from cT)
  assertEq "cLB == from cLT" cLB (from cLT)
  assertEq "cLB == from cTB" cLB (from cTB)
  assertEq "cSB == from cB" cSB (from cB)
  assertEq "cSB == from cLB" cSB (from cLB)
  assertEq "cSB == from cBB" cSB (from cBB)
  assertEq "cSB == from cT" cSB (from cT)
  assertEq "cSB == from cLT" cSB (from cLT)
  assertEq "cSB == from cTB" cSB (from cTB)
  assertEq " cT == from cB" cT (from cB)
  assertEq " cT == from cLB" cT (from cLB)
  assertEq " cT == from cBB" cT (from cBB)
  assertEq " cT == from cSB" cT (from cSB)
  assertEq " cT == from cLT" cT (from cLT)
  assertEq " cT == from cTB" cT (from cTB)
  assertEq "cLT == from cB" cLT (from cB)
  assertEq "cLT == from cLB" cLT (from cLB)
  assertEq "cLT == from cBB" cLT (from cBB)
  assertEq "cLT == from cSB" cLT (from cSB)
  assertEq "cLT == from cT" cLT (from cT)
  assertEq "cLT == from cTB" cLT (from cTB)
  assertEq "cTB == from cB" cTB (from cB)
  assertEq "cTB == from cLB" cTB (from cLB)
  assertEq "cTB == from cBB" cTB (from cBB)
  assertEq "cTB == from cSB" cTB (from cSB)
  assertEq "cTB == from cT" cTB (from cT)
  assertEq "cTB == from cLT" cTB (from cLT)

  exitSuccess
