{- This file is part of funbot.
 -
 - Written in 2015 by fr33domlover <fr33domlover@rel4tion.org>.
 -
 - ♡ Copying is an act of love. Please copy, reuse and share.
 -
 - The author(s) have dedicated all copyright and related and neighboring
 - rights to this software to the public domain worldwide. This software is
 - distributed without any warranty.
 -
 - You should have received a copy of the CC0 Public Domain Dedication along
 - with this software. If not, see
 - <http://creativecommons.org/publicdomain/zero/1.0/>.
 -}

module FunBot.Sources.WebListener.Client
    ( dispatchClient
    )
where

import Data.Aeson (eitherDecode)
import Data.ByteString.Lazy (ByteString)
import FunBot.ExtEvents (ExtEvent)
import Network.HTTP (Request (..))

parse :: ByteString -> Either String ExtEvent
parse = eitherDecode

dispatchClient push _pushMany request =
    case parse $ rqBody request of
        Left e -> do
            putStrLn $ "Web listener source: Client: " ++ show e ++ ":"
            print $ rqBody request
        Right event -> push event
