{- This file is part of funbot.
 -
 - Written in 2015 by fr33domlover <fr33domlover@rel4tion.org>.
 -
 - ♡ Copying is an act of love. Please copy, reuse and share.
 -
 - The author(s) have dedicated all copyright and related and neighboring
 - rights to this software to the public domain worldwide. This software is
 - distributed without any warranty.
 -
 - You should have received a copy of the CC0 Public Domain Dedication along
 - with this software. If not, see
 - <http://creativecommons.org/publicdomain/zero/1.0/>.
 -}

module Main (main) where

import Control.Monad.IO.Class (liftIO)
import qualified Data.HashMap.Lazy as M (empty)
import Data.Settings.Section (empty)
import FunBot.Commands (commandSet)
import qualified FunBot.Config as C
import FunBot.ExtHandlers (handler)
import qualified FunBot.IrcHandlers as H
import FunBot.Memos
import FunBot.Settings
import FunBot.Sources
import FunBot.Types
import Network.IRC.Fun.Bot (runBot)
import Network.IRC.Fun.Bot.Behavior (defaultBehavior)
import Network.IRC.Fun.Bot.EventMatch
import Network.IRC.Fun.Bot.Types (Behavior (..))

-- | Bot environment content
env saveS saveM = BotEnv
    { webHookSourcePort = C.webListenerPort
    , saveSettings      = saveS
    , saveMemos         = saveM
    , feedErrorLogFile  = C.feedErrorLogFile
    }

-- | Initial content of the bot state
initialState sets ms = BotState
    { settings = sets
    , stree    = empty
    , memos    = ms
    }

-- | Event detector specification
matchers =
    [ matchPrefixedCommandC
    , matchRefCommandFromSetC
    , matchRefCommandFromNamesP ["help", "info", "echo", "tell", "get"]
    , matchRef
    , defaultMatch
    ]

-- | Bot behavior definition
behavior = defaultBehavior
    { handleJoin       = H.handleJoin
    , handleMsg        = H.handleMsg
    , handleBotMsg     = H.handleBotMsg
    , commandSets      = [commandSet]
    , handleNickChange = H.handleNickChange
    }

-- | Additional events sources
mkSources state =
    [ webListenerSource
    , feedWatcherSource C.feedErrorLogFile state
    ]

main = do
    liftIO $ putStrLn "Loading bot settings"
    sets <- loadBotSettings
    ms <- loadBotMemos
    saveS <- mkSaveBotSettings
    saveM <- mkSaveBotMemos
    let state = initialState sets ms
    runBot
        C.configuration
        matchers
        behavior
        (mkSources state)
        handler
        (env saveS saveM)
        state
        initTree
