{- This file is part of funbot.
 -
 - Written in 2015 by fr33domlover <fr33domlover@rel4tion.org>.
 -
 - ♡ Copying is an act of love. Please copy, reuse and share.
 -
 - The author(s) have dedicated all copyright and related and neighboring
 - rights to this software to the public domain worldwide. This software is
 - distributed without any warranty.
 -
 - You should have received a copy of the CC0 Public Domain Dedication along
 - with this software. If not, see
 - <http://creativecommons.org/publicdomain/zero/1.0/>.
 -}

module FunBot.Config
    ( stateSaveInterval
    , configuration
    , webListenerPort
    , feedErrorLogFile
    , feedVisitInterval
    , settingsFilename
    , memosFilename
    , userOptsFilename
    , nicksFilename
    , quoteDir
    )
where

import Data.Time.Interval (time)
import Data.Time.Units
import Network.IRC.Fun.Bot (defConfig)
import Network.IRC.Fun.Bot.Types (Connection (..), Config (..))

stateSaveInterval = 3 :: Second

configuration = defConfig
    { cfgConnection = Connection
        { connServer   = "irc.freenode.net"
        , connPort     = 6667
        , connTls      = False -- not supported yet
        , connNick     = "bot_test_joe"
        , connPassword = Nothing
        }
    , cfgChannels        = ["#freepost-bot-test"]
    , cfgLogDir          = "state/chanlogs"
    , cfgStateRepo       = Nothing
    , cfgStateFile       = "state/state.json"
    , cfgSaveInterval    = time stateSaveInterval
    , cfgBotEventLogFile = "state/bot.log"
    , cfgIrcErrorLogFile = Nothing
    , cfgMaxMsgChars     = Just 400
    }

webListenerPort = 8998 :: Int

feedErrorLogFile = "state/feed-error.log"

feedVisitInterval = 5 :: Minute

-- | If you set a repo path in the configuration above ('stateRepo' field),
-- then this path is relative to that repo and the settings file will be
-- commited to Git. Otherwise, this path is relative to the bot process working
-- dir (or absolute), and Git won't be used.
settingsFilename = "state/settings.json"

-- | If you set a repo path in the configuration above ('stateRepo' field),
-- then this path is relative to that repo and the memos file will be commited
-- to Git. Otherwise, this path is relative to the bot process working dir (or
-- absolute), and Git won't be used.
memosFilename = "state/memos.json"

-- | If you set a repo path in the configuration above ('stateRepo' field),
-- then this path is relative to that repo and the user options file will be
-- commited to Git. Otherwise, this path is relative to the bot process working
-- dir (or absolute), and Git won't be used.
userOptsFilename = "state/user-options.json"

-- | If you set a repo path in the configuration above ('stateRepo' field),
-- then this path is relative to that repo and the nicks file will be commited
-- to Git. Otherwise, this path is relative to the bot process working dir (or
-- absolute), and Git won't be used.
nicksFilename = "state/nicks.json"

-- | Directory in which to place channel quotes.
quoteDir = "state/quotes"
