{- This file is part of funbot.
 -
 - Written in 2015 by fr33domlover <fr33domlover@rel4tion.org>.
 -
 - ♡ Copying is an act of love. Please copy, reuse and share.
 -
 - The author(s) have dedicated all copyright and related and neighboring
 - rights to this software to the public domain worldwide. This software is
 - distributed without any warranty.
 -
 - You should have received a copy of the CC0 Public Domain Dedication along
 - with this software. If not, see
 - <http://creativecommons.org/publicdomain/zero/1.0/>.
 -}

module FunBot.Sources.Loopback
    ( loopbackSource
    , insertEvent
    )
where

import Control.Concurrent.Chan
import Control.Monad (forever)
import Control.Monad.IO.Class (liftIO)
import FunBot.ExtEvents (ExtEvent)
import FunBot.Types
import Network.IRC.Fun.Bot.State (askEnvS)

loopbackSource :: ExtEventSource
loopbackSource _config env push _pushMany _mkLogger = do
    putStrLn "Bot: Loopback source running"
    let chan = loopbackQueue env
    forever $ do
        event <- readChan chan
        push event

insertEvent :: ExtEvent -> BotSession ()
insertEvent event = do
    chan <- askEnvS loopbackQueue
    liftIO $ writeChan chan event
