{-
This is a generated file (generated by genprimopcode).
It is not code to actually be used. Its only purpose is to be
consumed by haddock.
-}

-----------------------------------------------------------------------------
-- |
-- Module      :  GHC.Internal.Prim
-- 
-- Maintainer  :  ghc-devs@haskell.org
-- Stability   :  internal
-- Portability :  non-portable (GHC extensions)
--
-- GHC's primitive types and operations.
-- Use GHC.Exts from the base package instead of importing this
-- module directly.
--
-----------------------------------------------------------------------------
{-# LANGUAGE Unsafe #-}
{-# LANGUAGE MagicHash #-}
{-# LANGUAGE MultiParamTypeClasses #-}
{-# LANGUAGE NoImplicitPrelude #-}
{-# LANGUAGE UnboxedTuples #-}
{-# LANGUAGE NegativeLiterals #-}
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
{-# OPTIONS_HADDOCK print-explicit-runtime-reps #-}
module GHC.Internal.Prim (
        
{- * The word size story.-}
{-|Haskell98 specifies that signed integers (type 'Int')
         must contain at least 30 bits. GHC always implements
         'Int' using the primitive type 'Int#', whose size equals
         the @MachDeps.h@ constant @WORD\_SIZE\_IN\_BITS@.
         This is normally set based on the RTS @ghcautoconf.h@ parameter
         @SIZEOF\_HSWORD@, i.e., 32 bits on 32-bit machines, 64
         bits on 64-bit machines.

         GHC also implements a primitive unsigned integer type
         'Word#' which always has the same number of bits as 'Int#'.

         In addition, GHC supports families of explicit-sized integers
         and words at 8, 16, 32, and 64 bits, with the usual
         arithmetic operations, comparisons, and a range of
         conversions.

         Finally, there are strongly deprecated primops for coercing
         between 'Addr#', the primitive type of machine
         addresses, and 'Int#'.  These are pretty bogus anyway,
         but will work on existing 32-bit and 64-bit GHC targets; they
         are completely bogus when tag bits are used in 'Int#',
         so are not available in this case.-}
        
{- * Char#-}
{-|Operations on 31-bit characters.-}
        Char#,
        gtChar#,
        geChar#,
        eqChar#,
        neChar#,
        ltChar#,
        leChar#,
        ord#,
        
{- * Int8#-}
{-|Operations on 8-bit integers.-}
        Int8#,
        int8ToInt#,
        intToInt8#,
        negateInt8#,
        plusInt8#,
        subInt8#,
        timesInt8#,
        quotInt8#,
        remInt8#,
        quotRemInt8#,
        uncheckedShiftLInt8#,
        uncheckedShiftRAInt8#,
        uncheckedShiftRLInt8#,
        int8ToWord8#,
        eqInt8#,
        geInt8#,
        gtInt8#,
        leInt8#,
        ltInt8#,
        neInt8#,
        
{- * Word8#-}
{-|Operations on 8-bit unsigned words.-}
        Word8#,
        word8ToWord#,
        wordToWord8#,
        plusWord8#,
        subWord8#,
        timesWord8#,
        quotWord8#,
        remWord8#,
        quotRemWord8#,
        andWord8#,
        orWord8#,
        xorWord8#,
        notWord8#,
        uncheckedShiftLWord8#,
        uncheckedShiftRLWord8#,
        word8ToInt8#,
        eqWord8#,
        geWord8#,
        gtWord8#,
        leWord8#,
        ltWord8#,
        neWord8#,
        
{- * Int16#-}
{-|Operations on 16-bit integers.-}
        Int16#,
        int16ToInt#,
        intToInt16#,
        negateInt16#,
        plusInt16#,
        subInt16#,
        timesInt16#,
        quotInt16#,
        remInt16#,
        quotRemInt16#,
        uncheckedShiftLInt16#,
        uncheckedShiftRAInt16#,
        uncheckedShiftRLInt16#,
        int16ToWord16#,
        eqInt16#,
        geInt16#,
        gtInt16#,
        leInt16#,
        ltInt16#,
        neInt16#,
        
{- * Word16#-}
{-|Operations on 16-bit unsigned words.-}
        Word16#,
        word16ToWord#,
        wordToWord16#,
        plusWord16#,
        subWord16#,
        timesWord16#,
        quotWord16#,
        remWord16#,
        quotRemWord16#,
        andWord16#,
        orWord16#,
        xorWord16#,
        notWord16#,
        uncheckedShiftLWord16#,
        uncheckedShiftRLWord16#,
        word16ToInt16#,
        eqWord16#,
        geWord16#,
        gtWord16#,
        leWord16#,
        ltWord16#,
        neWord16#,
        
{- * Int32#-}
{-|Operations on 32-bit integers.-}
        Int32#,
        int32ToInt#,
        intToInt32#,
        negateInt32#,
        plusInt32#,
        subInt32#,
        timesInt32#,
        quotInt32#,
        remInt32#,
        quotRemInt32#,
        uncheckedShiftLInt32#,
        uncheckedShiftRAInt32#,
        uncheckedShiftRLInt32#,
        int32ToWord32#,
        eqInt32#,
        geInt32#,
        gtInt32#,
        leInt32#,
        ltInt32#,
        neInt32#,
        
{- * Word32#-}
{-|Operations on 32-bit unsigned words.-}
        Word32#,
        word32ToWord#,
        wordToWord32#,
        plusWord32#,
        subWord32#,
        timesWord32#,
        quotWord32#,
        remWord32#,
        quotRemWord32#,
        andWord32#,
        orWord32#,
        xorWord32#,
        notWord32#,
        uncheckedShiftLWord32#,
        uncheckedShiftRLWord32#,
        word32ToInt32#,
        eqWord32#,
        geWord32#,
        gtWord32#,
        leWord32#,
        ltWord32#,
        neWord32#,
        
{- * Int64#-}
{-|Operations on 64-bit signed words.-}
        Int64#,
        int64ToInt#,
        intToInt64#,
        negateInt64#,
        plusInt64#,
        subInt64#,
        timesInt64#,
        quotInt64#,
        remInt64#,
        uncheckedIShiftL64#,
        uncheckedIShiftRA64#,
        uncheckedIShiftRL64#,
        int64ToWord64#,
        eqInt64#,
        geInt64#,
        gtInt64#,
        leInt64#,
        ltInt64#,
        neInt64#,
        
{- * Word64#-}
{-|Operations on 64-bit unsigned words.-}
        Word64#,
        word64ToWord#,
        wordToWord64#,
        plusWord64#,
        subWord64#,
        timesWord64#,
        quotWord64#,
        remWord64#,
        and64#,
        or64#,
        xor64#,
        not64#,
        uncheckedShiftL64#,
        uncheckedShiftRL64#,
        word64ToInt64#,
        eqWord64#,
        geWord64#,
        gtWord64#,
        leWord64#,
        ltWord64#,
        neWord64#,
        
{- * Int#-}
{-|Operations on native-size integers (32+ bits).-}
        Int#,
        (+#),
        (-#),
        (*#),
        timesInt2#,
        mulIntMayOflo#,
        quotInt#,
        remInt#,
        quotRemInt#,
        andI#,
        orI#,
        xorI#,
        notI#,
        negateInt#,
        addIntC#,
        subIntC#,
        (>#),
        (>=#),
        (==#),
        (/=#),
        (<#),
        (<=#),
        chr#,
        int2Word#,
        int2Float#,
        int2Double#,
        word2Float#,
        word2Double#,
        uncheckedIShiftL#,
        uncheckedIShiftRA#,
        uncheckedIShiftRL#,
        
{- * Word#-}
{-|Operations on native-sized unsigned words (32+ bits).-}
        Word#,
        plusWord#,
        addWordC#,
        subWordC#,
        plusWord2#,
        minusWord#,
        timesWord#,
        timesWord2#,
        quotWord#,
        remWord#,
        quotRemWord#,
        quotRemWord2#,
        and#,
        or#,
        xor#,
        not#,
        uncheckedShiftL#,
        uncheckedShiftRL#,
        word2Int#,
        gtWord#,
        geWord#,
        eqWord#,
        neWord#,
        ltWord#,
        leWord#,
        popCnt8#,
        popCnt16#,
        popCnt32#,
        popCnt64#,
        popCnt#,
        pdep8#,
        pdep16#,
        pdep32#,
        pdep64#,
        pdep#,
        pext8#,
        pext16#,
        pext32#,
        pext64#,
        pext#,
        clz8#,
        clz16#,
        clz32#,
        clz64#,
        clz#,
        ctz8#,
        ctz16#,
        ctz32#,
        ctz64#,
        ctz#,
        byteSwap16#,
        byteSwap32#,
        byteSwap64#,
        byteSwap#,
        bitReverse8#,
        bitReverse16#,
        bitReverse32#,
        bitReverse64#,
        bitReverse#,
        
{- * Narrowings-}
{-|Explicit narrowing of native-sized ints or words.-}
        narrow8Int#,
        narrow16Int#,
        narrow32Int#,
        narrow8Word#,
        narrow16Word#,
        narrow32Word#,
        
{- * Double#-}
{-|Operations on double-precision (64 bit) floating-point numbers.-}
        Double#,
        (>##),
        (>=##),
        (==##),
        (/=##),
        (<##),
        (<=##),
        minDouble#,
        maxDouble#,
        (+##),
        (-##),
        (*##),
        (/##),
        negateDouble#,
        fabsDouble#,
        double2Int#,
        double2Float#,
        expDouble#,
        expm1Double#,
        logDouble#,
        log1pDouble#,
        sqrtDouble#,
        sinDouble#,
        cosDouble#,
        tanDouble#,
        asinDouble#,
        acosDouble#,
        atanDouble#,
        sinhDouble#,
        coshDouble#,
        tanhDouble#,
        asinhDouble#,
        acoshDouble#,
        atanhDouble#,
        (**##),
        decodeDouble_2Int#,
        decodeDouble_Int64#,
        castDoubleToWord64#,
        castWord64ToDouble#,
        
{- * Float#-}
{-|Operations on single-precision (32-bit) floating-point numbers.-}
        Float#,
        gtFloat#,
        geFloat#,
        eqFloat#,
        neFloat#,
        ltFloat#,
        leFloat#,
        minFloat#,
        maxFloat#,
        plusFloat#,
        minusFloat#,
        timesFloat#,
        divideFloat#,
        negateFloat#,
        fabsFloat#,
        float2Int#,
        expFloat#,
        expm1Float#,
        logFloat#,
        log1pFloat#,
        sqrtFloat#,
        sinFloat#,
        cosFloat#,
        tanFloat#,
        asinFloat#,
        acosFloat#,
        atanFloat#,
        sinhFloat#,
        coshFloat#,
        tanhFloat#,
        asinhFloat#,
        acoshFloat#,
        atanhFloat#,
        powerFloat#,
        float2Double#,
        decodeFloat_Int#,
        castFloatToWord32#,
        castWord32ToFloat#,
        
{- * Fused multiply-add operations-}
{-| #fma#

    The fused multiply-add primops 'fmaddFloat#' and 'fmaddDouble#'
    implement the operation

    \[
    \lambda\ x\ y\ z \rightarrow x * y + z
    \]

    with a single floating-point rounding operation at the end, as opposed to
    rounding twice (which can accumulate rounding errors).

    These primops can be compiled directly to a single machine instruction on
    architectures that support them. Currently, these are:

      1. x86 with CPUs that support the FMA3 extended instruction set (which
         includes most processors since 2013).
      2. PowerPC.
      3. AArch64.

    This requires users pass the '-mfma' flag to GHC. Otherwise, the primop
    is implemented by falling back to the C standard library, which might
    perform software emulation (this may yield results that are not IEEE
    compliant on some platforms).

    The additional operations 'fmsubFloat#'/'fmsubDouble#',
    'fnmaddFloat#'/'fnmaddDouble#' and 'fnmsubFloat#'/'fnmsubDouble#' provide
    variants on 'fmaddFloat#'/'fmaddDouble#' in which some signs are changed:

    \[
    \begin{aligned}
    \mathrm{fmadd}\ x\ y\ z &= \phantom{+} x * y + z \\[8pt]
    \mathrm{fmsub}\ x\ y\ z &= \phantom{+} x * y - z \\[8pt]
    \mathrm{fnmadd}\ x\ y\ z &= - x * y + z \\[8pt]
    \mathrm{fnmsub}\ x\ y\ z &= - x * y - z
    \end{aligned}
    \]

    -}
        fmaddFloat#,
        fmsubFloat#,
        fnmaddFloat#,
        fnmsubFloat#,
        fmaddDouble#,
        fmsubDouble#,
        fnmaddDouble#,
        fnmsubDouble#,
        
{- * Arrays-}
{-|Operations on 'Array#'.-}
        Array#,
        MutableArray#,
        newArray#,
        readArray#,
        writeArray#,
        sizeofArray#,
        sizeofMutableArray#,
        indexArray#,
        unsafeFreezeArray#,
        unsafeThawArray#,
        copyArray#,
        copyMutableArray#,
        cloneArray#,
        cloneMutableArray#,
        freezeArray#,
        thawArray#,
        casArray#,
        
{- * Small Arrays-}
{-|Operations on 'SmallArray#'. A 'SmallArray#' works
         just like an 'Array#', but with different space use and
         performance characteristics (that are often useful with small
         arrays). The 'SmallArray#' and 'SmallMutableArray#'
         lack a `card table'. The purpose of a card table is to avoid
         having to scan every element of the array on each GC by
         keeping track of which elements have changed since the last GC
         and only scanning those that have changed. So the consequence
         of there being no card table is that the representation is
         somewhat smaller and the writes are somewhat faster (because
         the card table does not need to be updated). The disadvantage
         of course is that for a 'SmallMutableArray#' the whole
         array has to be scanned on each GC. Thus it is best suited for
         use cases where the mutable array is not long lived, e.g.
         where a mutable array is initialised quickly and then frozen
         to become an immutable 'SmallArray#'.
        -}
        SmallArray#,
        SmallMutableArray#,
        newSmallArray#,
        shrinkSmallMutableArray#,
        readSmallArray#,
        writeSmallArray#,
        sizeofSmallArray#,
        sizeofSmallMutableArray#,
        getSizeofSmallMutableArray#,
        indexSmallArray#,
        unsafeFreezeSmallArray#,
        unsafeThawSmallArray#,
        copySmallArray#,
        copySmallMutableArray#,
        cloneSmallArray#,
        cloneSmallMutableArray#,
        freezeSmallArray#,
        thawSmallArray#,
        casSmallArray#,
        
{- * Byte Arrays-}
{-|A 'ByteArray#' is a region of
         raw memory in the garbage-collected heap, which is not
         scanned for pointers.
         There are three sets of operations for accessing byte array contents:
         index for reading from immutable byte arrays, and read/write
         for mutable byte arrays.  Each set contains operations for a
         range of useful primitive data types.  Each operation takes
         an offset measured in terms of the size of the primitive type
         being read or written.

         -}
        ByteArray#,
        MutableByteArray#,
        newByteArray#,
        newPinnedByteArray#,
        newAlignedPinnedByteArray#,
        isMutableByteArrayPinned#,
        isByteArrayPinned#,
        isByteArrayWeaklyPinned#,
        isMutableByteArrayWeaklyPinned#,
        byteArrayContents#,
        mutableByteArrayContents#,
        shrinkMutableByteArray#,
        resizeMutableByteArray#,
        unsafeFreezeByteArray#,
        unsafeThawByteArray#,
        sizeofByteArray#,
        sizeofMutableByteArray#,
        getSizeofMutableByteArray#,
        indexCharArray#,
        indexWideCharArray#,
        indexIntArray#,
        indexWordArray#,
        indexAddrArray#,
        indexFloatArray#,
        indexDoubleArray#,
        indexStablePtrArray#,
        indexInt8Array#,
        indexWord8Array#,
        indexInt16Array#,
        indexWord16Array#,
        indexInt32Array#,
        indexWord32Array#,
        indexInt64Array#,
        indexWord64Array#,
        indexWord8ArrayAsChar#,
        indexWord8ArrayAsWideChar#,
        indexWord8ArrayAsInt#,
        indexWord8ArrayAsWord#,
        indexWord8ArrayAsAddr#,
        indexWord8ArrayAsFloat#,
        indexWord8ArrayAsDouble#,
        indexWord8ArrayAsStablePtr#,
        indexWord8ArrayAsInt16#,
        indexWord8ArrayAsWord16#,
        indexWord8ArrayAsInt32#,
        indexWord8ArrayAsWord32#,
        indexWord8ArrayAsInt64#,
        indexWord8ArrayAsWord64#,
        readCharArray#,
        readWideCharArray#,
        readIntArray#,
        readWordArray#,
        readAddrArray#,
        readFloatArray#,
        readDoubleArray#,
        readStablePtrArray#,
        readInt8Array#,
        readWord8Array#,
        readInt16Array#,
        readWord16Array#,
        readInt32Array#,
        readWord32Array#,
        readInt64Array#,
        readWord64Array#,
        readWord8ArrayAsChar#,
        readWord8ArrayAsWideChar#,
        readWord8ArrayAsInt#,
        readWord8ArrayAsWord#,
        readWord8ArrayAsAddr#,
        readWord8ArrayAsFloat#,
        readWord8ArrayAsDouble#,
        readWord8ArrayAsStablePtr#,
        readWord8ArrayAsInt16#,
        readWord8ArrayAsWord16#,
        readWord8ArrayAsInt32#,
        readWord8ArrayAsWord32#,
        readWord8ArrayAsInt64#,
        readWord8ArrayAsWord64#,
        writeCharArray#,
        writeWideCharArray#,
        writeIntArray#,
        writeWordArray#,
        writeAddrArray#,
        writeFloatArray#,
        writeDoubleArray#,
        writeStablePtrArray#,
        writeInt8Array#,
        writeWord8Array#,
        writeInt16Array#,
        writeWord16Array#,
        writeInt32Array#,
        writeWord32Array#,
        writeInt64Array#,
        writeWord64Array#,
        writeWord8ArrayAsChar#,
        writeWord8ArrayAsWideChar#,
        writeWord8ArrayAsInt#,
        writeWord8ArrayAsWord#,
        writeWord8ArrayAsAddr#,
        writeWord8ArrayAsFloat#,
        writeWord8ArrayAsDouble#,
        writeWord8ArrayAsStablePtr#,
        writeWord8ArrayAsInt16#,
        writeWord8ArrayAsWord16#,
        writeWord8ArrayAsInt32#,
        writeWord8ArrayAsWord32#,
        writeWord8ArrayAsInt64#,
        writeWord8ArrayAsWord64#,
        compareByteArrays#,
        copyByteArray#,
        copyMutableByteArray#,
        copyMutableByteArrayNonOverlapping#,
        copyByteArrayToAddr#,
        copyMutableByteArrayToAddr#,
        copyAddrToByteArray#,
        copyAddrToAddr#,
        copyAddrToAddrNonOverlapping#,
        setByteArray#,
        setAddrRange#,
        atomicReadIntArray#,
        atomicWriteIntArray#,
        casIntArray#,
        casInt8Array#,
        casInt16Array#,
        casInt32Array#,
        casInt64Array#,
        fetchAddIntArray#,
        fetchSubIntArray#,
        fetchAndIntArray#,
        fetchNandIntArray#,
        fetchOrIntArray#,
        fetchXorIntArray#,
        
{- * Addr#-}
{-|-}
        Addr#,
        nullAddr#,
        plusAddr#,
        minusAddr#,
        remAddr#,
        addr2Int#,
        int2Addr#,
        gtAddr#,
        geAddr#,
        eqAddr#,
        neAddr#,
        ltAddr#,
        leAddr#,
        indexCharOffAddr#,
        indexWideCharOffAddr#,
        indexIntOffAddr#,
        indexWordOffAddr#,
        indexAddrOffAddr#,
        indexFloatOffAddr#,
        indexDoubleOffAddr#,
        indexStablePtrOffAddr#,
        indexInt8OffAddr#,
        indexWord8OffAddr#,
        indexInt16OffAddr#,
        indexWord16OffAddr#,
        indexInt32OffAddr#,
        indexWord32OffAddr#,
        indexInt64OffAddr#,
        indexWord64OffAddr#,
        indexWord8OffAddrAsChar#,
        indexWord8OffAddrAsWideChar#,
        indexWord8OffAddrAsInt#,
        indexWord8OffAddrAsWord#,
        indexWord8OffAddrAsAddr#,
        indexWord8OffAddrAsFloat#,
        indexWord8OffAddrAsDouble#,
        indexWord8OffAddrAsStablePtr#,
        indexWord8OffAddrAsInt16#,
        indexWord8OffAddrAsWord16#,
        indexWord8OffAddrAsInt32#,
        indexWord8OffAddrAsWord32#,
        indexWord8OffAddrAsInt64#,
        indexWord8OffAddrAsWord64#,
        readCharOffAddr#,
        readWideCharOffAddr#,
        readIntOffAddr#,
        readWordOffAddr#,
        readAddrOffAddr#,
        readFloatOffAddr#,
        readDoubleOffAddr#,
        readStablePtrOffAddr#,
        readInt8OffAddr#,
        readWord8OffAddr#,
        readInt16OffAddr#,
        readWord16OffAddr#,
        readInt32OffAddr#,
        readWord32OffAddr#,
        readInt64OffAddr#,
        readWord64OffAddr#,
        readWord8OffAddrAsChar#,
        readWord8OffAddrAsWideChar#,
        readWord8OffAddrAsInt#,
        readWord8OffAddrAsWord#,
        readWord8OffAddrAsAddr#,
        readWord8OffAddrAsFloat#,
        readWord8OffAddrAsDouble#,
        readWord8OffAddrAsStablePtr#,
        readWord8OffAddrAsInt16#,
        readWord8OffAddrAsWord16#,
        readWord8OffAddrAsInt32#,
        readWord8OffAddrAsWord32#,
        readWord8OffAddrAsInt64#,
        readWord8OffAddrAsWord64#,
        writeCharOffAddr#,
        writeWideCharOffAddr#,
        writeIntOffAddr#,
        writeWordOffAddr#,
        writeAddrOffAddr#,
        writeFloatOffAddr#,
        writeDoubleOffAddr#,
        writeStablePtrOffAddr#,
        writeInt8OffAddr#,
        writeWord8OffAddr#,
        writeInt16OffAddr#,
        writeWord16OffAddr#,
        writeInt32OffAddr#,
        writeWord32OffAddr#,
        writeInt64OffAddr#,
        writeWord64OffAddr#,
        writeWord8OffAddrAsChar#,
        writeWord8OffAddrAsWideChar#,
        writeWord8OffAddrAsInt#,
        writeWord8OffAddrAsWord#,
        writeWord8OffAddrAsAddr#,
        writeWord8OffAddrAsFloat#,
        writeWord8OffAddrAsDouble#,
        writeWord8OffAddrAsStablePtr#,
        writeWord8OffAddrAsInt16#,
        writeWord8OffAddrAsWord16#,
        writeWord8OffAddrAsInt32#,
        writeWord8OffAddrAsWord32#,
        writeWord8OffAddrAsInt64#,
        writeWord8OffAddrAsWord64#,
        atomicExchangeAddrAddr#,
        atomicExchangeWordAddr#,
        atomicCasAddrAddr#,
        atomicCasWordAddr#,
        atomicCasWord8Addr#,
        atomicCasWord16Addr#,
        atomicCasWord32Addr#,
        atomicCasWord64Addr#,
        fetchAddWordAddr#,
        fetchSubWordAddr#,
        fetchAndWordAddr#,
        fetchNandWordAddr#,
        fetchOrWordAddr#,
        fetchXorWordAddr#,
        atomicReadWordAddr#,
        atomicWriteWordAddr#,
        
{- * Mutable variables-}
{-|Operations on MutVar\#s.-}
        MutVar#,
        newMutVar#,
        readMutVar#,
        writeMutVar#,
        atomicSwapMutVar#,
        atomicModifyMutVar2#,
        atomicModifyMutVar_#,
        casMutVar#,
        
{- * Exceptions-}
{-|-}
        catch#,
        raise#,
        raiseUnderflow#,
        raiseOverflow#,
        raiseDivZero#,
        raiseIO#,
        maskAsyncExceptions#,
        maskUninterruptible#,
        unmaskAsyncExceptions#,
        getMaskingState#,
        
{- * Continuations-}
{-| #continuations#

    These operations provide access to first-class delimited continuations,
    which allow a computation to access and manipulate portions of its
    /current continuation/. Operationally, they are implemented by direct
    manipulation of the RTS call stack, which may provide significant
    performance gains relative to manual continuation-passing style (CPS) for
    some programs.

    Intuitively, the delimited control operators 'prompt#' and
    'control0#' can be understood by analogy to 'catch#' and 'raiseIO#',
    respectively:

      * Like 'catch#', 'prompt#' does not do anything on its own, it
        just /delimits/ a subcomputation (the source of the name "delimited
        continuations").

      * Like 'raiseIO#', 'control0#' aborts to the nearest enclosing
        'prompt#' before resuming execution.

    However, /unlike/ 'raiseIO#', 'control0#' does /not/ discard
    the aborted computation: instead, it /captures/ it in a form that allows
    it to be resumed later. In other words, 'control0#' does not
    irreversibly abort the local computation before returning to the enclosing
    'prompt#', it merely suspends it. All local context of the suspended
    computation is packaged up and returned as an ordinary function that can be
    invoked at a later point in time to /continue/ execution, which is why
    the suspended computation is known as a /first-class continuation/.

    In GHC, every continuation prompt is associated with exactly one
    'PromptTag#'. Prompt tags are unique, opaque values created by
    'newPromptTag#' that may only be compared for equality. Both 'prompt#'
    and 'control0#' accept a 'PromptTag#' argument, and 'control0#'
    captures the continuation up to the nearest enclosing use of 'prompt#'
    /with the same tag/. This allows a program to control exactly which
    prompt it will abort to by using different tags, similar to how a program
    can control which 'catch' it will abort to by throwing different types
    of exceptions. Additionally, 'PromptTag#' accepts a single type parameter,
    which is used to relate the expected result type at the point of the
    'prompt#' to the type of the continuation produced by 'control0#'.

    == The gory details

    The high-level explanation provided above should hopefully provide some
    intuition for what these operations do, but it is not very precise; this
    section provides a more thorough explanation.

    The 'prompt#' operation morally has the following type:

@
'prompt#' :: 'PromptTag#' a -> IO a -> IO a
@

    If a computation @/m/@ never calls 'control0#', then
    @'prompt#' /tag/ /m/@ is equivalent to just @/m/@, i.e. the 'prompt#' is
    a no-op. This implies the following law:

    \[
    \mathtt{prompt\#}\ \mathit{tag}\ (\mathtt{pure}\ x) \equiv \mathtt{pure}\ x
    \]

    The 'control0#' operation morally has the following type:

@
'control0#' :: 'PromptTag#' a -> ((IO b -> IO a) -> IO a) -> IO b
@

    @'control0#' /tag/ /f/@ captures the current continuation up to the nearest
    enclosing @'prompt#' /tag/@ and resumes execution from the point of the call
    to 'prompt#', passing the captured continuation to @/f/@. To make that
    somewhat more precise, we can say 'control0#' obeys the following law:

    \[
    \mathtt{prompt\#}\ \mathit{tag}\ (\mathtt{control0\#}\ tag\ f \mathbin{\mathtt{>>=}} k)
      \equiv f\ (\lambda\ m \rightarrow m \mathbin{\mathtt{>>=}} k)
    \]

    However, this law does not fully describe the behavior of 'control0#',
    as it does not account for situations where 'control0#' does not appear
    immediately inside 'prompt#'. Capturing the semantics more precisely
    requires some additional notational machinery; a common approach is to
    use [reduction semantics](https://en.wikipedia.org/wiki/Operational_semantics#Reduction_semantics).
    Assuming an appropriate definition of evaluation contexts \(E\), the
    semantics of 'prompt#' and 'control0#' can be given as follows:

    \[
    \begin{aligned}
    E[\mathtt{prompt\#}\ \mathit{tag}\ (\mathtt{pure}\ v)]
      &\longrightarrow E[\mathtt{pure}\ v] \\[8pt]
    E_1[\mathtt{prompt\#}\ \mathit{tag}\ E_2[\mathtt{control0\#}\ tag\ f]]
      &\longrightarrow E_1[f\ (\lambda\ m \rightarrow E_2[m])] \\[-2pt]
      \mathrm{where}\;\: \mathtt{prompt\#}\ \mathit{tag} &\not\in E_2
    \end{aligned}
    \]

    A full treatment of the semantics and metatheory of delimited control is
    well outside the scope of this documentation, but a good, thorough
    overview (in Haskell) is provided in [A Monadic Framework for Delimited
    Continuations](https://legacy.cs.indiana.edu/~dyb/pubs/monadicDC.pdf) by
    Dybvig et al.

    == Safety and invariants

    Correct uses of 'control0#' must obey the following restrictions:

    1. The behavior of 'control0#' is only well-defined within a /strict
       'State#' thread/, such as those associated with @IO@ and strict @ST@
       computations.

    2. Furthermore, 'control0#' may only be called within the dynamic extent
       of a 'prompt#' with a matching tag somewhere in the /current/ strict
       'State#' thread. Effectively, this means that a matching prompt must
       exist somewhere, and the captured continuation must /not/ contain any
       uses of @unsafePerformIO@, @runST@, @unsafeInterleaveIO@, etc. For
       example, the following program is ill-defined:

        @
        'prompt#' /tag/ $
          evaluate (unsafePerformIO $ 'control0#' /tag/ /f/)
        @

        In this example, the use of 'prompt#' appears in a different 'State#'
        thread from the use of 'control0#', so there is no valid prompt in
        scope to capture up to.

    3. Finally, 'control0#' may not be used within 'State#' threads associated
       with an STM transaction (i.e. those introduced by 'atomically#').

    If the runtime is able to detect that any of these invariants have been
    violated in a way that would compromise internal invariants of the runtime,
    'control0#' will fail by raising an exception. However, such violations
    are only detected on a best-effort basis, as the bookkeeping necessary for
    detecting /all/ illegal uses of 'control0#' would have significant overhead.
    Therefore, although the operations are "safe" from the runtime's point of
    view (e.g. they will not compromise memory safety or clobber internal runtime
    state), it is still ultimately the programmer's responsibility to ensure
    these invariants hold to guarantee predictable program behavior.

    In a similar vein, since each captured continuation includes the full local
    context of the suspended computation, it can safely be resumed arbitrarily
    many times without violating any invariants of the runtime system. However,
    use of these operations in an arbitrary 'IO' computation may be unsafe for
    other reasons, as most 'IO' code is not written with reentrancy in mind. For
    example, a computation suspended in the middle of reading a file will likely
    finish reading it when it is resumed; further attempts to resume from the
    same place would then fail because the file handle was already closed.

    In other words, although the RTS ensures that a computation's control state
    and local variables are properly restored for each distinct resumption of
    a continuation, it makes no attempt to duplicate any local state the
    computation may have been using (and could not possibly do so in general).
    Furthermore, it provides no mechanism for an arbitrary computation to
    protect itself against unwanted reentrancy (i.e. there is no analogue to
    Scheme's @dynamic-wind@). For those reasons, manipulating the continuation
    is only safe if the caller can be certain that doing so will not violate any
    expectations or invariants of the enclosing computation. -}
        PromptTag#,
        newPromptTag#,
        prompt#,
        control0#,
        
{- * STM-accessible Mutable Variables-}
{-|-}
        TVar#,
        atomically#,
        retry#,
        catchRetry#,
        catchSTM#,
        newTVar#,
        readTVar#,
        readTVarIO#,
        writeTVar#,
        
{- * Synchronized Mutable Variables-}
{-|Operations on 'MVar#'s. -}
        MVar#,
        newMVar#,
        takeMVar#,
        tryTakeMVar#,
        putMVar#,
        tryPutMVar#,
        readMVar#,
        tryReadMVar#,
        isEmptyMVar#,
        
{- * Delay/wait operations-}
{-|-}
        delay#,
        waitRead#,
        waitWrite#,
        
{- * Concurrency primitives-}
{-|-}
        State#,
        RealWorld,
        ThreadId#,
        fork#,
        forkOn#,
        killThread#,
        yield#,
        myThreadId#,
        labelThread#,
        isCurrentThreadBound#,
        noDuplicate#,
        threadLabel#,
        threadStatus#,
        listThreads#,
        
{- * Weak pointers-}
{-|-}
        Weak#,
        mkWeak#,
        mkWeakNoFinalizer#,
        addCFinalizerToWeak#,
        deRefWeak#,
        finalizeWeak#,
        touch#,
        
{- * Stable pointers and names-}
{-|-}
        StablePtr#,
        StableName#,
        makeStablePtr#,
        deRefStablePtr#,
        eqStablePtr#,
        makeStableName#,
        stableNameToInt#,
        
{- * Compact normal form-}
{-|Primitives for working with compact regions. The @ghc-compact@
         library and the @compact@ library demonstrate how to use these
         primitives. The documentation below draws a distinction between
         a CNF and a compact block. A CNF contains one or more compact
         blocks. The source file @rts\/sm\/CNF.c@
         diagrams this relationship. When discussing a compact
         block, an additional distinction is drawn between capacity and
         utilized bytes. The capacity is the maximum number of bytes that
         the compact block can hold. The utilized bytes is the number of
         bytes that are actually used by the compact block.
        -}
        Compact#,
        compactNew#,
        compactResize#,
        compactContains#,
        compactContainsAny#,
        compactGetFirstBlock#,
        compactGetNextBlock#,
        compactAllocateBlock#,
        compactFixupPointers#,
        compactAdd#,
        compactAddWithSharing#,
        compactSize#,
        
{- * Unsafe pointer equality-}
{-|-}
        reallyUnsafePtrEquality#,
        
{- * Parallelism-}
{-|-}
        par#,
        spark#,
        getSpark#,
        numSparks#,
        
{- * Controlling object lifetime-}
{-|Ensuring that objects don't die a premature death.-}
        keepAlive#,
        
{- * Tag to enum stuff-}
{-|Convert back and forth between values of enumerated types
        and small integers.-}
        dataToTagSmall#,
        dataToTagLarge#,
        tagToEnum#,
        
{- * Bytecode operations-}
{-|Support for manipulating bytecode objects used by the interpreter and
        linker.

        Bytecode objects are heap objects which represent top-level bindings and
        contain a list of instructions and data needed by these instructions.-}
        BCO,
        addrToAny#,
        anyToAddr#,
        mkApUpd0#,
        newBCO#,
        unpackClosure#,
        closureSize#,
        getApStackVal#,
        
{- * Misc-}
{-|These aren't nearly as wired in as Etc...-}
        getCCSOf#,
        getCurrentCCS#,
        clearCCS#,
        
{- * Annotating call stacks-}
{-|-}
        annotateStack#,
        
{- * Info Table Origin-}
{-|-}
        whereFrom#,
        
{- * Etc-}
{-|Miscellaneous built-ins-}
        FUN,
        realWorld#,
        void#,
        Proxy#,
        proxy#,
        seq,
        traceEvent#,
        traceBinaryEvent#,
        traceMarker#,
        setThreadAllocationCounter#,
        setOtherThreadAllocationCounter#,
        StackSnapshot#,
        
{- * Safe coercions-}
{-|-}
        coerce,
        
{- * SIMD Vectors-}
{-|Operations on SIMD vectors.-}
        Int8X16#,
        Int16X8#,
        Int32X4#,
        Int64X2#,
        Int8X32#,
        Int16X16#,
        Int32X8#,
        Int64X4#,
        Int8X64#,
        Int16X32#,
        Int32X16#,
        Int64X8#,
        Word8X16#,
        Word16X8#,
        Word32X4#,
        Word64X2#,
        Word8X32#,
        Word16X16#,
        Word32X8#,
        Word64X4#,
        Word8X64#,
        Word16X32#,
        Word32X16#,
        Word64X8#,
        FloatX4#,
        DoubleX2#,
        FloatX8#,
        DoubleX4#,
        FloatX16#,
        DoubleX8#,
        broadcastInt8X16#,
        broadcastInt16X8#,
        broadcastInt32X4#,
        broadcastInt64X2#,
        broadcastInt8X32#,
        broadcastInt16X16#,
        broadcastInt32X8#,
        broadcastInt64X4#,
        broadcastInt8X64#,
        broadcastInt16X32#,
        broadcastInt32X16#,
        broadcastInt64X8#,
        broadcastWord8X16#,
        broadcastWord16X8#,
        broadcastWord32X4#,
        broadcastWord64X2#,
        broadcastWord8X32#,
        broadcastWord16X16#,
        broadcastWord32X8#,
        broadcastWord64X4#,
        broadcastWord8X64#,
        broadcastWord16X32#,
        broadcastWord32X16#,
        broadcastWord64X8#,
        broadcastFloatX4#,
        broadcastDoubleX2#,
        broadcastFloatX8#,
        broadcastDoubleX4#,
        broadcastFloatX16#,
        broadcastDoubleX8#,
        packInt8X16#,
        packInt16X8#,
        packInt32X4#,
        packInt64X2#,
        packInt8X32#,
        packInt16X16#,
        packInt32X8#,
        packInt64X4#,
        packInt8X64#,
        packInt16X32#,
        packInt32X16#,
        packInt64X8#,
        packWord8X16#,
        packWord16X8#,
        packWord32X4#,
        packWord64X2#,
        packWord8X32#,
        packWord16X16#,
        packWord32X8#,
        packWord64X4#,
        packWord8X64#,
        packWord16X32#,
        packWord32X16#,
        packWord64X8#,
        packFloatX4#,
        packDoubleX2#,
        packFloatX8#,
        packDoubleX4#,
        packFloatX16#,
        packDoubleX8#,
        unpackInt8X16#,
        unpackInt16X8#,
        unpackInt32X4#,
        unpackInt64X2#,
        unpackInt8X32#,
        unpackInt16X16#,
        unpackInt32X8#,
        unpackInt64X4#,
        unpackInt8X64#,
        unpackInt16X32#,
        unpackInt32X16#,
        unpackInt64X8#,
        unpackWord8X16#,
        unpackWord16X8#,
        unpackWord32X4#,
        unpackWord64X2#,
        unpackWord8X32#,
        unpackWord16X16#,
        unpackWord32X8#,
        unpackWord64X4#,
        unpackWord8X64#,
        unpackWord16X32#,
        unpackWord32X16#,
        unpackWord64X8#,
        unpackFloatX4#,
        unpackDoubleX2#,
        unpackFloatX8#,
        unpackDoubleX4#,
        unpackFloatX16#,
        unpackDoubleX8#,
        insertInt8X16#,
        insertInt16X8#,
        insertInt32X4#,
        insertInt64X2#,
        insertInt8X32#,
        insertInt16X16#,
        insertInt32X8#,
        insertInt64X4#,
        insertInt8X64#,
        insertInt16X32#,
        insertInt32X16#,
        insertInt64X8#,
        insertWord8X16#,
        insertWord16X8#,
        insertWord32X4#,
        insertWord64X2#,
        insertWord8X32#,
        insertWord16X16#,
        insertWord32X8#,
        insertWord64X4#,
        insertWord8X64#,
        insertWord16X32#,
        insertWord32X16#,
        insertWord64X8#,
        insertFloatX4#,
        insertDoubleX2#,
        insertFloatX8#,
        insertDoubleX4#,
        insertFloatX16#,
        insertDoubleX8#,
        plusInt8X16#,
        plusInt16X8#,
        plusInt32X4#,
        plusInt64X2#,
        plusInt8X32#,
        plusInt16X16#,
        plusInt32X8#,
        plusInt64X4#,
        plusInt8X64#,
        plusInt16X32#,
        plusInt32X16#,
        plusInt64X8#,
        plusWord8X16#,
        plusWord16X8#,
        plusWord32X4#,
        plusWord64X2#,
        plusWord8X32#,
        plusWord16X16#,
        plusWord32X8#,
        plusWord64X4#,
        plusWord8X64#,
        plusWord16X32#,
        plusWord32X16#,
        plusWord64X8#,
        plusFloatX4#,
        plusDoubleX2#,
        plusFloatX8#,
        plusDoubleX4#,
        plusFloatX16#,
        plusDoubleX8#,
        minusInt8X16#,
        minusInt16X8#,
        minusInt32X4#,
        minusInt64X2#,
        minusInt8X32#,
        minusInt16X16#,
        minusInt32X8#,
        minusInt64X4#,
        minusInt8X64#,
        minusInt16X32#,
        minusInt32X16#,
        minusInt64X8#,
        minusWord8X16#,
        minusWord16X8#,
        minusWord32X4#,
        minusWord64X2#,
        minusWord8X32#,
        minusWord16X16#,
        minusWord32X8#,
        minusWord64X4#,
        minusWord8X64#,
        minusWord16X32#,
        minusWord32X16#,
        minusWord64X8#,
        minusFloatX4#,
        minusDoubleX2#,
        minusFloatX8#,
        minusDoubleX4#,
        minusFloatX16#,
        minusDoubleX8#,
        timesInt8X16#,
        timesInt16X8#,
        timesInt32X4#,
        timesInt64X2#,
        timesInt8X32#,
        timesInt16X16#,
        timesInt32X8#,
        timesInt64X4#,
        timesInt8X64#,
        timesInt16X32#,
        timesInt32X16#,
        timesInt64X8#,
        timesWord8X16#,
        timesWord16X8#,
        timesWord32X4#,
        timesWord64X2#,
        timesWord8X32#,
        timesWord16X16#,
        timesWord32X8#,
        timesWord64X4#,
        timesWord8X64#,
        timesWord16X32#,
        timesWord32X16#,
        timesWord64X8#,
        timesFloatX4#,
        timesDoubleX2#,
        timesFloatX8#,
        timesDoubleX4#,
        timesFloatX16#,
        timesDoubleX8#,
        divideFloatX4#,
        divideDoubleX2#,
        divideFloatX8#,
        divideDoubleX4#,
        divideFloatX16#,
        divideDoubleX8#,
        quotInt8X16#,
        quotInt16X8#,
        quotInt32X4#,
        quotInt64X2#,
        quotInt8X32#,
        quotInt16X16#,
        quotInt32X8#,
        quotInt64X4#,
        quotInt8X64#,
        quotInt16X32#,
        quotInt32X16#,
        quotInt64X8#,
        quotWord8X16#,
        quotWord16X8#,
        quotWord32X4#,
        quotWord64X2#,
        quotWord8X32#,
        quotWord16X16#,
        quotWord32X8#,
        quotWord64X4#,
        quotWord8X64#,
        quotWord16X32#,
        quotWord32X16#,
        quotWord64X8#,
        remInt8X16#,
        remInt16X8#,
        remInt32X4#,
        remInt64X2#,
        remInt8X32#,
        remInt16X16#,
        remInt32X8#,
        remInt64X4#,
        remInt8X64#,
        remInt16X32#,
        remInt32X16#,
        remInt64X8#,
        remWord8X16#,
        remWord16X8#,
        remWord32X4#,
        remWord64X2#,
        remWord8X32#,
        remWord16X16#,
        remWord32X8#,
        remWord64X4#,
        remWord8X64#,
        remWord16X32#,
        remWord32X16#,
        remWord64X8#,
        negateInt8X16#,
        negateInt16X8#,
        negateInt32X4#,
        negateInt64X2#,
        negateInt8X32#,
        negateInt16X16#,
        negateInt32X8#,
        negateInt64X4#,
        negateInt8X64#,
        negateInt16X32#,
        negateInt32X16#,
        negateInt64X8#,
        negateFloatX4#,
        negateDoubleX2#,
        negateFloatX8#,
        negateDoubleX4#,
        negateFloatX16#,
        negateDoubleX8#,
        indexInt8X16Array#,
        indexInt16X8Array#,
        indexInt32X4Array#,
        indexInt64X2Array#,
        indexInt8X32Array#,
        indexInt16X16Array#,
        indexInt32X8Array#,
        indexInt64X4Array#,
        indexInt8X64Array#,
        indexInt16X32Array#,
        indexInt32X16Array#,
        indexInt64X8Array#,
        indexWord8X16Array#,
        indexWord16X8Array#,
        indexWord32X4Array#,
        indexWord64X2Array#,
        indexWord8X32Array#,
        indexWord16X16Array#,
        indexWord32X8Array#,
        indexWord64X4Array#,
        indexWord8X64Array#,
        indexWord16X32Array#,
        indexWord32X16Array#,
        indexWord64X8Array#,
        indexFloatX4Array#,
        indexDoubleX2Array#,
        indexFloatX8Array#,
        indexDoubleX4Array#,
        indexFloatX16Array#,
        indexDoubleX8Array#,
        readInt8X16Array#,
        readInt16X8Array#,
        readInt32X4Array#,
        readInt64X2Array#,
        readInt8X32Array#,
        readInt16X16Array#,
        readInt32X8Array#,
        readInt64X4Array#,
        readInt8X64Array#,
        readInt16X32Array#,
        readInt32X16Array#,
        readInt64X8Array#,
        readWord8X16Array#,
        readWord16X8Array#,
        readWord32X4Array#,
        readWord64X2Array#,
        readWord8X32Array#,
        readWord16X16Array#,
        readWord32X8Array#,
        readWord64X4Array#,
        readWord8X64Array#,
        readWord16X32Array#,
        readWord32X16Array#,
        readWord64X8Array#,
        readFloatX4Array#,
        readDoubleX2Array#,
        readFloatX8Array#,
        readDoubleX4Array#,
        readFloatX16Array#,
        readDoubleX8Array#,
        writeInt8X16Array#,
        writeInt16X8Array#,
        writeInt32X4Array#,
        writeInt64X2Array#,
        writeInt8X32Array#,
        writeInt16X16Array#,
        writeInt32X8Array#,
        writeInt64X4Array#,
        writeInt8X64Array#,
        writeInt16X32Array#,
        writeInt32X16Array#,
        writeInt64X8Array#,
        writeWord8X16Array#,
        writeWord16X8Array#,
        writeWord32X4Array#,
        writeWord64X2Array#,
        writeWord8X32Array#,
        writeWord16X16Array#,
        writeWord32X8Array#,
        writeWord64X4Array#,
        writeWord8X64Array#,
        writeWord16X32Array#,
        writeWord32X16Array#,
        writeWord64X8Array#,
        writeFloatX4Array#,
        writeDoubleX2Array#,
        writeFloatX8Array#,
        writeDoubleX4Array#,
        writeFloatX16Array#,
        writeDoubleX8Array#,
        indexInt8X16OffAddr#,
        indexInt16X8OffAddr#,
        indexInt32X4OffAddr#,
        indexInt64X2OffAddr#,
        indexInt8X32OffAddr#,
        indexInt16X16OffAddr#,
        indexInt32X8OffAddr#,
        indexInt64X4OffAddr#,
        indexInt8X64OffAddr#,
        indexInt16X32OffAddr#,
        indexInt32X16OffAddr#,
        indexInt64X8OffAddr#,
        indexWord8X16OffAddr#,
        indexWord16X8OffAddr#,
        indexWord32X4OffAddr#,
        indexWord64X2OffAddr#,
        indexWord8X32OffAddr#,
        indexWord16X16OffAddr#,
        indexWord32X8OffAddr#,
        indexWord64X4OffAddr#,
        indexWord8X64OffAddr#,
        indexWord16X32OffAddr#,
        indexWord32X16OffAddr#,
        indexWord64X8OffAddr#,
        indexFloatX4OffAddr#,
        indexDoubleX2OffAddr#,
        indexFloatX8OffAddr#,
        indexDoubleX4OffAddr#,
        indexFloatX16OffAddr#,
        indexDoubleX8OffAddr#,
        readInt8X16OffAddr#,
        readInt16X8OffAddr#,
        readInt32X4OffAddr#,
        readInt64X2OffAddr#,
        readInt8X32OffAddr#,
        readInt16X16OffAddr#,
        readInt32X8OffAddr#,
        readInt64X4OffAddr#,
        readInt8X64OffAddr#,
        readInt16X32OffAddr#,
        readInt32X16OffAddr#,
        readInt64X8OffAddr#,
        readWord8X16OffAddr#,
        readWord16X8OffAddr#,
        readWord32X4OffAddr#,
        readWord64X2OffAddr#,
        readWord8X32OffAddr#,
        readWord16X16OffAddr#,
        readWord32X8OffAddr#,
        readWord64X4OffAddr#,
        readWord8X64OffAddr#,
        readWord16X32OffAddr#,
        readWord32X16OffAddr#,
        readWord64X8OffAddr#,
        readFloatX4OffAddr#,
        readDoubleX2OffAddr#,
        readFloatX8OffAddr#,
        readDoubleX4OffAddr#,
        readFloatX16OffAddr#,
        readDoubleX8OffAddr#,
        writeInt8X16OffAddr#,
        writeInt16X8OffAddr#,
        writeInt32X4OffAddr#,
        writeInt64X2OffAddr#,
        writeInt8X32OffAddr#,
        writeInt16X16OffAddr#,
        writeInt32X8OffAddr#,
        writeInt64X4OffAddr#,
        writeInt8X64OffAddr#,
        writeInt16X32OffAddr#,
        writeInt32X16OffAddr#,
        writeInt64X8OffAddr#,
        writeWord8X16OffAddr#,
        writeWord16X8OffAddr#,
        writeWord32X4OffAddr#,
        writeWord64X2OffAddr#,
        writeWord8X32OffAddr#,
        writeWord16X16OffAddr#,
        writeWord32X8OffAddr#,
        writeWord64X4OffAddr#,
        writeWord8X64OffAddr#,
        writeWord16X32OffAddr#,
        writeWord32X16OffAddr#,
        writeWord64X8OffAddr#,
        writeFloatX4OffAddr#,
        writeDoubleX2OffAddr#,
        writeFloatX8OffAddr#,
        writeDoubleX4OffAddr#,
        writeFloatX16OffAddr#,
        writeDoubleX8OffAddr#,
        indexInt8ArrayAsInt8X16#,
        indexInt16ArrayAsInt16X8#,
        indexInt32ArrayAsInt32X4#,
        indexInt64ArrayAsInt64X2#,
        indexInt8ArrayAsInt8X32#,
        indexInt16ArrayAsInt16X16#,
        indexInt32ArrayAsInt32X8#,
        indexInt64ArrayAsInt64X4#,
        indexInt8ArrayAsInt8X64#,
        indexInt16ArrayAsInt16X32#,
        indexInt32ArrayAsInt32X16#,
        indexInt64ArrayAsInt64X8#,
        indexWord8ArrayAsWord8X16#,
        indexWord16ArrayAsWord16X8#,
        indexWord32ArrayAsWord32X4#,
        indexWord64ArrayAsWord64X2#,
        indexWord8ArrayAsWord8X32#,
        indexWord16ArrayAsWord16X16#,
        indexWord32ArrayAsWord32X8#,
        indexWord64ArrayAsWord64X4#,
        indexWord8ArrayAsWord8X64#,
        indexWord16ArrayAsWord16X32#,
        indexWord32ArrayAsWord32X16#,
        indexWord64ArrayAsWord64X8#,
        indexFloatArrayAsFloatX4#,
        indexDoubleArrayAsDoubleX2#,
        indexFloatArrayAsFloatX8#,
        indexDoubleArrayAsDoubleX4#,
        indexFloatArrayAsFloatX16#,
        indexDoubleArrayAsDoubleX8#,
        readInt8ArrayAsInt8X16#,
        readInt16ArrayAsInt16X8#,
        readInt32ArrayAsInt32X4#,
        readInt64ArrayAsInt64X2#,
        readInt8ArrayAsInt8X32#,
        readInt16ArrayAsInt16X16#,
        readInt32ArrayAsInt32X8#,
        readInt64ArrayAsInt64X4#,
        readInt8ArrayAsInt8X64#,
        readInt16ArrayAsInt16X32#,
        readInt32ArrayAsInt32X16#,
        readInt64ArrayAsInt64X8#,
        readWord8ArrayAsWord8X16#,
        readWord16ArrayAsWord16X8#,
        readWord32ArrayAsWord32X4#,
        readWord64ArrayAsWord64X2#,
        readWord8ArrayAsWord8X32#,
        readWord16ArrayAsWord16X16#,
        readWord32ArrayAsWord32X8#,
        readWord64ArrayAsWord64X4#,
        readWord8ArrayAsWord8X64#,
        readWord16ArrayAsWord16X32#,
        readWord32ArrayAsWord32X16#,
        readWord64ArrayAsWord64X8#,
        readFloatArrayAsFloatX4#,
        readDoubleArrayAsDoubleX2#,
        readFloatArrayAsFloatX8#,
        readDoubleArrayAsDoubleX4#,
        readFloatArrayAsFloatX16#,
        readDoubleArrayAsDoubleX8#,
        writeInt8ArrayAsInt8X16#,
        writeInt16ArrayAsInt16X8#,
        writeInt32ArrayAsInt32X4#,
        writeInt64ArrayAsInt64X2#,
        writeInt8ArrayAsInt8X32#,
        writeInt16ArrayAsInt16X16#,
        writeInt32ArrayAsInt32X8#,
        writeInt64ArrayAsInt64X4#,
        writeInt8ArrayAsInt8X64#,
        writeInt16ArrayAsInt16X32#,
        writeInt32ArrayAsInt32X16#,
        writeInt64ArrayAsInt64X8#,
        writeWord8ArrayAsWord8X16#,
        writeWord16ArrayAsWord16X8#,
        writeWord32ArrayAsWord32X4#,
        writeWord64ArrayAsWord64X2#,
        writeWord8ArrayAsWord8X32#,
        writeWord16ArrayAsWord16X16#,
        writeWord32ArrayAsWord32X8#,
        writeWord64ArrayAsWord64X4#,
        writeWord8ArrayAsWord8X64#,
        writeWord16ArrayAsWord16X32#,
        writeWord32ArrayAsWord32X16#,
        writeWord64ArrayAsWord64X8#,
        writeFloatArrayAsFloatX4#,
        writeDoubleArrayAsDoubleX2#,
        writeFloatArrayAsFloatX8#,
        writeDoubleArrayAsDoubleX4#,
        writeFloatArrayAsFloatX16#,
        writeDoubleArrayAsDoubleX8#,
        indexInt8OffAddrAsInt8X16#,
        indexInt16OffAddrAsInt16X8#,
        indexInt32OffAddrAsInt32X4#,
        indexInt64OffAddrAsInt64X2#,
        indexInt8OffAddrAsInt8X32#,
        indexInt16OffAddrAsInt16X16#,
        indexInt32OffAddrAsInt32X8#,
        indexInt64OffAddrAsInt64X4#,
        indexInt8OffAddrAsInt8X64#,
        indexInt16OffAddrAsInt16X32#,
        indexInt32OffAddrAsInt32X16#,
        indexInt64OffAddrAsInt64X8#,
        indexWord8OffAddrAsWord8X16#,
        indexWord16OffAddrAsWord16X8#,
        indexWord32OffAddrAsWord32X4#,
        indexWord64OffAddrAsWord64X2#,
        indexWord8OffAddrAsWord8X32#,
        indexWord16OffAddrAsWord16X16#,
        indexWord32OffAddrAsWord32X8#,
        indexWord64OffAddrAsWord64X4#,
        indexWord8OffAddrAsWord8X64#,
        indexWord16OffAddrAsWord16X32#,
        indexWord32OffAddrAsWord32X16#,
        indexWord64OffAddrAsWord64X8#,
        indexFloatOffAddrAsFloatX4#,
        indexDoubleOffAddrAsDoubleX2#,
        indexFloatOffAddrAsFloatX8#,
        indexDoubleOffAddrAsDoubleX4#,
        indexFloatOffAddrAsFloatX16#,
        indexDoubleOffAddrAsDoubleX8#,
        readInt8OffAddrAsInt8X16#,
        readInt16OffAddrAsInt16X8#,
        readInt32OffAddrAsInt32X4#,
        readInt64OffAddrAsInt64X2#,
        readInt8OffAddrAsInt8X32#,
        readInt16OffAddrAsInt16X16#,
        readInt32OffAddrAsInt32X8#,
        readInt64OffAddrAsInt64X4#,
        readInt8OffAddrAsInt8X64#,
        readInt16OffAddrAsInt16X32#,
        readInt32OffAddrAsInt32X16#,
        readInt64OffAddrAsInt64X8#,
        readWord8OffAddrAsWord8X16#,
        readWord16OffAddrAsWord16X8#,
        readWord32OffAddrAsWord32X4#,
        readWord64OffAddrAsWord64X2#,
        readWord8OffAddrAsWord8X32#,
        readWord16OffAddrAsWord16X16#,
        readWord32OffAddrAsWord32X8#,
        readWord64OffAddrAsWord64X4#,
        readWord8OffAddrAsWord8X64#,
        readWord16OffAddrAsWord16X32#,
        readWord32OffAddrAsWord32X16#,
        readWord64OffAddrAsWord64X8#,
        readFloatOffAddrAsFloatX4#,
        readDoubleOffAddrAsDoubleX2#,
        readFloatOffAddrAsFloatX8#,
        readDoubleOffAddrAsDoubleX4#,
        readFloatOffAddrAsFloatX16#,
        readDoubleOffAddrAsDoubleX8#,
        writeInt8OffAddrAsInt8X16#,
        writeInt16OffAddrAsInt16X8#,
        writeInt32OffAddrAsInt32X4#,
        writeInt64OffAddrAsInt64X2#,
        writeInt8OffAddrAsInt8X32#,
        writeInt16OffAddrAsInt16X16#,
        writeInt32OffAddrAsInt32X8#,
        writeInt64OffAddrAsInt64X4#,
        writeInt8OffAddrAsInt8X64#,
        writeInt16OffAddrAsInt16X32#,
        writeInt32OffAddrAsInt32X16#,
        writeInt64OffAddrAsInt64X8#,
        writeWord8OffAddrAsWord8X16#,
        writeWord16OffAddrAsWord16X8#,
        writeWord32OffAddrAsWord32X4#,
        writeWord64OffAddrAsWord64X2#,
        writeWord8OffAddrAsWord8X32#,
        writeWord16OffAddrAsWord16X16#,
        writeWord32OffAddrAsWord32X8#,
        writeWord64OffAddrAsWord64X4#,
        writeWord8OffAddrAsWord8X64#,
        writeWord16OffAddrAsWord16X32#,
        writeWord32OffAddrAsWord32X16#,
        writeWord64OffAddrAsWord64X8#,
        writeFloatOffAddrAsFloatX4#,
        writeDoubleOffAddrAsDoubleX2#,
        writeFloatOffAddrAsFloatX8#,
        writeDoubleOffAddrAsDoubleX4#,
        writeFloatOffAddrAsFloatX16#,
        writeDoubleOffAddrAsDoubleX8#,
        fmaddFloatX4#,
        fmaddDoubleX2#,
        fmaddFloatX8#,
        fmaddDoubleX4#,
        fmaddFloatX16#,
        fmaddDoubleX8#,
        fmsubFloatX4#,
        fmsubDoubleX2#,
        fmsubFloatX8#,
        fmsubDoubleX4#,
        fmsubFloatX16#,
        fmsubDoubleX8#,
        fnmaddFloatX4#,
        fnmaddDoubleX2#,
        fnmaddFloatX8#,
        fnmaddDoubleX4#,
        fnmaddFloatX16#,
        fnmaddDoubleX8#,
        fnmsubFloatX4#,
        fnmsubDoubleX2#,
        fnmsubFloatX8#,
        fnmsubDoubleX4#,
        fnmsubFloatX16#,
        fnmsubDoubleX8#,
        shuffleInt8X16#,
        shuffleInt16X8#,
        shuffleInt32X4#,
        shuffleInt64X2#,
        shuffleInt8X32#,
        shuffleInt16X16#,
        shuffleInt32X8#,
        shuffleInt64X4#,
        shuffleInt8X64#,
        shuffleInt16X32#,
        shuffleInt32X16#,
        shuffleInt64X8#,
        shuffleWord8X16#,
        shuffleWord16X8#,
        shuffleWord32X4#,
        shuffleWord64X2#,
        shuffleWord8X32#,
        shuffleWord16X16#,
        shuffleWord32X8#,
        shuffleWord64X4#,
        shuffleWord8X64#,
        shuffleWord16X32#,
        shuffleWord32X16#,
        shuffleWord64X8#,
        shuffleFloatX4#,
        shuffleDoubleX2#,
        shuffleFloatX8#,
        shuffleDoubleX4#,
        shuffleFloatX16#,
        shuffleDoubleX8#,
        minInt8X16#,
        minInt16X8#,
        minInt32X4#,
        minInt64X2#,
        minInt8X32#,
        minInt16X16#,
        minInt32X8#,
        minInt64X4#,
        minInt8X64#,
        minInt16X32#,
        minInt32X16#,
        minInt64X8#,
        minWord8X16#,
        minWord16X8#,
        minWord32X4#,
        minWord64X2#,
        minWord8X32#,
        minWord16X16#,
        minWord32X8#,
        minWord64X4#,
        minWord8X64#,
        minWord16X32#,
        minWord32X16#,
        minWord64X8#,
        minFloatX4#,
        minDoubleX2#,
        minFloatX8#,
        minDoubleX4#,
        minFloatX16#,
        minDoubleX8#,
        maxInt8X16#,
        maxInt16X8#,
        maxInt32X4#,
        maxInt64X2#,
        maxInt8X32#,
        maxInt16X16#,
        maxInt32X8#,
        maxInt64X4#,
        maxInt8X64#,
        maxInt16X32#,
        maxInt32X16#,
        maxInt64X8#,
        maxWord8X16#,
        maxWord16X8#,
        maxWord32X4#,
        maxWord64X2#,
        maxWord8X32#,
        maxWord16X16#,
        maxWord32X8#,
        maxWord64X4#,
        maxWord8X64#,
        maxWord16X32#,
        maxWord32X16#,
        maxWord64X8#,
        maxFloatX4#,
        maxDoubleX2#,
        maxFloatX8#,
        maxDoubleX4#,
        maxFloatX16#,
        maxDoubleX8#,
        
{- * Prefetch-}
{-|Prefetch operations: Note how every prefetch operation has a name
  with the pattern prefetch*N#, where N is either 0,1,2, or 3.

  This suffix number, N, is the "locality level" of the prefetch, following the
  convention in GCC and other compilers.
  Higher locality numbers correspond to the memory being loaded in more
  levels of the cpu cache, and being retained after initial use. The naming
  convention follows the naming convention of the prefetch intrinsic found
  in the GCC and Clang C compilers.

  On the LLVM backend, prefetch*N# uses the LLVM prefetch intrinsic
  with locality level N. The code generated by LLVM is target architecture
  dependent, but should agree with the GHC NCG on x86 systems.

  On the PPC native backend, prefetch*N is a No-Op.

  On the x86 NCG, N=0 will generate prefetchNTA,
  N=1 generates prefetcht2, N=2 generates prefetcht1, and
  N=3 generates prefetcht0.

  For streaming workloads, the prefetch*0 operations are recommended.
  For workloads which do many reads or writes to a memory location in a short period of time,
  prefetch*3 operations are recommended.

  For further reading about prefetch and associated systems performance optimization,
  the instruction set and optimization manuals by Intel and other CPU vendors are
  excellent starting place.


  The "Intel 64 and IA-32 Architectures Optimization Reference Manual" is
  especially a helpful read, even if your software is meant for other CPU
  architectures or vendor hardware. The manual can be found at
  http://www.intel.com/content/www/us/en/architecture-and-technology/64-ia-32-architectures-optimization-manual.html .

  The @prefetch*@ family of operations has the order of operations
  determined by passing around the 'State#' token.

  To get a "pure" version of these operations, use 'inlinePerformIO' which is quite safe in this context.

  It is important to note that while the prefetch operations will never change the
  answer to a pure computation, They CAN change the memory locations resident
  in a CPU cache and that may change the performance and timing characteristics
  of an application. The prefetch operations are marked as ReadWriteEffect
  to reflect that these operations have side effects with respect to the runtime
  performance characteristics of the resulting code. Additionally, if the prefetchValue
  operations did not have this attribute, GHC does a float out transformation that
  results in a let-can-float invariant violation, at least with the current design.
  -}
        prefetchByteArray3#,
        prefetchMutableByteArray3#,
        prefetchAddr3#,
        prefetchValue3#,
        prefetchByteArray2#,
        prefetchMutableByteArray2#,
        prefetchAddr2#,
        prefetchValue2#,
        prefetchByteArray1#,
        prefetchMutableByteArray1#,
        prefetchAddr1#,
        prefetchValue1#,
        prefetchByteArray0#,
        prefetchMutableByteArray0#,
        prefetchAddr0#,
        prefetchValue0#,
        
{- * RuntimeRep polymorphism in continuation-style primops-}
{-|
  Several primops provided by GHC accept continuation arguments with highly polymorphic
  arguments. For instance, consider the type of `catch#`:

    catch# :: forall (r_rep :: RuntimeRep) (r :: TYPE r_rep) w.
              (State# RealWorld -> (# State# RealWorld, r #) )
           -> (w -> State# RealWorld -> (# State# RealWorld, r #) )
           -> State# RealWorld
           -> (# State# RealWorld, r #)

  This type suggests that we could instantiate `catch#` continuation argument
  (namely, the first argument) with something like,

    f :: State# RealWorld -> (# State# RealWorld, (# Int, String, Int8# #) #)

  However, sadly the type does not capture an important limitation of the
  primop. Specifically, due to the operational behavior of `catch#` the result
  type must be representable with a single machine word. In a future GHC
  release we may improve the precision of this type to capture this limitation.

  See #21868.
  -}
) where

{-
effect = NoEffect
can_fail_warning = WarnIfEffectIsCanFail
out_of_line = False
commutable = False
code_size = {  primOpCodeSizeDefault }
work_free = {  primOpCodeSize _thisOp == 0 }
cheap = {  primOpOkForSpeculation _thisOp }
strictness = {  \ arity -> mkClosedDmdSig (replicate arity topDmd) topDiv }
fixity = Nothing

deprecated_msg = { }
div_like = False
defined_bits = Nothing
-}
default ()

data Char#

gtChar# :: Char# -> Char# -> Int#
gtChar# = gtChar#

geChar# :: Char# -> Char# -> Int#
geChar# = geChar#

eqChar# :: Char# -> Char# -> Int#
eqChar# = eqChar#

neChar# :: Char# -> Char# -> Int#
neChar# = neChar#

ltChar# :: Char# -> Char# -> Int#
ltChar# = ltChar#

leChar# :: Char# -> Char# -> Int#
leChar# = leChar#

ord# :: Char# -> Int#
ord# = ord#

data Int8#

int8ToInt# :: Int8# -> Int#
int8ToInt# = int8ToInt#

intToInt8# :: Int# -> Int8#
intToInt8# = intToInt8#

negateInt8# :: Int8# -> Int8#
negateInt8# = negateInt8#

plusInt8# :: Int8# -> Int8# -> Int8#
plusInt8# = plusInt8#

subInt8# :: Int8# -> Int8# -> Int8#
subInt8# = subInt8#

timesInt8# :: Int8# -> Int8# -> Int8#
timesInt8# = timesInt8#

quotInt8# :: Int8# -> Int8# -> Int8#
quotInt8# = quotInt8#

remInt8# :: Int8# -> Int8# -> Int8#
remInt8# = remInt8#

quotRemInt8# :: Int8# -> Int8# -> (# Int8#,Int8# #)
quotRemInt8# = quotRemInt8#

uncheckedShiftLInt8# :: Int8# -> Int# -> Int8#
uncheckedShiftLInt8# = uncheckedShiftLInt8#

uncheckedShiftRAInt8# :: Int8# -> Int# -> Int8#
uncheckedShiftRAInt8# = uncheckedShiftRAInt8#

uncheckedShiftRLInt8# :: Int8# -> Int# -> Int8#
uncheckedShiftRLInt8# = uncheckedShiftRLInt8#

int8ToWord8# :: Int8# -> Word8#
int8ToWord8# = int8ToWord8#

eqInt8# :: Int8# -> Int8# -> Int#
eqInt8# = eqInt8#

geInt8# :: Int8# -> Int8# -> Int#
geInt8# = geInt8#

gtInt8# :: Int8# -> Int8# -> Int#
gtInt8# = gtInt8#

leInt8# :: Int8# -> Int8# -> Int#
leInt8# = leInt8#

ltInt8# :: Int8# -> Int8# -> Int#
ltInt8# = ltInt8#

neInt8# :: Int8# -> Int8# -> Int#
neInt8# = neInt8#

data Word8#

word8ToWord# :: Word8# -> Word#
word8ToWord# = word8ToWord#

wordToWord8# :: Word# -> Word8#
wordToWord8# = wordToWord8#

plusWord8# :: Word8# -> Word8# -> Word8#
plusWord8# = plusWord8#

subWord8# :: Word8# -> Word8# -> Word8#
subWord8# = subWord8#

timesWord8# :: Word8# -> Word8# -> Word8#
timesWord8# = timesWord8#

quotWord8# :: Word8# -> Word8# -> Word8#
quotWord8# = quotWord8#

remWord8# :: Word8# -> Word8# -> Word8#
remWord8# = remWord8#

quotRemWord8# :: Word8# -> Word8# -> (# Word8#,Word8# #)
quotRemWord8# = quotRemWord8#

andWord8# :: Word8# -> Word8# -> Word8#
andWord8# = andWord8#

orWord8# :: Word8# -> Word8# -> Word8#
orWord8# = orWord8#

xorWord8# :: Word8# -> Word8# -> Word8#
xorWord8# = xorWord8#

notWord8# :: Word8# -> Word8#
notWord8# = notWord8#

uncheckedShiftLWord8# :: Word8# -> Int# -> Word8#
uncheckedShiftLWord8# = uncheckedShiftLWord8#

uncheckedShiftRLWord8# :: Word8# -> Int# -> Word8#
uncheckedShiftRLWord8# = uncheckedShiftRLWord8#

word8ToInt8# :: Word8# -> Int8#
word8ToInt8# = word8ToInt8#

eqWord8# :: Word8# -> Word8# -> Int#
eqWord8# = eqWord8#

geWord8# :: Word8# -> Word8# -> Int#
geWord8# = geWord8#

gtWord8# :: Word8# -> Word8# -> Int#
gtWord8# = gtWord8#

leWord8# :: Word8# -> Word8# -> Int#
leWord8# = leWord8#

ltWord8# :: Word8# -> Word8# -> Int#
ltWord8# = ltWord8#

neWord8# :: Word8# -> Word8# -> Int#
neWord8# = neWord8#

data Int16#

int16ToInt# :: Int16# -> Int#
int16ToInt# = int16ToInt#

intToInt16# :: Int# -> Int16#
intToInt16# = intToInt16#

negateInt16# :: Int16# -> Int16#
negateInt16# = negateInt16#

plusInt16# :: Int16# -> Int16# -> Int16#
plusInt16# = plusInt16#

subInt16# :: Int16# -> Int16# -> Int16#
subInt16# = subInt16#

timesInt16# :: Int16# -> Int16# -> Int16#
timesInt16# = timesInt16#

quotInt16# :: Int16# -> Int16# -> Int16#
quotInt16# = quotInt16#

remInt16# :: Int16# -> Int16# -> Int16#
remInt16# = remInt16#

quotRemInt16# :: Int16# -> Int16# -> (# Int16#,Int16# #)
quotRemInt16# = quotRemInt16#

uncheckedShiftLInt16# :: Int16# -> Int# -> Int16#
uncheckedShiftLInt16# = uncheckedShiftLInt16#

uncheckedShiftRAInt16# :: Int16# -> Int# -> Int16#
uncheckedShiftRAInt16# = uncheckedShiftRAInt16#

uncheckedShiftRLInt16# :: Int16# -> Int# -> Int16#
uncheckedShiftRLInt16# = uncheckedShiftRLInt16#

int16ToWord16# :: Int16# -> Word16#
int16ToWord16# = int16ToWord16#

eqInt16# :: Int16# -> Int16# -> Int#
eqInt16# = eqInt16#

geInt16# :: Int16# -> Int16# -> Int#
geInt16# = geInt16#

gtInt16# :: Int16# -> Int16# -> Int#
gtInt16# = gtInt16#

leInt16# :: Int16# -> Int16# -> Int#
leInt16# = leInt16#

ltInt16# :: Int16# -> Int16# -> Int#
ltInt16# = ltInt16#

neInt16# :: Int16# -> Int16# -> Int#
neInt16# = neInt16#

data Word16#

word16ToWord# :: Word16# -> Word#
word16ToWord# = word16ToWord#

wordToWord16# :: Word# -> Word16#
wordToWord16# = wordToWord16#

plusWord16# :: Word16# -> Word16# -> Word16#
plusWord16# = plusWord16#

subWord16# :: Word16# -> Word16# -> Word16#
subWord16# = subWord16#

timesWord16# :: Word16# -> Word16# -> Word16#
timesWord16# = timesWord16#

quotWord16# :: Word16# -> Word16# -> Word16#
quotWord16# = quotWord16#

remWord16# :: Word16# -> Word16# -> Word16#
remWord16# = remWord16#

quotRemWord16# :: Word16# -> Word16# -> (# Word16#,Word16# #)
quotRemWord16# = quotRemWord16#

andWord16# :: Word16# -> Word16# -> Word16#
andWord16# = andWord16#

orWord16# :: Word16# -> Word16# -> Word16#
orWord16# = orWord16#

xorWord16# :: Word16# -> Word16# -> Word16#
xorWord16# = xorWord16#

notWord16# :: Word16# -> Word16#
notWord16# = notWord16#

uncheckedShiftLWord16# :: Word16# -> Int# -> Word16#
uncheckedShiftLWord16# = uncheckedShiftLWord16#

uncheckedShiftRLWord16# :: Word16# -> Int# -> Word16#
uncheckedShiftRLWord16# = uncheckedShiftRLWord16#

word16ToInt16# :: Word16# -> Int16#
word16ToInt16# = word16ToInt16#

eqWord16# :: Word16# -> Word16# -> Int#
eqWord16# = eqWord16#

geWord16# :: Word16# -> Word16# -> Int#
geWord16# = geWord16#

gtWord16# :: Word16# -> Word16# -> Int#
gtWord16# = gtWord16#

leWord16# :: Word16# -> Word16# -> Int#
leWord16# = leWord16#

ltWord16# :: Word16# -> Word16# -> Int#
ltWord16# = ltWord16#

neWord16# :: Word16# -> Word16# -> Int#
neWord16# = neWord16#

data Int32#

int32ToInt# :: Int32# -> Int#
int32ToInt# = int32ToInt#

intToInt32# :: Int# -> Int32#
intToInt32# = intToInt32#

negateInt32# :: Int32# -> Int32#
negateInt32# = negateInt32#

plusInt32# :: Int32# -> Int32# -> Int32#
plusInt32# = plusInt32#

subInt32# :: Int32# -> Int32# -> Int32#
subInt32# = subInt32#

timesInt32# :: Int32# -> Int32# -> Int32#
timesInt32# = timesInt32#

quotInt32# :: Int32# -> Int32# -> Int32#
quotInt32# = quotInt32#

remInt32# :: Int32# -> Int32# -> Int32#
remInt32# = remInt32#

quotRemInt32# :: Int32# -> Int32# -> (# Int32#,Int32# #)
quotRemInt32# = quotRemInt32#

uncheckedShiftLInt32# :: Int32# -> Int# -> Int32#
uncheckedShiftLInt32# = uncheckedShiftLInt32#

uncheckedShiftRAInt32# :: Int32# -> Int# -> Int32#
uncheckedShiftRAInt32# = uncheckedShiftRAInt32#

uncheckedShiftRLInt32# :: Int32# -> Int# -> Int32#
uncheckedShiftRLInt32# = uncheckedShiftRLInt32#

int32ToWord32# :: Int32# -> Word32#
int32ToWord32# = int32ToWord32#

eqInt32# :: Int32# -> Int32# -> Int#
eqInt32# = eqInt32#

geInt32# :: Int32# -> Int32# -> Int#
geInt32# = geInt32#

gtInt32# :: Int32# -> Int32# -> Int#
gtInt32# = gtInt32#

leInt32# :: Int32# -> Int32# -> Int#
leInt32# = leInt32#

ltInt32# :: Int32# -> Int32# -> Int#
ltInt32# = ltInt32#

neInt32# :: Int32# -> Int32# -> Int#
neInt32# = neInt32#

data Word32#

word32ToWord# :: Word32# -> Word#
word32ToWord# = word32ToWord#

wordToWord32# :: Word# -> Word32#
wordToWord32# = wordToWord32#

plusWord32# :: Word32# -> Word32# -> Word32#
plusWord32# = plusWord32#

subWord32# :: Word32# -> Word32# -> Word32#
subWord32# = subWord32#

timesWord32# :: Word32# -> Word32# -> Word32#
timesWord32# = timesWord32#

quotWord32# :: Word32# -> Word32# -> Word32#
quotWord32# = quotWord32#

remWord32# :: Word32# -> Word32# -> Word32#
remWord32# = remWord32#

quotRemWord32# :: Word32# -> Word32# -> (# Word32#,Word32# #)
quotRemWord32# = quotRemWord32#

andWord32# :: Word32# -> Word32# -> Word32#
andWord32# = andWord32#

orWord32# :: Word32# -> Word32# -> Word32#
orWord32# = orWord32#

xorWord32# :: Word32# -> Word32# -> Word32#
xorWord32# = xorWord32#

notWord32# :: Word32# -> Word32#
notWord32# = notWord32#

uncheckedShiftLWord32# :: Word32# -> Int# -> Word32#
uncheckedShiftLWord32# = uncheckedShiftLWord32#

uncheckedShiftRLWord32# :: Word32# -> Int# -> Word32#
uncheckedShiftRLWord32# = uncheckedShiftRLWord32#

word32ToInt32# :: Word32# -> Int32#
word32ToInt32# = word32ToInt32#

eqWord32# :: Word32# -> Word32# -> Int#
eqWord32# = eqWord32#

geWord32# :: Word32# -> Word32# -> Int#
geWord32# = geWord32#

gtWord32# :: Word32# -> Word32# -> Int#
gtWord32# = gtWord32#

leWord32# :: Word32# -> Word32# -> Int#
leWord32# = leWord32#

ltWord32# :: Word32# -> Word32# -> Int#
ltWord32# = ltWord32#

neWord32# :: Word32# -> Word32# -> Int#
neWord32# = neWord32#

data Int64#

int64ToInt# :: Int64# -> Int#
int64ToInt# = int64ToInt#

intToInt64# :: Int# -> Int64#
intToInt64# = intToInt64#

negateInt64# :: Int64# -> Int64#
negateInt64# = negateInt64#

plusInt64# :: Int64# -> Int64# -> Int64#
plusInt64# = plusInt64#

subInt64# :: Int64# -> Int64# -> Int64#
subInt64# = subInt64#

timesInt64# :: Int64# -> Int64# -> Int64#
timesInt64# = timesInt64#

quotInt64# :: Int64# -> Int64# -> Int64#
quotInt64# = quotInt64#

remInt64# :: Int64# -> Int64# -> Int64#
remInt64# = remInt64#

uncheckedIShiftL64# :: Int64# -> Int# -> Int64#
uncheckedIShiftL64# = uncheckedIShiftL64#

uncheckedIShiftRA64# :: Int64# -> Int# -> Int64#
uncheckedIShiftRA64# = uncheckedIShiftRA64#

uncheckedIShiftRL64# :: Int64# -> Int# -> Int64#
uncheckedIShiftRL64# = uncheckedIShiftRL64#

int64ToWord64# :: Int64# -> Word64#
int64ToWord64# = int64ToWord64#

eqInt64# :: Int64# -> Int64# -> Int#
eqInt64# = eqInt64#

geInt64# :: Int64# -> Int64# -> Int#
geInt64# = geInt64#

gtInt64# :: Int64# -> Int64# -> Int#
gtInt64# = gtInt64#

leInt64# :: Int64# -> Int64# -> Int#
leInt64# = leInt64#

ltInt64# :: Int64# -> Int64# -> Int#
ltInt64# = ltInt64#

neInt64# :: Int64# -> Int64# -> Int#
neInt64# = neInt64#

data Word64#

word64ToWord# :: Word64# -> Word#
word64ToWord# = word64ToWord#

wordToWord64# :: Word# -> Word64#
wordToWord64# = wordToWord64#

plusWord64# :: Word64# -> Word64# -> Word64#
plusWord64# = plusWord64#

subWord64# :: Word64# -> Word64# -> Word64#
subWord64# = subWord64#

timesWord64# :: Word64# -> Word64# -> Word64#
timesWord64# = timesWord64#

quotWord64# :: Word64# -> Word64# -> Word64#
quotWord64# = quotWord64#

remWord64# :: Word64# -> Word64# -> Word64#
remWord64# = remWord64#

and64# :: Word64# -> Word64# -> Word64#
and64# = and64#

or64# :: Word64# -> Word64# -> Word64#
or64# = or64#

xor64# :: Word64# -> Word64# -> Word64#
xor64# = xor64#

not64# :: Word64# -> Word64#
not64# = not64#

uncheckedShiftL64# :: Word64# -> Int# -> Word64#
uncheckedShiftL64# = uncheckedShiftL64#

uncheckedShiftRL64# :: Word64# -> Int# -> Word64#
uncheckedShiftRL64# = uncheckedShiftRL64#

word64ToInt64# :: Word64# -> Int64#
word64ToInt64# = word64ToInt64#

eqWord64# :: Word64# -> Word64# -> Int#
eqWord64# = eqWord64#

geWord64# :: Word64# -> Word64# -> Int#
geWord64# = geWord64#

gtWord64# :: Word64# -> Word64# -> Int#
gtWord64# = gtWord64#

leWord64# :: Word64# -> Word64# -> Int#
leWord64# = leWord64#

ltWord64# :: Word64# -> Word64# -> Int#
ltWord64# = ltWord64#

neWord64# :: Word64# -> Word64# -> Int#
neWord64# = neWord64#

data Int#

infixl 6 +#
(+#) :: Int# -> Int# -> Int#
(+#) = (+#)

infixl 6 -#
(-#) :: Int# -> Int# -> Int#
(-#) = (-#)

{-|Low word of signed integer multiply.-}
infixl 7 *#
(*#) :: Int# -> Int# -> Int#
(*#) = (*#)

{-|Return a triple (isHighNeeded,high,low) where high and low are respectively
   the high and low bits of the double-word result. isHighNeeded is a cheap way
   to test if the high word is a sign-extension of the low word (isHighNeeded =
   0#) or not (isHighNeeded = 1#).-}
timesInt2# :: Int# -> Int# -> (# Int#,Int#,Int# #)
timesInt2# = timesInt2#

{-|Return non-zero if there is any possibility that the upper word of a
    signed integer multiply might contain useful information.  Return
    zero only if you are completely sure that no overflow can occur.
    On a 32-bit platform, the recommended implementation is to do a
    32 x 32 -> 64 signed multiply, and subtract result[63:32] from
    (result[31] >>signed 31).  If this is zero, meaning that the
    upper word is merely a sign extension of the lower one, no
    overflow can occur.

    On a 64-bit platform it is not always possible to
    acquire the top 64 bits of the result.  Therefore, a recommended
    implementation is to take the absolute value of both operands, and
    return 0 iff bits[63:31] of them are zero, since that means that their
    magnitudes fit within 31 bits, so the magnitude of the product must fit
    into 62 bits.

    If in doubt, return non-zero, but do make an effort to create the
    correct answer for small args, since otherwise the performance of
    @(*) :: Integer -> Integer -> Integer@ will be poor.
   -}
mulIntMayOflo# :: Int# -> Int# -> Int#
mulIntMayOflo# = mulIntMayOflo#

{-|Rounds towards zero. The behavior is undefined if the second argument is
    zero.
   -}
quotInt# :: Int# -> Int# -> Int#
quotInt# = quotInt#

{-|Satisfies @('quotInt#' x y) '*#' y '+#' ('remInt#' x y) == x@. The
    behavior is undefined if the second argument is zero.
   -}
remInt# :: Int# -> Int# -> Int#
remInt# = remInt#

{-|Rounds towards zero.-}
quotRemInt# :: Int# -> Int# -> (# Int#,Int# #)
quotRemInt# = quotRemInt#

{-|Bitwise "and".-}
andI# :: Int# -> Int# -> Int#
andI# = andI#

{-|Bitwise "or".-}
orI# :: Int# -> Int# -> Int#
orI# = orI#

{-|Bitwise "xor".-}
xorI# :: Int# -> Int# -> Int#
xorI# = xorI#

{-|Bitwise "not", also known as the binary complement.-}
notI# :: Int# -> Int#
notI# = notI#

{-|Unary negation.
    Since the negative 'Int#' range extends one further than the
    positive range, 'negateInt#' of the most negative number is an
    identity operation. This way, 'negateInt#' is always its own inverse.-}
negateInt# :: Int# -> Int#
negateInt# = negateInt#

{-|Add signed integers reporting overflow.
          First member of result is the sum truncated to an 'Int#';
          second member is zero if the true sum fits in an 'Int#',
          nonzero if overflow occurred (the sum is either too large
          or too small to fit in an 'Int#').-}
addIntC# :: Int# -> Int# -> (# Int#,Int# #)
addIntC# = addIntC#

{-|Subtract signed integers reporting overflow.
          First member of result is the difference truncated to an 'Int#';
          second member is zero if the true difference fits in an 'Int#',
          nonzero if overflow occurred (the difference is either too large
          or too small to fit in an 'Int#').-}
subIntC# :: Int# -> Int# -> (# Int#,Int# #)
subIntC# = subIntC#

infix 4 >#
(>#) :: Int# -> Int# -> Int#
(>#) = (>#)

infix 4 >=#
(>=#) :: Int# -> Int# -> Int#
(>=#) = (>=#)

infix 4 ==#
(==#) :: Int# -> Int# -> Int#
(==#) = (==#)

infix 4 /=#
(/=#) :: Int# -> Int# -> Int#
(/=#) = (/=#)

infix 4 <#
(<#) :: Int# -> Int# -> Int#
(<#) = (<#)

infix 4 <=#
(<=#) :: Int# -> Int# -> Int#
(<=#) = (<=#)

chr# :: Int# -> Char#
chr# = chr#

int2Word# :: Int# -> Word#
int2Word# = int2Word#

{-|Convert an 'Int#' to the corresponding 'Float#' with the same
    integral value (up to truncation due to floating-point precision). e.g.
    @'int2Float#' 1# == 1.0#@-}
int2Float# :: Int# -> Float#
int2Float# = int2Float#

{-|Convert an 'Int#' to the corresponding 'Double#' with the same
    integral value (up to truncation due to floating-point precision). e.g.
    @'int2Double#' 1# == 1.0##@-}
int2Double# :: Int# -> Double#
int2Double# = int2Double#

{-|Convert an 'Word#' to the corresponding 'Float#' with the same
    integral value (up to truncation due to floating-point precision). e.g.
    @'word2Float#' 1## == 1.0#@-}
word2Float# :: Word# -> Float#
word2Float# = word2Float#

{-|Convert an 'Word#' to the corresponding 'Double#' with the same
    integral value (up to truncation due to floating-point precision). e.g.
    @'word2Double#' 1## == 1.0##@-}
word2Double# :: Word# -> Double#
word2Double# = word2Double#

{-|Shift left.  Result undefined if shift amount is not
          in the range 0 to word size - 1 inclusive.-}
uncheckedIShiftL# :: Int# -> Int# -> Int#
uncheckedIShiftL# = uncheckedIShiftL#

{-|Shift right arithmetic.  Result undefined if shift amount is not
          in the range 0 to word size - 1 inclusive.-}
uncheckedIShiftRA# :: Int# -> Int# -> Int#
uncheckedIShiftRA# = uncheckedIShiftRA#

{-|Shift right logical.  Result undefined if shift amount is not
          in the range 0 to word size - 1 inclusive.-}
uncheckedIShiftRL# :: Int# -> Int# -> Int#
uncheckedIShiftRL# = uncheckedIShiftRL#

data Word#

plusWord# :: Word# -> Word# -> Word#
plusWord# = plusWord#

{-|Add unsigned integers reporting overflow.
          The first element of the pair is the result.  The second element is
          the carry flag, which is nonzero on overflow. See also 'plusWord2#'.-}
addWordC# :: Word# -> Word# -> (# Word#,Int# #)
addWordC# = addWordC#

{-|Subtract unsigned integers reporting overflow.
          The first element of the pair is the result.  The second element is
          the carry flag, which is nonzero on overflow.-}
subWordC# :: Word# -> Word# -> (# Word#,Int# #)
subWordC# = subWordC#

{-|Add unsigned integers, with the high part (carry) in the first
          component of the returned pair and the low part in the second
          component of the pair. See also 'addWordC#'.-}
plusWord2# :: Word# -> Word# -> (# Word#,Word# #)
plusWord2# = plusWord2#

minusWord# :: Word# -> Word# -> Word#
minusWord# = minusWord#

timesWord# :: Word# -> Word# -> Word#
timesWord# = timesWord#

timesWord2# :: Word# -> Word# -> (# Word#,Word# #)
timesWord2# = timesWord2#

quotWord# :: Word# -> Word# -> Word#
quotWord# = quotWord#

remWord# :: Word# -> Word# -> Word#
remWord# = remWord#

quotRemWord# :: Word# -> Word# -> (# Word#,Word# #)
quotRemWord# = quotRemWord#

{-| Takes high word of dividend, then low word of dividend, then divisor.
           Requires that high word < divisor.-}
quotRemWord2# :: Word# -> Word# -> Word# -> (# Word#,Word# #)
quotRemWord2# = quotRemWord2#

and# :: Word# -> Word# -> Word#
and# = and#

or# :: Word# -> Word# -> Word#
or# = or#

xor# :: Word# -> Word# -> Word#
xor# = xor#

not# :: Word# -> Word#
not# = not#

{-|Shift left logical.   Result undefined if shift amount is not
          in the range 0 to word size - 1 inclusive.-}
uncheckedShiftL# :: Word# -> Int# -> Word#
uncheckedShiftL# = uncheckedShiftL#

{-|Shift right logical.   Result undefined if shift  amount is not
          in the range 0 to word size - 1 inclusive.-}
uncheckedShiftRL# :: Word# -> Int# -> Word#
uncheckedShiftRL# = uncheckedShiftRL#

word2Int# :: Word# -> Int#
word2Int# = word2Int#

gtWord# :: Word# -> Word# -> Int#
gtWord# = gtWord#

geWord# :: Word# -> Word# -> Int#
geWord# = geWord#

eqWord# :: Word# -> Word# -> Int#
eqWord# = eqWord#

neWord# :: Word# -> Word# -> Int#
neWord# = neWord#

ltWord# :: Word# -> Word# -> Int#
ltWord# = ltWord#

leWord# :: Word# -> Word# -> Int#
leWord# = leWord#

{-|Count the number of set bits in the lower 8 bits of a word.-}
popCnt8# :: Word# -> Word#
popCnt8# = popCnt8#

{-|Count the number of set bits in the lower 16 bits of a word.-}
popCnt16# :: Word# -> Word#
popCnt16# = popCnt16#

{-|Count the number of set bits in the lower 32 bits of a word.-}
popCnt32# :: Word# -> Word#
popCnt32# = popCnt32#

{-|Count the number of set bits in a 64-bit word.-}
popCnt64# :: Word64# -> Word#
popCnt64# = popCnt64#

{-|Count the number of set bits in a word.-}
popCnt# :: Word# -> Word#
popCnt# = popCnt#

{-|Deposit bits to lower 8 bits of a word at locations specified by a mask.

    @since 0.5.2.0-}
pdep8# :: Word# -> Word# -> Word#
pdep8# = pdep8#

{-|Deposit bits to lower 16 bits of a word at locations specified by a mask.

    @since 0.5.2.0-}
pdep16# :: Word# -> Word# -> Word#
pdep16# = pdep16#

{-|Deposit bits to lower 32 bits of a word at locations specified by a mask.

    @since 0.5.2.0-}
pdep32# :: Word# -> Word# -> Word#
pdep32# = pdep32#

{-|Deposit bits to a word at locations specified by a mask.

    @since 0.5.2.0-}
pdep64# :: Word64# -> Word64# -> Word64#
pdep64# = pdep64#

{-|Deposit bits to a word at locations specified by a mask, aka
    [parallel bit deposit](https://en.wikipedia.org/wiki/Bit_Manipulation_Instruction_Sets#Parallel_bit_deposit_and_extract).

    Software emulation:

    > pdep :: Word -> Word -> Word
    > pdep src mask = go 0 src mask
    >   where
    >     go :: Word -> Word -> Word -> Word
    >     go result _ 0 = result
    >     go result src mask = go newResult newSrc newMask
    >       where
    >         maskCtz   = countTrailingZeros mask
    >         newResult = if testBit src 0 then setBit result maskCtz else result
    >         newSrc    = src `shiftR` 1
    >         newMask   = clearBit mask maskCtz

    @since 0.5.2.0-}
pdep# :: Word# -> Word# -> Word#
pdep# = pdep#

{-|Extract bits from lower 8 bits of a word at locations specified by a mask.

    @since 0.5.2.0-}
pext8# :: Word# -> Word# -> Word#
pext8# = pext8#

{-|Extract bits from lower 16 bits of a word at locations specified by a mask.

    @since 0.5.2.0-}
pext16# :: Word# -> Word# -> Word#
pext16# = pext16#

{-|Extract bits from lower 32 bits of a word at locations specified by a mask.

    @since 0.5.2.0-}
pext32# :: Word# -> Word# -> Word#
pext32# = pext32#

{-|Extract bits from a word at locations specified by a mask.

    @since 0.5.2.0-}
pext64# :: Word64# -> Word64# -> Word64#
pext64# = pext64#

{-|Extract bits from a word at locations specified by a mask, aka
    [parallel bit extract](https://en.wikipedia.org/wiki/Bit_Manipulation_Instruction_Sets#Parallel_bit_deposit_and_extract).

    Software emulation:

    > pext :: Word -> Word -> Word
    > pext src mask = loop 0 0 0
    >   where
    >     loop i count result
    >       | i >= finiteBitSize (0 :: Word)
    >       = result
    >       | testBit mask i
    >       = loop (i + 1) (count + 1) (if testBit src i then setBit result count else result)
    >       | otherwise
    >       = loop (i + 1) count result

    @since 0.5.2.0-}
pext# :: Word# -> Word# -> Word#
pext# = pext#

{-|Count leading zeros in the lower 8 bits of a word.-}
clz8# :: Word# -> Word#
clz8# = clz8#

{-|Count leading zeros in the lower 16 bits of a word.-}
clz16# :: Word# -> Word#
clz16# = clz16#

{-|Count leading zeros in the lower 32 bits of a word.-}
clz32# :: Word# -> Word#
clz32# = clz32#

{-|Count leading zeros in a 64-bit word.-}
clz64# :: Word64# -> Word#
clz64# = clz64#

{-|Count leading zeros in a word.-}
clz# :: Word# -> Word#
clz# = clz#

{-|Count trailing zeros in the lower 8 bits of a word.-}
ctz8# :: Word# -> Word#
ctz8# = ctz8#

{-|Count trailing zeros in the lower 16 bits of a word.-}
ctz16# :: Word# -> Word#
ctz16# = ctz16#

{-|Count trailing zeros in the lower 32 bits of a word.-}
ctz32# :: Word# -> Word#
ctz32# = ctz32#

{-|Count trailing zeros in a 64-bit word.-}
ctz64# :: Word64# -> Word#
ctz64# = ctz64#

{-|Count trailing zeros in a word.-}
ctz# :: Word# -> Word#
ctz# = ctz#

{-|Swap bytes in the lower 16 bits of a word. The higher bytes are undefined. -}
byteSwap16# :: Word# -> Word#
byteSwap16# = byteSwap16#

{-|Swap bytes in the lower 32 bits of a word. The higher bytes are undefined. -}
byteSwap32# :: Word# -> Word#
byteSwap32# = byteSwap32#

{-|Swap bytes in a 64 bits of a word.-}
byteSwap64# :: Word64# -> Word64#
byteSwap64# = byteSwap64#

{-|Swap bytes in a word.-}
byteSwap# :: Word# -> Word#
byteSwap# = byteSwap#

{-|Reverse the order of the bits in a 8-bit word.-}
bitReverse8# :: Word# -> Word#
bitReverse8# = bitReverse8#

{-|Reverse the order of the bits in a 16-bit word.-}
bitReverse16# :: Word# -> Word#
bitReverse16# = bitReverse16#

{-|Reverse the order of the bits in a 32-bit word.-}
bitReverse32# :: Word# -> Word#
bitReverse32# = bitReverse32#

{-|Reverse the order of the bits in a 64-bit word.-}
bitReverse64# :: Word64# -> Word64#
bitReverse64# = bitReverse64#

{-|Reverse the order of the bits in a word.-}
bitReverse# :: Word# -> Word#
bitReverse# = bitReverse#

narrow8Int# :: Int# -> Int#
narrow8Int# = narrow8Int#

narrow16Int# :: Int# -> Int#
narrow16Int# = narrow16Int#

narrow32Int# :: Int# -> Int#
narrow32Int# = narrow32Int#

narrow8Word# :: Word# -> Word#
narrow8Word# = narrow8Word#

narrow16Word# :: Word# -> Word#
narrow16Word# = narrow16Word#

narrow32Word# :: Word# -> Word#
narrow32Word# = narrow32Word#

data Double#

infix 4 >##
(>##) :: Double# -> Double# -> Int#
(>##) = (>##)

infix 4 >=##
(>=##) :: Double# -> Double# -> Int#
(>=##) = (>=##)

infix 4 ==##
(==##) :: Double# -> Double# -> Int#
(==##) = (==##)

infix 4 /=##
(/=##) :: Double# -> Double# -> Int#
(/=##) = (/=##)

infix 4 <##
(<##) :: Double# -> Double# -> Int#
(<##) = (<##)

infix 4 <=##
(<=##) :: Double# -> Double# -> Int#
(<=##) = (<=##)

{-|Return the minimum of the arguments.
   When the arguments are numerically equal (e.g. @0.0##@ and @-0.0##@)
   or one of the arguments is not-a-number (NaN),
   it is unspecified which one is returned.-}
minDouble# :: Double# -> Double# -> Double#
minDouble# = minDouble#

{-|Return the maximum of the arguments.
   When the arguments are numerically equal (e.g. @0.0##@ and @-0.0##@)
   or one of the arguments is not-a-number (NaN),
   it is unspecified which one is returned.-}
maxDouble# :: Double# -> Double# -> Double#
maxDouble# = maxDouble#

infixl 6 +##
(+##) :: Double# -> Double# -> Double#
(+##) = (+##)

infixl 6 -##
(-##) :: Double# -> Double# -> Double#
(-##) = (-##)

infixl 7 *##
(*##) :: Double# -> Double# -> Double#
(*##) = (*##)

infixl 7 /##
(/##) :: Double# -> Double# -> Double#
(/##) = (/##)

negateDouble# :: Double# -> Double#
negateDouble# = negateDouble#

fabsDouble# :: Double# -> Double#
fabsDouble# = fabsDouble#

{-|Truncates a 'Double#' value to the nearest 'Int#'.
    Results are undefined if the truncation if truncation yields
    a value outside the range of 'Int#'.-}
double2Int# :: Double# -> Int#
double2Int# = double2Int#

double2Float# :: Double# -> Float#
double2Float# = double2Float#

expDouble# :: Double# -> Double#
expDouble# = expDouble#

expm1Double# :: Double# -> Double#
expm1Double# = expm1Double#

logDouble# :: Double# -> Double#
logDouble# = logDouble#

log1pDouble# :: Double# -> Double#
log1pDouble# = log1pDouble#

sqrtDouble# :: Double# -> Double#
sqrtDouble# = sqrtDouble#

sinDouble# :: Double# -> Double#
sinDouble# = sinDouble#

cosDouble# :: Double# -> Double#
cosDouble# = cosDouble#

tanDouble# :: Double# -> Double#
tanDouble# = tanDouble#

asinDouble# :: Double# -> Double#
asinDouble# = asinDouble#

acosDouble# :: Double# -> Double#
acosDouble# = acosDouble#

atanDouble# :: Double# -> Double#
atanDouble# = atanDouble#

sinhDouble# :: Double# -> Double#
sinhDouble# = sinhDouble#

coshDouble# :: Double# -> Double#
coshDouble# = coshDouble#

tanhDouble# :: Double# -> Double#
tanhDouble# = tanhDouble#

asinhDouble# :: Double# -> Double#
asinhDouble# = asinhDouble#

acoshDouble# :: Double# -> Double#
acoshDouble# = acoshDouble#

atanhDouble# :: Double# -> Double#
atanhDouble# = atanhDouble#

{-|Exponentiation.-}
(**##) :: Double# -> Double# -> Double#
(**##) = (**##)

{-|Convert to integer.
    First component of the result is -1 or 1, indicating the sign of the
    mantissa. The next two are the high and low 32 bits of the mantissa
    respectively, and the last is the exponent.-}
decodeDouble_2Int# :: Double# -> (# Int#,Word#,Word#,Int# #)
decodeDouble_2Int# = decodeDouble_2Int#

{-|Decode 'Double#' into mantissa and base-2 exponent.-}
decodeDouble_Int64# :: Double# -> (# Int64#,Int# #)
decodeDouble_Int64# = decodeDouble_Int64#

{-|Bitcast a 'Double#' into a 'Word64#'-}
castDoubleToWord64# :: Double# -> Word64#
castDoubleToWord64# = castDoubleToWord64#

{-|Bitcast a 'Word64#' into a 'Double#'-}
castWord64ToDouble# :: Word64# -> Double#
castWord64ToDouble# = castWord64ToDouble#

data Float#

gtFloat# :: Float# -> Float# -> Int#
gtFloat# = gtFloat#

geFloat# :: Float# -> Float# -> Int#
geFloat# = geFloat#

eqFloat# :: Float# -> Float# -> Int#
eqFloat# = eqFloat#

neFloat# :: Float# -> Float# -> Int#
neFloat# = neFloat#

ltFloat# :: Float# -> Float# -> Int#
ltFloat# = ltFloat#

leFloat# :: Float# -> Float# -> Int#
leFloat# = leFloat#

{-|Return the minimum of the arguments.
   When the arguments are numerically equal (e.g. @0.0#@ and @-0.0#@)
   or one of the arguments is not-a-number (NaN),
   it is unspecified which one is returned.-}
minFloat# :: Float# -> Float# -> Float#
minFloat# = minFloat#

{-|Return the maximum of the arguments.
   When the arguments are numerically equal (e.g. @0.0#@ and @-0.0#@)
   or one of the arguments is not-a-number (NaN),
   it is unspecified which one is returned.-}
maxFloat# :: Float# -> Float# -> Float#
maxFloat# = maxFloat#

plusFloat# :: Float# -> Float# -> Float#
plusFloat# = plusFloat#

minusFloat# :: Float# -> Float# -> Float#
minusFloat# = minusFloat#

timesFloat# :: Float# -> Float# -> Float#
timesFloat# = timesFloat#

divideFloat# :: Float# -> Float# -> Float#
divideFloat# = divideFloat#

negateFloat# :: Float# -> Float#
negateFloat# = negateFloat#

fabsFloat# :: Float# -> Float#
fabsFloat# = fabsFloat#

{-|Truncates a 'Float#' value to the nearest 'Int#'.
    Results are undefined if the truncation if truncation yields
    a value outside the range of 'Int#'.-}
float2Int# :: Float# -> Int#
float2Int# = float2Int#

expFloat# :: Float# -> Float#
expFloat# = expFloat#

expm1Float# :: Float# -> Float#
expm1Float# = expm1Float#

logFloat# :: Float# -> Float#
logFloat# = logFloat#

log1pFloat# :: Float# -> Float#
log1pFloat# = log1pFloat#

sqrtFloat# :: Float# -> Float#
sqrtFloat# = sqrtFloat#

sinFloat# :: Float# -> Float#
sinFloat# = sinFloat#

cosFloat# :: Float# -> Float#
cosFloat# = cosFloat#

tanFloat# :: Float# -> Float#
tanFloat# = tanFloat#

asinFloat# :: Float# -> Float#
asinFloat# = asinFloat#

acosFloat# :: Float# -> Float#
acosFloat# = acosFloat#

atanFloat# :: Float# -> Float#
atanFloat# = atanFloat#

sinhFloat# :: Float# -> Float#
sinhFloat# = sinhFloat#

coshFloat# :: Float# -> Float#
coshFloat# = coshFloat#

tanhFloat# :: Float# -> Float#
tanhFloat# = tanhFloat#

asinhFloat# :: Float# -> Float#
asinhFloat# = asinhFloat#

acoshFloat# :: Float# -> Float#
acoshFloat# = acoshFloat#

atanhFloat# :: Float# -> Float#
atanhFloat# = atanhFloat#

powerFloat# :: Float# -> Float# -> Float#
powerFloat# = powerFloat#

float2Double# :: Float# -> Double#
float2Double# = float2Double#

{-|Convert to integers.
    First 'Int#' in result is the mantissa; second is the exponent.-}
decodeFloat_Int# :: Float# -> (# Int#,Int# #)
decodeFloat_Int# = decodeFloat_Int#

{-|Bitcast a 'Float#' into a 'Word32#'-}
castFloatToWord32# :: Float# -> Word32#
castFloatToWord32# = castFloatToWord32#

{-|Bitcast a 'Word32#' into a 'Float#'-}
castWord32ToFloat# :: Word32# -> Float#
castWord32ToFloat# = castWord32ToFloat#

{-|Fused multiply-add operation @x*y+z@. See "GHC.Prim#fma".-}
fmaddFloat# :: Float# -> Float# -> Float# -> Float#
fmaddFloat# = fmaddFloat#

{-|Fused multiply-subtract operation @x*y-z@. See "GHC.Prim#fma".-}
fmsubFloat# :: Float# -> Float# -> Float# -> Float#
fmsubFloat# = fmsubFloat#

{-|Fused negate-multiply-add operation @-x*y+z@. See "GHC.Prim#fma".-}
fnmaddFloat# :: Float# -> Float# -> Float# -> Float#
fnmaddFloat# = fnmaddFloat#

{-|Fused negate-multiply-subtract operation @-x*y-z@. See "GHC.Prim#fma".-}
fnmsubFloat# :: Float# -> Float# -> Float# -> Float#
fnmsubFloat# = fnmsubFloat#

{-|Fused multiply-add operation @x*y+z@. See "GHC.Prim#fma".-}
fmaddDouble# :: Double# -> Double# -> Double# -> Double#
fmaddDouble# = fmaddDouble#

{-|Fused multiply-subtract operation @x*y-z@. See "GHC.Prim#fma".-}
fmsubDouble# :: Double# -> Double# -> Double# -> Double#
fmsubDouble# = fmsubDouble#

{-|Fused negate-multiply-add operation @-x*y+z@. See "GHC.Prim#fma".-}
fnmaddDouble# :: Double# -> Double# -> Double# -> Double#
fnmaddDouble# = fnmaddDouble#

{-|Fused negate-multiply-subtract operation @-x*y-z@. See "GHC.Prim#fma".-}
fnmsubDouble# :: Double# -> Double# -> Double# -> Double#
fnmsubDouble# = fnmsubDouble#

data Array# a

data MutableArray# s a

{-|Create a new mutable array with the specified number of elements,
    in the specified state thread,
    with each element containing the specified initial value.-}
newArray# :: Int# -> a_levpoly -> State# s -> (# State# s,MutableArray# s a_levpoly #)
newArray# = newArray#

{-|Read from specified index of mutable array. Result is not yet evaluated.

__/Warning:/__ this can fail with an unchecked exception.-}
readArray# :: MutableArray# s a_levpoly -> Int# -> State# s -> (# State# s,a_levpoly #)
readArray# = readArray#

{-|Write to specified index of mutable array.

__/Warning:/__ this can fail with an unchecked exception.-}
writeArray# :: MutableArray# s a_levpoly -> Int# -> a_levpoly -> State# s -> State# s
writeArray# = writeArray#

{-|Return the number of elements in the array.-}
sizeofArray# :: Array# a_levpoly -> Int#
sizeofArray# = sizeofArray#

{-|Return the number of elements in the array.-}
sizeofMutableArray# :: MutableArray# s a_levpoly -> Int#
sizeofMutableArray# = sizeofMutableArray#

{-|Read from the specified index of an immutable array. The result is packaged
    into an unboxed unary tuple; the result itself is not yet
    evaluated. Pattern matching on the tuple forces the indexing of the
    array to happen but does not evaluate the element itself. Evaluating
    the thunk prevents additional thunks from building up on the
    heap. Avoiding these thunks, in turn, reduces references to the
    argument array, allowing it to be garbage collected more promptly.-}
indexArray# :: Array# a_levpoly -> Int# -> (# a_levpoly #)
indexArray# = indexArray#

{-|Make a mutable array immutable, without copying.-}
unsafeFreezeArray# :: MutableArray# s a_levpoly -> State# s -> (# State# s,Array# a_levpoly #)
unsafeFreezeArray# = unsafeFreezeArray#

{-|Make an immutable array mutable, without copying.-}
unsafeThawArray# :: Array# a_levpoly -> State# s -> (# State# s,MutableArray# s a_levpoly #)
unsafeThawArray# = unsafeThawArray#

{-|Given a source array, an offset into the source array, a
   destination array, an offset into the destination array, and a
   number of elements to copy, copy the elements from the source array
   to the destination array. Both arrays must fully contain the
   specified ranges, but this is not checked. The two arrays must not
   be the same array in different states, but this is not checked
   either.

__/Warning:/__ this can fail with an unchecked exception.-}
copyArray# :: Array# a_levpoly -> Int# -> MutableArray# s a_levpoly -> Int# -> Int# -> State# s -> State# s
copyArray# = copyArray#

{-|Given a source array, an offset into the source array, a
   destination array, an offset into the destination array, and a
   number of elements to copy, copy the elements from the source array
   to the destination array. Both arrays must fully contain the
   specified ranges, but this is not checked. In the case where
   the source and destination are the same array the source and
   destination regions may overlap.

__/Warning:/__ this can fail with an unchecked exception.-}
copyMutableArray# :: MutableArray# s a_levpoly -> Int# -> MutableArray# s a_levpoly -> Int# -> Int# -> State# s -> State# s
copyMutableArray# = copyMutableArray#

{-|Given a source array, an offset into the source array, and a number
   of elements to copy, create a new array with the elements from the
   source array. The provided array must fully contain the specified
   range, but this is not checked.

__/Warning:/__ this can fail with an unchecked exception.-}
cloneArray# :: Array# a_levpoly -> Int# -> Int# -> Array# a_levpoly
cloneArray# = cloneArray#

{-|Given a source array, an offset into the source array, and a number
   of elements to copy, create a new array with the elements from the
   source array. The provided array must fully contain the specified
   range, but this is not checked.

__/Warning:/__ this can fail with an unchecked exception.-}
cloneMutableArray# :: MutableArray# s a_levpoly -> Int# -> Int# -> State# s -> (# State# s,MutableArray# s a_levpoly #)
cloneMutableArray# = cloneMutableArray#

{-|Given a source array, an offset into the source array, and a number
   of elements to copy, create a new array with the elements from the
   source array. The provided array must fully contain the specified
   range, but this is not checked.

__/Warning:/__ this can fail with an unchecked exception.-}
freezeArray# :: MutableArray# s a_levpoly -> Int# -> Int# -> State# s -> (# State# s,Array# a_levpoly #)
freezeArray# = freezeArray#

{-|Given a source array, an offset into the source array, and a number
   of elements to copy, create a new array with the elements from the
   source array. The provided array must fully contain the specified
   range, but this is not checked.

__/Warning:/__ this can fail with an unchecked exception.-}
thawArray# :: Array# a_levpoly -> Int# -> Int# -> State# s -> (# State# s,MutableArray# s a_levpoly #)
thawArray# = thawArray#

{-|Given an array, an offset, the expected old value, and
    the new value, perform an atomic compare and swap (i.e. write the new
    value if the current value and the old value are the same pointer).
    Returns 0 if the swap succeeds and 1 if it fails. Additionally, returns
    the element at the offset after the operation completes. This means that
    on a success the new value is returned, and on a failure the actual old
    value (not the expected one) is returned. Implies a full memory barrier.
    The use of a pointer equality on a boxed value makes this function harder
    to use correctly than 'casIntArray#'. All of the difficulties
    of using 'reallyUnsafePtrEquality#' correctly apply to
    'casArray#' as well.
   

__/Warning:/__ this can fail with an unchecked exception.-}
casArray# :: MutableArray# s a_levpoly -> Int# -> a_levpoly -> a_levpoly -> State# s -> (# State# s,Int#,a_levpoly #)
casArray# = casArray#

data SmallArray# a

data SmallMutableArray# s a

{-|Create a new mutable array with the specified number of elements,
    in the specified state thread,
    with each element containing the specified initial value.-}
newSmallArray# :: Int# -> a_levpoly -> State# s -> (# State# s,SmallMutableArray# s a_levpoly #)
newSmallArray# = newSmallArray#

{-|Shrink mutable array to new specified size, in
    the specified state thread. The new size argument must be less than or
    equal to the current size as reported by 'getSizeofSmallMutableArray#'.

    Assuming the non-profiling RTS, for the copying garbage collector
    (default) this primitive compiles to an O(1) operation in C--, modifying
    the array in-place. For the non-moving garbage collector, however, the
    time is proportional to the number of elements shrinked out. Backends
    bypassing C-- representation (such as JavaScript) might behave
    differently.

    @since 0.6.1

__/Warning:/__ this can fail with an unchecked exception.-}
shrinkSmallMutableArray# :: SmallMutableArray# s a_levpoly -> Int# -> State# s -> State# s
shrinkSmallMutableArray# = shrinkSmallMutableArray#

{-|Read from specified index of mutable array. Result is not yet evaluated.

__/Warning:/__ this can fail with an unchecked exception.-}
readSmallArray# :: SmallMutableArray# s a_levpoly -> Int# -> State# s -> (# State# s,a_levpoly #)
readSmallArray# = readSmallArray#

{-|Write to specified index of mutable array.

__/Warning:/__ this can fail with an unchecked exception.-}
writeSmallArray# :: SmallMutableArray# s a_levpoly -> Int# -> a_levpoly -> State# s -> State# s
writeSmallArray# = writeSmallArray#

{-|Return the number of elements in the array.-}
sizeofSmallArray# :: SmallArray# a_levpoly -> Int#
sizeofSmallArray# = sizeofSmallArray#

{-|Return the number of elements in the array. __Deprecated__, it is
   unsafe in the presence of 'shrinkSmallMutableArray#' and @resizeSmallMutableArray#@
   operations on the same small mutable array.-}
{-# DEPRECATED sizeofSmallMutableArray# " Use 'getSizeofSmallMutableArray#' instead " #-}
sizeofSmallMutableArray# :: SmallMutableArray# s a_levpoly -> Int#
sizeofSmallMutableArray# = sizeofSmallMutableArray#

{-|Return the number of elements in the array, correctly accounting for
   the effect of 'shrinkSmallMutableArray#' and @resizeSmallMutableArray#@.

   @since 0.6.1-}
getSizeofSmallMutableArray# :: SmallMutableArray# s a_levpoly -> State# s -> (# State# s,Int# #)
getSizeofSmallMutableArray# = getSizeofSmallMutableArray#

{-|Read from specified index of immutable array. Result is packaged into
    an unboxed singleton; the result itself is not yet evaluated.-}
indexSmallArray# :: SmallArray# a_levpoly -> Int# -> (# a_levpoly #)
indexSmallArray# = indexSmallArray#

{-|Make a mutable array immutable, without copying.-}
unsafeFreezeSmallArray# :: SmallMutableArray# s a_levpoly -> State# s -> (# State# s,SmallArray# a_levpoly #)
unsafeFreezeSmallArray# = unsafeFreezeSmallArray#

{-|Make an immutable array mutable, without copying.-}
unsafeThawSmallArray# :: SmallArray# a_levpoly -> State# s -> (# State# s,SmallMutableArray# s a_levpoly #)
unsafeThawSmallArray# = unsafeThawSmallArray#

{-|Given a source array, an offset into the source array, a
   destination array, an offset into the destination array, and a
   number of elements to copy, copy the elements from the source array
   to the destination array. Both arrays must fully contain the
   specified ranges, but this is not checked. The two arrays must not
   be the same array in different states, but this is not checked
   either.

__/Warning:/__ this can fail with an unchecked exception.-}
copySmallArray# :: SmallArray# a_levpoly -> Int# -> SmallMutableArray# s a_levpoly -> Int# -> Int# -> State# s -> State# s
copySmallArray# = copySmallArray#

{-|Given a source array, an offset into the source array, a
   destination array, an offset into the destination array, and a
   number of elements to copy, copy the elements from the source array
   to the destination array. The source and destination arrays can
   refer to the same array. Both arrays must fully contain the
   specified ranges, but this is not checked.
   The regions are allowed to overlap, although this is only possible when the same
   array is provided as both the source and the destination. 

__/Warning:/__ this can fail with an unchecked exception.-}
copySmallMutableArray# :: SmallMutableArray# s a_levpoly -> Int# -> SmallMutableArray# s a_levpoly -> Int# -> Int# -> State# s -> State# s
copySmallMutableArray# = copySmallMutableArray#

{-|Given a source array, an offset into the source array, and a number
   of elements to copy, create a new array with the elements from the
   source array. The provided array must fully contain the specified
   range, but this is not checked.

__/Warning:/__ this can fail with an unchecked exception.-}
cloneSmallArray# :: SmallArray# a_levpoly -> Int# -> Int# -> SmallArray# a_levpoly
cloneSmallArray# = cloneSmallArray#

{-|Given a source array, an offset into the source array, and a number
   of elements to copy, create a new array with the elements from the
   source array. The provided array must fully contain the specified
   range, but this is not checked.

__/Warning:/__ this can fail with an unchecked exception.-}
cloneSmallMutableArray# :: SmallMutableArray# s a_levpoly -> Int# -> Int# -> State# s -> (# State# s,SmallMutableArray# s a_levpoly #)
cloneSmallMutableArray# = cloneSmallMutableArray#

{-|Given a source array, an offset into the source array, and a number
   of elements to copy, create a new array with the elements from the
   source array. The provided array must fully contain the specified
   range, but this is not checked.

__/Warning:/__ this can fail with an unchecked exception.-}
freezeSmallArray# :: SmallMutableArray# s a_levpoly -> Int# -> Int# -> State# s -> (# State# s,SmallArray# a_levpoly #)
freezeSmallArray# = freezeSmallArray#

{-|Given a source array, an offset into the source array, and a number
   of elements to copy, create a new array with the elements from the
   source array. The provided array must fully contain the specified
   range, but this is not checked.

__/Warning:/__ this can fail with an unchecked exception.-}
thawSmallArray# :: SmallArray# a_levpoly -> Int# -> Int# -> State# s -> (# State# s,SmallMutableArray# s a_levpoly #)
thawSmallArray# = thawSmallArray#

{-|Unsafe, machine-level atomic compare and swap on an element within an array.
    See the documentation of 'casArray#'.

__/Warning:/__ this can fail with an unchecked exception.-}
casSmallArray# :: SmallMutableArray# s a_levpoly -> Int# -> a_levpoly -> a_levpoly -> State# s -> (# State# s,Int#,a_levpoly #)
casSmallArray# = casSmallArray#

{-|
  A boxed, unlifted datatype representing a region of raw memory in the garbage-collected heap,
  which is not scanned for pointers during garbage collection.

  It is created by freezing a 'MutableByteArray#' with 'unsafeFreezeByteArray#'.
  Freezing is essentially a no-op, as 'MutableByteArray#' and 'ByteArray#' share the same heap structure under the hood.

  The immutable and mutable variants are commonly used for scenarios requiring high-performance data structures,
  like @Text@, @Primitive Vector@, @Unboxed Array@, and @ShortByteString@.

  Another application of fundamental importance is 'Integer', which is backed by 'ByteArray#'.

  The representation on the heap of a Byte Array is:

  > +------------+-----------------+-----------------------+
  > |            |                 |                       |
  > |   HEADER   | SIZE (in bytes) |       PAYLOAD         |
  > |            |                 |                       |
  > +------------+-----------------+-----------------------+

  To obtain a pointer to actual payload (e.g., for FFI purposes) use 'byteArrayContents#' or 'mutableByteArrayContents#'.

  Alternatively, enabling the @UnliftedFFITypes@ extension
  allows to mention 'ByteArray#' and 'MutableByteArray#' in FFI type signatures directly.
-}
data ByteArray#

{-| A mutable 'ByteAray#'. It can be created in three ways:

  * 'newByteArray#': Create an unpinned array.
  * 'newPinnedByteArray#': This will create a pinned array,
  * 'newAlignedPinnedByteArray#': This will create a pinned array, with a custom alignment.

  Unpinned arrays can be moved around during garbage collection, so you must not store or pass pointers to these values
  if there is a chance for the garbage collector to kick in. That said, even unpinned arrays can be passed to unsafe FFI calls,
  because no garbage collection happens during these unsafe calls
  (see [Guaranteed Call Safety](https://ghc.gitlab.haskell.org/ghc/doc/users_guide/exts/ffi.html#guaranteed-call-safety)
  in the GHC Manual). For safe FFI calls, byte arrays must be not only pinned, but also kept alive by means of the keepAlive# function
  for the duration of a call (that's because garbage collection cannot move a pinned array, but is free to scrap it altogether).
-}
data MutableByteArray# s

{-|Create a new mutable byte array of specified size (in bytes), in
    the specified state thread. The size of the memory underlying the
    array will be rounded up to the platform's word size.-}
newByteArray# :: Int# -> State# s -> (# State# s,MutableByteArray# s #)
newByteArray# = newByteArray#

{-|Like 'newByteArray#' but GC guarantees not to move it.-}
newPinnedByteArray# :: Int# -> State# s -> (# State# s,MutableByteArray# s #)
newPinnedByteArray# = newPinnedByteArray#

{-|Like 'newPinnedByteArray#' but allow specifying an arbitrary
    alignment, which must be a power of two.

__/Warning:/__ this can fail with an unchecked exception.-}
newAlignedPinnedByteArray# :: Int# -> Int# -> State# s -> (# State# s,MutableByteArray# s #)
newAlignedPinnedByteArray# = newAlignedPinnedByteArray#

{-|Determine whether a 'MutableByteArray#' is guaranteed not to move
   during GC.-}
isMutableByteArrayPinned# :: MutableByteArray# s -> Int#
isMutableByteArrayPinned# = isMutableByteArrayPinned#

{-|Determine whether a 'ByteArray#' is guaranteed not to move.-}
isByteArrayPinned# :: ByteArray# -> Int#
isByteArrayPinned# = isByteArrayPinned#

{-|Similar to 'isByteArrayPinned#'. Weakly pinned byte arrays are allowed
    to be copied into compact regions by the user, potentially invalidating
    the results of earlier calls to 'byteArrayContents#'.

    See the section `Pinned Byte Arrays` in the user guide for more information.

    This function also returns true for regular pinned bytearrays.
   -}
isByteArrayWeaklyPinned# :: ByteArray# -> Int#
isByteArrayWeaklyPinned# = isByteArrayWeaklyPinned#

{-| 'isByteArrayWeaklyPinned#' but for mutable arrays.
   -}
isMutableByteArrayWeaklyPinned# :: MutableByteArray# s -> Int#
isMutableByteArrayWeaklyPinned# = isMutableByteArrayWeaklyPinned#

{-|Intended for use with pinned arrays; otherwise very unsafe!-}
byteArrayContents# :: ByteArray# -> Addr#
byteArrayContents# = byteArrayContents#

{-|Intended for use with pinned arrays; otherwise very unsafe!-}
mutableByteArrayContents# :: MutableByteArray# s -> Addr#
mutableByteArrayContents# = mutableByteArrayContents#

{-|Shrink mutable byte array to new specified size (in bytes), in
    the specified state thread. The new size argument must be less than or
    equal to the current size as reported by 'getSizeofMutableByteArray#'.

    Assuming the non-profiling RTS, this primitive compiles to an O(1)
    operation in C--, modifying the array in-place. Backends bypassing C--
    representation (such as JavaScript) might behave differently.

    @since 0.4.0.0

__/Warning:/__ this can fail with an unchecked exception.-}
shrinkMutableByteArray# :: MutableByteArray# s -> Int# -> State# s -> State# s
shrinkMutableByteArray# = shrinkMutableByteArray#

{-|Resize mutable byte array to new specified size (in bytes), shrinking or growing it.
    The returned 'MutableByteArray#' is either the original
    'MutableByteArray#' resized in-place or, if not possible, a newly
    allocated (unpinned) 'MutableByteArray#' (with the original content
    copied over).

    To avoid undefined behaviour, the original 'MutableByteArray#' shall
    not be accessed anymore after a 'resizeMutableByteArray#' has been
    performed.  Moreover, no reference to the old one should be kept in order
    to allow garbage collection of the original 'MutableByteArray#' in
    case a new 'MutableByteArray#' had to be allocated.

    @since 0.4.0.0-}
resizeMutableByteArray# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,MutableByteArray# s #)
resizeMutableByteArray# = resizeMutableByteArray#

{-|Make a mutable byte array immutable, without copying.-}
unsafeFreezeByteArray# :: MutableByteArray# s -> State# s -> (# State# s,ByteArray# #)
unsafeFreezeByteArray# = unsafeFreezeByteArray#

{-|Make an immutable byte array mutable, without copying.

    @since 0.12.0.0-}
unsafeThawByteArray# :: ByteArray# -> State# s -> (# State# s,MutableByteArray# s #)
unsafeThawByteArray# = unsafeThawByteArray#

{-|Return the size of the array in bytes.-}
sizeofByteArray# :: ByteArray# -> Int#
sizeofByteArray# = sizeofByteArray#

{-|Return the size of the array in bytes. __Deprecated__, it is
   unsafe in the presence of 'shrinkMutableByteArray#' and 'resizeMutableByteArray#'
   operations on the same mutable byte
   array.-}
{-# DEPRECATED sizeofMutableByteArray# " Use 'getSizeofMutableByteArray#' instead " #-}
sizeofMutableByteArray# :: MutableByteArray# s -> Int#
sizeofMutableByteArray# = sizeofMutableByteArray#

{-|Return the number of elements in the array, correctly accounting for
   the effect of 'shrinkMutableByteArray#' and 'resizeMutableByteArray#'.

   @since 0.5.0.0-}
getSizeofMutableByteArray# :: MutableByteArray# s -> State# s -> (# State# s,Int# #)
getSizeofMutableByteArray# = getSizeofMutableByteArray#

{-|Read an 8-bit character from immutable array; offset in bytes.-}
indexCharArray# :: ByteArray# -> Int# -> Char#
indexCharArray# = indexCharArray#

{-|Read a 32-bit character from immutable array; offset in 4-byte words.-}
indexWideCharArray# :: ByteArray# -> Int# -> Char#
indexWideCharArray# = indexWideCharArray#

{-|Read a word-sized integer from immutable array; offset in machine words.-}
indexIntArray# :: ByteArray# -> Int# -> Int#
indexIntArray# = indexIntArray#

{-|Read a word-sized unsigned integer from immutable array; offset in machine words.-}
indexWordArray# :: ByteArray# -> Int# -> Word#
indexWordArray# = indexWordArray#

{-|Read a machine address from immutable array; offset in machine words.-}
indexAddrArray# :: ByteArray# -> Int# -> Addr#
indexAddrArray# = indexAddrArray#

{-|Read a single-precision floating-point value from immutable array; offset in 4-byte words.-}
indexFloatArray# :: ByteArray# -> Int# -> Float#
indexFloatArray# = indexFloatArray#

{-|Read a double-precision floating-point value from immutable array; offset in 8-byte words.-}
indexDoubleArray# :: ByteArray# -> Int# -> Double#
indexDoubleArray# = indexDoubleArray#

{-|Read a 'StablePtr#' value from immutable array; offset in machine words.-}
indexStablePtrArray# :: ByteArray# -> Int# -> StablePtr# a
indexStablePtrArray# = indexStablePtrArray#

{-|Read an 8-bit signed integer from immutable array; offset in bytes.-}
indexInt8Array# :: ByteArray# -> Int# -> Int8#
indexInt8Array# = indexInt8Array#

{-|Read an 8-bit unsigned integer from immutable array; offset in bytes.-}
indexWord8Array# :: ByteArray# -> Int# -> Word8#
indexWord8Array# = indexWord8Array#

{-|Read a 16-bit signed integer from immutable array; offset in 2-byte words.-}
indexInt16Array# :: ByteArray# -> Int# -> Int16#
indexInt16Array# = indexInt16Array#

{-|Read a 16-bit unsigned integer from immutable array; offset in 2-byte words.-}
indexWord16Array# :: ByteArray# -> Int# -> Word16#
indexWord16Array# = indexWord16Array#

{-|Read a 32-bit signed integer from immutable array; offset in 4-byte words.-}
indexInt32Array# :: ByteArray# -> Int# -> Int32#
indexInt32Array# = indexInt32Array#

{-|Read a 32-bit unsigned integer from immutable array; offset in 4-byte words.-}
indexWord32Array# :: ByteArray# -> Int# -> Word32#
indexWord32Array# = indexWord32Array#

{-|Read a 64-bit signed integer from immutable array; offset in 8-byte words.-}
indexInt64Array# :: ByteArray# -> Int# -> Int64#
indexInt64Array# = indexInt64Array#

{-|Read a 64-bit unsigned integer from immutable array; offset in 8-byte words.-}
indexWord64Array# :: ByteArray# -> Int# -> Word64#
indexWord64Array# = indexWord64Array#

{-|Read an 8-bit character from immutable array; offset in bytes.-}
indexWord8ArrayAsChar# :: ByteArray# -> Int# -> Char#
indexWord8ArrayAsChar# = indexWord8ArrayAsChar#

{-|Read a 32-bit character from immutable array; offset in bytes.-}
indexWord8ArrayAsWideChar# :: ByteArray# -> Int# -> Char#
indexWord8ArrayAsWideChar# = indexWord8ArrayAsWideChar#

{-|Read a word-sized integer from immutable array; offset in bytes.-}
indexWord8ArrayAsInt# :: ByteArray# -> Int# -> Int#
indexWord8ArrayAsInt# = indexWord8ArrayAsInt#

{-|Read a word-sized unsigned integer from immutable array; offset in bytes.-}
indexWord8ArrayAsWord# :: ByteArray# -> Int# -> Word#
indexWord8ArrayAsWord# = indexWord8ArrayAsWord#

{-|Read a machine address from immutable array; offset in bytes.-}
indexWord8ArrayAsAddr# :: ByteArray# -> Int# -> Addr#
indexWord8ArrayAsAddr# = indexWord8ArrayAsAddr#

{-|Read a single-precision floating-point value from immutable array; offset in bytes.-}
indexWord8ArrayAsFloat# :: ByteArray# -> Int# -> Float#
indexWord8ArrayAsFloat# = indexWord8ArrayAsFloat#

{-|Read a double-precision floating-point value from immutable array; offset in bytes.-}
indexWord8ArrayAsDouble# :: ByteArray# -> Int# -> Double#
indexWord8ArrayAsDouble# = indexWord8ArrayAsDouble#

{-|Read a 'StablePtr#' value from immutable array; offset in bytes.-}
indexWord8ArrayAsStablePtr# :: ByteArray# -> Int# -> StablePtr# a
indexWord8ArrayAsStablePtr# = indexWord8ArrayAsStablePtr#

{-|Read a 16-bit signed integer from immutable array; offset in bytes.-}
indexWord8ArrayAsInt16# :: ByteArray# -> Int# -> Int16#
indexWord8ArrayAsInt16# = indexWord8ArrayAsInt16#

{-|Read a 16-bit unsigned integer from immutable array; offset in bytes.-}
indexWord8ArrayAsWord16# :: ByteArray# -> Int# -> Word16#
indexWord8ArrayAsWord16# = indexWord8ArrayAsWord16#

{-|Read a 32-bit signed integer from immutable array; offset in bytes.-}
indexWord8ArrayAsInt32# :: ByteArray# -> Int# -> Int32#
indexWord8ArrayAsInt32# = indexWord8ArrayAsInt32#

{-|Read a 32-bit unsigned integer from immutable array; offset in bytes.-}
indexWord8ArrayAsWord32# :: ByteArray# -> Int# -> Word32#
indexWord8ArrayAsWord32# = indexWord8ArrayAsWord32#

{-|Read a 64-bit signed integer from immutable array; offset in bytes.-}
indexWord8ArrayAsInt64# :: ByteArray# -> Int# -> Int64#
indexWord8ArrayAsInt64# = indexWord8ArrayAsInt64#

{-|Read a 64-bit unsigned integer from immutable array; offset in bytes.-}
indexWord8ArrayAsWord64# :: ByteArray# -> Int# -> Word64#
indexWord8ArrayAsWord64# = indexWord8ArrayAsWord64#

{-|Read an 8-bit character from mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readCharArray# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Char# #)
readCharArray# = readCharArray#

{-|Read a 32-bit character from mutable array; offset in 4-byte words.

__/Warning:/__ this can fail with an unchecked exception.-}
readWideCharArray# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Char# #)
readWideCharArray# = readWideCharArray#

{-|Read a word-sized integer from mutable array; offset in machine words.

__/Warning:/__ this can fail with an unchecked exception.-}
readIntArray# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int# #)
readIntArray# = readIntArray#

{-|Read a word-sized unsigned integer from mutable array; offset in machine words.

__/Warning:/__ this can fail with an unchecked exception.-}
readWordArray# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word# #)
readWordArray# = readWordArray#

{-|Read a machine address from mutable array; offset in machine words.

__/Warning:/__ this can fail with an unchecked exception.-}
readAddrArray# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Addr# #)
readAddrArray# = readAddrArray#

{-|Read a single-precision floating-point value from mutable array; offset in 4-byte words.

__/Warning:/__ this can fail with an unchecked exception.-}
readFloatArray# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Float# #)
readFloatArray# = readFloatArray#

{-|Read a double-precision floating-point value from mutable array; offset in 8-byte words.

__/Warning:/__ this can fail with an unchecked exception.-}
readDoubleArray# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Double# #)
readDoubleArray# = readDoubleArray#

{-|Read a 'StablePtr#' value from mutable array; offset in machine words.

__/Warning:/__ this can fail with an unchecked exception.-}
readStablePtrArray# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,StablePtr# a #)
readStablePtrArray# = readStablePtrArray#

{-|Read an 8-bit signed integer from mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readInt8Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int8# #)
readInt8Array# = readInt8Array#

{-|Read an 8-bit unsigned integer from mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word8# #)
readWord8Array# = readWord8Array#

{-|Read a 16-bit signed integer from mutable array; offset in 2-byte words.

__/Warning:/__ this can fail with an unchecked exception.-}
readInt16Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int16# #)
readInt16Array# = readInt16Array#

{-|Read a 16-bit unsigned integer from mutable array; offset in 2-byte words.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord16Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word16# #)
readWord16Array# = readWord16Array#

{-|Read a 32-bit signed integer from mutable array; offset in 4-byte words.

__/Warning:/__ this can fail with an unchecked exception.-}
readInt32Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int32# #)
readInt32Array# = readInt32Array#

{-|Read a 32-bit unsigned integer from mutable array; offset in 4-byte words.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord32Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word32# #)
readWord32Array# = readWord32Array#

{-|Read a 64-bit signed integer from mutable array; offset in 8-byte words.

__/Warning:/__ this can fail with an unchecked exception.-}
readInt64Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int64# #)
readInt64Array# = readInt64Array#

{-|Read a 64-bit unsigned integer from mutable array; offset in 8-byte words.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord64Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word64# #)
readWord64Array# = readWord64Array#

{-|Read an 8-bit character from mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8ArrayAsChar# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Char# #)
readWord8ArrayAsChar# = readWord8ArrayAsChar#

{-|Read a 32-bit character from mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8ArrayAsWideChar# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Char# #)
readWord8ArrayAsWideChar# = readWord8ArrayAsWideChar#

{-|Read a word-sized integer from mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8ArrayAsInt# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int# #)
readWord8ArrayAsInt# = readWord8ArrayAsInt#

{-|Read a word-sized unsigned integer from mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8ArrayAsWord# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word# #)
readWord8ArrayAsWord# = readWord8ArrayAsWord#

{-|Read a machine address from mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8ArrayAsAddr# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Addr# #)
readWord8ArrayAsAddr# = readWord8ArrayAsAddr#

{-|Read a single-precision floating-point value from mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8ArrayAsFloat# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Float# #)
readWord8ArrayAsFloat# = readWord8ArrayAsFloat#

{-|Read a double-precision floating-point value from mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8ArrayAsDouble# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Double# #)
readWord8ArrayAsDouble# = readWord8ArrayAsDouble#

{-|Read a 'StablePtr#' value from mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8ArrayAsStablePtr# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,StablePtr# a #)
readWord8ArrayAsStablePtr# = readWord8ArrayAsStablePtr#

{-|Read a 16-bit signed integer from mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8ArrayAsInt16# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int16# #)
readWord8ArrayAsInt16# = readWord8ArrayAsInt16#

{-|Read a 16-bit unsigned integer from mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8ArrayAsWord16# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word16# #)
readWord8ArrayAsWord16# = readWord8ArrayAsWord16#

{-|Read a 32-bit signed integer from mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8ArrayAsInt32# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int32# #)
readWord8ArrayAsInt32# = readWord8ArrayAsInt32#

{-|Read a 32-bit unsigned integer from mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8ArrayAsWord32# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word32# #)
readWord8ArrayAsWord32# = readWord8ArrayAsWord32#

{-|Read a 64-bit signed integer from mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8ArrayAsInt64# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int64# #)
readWord8ArrayAsInt64# = readWord8ArrayAsInt64#

{-|Read a 64-bit unsigned integer from mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8ArrayAsWord64# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word64# #)
readWord8ArrayAsWord64# = readWord8ArrayAsWord64#

{-|Write an 8-bit character to mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeCharArray# :: MutableByteArray# s -> Int# -> Char# -> State# s -> State# s
writeCharArray# = writeCharArray#

{-|Write a 32-bit character to mutable array; offset in 4-byte words.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWideCharArray# :: MutableByteArray# s -> Int# -> Char# -> State# s -> State# s
writeWideCharArray# = writeWideCharArray#

{-|Write a word-sized integer to mutable array; offset in machine words.

__/Warning:/__ this can fail with an unchecked exception.-}
writeIntArray# :: MutableByteArray# s -> Int# -> Int# -> State# s -> State# s
writeIntArray# = writeIntArray#

{-|Write a word-sized unsigned integer to mutable array; offset in machine words.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWordArray# :: MutableByteArray# s -> Int# -> Word# -> State# s -> State# s
writeWordArray# = writeWordArray#

{-|Write a machine address to mutable array; offset in machine words.

__/Warning:/__ this can fail with an unchecked exception.-}
writeAddrArray# :: MutableByteArray# s -> Int# -> Addr# -> State# s -> State# s
writeAddrArray# = writeAddrArray#

{-|Write a single-precision floating-point value to mutable array; offset in 4-byte words.

__/Warning:/__ this can fail with an unchecked exception.-}
writeFloatArray# :: MutableByteArray# s -> Int# -> Float# -> State# s -> State# s
writeFloatArray# = writeFloatArray#

{-|Write a double-precision floating-point value to mutable array; offset in 8-byte words.

__/Warning:/__ this can fail with an unchecked exception.-}
writeDoubleArray# :: MutableByteArray# s -> Int# -> Double# -> State# s -> State# s
writeDoubleArray# = writeDoubleArray#

{-|Write a 'StablePtr#' value to mutable array; offset in machine words.

__/Warning:/__ this can fail with an unchecked exception.-}
writeStablePtrArray# :: MutableByteArray# s -> Int# -> StablePtr# a -> State# s -> State# s
writeStablePtrArray# = writeStablePtrArray#

{-|Write an 8-bit signed integer to mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt8Array# :: MutableByteArray# s -> Int# -> Int8# -> State# s -> State# s
writeInt8Array# = writeInt8Array#

{-|Write an 8-bit unsigned integer to mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8Array# :: MutableByteArray# s -> Int# -> Word8# -> State# s -> State# s
writeWord8Array# = writeWord8Array#

{-|Write a 16-bit signed integer to mutable array; offset in 2-byte words.

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt16Array# :: MutableByteArray# s -> Int# -> Int16# -> State# s -> State# s
writeInt16Array# = writeInt16Array#

{-|Write a 16-bit unsigned integer to mutable array; offset in 2-byte words.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord16Array# :: MutableByteArray# s -> Int# -> Word16# -> State# s -> State# s
writeWord16Array# = writeWord16Array#

{-|Write a 32-bit signed integer to mutable array; offset in 4-byte words.

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt32Array# :: MutableByteArray# s -> Int# -> Int32# -> State# s -> State# s
writeInt32Array# = writeInt32Array#

{-|Write a 32-bit unsigned integer to mutable array; offset in 4-byte words.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord32Array# :: MutableByteArray# s -> Int# -> Word32# -> State# s -> State# s
writeWord32Array# = writeWord32Array#

{-|Write a 64-bit signed integer to mutable array; offset in 8-byte words.

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt64Array# :: MutableByteArray# s -> Int# -> Int64# -> State# s -> State# s
writeInt64Array# = writeInt64Array#

{-|Write a 64-bit unsigned integer to mutable array; offset in 8-byte words.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord64Array# :: MutableByteArray# s -> Int# -> Word64# -> State# s -> State# s
writeWord64Array# = writeWord64Array#

{-|Write an 8-bit character to mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8ArrayAsChar# :: MutableByteArray# s -> Int# -> Char# -> State# s -> State# s
writeWord8ArrayAsChar# = writeWord8ArrayAsChar#

{-|Write a 32-bit character to mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8ArrayAsWideChar# :: MutableByteArray# s -> Int# -> Char# -> State# s -> State# s
writeWord8ArrayAsWideChar# = writeWord8ArrayAsWideChar#

{-|Write a word-sized integer to mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8ArrayAsInt# :: MutableByteArray# s -> Int# -> Int# -> State# s -> State# s
writeWord8ArrayAsInt# = writeWord8ArrayAsInt#

{-|Write a word-sized unsigned integer to mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8ArrayAsWord# :: MutableByteArray# s -> Int# -> Word# -> State# s -> State# s
writeWord8ArrayAsWord# = writeWord8ArrayAsWord#

{-|Write a machine address to mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8ArrayAsAddr# :: MutableByteArray# s -> Int# -> Addr# -> State# s -> State# s
writeWord8ArrayAsAddr# = writeWord8ArrayAsAddr#

{-|Write a single-precision floating-point value to mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8ArrayAsFloat# :: MutableByteArray# s -> Int# -> Float# -> State# s -> State# s
writeWord8ArrayAsFloat# = writeWord8ArrayAsFloat#

{-|Write a double-precision floating-point value to mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8ArrayAsDouble# :: MutableByteArray# s -> Int# -> Double# -> State# s -> State# s
writeWord8ArrayAsDouble# = writeWord8ArrayAsDouble#

{-|Write a 'StablePtr#' value to mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8ArrayAsStablePtr# :: MutableByteArray# s -> Int# -> StablePtr# a -> State# s -> State# s
writeWord8ArrayAsStablePtr# = writeWord8ArrayAsStablePtr#

{-|Write a 16-bit signed integer to mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8ArrayAsInt16# :: MutableByteArray# s -> Int# -> Int16# -> State# s -> State# s
writeWord8ArrayAsInt16# = writeWord8ArrayAsInt16#

{-|Write a 16-bit unsigned integer to mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8ArrayAsWord16# :: MutableByteArray# s -> Int# -> Word16# -> State# s -> State# s
writeWord8ArrayAsWord16# = writeWord8ArrayAsWord16#

{-|Write a 32-bit signed integer to mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8ArrayAsInt32# :: MutableByteArray# s -> Int# -> Int32# -> State# s -> State# s
writeWord8ArrayAsInt32# = writeWord8ArrayAsInt32#

{-|Write a 32-bit unsigned integer to mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8ArrayAsWord32# :: MutableByteArray# s -> Int# -> Word32# -> State# s -> State# s
writeWord8ArrayAsWord32# = writeWord8ArrayAsWord32#

{-|Write a 64-bit signed integer to mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8ArrayAsInt64# :: MutableByteArray# s -> Int# -> Int64# -> State# s -> State# s
writeWord8ArrayAsInt64# = writeWord8ArrayAsInt64#

{-|Write a 64-bit unsigned integer to mutable array; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8ArrayAsWord64# :: MutableByteArray# s -> Int# -> Word64# -> State# s -> State# s
writeWord8ArrayAsWord64# = writeWord8ArrayAsWord64#

{-|@'compareByteArrays#' src1 src1_ofs src2 src2_ofs n@ compares
    @n@ bytes starting at offset @src1_ofs@ in the first
    'ByteArray#' @src1@ to the range of @n@ bytes
    (i.e. same length) starting at offset @src2_ofs@ of the second
    'ByteArray#' @src2@.  Both arrays must fully contain the
    specified ranges, but this is not checked.  Returns an 'Int#'
    less than, equal to, or greater than zero if the range is found,
    respectively, to be byte-wise lexicographically less than, to
    match, or be greater than the second range.

    @since 0.5.2.0-}
compareByteArrays# :: ByteArray# -> Int# -> ByteArray# -> Int# -> Int# -> Int#
compareByteArrays# = compareByteArrays#

{-| @'copyByteArray#' src src_ofs dst dst_ofs len@ copies the range
    starting at offset @src_ofs@ of length @len@ from the
    'ByteArray#' @src@ to the 'MutableByteArray#' @dst@
    starting at offset @dst_ofs@.  Both arrays must fully contain
    the specified ranges, but this is not checked.  The two arrays must
    not be the same array in different states, but this is not checked
    either.
  

__/Warning:/__ this can fail with an unchecked exception.-}
copyByteArray# :: ByteArray# -> Int# -> MutableByteArray# s -> Int# -> Int# -> State# s -> State# s
copyByteArray# = copyByteArray#

{-| @'copyMutableByteArray#' src src_ofs dst dst_ofs len@ copies the
    range starting at offset @src_ofs@ of length @len@ from the
    'MutableByteArray#' @src@ to the 'MutableByteArray#' @dst@
    starting at offset @dst_ofs@.  Both arrays must fully contain the
    specified ranges, but this is not checked.  The regions are
    allowed to overlap, although this is only possible when the same
    array is provided as both the source and the destination.
  

__/Warning:/__ this can fail with an unchecked exception.-}
copyMutableByteArray# :: MutableByteArray# s -> Int# -> MutableByteArray# s -> Int# -> Int# -> State# s -> State# s
copyMutableByteArray# = copyMutableByteArray#

{-| @'copyMutableByteArrayNonOverlapping#' src src_ofs dst dst_ofs len@
    copies the range starting at offset @src_ofs@ of length @len@ from
    the 'MutableByteArray#' @src@ to the 'MutableByteArray#' @dst@
    starting at offset @dst_ofs@.  Both arrays must fully contain the
    specified ranges, but this is not checked.  The regions are /not/
    allowed to overlap, but this is also not checked.

    @since 0.11.0
  

__/Warning:/__ this can fail with an unchecked exception.-}
copyMutableByteArrayNonOverlapping# :: MutableByteArray# s -> Int# -> MutableByteArray# s -> Int# -> Int# -> State# s -> State# s
copyMutableByteArrayNonOverlapping# = copyMutableByteArrayNonOverlapping#

{-|Copy a range of the ByteArray\# to the memory range starting at the Addr\#.
   The ByteArray\# and the memory region at Addr\# must fully contain the
   specified ranges, but this is not checked. The Addr\# must not point into the
   ByteArray\# (e.g. if the ByteArray\# were pinned), but this is not checked
   either.

__/Warning:/__ this can fail with an unchecked exception.-}
copyByteArrayToAddr# :: ByteArray# -> Int# -> Addr# -> Int# -> State# s -> State# s
copyByteArrayToAddr# = copyByteArrayToAddr#

{-|Copy a range of the MutableByteArray\# to the memory range starting at the
   Addr\#. The MutableByteArray\# and the memory region at Addr\# must fully
   contain the specified ranges, but this is not checked. The Addr\# must not
   point into the MutableByteArray\# (e.g. if the MutableByteArray\# were
   pinned), but this is not checked either.

__/Warning:/__ this can fail with an unchecked exception.-}
copyMutableByteArrayToAddr# :: MutableByteArray# s -> Int# -> Addr# -> Int# -> State# s -> State# s
copyMutableByteArrayToAddr# = copyMutableByteArrayToAddr#

{-|Copy a memory range starting at the Addr\# to the specified range in the
   MutableByteArray\#. The memory region at Addr\# and the ByteArray\# must fully
   contain the specified ranges, but this is not checked. The Addr\# must not
   point into the MutableByteArray\# (e.g. if the MutableByteArray\# were pinned),
   but this is not checked either.

__/Warning:/__ this can fail with an unchecked exception.-}
copyAddrToByteArray# :: Addr# -> MutableByteArray# s -> Int# -> Int# -> State# s -> State# s
copyAddrToByteArray# = copyAddrToByteArray#

{-| @'copyAddrToAddr#' src dest len@ copies @len@ bytes
    from @src@ to @dest@.  These two memory ranges are allowed to overlap.

    Analogous to the standard C function @memmove@, but with a different
    argument order.

    @since 0.11.0
  

__/Warning:/__ this can fail with an unchecked exception.-}
copyAddrToAddr# :: Addr# -> Addr# -> Int# -> State# (RealWorld) -> State# (RealWorld)
copyAddrToAddr# = copyAddrToAddr#

{-| @'copyAddrToAddrNonOverlapping#' src dest len@ copies @len@ bytes
    from @src@ to @dest@.  As the name suggests, these two memory ranges
    /must not overlap/, although this pre-condition is not checked.

    Analogous to the standard C function @memcpy@, but with a different
    argument order.

    @since 0.11.0
  

__/Warning:/__ this can fail with an unchecked exception.-}
copyAddrToAddrNonOverlapping# :: Addr# -> Addr# -> Int# -> State# (RealWorld) -> State# (RealWorld)
copyAddrToAddrNonOverlapping# = copyAddrToAddrNonOverlapping#

{-|@'setByteArray#' ba off len c@ sets the byte range @[off, off+len)@ of
   the 'MutableByteArray#' to the byte @c@.

__/Warning:/__ this can fail with an unchecked exception.-}
setByteArray# :: MutableByteArray# s -> Int# -> Int# -> Int# -> State# s -> State# s
setByteArray# = setByteArray#

{-| @'setAddrRange#' dest len c@ sets all of the bytes in
    @[dest, dest+len)@ to the value @c@.

    Analogous to the standard C function @memset@, but with a different
    argument order.

    @since 0.11.0
  

__/Warning:/__ this can fail with an unchecked exception.-}
setAddrRange# :: Addr# -> Int# -> Int# -> State# (RealWorld) -> State# (RealWorld)
setAddrRange# = setAddrRange#

{-|Given an array and an offset in machine words, read an element. The
    index is assumed to be in bounds. Implies a full memory barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
atomicReadIntArray# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int# #)
atomicReadIntArray# = atomicReadIntArray#

{-|Given an array and an offset in machine words, write an element. The
    index is assumed to be in bounds. Implies a full memory barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
atomicWriteIntArray# :: MutableByteArray# s -> Int# -> Int# -> State# s -> State# s
atomicWriteIntArray# = atomicWriteIntArray#

{-|Given an array, an offset in machine words, the expected old value, and
    the new value, perform an atomic compare and swap i.e. write the new
    value if the current value matches the provided old value. Returns
    the value of the element before the operation. Implies a full memory
    barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
casIntArray# :: MutableByteArray# s -> Int# -> Int# -> Int# -> State# s -> (# State# s,Int# #)
casIntArray# = casIntArray#

{-|Given an array, an offset in bytes, the expected old value, and
    the new value, perform an atomic compare and swap i.e. write the new
    value if the current value matches the provided old value. Returns
    the value of the element before the operation. Implies a full memory
    barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
casInt8Array# :: MutableByteArray# s -> Int# -> Int8# -> Int8# -> State# s -> (# State# s,Int8# #)
casInt8Array# = casInt8Array#

{-|Given an array, an offset in 16 bit units, the expected old value, and
    the new value, perform an atomic compare and swap i.e. write the new
    value if the current value matches the provided old value. Returns
    the value of the element before the operation. Implies a full memory
    barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
casInt16Array# :: MutableByteArray# s -> Int# -> Int16# -> Int16# -> State# s -> (# State# s,Int16# #)
casInt16Array# = casInt16Array#

{-|Given an array, an offset in 32 bit units, the expected old value, and
    the new value, perform an atomic compare and swap i.e. write the new
    value if the current value matches the provided old value. Returns
    the value of the element before the operation. Implies a full memory
    barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
casInt32Array# :: MutableByteArray# s -> Int# -> Int32# -> Int32# -> State# s -> (# State# s,Int32# #)
casInt32Array# = casInt32Array#

{-|Given an array, an offset in 64 bit units, the expected old value, and
    the new value, perform an atomic compare and swap i.e. write the new
    value if the current value matches the provided old value. Returns
    the value of the element before the operation. Implies a full memory
    barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
casInt64Array# :: MutableByteArray# s -> Int# -> Int64# -> Int64# -> State# s -> (# State# s,Int64# #)
casInt64Array# = casInt64Array#

{-|Given an array, and offset in machine words, and a value to add,
    atomically add the value to the element. Returns the value of the
    element before the operation. Implies a full memory barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
fetchAddIntArray# :: MutableByteArray# s -> Int# -> Int# -> State# s -> (# State# s,Int# #)
fetchAddIntArray# = fetchAddIntArray#

{-|Given an array, and offset in machine words, and a value to subtract,
    atomically subtract the value from the element. Returns the value of
    the element before the operation. Implies a full memory barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
fetchSubIntArray# :: MutableByteArray# s -> Int# -> Int# -> State# s -> (# State# s,Int# #)
fetchSubIntArray# = fetchSubIntArray#

{-|Given an array, and offset in machine words, and a value to AND,
    atomically AND the value into the element. Returns the value of the
    element before the operation. Implies a full memory barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
fetchAndIntArray# :: MutableByteArray# s -> Int# -> Int# -> State# s -> (# State# s,Int# #)
fetchAndIntArray# = fetchAndIntArray#

{-|Given an array, and offset in machine words, and a value to NAND,
    atomically NAND the value into the element. Returns the value of the
    element before the operation. Implies a full memory barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
fetchNandIntArray# :: MutableByteArray# s -> Int# -> Int# -> State# s -> (# State# s,Int# #)
fetchNandIntArray# = fetchNandIntArray#

{-|Given an array, and offset in machine words, and a value to OR,
    atomically OR the value into the element. Returns the value of the
    element before the operation. Implies a full memory barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
fetchOrIntArray# :: MutableByteArray# s -> Int# -> Int# -> State# s -> (# State# s,Int# #)
fetchOrIntArray# = fetchOrIntArray#

{-|Given an array, and offset in machine words, and a value to XOR,
    atomically XOR the value into the element. Returns the value of the
    element before the operation. Implies a full memory barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
fetchXorIntArray# :: MutableByteArray# s -> Int# -> Int# -> State# s -> (# State# s,Int# #)
fetchXorIntArray# = fetchXorIntArray#

{-| An arbitrary machine address assumed to point outside
         the garbage-collected heap. -}
data Addr#

{-| The null address. -}
nullAddr# :: Addr#
nullAddr# = nullAddr#

plusAddr# :: Addr# -> Int# -> Addr#
plusAddr# = plusAddr#

{-|Result is meaningless if two 'Addr#'s are so far apart that their
         difference doesn't fit in an 'Int#'.-}
minusAddr# :: Addr# -> Addr# -> Int#
minusAddr# = minusAddr#

{-|Return the remainder when the 'Addr#' arg, treated like an 'Int#',
          is divided by the 'Int#' arg.-}
remAddr# :: Addr# -> Int# -> Int#
remAddr# = remAddr#

{-|Coerce directly from address to int. Users are discouraged from using
         this operation as it makes little sense on platforms with tagged pointers.-}
addr2Int# :: Addr# -> Int#
addr2Int# = addr2Int#

{-|Coerce directly from int to address. Users are discouraged from using
         this operation as it makes little sense on platforms with tagged pointers.-}
int2Addr# :: Int# -> Addr#
int2Addr# = int2Addr#

gtAddr# :: Addr# -> Addr# -> Int#
gtAddr# = gtAddr#

geAddr# :: Addr# -> Addr# -> Int#
geAddr# = geAddr#

eqAddr# :: Addr# -> Addr# -> Int#
eqAddr# = eqAddr#

neAddr# :: Addr# -> Addr# -> Int#
neAddr# = neAddr#

ltAddr# :: Addr# -> Addr# -> Int#
ltAddr# = ltAddr#

leAddr# :: Addr# -> Addr# -> Int#
leAddr# = leAddr#

{-|Read an 8-bit character from immutable address; offset in bytes.

-}
indexCharOffAddr# :: Addr# -> Int# -> Char#
indexCharOffAddr# = indexCharOffAddr#

{-|Read a 32-bit character from immutable address; offset in 4-byte words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.-}
indexWideCharOffAddr# :: Addr# -> Int# -> Char#
indexWideCharOffAddr# = indexWideCharOffAddr#

{-|Read a word-sized integer from immutable address; offset in machine words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.-}
indexIntOffAddr# :: Addr# -> Int# -> Int#
indexIntOffAddr# = indexIntOffAddr#

{-|Read a word-sized unsigned integer from immutable address; offset in machine words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.-}
indexWordOffAddr# :: Addr# -> Int# -> Word#
indexWordOffAddr# = indexWordOffAddr#

{-|Read a machine address from immutable address; offset in machine words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.-}
indexAddrOffAddr# :: Addr# -> Int# -> Addr#
indexAddrOffAddr# = indexAddrOffAddr#

{-|Read a single-precision floating-point value from immutable address; offset in 4-byte words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.-}
indexFloatOffAddr# :: Addr# -> Int# -> Float#
indexFloatOffAddr# = indexFloatOffAddr#

{-|Read a double-precision floating-point value from immutable address; offset in 8-byte words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.-}
indexDoubleOffAddr# :: Addr# -> Int# -> Double#
indexDoubleOffAddr# = indexDoubleOffAddr#

{-|Read a 'StablePtr#' value from immutable address; offset in machine words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.-}
indexStablePtrOffAddr# :: Addr# -> Int# -> StablePtr# a
indexStablePtrOffAddr# = indexStablePtrOffAddr#

{-|Read an 8-bit signed integer from immutable address; offset in bytes.

-}
indexInt8OffAddr# :: Addr# -> Int# -> Int8#
indexInt8OffAddr# = indexInt8OffAddr#

{-|Read an 8-bit unsigned integer from immutable address; offset in bytes.

-}
indexWord8OffAddr# :: Addr# -> Int# -> Word8#
indexWord8OffAddr# = indexWord8OffAddr#

{-|Read a 16-bit signed integer from immutable address; offset in 2-byte words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.-}
indexInt16OffAddr# :: Addr# -> Int# -> Int16#
indexInt16OffAddr# = indexInt16OffAddr#

{-|Read a 16-bit unsigned integer from immutable address; offset in 2-byte words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.-}
indexWord16OffAddr# :: Addr# -> Int# -> Word16#
indexWord16OffAddr# = indexWord16OffAddr#

{-|Read a 32-bit signed integer from immutable address; offset in 4-byte words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.-}
indexInt32OffAddr# :: Addr# -> Int# -> Int32#
indexInt32OffAddr# = indexInt32OffAddr#

{-|Read a 32-bit unsigned integer from immutable address; offset in 4-byte words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.-}
indexWord32OffAddr# :: Addr# -> Int# -> Word32#
indexWord32OffAddr# = indexWord32OffAddr#

{-|Read a 64-bit signed integer from immutable address; offset in 8-byte words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.-}
indexInt64OffAddr# :: Addr# -> Int# -> Int64#
indexInt64OffAddr# = indexInt64OffAddr#

{-|Read a 64-bit unsigned integer from immutable address; offset in 8-byte words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.-}
indexWord64OffAddr# :: Addr# -> Int# -> Word64#
indexWord64OffAddr# = indexWord64OffAddr#

{-|Read an 8-bit character from immutable address; offset in bytes.-}
indexWord8OffAddrAsChar# :: Addr# -> Int# -> Char#
indexWord8OffAddrAsChar# = indexWord8OffAddrAsChar#

{-|Read a 32-bit character from immutable address; offset in bytes.-}
indexWord8OffAddrAsWideChar# :: Addr# -> Int# -> Char#
indexWord8OffAddrAsWideChar# = indexWord8OffAddrAsWideChar#

{-|Read a word-sized integer from immutable address; offset in bytes.-}
indexWord8OffAddrAsInt# :: Addr# -> Int# -> Int#
indexWord8OffAddrAsInt# = indexWord8OffAddrAsInt#

{-|Read a word-sized unsigned integer from immutable address; offset in bytes.-}
indexWord8OffAddrAsWord# :: Addr# -> Int# -> Word#
indexWord8OffAddrAsWord# = indexWord8OffAddrAsWord#

{-|Read a machine address from immutable address; offset in bytes.-}
indexWord8OffAddrAsAddr# :: Addr# -> Int# -> Addr#
indexWord8OffAddrAsAddr# = indexWord8OffAddrAsAddr#

{-|Read a single-precision floating-point value from immutable address; offset in bytes.-}
indexWord8OffAddrAsFloat# :: Addr# -> Int# -> Float#
indexWord8OffAddrAsFloat# = indexWord8OffAddrAsFloat#

{-|Read a double-precision floating-point value from immutable address; offset in bytes.-}
indexWord8OffAddrAsDouble# :: Addr# -> Int# -> Double#
indexWord8OffAddrAsDouble# = indexWord8OffAddrAsDouble#

{-|Read a 'StablePtr#' value from immutable address; offset in bytes.-}
indexWord8OffAddrAsStablePtr# :: Addr# -> Int# -> StablePtr# a
indexWord8OffAddrAsStablePtr# = indexWord8OffAddrAsStablePtr#

{-|Read a 16-bit signed integer from immutable address; offset in bytes.-}
indexWord8OffAddrAsInt16# :: Addr# -> Int# -> Int16#
indexWord8OffAddrAsInt16# = indexWord8OffAddrAsInt16#

{-|Read a 16-bit unsigned integer from immutable address; offset in bytes.-}
indexWord8OffAddrAsWord16# :: Addr# -> Int# -> Word16#
indexWord8OffAddrAsWord16# = indexWord8OffAddrAsWord16#

{-|Read a 32-bit signed integer from immutable address; offset in bytes.-}
indexWord8OffAddrAsInt32# :: Addr# -> Int# -> Int32#
indexWord8OffAddrAsInt32# = indexWord8OffAddrAsInt32#

{-|Read a 32-bit unsigned integer from immutable address; offset in bytes.-}
indexWord8OffAddrAsWord32# :: Addr# -> Int# -> Word32#
indexWord8OffAddrAsWord32# = indexWord8OffAddrAsWord32#

{-|Read a 64-bit signed integer from immutable address; offset in bytes.-}
indexWord8OffAddrAsInt64# :: Addr# -> Int# -> Int64#
indexWord8OffAddrAsInt64# = indexWord8OffAddrAsInt64#

{-|Read a 64-bit unsigned integer from immutable address; offset in bytes.-}
indexWord8OffAddrAsWord64# :: Addr# -> Int# -> Word64#
indexWord8OffAddrAsWord64# = indexWord8OffAddrAsWord64#

{-|Read an 8-bit character from mutable address; offset in bytes.



__/Warning:/__ this can fail with an unchecked exception.-}
readCharOffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Char# #)
readCharOffAddr# = readCharOffAddr#

{-|Read a 32-bit character from mutable address; offset in 4-byte words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.

__/Warning:/__ this can fail with an unchecked exception.-}
readWideCharOffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Char# #)
readWideCharOffAddr# = readWideCharOffAddr#

{-|Read a word-sized integer from mutable address; offset in machine words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.

__/Warning:/__ this can fail with an unchecked exception.-}
readIntOffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Int# #)
readIntOffAddr# = readIntOffAddr#

{-|Read a word-sized unsigned integer from mutable address; offset in machine words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.

__/Warning:/__ this can fail with an unchecked exception.-}
readWordOffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Word# #)
readWordOffAddr# = readWordOffAddr#

{-|Read a machine address from mutable address; offset in machine words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.

__/Warning:/__ this can fail with an unchecked exception.-}
readAddrOffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Addr# #)
readAddrOffAddr# = readAddrOffAddr#

{-|Read a single-precision floating-point value from mutable address; offset in 4-byte words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.

__/Warning:/__ this can fail with an unchecked exception.-}
readFloatOffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Float# #)
readFloatOffAddr# = readFloatOffAddr#

{-|Read a double-precision floating-point value from mutable address; offset in 8-byte words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.

__/Warning:/__ this can fail with an unchecked exception.-}
readDoubleOffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Double# #)
readDoubleOffAddr# = readDoubleOffAddr#

{-|Read a 'StablePtr#' value from mutable address; offset in machine words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.

__/Warning:/__ this can fail with an unchecked exception.-}
readStablePtrOffAddr# :: Addr# -> Int# -> State# s -> (# State# s,StablePtr# a #)
readStablePtrOffAddr# = readStablePtrOffAddr#

{-|Read an 8-bit signed integer from mutable address; offset in bytes.



__/Warning:/__ this can fail with an unchecked exception.-}
readInt8OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Int8# #)
readInt8OffAddr# = readInt8OffAddr#

{-|Read an 8-bit unsigned integer from mutable address; offset in bytes.



__/Warning:/__ this can fail with an unchecked exception.-}
readWord8OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Word8# #)
readWord8OffAddr# = readWord8OffAddr#

{-|Read a 16-bit signed integer from mutable address; offset in 2-byte words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.

__/Warning:/__ this can fail with an unchecked exception.-}
readInt16OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Int16# #)
readInt16OffAddr# = readInt16OffAddr#

{-|Read a 16-bit unsigned integer from mutable address; offset in 2-byte words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord16OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Word16# #)
readWord16OffAddr# = readWord16OffAddr#

{-|Read a 32-bit signed integer from mutable address; offset in 4-byte words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.

__/Warning:/__ this can fail with an unchecked exception.-}
readInt32OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Int32# #)
readInt32OffAddr# = readInt32OffAddr#

{-|Read a 32-bit unsigned integer from mutable address; offset in 4-byte words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord32OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Word32# #)
readWord32OffAddr# = readWord32OffAddr#

{-|Read a 64-bit signed integer from mutable address; offset in 8-byte words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.

__/Warning:/__ this can fail with an unchecked exception.-}
readInt64OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Int64# #)
readInt64OffAddr# = readInt64OffAddr#

{-|Read a 64-bit unsigned integer from mutable address; offset in 8-byte words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord64OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Word64# #)
readWord64OffAddr# = readWord64OffAddr#

{-|Read an 8-bit character from mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8OffAddrAsChar# :: Addr# -> Int# -> State# s -> (# State# s,Char# #)
readWord8OffAddrAsChar# = readWord8OffAddrAsChar#

{-|Read a 32-bit character from mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8OffAddrAsWideChar# :: Addr# -> Int# -> State# s -> (# State# s,Char# #)
readWord8OffAddrAsWideChar# = readWord8OffAddrAsWideChar#

{-|Read a word-sized integer from mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8OffAddrAsInt# :: Addr# -> Int# -> State# s -> (# State# s,Int# #)
readWord8OffAddrAsInt# = readWord8OffAddrAsInt#

{-|Read a word-sized unsigned integer from mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8OffAddrAsWord# :: Addr# -> Int# -> State# s -> (# State# s,Word# #)
readWord8OffAddrAsWord# = readWord8OffAddrAsWord#

{-|Read a machine address from mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8OffAddrAsAddr# :: Addr# -> Int# -> State# s -> (# State# s,Addr# #)
readWord8OffAddrAsAddr# = readWord8OffAddrAsAddr#

{-|Read a single-precision floating-point value from mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8OffAddrAsFloat# :: Addr# -> Int# -> State# s -> (# State# s,Float# #)
readWord8OffAddrAsFloat# = readWord8OffAddrAsFloat#

{-|Read a double-precision floating-point value from mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8OffAddrAsDouble# :: Addr# -> Int# -> State# s -> (# State# s,Double# #)
readWord8OffAddrAsDouble# = readWord8OffAddrAsDouble#

{-|Read a 'StablePtr#' value from mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8OffAddrAsStablePtr# :: Addr# -> Int# -> State# s -> (# State# s,StablePtr# a #)
readWord8OffAddrAsStablePtr# = readWord8OffAddrAsStablePtr#

{-|Read a 16-bit signed integer from mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8OffAddrAsInt16# :: Addr# -> Int# -> State# s -> (# State# s,Int16# #)
readWord8OffAddrAsInt16# = readWord8OffAddrAsInt16#

{-|Read a 16-bit unsigned integer from mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8OffAddrAsWord16# :: Addr# -> Int# -> State# s -> (# State# s,Word16# #)
readWord8OffAddrAsWord16# = readWord8OffAddrAsWord16#

{-|Read a 32-bit signed integer from mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8OffAddrAsInt32# :: Addr# -> Int# -> State# s -> (# State# s,Int32# #)
readWord8OffAddrAsInt32# = readWord8OffAddrAsInt32#

{-|Read a 32-bit unsigned integer from mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8OffAddrAsWord32# :: Addr# -> Int# -> State# s -> (# State# s,Word32# #)
readWord8OffAddrAsWord32# = readWord8OffAddrAsWord32#

{-|Read a 64-bit signed integer from mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8OffAddrAsInt64# :: Addr# -> Int# -> State# s -> (# State# s,Int64# #)
readWord8OffAddrAsInt64# = readWord8OffAddrAsInt64#

{-|Read a 64-bit unsigned integer from mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8OffAddrAsWord64# :: Addr# -> Int# -> State# s -> (# State# s,Word64# #)
readWord8OffAddrAsWord64# = readWord8OffAddrAsWord64#

{-|Write an 8-bit character to mutable address; offset in bytes.



__/Warning:/__ this can fail with an unchecked exception.-}
writeCharOffAddr# :: Addr# -> Int# -> Char# -> State# s -> State# s
writeCharOffAddr# = writeCharOffAddr#

{-|Write a 32-bit character to mutable address; offset in 4-byte words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWideCharOffAddr# :: Addr# -> Int# -> Char# -> State# s -> State# s
writeWideCharOffAddr# = writeWideCharOffAddr#

{-|Write a word-sized integer to mutable address; offset in machine words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.

__/Warning:/__ this can fail with an unchecked exception.-}
writeIntOffAddr# :: Addr# -> Int# -> Int# -> State# s -> State# s
writeIntOffAddr# = writeIntOffAddr#

{-|Write a word-sized unsigned integer to mutable address; offset in machine words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWordOffAddr# :: Addr# -> Int# -> Word# -> State# s -> State# s
writeWordOffAddr# = writeWordOffAddr#

{-|Write a machine address to mutable address; offset in machine words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.

__/Warning:/__ this can fail with an unchecked exception.-}
writeAddrOffAddr# :: Addr# -> Int# -> Addr# -> State# s -> State# s
writeAddrOffAddr# = writeAddrOffAddr#

{-|Write a single-precision floating-point value to mutable address; offset in 4-byte words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.

__/Warning:/__ this can fail with an unchecked exception.-}
writeFloatOffAddr# :: Addr# -> Int# -> Float# -> State# s -> State# s
writeFloatOffAddr# = writeFloatOffAddr#

{-|Write a double-precision floating-point value to mutable address; offset in 8-byte words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.

__/Warning:/__ this can fail with an unchecked exception.-}
writeDoubleOffAddr# :: Addr# -> Int# -> Double# -> State# s -> State# s
writeDoubleOffAddr# = writeDoubleOffAddr#

{-|Write a 'StablePtr#' value to mutable address; offset in machine words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.

__/Warning:/__ this can fail with an unchecked exception.-}
writeStablePtrOffAddr# :: Addr# -> Int# -> StablePtr# a -> State# s -> State# s
writeStablePtrOffAddr# = writeStablePtrOffAddr#

{-|Write an 8-bit signed integer to mutable address; offset in bytes.



__/Warning:/__ this can fail with an unchecked exception.-}
writeInt8OffAddr# :: Addr# -> Int# -> Int8# -> State# s -> State# s
writeInt8OffAddr# = writeInt8OffAddr#

{-|Write an 8-bit unsigned integer to mutable address; offset in bytes.



__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8OffAddr# :: Addr# -> Int# -> Word8# -> State# s -> State# s
writeWord8OffAddr# = writeWord8OffAddr#

{-|Write a 16-bit signed integer to mutable address; offset in 2-byte words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt16OffAddr# :: Addr# -> Int# -> Int16# -> State# s -> State# s
writeInt16OffAddr# = writeInt16OffAddr#

{-|Write a 16-bit unsigned integer to mutable address; offset in 2-byte words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord16OffAddr# :: Addr# -> Int# -> Word16# -> State# s -> State# s
writeWord16OffAddr# = writeWord16OffAddr#

{-|Write a 32-bit signed integer to mutable address; offset in 4-byte words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt32OffAddr# :: Addr# -> Int# -> Int32# -> State# s -> State# s
writeInt32OffAddr# = writeInt32OffAddr#

{-|Write a 32-bit unsigned integer to mutable address; offset in 4-byte words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord32OffAddr# :: Addr# -> Int# -> Word32# -> State# s -> State# s
writeWord32OffAddr# = writeWord32OffAddr#

{-|Write a 64-bit signed integer to mutable address; offset in 8-byte words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt64OffAddr# :: Addr# -> Int# -> Int64# -> State# s -> State# s
writeInt64OffAddr# = writeInt64OffAddr#

{-|Write a 64-bit unsigned integer to mutable address; offset in 8-byte words.

On some platforms, the access may fail
for an insufficiently aligned @Addr#@.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord64OffAddr# :: Addr# -> Int# -> Word64# -> State# s -> State# s
writeWord64OffAddr# = writeWord64OffAddr#

{-|Write an 8-bit character to mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8OffAddrAsChar# :: Addr# -> Int# -> Char# -> State# s -> State# s
writeWord8OffAddrAsChar# = writeWord8OffAddrAsChar#

{-|Write a 32-bit character to mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8OffAddrAsWideChar# :: Addr# -> Int# -> Char# -> State# s -> State# s
writeWord8OffAddrAsWideChar# = writeWord8OffAddrAsWideChar#

{-|Write a word-sized integer to mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8OffAddrAsInt# :: Addr# -> Int# -> Int# -> State# s -> State# s
writeWord8OffAddrAsInt# = writeWord8OffAddrAsInt#

{-|Write a word-sized unsigned integer to mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8OffAddrAsWord# :: Addr# -> Int# -> Word# -> State# s -> State# s
writeWord8OffAddrAsWord# = writeWord8OffAddrAsWord#

{-|Write a machine address to mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8OffAddrAsAddr# :: Addr# -> Int# -> Addr# -> State# s -> State# s
writeWord8OffAddrAsAddr# = writeWord8OffAddrAsAddr#

{-|Write a single-precision floating-point value to mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8OffAddrAsFloat# :: Addr# -> Int# -> Float# -> State# s -> State# s
writeWord8OffAddrAsFloat# = writeWord8OffAddrAsFloat#

{-|Write a double-precision floating-point value to mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8OffAddrAsDouble# :: Addr# -> Int# -> Double# -> State# s -> State# s
writeWord8OffAddrAsDouble# = writeWord8OffAddrAsDouble#

{-|Write a 'StablePtr#' value to mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8OffAddrAsStablePtr# :: Addr# -> Int# -> StablePtr# a -> State# s -> State# s
writeWord8OffAddrAsStablePtr# = writeWord8OffAddrAsStablePtr#

{-|Write a 16-bit signed integer to mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8OffAddrAsInt16# :: Addr# -> Int# -> Int16# -> State# s -> State# s
writeWord8OffAddrAsInt16# = writeWord8OffAddrAsInt16#

{-|Write a 16-bit unsigned integer to mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8OffAddrAsWord16# :: Addr# -> Int# -> Word16# -> State# s -> State# s
writeWord8OffAddrAsWord16# = writeWord8OffAddrAsWord16#

{-|Write a 32-bit signed integer to mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8OffAddrAsInt32# :: Addr# -> Int# -> Int32# -> State# s -> State# s
writeWord8OffAddrAsInt32# = writeWord8OffAddrAsInt32#

{-|Write a 32-bit unsigned integer to mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8OffAddrAsWord32# :: Addr# -> Int# -> Word32# -> State# s -> State# s
writeWord8OffAddrAsWord32# = writeWord8OffAddrAsWord32#

{-|Write a 64-bit signed integer to mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8OffAddrAsInt64# :: Addr# -> Int# -> Int64# -> State# s -> State# s
writeWord8OffAddrAsInt64# = writeWord8OffAddrAsInt64#

{-|Write a 64-bit unsigned integer to mutable address; offset in bytes.

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8OffAddrAsWord64# :: Addr# -> Int# -> Word64# -> State# s -> State# s
writeWord8OffAddrAsWord64# = writeWord8OffAddrAsWord64#

{-|The atomic exchange operation. Atomically exchanges the value at the first address
    with the Addr# given as second argument. Implies a read barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
atomicExchangeAddrAddr# :: Addr# -> Addr# -> State# s -> (# State# s,Addr# #)
atomicExchangeAddrAddr# = atomicExchangeAddrAddr#

{-|The atomic exchange operation. Atomically exchanges the value at the address
    with the given value. Returns the old value. Implies a read barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
atomicExchangeWordAddr# :: Addr# -> Word# -> State# s -> (# State# s,Word# #)
atomicExchangeWordAddr# = atomicExchangeWordAddr#

{-| Compare and swap on a word-sized memory location.

     Use as: \s -> atomicCasAddrAddr# location expected desired s

     This version always returns the old value read. This follows the normal
     protocol for CAS operations (and matches the underlying instruction on
     most architectures).

     Implies a full memory barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
atomicCasAddrAddr# :: Addr# -> Addr# -> Addr# -> State# s -> (# State# s,Addr# #)
atomicCasAddrAddr# = atomicCasAddrAddr#

{-| Compare and swap on a word-sized and aligned memory location.

     Use as: \s -> atomicCasWordAddr# location expected desired s

     This version always returns the old value read. This follows the normal
     protocol for CAS operations (and matches the underlying instruction on
     most architectures).

     Implies a full memory barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
atomicCasWordAddr# :: Addr# -> Word# -> Word# -> State# s -> (# State# s,Word# #)
atomicCasWordAddr# = atomicCasWordAddr#

{-| Compare and swap on a 8 bit-sized and aligned memory location.

     Use as: \s -> atomicCasWordAddr8# location expected desired s

     This version always returns the old value read. This follows the normal
     protocol for CAS operations (and matches the underlying instruction on
     most architectures).

     Implies a full memory barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
atomicCasWord8Addr# :: Addr# -> Word8# -> Word8# -> State# s -> (# State# s,Word8# #)
atomicCasWord8Addr# = atomicCasWord8Addr#

{-| Compare and swap on a 16 bit-sized and aligned memory location.

     Use as: \s -> atomicCasWordAddr16# location expected desired s

     This version always returns the old value read. This follows the normal
     protocol for CAS operations (and matches the underlying instruction on
     most architectures).

     Implies a full memory barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
atomicCasWord16Addr# :: Addr# -> Word16# -> Word16# -> State# s -> (# State# s,Word16# #)
atomicCasWord16Addr# = atomicCasWord16Addr#

{-| Compare and swap on a 32 bit-sized and aligned memory location.

     Use as: \s -> atomicCasWordAddr32# location expected desired s

     This version always returns the old value read. This follows the normal
     protocol for CAS operations (and matches the underlying instruction on
     most architectures).

     Implies a full memory barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
atomicCasWord32Addr# :: Addr# -> Word32# -> Word32# -> State# s -> (# State# s,Word32# #)
atomicCasWord32Addr# = atomicCasWord32Addr#

{-| Compare and swap on a 64 bit-sized and aligned memory location.

     Use as: \s -> atomicCasWordAddr64# location expected desired s

     This version always returns the old value read. This follows the normal
     protocol for CAS operations (and matches the underlying instruction on
     most architectures).

     Implies a full memory barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
atomicCasWord64Addr# :: Addr# -> Word64# -> Word64# -> State# s -> (# State# s,Word64# #)
atomicCasWord64Addr# = atomicCasWord64Addr#

{-|Given an address, and a value to add,
    atomically add the value to the element. Returns the value of the
    element before the operation. Implies a full memory barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
fetchAddWordAddr# :: Addr# -> Word# -> State# s -> (# State# s,Word# #)
fetchAddWordAddr# = fetchAddWordAddr#

{-|Given an address, and a value to subtract,
    atomically subtract the value from the element. Returns the value of
    the element before the operation. Implies a full memory barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
fetchSubWordAddr# :: Addr# -> Word# -> State# s -> (# State# s,Word# #)
fetchSubWordAddr# = fetchSubWordAddr#

{-|Given an address, and a value to AND,
    atomically AND the value into the element. Returns the value of the
    element before the operation. Implies a full memory barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
fetchAndWordAddr# :: Addr# -> Word# -> State# s -> (# State# s,Word# #)
fetchAndWordAddr# = fetchAndWordAddr#

{-|Given an address, and a value to NAND,
    atomically NAND the value into the element. Returns the value of the
    element before the operation. Implies a full memory barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
fetchNandWordAddr# :: Addr# -> Word# -> State# s -> (# State# s,Word# #)
fetchNandWordAddr# = fetchNandWordAddr#

{-|Given an address, and a value to OR,
    atomically OR the value into the element. Returns the value of the
    element before the operation. Implies a full memory barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
fetchOrWordAddr# :: Addr# -> Word# -> State# s -> (# State# s,Word# #)
fetchOrWordAddr# = fetchOrWordAddr#

{-|Given an address, and a value to XOR,
    atomically XOR the value into the element. Returns the value of the
    element before the operation. Implies a full memory barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
fetchXorWordAddr# :: Addr# -> Word# -> State# s -> (# State# s,Word# #)
fetchXorWordAddr# = fetchXorWordAddr#

{-|Given an address, read a machine word.  Implies a full memory barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
atomicReadWordAddr# :: Addr# -> State# s -> (# State# s,Word# #)
atomicReadWordAddr# = atomicReadWordAddr#

{-|Given an address, write a machine word. Implies a full memory barrier.

__/Warning:/__ this can fail with an unchecked exception.-}
atomicWriteWordAddr# :: Addr# -> Word# -> State# s -> State# s
atomicWriteWordAddr# = atomicWriteWordAddr#

{-|A 'MutVar#' behaves like a single-element mutable array.-}
data MutVar# s a

{-|Create 'MutVar#' with specified initial value in specified state thread.-}
newMutVar# :: a_levpoly -> State# s -> (# State# s,MutVar# s a_levpoly #)
newMutVar# = newMutVar#

{-|Read contents of 'MutVar#'. Result is not yet evaluated.-}
readMutVar# :: MutVar# s a_levpoly -> State# s -> (# State# s,a_levpoly #)
readMutVar# = readMutVar#

{-|Write contents of 'MutVar#'.-}
writeMutVar# :: MutVar# s a_levpoly -> a_levpoly -> State# s -> State# s
writeMutVar# = writeMutVar#

{-|Atomically exchange the value of a 'MutVar#'.-}
atomicSwapMutVar# :: MutVar# s a_levpoly -> a_levpoly -> State# s -> (# State# s,a_levpoly #)
atomicSwapMutVar# = atomicSwapMutVar#

{-| Modify the contents of a 'MutVar#', returning the previous
     contents @x :: a@ and the result of applying the given function to the
     previous contents @f x :: c@.

     The @data@ type @c@ (not a @newtype@!) must be a record whose first field
     is of lifted type @a :: Type@ and is not unpacked. For example, product
     types @c ~ Solo a@ or @c ~ (a, b)@ work well. If the record type is both
     monomorphic and strict in its first field, it's recommended to mark the
     latter @{-# NOUNPACK #-}@ explicitly.

     Under the hood 'atomicModifyMutVar2#' atomically replaces a pointer to an
     old @x :: a@ with a pointer to a selector thunk @fst r@, where
     @fst@ is a selector for the first field of the record and @r@ is a
     function application thunk @r = f x@.

     @atomicModifyIORef2Native@ from @atomic-modify-general@ package makes an
     effort to reflect restrictions on @c@ faithfully, providing a
     well-typed high-level wrapper.-}
atomicModifyMutVar2# :: MutVar# s a -> (a -> c) -> State# s -> (# State# s,a,c #)
atomicModifyMutVar2# = atomicModifyMutVar2#

{-| Modify the contents of a 'MutVar#', returning the previous
     contents and the result of applying the given function to the
     previous contents. -}
atomicModifyMutVar_# :: MutVar# s a -> (a -> a) -> State# s -> (# State# s,a,a #)
atomicModifyMutVar_# = atomicModifyMutVar_#

{-| Compare-and-swap: perform a pointer equality test between
     the first value passed to this function and the value
     stored inside the 'MutVar#'. If the pointers are equal,
     replace the stored value with the second value passed to this
     function, otherwise do nothing.
     Returns the final value stored inside the 'MutVar#'.
     The 'Int#' indicates whether a swap took place,
     with @1#@ meaning that we didn't swap, and @0#@
     that we did.
     Implies a full memory barrier.
     Because the comparison is done on the level of pointers,
     all of the difficulties of using
     'reallyUnsafePtrEquality#' correctly apply to
     'casMutVar#' as well.
   -}
casMutVar# :: MutVar# s a_levpoly -> a_levpoly -> a_levpoly -> State# s -> (# State# s,Int#,a_levpoly #)
casMutVar# = casMutVar#

{-| @'catch#' k handler s@ evaluates @k s@, invoking @handler@ on any exceptions
     thrown.

     Note that the result type here isn't quite as unrestricted as the
     polymorphic type might suggest; see the section \"RuntimeRep polymorphism
     in continuation-style primops\" for details. -}
catch# :: (State# (RealWorld) -> (# State# (RealWorld),a_reppoly #)) -> (b_levpoly -> State# (RealWorld) -> (# State# (RealWorld),a_reppoly #)) -> State# (RealWorld) -> (# State# (RealWorld),a_reppoly #)
catch# = catch#

raise# :: a_levpoly -> b_reppoly
raise# = raise#

raiseUnderflow# :: (#  #) -> b_reppoly
raiseUnderflow# = raiseUnderflow#

raiseOverflow# :: (#  #) -> b_reppoly
raiseOverflow# = raiseOverflow#

raiseDivZero# :: (#  #) -> b_reppoly
raiseDivZero# = raiseDivZero#

raiseIO# :: a_levpoly -> State# (RealWorld) -> (# State# (RealWorld),b_reppoly #)
raiseIO# = raiseIO#

{-| @'maskAsyncExceptions#' k s@ evaluates @k s@ such that asynchronous
     exceptions are deferred until after evaluation has finished.

     Note that the result type here isn't quite as unrestricted as the
     polymorphic type might suggest; see the section \"RuntimeRep polymorphism
     in continuation-style primops\" for details. -}
maskAsyncExceptions# :: (State# (RealWorld) -> (# State# (RealWorld),a_reppoly #)) -> State# (RealWorld) -> (# State# (RealWorld),a_reppoly #)
maskAsyncExceptions# = maskAsyncExceptions#

{-| @'maskUninterruptible#' k s@ evaluates @k s@ such that asynchronous
     exceptions are deferred until after evaluation has finished.

     Note that the result type here isn't quite as unrestricted as the
     polymorphic type might suggest; see the section \"RuntimeRep polymorphism
     in continuation-style primops\" for details. -}
maskUninterruptible# :: (State# (RealWorld) -> (# State# (RealWorld),a_reppoly #)) -> State# (RealWorld) -> (# State# (RealWorld),a_reppoly #)
maskUninterruptible# = maskUninterruptible#

{-| @'unmaskAsyncUninterruptible#' k s@ evaluates @k s@ such that asynchronous
     exceptions are unmasked.

     Note that the result type here isn't quite as unrestricted as the
     polymorphic type might suggest; see the section \"RuntimeRep polymorphism
     in continuation-style primops\" for details. -}
unmaskAsyncExceptions# :: (State# (RealWorld) -> (# State# (RealWorld),a_reppoly #)) -> State# (RealWorld) -> (# State# (RealWorld),a_reppoly #)
unmaskAsyncExceptions# = unmaskAsyncExceptions#

getMaskingState# :: State# (RealWorld) -> (# State# (RealWorld),Int# #)
getMaskingState# = getMaskingState#

{-| See "GHC.Prim#continuations". -}
data PromptTag# a

{-| See "GHC.Prim#continuations". -}
newPromptTag# :: State# (RealWorld) -> (# State# (RealWorld),PromptTag# a #)
newPromptTag# = newPromptTag#

{-| See "GHC.Prim#continuations". -}
prompt# :: PromptTag# a -> (State# (RealWorld) -> (# State# (RealWorld),a #)) -> State# (RealWorld) -> (# State# (RealWorld),a #)
prompt# = prompt#

{-| See "GHC.Prim#continuations". 

__/Warning:/__ this can fail with an unchecked exception.-}
control0# :: PromptTag# a -> (((State# (RealWorld) -> (# State# (RealWorld),b_reppoly #)) -> State# (RealWorld) -> (# State# (RealWorld),a #)) -> State# (RealWorld) -> (# State# (RealWorld),a #)) -> State# (RealWorld) -> (# State# (RealWorld),b_reppoly #)
control0# = control0#

data TVar# s a

atomically# :: (State# (RealWorld) -> (# State# (RealWorld),a_levpoly #)) -> State# (RealWorld) -> (# State# (RealWorld),a_levpoly #)
atomically# = atomically#

retry# :: State# (RealWorld) -> (# State# (RealWorld),a_levpoly #)
retry# = retry#

catchRetry# :: (State# (RealWorld) -> (# State# (RealWorld),a_levpoly #)) -> (State# (RealWorld) -> (# State# (RealWorld),a_levpoly #)) -> State# (RealWorld) -> (# State# (RealWorld),a_levpoly #)
catchRetry# = catchRetry#

catchSTM# :: (State# (RealWorld) -> (# State# (RealWorld),a_levpoly #)) -> (b -> State# (RealWorld) -> (# State# (RealWorld),a_levpoly #)) -> State# (RealWorld) -> (# State# (RealWorld),a_levpoly #)
catchSTM# = catchSTM#

{-|Create a new 'TVar#' holding a specified initial value.-}
newTVar# :: a_levpoly -> State# s -> (# State# s,TVar# s a_levpoly #)
newTVar# = newTVar#

{-|Read contents of 'TVar#' inside an STM transaction,
    i.e. within a call to 'atomically#'.
    Does not force evaluation of the result.-}
readTVar# :: TVar# s a_levpoly -> State# s -> (# State# s,a_levpoly #)
readTVar# = readTVar#

{-|Read contents of 'TVar#' outside an STM transaction.
   Does not force evaluation of the result.-}
readTVarIO# :: TVar# s a_levpoly -> State# s -> (# State# s,a_levpoly #)
readTVarIO# = readTVarIO#

{-|Write contents of 'TVar#'.-}
writeTVar# :: TVar# s a_levpoly -> a_levpoly -> State# s -> State# s
writeTVar# = writeTVar#

{-| A shared mutable variable (/not/ the same as a 'MutVar#'!).
        (Note: in a non-concurrent implementation, @('MVar#' a)@ can be
        represented by @('MutVar#' (Maybe a))@.) -}
data MVar# s a

{-|Create new 'MVar#'; initially empty.-}
newMVar# :: State# s -> (# State# s,MVar# s a_levpoly #)
newMVar# = newMVar#

{-|If 'MVar#' is empty, block until it becomes full.
   Then remove and return its contents, and set it empty.-}
takeMVar# :: MVar# s a_levpoly -> State# s -> (# State# s,a_levpoly #)
takeMVar# = takeMVar#

{-|If 'MVar#' is empty, immediately return with integer 0 and value undefined.
   Otherwise, return with integer 1 and contents of 'MVar#', and set 'MVar#' empty.-}
tryTakeMVar# :: MVar# s a_levpoly -> State# s -> (# State# s,Int#,a_levpoly #)
tryTakeMVar# = tryTakeMVar#

{-|If 'MVar#' is full, block until it becomes empty.
   Then store value arg as its new contents.-}
putMVar# :: MVar# s a_levpoly -> a_levpoly -> State# s -> State# s
putMVar# = putMVar#

{-|If 'MVar#' is full, immediately return with integer 0.
    Otherwise, store value arg as 'MVar#''s new contents, and return with integer 1.-}
tryPutMVar# :: MVar# s a_levpoly -> a_levpoly -> State# s -> (# State# s,Int# #)
tryPutMVar# = tryPutMVar#

{-|If 'MVar#' is empty, block until it becomes full.
   Then read its contents without modifying the MVar, without possibility
   of intervention from other threads.-}
readMVar# :: MVar# s a_levpoly -> State# s -> (# State# s,a_levpoly #)
readMVar# = readMVar#

{-|If 'MVar#' is empty, immediately return with integer 0 and value undefined.
   Otherwise, return with integer 1 and contents of 'MVar#'.-}
tryReadMVar# :: MVar# s a_levpoly -> State# s -> (# State# s,Int#,a_levpoly #)
tryReadMVar# = tryReadMVar#

{-|Return 1 if 'MVar#' is empty; 0 otherwise.-}
isEmptyMVar# :: MVar# s a_levpoly -> State# s -> (# State# s,Int# #)
isEmptyMVar# = isEmptyMVar#

{-|Sleep specified number of microseconds.-}
delay# :: Int# -> State# s -> State# s
delay# = delay#

{-|Block until input is available on specified file descriptor.-}
waitRead# :: Int# -> State# s -> State# s
waitRead# = waitRead#

{-|Block until output is possible on specified file descriptor.-}
waitWrite# :: Int# -> State# s -> State# s
waitWrite# = waitWrite#

{-| 'State#' is the primitive, unlifted type of states.  It has
        one type parameter, thus @'State#' 'RealWorld'@, or @'State#' s@,
        where s is a type variable. The only purpose of the type parameter
        is to keep different state threads separate.  It is represented by
        nothing at all. -}
data State# s

{-| 'RealWorld' is deeply magical.  It is /primitive/, but it is not
        /unlifted/ (hence @ptrArg@).  We never manipulate values of type
        'RealWorld'; it's only used in the type system, to parameterise 'State#'. -}
data RealWorld

{-|(In a non-concurrent implementation, this can be a singleton
        type, whose (unique) value is returned by 'myThreadId#'.  The
        other operations can be omitted.)-}
data ThreadId#

fork# :: (State# (RealWorld) -> (# State# (RealWorld),a_reppoly #)) -> State# (RealWorld) -> (# State# (RealWorld),ThreadId# #)
fork# = fork#

forkOn# :: Int# -> (State# (RealWorld) -> (# State# (RealWorld),a_reppoly #)) -> State# (RealWorld) -> (# State# (RealWorld),ThreadId# #)
forkOn# = forkOn#

killThread# :: ThreadId# -> a -> State# (RealWorld) -> State# (RealWorld)
killThread# = killThread#

yield# :: State# (RealWorld) -> State# (RealWorld)
yield# = yield#

myThreadId# :: State# (RealWorld) -> (# State# (RealWorld),ThreadId# #)
myThreadId# = myThreadId#

{-|Set the label of the given thread. The @ByteArray#@ should contain
    a UTF-8-encoded string.-}
labelThread# :: ThreadId# -> ByteArray# -> State# (RealWorld) -> State# (RealWorld)
labelThread# = labelThread#

isCurrentThreadBound# :: State# (RealWorld) -> (# State# (RealWorld),Int# #)
isCurrentThreadBound# = isCurrentThreadBound#

noDuplicate# :: State# s -> State# s
noDuplicate# = noDuplicate#

{-|Get the label of the given thread.
    Morally of type @ThreadId# -> IO (Maybe ByteArray#)@, with a @1#@ tag
    denoting @Just@.

    @since 0.10-}
threadLabel# :: ThreadId# -> State# (RealWorld) -> (# State# (RealWorld),Int#,ByteArray# #)
threadLabel# = threadLabel#

{-|Get the status of the given thread. Result is
    @(ThreadStatus, Capability, Locked)@ where
    @ThreadStatus@ is one of the status constants defined in
    @rts/Constants.h@, @Capability@ is the number of
    the capability which currently owns the thread, and
    @Locked@ is a boolean indicating whether the
    thread is bound to that capability.

    @since 0.9-}
threadStatus# :: ThreadId# -> State# (RealWorld) -> (# State# (RealWorld),Int#,Int#,Int# #)
threadStatus# = threadStatus#

{-| Returns an array of the threads started by the program. Note that this
     threads which have finished execution may or may not be present in this
     list, depending upon whether they have been collected by the garbage collector.

     @since 0.10-}
listThreads# :: State# (RealWorld) -> (# State# (RealWorld),Array# (ThreadId#) #)
listThreads# = listThreads#

data Weak# b

{-| @'mkWeak#' k v finalizer s@ creates a weak reference to value @k@,
     with an associated reference to some value @v@. If @k@ is still
     alive then @v@ can be retrieved using 'deRefWeak#'. Note that
     the type of @k@ must be represented by a pointer (i.e. of kind
     @'TYPE' ''LiftedRep' or @'TYPE' ''UnliftedRep'@). -}
mkWeak# :: a_levpoly -> b_levpoly -> (State# (RealWorld) -> (# State# (RealWorld),c #)) -> State# (RealWorld) -> (# State# (RealWorld),Weak# b_levpoly #)
mkWeak# = mkWeak#

mkWeakNoFinalizer# :: a_levpoly -> b_levpoly -> State# (RealWorld) -> (# State# (RealWorld),Weak# b_levpoly #)
mkWeakNoFinalizer# = mkWeakNoFinalizer#

{-| @'addCFinalizerToWeak#' fptr ptr flag eptr w@ attaches a C
     function pointer @fptr@ to a weak pointer @w@ as a finalizer. If
     @flag@ is zero, @fptr@ will be called with one argument,
     @ptr@. Otherwise, it will be called with two arguments,
     @eptr@ and @ptr@. 'addCFinalizerToWeak#' returns
     1 on success, or 0 if @w@ is already dead. -}
addCFinalizerToWeak# :: Addr# -> Addr# -> Int# -> Addr# -> Weak# b_levpoly -> State# (RealWorld) -> (# State# (RealWorld),Int# #)
addCFinalizerToWeak# = addCFinalizerToWeak#

deRefWeak# :: Weak# a_levpoly -> State# (RealWorld) -> (# State# (RealWorld),Int#,a_levpoly #)
deRefWeak# = deRefWeak#

{-| Finalize a weak pointer. The return value is an unboxed tuple
     containing the new state of the world and an "unboxed Maybe",
     represented by an 'Int#' and a (possibly invalid) finalization
     action. An 'Int#' of @1@ indicates that the finalizer is valid. The
     return value @b@ from the finalizer should be ignored. -}
finalizeWeak# :: Weak# a_levpoly -> State# (RealWorld) -> (# State# (RealWorld),Int#,State# (RealWorld) -> (# State# (RealWorld),b #) #)
finalizeWeak# = finalizeWeak#

touch# :: a_levpoly -> State# s -> State# s
touch# = touch#

data StablePtr# a

data StableName# a

makeStablePtr# :: a_levpoly -> State# (RealWorld) -> (# State# (RealWorld),StablePtr# a_levpoly #)
makeStablePtr# = makeStablePtr#

deRefStablePtr# :: StablePtr# a_levpoly -> State# (RealWorld) -> (# State# (RealWorld),a_levpoly #)
deRefStablePtr# = deRefStablePtr#

eqStablePtr# :: StablePtr# a_levpoly -> StablePtr# a_levpoly -> Int#
eqStablePtr# = eqStablePtr#

makeStableName# :: a_levpoly -> State# (RealWorld) -> (# State# (RealWorld),StableName# a_levpoly #)
makeStableName# = makeStableName#

stableNameToInt# :: StableName# a_levpoly -> Int#
stableNameToInt# = stableNameToInt#

data Compact#

{-| Create a new CNF with a single compact block. The argument is
     the capacity of the compact block (in bytes, not words).
     The capacity is rounded up to a multiple of the allocator block size
     and is capped to one mega block. -}
compactNew# :: Word# -> State# (RealWorld) -> (# State# (RealWorld),Compact# #)
compactNew# = compactNew#

{-| Set the new allocation size of the CNF. This value (in bytes)
     determines the capacity of each compact block in the CNF. It
     does not retroactively affect existing compact blocks in the CNF. -}
compactResize# :: Compact# -> Word# -> State# (RealWorld) -> State# (RealWorld)
compactResize# = compactResize#

{-| Returns 1\# if the object is contained in the CNF, 0\# otherwise. -}
compactContains# :: Compact# -> a -> State# (RealWorld) -> (# State# (RealWorld),Int# #)
compactContains# = compactContains#

{-| Returns 1\# if the object is in any CNF at all, 0\# otherwise. -}
compactContainsAny# :: a -> State# (RealWorld) -> (# State# (RealWorld),Int# #)
compactContainsAny# = compactContainsAny#

{-| Returns the address and the utilized size (in bytes) of the
     first compact block of a CNF.-}
compactGetFirstBlock# :: Compact# -> State# (RealWorld) -> (# State# (RealWorld),Addr#,Word# #)
compactGetFirstBlock# = compactGetFirstBlock#

{-| Given a CNF and the address of one its compact blocks, returns the
     next compact block and its utilized size, or 'nullAddr#' if the
     argument was the last compact block in the CNF. -}
compactGetNextBlock# :: Compact# -> Addr# -> State# (RealWorld) -> (# State# (RealWorld),Addr#,Word# #)
compactGetNextBlock# = compactGetNextBlock#

{-| Attempt to allocate a compact block with the capacity (in
     bytes) given by the first argument. The 'Addr#' is a pointer
     to previous compact block of the CNF or 'nullAddr#' to create a
     new CNF with a single compact block.

     The resulting block is not known to the GC until
     'compactFixupPointers#' is called on it, and care must be taken
     so that the address does not escape or memory will be leaked.
   -}
compactAllocateBlock# :: Word# -> Addr# -> State# (RealWorld) -> (# State# (RealWorld),Addr# #)
compactAllocateBlock# = compactAllocateBlock#

{-| Given the pointer to the first block of a CNF and the
     address of the root object in the old address space, fix up
     the internal pointers inside the CNF to account for
     a different position in memory than when it was serialized.
     This method must be called exactly once after importing
     a serialized CNF. It returns the new CNF and the new adjusted
     root address. -}
compactFixupPointers# :: Addr# -> Addr# -> State# (RealWorld) -> (# State# (RealWorld),Compact#,Addr# #)
compactFixupPointers# = compactFixupPointers#

{-| Recursively add a closure and its transitive closure to a
     'Compact#' (a CNF), evaluating any unevaluated components
     at the same time. Note: 'compactAdd#' is not thread-safe, so
     only one thread may call 'compactAdd#' with a particular
     'Compact#' at any given time. The primop does not
     enforce any mutual exclusion; the caller is expected to
     arrange this. -}
compactAdd# :: Compact# -> a -> State# (RealWorld) -> (# State# (RealWorld),a #)
compactAdd# = compactAdd#

{-| Like 'compactAdd#', but retains sharing and cycles
   during compaction. -}
compactAddWithSharing# :: Compact# -> a -> State# (RealWorld) -> (# State# (RealWorld),a #)
compactAddWithSharing# = compactAddWithSharing#

{-| Return the total capacity (in bytes) of all the compact blocks
     in the CNF. -}
compactSize# :: Compact# -> State# (RealWorld) -> (# State# (RealWorld),Word# #)
compactSize# = compactSize#

{-| Returns @1#@ if the given pointers are equal and @0#@ otherwise. -}
reallyUnsafePtrEquality# :: a_levpoly -> b_levpoly -> Int#
reallyUnsafePtrEquality# = reallyUnsafePtrEquality#

{-|Create a new spark evaluating the given argument.
    The return value should always be 1.
    Users are encouraged to use spark# instead.-}
par# :: a -> Int#
par# = par#

spark# :: a -> State# s -> (# State# s,a #)
spark# = spark#

getSpark# :: State# s -> (# State# s,Int#,a #)
getSpark# = getSpark#

{-| Returns the number of sparks in the local spark pool. -}
numSparks# :: State# s -> (# State# s,Int# #)
numSparks# = numSparks#

{-| @'keepAlive#' x s k@ keeps the value @x@ alive during the execution
     of the computation @k@.

     Note that the result type here isn't quite as unrestricted as the
     polymorphic type might suggest; see the section \"RuntimeRep polymorphism
     in continuation-style primops\" for details. -}
keepAlive# :: a_levpoly -> State# s -> (State# s -> b_reppoly) -> b_reppoly
keepAlive# = keepAlive#

{-| Used internally to implement @dataToTag#@: Use that function instead!
     This one normally offers /no advantage/ and comes with no stability
     guarantees: it may change its type, its name, or its behavior
     with /no warning/ between compiler releases.

     It is expected that this function will be un-exposed in a future
     release of ghc.

     For more details, look at @Note [DataToTag overview]@
     in GHC.Tc.Instance.Class in the source code for
     /the specific compiler version you are using./
   -}
{-# DEPRECATED dataToTagSmall# " Use dataToTag# from \"GHC.Magic\" instead. " #-}
dataToTagSmall# :: a_levpoly -> Int#
dataToTagSmall# = dataToTagSmall#

{-| Used internally to implement @dataToTag#@: Use that function instead!
     This one offers /no advantage/ and comes with no stability
     guarantees: it may change its type, its name, or its behavior
     with /no warning/ between compiler releases.

     It is expected that this function will be un-exposed in a future
     release of ghc.

     For more details, look at @Note [DataToTag overview]@
     in GHC.Tc.Instance.Class in the source code for
     /the specific compiler version you are using./
   -}
{-# DEPRECATED dataToTagLarge# " Use dataToTag# from \"GHC.Magic\" instead. " #-}
dataToTagLarge# :: a_levpoly -> Int#
dataToTagLarge# = dataToTagLarge#

tagToEnum# :: Int# -> a
tagToEnum# = let x = x in x

{-| Primitive bytecode type. -}
data BCO

{-| Convert an 'Addr#' to a followable Any type. -}
addrToAny# :: Addr# -> (# a_levpoly #)
addrToAny# = addrToAny#

{-| Retrieve the address of any Haskell value. This is
     essentially an 'unsafeCoerce#', but if implemented as such
     the core lint pass complains and fails to compile.
     As a primop, it is opaque to core/stg, and only appears
     in cmm (where the copy propagation pass will get rid of it).
     Note that "a" must be a value, not a thunk! It's too late
     for strictness analysis to enforce this, so you're on your
     own to guarantee this. Also note that 'Addr#' is not a GC
     pointer - up to you to guarantee that it does not become
     a dangling pointer immediately after you get it.-}
anyToAddr# :: a -> State# (RealWorld) -> (# State# (RealWorld),Addr# #)
anyToAddr# = anyToAddr#

{-| Wrap a BCO in a @AP_UPD@ thunk which will be updated with the value of
     the BCO when evaluated. -}
mkApUpd0# :: BCO -> (# a #)
mkApUpd0# = mkApUpd0#

{-| @'newBCO#' instrs lits ptrs arity bitmap@ creates a new bytecode object. The
     resulting object encodes a function of the given arity with the instructions
     encoded in @instrs@, and a static reference table usage bitmap given by
     @bitmap@. -}
newBCO# :: ByteArray# -> ByteArray# -> Array# a -> Int# -> ByteArray# -> State# s -> (# State# s,BCO #)
newBCO# = newBCO#

{-| @'unpackClosure#' closure@ copies the closure and pointers in the
     payload of the given closure into two new arrays, and returns a pointer to
     the first word of the closure's info table, a non-pointer array for the raw
     bytes of the closure, and a pointer array for the pointers in the payload. -}
unpackClosure# :: a -> (# Addr#,ByteArray#,Array# b #)
unpackClosure# = unpackClosure#

{-| @'closureSize#' closure@ returns the size of the given closure in
     machine words. -}
closureSize# :: a -> Int#
closureSize# = closureSize#

getApStackVal# :: a -> Int# -> (# Int#,b #)
getApStackVal# = getApStackVal#

getCCSOf# :: a -> State# s -> (# State# s,Addr# #)
getCCSOf# = getCCSOf#

{-| Returns the current 'CostCentreStack' (value is @NULL@ if
     not profiling).  Takes a dummy argument which can be used to
     avoid the call to 'getCurrentCCS#' being floated out by the
     simplifier, which would result in an uninformative stack
     ("CAF"). -}
getCurrentCCS# :: a -> State# s -> (# State# s,Addr# #)
getCurrentCCS# = getCurrentCCS#

{-| Run the supplied IO action with an empty CCS.  For example, this
     is used by the interpreter to run an interpreted computation
     without the call stack showing that it was invoked from GHC. -}
clearCCS# :: (State# s -> (# State# s,a #)) -> State# s -> (# State# s,a #)
clearCCS# = clearCCS#

{-| Pushes an annotation frame to the stack which can be reported by backtraces. -}
annotateStack# :: b -> (State# s -> (# State# s,a_reppoly #)) -> State# s -> (# State# s,a_reppoly #)
annotateStack# = annotateStack#

{-| Fills the given buffer with the @InfoProvEnt@ for the info table of the
     given object. Returns @1#@ on success and @0#@ otherwise.-}
whereFrom# :: a -> Addr# -> State# s -> (# State# s,Int# #)
whereFrom# = whereFrom#

{-|The builtin function type, written in infix form as @a % m -> b@.
   Values of this type are functions taking inputs of type @a@ and
   producing outputs of type @b@. The multiplicity of the input is
   @m@.

   Note that @'FUN' m a b@ permits representation polymorphism in both
   @a@ and @b@, so that types like @'Int#' -> 'Int#'@ can still be
   well-kinded.
  -}
data FUN m a b

{-| The token used in the implementation of the IO monad as a state monad.
     It does not pass any information at runtime.
     See also 'GHC.Magic.runRW#'. -}
realWorld# :: State# (RealWorld)
realWorld# = realWorld#

{-| This is an alias for the unboxed unit tuple constructor.
     In earlier versions of GHC, 'void#' was a value
     of the primitive type 'Void#', which is now defined to be @(# #)@.
   -}
{-# DEPRECATED void# " Use an unboxed unit tuple instead " #-}
void# :: (#  #)
void# = void#

{-| The type constructor 'Proxy#' is used to bear witness to some
   type variable. It's used when you want to pass around proxy values
   for doing things like modelling type applications. A 'Proxy#'
   is not only unboxed, it also has a polymorphic kind, and has no
   runtime representation, being totally free. -}
data Proxy# a

{-| Witness for an unboxed 'Proxy#' value, which has no runtime
   representation. -}
proxy# :: Proxy# a
proxy# = proxy#

{-| The value of @'seq' a b@ is bottom if @a@ is bottom, and
     otherwise equal to @b@. In other words, it evaluates the first
     argument @a@ to weak head normal form (WHNF). 'seq' is usually
     introduced to improve performance by avoiding unneeded laziness.

     A note on evaluation order: the expression @'seq' a b@ does
     /not/ guarantee that @a@ will be evaluated before @b@.
     The only guarantee given by 'seq' is that the both @a@
     and @b@ will be evaluated before 'seq' returns a value.
     In particular, this means that @b@ may be evaluated before
     @a@. If you need to guarantee a specific order of evaluation,
     you must use the function 'pseq' from the "parallel" package. -}
infixr 0 `seq`
seq :: a -> b_reppoly -> b_reppoly
seq = seq

{-| Emits an event via the RTS tracing framework.  The contents
     of the event is the zero-terminated byte string passed as the first
     argument.  The event will be emitted either to the @.eventlog@ file,
     or to stderr, depending on the runtime RTS flags. -}
traceEvent# :: Addr# -> State# s -> State# s
traceEvent# = traceEvent#

{-| Emits an event via the RTS tracing framework.  The contents
     of the event is the binary object passed as the first argument with
     the given length passed as the second argument. The event will be
     emitted to the @.eventlog@ file. -}
traceBinaryEvent# :: Addr# -> Int# -> State# s -> State# s
traceBinaryEvent# = traceBinaryEvent#

{-| Emits a marker event via the RTS tracing framework.  The contents
     of the event is the zero-terminated byte string passed as the first
     argument.  The event will be emitted either to the @.eventlog@ file,
     or to stderr, depending on the runtime RTS flags. -}
traceMarker# :: Addr# -> State# s -> State# s
traceMarker# = traceMarker#

{-| Sets the allocation counter for the current thread to the given value. -}
setThreadAllocationCounter# :: Int64# -> State# (RealWorld) -> State# (RealWorld)
setThreadAllocationCounter# = setThreadAllocationCounter#

{-| Sets the allocation counter for the another thread to the given value.
     This doesn't take allocations into the current nursery chunk into account.
     Therefore it is only accurate if the other thread is not currently running. -}
setOtherThreadAllocationCounter# :: Int64# -> ThreadId# -> State# (RealWorld) -> State# (RealWorld)
setOtherThreadAllocationCounter# = setOtherThreadAllocationCounter#

{-| Haskell representation of a @StgStack*@ that was created (cloned)
     with a function in "GHC.Stack.CloneStack". Please check the
     documentation in that module for more detailed explanations. -}
data StackSnapshot#

{-| The function 'coerce' allows you to safely convert between values of
     types that have the same representation with no run-time overhead. In the
     simplest case you can use it instead of a newtype constructor, to go from
     the newtype's concrete type to the abstract type. But it also works in
     more complicated settings, e.g. converting a list of newtypes to a list of
     concrete types.

     When used in conversions involving a newtype wrapper,
     make sure the newtype constructor is in scope.

     This function is representation-polymorphic, but the
     'RuntimeRep' type argument is marked as 'Inferred', meaning
     that it is not available for visible type application. This means
     the typechecker will accept @'coerce' \@'Int' \@Age 42@.

     === __Examples__

     >>> newtype TTL = TTL Int deriving (Eq, Ord, Show)
     >>> newtype Age = Age Int deriving (Eq, Ord, Show)
     >>> coerce (Age 42) :: TTL
     TTL 42
     >>> coerce (+ (1 :: Int)) (Age 42) :: TTL
     TTL 43
     >>> coerce (map (+ (1 :: Int))) [Age 42, Age 24] :: [TTL]
     [TTL 43,TTL 25]

   -}
coerce :: Coercible a b => a -> b
coerce = coerce

data Int8X16#

data Int16X8#

data Int32X4#

data Int64X2#

data Int8X32#

data Int16X16#

data Int32X8#

data Int64X4#

data Int8X64#

data Int16X32#

data Int32X16#

data Int64X8#

data Word8X16#

data Word16X8#

data Word32X4#

data Word64X2#

data Word8X32#

data Word16X16#

data Word32X8#

data Word64X4#

data Word8X64#

data Word16X32#

data Word32X16#

data Word64X8#

data FloatX4#

data DoubleX2#

data FloatX8#

data DoubleX4#

data FloatX16#

data DoubleX8#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastInt8X16# :: Int8# -> Int8X16#
broadcastInt8X16# = broadcastInt8X16#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastInt16X8# :: Int16# -> Int16X8#
broadcastInt16X8# = broadcastInt16X8#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastInt32X4# :: Int32# -> Int32X4#
broadcastInt32X4# = broadcastInt32X4#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastInt64X2# :: Int64# -> Int64X2#
broadcastInt64X2# = broadcastInt64X2#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastInt8X32# :: Int8# -> Int8X32#
broadcastInt8X32# = broadcastInt8X32#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastInt16X16# :: Int16# -> Int16X16#
broadcastInt16X16# = broadcastInt16X16#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastInt32X8# :: Int32# -> Int32X8#
broadcastInt32X8# = broadcastInt32X8#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastInt64X4# :: Int64# -> Int64X4#
broadcastInt64X4# = broadcastInt64X4#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastInt8X64# :: Int8# -> Int8X64#
broadcastInt8X64# = broadcastInt8X64#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastInt16X32# :: Int16# -> Int16X32#
broadcastInt16X32# = broadcastInt16X32#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastInt32X16# :: Int32# -> Int32X16#
broadcastInt32X16# = broadcastInt32X16#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastInt64X8# :: Int64# -> Int64X8#
broadcastInt64X8# = broadcastInt64X8#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastWord8X16# :: Word8# -> Word8X16#
broadcastWord8X16# = broadcastWord8X16#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastWord16X8# :: Word16# -> Word16X8#
broadcastWord16X8# = broadcastWord16X8#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastWord32X4# :: Word32# -> Word32X4#
broadcastWord32X4# = broadcastWord32X4#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastWord64X2# :: Word64# -> Word64X2#
broadcastWord64X2# = broadcastWord64X2#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastWord8X32# :: Word8# -> Word8X32#
broadcastWord8X32# = broadcastWord8X32#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastWord16X16# :: Word16# -> Word16X16#
broadcastWord16X16# = broadcastWord16X16#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastWord32X8# :: Word32# -> Word32X8#
broadcastWord32X8# = broadcastWord32X8#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastWord64X4# :: Word64# -> Word64X4#
broadcastWord64X4# = broadcastWord64X4#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastWord8X64# :: Word8# -> Word8X64#
broadcastWord8X64# = broadcastWord8X64#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastWord16X32# :: Word16# -> Word16X32#
broadcastWord16X32# = broadcastWord16X32#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastWord32X16# :: Word32# -> Word32X16#
broadcastWord32X16# = broadcastWord32X16#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastWord64X8# :: Word64# -> Word64X8#
broadcastWord64X8# = broadcastWord64X8#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastFloatX4# :: Float# -> FloatX4#
broadcastFloatX4# = broadcastFloatX4#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastDoubleX2# :: Double# -> DoubleX2#
broadcastDoubleX2# = broadcastDoubleX2#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastFloatX8# :: Float# -> FloatX8#
broadcastFloatX8# = broadcastFloatX8#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastDoubleX4# :: Double# -> DoubleX4#
broadcastDoubleX4# = broadcastDoubleX4#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastFloatX16# :: Float# -> FloatX16#
broadcastFloatX16# = broadcastFloatX16#

{-| Broadcast a scalar to all elements of a vector. -}
broadcastDoubleX8# :: Double# -> DoubleX8#
broadcastDoubleX8# = broadcastDoubleX8#

{-| Pack the elements of an unboxed tuple into a vector. -}
packInt8X16# :: (# Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8# #) -> Int8X16#
packInt8X16# = packInt8X16#

{-| Pack the elements of an unboxed tuple into a vector. -}
packInt16X8# :: (# Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16# #) -> Int16X8#
packInt16X8# = packInt16X8#

{-| Pack the elements of an unboxed tuple into a vector. -}
packInt32X4# :: (# Int32#,Int32#,Int32#,Int32# #) -> Int32X4#
packInt32X4# = packInt32X4#

{-| Pack the elements of an unboxed tuple into a vector. -}
packInt64X2# :: (# Int64#,Int64# #) -> Int64X2#
packInt64X2# = packInt64X2#

{-| Pack the elements of an unboxed tuple into a vector. -}
packInt8X32# :: (# Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8# #) -> Int8X32#
packInt8X32# = packInt8X32#

{-| Pack the elements of an unboxed tuple into a vector. -}
packInt16X16# :: (# Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16# #) -> Int16X16#
packInt16X16# = packInt16X16#

{-| Pack the elements of an unboxed tuple into a vector. -}
packInt32X8# :: (# Int32#,Int32#,Int32#,Int32#,Int32#,Int32#,Int32#,Int32# #) -> Int32X8#
packInt32X8# = packInt32X8#

{-| Pack the elements of an unboxed tuple into a vector. -}
packInt64X4# :: (# Int64#,Int64#,Int64#,Int64# #) -> Int64X4#
packInt64X4# = packInt64X4#

{-| Pack the elements of an unboxed tuple into a vector. -}
packInt8X64# :: (# Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8# #) -> Int8X64#
packInt8X64# = packInt8X64#

{-| Pack the elements of an unboxed tuple into a vector. -}
packInt16X32# :: (# Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16# #) -> Int16X32#
packInt16X32# = packInt16X32#

{-| Pack the elements of an unboxed tuple into a vector. -}
packInt32X16# :: (# Int32#,Int32#,Int32#,Int32#,Int32#,Int32#,Int32#,Int32#,Int32#,Int32#,Int32#,Int32#,Int32#,Int32#,Int32#,Int32# #) -> Int32X16#
packInt32X16# = packInt32X16#

{-| Pack the elements of an unboxed tuple into a vector. -}
packInt64X8# :: (# Int64#,Int64#,Int64#,Int64#,Int64#,Int64#,Int64#,Int64# #) -> Int64X8#
packInt64X8# = packInt64X8#

{-| Pack the elements of an unboxed tuple into a vector. -}
packWord8X16# :: (# Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8# #) -> Word8X16#
packWord8X16# = packWord8X16#

{-| Pack the elements of an unboxed tuple into a vector. -}
packWord16X8# :: (# Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16# #) -> Word16X8#
packWord16X8# = packWord16X8#

{-| Pack the elements of an unboxed tuple into a vector. -}
packWord32X4# :: (# Word32#,Word32#,Word32#,Word32# #) -> Word32X4#
packWord32X4# = packWord32X4#

{-| Pack the elements of an unboxed tuple into a vector. -}
packWord64X2# :: (# Word64#,Word64# #) -> Word64X2#
packWord64X2# = packWord64X2#

{-| Pack the elements of an unboxed tuple into a vector. -}
packWord8X32# :: (# Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8# #) -> Word8X32#
packWord8X32# = packWord8X32#

{-| Pack the elements of an unboxed tuple into a vector. -}
packWord16X16# :: (# Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16# #) -> Word16X16#
packWord16X16# = packWord16X16#

{-| Pack the elements of an unboxed tuple into a vector. -}
packWord32X8# :: (# Word32#,Word32#,Word32#,Word32#,Word32#,Word32#,Word32#,Word32# #) -> Word32X8#
packWord32X8# = packWord32X8#

{-| Pack the elements of an unboxed tuple into a vector. -}
packWord64X4# :: (# Word64#,Word64#,Word64#,Word64# #) -> Word64X4#
packWord64X4# = packWord64X4#

{-| Pack the elements of an unboxed tuple into a vector. -}
packWord8X64# :: (# Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8# #) -> Word8X64#
packWord8X64# = packWord8X64#

{-| Pack the elements of an unboxed tuple into a vector. -}
packWord16X32# :: (# Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16# #) -> Word16X32#
packWord16X32# = packWord16X32#

{-| Pack the elements of an unboxed tuple into a vector. -}
packWord32X16# :: (# Word32#,Word32#,Word32#,Word32#,Word32#,Word32#,Word32#,Word32#,Word32#,Word32#,Word32#,Word32#,Word32#,Word32#,Word32#,Word32# #) -> Word32X16#
packWord32X16# = packWord32X16#

{-| Pack the elements of an unboxed tuple into a vector. -}
packWord64X8# :: (# Word64#,Word64#,Word64#,Word64#,Word64#,Word64#,Word64#,Word64# #) -> Word64X8#
packWord64X8# = packWord64X8#

{-| Pack the elements of an unboxed tuple into a vector. -}
packFloatX4# :: (# Float#,Float#,Float#,Float# #) -> FloatX4#
packFloatX4# = packFloatX4#

{-| Pack the elements of an unboxed tuple into a vector. -}
packDoubleX2# :: (# Double#,Double# #) -> DoubleX2#
packDoubleX2# = packDoubleX2#

{-| Pack the elements of an unboxed tuple into a vector. -}
packFloatX8# :: (# Float#,Float#,Float#,Float#,Float#,Float#,Float#,Float# #) -> FloatX8#
packFloatX8# = packFloatX8#

{-| Pack the elements of an unboxed tuple into a vector. -}
packDoubleX4# :: (# Double#,Double#,Double#,Double# #) -> DoubleX4#
packDoubleX4# = packDoubleX4#

{-| Pack the elements of an unboxed tuple into a vector. -}
packFloatX16# :: (# Float#,Float#,Float#,Float#,Float#,Float#,Float#,Float#,Float#,Float#,Float#,Float#,Float#,Float#,Float#,Float# #) -> FloatX16#
packFloatX16# = packFloatX16#

{-| Pack the elements of an unboxed tuple into a vector. -}
packDoubleX8# :: (# Double#,Double#,Double#,Double#,Double#,Double#,Double#,Double# #) -> DoubleX8#
packDoubleX8# = packDoubleX8#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackInt8X16# :: Int8X16# -> (# Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8# #)
unpackInt8X16# = unpackInt8X16#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackInt16X8# :: Int16X8# -> (# Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16# #)
unpackInt16X8# = unpackInt16X8#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackInt32X4# :: Int32X4# -> (# Int32#,Int32#,Int32#,Int32# #)
unpackInt32X4# = unpackInt32X4#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackInt64X2# :: Int64X2# -> (# Int64#,Int64# #)
unpackInt64X2# = unpackInt64X2#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackInt8X32# :: Int8X32# -> (# Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8# #)
unpackInt8X32# = unpackInt8X32#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackInt16X16# :: Int16X16# -> (# Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16# #)
unpackInt16X16# = unpackInt16X16#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackInt32X8# :: Int32X8# -> (# Int32#,Int32#,Int32#,Int32#,Int32#,Int32#,Int32#,Int32# #)
unpackInt32X8# = unpackInt32X8#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackInt64X4# :: Int64X4# -> (# Int64#,Int64#,Int64#,Int64# #)
unpackInt64X4# = unpackInt64X4#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackInt8X64# :: Int8X64# -> (# Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8#,Int8# #)
unpackInt8X64# = unpackInt8X64#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackInt16X32# :: Int16X32# -> (# Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16#,Int16# #)
unpackInt16X32# = unpackInt16X32#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackInt32X16# :: Int32X16# -> (# Int32#,Int32#,Int32#,Int32#,Int32#,Int32#,Int32#,Int32#,Int32#,Int32#,Int32#,Int32#,Int32#,Int32#,Int32#,Int32# #)
unpackInt32X16# = unpackInt32X16#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackInt64X8# :: Int64X8# -> (# Int64#,Int64#,Int64#,Int64#,Int64#,Int64#,Int64#,Int64# #)
unpackInt64X8# = unpackInt64X8#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackWord8X16# :: Word8X16# -> (# Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8# #)
unpackWord8X16# = unpackWord8X16#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackWord16X8# :: Word16X8# -> (# Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16# #)
unpackWord16X8# = unpackWord16X8#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackWord32X4# :: Word32X4# -> (# Word32#,Word32#,Word32#,Word32# #)
unpackWord32X4# = unpackWord32X4#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackWord64X2# :: Word64X2# -> (# Word64#,Word64# #)
unpackWord64X2# = unpackWord64X2#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackWord8X32# :: Word8X32# -> (# Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8# #)
unpackWord8X32# = unpackWord8X32#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackWord16X16# :: Word16X16# -> (# Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16# #)
unpackWord16X16# = unpackWord16X16#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackWord32X8# :: Word32X8# -> (# Word32#,Word32#,Word32#,Word32#,Word32#,Word32#,Word32#,Word32# #)
unpackWord32X8# = unpackWord32X8#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackWord64X4# :: Word64X4# -> (# Word64#,Word64#,Word64#,Word64# #)
unpackWord64X4# = unpackWord64X4#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackWord8X64# :: Word8X64# -> (# Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8#,Word8# #)
unpackWord8X64# = unpackWord8X64#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackWord16X32# :: Word16X32# -> (# Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16#,Word16# #)
unpackWord16X32# = unpackWord16X32#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackWord32X16# :: Word32X16# -> (# Word32#,Word32#,Word32#,Word32#,Word32#,Word32#,Word32#,Word32#,Word32#,Word32#,Word32#,Word32#,Word32#,Word32#,Word32#,Word32# #)
unpackWord32X16# = unpackWord32X16#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackWord64X8# :: Word64X8# -> (# Word64#,Word64#,Word64#,Word64#,Word64#,Word64#,Word64#,Word64# #)
unpackWord64X8# = unpackWord64X8#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackFloatX4# :: FloatX4# -> (# Float#,Float#,Float#,Float# #)
unpackFloatX4# = unpackFloatX4#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackDoubleX2# :: DoubleX2# -> (# Double#,Double# #)
unpackDoubleX2# = unpackDoubleX2#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackFloatX8# :: FloatX8# -> (# Float#,Float#,Float#,Float#,Float#,Float#,Float#,Float# #)
unpackFloatX8# = unpackFloatX8#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackDoubleX4# :: DoubleX4# -> (# Double#,Double#,Double#,Double# #)
unpackDoubleX4# = unpackDoubleX4#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackFloatX16# :: FloatX16# -> (# Float#,Float#,Float#,Float#,Float#,Float#,Float#,Float#,Float#,Float#,Float#,Float#,Float#,Float#,Float#,Float# #)
unpackFloatX16# = unpackFloatX16#

{-| Unpack the elements of a vector into an unboxed tuple. -}
unpackDoubleX8# :: DoubleX8# -> (# Double#,Double#,Double#,Double#,Double#,Double#,Double#,Double# #)
unpackDoubleX8# = unpackDoubleX8#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertInt8X16# :: Int8X16# -> Int8# -> Int# -> Int8X16#
insertInt8X16# = insertInt8X16#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertInt16X8# :: Int16X8# -> Int16# -> Int# -> Int16X8#
insertInt16X8# = insertInt16X8#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertInt32X4# :: Int32X4# -> Int32# -> Int# -> Int32X4#
insertInt32X4# = insertInt32X4#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertInt64X2# :: Int64X2# -> Int64# -> Int# -> Int64X2#
insertInt64X2# = insertInt64X2#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertInt8X32# :: Int8X32# -> Int8# -> Int# -> Int8X32#
insertInt8X32# = insertInt8X32#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertInt16X16# :: Int16X16# -> Int16# -> Int# -> Int16X16#
insertInt16X16# = insertInt16X16#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertInt32X8# :: Int32X8# -> Int32# -> Int# -> Int32X8#
insertInt32X8# = insertInt32X8#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertInt64X4# :: Int64X4# -> Int64# -> Int# -> Int64X4#
insertInt64X4# = insertInt64X4#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertInt8X64# :: Int8X64# -> Int8# -> Int# -> Int8X64#
insertInt8X64# = insertInt8X64#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertInt16X32# :: Int16X32# -> Int16# -> Int# -> Int16X32#
insertInt16X32# = insertInt16X32#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertInt32X16# :: Int32X16# -> Int32# -> Int# -> Int32X16#
insertInt32X16# = insertInt32X16#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertInt64X8# :: Int64X8# -> Int64# -> Int# -> Int64X8#
insertInt64X8# = insertInt64X8#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertWord8X16# :: Word8X16# -> Word8# -> Int# -> Word8X16#
insertWord8X16# = insertWord8X16#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertWord16X8# :: Word16X8# -> Word16# -> Int# -> Word16X8#
insertWord16X8# = insertWord16X8#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertWord32X4# :: Word32X4# -> Word32# -> Int# -> Word32X4#
insertWord32X4# = insertWord32X4#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertWord64X2# :: Word64X2# -> Word64# -> Int# -> Word64X2#
insertWord64X2# = insertWord64X2#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertWord8X32# :: Word8X32# -> Word8# -> Int# -> Word8X32#
insertWord8X32# = insertWord8X32#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertWord16X16# :: Word16X16# -> Word16# -> Int# -> Word16X16#
insertWord16X16# = insertWord16X16#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertWord32X8# :: Word32X8# -> Word32# -> Int# -> Word32X8#
insertWord32X8# = insertWord32X8#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertWord64X4# :: Word64X4# -> Word64# -> Int# -> Word64X4#
insertWord64X4# = insertWord64X4#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertWord8X64# :: Word8X64# -> Word8# -> Int# -> Word8X64#
insertWord8X64# = insertWord8X64#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertWord16X32# :: Word16X32# -> Word16# -> Int# -> Word16X32#
insertWord16X32# = insertWord16X32#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertWord32X16# :: Word32X16# -> Word32# -> Int# -> Word32X16#
insertWord32X16# = insertWord32X16#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertWord64X8# :: Word64X8# -> Word64# -> Int# -> Word64X8#
insertWord64X8# = insertWord64X8#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertFloatX4# :: FloatX4# -> Float# -> Int# -> FloatX4#
insertFloatX4# = insertFloatX4#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertDoubleX2# :: DoubleX2# -> Double# -> Int# -> DoubleX2#
insertDoubleX2# = insertDoubleX2#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertFloatX8# :: FloatX8# -> Float# -> Int# -> FloatX8#
insertFloatX8# = insertFloatX8#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertDoubleX4# :: DoubleX4# -> Double# -> Int# -> DoubleX4#
insertDoubleX4# = insertDoubleX4#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertFloatX16# :: FloatX16# -> Float# -> Int# -> FloatX16#
insertFloatX16# = insertFloatX16#

{-| Insert a scalar at the given position in a vector.
     The position must be a compile-time constant. -}
insertDoubleX8# :: DoubleX8# -> Double# -> Int# -> DoubleX8#
insertDoubleX8# = insertDoubleX8#

{-| Add two vectors element-wise. -}
plusInt8X16# :: Int8X16# -> Int8X16# -> Int8X16#
plusInt8X16# = plusInt8X16#

{-| Add two vectors element-wise. -}
plusInt16X8# :: Int16X8# -> Int16X8# -> Int16X8#
plusInt16X8# = plusInt16X8#

{-| Add two vectors element-wise. -}
plusInt32X4# :: Int32X4# -> Int32X4# -> Int32X4#
plusInt32X4# = plusInt32X4#

{-| Add two vectors element-wise. -}
plusInt64X2# :: Int64X2# -> Int64X2# -> Int64X2#
plusInt64X2# = plusInt64X2#

{-| Add two vectors element-wise. -}
plusInt8X32# :: Int8X32# -> Int8X32# -> Int8X32#
plusInt8X32# = plusInt8X32#

{-| Add two vectors element-wise. -}
plusInt16X16# :: Int16X16# -> Int16X16# -> Int16X16#
plusInt16X16# = plusInt16X16#

{-| Add two vectors element-wise. -}
plusInt32X8# :: Int32X8# -> Int32X8# -> Int32X8#
plusInt32X8# = plusInt32X8#

{-| Add two vectors element-wise. -}
plusInt64X4# :: Int64X4# -> Int64X4# -> Int64X4#
plusInt64X4# = plusInt64X4#

{-| Add two vectors element-wise. -}
plusInt8X64# :: Int8X64# -> Int8X64# -> Int8X64#
plusInt8X64# = plusInt8X64#

{-| Add two vectors element-wise. -}
plusInt16X32# :: Int16X32# -> Int16X32# -> Int16X32#
plusInt16X32# = plusInt16X32#

{-| Add two vectors element-wise. -}
plusInt32X16# :: Int32X16# -> Int32X16# -> Int32X16#
plusInt32X16# = plusInt32X16#

{-| Add two vectors element-wise. -}
plusInt64X8# :: Int64X8# -> Int64X8# -> Int64X8#
plusInt64X8# = plusInt64X8#

{-| Add two vectors element-wise. -}
plusWord8X16# :: Word8X16# -> Word8X16# -> Word8X16#
plusWord8X16# = plusWord8X16#

{-| Add two vectors element-wise. -}
plusWord16X8# :: Word16X8# -> Word16X8# -> Word16X8#
plusWord16X8# = plusWord16X8#

{-| Add two vectors element-wise. -}
plusWord32X4# :: Word32X4# -> Word32X4# -> Word32X4#
plusWord32X4# = plusWord32X4#

{-| Add two vectors element-wise. -}
plusWord64X2# :: Word64X2# -> Word64X2# -> Word64X2#
plusWord64X2# = plusWord64X2#

{-| Add two vectors element-wise. -}
plusWord8X32# :: Word8X32# -> Word8X32# -> Word8X32#
plusWord8X32# = plusWord8X32#

{-| Add two vectors element-wise. -}
plusWord16X16# :: Word16X16# -> Word16X16# -> Word16X16#
plusWord16X16# = plusWord16X16#

{-| Add two vectors element-wise. -}
plusWord32X8# :: Word32X8# -> Word32X8# -> Word32X8#
plusWord32X8# = plusWord32X8#

{-| Add two vectors element-wise. -}
plusWord64X4# :: Word64X4# -> Word64X4# -> Word64X4#
plusWord64X4# = plusWord64X4#

{-| Add two vectors element-wise. -}
plusWord8X64# :: Word8X64# -> Word8X64# -> Word8X64#
plusWord8X64# = plusWord8X64#

{-| Add two vectors element-wise. -}
plusWord16X32# :: Word16X32# -> Word16X32# -> Word16X32#
plusWord16X32# = plusWord16X32#

{-| Add two vectors element-wise. -}
plusWord32X16# :: Word32X16# -> Word32X16# -> Word32X16#
plusWord32X16# = plusWord32X16#

{-| Add two vectors element-wise. -}
plusWord64X8# :: Word64X8# -> Word64X8# -> Word64X8#
plusWord64X8# = plusWord64X8#

{-| Add two vectors element-wise. -}
plusFloatX4# :: FloatX4# -> FloatX4# -> FloatX4#
plusFloatX4# = plusFloatX4#

{-| Add two vectors element-wise. -}
plusDoubleX2# :: DoubleX2# -> DoubleX2# -> DoubleX2#
plusDoubleX2# = plusDoubleX2#

{-| Add two vectors element-wise. -}
plusFloatX8# :: FloatX8# -> FloatX8# -> FloatX8#
plusFloatX8# = plusFloatX8#

{-| Add two vectors element-wise. -}
plusDoubleX4# :: DoubleX4# -> DoubleX4# -> DoubleX4#
plusDoubleX4# = plusDoubleX4#

{-| Add two vectors element-wise. -}
plusFloatX16# :: FloatX16# -> FloatX16# -> FloatX16#
plusFloatX16# = plusFloatX16#

{-| Add two vectors element-wise. -}
plusDoubleX8# :: DoubleX8# -> DoubleX8# -> DoubleX8#
plusDoubleX8# = plusDoubleX8#

{-| Subtract two vectors element-wise. -}
minusInt8X16# :: Int8X16# -> Int8X16# -> Int8X16#
minusInt8X16# = minusInt8X16#

{-| Subtract two vectors element-wise. -}
minusInt16X8# :: Int16X8# -> Int16X8# -> Int16X8#
minusInt16X8# = minusInt16X8#

{-| Subtract two vectors element-wise. -}
minusInt32X4# :: Int32X4# -> Int32X4# -> Int32X4#
minusInt32X4# = minusInt32X4#

{-| Subtract two vectors element-wise. -}
minusInt64X2# :: Int64X2# -> Int64X2# -> Int64X2#
minusInt64X2# = minusInt64X2#

{-| Subtract two vectors element-wise. -}
minusInt8X32# :: Int8X32# -> Int8X32# -> Int8X32#
minusInt8X32# = minusInt8X32#

{-| Subtract two vectors element-wise. -}
minusInt16X16# :: Int16X16# -> Int16X16# -> Int16X16#
minusInt16X16# = minusInt16X16#

{-| Subtract two vectors element-wise. -}
minusInt32X8# :: Int32X8# -> Int32X8# -> Int32X8#
minusInt32X8# = minusInt32X8#

{-| Subtract two vectors element-wise. -}
minusInt64X4# :: Int64X4# -> Int64X4# -> Int64X4#
minusInt64X4# = minusInt64X4#

{-| Subtract two vectors element-wise. -}
minusInt8X64# :: Int8X64# -> Int8X64# -> Int8X64#
minusInt8X64# = minusInt8X64#

{-| Subtract two vectors element-wise. -}
minusInt16X32# :: Int16X32# -> Int16X32# -> Int16X32#
minusInt16X32# = minusInt16X32#

{-| Subtract two vectors element-wise. -}
minusInt32X16# :: Int32X16# -> Int32X16# -> Int32X16#
minusInt32X16# = minusInt32X16#

{-| Subtract two vectors element-wise. -}
minusInt64X8# :: Int64X8# -> Int64X8# -> Int64X8#
minusInt64X8# = minusInt64X8#

{-| Subtract two vectors element-wise. -}
minusWord8X16# :: Word8X16# -> Word8X16# -> Word8X16#
minusWord8X16# = minusWord8X16#

{-| Subtract two vectors element-wise. -}
minusWord16X8# :: Word16X8# -> Word16X8# -> Word16X8#
minusWord16X8# = minusWord16X8#

{-| Subtract two vectors element-wise. -}
minusWord32X4# :: Word32X4# -> Word32X4# -> Word32X4#
minusWord32X4# = minusWord32X4#

{-| Subtract two vectors element-wise. -}
minusWord64X2# :: Word64X2# -> Word64X2# -> Word64X2#
minusWord64X2# = minusWord64X2#

{-| Subtract two vectors element-wise. -}
minusWord8X32# :: Word8X32# -> Word8X32# -> Word8X32#
minusWord8X32# = minusWord8X32#

{-| Subtract two vectors element-wise. -}
minusWord16X16# :: Word16X16# -> Word16X16# -> Word16X16#
minusWord16X16# = minusWord16X16#

{-| Subtract two vectors element-wise. -}
minusWord32X8# :: Word32X8# -> Word32X8# -> Word32X8#
minusWord32X8# = minusWord32X8#

{-| Subtract two vectors element-wise. -}
minusWord64X4# :: Word64X4# -> Word64X4# -> Word64X4#
minusWord64X4# = minusWord64X4#

{-| Subtract two vectors element-wise. -}
minusWord8X64# :: Word8X64# -> Word8X64# -> Word8X64#
minusWord8X64# = minusWord8X64#

{-| Subtract two vectors element-wise. -}
minusWord16X32# :: Word16X32# -> Word16X32# -> Word16X32#
minusWord16X32# = minusWord16X32#

{-| Subtract two vectors element-wise. -}
minusWord32X16# :: Word32X16# -> Word32X16# -> Word32X16#
minusWord32X16# = minusWord32X16#

{-| Subtract two vectors element-wise. -}
minusWord64X8# :: Word64X8# -> Word64X8# -> Word64X8#
minusWord64X8# = minusWord64X8#

{-| Subtract two vectors element-wise. -}
minusFloatX4# :: FloatX4# -> FloatX4# -> FloatX4#
minusFloatX4# = minusFloatX4#

{-| Subtract two vectors element-wise. -}
minusDoubleX2# :: DoubleX2# -> DoubleX2# -> DoubleX2#
minusDoubleX2# = minusDoubleX2#

{-| Subtract two vectors element-wise. -}
minusFloatX8# :: FloatX8# -> FloatX8# -> FloatX8#
minusFloatX8# = minusFloatX8#

{-| Subtract two vectors element-wise. -}
minusDoubleX4# :: DoubleX4# -> DoubleX4# -> DoubleX4#
minusDoubleX4# = minusDoubleX4#

{-| Subtract two vectors element-wise. -}
minusFloatX16# :: FloatX16# -> FloatX16# -> FloatX16#
minusFloatX16# = minusFloatX16#

{-| Subtract two vectors element-wise. -}
minusDoubleX8# :: DoubleX8# -> DoubleX8# -> DoubleX8#
minusDoubleX8# = minusDoubleX8#

{-| Multiply two vectors element-wise. -}
timesInt8X16# :: Int8X16# -> Int8X16# -> Int8X16#
timesInt8X16# = timesInt8X16#

{-| Multiply two vectors element-wise. -}
timesInt16X8# :: Int16X8# -> Int16X8# -> Int16X8#
timesInt16X8# = timesInt16X8#

{-| Multiply two vectors element-wise. -}
timesInt32X4# :: Int32X4# -> Int32X4# -> Int32X4#
timesInt32X4# = timesInt32X4#

{-| Multiply two vectors element-wise. -}
timesInt64X2# :: Int64X2# -> Int64X2# -> Int64X2#
timesInt64X2# = timesInt64X2#

{-| Multiply two vectors element-wise. -}
timesInt8X32# :: Int8X32# -> Int8X32# -> Int8X32#
timesInt8X32# = timesInt8X32#

{-| Multiply two vectors element-wise. -}
timesInt16X16# :: Int16X16# -> Int16X16# -> Int16X16#
timesInt16X16# = timesInt16X16#

{-| Multiply two vectors element-wise. -}
timesInt32X8# :: Int32X8# -> Int32X8# -> Int32X8#
timesInt32X8# = timesInt32X8#

{-| Multiply two vectors element-wise. -}
timesInt64X4# :: Int64X4# -> Int64X4# -> Int64X4#
timesInt64X4# = timesInt64X4#

{-| Multiply two vectors element-wise. -}
timesInt8X64# :: Int8X64# -> Int8X64# -> Int8X64#
timesInt8X64# = timesInt8X64#

{-| Multiply two vectors element-wise. -}
timesInt16X32# :: Int16X32# -> Int16X32# -> Int16X32#
timesInt16X32# = timesInt16X32#

{-| Multiply two vectors element-wise. -}
timesInt32X16# :: Int32X16# -> Int32X16# -> Int32X16#
timesInt32X16# = timesInt32X16#

{-| Multiply two vectors element-wise. -}
timesInt64X8# :: Int64X8# -> Int64X8# -> Int64X8#
timesInt64X8# = timesInt64X8#

{-| Multiply two vectors element-wise. -}
timesWord8X16# :: Word8X16# -> Word8X16# -> Word8X16#
timesWord8X16# = timesWord8X16#

{-| Multiply two vectors element-wise. -}
timesWord16X8# :: Word16X8# -> Word16X8# -> Word16X8#
timesWord16X8# = timesWord16X8#

{-| Multiply two vectors element-wise. -}
timesWord32X4# :: Word32X4# -> Word32X4# -> Word32X4#
timesWord32X4# = timesWord32X4#

{-| Multiply two vectors element-wise. -}
timesWord64X2# :: Word64X2# -> Word64X2# -> Word64X2#
timesWord64X2# = timesWord64X2#

{-| Multiply two vectors element-wise. -}
timesWord8X32# :: Word8X32# -> Word8X32# -> Word8X32#
timesWord8X32# = timesWord8X32#

{-| Multiply two vectors element-wise. -}
timesWord16X16# :: Word16X16# -> Word16X16# -> Word16X16#
timesWord16X16# = timesWord16X16#

{-| Multiply two vectors element-wise. -}
timesWord32X8# :: Word32X8# -> Word32X8# -> Word32X8#
timesWord32X8# = timesWord32X8#

{-| Multiply two vectors element-wise. -}
timesWord64X4# :: Word64X4# -> Word64X4# -> Word64X4#
timesWord64X4# = timesWord64X4#

{-| Multiply two vectors element-wise. -}
timesWord8X64# :: Word8X64# -> Word8X64# -> Word8X64#
timesWord8X64# = timesWord8X64#

{-| Multiply two vectors element-wise. -}
timesWord16X32# :: Word16X32# -> Word16X32# -> Word16X32#
timesWord16X32# = timesWord16X32#

{-| Multiply two vectors element-wise. -}
timesWord32X16# :: Word32X16# -> Word32X16# -> Word32X16#
timesWord32X16# = timesWord32X16#

{-| Multiply two vectors element-wise. -}
timesWord64X8# :: Word64X8# -> Word64X8# -> Word64X8#
timesWord64X8# = timesWord64X8#

{-| Multiply two vectors element-wise. -}
timesFloatX4# :: FloatX4# -> FloatX4# -> FloatX4#
timesFloatX4# = timesFloatX4#

{-| Multiply two vectors element-wise. -}
timesDoubleX2# :: DoubleX2# -> DoubleX2# -> DoubleX2#
timesDoubleX2# = timesDoubleX2#

{-| Multiply two vectors element-wise. -}
timesFloatX8# :: FloatX8# -> FloatX8# -> FloatX8#
timesFloatX8# = timesFloatX8#

{-| Multiply two vectors element-wise. -}
timesDoubleX4# :: DoubleX4# -> DoubleX4# -> DoubleX4#
timesDoubleX4# = timesDoubleX4#

{-| Multiply two vectors element-wise. -}
timesFloatX16# :: FloatX16# -> FloatX16# -> FloatX16#
timesFloatX16# = timesFloatX16#

{-| Multiply two vectors element-wise. -}
timesDoubleX8# :: DoubleX8# -> DoubleX8# -> DoubleX8#
timesDoubleX8# = timesDoubleX8#

{-| Divide two vectors element-wise. -}
divideFloatX4# :: FloatX4# -> FloatX4# -> FloatX4#
divideFloatX4# = divideFloatX4#

{-| Divide two vectors element-wise. -}
divideDoubleX2# :: DoubleX2# -> DoubleX2# -> DoubleX2#
divideDoubleX2# = divideDoubleX2#

{-| Divide two vectors element-wise. -}
divideFloatX8# :: FloatX8# -> FloatX8# -> FloatX8#
divideFloatX8# = divideFloatX8#

{-| Divide two vectors element-wise. -}
divideDoubleX4# :: DoubleX4# -> DoubleX4# -> DoubleX4#
divideDoubleX4# = divideDoubleX4#

{-| Divide two vectors element-wise. -}
divideFloatX16# :: FloatX16# -> FloatX16# -> FloatX16#
divideFloatX16# = divideFloatX16#

{-| Divide two vectors element-wise. -}
divideDoubleX8# :: DoubleX8# -> DoubleX8# -> DoubleX8#
divideDoubleX8# = divideDoubleX8#

{-| Rounds towards zero element-wise.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
quotInt8X16# :: Int8X16# -> Int8X16# -> Int8X16#
quotInt8X16# = quotInt8X16#

{-| Rounds towards zero element-wise.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
quotInt16X8# :: Int16X8# -> Int16X8# -> Int16X8#
quotInt16X8# = quotInt16X8#

{-| Rounds towards zero element-wise.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
quotInt32X4# :: Int32X4# -> Int32X4# -> Int32X4#
quotInt32X4# = quotInt32X4#

{-| Rounds towards zero element-wise.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
quotInt64X2# :: Int64X2# -> Int64X2# -> Int64X2#
quotInt64X2# = quotInt64X2#

{-| Rounds towards zero element-wise.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
quotInt8X32# :: Int8X32# -> Int8X32# -> Int8X32#
quotInt8X32# = quotInt8X32#

{-| Rounds towards zero element-wise.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
quotInt16X16# :: Int16X16# -> Int16X16# -> Int16X16#
quotInt16X16# = quotInt16X16#

{-| Rounds towards zero element-wise.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
quotInt32X8# :: Int32X8# -> Int32X8# -> Int32X8#
quotInt32X8# = quotInt32X8#

{-| Rounds towards zero element-wise.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
quotInt64X4# :: Int64X4# -> Int64X4# -> Int64X4#
quotInt64X4# = quotInt64X4#

{-| Rounds towards zero element-wise.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
quotInt8X64# :: Int8X64# -> Int8X64# -> Int8X64#
quotInt8X64# = quotInt8X64#

{-| Rounds towards zero element-wise.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
quotInt16X32# :: Int16X32# -> Int16X32# -> Int16X32#
quotInt16X32# = quotInt16X32#

{-| Rounds towards zero element-wise.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
quotInt32X16# :: Int32X16# -> Int32X16# -> Int32X16#
quotInt32X16# = quotInt32X16#

{-| Rounds towards zero element-wise.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
quotInt64X8# :: Int64X8# -> Int64X8# -> Int64X8#
quotInt64X8# = quotInt64X8#

{-| Rounds towards zero element-wise.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
quotWord8X16# :: Word8X16# -> Word8X16# -> Word8X16#
quotWord8X16# = quotWord8X16#

{-| Rounds towards zero element-wise.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
quotWord16X8# :: Word16X8# -> Word16X8# -> Word16X8#
quotWord16X8# = quotWord16X8#

{-| Rounds towards zero element-wise.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
quotWord32X4# :: Word32X4# -> Word32X4# -> Word32X4#
quotWord32X4# = quotWord32X4#

{-| Rounds towards zero element-wise.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
quotWord64X2# :: Word64X2# -> Word64X2# -> Word64X2#
quotWord64X2# = quotWord64X2#

{-| Rounds towards zero element-wise.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
quotWord8X32# :: Word8X32# -> Word8X32# -> Word8X32#
quotWord8X32# = quotWord8X32#

{-| Rounds towards zero element-wise.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
quotWord16X16# :: Word16X16# -> Word16X16# -> Word16X16#
quotWord16X16# = quotWord16X16#

{-| Rounds towards zero element-wise.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
quotWord32X8# :: Word32X8# -> Word32X8# -> Word32X8#
quotWord32X8# = quotWord32X8#

{-| Rounds towards zero element-wise.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
quotWord64X4# :: Word64X4# -> Word64X4# -> Word64X4#
quotWord64X4# = quotWord64X4#

{-| Rounds towards zero element-wise.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
quotWord8X64# :: Word8X64# -> Word8X64# -> Word8X64#
quotWord8X64# = quotWord8X64#

{-| Rounds towards zero element-wise.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
quotWord16X32# :: Word16X32# -> Word16X32# -> Word16X32#
quotWord16X32# = quotWord16X32#

{-| Rounds towards zero element-wise.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
quotWord32X16# :: Word32X16# -> Word32X16# -> Word32X16#
quotWord32X16# = quotWord32X16#

{-| Rounds towards zero element-wise.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
quotWord64X8# :: Word64X8# -> Word64X8# -> Word64X8#
quotWord64X8# = quotWord64X8#

{-| Satisfies @('quot#' x y) 'times#' y 'plus#' ('rem#' x y) == x@.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
remInt8X16# :: Int8X16# -> Int8X16# -> Int8X16#
remInt8X16# = remInt8X16#

{-| Satisfies @('quot#' x y) 'times#' y 'plus#' ('rem#' x y) == x@.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
remInt16X8# :: Int16X8# -> Int16X8# -> Int16X8#
remInt16X8# = remInt16X8#

{-| Satisfies @('quot#' x y) 'times#' y 'plus#' ('rem#' x y) == x@.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
remInt32X4# :: Int32X4# -> Int32X4# -> Int32X4#
remInt32X4# = remInt32X4#

{-| Satisfies @('quot#' x y) 'times#' y 'plus#' ('rem#' x y) == x@.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
remInt64X2# :: Int64X2# -> Int64X2# -> Int64X2#
remInt64X2# = remInt64X2#

{-| Satisfies @('quot#' x y) 'times#' y 'plus#' ('rem#' x y) == x@.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
remInt8X32# :: Int8X32# -> Int8X32# -> Int8X32#
remInt8X32# = remInt8X32#

{-| Satisfies @('quot#' x y) 'times#' y 'plus#' ('rem#' x y) == x@.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
remInt16X16# :: Int16X16# -> Int16X16# -> Int16X16#
remInt16X16# = remInt16X16#

{-| Satisfies @('quot#' x y) 'times#' y 'plus#' ('rem#' x y) == x@.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
remInt32X8# :: Int32X8# -> Int32X8# -> Int32X8#
remInt32X8# = remInt32X8#

{-| Satisfies @('quot#' x y) 'times#' y 'plus#' ('rem#' x y) == x@.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
remInt64X4# :: Int64X4# -> Int64X4# -> Int64X4#
remInt64X4# = remInt64X4#

{-| Satisfies @('quot#' x y) 'times#' y 'plus#' ('rem#' x y) == x@.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
remInt8X64# :: Int8X64# -> Int8X64# -> Int8X64#
remInt8X64# = remInt8X64#

{-| Satisfies @('quot#' x y) 'times#' y 'plus#' ('rem#' x y) == x@.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
remInt16X32# :: Int16X32# -> Int16X32# -> Int16X32#
remInt16X32# = remInt16X32#

{-| Satisfies @('quot#' x y) 'times#' y 'plus#' ('rem#' x y) == x@.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
remInt32X16# :: Int32X16# -> Int32X16# -> Int32X16#
remInt32X16# = remInt32X16#

{-| Satisfies @('quot#' x y) 'times#' y 'plus#' ('rem#' x y) == x@.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
remInt64X8# :: Int64X8# -> Int64X8# -> Int64X8#
remInt64X8# = remInt64X8#

{-| Satisfies @('quot#' x y) 'times#' y 'plus#' ('rem#' x y) == x@.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
remWord8X16# :: Word8X16# -> Word8X16# -> Word8X16#
remWord8X16# = remWord8X16#

{-| Satisfies @('quot#' x y) 'times#' y 'plus#' ('rem#' x y) == x@.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
remWord16X8# :: Word16X8# -> Word16X8# -> Word16X8#
remWord16X8# = remWord16X8#

{-| Satisfies @('quot#' x y) 'times#' y 'plus#' ('rem#' x y) == x@.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
remWord32X4# :: Word32X4# -> Word32X4# -> Word32X4#
remWord32X4# = remWord32X4#

{-| Satisfies @('quot#' x y) 'times#' y 'plus#' ('rem#' x y) == x@.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
remWord64X2# :: Word64X2# -> Word64X2# -> Word64X2#
remWord64X2# = remWord64X2#

{-| Satisfies @('quot#' x y) 'times#' y 'plus#' ('rem#' x y) == x@.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
remWord8X32# :: Word8X32# -> Word8X32# -> Word8X32#
remWord8X32# = remWord8X32#

{-| Satisfies @('quot#' x y) 'times#' y 'plus#' ('rem#' x y) == x@.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
remWord16X16# :: Word16X16# -> Word16X16# -> Word16X16#
remWord16X16# = remWord16X16#

{-| Satisfies @('quot#' x y) 'times#' y 'plus#' ('rem#' x y) == x@.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
remWord32X8# :: Word32X8# -> Word32X8# -> Word32X8#
remWord32X8# = remWord32X8#

{-| Satisfies @('quot#' x y) 'times#' y 'plus#' ('rem#' x y) == x@.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
remWord64X4# :: Word64X4# -> Word64X4# -> Word64X4#
remWord64X4# = remWord64X4#

{-| Satisfies @('quot#' x y) 'times#' y 'plus#' ('rem#' x y) == x@.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
remWord8X64# :: Word8X64# -> Word8X64# -> Word8X64#
remWord8X64# = remWord8X64#

{-| Satisfies @('quot#' x y) 'times#' y 'plus#' ('rem#' x y) == x@.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
remWord16X32# :: Word16X32# -> Word16X32# -> Word16X32#
remWord16X32# = remWord16X32#

{-| Satisfies @('quot#' x y) 'times#' y 'plus#' ('rem#' x y) == x@.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
remWord32X16# :: Word32X16# -> Word32X16# -> Word32X16#
remWord32X16# = remWord32X16#

{-| Satisfies @('quot#' x y) 'times#' y 'plus#' ('rem#' x y) == x@.

     Note: Most CPU ISAs do not contain any SIMD integer division instructions.
     Do not expect high performance. -}
remWord64X8# :: Word64X8# -> Word64X8# -> Word64X8#
remWord64X8# = remWord64X8#

{-| Negate element-wise. -}
negateInt8X16# :: Int8X16# -> Int8X16#
negateInt8X16# = negateInt8X16#

{-| Negate element-wise. -}
negateInt16X8# :: Int16X8# -> Int16X8#
negateInt16X8# = negateInt16X8#

{-| Negate element-wise. -}
negateInt32X4# :: Int32X4# -> Int32X4#
negateInt32X4# = negateInt32X4#

{-| Negate element-wise. -}
negateInt64X2# :: Int64X2# -> Int64X2#
negateInt64X2# = negateInt64X2#

{-| Negate element-wise. -}
negateInt8X32# :: Int8X32# -> Int8X32#
negateInt8X32# = negateInt8X32#

{-| Negate element-wise. -}
negateInt16X16# :: Int16X16# -> Int16X16#
negateInt16X16# = negateInt16X16#

{-| Negate element-wise. -}
negateInt32X8# :: Int32X8# -> Int32X8#
negateInt32X8# = negateInt32X8#

{-| Negate element-wise. -}
negateInt64X4# :: Int64X4# -> Int64X4#
negateInt64X4# = negateInt64X4#

{-| Negate element-wise. -}
negateInt8X64# :: Int8X64# -> Int8X64#
negateInt8X64# = negateInt8X64#

{-| Negate element-wise. -}
negateInt16X32# :: Int16X32# -> Int16X32#
negateInt16X32# = negateInt16X32#

{-| Negate element-wise. -}
negateInt32X16# :: Int32X16# -> Int32X16#
negateInt32X16# = negateInt32X16#

{-| Negate element-wise. -}
negateInt64X8# :: Int64X8# -> Int64X8#
negateInt64X8# = negateInt64X8#

{-| Negate element-wise. -}
negateFloatX4# :: FloatX4# -> FloatX4#
negateFloatX4# = negateFloatX4#

{-| Negate element-wise. -}
negateDoubleX2# :: DoubleX2# -> DoubleX2#
negateDoubleX2# = negateDoubleX2#

{-| Negate element-wise. -}
negateFloatX8# :: FloatX8# -> FloatX8#
negateFloatX8# = negateFloatX8#

{-| Negate element-wise. -}
negateDoubleX4# :: DoubleX4# -> DoubleX4#
negateDoubleX4# = negateDoubleX4#

{-| Negate element-wise. -}
negateFloatX16# :: FloatX16# -> FloatX16#
negateFloatX16# = negateFloatX16#

{-| Negate element-wise. -}
negateDoubleX8# :: DoubleX8# -> DoubleX8#
negateDoubleX8# = negateDoubleX8#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexInt8X16Array# :: ByteArray# -> Int# -> Int8X16#
indexInt8X16Array# = indexInt8X16Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexInt16X8Array# :: ByteArray# -> Int# -> Int16X8#
indexInt16X8Array# = indexInt16X8Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexInt32X4Array# :: ByteArray# -> Int# -> Int32X4#
indexInt32X4Array# = indexInt32X4Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexInt64X2Array# :: ByteArray# -> Int# -> Int64X2#
indexInt64X2Array# = indexInt64X2Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexInt8X32Array# :: ByteArray# -> Int# -> Int8X32#
indexInt8X32Array# = indexInt8X32Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexInt16X16Array# :: ByteArray# -> Int# -> Int16X16#
indexInt16X16Array# = indexInt16X16Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexInt32X8Array# :: ByteArray# -> Int# -> Int32X8#
indexInt32X8Array# = indexInt32X8Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexInt64X4Array# :: ByteArray# -> Int# -> Int64X4#
indexInt64X4Array# = indexInt64X4Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexInt8X64Array# :: ByteArray# -> Int# -> Int8X64#
indexInt8X64Array# = indexInt8X64Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexInt16X32Array# :: ByteArray# -> Int# -> Int16X32#
indexInt16X32Array# = indexInt16X32Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexInt32X16Array# :: ByteArray# -> Int# -> Int32X16#
indexInt32X16Array# = indexInt32X16Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexInt64X8Array# :: ByteArray# -> Int# -> Int64X8#
indexInt64X8Array# = indexInt64X8Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexWord8X16Array# :: ByteArray# -> Int# -> Word8X16#
indexWord8X16Array# = indexWord8X16Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexWord16X8Array# :: ByteArray# -> Int# -> Word16X8#
indexWord16X8Array# = indexWord16X8Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexWord32X4Array# :: ByteArray# -> Int# -> Word32X4#
indexWord32X4Array# = indexWord32X4Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexWord64X2Array# :: ByteArray# -> Int# -> Word64X2#
indexWord64X2Array# = indexWord64X2Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexWord8X32Array# :: ByteArray# -> Int# -> Word8X32#
indexWord8X32Array# = indexWord8X32Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexWord16X16Array# :: ByteArray# -> Int# -> Word16X16#
indexWord16X16Array# = indexWord16X16Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexWord32X8Array# :: ByteArray# -> Int# -> Word32X8#
indexWord32X8Array# = indexWord32X8Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexWord64X4Array# :: ByteArray# -> Int# -> Word64X4#
indexWord64X4Array# = indexWord64X4Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexWord8X64Array# :: ByteArray# -> Int# -> Word8X64#
indexWord8X64Array# = indexWord8X64Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexWord16X32Array# :: ByteArray# -> Int# -> Word16X32#
indexWord16X32Array# = indexWord16X32Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexWord32X16Array# :: ByteArray# -> Int# -> Word32X16#
indexWord32X16Array# = indexWord32X16Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexWord64X8Array# :: ByteArray# -> Int# -> Word64X8#
indexWord64X8Array# = indexWord64X8Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexFloatX4Array# :: ByteArray# -> Int# -> FloatX4#
indexFloatX4Array# = indexFloatX4Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexDoubleX2Array# :: ByteArray# -> Int# -> DoubleX2#
indexDoubleX2Array# = indexDoubleX2Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexFloatX8Array# :: ByteArray# -> Int# -> FloatX8#
indexFloatX8Array# = indexFloatX8Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexDoubleX4Array# :: ByteArray# -> Int# -> DoubleX4#
indexDoubleX4Array# = indexDoubleX4Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexFloatX16Array# :: ByteArray# -> Int# -> FloatX16#
indexFloatX16Array# = indexFloatX16Array#

{-| Read a vector from the specified index of an immutable array.
     The index is counted in units of SIMD vectors (not scalar elements). -}
indexDoubleX8Array# :: ByteArray# -> Int# -> DoubleX8#
indexDoubleX8Array# = indexDoubleX8Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt8X16Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int8X16# #)
readInt8X16Array# = readInt8X16Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt16X8Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int16X8# #)
readInt16X8Array# = readInt16X8Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt32X4Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int32X4# #)
readInt32X4Array# = readInt32X4Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt64X2Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int64X2# #)
readInt64X2Array# = readInt64X2Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt8X32Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int8X32# #)
readInt8X32Array# = readInt8X32Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt16X16Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int16X16# #)
readInt16X16Array# = readInt16X16Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt32X8Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int32X8# #)
readInt32X8Array# = readInt32X8Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt64X4Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int64X4# #)
readInt64X4Array# = readInt64X4Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt8X64Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int8X64# #)
readInt8X64Array# = readInt8X64Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt16X32Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int16X32# #)
readInt16X32Array# = readInt16X32Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt32X16Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int32X16# #)
readInt32X16Array# = readInt32X16Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt64X8Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int64X8# #)
readInt64X8Array# = readInt64X8Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8X16Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word8X16# #)
readWord8X16Array# = readWord8X16Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord16X8Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word16X8# #)
readWord16X8Array# = readWord16X8Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord32X4Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word32X4# #)
readWord32X4Array# = readWord32X4Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord64X2Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word64X2# #)
readWord64X2Array# = readWord64X2Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8X32Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word8X32# #)
readWord8X32Array# = readWord8X32Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord16X16Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word16X16# #)
readWord16X16Array# = readWord16X16Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord32X8Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word32X8# #)
readWord32X8Array# = readWord32X8Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord64X4Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word64X4# #)
readWord64X4Array# = readWord64X4Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8X64Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word8X64# #)
readWord8X64Array# = readWord8X64Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord16X32Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word16X32# #)
readWord16X32Array# = readWord16X32Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord32X16Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word32X16# #)
readWord32X16Array# = readWord32X16Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord64X8Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word64X8# #)
readWord64X8Array# = readWord64X8Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readFloatX4Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,FloatX4# #)
readFloatX4Array# = readFloatX4Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readDoubleX2Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,DoubleX2# #)
readDoubleX2Array# = readDoubleX2Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readFloatX8Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,FloatX8# #)
readFloatX8Array# = readFloatX8Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readDoubleX4Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,DoubleX4# #)
readDoubleX4Array# = readDoubleX4Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readFloatX16Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,FloatX16# #)
readFloatX16Array# = readFloatX16Array#

{-| Read a vector from the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readDoubleX8Array# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,DoubleX8# #)
readDoubleX8Array# = readDoubleX8Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt8X16Array# :: MutableByteArray# s -> Int# -> Int8X16# -> State# s -> State# s
writeInt8X16Array# = writeInt8X16Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt16X8Array# :: MutableByteArray# s -> Int# -> Int16X8# -> State# s -> State# s
writeInt16X8Array# = writeInt16X8Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt32X4Array# :: MutableByteArray# s -> Int# -> Int32X4# -> State# s -> State# s
writeInt32X4Array# = writeInt32X4Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt64X2Array# :: MutableByteArray# s -> Int# -> Int64X2# -> State# s -> State# s
writeInt64X2Array# = writeInt64X2Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt8X32Array# :: MutableByteArray# s -> Int# -> Int8X32# -> State# s -> State# s
writeInt8X32Array# = writeInt8X32Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt16X16Array# :: MutableByteArray# s -> Int# -> Int16X16# -> State# s -> State# s
writeInt16X16Array# = writeInt16X16Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt32X8Array# :: MutableByteArray# s -> Int# -> Int32X8# -> State# s -> State# s
writeInt32X8Array# = writeInt32X8Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt64X4Array# :: MutableByteArray# s -> Int# -> Int64X4# -> State# s -> State# s
writeInt64X4Array# = writeInt64X4Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt8X64Array# :: MutableByteArray# s -> Int# -> Int8X64# -> State# s -> State# s
writeInt8X64Array# = writeInt8X64Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt16X32Array# :: MutableByteArray# s -> Int# -> Int16X32# -> State# s -> State# s
writeInt16X32Array# = writeInt16X32Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt32X16Array# :: MutableByteArray# s -> Int# -> Int32X16# -> State# s -> State# s
writeInt32X16Array# = writeInt32X16Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt64X8Array# :: MutableByteArray# s -> Int# -> Int64X8# -> State# s -> State# s
writeInt64X8Array# = writeInt64X8Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8X16Array# :: MutableByteArray# s -> Int# -> Word8X16# -> State# s -> State# s
writeWord8X16Array# = writeWord8X16Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord16X8Array# :: MutableByteArray# s -> Int# -> Word16X8# -> State# s -> State# s
writeWord16X8Array# = writeWord16X8Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord32X4Array# :: MutableByteArray# s -> Int# -> Word32X4# -> State# s -> State# s
writeWord32X4Array# = writeWord32X4Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord64X2Array# :: MutableByteArray# s -> Int# -> Word64X2# -> State# s -> State# s
writeWord64X2Array# = writeWord64X2Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8X32Array# :: MutableByteArray# s -> Int# -> Word8X32# -> State# s -> State# s
writeWord8X32Array# = writeWord8X32Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord16X16Array# :: MutableByteArray# s -> Int# -> Word16X16# -> State# s -> State# s
writeWord16X16Array# = writeWord16X16Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord32X8Array# :: MutableByteArray# s -> Int# -> Word32X8# -> State# s -> State# s
writeWord32X8Array# = writeWord32X8Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord64X4Array# :: MutableByteArray# s -> Int# -> Word64X4# -> State# s -> State# s
writeWord64X4Array# = writeWord64X4Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8X64Array# :: MutableByteArray# s -> Int# -> Word8X64# -> State# s -> State# s
writeWord8X64Array# = writeWord8X64Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord16X32Array# :: MutableByteArray# s -> Int# -> Word16X32# -> State# s -> State# s
writeWord16X32Array# = writeWord16X32Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord32X16Array# :: MutableByteArray# s -> Int# -> Word32X16# -> State# s -> State# s
writeWord32X16Array# = writeWord32X16Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord64X8Array# :: MutableByteArray# s -> Int# -> Word64X8# -> State# s -> State# s
writeWord64X8Array# = writeWord64X8Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeFloatX4Array# :: MutableByteArray# s -> Int# -> FloatX4# -> State# s -> State# s
writeFloatX4Array# = writeFloatX4Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeDoubleX2Array# :: MutableByteArray# s -> Int# -> DoubleX2# -> State# s -> State# s
writeDoubleX2Array# = writeDoubleX2Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeFloatX8Array# :: MutableByteArray# s -> Int# -> FloatX8# -> State# s -> State# s
writeFloatX8Array# = writeFloatX8Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeDoubleX4Array# :: MutableByteArray# s -> Int# -> DoubleX4# -> State# s -> State# s
writeDoubleX4Array# = writeDoubleX4Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeFloatX16Array# :: MutableByteArray# s -> Int# -> FloatX16# -> State# s -> State# s
writeFloatX16Array# = writeFloatX16Array#

{-| Write a vector to the specified index of a mutable array.
     The index is counted in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeDoubleX8Array# :: MutableByteArray# s -> Int# -> DoubleX8# -> State# s -> State# s
writeDoubleX8Array# = writeDoubleX8Array#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexInt8X16OffAddr# :: Addr# -> Int# -> Int8X16#
indexInt8X16OffAddr# = indexInt8X16OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexInt16X8OffAddr# :: Addr# -> Int# -> Int16X8#
indexInt16X8OffAddr# = indexInt16X8OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexInt32X4OffAddr# :: Addr# -> Int# -> Int32X4#
indexInt32X4OffAddr# = indexInt32X4OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexInt64X2OffAddr# :: Addr# -> Int# -> Int64X2#
indexInt64X2OffAddr# = indexInt64X2OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexInt8X32OffAddr# :: Addr# -> Int# -> Int8X32#
indexInt8X32OffAddr# = indexInt8X32OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexInt16X16OffAddr# :: Addr# -> Int# -> Int16X16#
indexInt16X16OffAddr# = indexInt16X16OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexInt32X8OffAddr# :: Addr# -> Int# -> Int32X8#
indexInt32X8OffAddr# = indexInt32X8OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexInt64X4OffAddr# :: Addr# -> Int# -> Int64X4#
indexInt64X4OffAddr# = indexInt64X4OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexInt8X64OffAddr# :: Addr# -> Int# -> Int8X64#
indexInt8X64OffAddr# = indexInt8X64OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexInt16X32OffAddr# :: Addr# -> Int# -> Int16X32#
indexInt16X32OffAddr# = indexInt16X32OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexInt32X16OffAddr# :: Addr# -> Int# -> Int32X16#
indexInt32X16OffAddr# = indexInt32X16OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexInt64X8OffAddr# :: Addr# -> Int# -> Int64X8#
indexInt64X8OffAddr# = indexInt64X8OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexWord8X16OffAddr# :: Addr# -> Int# -> Word8X16#
indexWord8X16OffAddr# = indexWord8X16OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexWord16X8OffAddr# :: Addr# -> Int# -> Word16X8#
indexWord16X8OffAddr# = indexWord16X8OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexWord32X4OffAddr# :: Addr# -> Int# -> Word32X4#
indexWord32X4OffAddr# = indexWord32X4OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexWord64X2OffAddr# :: Addr# -> Int# -> Word64X2#
indexWord64X2OffAddr# = indexWord64X2OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexWord8X32OffAddr# :: Addr# -> Int# -> Word8X32#
indexWord8X32OffAddr# = indexWord8X32OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexWord16X16OffAddr# :: Addr# -> Int# -> Word16X16#
indexWord16X16OffAddr# = indexWord16X16OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexWord32X8OffAddr# :: Addr# -> Int# -> Word32X8#
indexWord32X8OffAddr# = indexWord32X8OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexWord64X4OffAddr# :: Addr# -> Int# -> Word64X4#
indexWord64X4OffAddr# = indexWord64X4OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexWord8X64OffAddr# :: Addr# -> Int# -> Word8X64#
indexWord8X64OffAddr# = indexWord8X64OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexWord16X32OffAddr# :: Addr# -> Int# -> Word16X32#
indexWord16X32OffAddr# = indexWord16X32OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexWord32X16OffAddr# :: Addr# -> Int# -> Word32X16#
indexWord32X16OffAddr# = indexWord32X16OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexWord64X8OffAddr# :: Addr# -> Int# -> Word64X8#
indexWord64X8OffAddr# = indexWord64X8OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexFloatX4OffAddr# :: Addr# -> Int# -> FloatX4#
indexFloatX4OffAddr# = indexFloatX4OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexDoubleX2OffAddr# :: Addr# -> Int# -> DoubleX2#
indexDoubleX2OffAddr# = indexDoubleX2OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexFloatX8OffAddr# :: Addr# -> Int# -> FloatX8#
indexFloatX8OffAddr# = indexFloatX8OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexDoubleX4OffAddr# :: Addr# -> Int# -> DoubleX4#
indexDoubleX4OffAddr# = indexDoubleX4OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexFloatX16OffAddr# :: Addr# -> Int# -> FloatX16#
indexFloatX16OffAddr# = indexFloatX16OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). -}
indexDoubleX8OffAddr# :: Addr# -> Int# -> DoubleX8#
indexDoubleX8OffAddr# = indexDoubleX8OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt8X16OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Int8X16# #)
readInt8X16OffAddr# = readInt8X16OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt16X8OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Int16X8# #)
readInt16X8OffAddr# = readInt16X8OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt32X4OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Int32X4# #)
readInt32X4OffAddr# = readInt32X4OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt64X2OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Int64X2# #)
readInt64X2OffAddr# = readInt64X2OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt8X32OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Int8X32# #)
readInt8X32OffAddr# = readInt8X32OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt16X16OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Int16X16# #)
readInt16X16OffAddr# = readInt16X16OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt32X8OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Int32X8# #)
readInt32X8OffAddr# = readInt32X8OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt64X4OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Int64X4# #)
readInt64X4OffAddr# = readInt64X4OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt8X64OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Int8X64# #)
readInt8X64OffAddr# = readInt8X64OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt16X32OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Int16X32# #)
readInt16X32OffAddr# = readInt16X32OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt32X16OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Int32X16# #)
readInt32X16OffAddr# = readInt32X16OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt64X8OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Int64X8# #)
readInt64X8OffAddr# = readInt64X8OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8X16OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Word8X16# #)
readWord8X16OffAddr# = readWord8X16OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord16X8OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Word16X8# #)
readWord16X8OffAddr# = readWord16X8OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord32X4OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Word32X4# #)
readWord32X4OffAddr# = readWord32X4OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord64X2OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Word64X2# #)
readWord64X2OffAddr# = readWord64X2OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8X32OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Word8X32# #)
readWord8X32OffAddr# = readWord8X32OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord16X16OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Word16X16# #)
readWord16X16OffAddr# = readWord16X16OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord32X8OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Word32X8# #)
readWord32X8OffAddr# = readWord32X8OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord64X4OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Word64X4# #)
readWord64X4OffAddr# = readWord64X4OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8X64OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Word8X64# #)
readWord8X64OffAddr# = readWord8X64OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord16X32OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Word16X32# #)
readWord16X32OffAddr# = readWord16X32OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord32X16OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Word32X16# #)
readWord32X16OffAddr# = readWord32X16OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord64X8OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,Word64X8# #)
readWord64X8OffAddr# = readWord64X8OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readFloatX4OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,FloatX4# #)
readFloatX4OffAddr# = readFloatX4OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readDoubleX2OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,DoubleX2# #)
readDoubleX2OffAddr# = readDoubleX2OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readFloatX8OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,FloatX8# #)
readFloatX8OffAddr# = readFloatX8OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readDoubleX4OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,DoubleX4# #)
readDoubleX4OffAddr# = readDoubleX4OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readFloatX16OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,FloatX16# #)
readFloatX16OffAddr# = readFloatX16OffAddr#

{-| Reads vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
readDoubleX8OffAddr# :: Addr# -> Int# -> State# s -> (# State# s,DoubleX8# #)
readDoubleX8OffAddr# = readDoubleX8OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt8X16OffAddr# :: Addr# -> Int# -> Int8X16# -> State# s -> State# s
writeInt8X16OffAddr# = writeInt8X16OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt16X8OffAddr# :: Addr# -> Int# -> Int16X8# -> State# s -> State# s
writeInt16X8OffAddr# = writeInt16X8OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt32X4OffAddr# :: Addr# -> Int# -> Int32X4# -> State# s -> State# s
writeInt32X4OffAddr# = writeInt32X4OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt64X2OffAddr# :: Addr# -> Int# -> Int64X2# -> State# s -> State# s
writeInt64X2OffAddr# = writeInt64X2OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt8X32OffAddr# :: Addr# -> Int# -> Int8X32# -> State# s -> State# s
writeInt8X32OffAddr# = writeInt8X32OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt16X16OffAddr# :: Addr# -> Int# -> Int16X16# -> State# s -> State# s
writeInt16X16OffAddr# = writeInt16X16OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt32X8OffAddr# :: Addr# -> Int# -> Int32X8# -> State# s -> State# s
writeInt32X8OffAddr# = writeInt32X8OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt64X4OffAddr# :: Addr# -> Int# -> Int64X4# -> State# s -> State# s
writeInt64X4OffAddr# = writeInt64X4OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt8X64OffAddr# :: Addr# -> Int# -> Int8X64# -> State# s -> State# s
writeInt8X64OffAddr# = writeInt8X64OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt16X32OffAddr# :: Addr# -> Int# -> Int16X32# -> State# s -> State# s
writeInt16X32OffAddr# = writeInt16X32OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt32X16OffAddr# :: Addr# -> Int# -> Int32X16# -> State# s -> State# s
writeInt32X16OffAddr# = writeInt32X16OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt64X8OffAddr# :: Addr# -> Int# -> Int64X8# -> State# s -> State# s
writeInt64X8OffAddr# = writeInt64X8OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8X16OffAddr# :: Addr# -> Int# -> Word8X16# -> State# s -> State# s
writeWord8X16OffAddr# = writeWord8X16OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord16X8OffAddr# :: Addr# -> Int# -> Word16X8# -> State# s -> State# s
writeWord16X8OffAddr# = writeWord16X8OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord32X4OffAddr# :: Addr# -> Int# -> Word32X4# -> State# s -> State# s
writeWord32X4OffAddr# = writeWord32X4OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord64X2OffAddr# :: Addr# -> Int# -> Word64X2# -> State# s -> State# s
writeWord64X2OffAddr# = writeWord64X2OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8X32OffAddr# :: Addr# -> Int# -> Word8X32# -> State# s -> State# s
writeWord8X32OffAddr# = writeWord8X32OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord16X16OffAddr# :: Addr# -> Int# -> Word16X16# -> State# s -> State# s
writeWord16X16OffAddr# = writeWord16X16OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord32X8OffAddr# :: Addr# -> Int# -> Word32X8# -> State# s -> State# s
writeWord32X8OffAddr# = writeWord32X8OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord64X4OffAddr# :: Addr# -> Int# -> Word64X4# -> State# s -> State# s
writeWord64X4OffAddr# = writeWord64X4OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8X64OffAddr# :: Addr# -> Int# -> Word8X64# -> State# s -> State# s
writeWord8X64OffAddr# = writeWord8X64OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord16X32OffAddr# :: Addr# -> Int# -> Word16X32# -> State# s -> State# s
writeWord16X32OffAddr# = writeWord16X32OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord32X16OffAddr# :: Addr# -> Int# -> Word32X16# -> State# s -> State# s
writeWord32X16OffAddr# = writeWord32X16OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord64X8OffAddr# :: Addr# -> Int# -> Word64X8# -> State# s -> State# s
writeWord64X8OffAddr# = writeWord64X8OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeFloatX4OffAddr# :: Addr# -> Int# -> FloatX4# -> State# s -> State# s
writeFloatX4OffAddr# = writeFloatX4OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeDoubleX2OffAddr# :: Addr# -> Int# -> DoubleX2# -> State# s -> State# s
writeDoubleX2OffAddr# = writeDoubleX2OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeFloatX8OffAddr# :: Addr# -> Int# -> FloatX8# -> State# s -> State# s
writeFloatX8OffAddr# = writeFloatX8OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeDoubleX4OffAddr# :: Addr# -> Int# -> DoubleX4# -> State# s -> State# s
writeDoubleX4OffAddr# = writeDoubleX4OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeFloatX16OffAddr# :: Addr# -> Int# -> FloatX16# -> State# s -> State# s
writeFloatX16OffAddr# = writeFloatX16OffAddr#

{-| Write vector; offset in units of SIMD vectors (not scalar elements). 

__/Warning:/__ this can fail with an unchecked exception.-}
writeDoubleX8OffAddr# :: Addr# -> Int# -> DoubleX8# -> State# s -> State# s
writeDoubleX8OffAddr# = writeDoubleX8OffAddr#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexInt8ArrayAsInt8X16# :: ByteArray# -> Int# -> Int8X16#
indexInt8ArrayAsInt8X16# = indexInt8ArrayAsInt8X16#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexInt16ArrayAsInt16X8# :: ByteArray# -> Int# -> Int16X8#
indexInt16ArrayAsInt16X8# = indexInt16ArrayAsInt16X8#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexInt32ArrayAsInt32X4# :: ByteArray# -> Int# -> Int32X4#
indexInt32ArrayAsInt32X4# = indexInt32ArrayAsInt32X4#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexInt64ArrayAsInt64X2# :: ByteArray# -> Int# -> Int64X2#
indexInt64ArrayAsInt64X2# = indexInt64ArrayAsInt64X2#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexInt8ArrayAsInt8X32# :: ByteArray# -> Int# -> Int8X32#
indexInt8ArrayAsInt8X32# = indexInt8ArrayAsInt8X32#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexInt16ArrayAsInt16X16# :: ByteArray# -> Int# -> Int16X16#
indexInt16ArrayAsInt16X16# = indexInt16ArrayAsInt16X16#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexInt32ArrayAsInt32X8# :: ByteArray# -> Int# -> Int32X8#
indexInt32ArrayAsInt32X8# = indexInt32ArrayAsInt32X8#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexInt64ArrayAsInt64X4# :: ByteArray# -> Int# -> Int64X4#
indexInt64ArrayAsInt64X4# = indexInt64ArrayAsInt64X4#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexInt8ArrayAsInt8X64# :: ByteArray# -> Int# -> Int8X64#
indexInt8ArrayAsInt8X64# = indexInt8ArrayAsInt8X64#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexInt16ArrayAsInt16X32# :: ByteArray# -> Int# -> Int16X32#
indexInt16ArrayAsInt16X32# = indexInt16ArrayAsInt16X32#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexInt32ArrayAsInt32X16# :: ByteArray# -> Int# -> Int32X16#
indexInt32ArrayAsInt32X16# = indexInt32ArrayAsInt32X16#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexInt64ArrayAsInt64X8# :: ByteArray# -> Int# -> Int64X8#
indexInt64ArrayAsInt64X8# = indexInt64ArrayAsInt64X8#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexWord8ArrayAsWord8X16# :: ByteArray# -> Int# -> Word8X16#
indexWord8ArrayAsWord8X16# = indexWord8ArrayAsWord8X16#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexWord16ArrayAsWord16X8# :: ByteArray# -> Int# -> Word16X8#
indexWord16ArrayAsWord16X8# = indexWord16ArrayAsWord16X8#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexWord32ArrayAsWord32X4# :: ByteArray# -> Int# -> Word32X4#
indexWord32ArrayAsWord32X4# = indexWord32ArrayAsWord32X4#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexWord64ArrayAsWord64X2# :: ByteArray# -> Int# -> Word64X2#
indexWord64ArrayAsWord64X2# = indexWord64ArrayAsWord64X2#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexWord8ArrayAsWord8X32# :: ByteArray# -> Int# -> Word8X32#
indexWord8ArrayAsWord8X32# = indexWord8ArrayAsWord8X32#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexWord16ArrayAsWord16X16# :: ByteArray# -> Int# -> Word16X16#
indexWord16ArrayAsWord16X16# = indexWord16ArrayAsWord16X16#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexWord32ArrayAsWord32X8# :: ByteArray# -> Int# -> Word32X8#
indexWord32ArrayAsWord32X8# = indexWord32ArrayAsWord32X8#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexWord64ArrayAsWord64X4# :: ByteArray# -> Int# -> Word64X4#
indexWord64ArrayAsWord64X4# = indexWord64ArrayAsWord64X4#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexWord8ArrayAsWord8X64# :: ByteArray# -> Int# -> Word8X64#
indexWord8ArrayAsWord8X64# = indexWord8ArrayAsWord8X64#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexWord16ArrayAsWord16X32# :: ByteArray# -> Int# -> Word16X32#
indexWord16ArrayAsWord16X32# = indexWord16ArrayAsWord16X32#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexWord32ArrayAsWord32X16# :: ByteArray# -> Int# -> Word32X16#
indexWord32ArrayAsWord32X16# = indexWord32ArrayAsWord32X16#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexWord64ArrayAsWord64X8# :: ByteArray# -> Int# -> Word64X8#
indexWord64ArrayAsWord64X8# = indexWord64ArrayAsWord64X8#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexFloatArrayAsFloatX4# :: ByteArray# -> Int# -> FloatX4#
indexFloatArrayAsFloatX4# = indexFloatArrayAsFloatX4#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexDoubleArrayAsDoubleX2# :: ByteArray# -> Int# -> DoubleX2#
indexDoubleArrayAsDoubleX2# = indexDoubleArrayAsDoubleX2#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexFloatArrayAsFloatX8# :: ByteArray# -> Int# -> FloatX8#
indexFloatArrayAsFloatX8# = indexFloatArrayAsFloatX8#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexDoubleArrayAsDoubleX4# :: ByteArray# -> Int# -> DoubleX4#
indexDoubleArrayAsDoubleX4# = indexDoubleArrayAsDoubleX4#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexFloatArrayAsFloatX16# :: ByteArray# -> Int# -> FloatX16#
indexFloatArrayAsFloatX16# = indexFloatArrayAsFloatX16#

{-| Read a vector from specified index of immutable array of scalars; offset is in scalar elements. -}
indexDoubleArrayAsDoubleX8# :: ByteArray# -> Int# -> DoubleX8#
indexDoubleArrayAsDoubleX8# = indexDoubleArrayAsDoubleX8#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt8ArrayAsInt8X16# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int8X16# #)
readInt8ArrayAsInt8X16# = readInt8ArrayAsInt8X16#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt16ArrayAsInt16X8# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int16X8# #)
readInt16ArrayAsInt16X8# = readInt16ArrayAsInt16X8#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt32ArrayAsInt32X4# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int32X4# #)
readInt32ArrayAsInt32X4# = readInt32ArrayAsInt32X4#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt64ArrayAsInt64X2# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int64X2# #)
readInt64ArrayAsInt64X2# = readInt64ArrayAsInt64X2#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt8ArrayAsInt8X32# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int8X32# #)
readInt8ArrayAsInt8X32# = readInt8ArrayAsInt8X32#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt16ArrayAsInt16X16# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int16X16# #)
readInt16ArrayAsInt16X16# = readInt16ArrayAsInt16X16#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt32ArrayAsInt32X8# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int32X8# #)
readInt32ArrayAsInt32X8# = readInt32ArrayAsInt32X8#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt64ArrayAsInt64X4# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int64X4# #)
readInt64ArrayAsInt64X4# = readInt64ArrayAsInt64X4#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt8ArrayAsInt8X64# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int8X64# #)
readInt8ArrayAsInt8X64# = readInt8ArrayAsInt8X64#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt16ArrayAsInt16X32# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int16X32# #)
readInt16ArrayAsInt16X32# = readInt16ArrayAsInt16X32#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt32ArrayAsInt32X16# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int32X16# #)
readInt32ArrayAsInt32X16# = readInt32ArrayAsInt32X16#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt64ArrayAsInt64X8# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Int64X8# #)
readInt64ArrayAsInt64X8# = readInt64ArrayAsInt64X8#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8ArrayAsWord8X16# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word8X16# #)
readWord8ArrayAsWord8X16# = readWord8ArrayAsWord8X16#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord16ArrayAsWord16X8# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word16X8# #)
readWord16ArrayAsWord16X8# = readWord16ArrayAsWord16X8#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord32ArrayAsWord32X4# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word32X4# #)
readWord32ArrayAsWord32X4# = readWord32ArrayAsWord32X4#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord64ArrayAsWord64X2# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word64X2# #)
readWord64ArrayAsWord64X2# = readWord64ArrayAsWord64X2#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8ArrayAsWord8X32# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word8X32# #)
readWord8ArrayAsWord8X32# = readWord8ArrayAsWord8X32#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord16ArrayAsWord16X16# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word16X16# #)
readWord16ArrayAsWord16X16# = readWord16ArrayAsWord16X16#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord32ArrayAsWord32X8# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word32X8# #)
readWord32ArrayAsWord32X8# = readWord32ArrayAsWord32X8#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord64ArrayAsWord64X4# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word64X4# #)
readWord64ArrayAsWord64X4# = readWord64ArrayAsWord64X4#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8ArrayAsWord8X64# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word8X64# #)
readWord8ArrayAsWord8X64# = readWord8ArrayAsWord8X64#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord16ArrayAsWord16X32# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word16X32# #)
readWord16ArrayAsWord16X32# = readWord16ArrayAsWord16X32#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord32ArrayAsWord32X16# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word32X16# #)
readWord32ArrayAsWord32X16# = readWord32ArrayAsWord32X16#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord64ArrayAsWord64X8# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,Word64X8# #)
readWord64ArrayAsWord64X8# = readWord64ArrayAsWord64X8#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readFloatArrayAsFloatX4# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,FloatX4# #)
readFloatArrayAsFloatX4# = readFloatArrayAsFloatX4#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readDoubleArrayAsDoubleX2# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,DoubleX2# #)
readDoubleArrayAsDoubleX2# = readDoubleArrayAsDoubleX2#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readFloatArrayAsFloatX8# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,FloatX8# #)
readFloatArrayAsFloatX8# = readFloatArrayAsFloatX8#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readDoubleArrayAsDoubleX4# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,DoubleX4# #)
readDoubleArrayAsDoubleX4# = readDoubleArrayAsDoubleX4#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readFloatArrayAsFloatX16# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,FloatX16# #)
readFloatArrayAsFloatX16# = readFloatArrayAsFloatX16#

{-| Read a vector from specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readDoubleArrayAsDoubleX8# :: MutableByteArray# s -> Int# -> State# s -> (# State# s,DoubleX8# #)
readDoubleArrayAsDoubleX8# = readDoubleArrayAsDoubleX8#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt8ArrayAsInt8X16# :: MutableByteArray# s -> Int# -> Int8X16# -> State# s -> State# s
writeInt8ArrayAsInt8X16# = writeInt8ArrayAsInt8X16#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt16ArrayAsInt16X8# :: MutableByteArray# s -> Int# -> Int16X8# -> State# s -> State# s
writeInt16ArrayAsInt16X8# = writeInt16ArrayAsInt16X8#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt32ArrayAsInt32X4# :: MutableByteArray# s -> Int# -> Int32X4# -> State# s -> State# s
writeInt32ArrayAsInt32X4# = writeInt32ArrayAsInt32X4#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt64ArrayAsInt64X2# :: MutableByteArray# s -> Int# -> Int64X2# -> State# s -> State# s
writeInt64ArrayAsInt64X2# = writeInt64ArrayAsInt64X2#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt8ArrayAsInt8X32# :: MutableByteArray# s -> Int# -> Int8X32# -> State# s -> State# s
writeInt8ArrayAsInt8X32# = writeInt8ArrayAsInt8X32#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt16ArrayAsInt16X16# :: MutableByteArray# s -> Int# -> Int16X16# -> State# s -> State# s
writeInt16ArrayAsInt16X16# = writeInt16ArrayAsInt16X16#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt32ArrayAsInt32X8# :: MutableByteArray# s -> Int# -> Int32X8# -> State# s -> State# s
writeInt32ArrayAsInt32X8# = writeInt32ArrayAsInt32X8#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt64ArrayAsInt64X4# :: MutableByteArray# s -> Int# -> Int64X4# -> State# s -> State# s
writeInt64ArrayAsInt64X4# = writeInt64ArrayAsInt64X4#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt8ArrayAsInt8X64# :: MutableByteArray# s -> Int# -> Int8X64# -> State# s -> State# s
writeInt8ArrayAsInt8X64# = writeInt8ArrayAsInt8X64#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt16ArrayAsInt16X32# :: MutableByteArray# s -> Int# -> Int16X32# -> State# s -> State# s
writeInt16ArrayAsInt16X32# = writeInt16ArrayAsInt16X32#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt32ArrayAsInt32X16# :: MutableByteArray# s -> Int# -> Int32X16# -> State# s -> State# s
writeInt32ArrayAsInt32X16# = writeInt32ArrayAsInt32X16#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt64ArrayAsInt64X8# :: MutableByteArray# s -> Int# -> Int64X8# -> State# s -> State# s
writeInt64ArrayAsInt64X8# = writeInt64ArrayAsInt64X8#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8ArrayAsWord8X16# :: MutableByteArray# s -> Int# -> Word8X16# -> State# s -> State# s
writeWord8ArrayAsWord8X16# = writeWord8ArrayAsWord8X16#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord16ArrayAsWord16X8# :: MutableByteArray# s -> Int# -> Word16X8# -> State# s -> State# s
writeWord16ArrayAsWord16X8# = writeWord16ArrayAsWord16X8#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord32ArrayAsWord32X4# :: MutableByteArray# s -> Int# -> Word32X4# -> State# s -> State# s
writeWord32ArrayAsWord32X4# = writeWord32ArrayAsWord32X4#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord64ArrayAsWord64X2# :: MutableByteArray# s -> Int# -> Word64X2# -> State# s -> State# s
writeWord64ArrayAsWord64X2# = writeWord64ArrayAsWord64X2#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8ArrayAsWord8X32# :: MutableByteArray# s -> Int# -> Word8X32# -> State# s -> State# s
writeWord8ArrayAsWord8X32# = writeWord8ArrayAsWord8X32#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord16ArrayAsWord16X16# :: MutableByteArray# s -> Int# -> Word16X16# -> State# s -> State# s
writeWord16ArrayAsWord16X16# = writeWord16ArrayAsWord16X16#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord32ArrayAsWord32X8# :: MutableByteArray# s -> Int# -> Word32X8# -> State# s -> State# s
writeWord32ArrayAsWord32X8# = writeWord32ArrayAsWord32X8#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord64ArrayAsWord64X4# :: MutableByteArray# s -> Int# -> Word64X4# -> State# s -> State# s
writeWord64ArrayAsWord64X4# = writeWord64ArrayAsWord64X4#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8ArrayAsWord8X64# :: MutableByteArray# s -> Int# -> Word8X64# -> State# s -> State# s
writeWord8ArrayAsWord8X64# = writeWord8ArrayAsWord8X64#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord16ArrayAsWord16X32# :: MutableByteArray# s -> Int# -> Word16X32# -> State# s -> State# s
writeWord16ArrayAsWord16X32# = writeWord16ArrayAsWord16X32#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord32ArrayAsWord32X16# :: MutableByteArray# s -> Int# -> Word32X16# -> State# s -> State# s
writeWord32ArrayAsWord32X16# = writeWord32ArrayAsWord32X16#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord64ArrayAsWord64X8# :: MutableByteArray# s -> Int# -> Word64X8# -> State# s -> State# s
writeWord64ArrayAsWord64X8# = writeWord64ArrayAsWord64X8#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeFloatArrayAsFloatX4# :: MutableByteArray# s -> Int# -> FloatX4# -> State# s -> State# s
writeFloatArrayAsFloatX4# = writeFloatArrayAsFloatX4#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeDoubleArrayAsDoubleX2# :: MutableByteArray# s -> Int# -> DoubleX2# -> State# s -> State# s
writeDoubleArrayAsDoubleX2# = writeDoubleArrayAsDoubleX2#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeFloatArrayAsFloatX8# :: MutableByteArray# s -> Int# -> FloatX8# -> State# s -> State# s
writeFloatArrayAsFloatX8# = writeFloatArrayAsFloatX8#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeDoubleArrayAsDoubleX4# :: MutableByteArray# s -> Int# -> DoubleX4# -> State# s -> State# s
writeDoubleArrayAsDoubleX4# = writeDoubleArrayAsDoubleX4#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeFloatArrayAsFloatX16# :: MutableByteArray# s -> Int# -> FloatX16# -> State# s -> State# s
writeFloatArrayAsFloatX16# = writeFloatArrayAsFloatX16#

{-| Write a vector to specified index of mutable array of scalars; offset is in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeDoubleArrayAsDoubleX8# :: MutableByteArray# s -> Int# -> DoubleX8# -> State# s -> State# s
writeDoubleArrayAsDoubleX8# = writeDoubleArrayAsDoubleX8#

{-| Reads vector; offset in scalar elements. -}
indexInt8OffAddrAsInt8X16# :: Addr# -> Int# -> Int8X16#
indexInt8OffAddrAsInt8X16# = indexInt8OffAddrAsInt8X16#

{-| Reads vector; offset in scalar elements. -}
indexInt16OffAddrAsInt16X8# :: Addr# -> Int# -> Int16X8#
indexInt16OffAddrAsInt16X8# = indexInt16OffAddrAsInt16X8#

{-| Reads vector; offset in scalar elements. -}
indexInt32OffAddrAsInt32X4# :: Addr# -> Int# -> Int32X4#
indexInt32OffAddrAsInt32X4# = indexInt32OffAddrAsInt32X4#

{-| Reads vector; offset in scalar elements. -}
indexInt64OffAddrAsInt64X2# :: Addr# -> Int# -> Int64X2#
indexInt64OffAddrAsInt64X2# = indexInt64OffAddrAsInt64X2#

{-| Reads vector; offset in scalar elements. -}
indexInt8OffAddrAsInt8X32# :: Addr# -> Int# -> Int8X32#
indexInt8OffAddrAsInt8X32# = indexInt8OffAddrAsInt8X32#

{-| Reads vector; offset in scalar elements. -}
indexInt16OffAddrAsInt16X16# :: Addr# -> Int# -> Int16X16#
indexInt16OffAddrAsInt16X16# = indexInt16OffAddrAsInt16X16#

{-| Reads vector; offset in scalar elements. -}
indexInt32OffAddrAsInt32X8# :: Addr# -> Int# -> Int32X8#
indexInt32OffAddrAsInt32X8# = indexInt32OffAddrAsInt32X8#

{-| Reads vector; offset in scalar elements. -}
indexInt64OffAddrAsInt64X4# :: Addr# -> Int# -> Int64X4#
indexInt64OffAddrAsInt64X4# = indexInt64OffAddrAsInt64X4#

{-| Reads vector; offset in scalar elements. -}
indexInt8OffAddrAsInt8X64# :: Addr# -> Int# -> Int8X64#
indexInt8OffAddrAsInt8X64# = indexInt8OffAddrAsInt8X64#

{-| Reads vector; offset in scalar elements. -}
indexInt16OffAddrAsInt16X32# :: Addr# -> Int# -> Int16X32#
indexInt16OffAddrAsInt16X32# = indexInt16OffAddrAsInt16X32#

{-| Reads vector; offset in scalar elements. -}
indexInt32OffAddrAsInt32X16# :: Addr# -> Int# -> Int32X16#
indexInt32OffAddrAsInt32X16# = indexInt32OffAddrAsInt32X16#

{-| Reads vector; offset in scalar elements. -}
indexInt64OffAddrAsInt64X8# :: Addr# -> Int# -> Int64X8#
indexInt64OffAddrAsInt64X8# = indexInt64OffAddrAsInt64X8#

{-| Reads vector; offset in scalar elements. -}
indexWord8OffAddrAsWord8X16# :: Addr# -> Int# -> Word8X16#
indexWord8OffAddrAsWord8X16# = indexWord8OffAddrAsWord8X16#

{-| Reads vector; offset in scalar elements. -}
indexWord16OffAddrAsWord16X8# :: Addr# -> Int# -> Word16X8#
indexWord16OffAddrAsWord16X8# = indexWord16OffAddrAsWord16X8#

{-| Reads vector; offset in scalar elements. -}
indexWord32OffAddrAsWord32X4# :: Addr# -> Int# -> Word32X4#
indexWord32OffAddrAsWord32X4# = indexWord32OffAddrAsWord32X4#

{-| Reads vector; offset in scalar elements. -}
indexWord64OffAddrAsWord64X2# :: Addr# -> Int# -> Word64X2#
indexWord64OffAddrAsWord64X2# = indexWord64OffAddrAsWord64X2#

{-| Reads vector; offset in scalar elements. -}
indexWord8OffAddrAsWord8X32# :: Addr# -> Int# -> Word8X32#
indexWord8OffAddrAsWord8X32# = indexWord8OffAddrAsWord8X32#

{-| Reads vector; offset in scalar elements. -}
indexWord16OffAddrAsWord16X16# :: Addr# -> Int# -> Word16X16#
indexWord16OffAddrAsWord16X16# = indexWord16OffAddrAsWord16X16#

{-| Reads vector; offset in scalar elements. -}
indexWord32OffAddrAsWord32X8# :: Addr# -> Int# -> Word32X8#
indexWord32OffAddrAsWord32X8# = indexWord32OffAddrAsWord32X8#

{-| Reads vector; offset in scalar elements. -}
indexWord64OffAddrAsWord64X4# :: Addr# -> Int# -> Word64X4#
indexWord64OffAddrAsWord64X4# = indexWord64OffAddrAsWord64X4#

{-| Reads vector; offset in scalar elements. -}
indexWord8OffAddrAsWord8X64# :: Addr# -> Int# -> Word8X64#
indexWord8OffAddrAsWord8X64# = indexWord8OffAddrAsWord8X64#

{-| Reads vector; offset in scalar elements. -}
indexWord16OffAddrAsWord16X32# :: Addr# -> Int# -> Word16X32#
indexWord16OffAddrAsWord16X32# = indexWord16OffAddrAsWord16X32#

{-| Reads vector; offset in scalar elements. -}
indexWord32OffAddrAsWord32X16# :: Addr# -> Int# -> Word32X16#
indexWord32OffAddrAsWord32X16# = indexWord32OffAddrAsWord32X16#

{-| Reads vector; offset in scalar elements. -}
indexWord64OffAddrAsWord64X8# :: Addr# -> Int# -> Word64X8#
indexWord64OffAddrAsWord64X8# = indexWord64OffAddrAsWord64X8#

{-| Reads vector; offset in scalar elements. -}
indexFloatOffAddrAsFloatX4# :: Addr# -> Int# -> FloatX4#
indexFloatOffAddrAsFloatX4# = indexFloatOffAddrAsFloatX4#

{-| Reads vector; offset in scalar elements. -}
indexDoubleOffAddrAsDoubleX2# :: Addr# -> Int# -> DoubleX2#
indexDoubleOffAddrAsDoubleX2# = indexDoubleOffAddrAsDoubleX2#

{-| Reads vector; offset in scalar elements. -}
indexFloatOffAddrAsFloatX8# :: Addr# -> Int# -> FloatX8#
indexFloatOffAddrAsFloatX8# = indexFloatOffAddrAsFloatX8#

{-| Reads vector; offset in scalar elements. -}
indexDoubleOffAddrAsDoubleX4# :: Addr# -> Int# -> DoubleX4#
indexDoubleOffAddrAsDoubleX4# = indexDoubleOffAddrAsDoubleX4#

{-| Reads vector; offset in scalar elements. -}
indexFloatOffAddrAsFloatX16# :: Addr# -> Int# -> FloatX16#
indexFloatOffAddrAsFloatX16# = indexFloatOffAddrAsFloatX16#

{-| Reads vector; offset in scalar elements. -}
indexDoubleOffAddrAsDoubleX8# :: Addr# -> Int# -> DoubleX8#
indexDoubleOffAddrAsDoubleX8# = indexDoubleOffAddrAsDoubleX8#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt8OffAddrAsInt8X16# :: Addr# -> Int# -> State# s -> (# State# s,Int8X16# #)
readInt8OffAddrAsInt8X16# = readInt8OffAddrAsInt8X16#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt16OffAddrAsInt16X8# :: Addr# -> Int# -> State# s -> (# State# s,Int16X8# #)
readInt16OffAddrAsInt16X8# = readInt16OffAddrAsInt16X8#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt32OffAddrAsInt32X4# :: Addr# -> Int# -> State# s -> (# State# s,Int32X4# #)
readInt32OffAddrAsInt32X4# = readInt32OffAddrAsInt32X4#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt64OffAddrAsInt64X2# :: Addr# -> Int# -> State# s -> (# State# s,Int64X2# #)
readInt64OffAddrAsInt64X2# = readInt64OffAddrAsInt64X2#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt8OffAddrAsInt8X32# :: Addr# -> Int# -> State# s -> (# State# s,Int8X32# #)
readInt8OffAddrAsInt8X32# = readInt8OffAddrAsInt8X32#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt16OffAddrAsInt16X16# :: Addr# -> Int# -> State# s -> (# State# s,Int16X16# #)
readInt16OffAddrAsInt16X16# = readInt16OffAddrAsInt16X16#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt32OffAddrAsInt32X8# :: Addr# -> Int# -> State# s -> (# State# s,Int32X8# #)
readInt32OffAddrAsInt32X8# = readInt32OffAddrAsInt32X8#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt64OffAddrAsInt64X4# :: Addr# -> Int# -> State# s -> (# State# s,Int64X4# #)
readInt64OffAddrAsInt64X4# = readInt64OffAddrAsInt64X4#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt8OffAddrAsInt8X64# :: Addr# -> Int# -> State# s -> (# State# s,Int8X64# #)
readInt8OffAddrAsInt8X64# = readInt8OffAddrAsInt8X64#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt16OffAddrAsInt16X32# :: Addr# -> Int# -> State# s -> (# State# s,Int16X32# #)
readInt16OffAddrAsInt16X32# = readInt16OffAddrAsInt16X32#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt32OffAddrAsInt32X16# :: Addr# -> Int# -> State# s -> (# State# s,Int32X16# #)
readInt32OffAddrAsInt32X16# = readInt32OffAddrAsInt32X16#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readInt64OffAddrAsInt64X8# :: Addr# -> Int# -> State# s -> (# State# s,Int64X8# #)
readInt64OffAddrAsInt64X8# = readInt64OffAddrAsInt64X8#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8OffAddrAsWord8X16# :: Addr# -> Int# -> State# s -> (# State# s,Word8X16# #)
readWord8OffAddrAsWord8X16# = readWord8OffAddrAsWord8X16#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord16OffAddrAsWord16X8# :: Addr# -> Int# -> State# s -> (# State# s,Word16X8# #)
readWord16OffAddrAsWord16X8# = readWord16OffAddrAsWord16X8#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord32OffAddrAsWord32X4# :: Addr# -> Int# -> State# s -> (# State# s,Word32X4# #)
readWord32OffAddrAsWord32X4# = readWord32OffAddrAsWord32X4#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord64OffAddrAsWord64X2# :: Addr# -> Int# -> State# s -> (# State# s,Word64X2# #)
readWord64OffAddrAsWord64X2# = readWord64OffAddrAsWord64X2#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8OffAddrAsWord8X32# :: Addr# -> Int# -> State# s -> (# State# s,Word8X32# #)
readWord8OffAddrAsWord8X32# = readWord8OffAddrAsWord8X32#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord16OffAddrAsWord16X16# :: Addr# -> Int# -> State# s -> (# State# s,Word16X16# #)
readWord16OffAddrAsWord16X16# = readWord16OffAddrAsWord16X16#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord32OffAddrAsWord32X8# :: Addr# -> Int# -> State# s -> (# State# s,Word32X8# #)
readWord32OffAddrAsWord32X8# = readWord32OffAddrAsWord32X8#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord64OffAddrAsWord64X4# :: Addr# -> Int# -> State# s -> (# State# s,Word64X4# #)
readWord64OffAddrAsWord64X4# = readWord64OffAddrAsWord64X4#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord8OffAddrAsWord8X64# :: Addr# -> Int# -> State# s -> (# State# s,Word8X64# #)
readWord8OffAddrAsWord8X64# = readWord8OffAddrAsWord8X64#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord16OffAddrAsWord16X32# :: Addr# -> Int# -> State# s -> (# State# s,Word16X32# #)
readWord16OffAddrAsWord16X32# = readWord16OffAddrAsWord16X32#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord32OffAddrAsWord32X16# :: Addr# -> Int# -> State# s -> (# State# s,Word32X16# #)
readWord32OffAddrAsWord32X16# = readWord32OffAddrAsWord32X16#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readWord64OffAddrAsWord64X8# :: Addr# -> Int# -> State# s -> (# State# s,Word64X8# #)
readWord64OffAddrAsWord64X8# = readWord64OffAddrAsWord64X8#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readFloatOffAddrAsFloatX4# :: Addr# -> Int# -> State# s -> (# State# s,FloatX4# #)
readFloatOffAddrAsFloatX4# = readFloatOffAddrAsFloatX4#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readDoubleOffAddrAsDoubleX2# :: Addr# -> Int# -> State# s -> (# State# s,DoubleX2# #)
readDoubleOffAddrAsDoubleX2# = readDoubleOffAddrAsDoubleX2#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readFloatOffAddrAsFloatX8# :: Addr# -> Int# -> State# s -> (# State# s,FloatX8# #)
readFloatOffAddrAsFloatX8# = readFloatOffAddrAsFloatX8#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readDoubleOffAddrAsDoubleX4# :: Addr# -> Int# -> State# s -> (# State# s,DoubleX4# #)
readDoubleOffAddrAsDoubleX4# = readDoubleOffAddrAsDoubleX4#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readFloatOffAddrAsFloatX16# :: Addr# -> Int# -> State# s -> (# State# s,FloatX16# #)
readFloatOffAddrAsFloatX16# = readFloatOffAddrAsFloatX16#

{-| Reads vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
readDoubleOffAddrAsDoubleX8# :: Addr# -> Int# -> State# s -> (# State# s,DoubleX8# #)
readDoubleOffAddrAsDoubleX8# = readDoubleOffAddrAsDoubleX8#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt8OffAddrAsInt8X16# :: Addr# -> Int# -> Int8X16# -> State# s -> State# s
writeInt8OffAddrAsInt8X16# = writeInt8OffAddrAsInt8X16#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt16OffAddrAsInt16X8# :: Addr# -> Int# -> Int16X8# -> State# s -> State# s
writeInt16OffAddrAsInt16X8# = writeInt16OffAddrAsInt16X8#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt32OffAddrAsInt32X4# :: Addr# -> Int# -> Int32X4# -> State# s -> State# s
writeInt32OffAddrAsInt32X4# = writeInt32OffAddrAsInt32X4#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt64OffAddrAsInt64X2# :: Addr# -> Int# -> Int64X2# -> State# s -> State# s
writeInt64OffAddrAsInt64X2# = writeInt64OffAddrAsInt64X2#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt8OffAddrAsInt8X32# :: Addr# -> Int# -> Int8X32# -> State# s -> State# s
writeInt8OffAddrAsInt8X32# = writeInt8OffAddrAsInt8X32#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt16OffAddrAsInt16X16# :: Addr# -> Int# -> Int16X16# -> State# s -> State# s
writeInt16OffAddrAsInt16X16# = writeInt16OffAddrAsInt16X16#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt32OffAddrAsInt32X8# :: Addr# -> Int# -> Int32X8# -> State# s -> State# s
writeInt32OffAddrAsInt32X8# = writeInt32OffAddrAsInt32X8#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt64OffAddrAsInt64X4# :: Addr# -> Int# -> Int64X4# -> State# s -> State# s
writeInt64OffAddrAsInt64X4# = writeInt64OffAddrAsInt64X4#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt8OffAddrAsInt8X64# :: Addr# -> Int# -> Int8X64# -> State# s -> State# s
writeInt8OffAddrAsInt8X64# = writeInt8OffAddrAsInt8X64#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt16OffAddrAsInt16X32# :: Addr# -> Int# -> Int16X32# -> State# s -> State# s
writeInt16OffAddrAsInt16X32# = writeInt16OffAddrAsInt16X32#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt32OffAddrAsInt32X16# :: Addr# -> Int# -> Int32X16# -> State# s -> State# s
writeInt32OffAddrAsInt32X16# = writeInt32OffAddrAsInt32X16#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeInt64OffAddrAsInt64X8# :: Addr# -> Int# -> Int64X8# -> State# s -> State# s
writeInt64OffAddrAsInt64X8# = writeInt64OffAddrAsInt64X8#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8OffAddrAsWord8X16# :: Addr# -> Int# -> Word8X16# -> State# s -> State# s
writeWord8OffAddrAsWord8X16# = writeWord8OffAddrAsWord8X16#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord16OffAddrAsWord16X8# :: Addr# -> Int# -> Word16X8# -> State# s -> State# s
writeWord16OffAddrAsWord16X8# = writeWord16OffAddrAsWord16X8#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord32OffAddrAsWord32X4# :: Addr# -> Int# -> Word32X4# -> State# s -> State# s
writeWord32OffAddrAsWord32X4# = writeWord32OffAddrAsWord32X4#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord64OffAddrAsWord64X2# :: Addr# -> Int# -> Word64X2# -> State# s -> State# s
writeWord64OffAddrAsWord64X2# = writeWord64OffAddrAsWord64X2#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8OffAddrAsWord8X32# :: Addr# -> Int# -> Word8X32# -> State# s -> State# s
writeWord8OffAddrAsWord8X32# = writeWord8OffAddrAsWord8X32#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord16OffAddrAsWord16X16# :: Addr# -> Int# -> Word16X16# -> State# s -> State# s
writeWord16OffAddrAsWord16X16# = writeWord16OffAddrAsWord16X16#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord32OffAddrAsWord32X8# :: Addr# -> Int# -> Word32X8# -> State# s -> State# s
writeWord32OffAddrAsWord32X8# = writeWord32OffAddrAsWord32X8#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord64OffAddrAsWord64X4# :: Addr# -> Int# -> Word64X4# -> State# s -> State# s
writeWord64OffAddrAsWord64X4# = writeWord64OffAddrAsWord64X4#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord8OffAddrAsWord8X64# :: Addr# -> Int# -> Word8X64# -> State# s -> State# s
writeWord8OffAddrAsWord8X64# = writeWord8OffAddrAsWord8X64#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord16OffAddrAsWord16X32# :: Addr# -> Int# -> Word16X32# -> State# s -> State# s
writeWord16OffAddrAsWord16X32# = writeWord16OffAddrAsWord16X32#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord32OffAddrAsWord32X16# :: Addr# -> Int# -> Word32X16# -> State# s -> State# s
writeWord32OffAddrAsWord32X16# = writeWord32OffAddrAsWord32X16#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeWord64OffAddrAsWord64X8# :: Addr# -> Int# -> Word64X8# -> State# s -> State# s
writeWord64OffAddrAsWord64X8# = writeWord64OffAddrAsWord64X8#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeFloatOffAddrAsFloatX4# :: Addr# -> Int# -> FloatX4# -> State# s -> State# s
writeFloatOffAddrAsFloatX4# = writeFloatOffAddrAsFloatX4#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeDoubleOffAddrAsDoubleX2# :: Addr# -> Int# -> DoubleX2# -> State# s -> State# s
writeDoubleOffAddrAsDoubleX2# = writeDoubleOffAddrAsDoubleX2#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeFloatOffAddrAsFloatX8# :: Addr# -> Int# -> FloatX8# -> State# s -> State# s
writeFloatOffAddrAsFloatX8# = writeFloatOffAddrAsFloatX8#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeDoubleOffAddrAsDoubleX4# :: Addr# -> Int# -> DoubleX4# -> State# s -> State# s
writeDoubleOffAddrAsDoubleX4# = writeDoubleOffAddrAsDoubleX4#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeFloatOffAddrAsFloatX16# :: Addr# -> Int# -> FloatX16# -> State# s -> State# s
writeFloatOffAddrAsFloatX16# = writeFloatOffAddrAsFloatX16#

{-| Write vector; offset in scalar elements. 

__/Warning:/__ this can fail with an unchecked exception.-}
writeDoubleOffAddrAsDoubleX8# :: Addr# -> Int# -> DoubleX8# -> State# s -> State# s
writeDoubleOffAddrAsDoubleX8# = writeDoubleOffAddrAsDoubleX8#

{-|Fused multiply-add operation @x*y+z@. See "GHC.Prim#fma".-}
fmaddFloatX4# :: FloatX4# -> FloatX4# -> FloatX4# -> FloatX4#
fmaddFloatX4# = fmaddFloatX4#

{-|Fused multiply-add operation @x*y+z@. See "GHC.Prim#fma".-}
fmaddDoubleX2# :: DoubleX2# -> DoubleX2# -> DoubleX2# -> DoubleX2#
fmaddDoubleX2# = fmaddDoubleX2#

{-|Fused multiply-add operation @x*y+z@. See "GHC.Prim#fma".-}
fmaddFloatX8# :: FloatX8# -> FloatX8# -> FloatX8# -> FloatX8#
fmaddFloatX8# = fmaddFloatX8#

{-|Fused multiply-add operation @x*y+z@. See "GHC.Prim#fma".-}
fmaddDoubleX4# :: DoubleX4# -> DoubleX4# -> DoubleX4# -> DoubleX4#
fmaddDoubleX4# = fmaddDoubleX4#

{-|Fused multiply-add operation @x*y+z@. See "GHC.Prim#fma".-}
fmaddFloatX16# :: FloatX16# -> FloatX16# -> FloatX16# -> FloatX16#
fmaddFloatX16# = fmaddFloatX16#

{-|Fused multiply-add operation @x*y+z@. See "GHC.Prim#fma".-}
fmaddDoubleX8# :: DoubleX8# -> DoubleX8# -> DoubleX8# -> DoubleX8#
fmaddDoubleX8# = fmaddDoubleX8#

{-|Fused multiply-subtract operation @x*y-z@. See "GHC.Prim#fma".-}
fmsubFloatX4# :: FloatX4# -> FloatX4# -> FloatX4# -> FloatX4#
fmsubFloatX4# = fmsubFloatX4#

{-|Fused multiply-subtract operation @x*y-z@. See "GHC.Prim#fma".-}
fmsubDoubleX2# :: DoubleX2# -> DoubleX2# -> DoubleX2# -> DoubleX2#
fmsubDoubleX2# = fmsubDoubleX2#

{-|Fused multiply-subtract operation @x*y-z@. See "GHC.Prim#fma".-}
fmsubFloatX8# :: FloatX8# -> FloatX8# -> FloatX8# -> FloatX8#
fmsubFloatX8# = fmsubFloatX8#

{-|Fused multiply-subtract operation @x*y-z@. See "GHC.Prim#fma".-}
fmsubDoubleX4# :: DoubleX4# -> DoubleX4# -> DoubleX4# -> DoubleX4#
fmsubDoubleX4# = fmsubDoubleX4#

{-|Fused multiply-subtract operation @x*y-z@. See "GHC.Prim#fma".-}
fmsubFloatX16# :: FloatX16# -> FloatX16# -> FloatX16# -> FloatX16#
fmsubFloatX16# = fmsubFloatX16#

{-|Fused multiply-subtract operation @x*y-z@. See "GHC.Prim#fma".-}
fmsubDoubleX8# :: DoubleX8# -> DoubleX8# -> DoubleX8# -> DoubleX8#
fmsubDoubleX8# = fmsubDoubleX8#

{-|Fused negate-multiply-add operation @-x*y+z@. See "GHC.Prim#fma".-}
fnmaddFloatX4# :: FloatX4# -> FloatX4# -> FloatX4# -> FloatX4#
fnmaddFloatX4# = fnmaddFloatX4#

{-|Fused negate-multiply-add operation @-x*y+z@. See "GHC.Prim#fma".-}
fnmaddDoubleX2# :: DoubleX2# -> DoubleX2# -> DoubleX2# -> DoubleX2#
fnmaddDoubleX2# = fnmaddDoubleX2#

{-|Fused negate-multiply-add operation @-x*y+z@. See "GHC.Prim#fma".-}
fnmaddFloatX8# :: FloatX8# -> FloatX8# -> FloatX8# -> FloatX8#
fnmaddFloatX8# = fnmaddFloatX8#

{-|Fused negate-multiply-add operation @-x*y+z@. See "GHC.Prim#fma".-}
fnmaddDoubleX4# :: DoubleX4# -> DoubleX4# -> DoubleX4# -> DoubleX4#
fnmaddDoubleX4# = fnmaddDoubleX4#

{-|Fused negate-multiply-add operation @-x*y+z@. See "GHC.Prim#fma".-}
fnmaddFloatX16# :: FloatX16# -> FloatX16# -> FloatX16# -> FloatX16#
fnmaddFloatX16# = fnmaddFloatX16#

{-|Fused negate-multiply-add operation @-x*y+z@. See "GHC.Prim#fma".-}
fnmaddDoubleX8# :: DoubleX8# -> DoubleX8# -> DoubleX8# -> DoubleX8#
fnmaddDoubleX8# = fnmaddDoubleX8#

{-|Fused negate-multiply-subtract operation @-x*y-z@. See "GHC.Prim#fma".-}
fnmsubFloatX4# :: FloatX4# -> FloatX4# -> FloatX4# -> FloatX4#
fnmsubFloatX4# = fnmsubFloatX4#

{-|Fused negate-multiply-subtract operation @-x*y-z@. See "GHC.Prim#fma".-}
fnmsubDoubleX2# :: DoubleX2# -> DoubleX2# -> DoubleX2# -> DoubleX2#
fnmsubDoubleX2# = fnmsubDoubleX2#

{-|Fused negate-multiply-subtract operation @-x*y-z@. See "GHC.Prim#fma".-}
fnmsubFloatX8# :: FloatX8# -> FloatX8# -> FloatX8# -> FloatX8#
fnmsubFloatX8# = fnmsubFloatX8#

{-|Fused negate-multiply-subtract operation @-x*y-z@. See "GHC.Prim#fma".-}
fnmsubDoubleX4# :: DoubleX4# -> DoubleX4# -> DoubleX4# -> DoubleX4#
fnmsubDoubleX4# = fnmsubDoubleX4#

{-|Fused negate-multiply-subtract operation @-x*y-z@. See "GHC.Prim#fma".-}
fnmsubFloatX16# :: FloatX16# -> FloatX16# -> FloatX16# -> FloatX16#
fnmsubFloatX16# = fnmsubFloatX16#

{-|Fused negate-multiply-subtract operation @-x*y-z@. See "GHC.Prim#fma".-}
fnmsubDoubleX8# :: DoubleX8# -> DoubleX8# -> DoubleX8# -> DoubleX8#
fnmsubDoubleX8# = fnmsubDoubleX8#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleInt8X16# :: Int8X16# -> Int8X16# -> (# Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int# #) -> Int8X16#
shuffleInt8X16# = shuffleInt8X16#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleInt16X8# :: Int16X8# -> Int16X8# -> (# Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int# #) -> Int16X8#
shuffleInt16X8# = shuffleInt16X8#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleInt32X4# :: Int32X4# -> Int32X4# -> (# Int#,Int#,Int#,Int# #) -> Int32X4#
shuffleInt32X4# = shuffleInt32X4#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleInt64X2# :: Int64X2# -> Int64X2# -> (# Int#,Int# #) -> Int64X2#
shuffleInt64X2# = shuffleInt64X2#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleInt8X32# :: Int8X32# -> Int8X32# -> (# Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int# #) -> Int8X32#
shuffleInt8X32# = shuffleInt8X32#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleInt16X16# :: Int16X16# -> Int16X16# -> (# Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int# #) -> Int16X16#
shuffleInt16X16# = shuffleInt16X16#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleInt32X8# :: Int32X8# -> Int32X8# -> (# Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int# #) -> Int32X8#
shuffleInt32X8# = shuffleInt32X8#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleInt64X4# :: Int64X4# -> Int64X4# -> (# Int#,Int#,Int#,Int# #) -> Int64X4#
shuffleInt64X4# = shuffleInt64X4#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleInt8X64# :: Int8X64# -> Int8X64# -> (# Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int# #) -> Int8X64#
shuffleInt8X64# = shuffleInt8X64#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleInt16X32# :: Int16X32# -> Int16X32# -> (# Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int# #) -> Int16X32#
shuffleInt16X32# = shuffleInt16X32#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleInt32X16# :: Int32X16# -> Int32X16# -> (# Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int# #) -> Int32X16#
shuffleInt32X16# = shuffleInt32X16#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleInt64X8# :: Int64X8# -> Int64X8# -> (# Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int# #) -> Int64X8#
shuffleInt64X8# = shuffleInt64X8#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleWord8X16# :: Word8X16# -> Word8X16# -> (# Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int# #) -> Word8X16#
shuffleWord8X16# = shuffleWord8X16#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleWord16X8# :: Word16X8# -> Word16X8# -> (# Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int# #) -> Word16X8#
shuffleWord16X8# = shuffleWord16X8#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleWord32X4# :: Word32X4# -> Word32X4# -> (# Int#,Int#,Int#,Int# #) -> Word32X4#
shuffleWord32X4# = shuffleWord32X4#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleWord64X2# :: Word64X2# -> Word64X2# -> (# Int#,Int# #) -> Word64X2#
shuffleWord64X2# = shuffleWord64X2#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleWord8X32# :: Word8X32# -> Word8X32# -> (# Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int# #) -> Word8X32#
shuffleWord8X32# = shuffleWord8X32#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleWord16X16# :: Word16X16# -> Word16X16# -> (# Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int# #) -> Word16X16#
shuffleWord16X16# = shuffleWord16X16#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleWord32X8# :: Word32X8# -> Word32X8# -> (# Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int# #) -> Word32X8#
shuffleWord32X8# = shuffleWord32X8#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleWord64X4# :: Word64X4# -> Word64X4# -> (# Int#,Int#,Int#,Int# #) -> Word64X4#
shuffleWord64X4# = shuffleWord64X4#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleWord8X64# :: Word8X64# -> Word8X64# -> (# Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int# #) -> Word8X64#
shuffleWord8X64# = shuffleWord8X64#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleWord16X32# :: Word16X32# -> Word16X32# -> (# Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int# #) -> Word16X32#
shuffleWord16X32# = shuffleWord16X32#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleWord32X16# :: Word32X16# -> Word32X16# -> (# Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int# #) -> Word32X16#
shuffleWord32X16# = shuffleWord32X16#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleWord64X8# :: Word64X8# -> Word64X8# -> (# Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int# #) -> Word64X8#
shuffleWord64X8# = shuffleWord64X8#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleFloatX4# :: FloatX4# -> FloatX4# -> (# Int#,Int#,Int#,Int# #) -> FloatX4#
shuffleFloatX4# = shuffleFloatX4#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleDoubleX2# :: DoubleX2# -> DoubleX2# -> (# Int#,Int# #) -> DoubleX2#
shuffleDoubleX2# = shuffleDoubleX2#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleFloatX8# :: FloatX8# -> FloatX8# -> (# Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int# #) -> FloatX8#
shuffleFloatX8# = shuffleFloatX8#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleDoubleX4# :: DoubleX4# -> DoubleX4# -> (# Int#,Int#,Int#,Int# #) -> DoubleX4#
shuffleDoubleX4# = shuffleDoubleX4#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleFloatX16# :: FloatX16# -> FloatX16# -> (# Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int# #) -> FloatX16#
shuffleFloatX16# = shuffleFloatX16#

{-|Shuffle elements of the concatenation of the input two vectors
  into the result vector. The indices must be compile-time constants.-}
shuffleDoubleX8# :: DoubleX8# -> DoubleX8# -> (# Int#,Int#,Int#,Int#,Int#,Int#,Int#,Int# #) -> DoubleX8#
shuffleDoubleX8# = shuffleDoubleX8#

{-|Component-wise minimum of two vectors.-}
minInt8X16# :: Int8X16# -> Int8X16# -> Int8X16#
minInt8X16# = minInt8X16#

{-|Component-wise minimum of two vectors.-}
minInt16X8# :: Int16X8# -> Int16X8# -> Int16X8#
minInt16X8# = minInt16X8#

{-|Component-wise minimum of two vectors.-}
minInt32X4# :: Int32X4# -> Int32X4# -> Int32X4#
minInt32X4# = minInt32X4#

{-|Component-wise minimum of two vectors.-}
minInt64X2# :: Int64X2# -> Int64X2# -> Int64X2#
minInt64X2# = minInt64X2#

{-|Component-wise minimum of two vectors.-}
minInt8X32# :: Int8X32# -> Int8X32# -> Int8X32#
minInt8X32# = minInt8X32#

{-|Component-wise minimum of two vectors.-}
minInt16X16# :: Int16X16# -> Int16X16# -> Int16X16#
minInt16X16# = minInt16X16#

{-|Component-wise minimum of two vectors.-}
minInt32X8# :: Int32X8# -> Int32X8# -> Int32X8#
minInt32X8# = minInt32X8#

{-|Component-wise minimum of two vectors.-}
minInt64X4# :: Int64X4# -> Int64X4# -> Int64X4#
minInt64X4# = minInt64X4#

{-|Component-wise minimum of two vectors.-}
minInt8X64# :: Int8X64# -> Int8X64# -> Int8X64#
minInt8X64# = minInt8X64#

{-|Component-wise minimum of two vectors.-}
minInt16X32# :: Int16X32# -> Int16X32# -> Int16X32#
minInt16X32# = minInt16X32#

{-|Component-wise minimum of two vectors.-}
minInt32X16# :: Int32X16# -> Int32X16# -> Int32X16#
minInt32X16# = minInt32X16#

{-|Component-wise minimum of two vectors.-}
minInt64X8# :: Int64X8# -> Int64X8# -> Int64X8#
minInt64X8# = minInt64X8#

{-|Component-wise minimum of two vectors.-}
minWord8X16# :: Word8X16# -> Word8X16# -> Word8X16#
minWord8X16# = minWord8X16#

{-|Component-wise minimum of two vectors.-}
minWord16X8# :: Word16X8# -> Word16X8# -> Word16X8#
minWord16X8# = minWord16X8#

{-|Component-wise minimum of two vectors.-}
minWord32X4# :: Word32X4# -> Word32X4# -> Word32X4#
minWord32X4# = minWord32X4#

{-|Component-wise minimum of two vectors.-}
minWord64X2# :: Word64X2# -> Word64X2# -> Word64X2#
minWord64X2# = minWord64X2#

{-|Component-wise minimum of two vectors.-}
minWord8X32# :: Word8X32# -> Word8X32# -> Word8X32#
minWord8X32# = minWord8X32#

{-|Component-wise minimum of two vectors.-}
minWord16X16# :: Word16X16# -> Word16X16# -> Word16X16#
minWord16X16# = minWord16X16#

{-|Component-wise minimum of two vectors.-}
minWord32X8# :: Word32X8# -> Word32X8# -> Word32X8#
minWord32X8# = minWord32X8#

{-|Component-wise minimum of two vectors.-}
minWord64X4# :: Word64X4# -> Word64X4# -> Word64X4#
minWord64X4# = minWord64X4#

{-|Component-wise minimum of two vectors.-}
minWord8X64# :: Word8X64# -> Word8X64# -> Word8X64#
minWord8X64# = minWord8X64#

{-|Component-wise minimum of two vectors.-}
minWord16X32# :: Word16X32# -> Word16X32# -> Word16X32#
minWord16X32# = minWord16X32#

{-|Component-wise minimum of two vectors.-}
minWord32X16# :: Word32X16# -> Word32X16# -> Word32X16#
minWord32X16# = minWord32X16#

{-|Component-wise minimum of two vectors.-}
minWord64X8# :: Word64X8# -> Word64X8# -> Word64X8#
minWord64X8# = minWord64X8#

{-|Component-wise minimum of two vectors.-}
minFloatX4# :: FloatX4# -> FloatX4# -> FloatX4#
minFloatX4# = minFloatX4#

{-|Component-wise minimum of two vectors.-}
minDoubleX2# :: DoubleX2# -> DoubleX2# -> DoubleX2#
minDoubleX2# = minDoubleX2#

{-|Component-wise minimum of two vectors.-}
minFloatX8# :: FloatX8# -> FloatX8# -> FloatX8#
minFloatX8# = minFloatX8#

{-|Component-wise minimum of two vectors.-}
minDoubleX4# :: DoubleX4# -> DoubleX4# -> DoubleX4#
minDoubleX4# = minDoubleX4#

{-|Component-wise minimum of two vectors.-}
minFloatX16# :: FloatX16# -> FloatX16# -> FloatX16#
minFloatX16# = minFloatX16#

{-|Component-wise minimum of two vectors.-}
minDoubleX8# :: DoubleX8# -> DoubleX8# -> DoubleX8#
minDoubleX8# = minDoubleX8#

{-|Component-wise maximum of two vectors.-}
maxInt8X16# :: Int8X16# -> Int8X16# -> Int8X16#
maxInt8X16# = maxInt8X16#

{-|Component-wise maximum of two vectors.-}
maxInt16X8# :: Int16X8# -> Int16X8# -> Int16X8#
maxInt16X8# = maxInt16X8#

{-|Component-wise maximum of two vectors.-}
maxInt32X4# :: Int32X4# -> Int32X4# -> Int32X4#
maxInt32X4# = maxInt32X4#

{-|Component-wise maximum of two vectors.-}
maxInt64X2# :: Int64X2# -> Int64X2# -> Int64X2#
maxInt64X2# = maxInt64X2#

{-|Component-wise maximum of two vectors.-}
maxInt8X32# :: Int8X32# -> Int8X32# -> Int8X32#
maxInt8X32# = maxInt8X32#

{-|Component-wise maximum of two vectors.-}
maxInt16X16# :: Int16X16# -> Int16X16# -> Int16X16#
maxInt16X16# = maxInt16X16#

{-|Component-wise maximum of two vectors.-}
maxInt32X8# :: Int32X8# -> Int32X8# -> Int32X8#
maxInt32X8# = maxInt32X8#

{-|Component-wise maximum of two vectors.-}
maxInt64X4# :: Int64X4# -> Int64X4# -> Int64X4#
maxInt64X4# = maxInt64X4#

{-|Component-wise maximum of two vectors.-}
maxInt8X64# :: Int8X64# -> Int8X64# -> Int8X64#
maxInt8X64# = maxInt8X64#

{-|Component-wise maximum of two vectors.-}
maxInt16X32# :: Int16X32# -> Int16X32# -> Int16X32#
maxInt16X32# = maxInt16X32#

{-|Component-wise maximum of two vectors.-}
maxInt32X16# :: Int32X16# -> Int32X16# -> Int32X16#
maxInt32X16# = maxInt32X16#

{-|Component-wise maximum of two vectors.-}
maxInt64X8# :: Int64X8# -> Int64X8# -> Int64X8#
maxInt64X8# = maxInt64X8#

{-|Component-wise maximum of two vectors.-}
maxWord8X16# :: Word8X16# -> Word8X16# -> Word8X16#
maxWord8X16# = maxWord8X16#

{-|Component-wise maximum of two vectors.-}
maxWord16X8# :: Word16X8# -> Word16X8# -> Word16X8#
maxWord16X8# = maxWord16X8#

{-|Component-wise maximum of two vectors.-}
maxWord32X4# :: Word32X4# -> Word32X4# -> Word32X4#
maxWord32X4# = maxWord32X4#

{-|Component-wise maximum of two vectors.-}
maxWord64X2# :: Word64X2# -> Word64X2# -> Word64X2#
maxWord64X2# = maxWord64X2#

{-|Component-wise maximum of two vectors.-}
maxWord8X32# :: Word8X32# -> Word8X32# -> Word8X32#
maxWord8X32# = maxWord8X32#

{-|Component-wise maximum of two vectors.-}
maxWord16X16# :: Word16X16# -> Word16X16# -> Word16X16#
maxWord16X16# = maxWord16X16#

{-|Component-wise maximum of two vectors.-}
maxWord32X8# :: Word32X8# -> Word32X8# -> Word32X8#
maxWord32X8# = maxWord32X8#

{-|Component-wise maximum of two vectors.-}
maxWord64X4# :: Word64X4# -> Word64X4# -> Word64X4#
maxWord64X4# = maxWord64X4#

{-|Component-wise maximum of two vectors.-}
maxWord8X64# :: Word8X64# -> Word8X64# -> Word8X64#
maxWord8X64# = maxWord8X64#

{-|Component-wise maximum of two vectors.-}
maxWord16X32# :: Word16X32# -> Word16X32# -> Word16X32#
maxWord16X32# = maxWord16X32#

{-|Component-wise maximum of two vectors.-}
maxWord32X16# :: Word32X16# -> Word32X16# -> Word32X16#
maxWord32X16# = maxWord32X16#

{-|Component-wise maximum of two vectors.-}
maxWord64X8# :: Word64X8# -> Word64X8# -> Word64X8#
maxWord64X8# = maxWord64X8#

{-|Component-wise maximum of two vectors.-}
maxFloatX4# :: FloatX4# -> FloatX4# -> FloatX4#
maxFloatX4# = maxFloatX4#

{-|Component-wise maximum of two vectors.-}
maxDoubleX2# :: DoubleX2# -> DoubleX2# -> DoubleX2#
maxDoubleX2# = maxDoubleX2#

{-|Component-wise maximum of two vectors.-}
maxFloatX8# :: FloatX8# -> FloatX8# -> FloatX8#
maxFloatX8# = maxFloatX8#

{-|Component-wise maximum of two vectors.-}
maxDoubleX4# :: DoubleX4# -> DoubleX4# -> DoubleX4#
maxDoubleX4# = maxDoubleX4#

{-|Component-wise maximum of two vectors.-}
maxFloatX16# :: FloatX16# -> FloatX16# -> FloatX16#
maxFloatX16# = maxFloatX16#

{-|Component-wise maximum of two vectors.-}
maxDoubleX8# :: DoubleX8# -> DoubleX8# -> DoubleX8#
maxDoubleX8# = maxDoubleX8#

prefetchByteArray3# :: ByteArray# -> Int# -> State# s -> State# s
prefetchByteArray3# = prefetchByteArray3#

prefetchMutableByteArray3# :: MutableByteArray# s -> Int# -> State# s -> State# s
prefetchMutableByteArray3# = prefetchMutableByteArray3#

prefetchAddr3# :: Addr# -> Int# -> State# s -> State# s
prefetchAddr3# = prefetchAddr3#

prefetchValue3# :: a -> State# s -> State# s
prefetchValue3# = prefetchValue3#

prefetchByteArray2# :: ByteArray# -> Int# -> State# s -> State# s
prefetchByteArray2# = prefetchByteArray2#

prefetchMutableByteArray2# :: MutableByteArray# s -> Int# -> State# s -> State# s
prefetchMutableByteArray2# = prefetchMutableByteArray2#

prefetchAddr2# :: Addr# -> Int# -> State# s -> State# s
prefetchAddr2# = prefetchAddr2#

prefetchValue2# :: a -> State# s -> State# s
prefetchValue2# = prefetchValue2#

prefetchByteArray1# :: ByteArray# -> Int# -> State# s -> State# s
prefetchByteArray1# = prefetchByteArray1#

prefetchMutableByteArray1# :: MutableByteArray# s -> Int# -> State# s -> State# s
prefetchMutableByteArray1# = prefetchMutableByteArray1#

prefetchAddr1# :: Addr# -> Int# -> State# s -> State# s
prefetchAddr1# = prefetchAddr1#

prefetchValue1# :: a -> State# s -> State# s
prefetchValue1# = prefetchValue1#

prefetchByteArray0# :: ByteArray# -> Int# -> State# s -> State# s
prefetchByteArray0# = prefetchByteArray0#

prefetchMutableByteArray0# :: MutableByteArray# s -> Int# -> State# s -> State# s
prefetchMutableByteArray0# = prefetchMutableByteArray0#

prefetchAddr0# :: Addr# -> Int# -> State# s -> State# s
prefetchAddr0# = prefetchAddr0#

prefetchValue0# :: a -> State# s -> State# s
prefetchValue0# = prefetchValue0#



