

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (inaki@blueleaf.cc)
-}

#define ENABLE_OVERLOADING (MIN_VERSION_haskell_gi_overloading(1,0,0) \
       && !defined(__HADDOCK_VERSION__))

module GI.JavaScriptCore.Enums
    ( 

 -- * Enumerations
-- ** CheckSyntaxMode #enum:CheckSyntaxMode#

    CheckSyntaxMode(..)                     ,


-- ** CheckSyntaxResult #enum:CheckSyntaxResult#

    CheckSyntaxResult(..)                   ,


-- ** OptionType #enum:OptionType#

    OptionType(..)                          ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL


-- Enum OptionType
{- |
Enum values for options types.

/Since: 2.24/
-}
data OptionType = 
      OptionTypeBoolean
    {- ^
    A 'Bool' option type.
    -}
    | OptionTypeInt
    {- ^
    A @/gint/@ option type.
    -}
    | OptionTypeUint
    {- ^
    A @/guint/@ option type.
    -}
    | OptionTypeSize
    {- ^
    A @/gsize/@ options type.
    -}
    | OptionTypeDouble
    {- ^
    A @/gdouble/@ options type.
    -}
    | OptionTypeString
    {- ^
    A string option type.
    -}
    | OptionTypeRangeString
    {- ^
    A range string option type.
    -}
    | AnotherOptionType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum OptionType where
    fromEnum OptionTypeBoolean = 0
    fromEnum OptionTypeInt = 1
    fromEnum OptionTypeUint = 2
    fromEnum OptionTypeSize = 3
    fromEnum OptionTypeDouble = 4
    fromEnum OptionTypeString = 5
    fromEnum OptionTypeRangeString = 6
    fromEnum (AnotherOptionType k) = k

    toEnum 0 = OptionTypeBoolean
    toEnum 1 = OptionTypeInt
    toEnum 2 = OptionTypeUint
    toEnum 3 = OptionTypeSize
    toEnum 4 = OptionTypeDouble
    toEnum 5 = OptionTypeString
    toEnum 6 = OptionTypeRangeString
    toEnum k = AnotherOptionType k

instance P.Ord OptionType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

-- Enum CheckSyntaxResult
{- |
Enum values to specify the result of 'GI.JavaScriptCore.Objects.Context.contextCheckSyntax'.
-}
data CheckSyntaxResult = 
      CheckSyntaxResultSuccess
    {- ^
    no errors
    -}
    | CheckSyntaxResultRecoverableError
    {- ^
    recoverable syntax error
    -}
    | CheckSyntaxResultIrrecoverableError
    {- ^
    irrecoverable syntax error
    -}
    | CheckSyntaxResultUnterminatedLiteralError
    {- ^
    unterminated literal error
    -}
    | CheckSyntaxResultOutOfMemoryError
    {- ^
    out of memory error
    -}
    | CheckSyntaxResultStackOverflowError
    {- ^
    stack overflow error
    -}
    | AnotherCheckSyntaxResult Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum CheckSyntaxResult where
    fromEnum CheckSyntaxResultSuccess = 0
    fromEnum CheckSyntaxResultRecoverableError = 1
    fromEnum CheckSyntaxResultIrrecoverableError = 2
    fromEnum CheckSyntaxResultUnterminatedLiteralError = 3
    fromEnum CheckSyntaxResultOutOfMemoryError = 4
    fromEnum CheckSyntaxResultStackOverflowError = 5
    fromEnum (AnotherCheckSyntaxResult k) = k

    toEnum 0 = CheckSyntaxResultSuccess
    toEnum 1 = CheckSyntaxResultRecoverableError
    toEnum 2 = CheckSyntaxResultIrrecoverableError
    toEnum 3 = CheckSyntaxResultUnterminatedLiteralError
    toEnum 4 = CheckSyntaxResultOutOfMemoryError
    toEnum 5 = CheckSyntaxResultStackOverflowError
    toEnum k = AnotherCheckSyntaxResult k

instance P.Ord CheckSyntaxResult where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

-- Enum CheckSyntaxMode
{- |
Enum values to specify a mode to check for syntax errors in 'GI.JavaScriptCore.Objects.Context.contextCheckSyntax'.
-}
data CheckSyntaxMode = 
      CheckSyntaxModeScript
    {- ^
    mode to check syntax of a script
    -}
    | CheckSyntaxModeModule
    {- ^
    mode to check syntax of a module
    -}
    | AnotherCheckSyntaxMode Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum CheckSyntaxMode where
    fromEnum CheckSyntaxModeScript = 0
    fromEnum CheckSyntaxModeModule = 1
    fromEnum (AnotherCheckSyntaxMode k) = k

    toEnum 0 = CheckSyntaxModeScript
    toEnum 1 = CheckSyntaxModeModule
    toEnum k = AnotherCheckSyntaxMode k

instance P.Ord CheckSyntaxMode where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)


