

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (inaki@blueleaf.cc)
-}

#define ENABLE_OVERLOADING (MIN_VERSION_haskell_gi_overloading(1,0,0) \
       && !defined(__HADDOCK_VERSION__))

module GI.JavaScriptCore.Flags
    ( 

 -- * Flags
-- ** ValuePropertyFlags #flag:ValuePropertyFlags#

    ValuePropertyFlags(..)                  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL


-- Flags ValuePropertyFlags
{- |
Flags used when defining properties with 'GI.JavaScriptCore.Objects.Value.valueObjectDefinePropertyData' and
'GI.JavaScriptCore.Objects.Value.valueObjectDefinePropertyAccessor'.
-}
data ValuePropertyFlags = 
      ValuePropertyFlagsConfigurable
    {- ^
    the type of the property descriptor may be changed and the
     property may be deleted from the corresponding object.
    -}
    | ValuePropertyFlagsEnumerable
    {- ^
    the property shows up during enumeration of the properties on
     the corresponding object.
    -}
    | ValuePropertyFlagsWritable
    {- ^
    the value associated with the property may be changed with an
     assignment operator. This doesn\'t have any effect when passed to 'GI.JavaScriptCore.Objects.Value.valueObjectDefinePropertyAccessor'.
    -}
    | AnotherValuePropertyFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ValuePropertyFlags where
    fromEnum ValuePropertyFlagsConfigurable = 1
    fromEnum ValuePropertyFlagsEnumerable = 2
    fromEnum ValuePropertyFlagsWritable = 4
    fromEnum (AnotherValuePropertyFlags k) = k

    toEnum 1 = ValuePropertyFlagsConfigurable
    toEnum 2 = ValuePropertyFlagsEnumerable
    toEnum 4 = ValuePropertyFlagsWritable
    toEnum k = AnotherValuePropertyFlags k

instance P.Ord ValuePropertyFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance IsGFlag ValuePropertyFlags


