

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (inaki@blueleaf.cc)

/No description available in the introspection data./
-}

#define ENABLE_OVERLOADING (MIN_VERSION_haskell_gi_overloading(1,0,0) \
       && !defined(__HADDOCK_VERSION__))

module GI.JavaScriptCore.Objects.Class
    ( 

-- * Exported types
    Class(..)                               ,
    IsClass                                 ,
    toClass                                 ,
    noClass                                 ,


 -- * Methods
-- ** addConstructor #method:addConstructor#

#if ENABLE_OVERLOADING
    ClassAddConstructorMethodInfo           ,
#endif
    classAddConstructor                     ,


-- ** addConstructorVariadic #method:addConstructorVariadic#

#if ENABLE_OVERLOADING
    ClassAddConstructorVariadicMethodInfo   ,
#endif
    classAddConstructorVariadic             ,


-- ** addMethod #method:addMethod#

#if ENABLE_OVERLOADING
    ClassAddMethodMethodInfo                ,
#endif
    classAddMethod                          ,


-- ** addMethodVariadic #method:addMethodVariadic#

#if ENABLE_OVERLOADING
    ClassAddMethodVariadicMethodInfo        ,
#endif
    classAddMethodVariadic                  ,


-- ** addProperty #method:addProperty#

#if ENABLE_OVERLOADING
    ClassAddPropertyMethodInfo              ,
#endif
    classAddProperty                        ,


-- ** getName #method:getName#

#if ENABLE_OVERLOADING
    ClassGetNameMethodInfo                  ,
#endif
    classGetName                            ,


-- ** getParent #method:getParent#

#if ENABLE_OVERLOADING
    ClassGetParentMethodInfo                ,
#endif
    classGetParent                          ,




 -- * Properties
-- ** context #attr:context#
{- | The 'GI.JavaScriptCore.Objects.Context.Context' in which the class was registered.
-}
#if ENABLE_OVERLOADING
    ClassContextPropertyInfo                ,
#endif
#if ENABLE_OVERLOADING
    classContext                            ,
#endif
    constructClassContext                   ,
    getClassContext                         ,


-- ** name #attr:name#
{- | The name of the class.
-}
#if ENABLE_OVERLOADING
    ClassNamePropertyInfo                   ,
#endif
#if ENABLE_OVERLOADING
    className                               ,
#endif
    constructClassName                      ,
    getClassName                            ,


-- ** parent #attr:parent#
{- | The parent class or 'Nothing' in case of final classes.
-}
#if ENABLE_OVERLOADING
    ClassParentPropertyInfo                 ,
#endif
#if ENABLE_OVERLOADING
    classParent                             ,
#endif
    constructClassParent                    ,
    getClassParent                          ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL

import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.JavaScriptCore.Objects.Context as JavaScriptCore.Context
import {-# SOURCE #-} qualified GI.JavaScriptCore.Objects.Value as JavaScriptCore.Value

-- | Memory-managed wrapper type.
newtype Class = Class (ManagedPtr Class)
foreign import ccall "jsc_class_get_type"
    c_jsc_class_get_type :: IO GType

instance GObject Class where
    gobjectType = c_jsc_class_get_type
    

-- | Type class for types which can be safely cast to `Class`, for instance with `toClass`.
class (GObject o, O.IsDescendantOf Class o) => IsClass o
instance (GObject o, O.IsDescendantOf Class o) => IsClass o

instance O.HasParentTypes Class
type instance O.ParentTypes Class = '[GObject.Object.Object]

-- | Cast to `Class`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toClass :: (MonadIO m, IsClass o) => o -> m Class
toClass = liftIO . unsafeCastTo Class

-- | A convenience alias for `Nothing` :: `Maybe` `Class`.
noClass :: Maybe Class
noClass = Nothing

#if ENABLE_OVERLOADING
type family ResolveClassMethod (t :: Symbol) (o :: *) :: * where
    ResolveClassMethod "addConstructor" o = ClassAddConstructorMethodInfo
    ResolveClassMethod "addConstructorVariadic" o = ClassAddConstructorVariadicMethodInfo
    ResolveClassMethod "addMethod" o = ClassAddMethodMethodInfo
    ResolveClassMethod "addMethodVariadic" o = ClassAddMethodVariadicMethodInfo
    ResolveClassMethod "addProperty" o = ClassAddPropertyMethodInfo
    ResolveClassMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveClassMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveClassMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveClassMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveClassMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveClassMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveClassMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveClassMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveClassMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveClassMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveClassMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveClassMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveClassMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveClassMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveClassMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveClassMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveClassMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveClassMethod "getName" o = ClassGetNameMethodInfo
    ResolveClassMethod "getParent" o = ClassGetParentMethodInfo
    ResolveClassMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveClassMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveClassMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveClassMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveClassMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveClassMethod t Class, O.MethodInfo info Class p) => OL.IsLabel t (Class -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod (O.MethodProxy :: O.MethodProxy info)
#else
    fromLabel _ = O.overloadedMethod (O.MethodProxy :: O.MethodProxy info)
#endif

#endif

-- VVV Prop "context"
   -- Type: TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

{- |
Get the value of the “@context@” property.
When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to

@
'Data.GI.Base.Attributes.get' class #context
@
-}
getClassContext :: (MonadIO m, IsClass o) => o -> m (Maybe JavaScriptCore.Context.Context)
getClassContext obj = liftIO $ B.Properties.getObjectPropertyObject obj "context" JavaScriptCore.Context.Context

{- |
Construct a `GValueConstruct` with valid value for the “@context@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
-}
constructClassContext :: (IsClass o, JavaScriptCore.Context.IsContext a) => a -> IO (GValueConstruct o)
constructClassContext val = B.Properties.constructObjectPropertyObject "context" (Just val)

#if ENABLE_OVERLOADING
data ClassContextPropertyInfo
instance AttrInfo ClassContextPropertyInfo where
    type AttrAllowedOps ClassContextPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ClassContextPropertyInfo = JavaScriptCore.Context.IsContext
    type AttrBaseTypeConstraint ClassContextPropertyInfo = IsClass
    type AttrGetType ClassContextPropertyInfo = (Maybe JavaScriptCore.Context.Context)
    type AttrLabel ClassContextPropertyInfo = "context"
    type AttrOrigin ClassContextPropertyInfo = Class
    attrGet _ = getClassContext
    attrSet _ = undefined
    attrConstruct _ = constructClassContext
    attrClear _ = undefined
#endif

-- VVV Prop "name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

{- |
Get the value of the “@name@” property.
When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to

@
'Data.GI.Base.Attributes.get' class #name
@
-}
getClassName :: (MonadIO m, IsClass o) => o -> m T.Text
getClassName obj = liftIO $ checkUnexpectedNothing "getClassName" $ B.Properties.getObjectPropertyString obj "name"

{- |
Construct a `GValueConstruct` with valid value for the “@name@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
-}
constructClassName :: (IsClass o) => T.Text -> IO (GValueConstruct o)
constructClassName val = B.Properties.constructObjectPropertyString "name" (Just val)

#if ENABLE_OVERLOADING
data ClassNamePropertyInfo
instance AttrInfo ClassNamePropertyInfo where
    type AttrAllowedOps ClassNamePropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ClassNamePropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint ClassNamePropertyInfo = IsClass
    type AttrGetType ClassNamePropertyInfo = T.Text
    type AttrLabel ClassNamePropertyInfo = "name"
    type AttrOrigin ClassNamePropertyInfo = Class
    attrGet _ = getClassName
    attrSet _ = undefined
    attrConstruct _ = constructClassName
    attrClear _ = undefined
#endif

-- VVV Prop "parent"
   -- Type: TInterface (Name {namespace = "JavaScriptCore", name = "Class"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

{- |
Get the value of the “@parent@” property.
When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to

@
'Data.GI.Base.Attributes.get' class #parent
@
-}
getClassParent :: (MonadIO m, IsClass o) => o -> m Class
getClassParent obj = liftIO $ checkUnexpectedNothing "getClassParent" $ B.Properties.getObjectPropertyObject obj "parent" Class

{- |
Construct a `GValueConstruct` with valid value for the “@parent@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
-}
constructClassParent :: (IsClass o, IsClass a) => a -> IO (GValueConstruct o)
constructClassParent val = B.Properties.constructObjectPropertyObject "parent" (Just val)

#if ENABLE_OVERLOADING
data ClassParentPropertyInfo
instance AttrInfo ClassParentPropertyInfo where
    type AttrAllowedOps ClassParentPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ClassParentPropertyInfo = IsClass
    type AttrBaseTypeConstraint ClassParentPropertyInfo = IsClass
    type AttrGetType ClassParentPropertyInfo = Class
    type AttrLabel ClassParentPropertyInfo = "parent"
    type AttrOrigin ClassParentPropertyInfo = Class
    attrGet _ = getClassParent
    attrSet _ = undefined
    attrConstruct _ = constructClassParent
    attrClear _ = undefined
#endif

#if ENABLE_OVERLOADING
instance O.HasAttributeList Class
type instance O.AttributeList Class = ClassAttributeList
type ClassAttributeList = ('[ '("context", ClassContextPropertyInfo), '("name", ClassNamePropertyInfo), '("parent", ClassParentPropertyInfo)] :: [(Symbol, *)])
#endif

#if ENABLE_OVERLOADING
classContext :: AttrLabelProxy "context"
classContext = AttrLabelProxy

className :: AttrLabelProxy "name"
className = AttrLabelProxy

classParent :: AttrLabelProxy "parent"
classParent = AttrLabelProxy

#endif

#if ENABLE_OVERLOADING
type instance O.SignalList Class = ClassSignalList
type ClassSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, *)])

#endif

-- method Class::add_constructor_variadic
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "jsc_class", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Class"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCClass", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "name", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "the constructor name or %NULL", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "callback", argType = TInterface (Name {namespace = "GObject", name = "Callback"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #GCallback to be called to create an instance of @jsc_class", sinceVersion = Nothing}, argScope = ScopeTypeNotified, argClosure = 3, argDestroy = 4, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "user_data", argType = TBasicType TPtr, direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "user data to pass to @callback", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "destroy_notify", argType = TInterface (Name {namespace = "GLib", name = "DestroyNotify"}), direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "destroy notifier for @user_data", sinceVersion = Nothing}, argScope = ScopeTypeAsync, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "return_type", argType = TBasicType TGType, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the #GType of the constructor return value", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_class_add_constructor_variadic" jsc_class_add_constructor_variadic :: 
    Ptr Class ->                            -- jsc_class : TInterface (Name {namespace = "JavaScriptCore", name = "Class"})
    CString ->                              -- name : TBasicType TUTF8
    FunPtr GObject.Callbacks.C_Callback ->  -- callback : TInterface (Name {namespace = "GObject", name = "Callback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy_notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    CGType ->                               -- return_type : TBasicType TGType
    IO (Ptr JavaScriptCore.Value.Value)

{- |
Add a constructor to /@jscClass@/. If /@name@/ is 'Nothing', the class name will be used. When \<function>new\<\/function>
is used with the constructor or @/jsc_value_constructor_call()/@ is called, /@callback@/ is invoked receiving
a 'GI.GLib.Structs.PtrArray.PtrArray' of 'GI.JavaScriptCore.Objects.Value.Value'\<!-- -->s as arguments and /@userData@/ as the last parameter. When the constructor object
is cleared in the 'GI.JavaScriptCore.Objects.Class.Class' context, /@destroyNotify@/ is called with /@userData@/ as parameter.

This function creates the constructor, which needs to be added to an object as a property to be able to use it. Use
'GI.JavaScriptCore.Objects.Context.contextSetValue' to make the constructor available in the global object.

Note that the value returned by /@callback@/ is adopted by /@jscClass@/, and the 'GI.GLib.Callbacks.DestroyNotify' passed to
'GI.JavaScriptCore.Objects.Context.contextRegisterClass' is responsible for disposing of it.
-}
classAddConstructorVariadic ::
    (B.CallStack.HasCallStack, MonadIO m, IsClass a) =>
    a
    {- ^ /@jscClass@/: a 'GI.JavaScriptCore.Objects.Class.Class' -}
    -> Maybe (T.Text)
    {- ^ /@name@/: the constructor name or 'Nothing' -}
    -> GObject.Callbacks.Callback
    {- ^ /@callback@/: a 'GI.GObject.Callbacks.Callback' to be called to create an instance of /@jscClass@/ -}
    -> GType
    {- ^ /@returnType@/: the 'GType' of the constructor return value -}
    -> m JavaScriptCore.Value.Value
    {- ^ __Returns:__ a 'GI.JavaScriptCore.Objects.Value.Value' representing the class constructor. -}
classAddConstructorVariadic jscClass name callback returnType = liftIO $ do
    jscClass' <- unsafeManagedPtrCastPtr jscClass
    maybeName <- case name of
        Nothing -> return nullPtr
        Just jName -> do
            jName' <- textToCString jName
            return jName'
    callback' <- GObject.Callbacks.mk_Callback (GObject.Callbacks.wrap_Callback Nothing callback)
    let returnType' = gtypeToCGType returnType
    let userData = castFunPtrToPtr callback'
    let destroyNotify = safeFreeFunPtrPtr
    result <- jsc_class_add_constructor_variadic jscClass' maybeName callback' userData destroyNotify returnType'
    checkUnexpectedReturnNULL "classAddConstructorVariadic" result
    result' <- (wrapObject JavaScriptCore.Value.Value) result
    touchManagedPtr jscClass
    freeMem maybeName
    return result'

#if ENABLE_OVERLOADING
data ClassAddConstructorVariadicMethodInfo
instance (signature ~ (Maybe (T.Text) -> GObject.Callbacks.Callback -> GType -> m JavaScriptCore.Value.Value), MonadIO m, IsClass a) => O.MethodInfo ClassAddConstructorVariadicMethodInfo a signature where
    overloadedMethod _ = classAddConstructorVariadic

#endif

-- method Class::add_constructor
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "jsc_class", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Class"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCClass", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "name", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "the constructor name or %NULL", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "callback", argType = TInterface (Name {namespace = "GObject", name = "Callback"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #GCallback to be called to create an instance of @jsc_class", sinceVersion = Nothing}, argScope = ScopeTypeNotified, argClosure = 3, argDestroy = 4, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "user_data", argType = TBasicType TPtr, direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "user data to pass to @callback", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "destroy_notify", argType = TInterface (Name {namespace = "GLib", name = "DestroyNotify"}), direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "destroy notifier for @user_data", sinceVersion = Nothing}, argScope = ScopeTypeAsync, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "return_type", argType = TBasicType TGType, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the #GType of the constructor return value", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "n_parameters", argType = TBasicType TUInt, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the number of parameters", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "parameter_types", argType = TCArray False (-1) 6 (TBasicType TGType), direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "a list of #GType<!-- -->s, one for each parameter, or %NULL", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : [Arg {argCName = "n_parameters", argType = TBasicType TUInt, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the number of parameters", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_class_add_constructorv" jsc_class_add_constructorv :: 
    Ptr Class ->                            -- jsc_class : TInterface (Name {namespace = "JavaScriptCore", name = "Class"})
    CString ->                              -- name : TBasicType TUTF8
    FunPtr GObject.Callbacks.C_Callback ->  -- callback : TInterface (Name {namespace = "GObject", name = "Callback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy_notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    CGType ->                               -- return_type : TBasicType TGType
    Word32 ->                               -- n_parameters : TBasicType TUInt
    Ptr CGType ->                           -- parameter_types : TCArray False (-1) 6 (TBasicType TGType)
    IO (Ptr JavaScriptCore.Value.Value)

{- |
Add a constructor to /@jscClass@/. If /@name@/ is 'Nothing', the class name will be used. When \<function>new\<\/function>
is used with the constructor or @/jsc_value_constructor_call()/@ is called, /@callback@/ is invoked receiving the
parameters and /@userData@/ as the last parameter. When the constructor object is cleared in the 'GI.JavaScriptCore.Objects.Class.Class' context,
/@destroyNotify@/ is called with /@userData@/ as parameter.

This function creates the constructor, which needs to be added to an object as a property to be able to use it. Use
'GI.JavaScriptCore.Objects.Context.contextSetValue' to make the constructor available in the global object.

Note that the value returned by /@callback@/ is adopted by /@jscClass@/, and the 'GI.GLib.Callbacks.DestroyNotify' passed to
'GI.JavaScriptCore.Objects.Context.contextRegisterClass' is responsible for disposing of it.
-}
classAddConstructor ::
    (B.CallStack.HasCallStack, MonadIO m, IsClass a) =>
    a
    {- ^ /@jscClass@/: a 'GI.JavaScriptCore.Objects.Class.Class' -}
    -> Maybe (T.Text)
    {- ^ /@name@/: the constructor name or 'Nothing' -}
    -> GObject.Callbacks.Callback
    {- ^ /@callback@/: a 'GI.GObject.Callbacks.Callback' to be called to create an instance of /@jscClass@/ -}
    -> GType
    {- ^ /@returnType@/: the 'GType' of the constructor return value -}
    -> Maybe ([GType])
    {- ^ /@parameterTypes@/: a list of 'GType'\<!-- -->s, one for each parameter, or 'Nothing' -}
    -> m JavaScriptCore.Value.Value
    {- ^ __Returns:__ a 'GI.JavaScriptCore.Objects.Value.Value' representing the class constructor. -}
classAddConstructor jscClass name callback returnType parameterTypes = liftIO $ do
    let nParameters = case parameterTypes of
            Nothing -> 0
            Just jParameterTypes -> fromIntegral $ length jParameterTypes
    jscClass' <- unsafeManagedPtrCastPtr jscClass
    maybeName <- case name of
        Nothing -> return nullPtr
        Just jName -> do
            jName' <- textToCString jName
            return jName'
    callback' <- GObject.Callbacks.mk_Callback (GObject.Callbacks.wrap_Callback Nothing callback)
    let returnType' = gtypeToCGType returnType
    maybeParameterTypes <- case parameterTypes of
        Nothing -> return nullPtr
        Just jParameterTypes -> do
            jParameterTypes' <- (packMapStorableArray gtypeToCGType) jParameterTypes
            return jParameterTypes'
    let userData = castFunPtrToPtr callback'
    let destroyNotify = safeFreeFunPtrPtr
    result <- jsc_class_add_constructorv jscClass' maybeName callback' userData destroyNotify returnType' nParameters maybeParameterTypes
    checkUnexpectedReturnNULL "classAddConstructor" result
    result' <- (wrapObject JavaScriptCore.Value.Value) result
    touchManagedPtr jscClass
    freeMem maybeName
    freeMem maybeParameterTypes
    return result'

#if ENABLE_OVERLOADING
data ClassAddConstructorMethodInfo
instance (signature ~ (Maybe (T.Text) -> GObject.Callbacks.Callback -> GType -> Maybe ([GType]) -> m JavaScriptCore.Value.Value), MonadIO m, IsClass a) => O.MethodInfo ClassAddConstructorMethodInfo a signature where
    overloadedMethod _ = classAddConstructor

#endif

-- method Class::add_method_variadic
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "jsc_class", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Class"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCClass", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "name", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the method name", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "callback", argType = TInterface (Name {namespace = "GObject", name = "Callback"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #GCallback to be called to invoke method @name of @jsc_class", sinceVersion = Nothing}, argScope = ScopeTypeNotified, argClosure = 3, argDestroy = 4, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "user_data", argType = TBasicType TPtr, direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "user data to pass to @callback", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "destroy_notify", argType = TInterface (Name {namespace = "GLib", name = "DestroyNotify"}), direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "destroy notifier for @user_data", sinceVersion = Nothing}, argScope = ScopeTypeAsync, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "return_type", argType = TBasicType TGType, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the #GType of the method return value, or %G_TYPE_NONE if the method is void.", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "jsc_class_add_method_variadic" jsc_class_add_method_variadic :: 
    Ptr Class ->                            -- jsc_class : TInterface (Name {namespace = "JavaScriptCore", name = "Class"})
    CString ->                              -- name : TBasicType TUTF8
    FunPtr GObject.Callbacks.C_Callback ->  -- callback : TInterface (Name {namespace = "GObject", name = "Callback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy_notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    CGType ->                               -- return_type : TBasicType TGType
    IO ()

{- |
Add method with /@name@/ to /@jscClass@/. When the method is called by JavaScript or @/jsc_value_object_invoke_method()/@,
/@callback@/ is called receiving the class instance as first parameter, followed by a 'GI.GLib.Structs.PtrArray.PtrArray' of 'GI.JavaScriptCore.Objects.Value.Value'\<!-- -->s
with the method arguments and then /@userData@/ as last parameter. When the method is cleared in the 'GI.JavaScriptCore.Objects.Class.Class' context,
/@destroyNotify@/ is called with /@userData@/ as parameter.

Note that the value returned by /@callback@/ must be transfer full. In case of non-refcounted boxed types, you should use
@/G_TYPE_POINTER/@ instead of the actual boxed 'GType' to ensure that the instance owned by 'GI.JavaScriptCore.Objects.Class.Class' is used.
If you really want to return a new copy of the boxed type, use @/JSC_TYPE_VALUE/@ and return a 'GI.JavaScriptCore.Objects.Value.Value' created
with 'GI.JavaScriptCore.Objects.Value.valueNewObject' that receives the copy as the instance parameter.
-}
classAddMethodVariadic ::
    (B.CallStack.HasCallStack, MonadIO m, IsClass a) =>
    a
    {- ^ /@jscClass@/: a 'GI.JavaScriptCore.Objects.Class.Class' -}
    -> T.Text
    {- ^ /@name@/: the method name -}
    -> GObject.Callbacks.Callback
    {- ^ /@callback@/: a 'GI.GObject.Callbacks.Callback' to be called to invoke method /@name@/ of /@jscClass@/ -}
    -> GType
    {- ^ /@returnType@/: the 'GType' of the method return value, or @/G_TYPE_NONE/@ if the method is void. -}
    -> m ()
classAddMethodVariadic jscClass name callback returnType = liftIO $ do
    jscClass' <- unsafeManagedPtrCastPtr jscClass
    name' <- textToCString name
    callback' <- GObject.Callbacks.mk_Callback (GObject.Callbacks.wrap_Callback Nothing callback)
    let returnType' = gtypeToCGType returnType
    let userData = castFunPtrToPtr callback'
    let destroyNotify = safeFreeFunPtrPtr
    jsc_class_add_method_variadic jscClass' name' callback' userData destroyNotify returnType'
    touchManagedPtr jscClass
    freeMem name'
    return ()

#if ENABLE_OVERLOADING
data ClassAddMethodVariadicMethodInfo
instance (signature ~ (T.Text -> GObject.Callbacks.Callback -> GType -> m ()), MonadIO m, IsClass a) => O.MethodInfo ClassAddMethodVariadicMethodInfo a signature where
    overloadedMethod _ = classAddMethodVariadic

#endif

-- method Class::add_method
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "jsc_class", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Class"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCClass", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "name", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the method name", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "callback", argType = TInterface (Name {namespace = "GObject", name = "Callback"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #GCallback to be called to invoke method @name of @jsc_class", sinceVersion = Nothing}, argScope = ScopeTypeNotified, argClosure = 3, argDestroy = 4, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "user_data", argType = TBasicType TPtr, direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "user data to pass to @callback", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "destroy_notify", argType = TInterface (Name {namespace = "GLib", name = "DestroyNotify"}), direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "destroy notifier for @user_data", sinceVersion = Nothing}, argScope = ScopeTypeAsync, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "return_type", argType = TBasicType TGType, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the #GType of the method return value, or %G_TYPE_NONE if the method is void.", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "n_parameters", argType = TBasicType TUInt, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the number of parameter types to follow or 0 if the method doesn't receive parameters.", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "parameter_types", argType = TCArray False (-1) 6 (TBasicType TGType), direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "a list of #GType<!-- -->s, one for each parameter, or %NULL", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : [Arg {argCName = "n_parameters", argType = TBasicType TUInt, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the number of parameter types to follow or 0 if the method doesn't receive parameters.", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "jsc_class_add_methodv" jsc_class_add_methodv :: 
    Ptr Class ->                            -- jsc_class : TInterface (Name {namespace = "JavaScriptCore", name = "Class"})
    CString ->                              -- name : TBasicType TUTF8
    FunPtr GObject.Callbacks.C_Callback ->  -- callback : TInterface (Name {namespace = "GObject", name = "Callback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy_notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    CGType ->                               -- return_type : TBasicType TGType
    Word32 ->                               -- n_parameters : TBasicType TUInt
    Ptr CGType ->                           -- parameter_types : TCArray False (-1) 6 (TBasicType TGType)
    IO ()

{- |
Add method with /@name@/ to /@jscClass@/. When the method is called by JavaScript or @/jsc_value_object_invoke_method()/@,
/@callback@/ is called receiving the class instance as first parameter, followed by the method parameters and then
/@userData@/ as last parameter. When the method is cleared in the 'GI.JavaScriptCore.Objects.Class.Class' context, /@destroyNotify@/ is called with
/@userData@/ as parameter.

Note that the value returned by /@callback@/ must be transfer full. In case of non-refcounted boxed types, you should use
@/G_TYPE_POINTER/@ instead of the actual boxed 'GType' to ensure that the instance owned by 'GI.JavaScriptCore.Objects.Class.Class' is used.
If you really want to return a new copy of the boxed type, use @/JSC_TYPE_VALUE/@ and return a 'GI.JavaScriptCore.Objects.Value.Value' created
with 'GI.JavaScriptCore.Objects.Value.valueNewObject' that receives the copy as the instance parameter.
-}
classAddMethod ::
    (B.CallStack.HasCallStack, MonadIO m, IsClass a) =>
    a
    {- ^ /@jscClass@/: a 'GI.JavaScriptCore.Objects.Class.Class' -}
    -> T.Text
    {- ^ /@name@/: the method name -}
    -> GObject.Callbacks.Callback
    {- ^ /@callback@/: a 'GI.GObject.Callbacks.Callback' to be called to invoke method /@name@/ of /@jscClass@/ -}
    -> GType
    {- ^ /@returnType@/: the 'GType' of the method return value, or @/G_TYPE_NONE/@ if the method is void. -}
    -> Maybe ([GType])
    {- ^ /@parameterTypes@/: a list of 'GType'\<!-- -->s, one for each parameter, or 'Nothing' -}
    -> m ()
classAddMethod jscClass name callback returnType parameterTypes = liftIO $ do
    let nParameters = case parameterTypes of
            Nothing -> 0
            Just jParameterTypes -> fromIntegral $ length jParameterTypes
    jscClass' <- unsafeManagedPtrCastPtr jscClass
    name' <- textToCString name
    callback' <- GObject.Callbacks.mk_Callback (GObject.Callbacks.wrap_Callback Nothing callback)
    let returnType' = gtypeToCGType returnType
    maybeParameterTypes <- case parameterTypes of
        Nothing -> return nullPtr
        Just jParameterTypes -> do
            jParameterTypes' <- (packMapStorableArray gtypeToCGType) jParameterTypes
            return jParameterTypes'
    let userData = castFunPtrToPtr callback'
    let destroyNotify = safeFreeFunPtrPtr
    jsc_class_add_methodv jscClass' name' callback' userData destroyNotify returnType' nParameters maybeParameterTypes
    touchManagedPtr jscClass
    freeMem name'
    freeMem maybeParameterTypes
    return ()

#if ENABLE_OVERLOADING
data ClassAddMethodMethodInfo
instance (signature ~ (T.Text -> GObject.Callbacks.Callback -> GType -> Maybe ([GType]) -> m ()), MonadIO m, IsClass a) => O.MethodInfo ClassAddMethodMethodInfo a signature where
    overloadedMethod _ = classAddMethod

#endif

-- method Class::add_property
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "jsc_class", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Class"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCClass", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "name", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the property name", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "property_type", argType = TBasicType TGType, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the #GType of the property value", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "getter", argType = TInterface (Name {namespace = "GObject", name = "Callback"}), direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "a #GCallback to be called to get the property value", sinceVersion = Nothing}, argScope = ScopeTypeAsync, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "setter", argType = TInterface (Name {namespace = "GObject", name = "Callback"}), direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "a #GCallback to be called to set the property value", sinceVersion = Nothing}, argScope = ScopeTypeNotified, argClosure = 5, argDestroy = 6, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "user_data", argType = TBasicType TPtr, direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "user data to pass to @getter and @setter", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "destroy_notify", argType = TInterface (Name {namespace = "GLib", name = "DestroyNotify"}), direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "destroy notifier for @user_data", sinceVersion = Nothing}, argScope = ScopeTypeAsync, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "jsc_class_add_property" jsc_class_add_property :: 
    Ptr Class ->                            -- jsc_class : TInterface (Name {namespace = "JavaScriptCore", name = "Class"})
    CString ->                              -- name : TBasicType TUTF8
    CGType ->                               -- property_type : TBasicType TGType
    FunPtr GObject.Callbacks.C_Callback ->  -- getter : TInterface (Name {namespace = "GObject", name = "Callback"})
    FunPtr GObject.Callbacks.C_Callback ->  -- setter : TInterface (Name {namespace = "GObject", name = "Callback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy_notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

{- |
Add a property with /@name@/ to /@jscClass@/. When the property value needs to be getted, /@getter@/ is called
receiving the the class instance as first parameter and /@userData@/ as last parameter. When the property
value needs to be set, /@setter@/ is called receiving the the class instance as first parameter, followed
by the value to be set and then /@userData@/ as the last parameter. When the property is cleared in the
'GI.JavaScriptCore.Objects.Class.Class' context, /@destroyNotify@/ is called with /@userData@/ as parameter.

Note that the value returned by /@getter@/ must be transfer full. In case of non-refcounted boxed types, you should use
@/G_TYPE_POINTER/@ instead of the actual boxed 'GType' to ensure that the instance owned by 'GI.JavaScriptCore.Objects.Class.Class' is used.
If you really want to return a new copy of the boxed type, use @/JSC_TYPE_VALUE/@ and return a 'GI.JavaScriptCore.Objects.Value.Value' created
with 'GI.JavaScriptCore.Objects.Value.valueNewObject' that receives the copy as the instance parameter.
-}
classAddProperty ::
    (B.CallStack.HasCallStack, MonadIO m, IsClass a) =>
    a
    {- ^ /@jscClass@/: a 'GI.JavaScriptCore.Objects.Class.Class' -}
    -> T.Text
    {- ^ /@name@/: the property name -}
    -> GType
    {- ^ /@propertyType@/: the 'GType' of the property value -}
    -> Maybe (GObject.Callbacks.Callback)
    {- ^ /@getter@/: a 'GI.GObject.Callbacks.Callback' to be called to get the property value -}
    -> Maybe (GObject.Callbacks.Callback)
    {- ^ /@setter@/: a 'GI.GObject.Callbacks.Callback' to be called to set the property value -}
    -> m ()
classAddProperty jscClass name propertyType getter setter = liftIO $ do
    jscClass' <- unsafeManagedPtrCastPtr jscClass
    name' <- textToCString name
    let propertyType' = gtypeToCGType propertyType
    maybeGetter <- case getter of
        Nothing -> return (castPtrToFunPtr nullPtr)
        Just jGetter -> do
            ptrgetter <- callocMem :: IO (Ptr (FunPtr GObject.Callbacks.C_Callback))
            jGetter' <- GObject.Callbacks.mk_Callback (GObject.Callbacks.wrap_Callback (Just ptrgetter) jGetter)
            poke ptrgetter jGetter'
            return jGetter'
    maybeSetter <- case setter of
        Nothing -> return (castPtrToFunPtr nullPtr)
        Just jSetter -> do
            jSetter' <- GObject.Callbacks.mk_Callback (GObject.Callbacks.wrap_Callback Nothing jSetter)
            return jSetter'
    let userData = castFunPtrToPtr maybeSetter
    let destroyNotify = safeFreeFunPtrPtr
    jsc_class_add_property jscClass' name' propertyType' maybeGetter maybeSetter userData destroyNotify
    touchManagedPtr jscClass
    freeMem name'
    return ()

#if ENABLE_OVERLOADING
data ClassAddPropertyMethodInfo
instance (signature ~ (T.Text -> GType -> Maybe (GObject.Callbacks.Callback) -> Maybe (GObject.Callbacks.Callback) -> m ()), MonadIO m, IsClass a) => O.MethodInfo ClassAddPropertyMethodInfo a signature where
    overloadedMethod _ = classAddProperty

#endif

-- method Class::get_name
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "jsc_class", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Class"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a @JSCClass", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "jsc_class_get_name" jsc_class_get_name :: 
    Ptr Class ->                            -- jsc_class : TInterface (Name {namespace = "JavaScriptCore", name = "Class"})
    IO CString

{- |
Get the class name of /@jscClass@/
-}
classGetName ::
    (B.CallStack.HasCallStack, MonadIO m, IsClass a) =>
    a
    {- ^ /@jscClass@/: a /@jSCClass@/ -}
    -> m T.Text
    {- ^ __Returns:__ the name of /@jscClass@/ -}
classGetName jscClass = liftIO $ do
    jscClass' <- unsafeManagedPtrCastPtr jscClass
    result <- jsc_class_get_name jscClass'
    checkUnexpectedReturnNULL "classGetName" result
    result' <- cstringToText result
    touchManagedPtr jscClass
    return result'

#if ENABLE_OVERLOADING
data ClassGetNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsClass a) => O.MethodInfo ClassGetNameMethodInfo a signature where
    overloadedMethod _ = classGetName

#endif

-- method Class::get_parent
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "jsc_class", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Class"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a @JSCClass", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Class"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_class_get_parent" jsc_class_get_parent :: 
    Ptr Class ->                            -- jsc_class : TInterface (Name {namespace = "JavaScriptCore", name = "Class"})
    IO (Ptr Class)

{- |
Get the parent class of /@jscClass@/
-}
classGetParent ::
    (B.CallStack.HasCallStack, MonadIO m, IsClass a) =>
    a
    {- ^ /@jscClass@/: a /@jSCClass@/ -}
    -> m Class
    {- ^ __Returns:__ the parent class of /@jscClass@/ -}
classGetParent jscClass = liftIO $ do
    jscClass' <- unsafeManagedPtrCastPtr jscClass
    result <- jsc_class_get_parent jscClass'
    checkUnexpectedReturnNULL "classGetParent" result
    result' <- (newObject Class) result
    touchManagedPtr jscClass
    return result'

#if ENABLE_OVERLOADING
data ClassGetParentMethodInfo
instance (signature ~ (m Class), MonadIO m, IsClass a) => O.MethodInfo ClassGetParentMethodInfo a signature where
    overloadedMethod _ = classGetParent

#endif


