

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (inaki@blueleaf.cc)

/No description available in the introspection data./
-}

#define ENABLE_OVERLOADING (MIN_VERSION_haskell_gi_overloading(1,0,0) \
       && !defined(__HADDOCK_VERSION__))

module GI.JavaScriptCore.Objects.Context
    ( 

-- * Exported types
    Context(..)                             ,
    IsContext                               ,
    toContext                               ,
    noContext                               ,


 -- * Methods
-- ** checkSyntax #method:checkSyntax#

#if ENABLE_OVERLOADING
    ContextCheckSyntaxMethodInfo            ,
#endif
    contextCheckSyntax                      ,


-- ** clearException #method:clearException#

#if ENABLE_OVERLOADING
    ContextClearExceptionMethodInfo         ,
#endif
    contextClearException                   ,


-- ** evaluate #method:evaluate#

#if ENABLE_OVERLOADING
    ContextEvaluateMethodInfo               ,
#endif
    contextEvaluate                         ,


-- ** evaluateInObject #method:evaluateInObject#

#if ENABLE_OVERLOADING
    ContextEvaluateInObjectMethodInfo       ,
#endif
    contextEvaluateInObject                 ,


-- ** evaluateWithSourceUri #method:evaluateWithSourceUri#

#if ENABLE_OVERLOADING
    ContextEvaluateWithSourceUriMethodInfo  ,
#endif
    contextEvaluateWithSourceUri            ,


-- ** getCurrent #method:getCurrent#

    contextGetCurrent                       ,


-- ** getException #method:getException#

#if ENABLE_OVERLOADING
    ContextGetExceptionMethodInfo           ,
#endif
    contextGetException                     ,


-- ** getGlobalObject #method:getGlobalObject#

#if ENABLE_OVERLOADING
    ContextGetGlobalObjectMethodInfo        ,
#endif
    contextGetGlobalObject                  ,


-- ** getValue #method:getValue#

#if ENABLE_OVERLOADING
    ContextGetValueMethodInfo               ,
#endif
    contextGetValue                         ,


-- ** getVirtualMachine #method:getVirtualMachine#

#if ENABLE_OVERLOADING
    ContextGetVirtualMachineMethodInfo      ,
#endif
    contextGetVirtualMachine                ,


-- ** new #method:new#

    contextNew                              ,


-- ** newWithVirtualMachine #method:newWithVirtualMachine#

    contextNewWithVirtualMachine            ,


-- ** popExceptionHandler #method:popExceptionHandler#

#if ENABLE_OVERLOADING
    ContextPopExceptionHandlerMethodInfo    ,
#endif
    contextPopExceptionHandler              ,


-- ** pushExceptionHandler #method:pushExceptionHandler#

#if ENABLE_OVERLOADING
    ContextPushExceptionHandlerMethodInfo   ,
#endif
    contextPushExceptionHandler             ,


-- ** registerClass #method:registerClass#

#if ENABLE_OVERLOADING
    ContextRegisterClassMethodInfo          ,
#endif
    contextRegisterClass                    ,


-- ** setValue #method:setValue#

#if ENABLE_OVERLOADING
    ContextSetValueMethodInfo               ,
#endif
    contextSetValue                         ,


-- ** throw #method:throw#

#if ENABLE_OVERLOADING
    ContextThrowMethodInfo                  ,
#endif
    contextThrow                            ,


-- ** throwException #method:throwException#

#if ENABLE_OVERLOADING
    ContextThrowExceptionMethodInfo         ,
#endif
    contextThrowException                   ,


-- ** throwWithName #method:throwWithName#

#if ENABLE_OVERLOADING
    ContextThrowWithNameMethodInfo          ,
#endif
    contextThrowWithName                    ,




 -- * Properties
-- ** virtualMachine #attr:virtualMachine#
{- | The 'GI.JavaScriptCore.Objects.VirtualMachine.VirtualMachine' in which the context was created.
-}
#if ENABLE_OVERLOADING
    ContextVirtualMachinePropertyInfo       ,
#endif
    constructContextVirtualMachine          ,
#if ENABLE_OVERLOADING
    contextVirtualMachine                   ,
#endif
    getContextVirtualMachine                ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL

import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.JavaScriptCore.Callbacks as JavaScriptCore.Callbacks
import {-# SOURCE #-} qualified GI.JavaScriptCore.Enums as JavaScriptCore.Enums
import {-# SOURCE #-} qualified GI.JavaScriptCore.Objects.Class as JavaScriptCore.Class
import {-# SOURCE #-} qualified GI.JavaScriptCore.Objects.Exception as JavaScriptCore.Exception
import {-# SOURCE #-} qualified GI.JavaScriptCore.Objects.Value as JavaScriptCore.Value
import {-# SOURCE #-} qualified GI.JavaScriptCore.Objects.VirtualMachine as JavaScriptCore.VirtualMachine
import {-# SOURCE #-} qualified GI.JavaScriptCore.Structs.ClassVTable as JavaScriptCore.ClassVTable

-- | Memory-managed wrapper type.
newtype Context = Context (ManagedPtr Context)
foreign import ccall "jsc_context_get_type"
    c_jsc_context_get_type :: IO GType

instance GObject Context where
    gobjectType = c_jsc_context_get_type
    

-- | Type class for types which can be safely cast to `Context`, for instance with `toContext`.
class (GObject o, O.IsDescendantOf Context o) => IsContext o
instance (GObject o, O.IsDescendantOf Context o) => IsContext o

instance O.HasParentTypes Context
type instance O.ParentTypes Context = '[GObject.Object.Object]

-- | Cast to `Context`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toContext :: (MonadIO m, IsContext o) => o -> m Context
toContext = liftIO . unsafeCastTo Context

-- | A convenience alias for `Nothing` :: `Maybe` `Context`.
noContext :: Maybe Context
noContext = Nothing

#if ENABLE_OVERLOADING
type family ResolveContextMethod (t :: Symbol) (o :: *) :: * where
    ResolveContextMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveContextMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveContextMethod "checkSyntax" o = ContextCheckSyntaxMethodInfo
    ResolveContextMethod "clearException" o = ContextClearExceptionMethodInfo
    ResolveContextMethod "evaluate" o = ContextEvaluateMethodInfo
    ResolveContextMethod "evaluateInObject" o = ContextEvaluateInObjectMethodInfo
    ResolveContextMethod "evaluateWithSourceUri" o = ContextEvaluateWithSourceUriMethodInfo
    ResolveContextMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveContextMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveContextMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveContextMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveContextMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveContextMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveContextMethod "popExceptionHandler" o = ContextPopExceptionHandlerMethodInfo
    ResolveContextMethod "pushExceptionHandler" o = ContextPushExceptionHandlerMethodInfo
    ResolveContextMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveContextMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveContextMethod "registerClass" o = ContextRegisterClassMethodInfo
    ResolveContextMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveContextMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveContextMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveContextMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveContextMethod "throw" o = ContextThrowMethodInfo
    ResolveContextMethod "throwException" o = ContextThrowExceptionMethodInfo
    ResolveContextMethod "throwWithName" o = ContextThrowWithNameMethodInfo
    ResolveContextMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveContextMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveContextMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveContextMethod "getException" o = ContextGetExceptionMethodInfo
    ResolveContextMethod "getGlobalObject" o = ContextGetGlobalObjectMethodInfo
    ResolveContextMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveContextMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveContextMethod "getValue" o = ContextGetValueMethodInfo
    ResolveContextMethod "getVirtualMachine" o = ContextGetVirtualMachineMethodInfo
    ResolveContextMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveContextMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveContextMethod "setValue" o = ContextSetValueMethodInfo
    ResolveContextMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveContextMethod t Context, O.MethodInfo info Context p) => OL.IsLabel t (Context -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod (O.MethodProxy :: O.MethodProxy info)
#else
    fromLabel _ = O.overloadedMethod (O.MethodProxy :: O.MethodProxy info)
#endif

#endif

-- VVV Prop "virtual-machine"
   -- Type: TInterface (Name {namespace = "JavaScriptCore", name = "VirtualMachine"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

{- |
Get the value of the “@virtual-machine@” property.
When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to

@
'Data.GI.Base.Attributes.get' context #virtualMachine
@
-}
getContextVirtualMachine :: (MonadIO m, IsContext o) => o -> m JavaScriptCore.VirtualMachine.VirtualMachine
getContextVirtualMachine obj = liftIO $ checkUnexpectedNothing "getContextVirtualMachine" $ B.Properties.getObjectPropertyObject obj "virtual-machine" JavaScriptCore.VirtualMachine.VirtualMachine

{- |
Construct a `GValueConstruct` with valid value for the “@virtual-machine@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
-}
constructContextVirtualMachine :: (IsContext o, JavaScriptCore.VirtualMachine.IsVirtualMachine a) => a -> IO (GValueConstruct o)
constructContextVirtualMachine val = B.Properties.constructObjectPropertyObject "virtual-machine" (Just val)

#if ENABLE_OVERLOADING
data ContextVirtualMachinePropertyInfo
instance AttrInfo ContextVirtualMachinePropertyInfo where
    type AttrAllowedOps ContextVirtualMachinePropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ContextVirtualMachinePropertyInfo = JavaScriptCore.VirtualMachine.IsVirtualMachine
    type AttrBaseTypeConstraint ContextVirtualMachinePropertyInfo = IsContext
    type AttrGetType ContextVirtualMachinePropertyInfo = JavaScriptCore.VirtualMachine.VirtualMachine
    type AttrLabel ContextVirtualMachinePropertyInfo = "virtual-machine"
    type AttrOrigin ContextVirtualMachinePropertyInfo = Context
    attrGet _ = getContextVirtualMachine
    attrSet _ = undefined
    attrConstruct _ = constructContextVirtualMachine
    attrClear _ = undefined
#endif

#if ENABLE_OVERLOADING
instance O.HasAttributeList Context
type instance O.AttributeList Context = ContextAttributeList
type ContextAttributeList = ('[ '("virtualMachine", ContextVirtualMachinePropertyInfo)] :: [(Symbol, *)])
#endif

#if ENABLE_OVERLOADING
contextVirtualMachine :: AttrLabelProxy "virtualMachine"
contextVirtualMachine = AttrLabelProxy

#endif

#if ENABLE_OVERLOADING
type instance O.SignalList Context = ContextSignalList
type ContextSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, *)])

#endif

-- method Context::new
-- method type : Constructor
-- Args : []
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Context"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_context_new" jsc_context_new :: 
    IO (Ptr Context)

{- |
Create a new 'GI.JavaScriptCore.Objects.Context.Context'. The context is created in a new 'GI.JavaScriptCore.Objects.VirtualMachine.VirtualMachine'.
Use 'GI.JavaScriptCore.Objects.Context.contextNewWithVirtualMachine' to create a new 'GI.JavaScriptCore.Objects.Context.Context' in an
existing 'GI.JavaScriptCore.Objects.VirtualMachine.VirtualMachine'.
-}
contextNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Context
    {- ^ __Returns:__ the newly created 'GI.JavaScriptCore.Objects.Context.Context'. -}
contextNew  = liftIO $ do
    result <- jsc_context_new
    checkUnexpectedReturnNULL "contextNew" result
    result' <- (wrapObject Context) result
    return result'

#if ENABLE_OVERLOADING
#endif

-- method Context::new_with_virtual_machine
-- method type : Constructor
-- Args : [Arg {argCName = "vm", argType = TInterface (Name {namespace = "JavaScriptCore", name = "VirtualMachine"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCVirtualMachine", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Context"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_context_new_with_virtual_machine" jsc_context_new_with_virtual_machine :: 
    Ptr JavaScriptCore.VirtualMachine.VirtualMachine -> -- vm : TInterface (Name {namespace = "JavaScriptCore", name = "VirtualMachine"})
    IO (Ptr Context)

{- |
Create a new 'GI.JavaScriptCore.Objects.Context.Context' in /@virtualMachine@/.
-}
contextNewWithVirtualMachine ::
    (B.CallStack.HasCallStack, MonadIO m, JavaScriptCore.VirtualMachine.IsVirtualMachine a) =>
    a
    {- ^ /@vm@/: a 'GI.JavaScriptCore.Objects.VirtualMachine.VirtualMachine' -}
    -> m Context
    {- ^ __Returns:__ the newly created 'GI.JavaScriptCore.Objects.Context.Context'. -}
contextNewWithVirtualMachine vm = liftIO $ do
    vm' <- unsafeManagedPtrCastPtr vm
    result <- jsc_context_new_with_virtual_machine vm'
    checkUnexpectedReturnNULL "contextNewWithVirtualMachine" result
    result' <- (wrapObject Context) result
    touchManagedPtr vm
    return result'

#if ENABLE_OVERLOADING
#endif

-- method Context::check_syntax
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "code", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a JavaScript script to check", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "length", argType = TBasicType TInt64, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "length of @code, or -1 if @code is a nul-terminated string", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "mode", argType = TInterface (Name {namespace = "JavaScriptCore", name = "CheckSyntaxMode"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCCheckSyntaxMode", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "uri", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the source URI", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "line_number", argType = TBasicType TUInt, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the starting line number", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "exception", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Exception"}), direction = DirectionOut, mayBeNull = False, argDoc = Documentation {rawDocText = Just "return location for a #JSCException, or %NULL to ignore", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferEverything}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "CheckSyntaxResult"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_context_check_syntax" jsc_context_check_syntax :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    CString ->                              -- code : TBasicType TUTF8
    Int64 ->                                -- length : TBasicType TInt64
    CUInt ->                                -- mode : TInterface (Name {namespace = "JavaScriptCore", name = "CheckSyntaxMode"})
    CString ->                              -- uri : TBasicType TUTF8
    Word32 ->                               -- line_number : TBasicType TUInt
    Ptr (Ptr JavaScriptCore.Exception.Exception) -> -- exception : TInterface (Name {namespace = "JavaScriptCore", name = "Exception"})
    IO CUInt

{- |
Check the given /@code@/ in /@context@/ for syntax errors. The /@lineNumber@/ is the starting line number in /@uri@/;
the value is one-based so the first line is 1. /@uri@/ and /@lineNumber@/ are only used to fill the /@exception@/.
In case of errors /@exception@/ will be set to a new 'GI.JavaScriptCore.Objects.Exception.Exception' with the details. You can pass 'Nothing' to
/@exception@/ to ignore the error details.
-}
contextCheckSyntax ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> T.Text
    {- ^ /@code@/: a JavaScript script to check -}
    -> Int64
    {- ^ /@length@/: length of /@code@/, or -1 if /@code@/ is a nul-terminated string -}
    -> JavaScriptCore.Enums.CheckSyntaxMode
    {- ^ /@mode@/: a 'GI.JavaScriptCore.Enums.CheckSyntaxMode' -}
    -> T.Text
    {- ^ /@uri@/: the source URI -}
    -> Word32
    {- ^ /@lineNumber@/: the starting line number -}
    -> m ((JavaScriptCore.Enums.CheckSyntaxResult, JavaScriptCore.Exception.Exception))
    {- ^ __Returns:__ a 'GI.JavaScriptCore.Enums.CheckSyntaxResult' -}
contextCheckSyntax context code length_ mode uri lineNumber = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    code' <- textToCString code
    let mode' = (fromIntegral . fromEnum) mode
    uri' <- textToCString uri
    exception <- allocMem :: IO (Ptr (Ptr JavaScriptCore.Exception.Exception))
    result <- jsc_context_check_syntax context' code' length_ mode' uri' lineNumber exception
    let result' = (toEnum . fromIntegral) result
    exception' <- peek exception
    exception'' <- (wrapObject JavaScriptCore.Exception.Exception) exception'
    touchManagedPtr context
    freeMem code'
    freeMem uri'
    freeMem exception
    return (result', exception'')

#if ENABLE_OVERLOADING
data ContextCheckSyntaxMethodInfo
instance (signature ~ (T.Text -> Int64 -> JavaScriptCore.Enums.CheckSyntaxMode -> T.Text -> Word32 -> m ((JavaScriptCore.Enums.CheckSyntaxResult, JavaScriptCore.Exception.Exception))), MonadIO m, IsContext a) => O.MethodInfo ContextCheckSyntaxMethodInfo a signature where
    overloadedMethod _ = contextCheckSyntax

#endif

-- method Context::clear_exception
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "jsc_context_clear_exception" jsc_context_clear_exception :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    IO ()

{- |
Clear the uncaught exception in /@context@/ if any.
-}
contextClearException ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> m ()
contextClearException context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    jsc_context_clear_exception context'
    touchManagedPtr context
    return ()

#if ENABLE_OVERLOADING
data ContextClearExceptionMethodInfo
instance (signature ~ (m ()), MonadIO m, IsContext a) => O.MethodInfo ContextClearExceptionMethodInfo a signature where
    overloadedMethod _ = contextClearException

#endif

-- method Context::evaluate
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "code", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a JavaScript script to evaluate", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "length", argType = TBasicType TInt64, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "length of @code, or -1 if @code is a nul-terminated string", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_context_evaluate" jsc_context_evaluate :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    CString ->                              -- code : TBasicType TUTF8
    Int64 ->                                -- length : TBasicType TInt64
    IO (Ptr JavaScriptCore.Value.Value)

{- |
Evaluate /@code@/ in /@context@/.
-}
contextEvaluate ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> T.Text
    {- ^ /@code@/: a JavaScript script to evaluate -}
    -> Int64
    {- ^ /@length@/: length of /@code@/, or -1 if /@code@/ is a nul-terminated string -}
    -> m JavaScriptCore.Value.Value
    {- ^ __Returns:__ a 'GI.JavaScriptCore.Objects.Value.Value' representing the last value generated by the script. -}
contextEvaluate context code length_ = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    code' <- textToCString code
    result <- jsc_context_evaluate context' code' length_
    checkUnexpectedReturnNULL "contextEvaluate" result
    result' <- (wrapObject JavaScriptCore.Value.Value) result
    touchManagedPtr context
    freeMem code'
    return result'

#if ENABLE_OVERLOADING
data ContextEvaluateMethodInfo
instance (signature ~ (T.Text -> Int64 -> m JavaScriptCore.Value.Value), MonadIO m, IsContext a) => O.MethodInfo ContextEvaluateMethodInfo a signature where
    overloadedMethod _ = contextEvaluate

#endif

-- method Context::evaluate_in_object
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "code", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a JavaScript script to evaluate", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "length", argType = TBasicType TInt64, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "length of @code, or -1 if @code is a nul-terminated string", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "object_instance", argType = TBasicType TPtr, direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "an object instance", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "object_class", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Class"}), direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "a #JSCClass or %NULL to use the default", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "uri", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the source URI", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "line_number", argType = TBasicType TUInt, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the starting line number", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "object", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionOut, mayBeNull = False, argDoc = Documentation {rawDocText = Just "return location for a #JSCValue.", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferEverything}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_context_evaluate_in_object" jsc_context_evaluate_in_object :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    CString ->                              -- code : TBasicType TUTF8
    Int64 ->                                -- length : TBasicType TInt64
    Ptr () ->                               -- object_instance : TBasicType TPtr
    Ptr JavaScriptCore.Class.Class ->       -- object_class : TInterface (Name {namespace = "JavaScriptCore", name = "Class"})
    CString ->                              -- uri : TBasicType TUTF8
    Word32 ->                               -- line_number : TBasicType TUInt
    Ptr (Ptr JavaScriptCore.Value.Value) -> -- object : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    IO (Ptr JavaScriptCore.Value.Value)

{- |
Evaluate /@code@/ and create an new object where symbols defined in /@code@/ will be added as properties,
instead of being added to /@context@/ global object. The new object is returned as /@object@/ parameter.
Similar to how 'GI.JavaScriptCore.Objects.Value.valueNewObject' works, if /@objectInstance@/ is not 'Nothing' /@objectClass@/ must be provided too.
The /@lineNumber@/ is the starting line number in /@uri@/; the value is one-based so the first line is 1.
/@uri@/ and /@lineNumber@/ will be shown in exceptions and they don\'t affect the behavior of the script.
-}
contextEvaluateInObject ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a, JavaScriptCore.Class.IsClass b) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> T.Text
    {- ^ /@code@/: a JavaScript script to evaluate -}
    -> Int64
    {- ^ /@length@/: length of /@code@/, or -1 if /@code@/ is a nul-terminated string -}
    -> Ptr ()
    {- ^ /@objectInstance@/: an object instance -}
    -> Maybe (b)
    {- ^ /@objectClass@/: a 'GI.JavaScriptCore.Objects.Class.Class' or 'Nothing' to use the default -}
    -> T.Text
    {- ^ /@uri@/: the source URI -}
    -> Word32
    {- ^ /@lineNumber@/: the starting line number -}
    -> m ((JavaScriptCore.Value.Value, JavaScriptCore.Value.Value))
    {- ^ __Returns:__ a 'GI.JavaScriptCore.Objects.Value.Value' representing the last value generated by the script. -}
contextEvaluateInObject context code length_ objectInstance objectClass uri lineNumber = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    code' <- textToCString code
    maybeObjectClass <- case objectClass of
        Nothing -> return nullPtr
        Just jObjectClass -> do
            jObjectClass' <- unsafeManagedPtrCastPtr jObjectClass
            return jObjectClass'
    uri' <- textToCString uri
    object <- allocMem :: IO (Ptr (Ptr JavaScriptCore.Value.Value))
    result <- jsc_context_evaluate_in_object context' code' length_ objectInstance maybeObjectClass uri' lineNumber object
    checkUnexpectedReturnNULL "contextEvaluateInObject" result
    result' <- (wrapObject JavaScriptCore.Value.Value) result
    object' <- peek object
    object'' <- (wrapObject JavaScriptCore.Value.Value) object'
    touchManagedPtr context
    whenJust objectClass touchManagedPtr
    freeMem code'
    freeMem uri'
    freeMem object
    return (result', object'')

#if ENABLE_OVERLOADING
data ContextEvaluateInObjectMethodInfo
instance (signature ~ (T.Text -> Int64 -> Ptr () -> Maybe (b) -> T.Text -> Word32 -> m ((JavaScriptCore.Value.Value, JavaScriptCore.Value.Value))), MonadIO m, IsContext a, JavaScriptCore.Class.IsClass b) => O.MethodInfo ContextEvaluateInObjectMethodInfo a signature where
    overloadedMethod _ = contextEvaluateInObject

#endif

-- method Context::evaluate_with_source_uri
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "code", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a JavaScript script to evaluate", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "length", argType = TBasicType TInt64, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "length of @code, or -1 if @code is a nul-terminated string", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "uri", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the source URI", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "line_number", argType = TBasicType TUInt, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the starting line number", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_context_evaluate_with_source_uri" jsc_context_evaluate_with_source_uri :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    CString ->                              -- code : TBasicType TUTF8
    Int64 ->                                -- length : TBasicType TInt64
    CString ->                              -- uri : TBasicType TUTF8
    Word32 ->                               -- line_number : TBasicType TUInt
    IO (Ptr JavaScriptCore.Value.Value)

{- |
Evaluate /@code@/ in /@context@/ using /@uri@/ as the source URI. The /@lineNumber@/ is the starting line number
in /@uri@/; the value is one-based so the first line is 1. /@uri@/ and /@lineNumber@/ will be shown in exceptions and
they don\'t affect the behavior of the script.
-}
contextEvaluateWithSourceUri ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> T.Text
    {- ^ /@code@/: a JavaScript script to evaluate -}
    -> Int64
    {- ^ /@length@/: length of /@code@/, or -1 if /@code@/ is a nul-terminated string -}
    -> T.Text
    {- ^ /@uri@/: the source URI -}
    -> Word32
    {- ^ /@lineNumber@/: the starting line number -}
    -> m JavaScriptCore.Value.Value
    {- ^ __Returns:__ a 'GI.JavaScriptCore.Objects.Value.Value' representing the last value generated by the script. -}
contextEvaluateWithSourceUri context code length_ uri lineNumber = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    code' <- textToCString code
    uri' <- textToCString uri
    result <- jsc_context_evaluate_with_source_uri context' code' length_ uri' lineNumber
    checkUnexpectedReturnNULL "contextEvaluateWithSourceUri" result
    result' <- (wrapObject JavaScriptCore.Value.Value) result
    touchManagedPtr context
    freeMem code'
    freeMem uri'
    return result'

#if ENABLE_OVERLOADING
data ContextEvaluateWithSourceUriMethodInfo
instance (signature ~ (T.Text -> Int64 -> T.Text -> Word32 -> m JavaScriptCore.Value.Value), MonadIO m, IsContext a) => O.MethodInfo ContextEvaluateWithSourceUriMethodInfo a signature where
    overloadedMethod _ = contextEvaluateWithSourceUri

#endif

-- method Context::get_exception
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Exception"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_context_get_exception" jsc_context_get_exception :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    IO (Ptr JavaScriptCore.Exception.Exception)

{- |
Get the last unhandled exception thrown in /@context@/ by API functions calls.
-}
contextGetException ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> m (Maybe JavaScriptCore.Exception.Exception)
    {- ^ __Returns:__ a 'GI.JavaScriptCore.Objects.Exception.Exception' or 'Nothing' if there isn\'t any
   unhandled exception in the 'GI.JavaScriptCore.Objects.Context.Context'. -}
contextGetException context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- jsc_context_get_exception context'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject JavaScriptCore.Exception.Exception) result'
        return result''
    touchManagedPtr context
    return maybeResult

#if ENABLE_OVERLOADING
data ContextGetExceptionMethodInfo
instance (signature ~ (m (Maybe JavaScriptCore.Exception.Exception)), MonadIO m, IsContext a) => O.MethodInfo ContextGetExceptionMethodInfo a signature where
    overloadedMethod _ = contextGetException

#endif

-- method Context::get_global_object
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_context_get_global_object" jsc_context_get_global_object :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    IO (Ptr JavaScriptCore.Value.Value)

{- |
Get a 'GI.JavaScriptCore.Objects.Value.Value' referencing the /@context@/ global object
-}
contextGetGlobalObject ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> m JavaScriptCore.Value.Value
    {- ^ __Returns:__ a 'GI.JavaScriptCore.Objects.Value.Value' -}
contextGetGlobalObject context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- jsc_context_get_global_object context'
    checkUnexpectedReturnNULL "contextGetGlobalObject" result
    result' <- (wrapObject JavaScriptCore.Value.Value) result
    touchManagedPtr context
    return result'

#if ENABLE_OVERLOADING
data ContextGetGlobalObjectMethodInfo
instance (signature ~ (m JavaScriptCore.Value.Value), MonadIO m, IsContext a) => O.MethodInfo ContextGetGlobalObjectMethodInfo a signature where
    overloadedMethod _ = contextGetGlobalObject

#endif

-- method Context::get_value
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "name", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the value name", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_context_get_value" jsc_context_get_value :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    CString ->                              -- name : TBasicType TUTF8
    IO (Ptr JavaScriptCore.Value.Value)

{- |
Get a property of /@context@/ global object with /@name@/.
-}
contextGetValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> T.Text
    {- ^ /@name@/: the value name -}
    -> m JavaScriptCore.Value.Value
    {- ^ __Returns:__ a 'GI.JavaScriptCore.Objects.Value.Value' -}
contextGetValue context name = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    name' <- textToCString name
    result <- jsc_context_get_value context' name'
    checkUnexpectedReturnNULL "contextGetValue" result
    result' <- (wrapObject JavaScriptCore.Value.Value) result
    touchManagedPtr context
    freeMem name'
    return result'

#if ENABLE_OVERLOADING
data ContextGetValueMethodInfo
instance (signature ~ (T.Text -> m JavaScriptCore.Value.Value), MonadIO m, IsContext a) => O.MethodInfo ContextGetValueMethodInfo a signature where
    overloadedMethod _ = contextGetValue

#endif

-- method Context::get_virtual_machine
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "VirtualMachine"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_context_get_virtual_machine" jsc_context_get_virtual_machine :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    IO (Ptr JavaScriptCore.VirtualMachine.VirtualMachine)

{- |
Get the 'GI.JavaScriptCore.Objects.VirtualMachine.VirtualMachine' where /@context@/ was created.
-}
contextGetVirtualMachine ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> m JavaScriptCore.VirtualMachine.VirtualMachine
    {- ^ __Returns:__ the 'GI.JavaScriptCore.Objects.VirtualMachine.VirtualMachine' where the 'GI.JavaScriptCore.Objects.Context.Context' was created. -}
contextGetVirtualMachine context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- jsc_context_get_virtual_machine context'
    checkUnexpectedReturnNULL "contextGetVirtualMachine" result
    result' <- (newObject JavaScriptCore.VirtualMachine.VirtualMachine) result
    touchManagedPtr context
    return result'

#if ENABLE_OVERLOADING
data ContextGetVirtualMachineMethodInfo
instance (signature ~ (m JavaScriptCore.VirtualMachine.VirtualMachine), MonadIO m, IsContext a) => O.MethodInfo ContextGetVirtualMachineMethodInfo a signature where
    overloadedMethod _ = contextGetVirtualMachine

#endif

-- method Context::pop_exception_handler
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "jsc_context_pop_exception_handler" jsc_context_pop_exception_handler :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    IO ()

{- |
Remove the last 'GI.JavaScriptCore.Callbacks.ExceptionHandler' previously pushed to /@context@/ with
'GI.JavaScriptCore.Objects.Context.contextPushExceptionHandler'.
-}
contextPopExceptionHandler ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> m ()
contextPopExceptionHandler context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    jsc_context_pop_exception_handler context'
    touchManagedPtr context
    return ()

#if ENABLE_OVERLOADING
data ContextPopExceptionHandlerMethodInfo
instance (signature ~ (m ()), MonadIO m, IsContext a) => O.MethodInfo ContextPopExceptionHandlerMethodInfo a signature where
    overloadedMethod _ = contextPopExceptionHandler

#endif

-- method Context::push_exception_handler
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "handler", argType = TInterface (Name {namespace = "JavaScriptCore", name = "ExceptionHandler"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCExceptionHandler", sinceVersion = Nothing}, argScope = ScopeTypeNotified, argClosure = 2, argDestroy = 3, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "user_data", argType = TBasicType TPtr, direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "user data to pass to @handler", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "destroy_notify", argType = TInterface (Name {namespace = "GLib", name = "DestroyNotify"}), direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "destroy notifier for @user_data", sinceVersion = Nothing}, argScope = ScopeTypeAsync, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "jsc_context_push_exception_handler" jsc_context_push_exception_handler :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    FunPtr JavaScriptCore.Callbacks.C_ExceptionHandler -> -- handler : TInterface (Name {namespace = "JavaScriptCore", name = "ExceptionHandler"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy_notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

{- |
Push an exception handler in /@context@/. Whenever a JavaScript exception happens in
the 'GI.JavaScriptCore.Objects.Context.Context', the given /@handler@/ will be called. The default 'GI.JavaScriptCore.Callbacks.ExceptionHandler'
simply calls 'GI.JavaScriptCore.Objects.Context.contextThrowException' to throw the exception to the 'GI.JavaScriptCore.Objects.Context.Context'.
If you don\'t want to catch the exception, but only get notified about it, call
'GI.JavaScriptCore.Objects.Context.contextThrowException' in /@handler@/ like the default one does.
The last exception handler pushed is the only one used by the 'GI.JavaScriptCore.Objects.Context.Context', use
'GI.JavaScriptCore.Objects.Context.contextPopExceptionHandler' to remove it and set the previous one. When /@handler@/
is removed from the context, /@destroyNotify@/ i called with /@userData@/ as parameter.
-}
contextPushExceptionHandler ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> JavaScriptCore.Callbacks.ExceptionHandler
    {- ^ /@handler@/: a 'GI.JavaScriptCore.Callbacks.ExceptionHandler' -}
    -> m ()
contextPushExceptionHandler context handler = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    handler' <- JavaScriptCore.Callbacks.mk_ExceptionHandler (JavaScriptCore.Callbacks.wrap_ExceptionHandler Nothing (JavaScriptCore.Callbacks.drop_closures_ExceptionHandler handler))
    let userData = castFunPtrToPtr handler'
    let destroyNotify = safeFreeFunPtrPtr
    jsc_context_push_exception_handler context' handler' userData destroyNotify
    touchManagedPtr context
    return ()

#if ENABLE_OVERLOADING
data ContextPushExceptionHandlerMethodInfo
instance (signature ~ (JavaScriptCore.Callbacks.ExceptionHandler -> m ()), MonadIO m, IsContext a) => O.MethodInfo ContextPushExceptionHandlerMethodInfo a signature where
    overloadedMethod _ = contextPushExceptionHandler

#endif

-- method Context::register_class
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "name", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the class name", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "parent_class", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Class"}), direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "a #JSCClass or %NULL", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "vtable", argType = TInterface (Name {namespace = "JavaScriptCore", name = "ClassVTable"}), direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "an optional #JSCClassVTable or %NULL", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "destroy_notify", argType = TInterface (Name {namespace = "GLib", name = "DestroyNotify"}), direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "a destroy notifier for class instances", sinceVersion = Nothing}, argScope = ScopeTypeAsync, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Class"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_context_register_class" jsc_context_register_class :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    CString ->                              -- name : TBasicType TUTF8
    Ptr JavaScriptCore.Class.Class ->       -- parent_class : TInterface (Name {namespace = "JavaScriptCore", name = "Class"})
    Ptr JavaScriptCore.ClassVTable.ClassVTable -> -- vtable : TInterface (Name {namespace = "JavaScriptCore", name = "ClassVTable"})
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy_notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO (Ptr JavaScriptCore.Class.Class)

{- |
Register a custom class in /@context@/ using the given /@name@/. If the new class inherits from
another 'GI.JavaScriptCore.Objects.Class.Class', the parent should be passed as /@parentClass@/, otherwise 'Nothing' should be
used. The optional /@vtable@/ parameter allows to provide a custom implementation for handling
the class, for example, to handle external properties not added to the prototype.
When an instance of the 'GI.JavaScriptCore.Objects.Class.Class' is cleared in the context, /@destroyNotify@/ is called with
the instance as parameter.
-}
contextRegisterClass ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a, JavaScriptCore.Class.IsClass b) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> T.Text
    {- ^ /@name@/: the class name -}
    -> Maybe (b)
    {- ^ /@parentClass@/: a 'GI.JavaScriptCore.Objects.Class.Class' or 'Nothing' -}
    -> Maybe (JavaScriptCore.ClassVTable.ClassVTable)
    {- ^ /@vtable@/: an optional 'GI.JavaScriptCore.Structs.ClassVTable.ClassVTable' or 'Nothing' -}
    -> Maybe (GLib.Callbacks.DestroyNotify)
    {- ^ /@destroyNotify@/: a destroy notifier for class instances -}
    -> m JavaScriptCore.Class.Class
    {- ^ __Returns:__ a 'GI.JavaScriptCore.Objects.Class.Class' -}
contextRegisterClass context name parentClass vtable destroyNotify = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    name' <- textToCString name
    maybeParentClass <- case parentClass of
        Nothing -> return nullPtr
        Just jParentClass -> do
            jParentClass' <- unsafeManagedPtrCastPtr jParentClass
            return jParentClass'
    maybeVtable <- case vtable of
        Nothing -> return nullPtr
        Just jVtable -> do
            jVtable' <- unsafeManagedPtrGetPtr jVtable
            return jVtable'
    maybeDestroyNotify <- case destroyNotify of
        Nothing -> return (castPtrToFunPtr nullPtr)
        Just jDestroyNotify -> do
            ptrdestroyNotify <- callocMem :: IO (Ptr (FunPtr GLib.Callbacks.C_DestroyNotify))
            jDestroyNotify' <- GLib.Callbacks.mk_DestroyNotify (GLib.Callbacks.wrap_DestroyNotify (Just ptrdestroyNotify) jDestroyNotify)
            poke ptrdestroyNotify jDestroyNotify'
            return jDestroyNotify'
    result <- jsc_context_register_class context' name' maybeParentClass maybeVtable maybeDestroyNotify
    checkUnexpectedReturnNULL "contextRegisterClass" result
    result' <- (newObject JavaScriptCore.Class.Class) result
    touchManagedPtr context
    whenJust parentClass touchManagedPtr
    whenJust vtable touchManagedPtr
    freeMem name'
    return result'

#if ENABLE_OVERLOADING
data ContextRegisterClassMethodInfo
instance (signature ~ (T.Text -> Maybe (b) -> Maybe (JavaScriptCore.ClassVTable.ClassVTable) -> Maybe (GLib.Callbacks.DestroyNotify) -> m JavaScriptCore.Class.Class), MonadIO m, IsContext a, JavaScriptCore.Class.IsClass b) => O.MethodInfo ContextRegisterClassMethodInfo a signature where
    overloadedMethod _ = contextRegisterClass

#endif

-- method Context::set_value
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "name", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the value name", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "jsc_context_set_value" jsc_context_set_value :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    CString ->                              -- name : TBasicType TUTF8
    Ptr JavaScriptCore.Value.Value ->       -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    IO ()

{- |
Set a property of /@context@/ global object with /@name@/ and /@value@/.
-}
contextSetValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a, JavaScriptCore.Value.IsValue b) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> T.Text
    {- ^ /@name@/: the value name -}
    -> b
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> m ()
contextSetValue context name value = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    name' <- textToCString name
    value' <- unsafeManagedPtrCastPtr value
    jsc_context_set_value context' name' value'
    touchManagedPtr context
    touchManagedPtr value
    freeMem name'
    return ()

#if ENABLE_OVERLOADING
data ContextSetValueMethodInfo
instance (signature ~ (T.Text -> b -> m ()), MonadIO m, IsContext a, JavaScriptCore.Value.IsValue b) => O.MethodInfo ContextSetValueMethodInfo a signature where
    overloadedMethod _ = contextSetValue

#endif

-- method Context::throw
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "error_message", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "an error message", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "jsc_context_throw" jsc_context_throw :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    CString ->                              -- error_message : TBasicType TUTF8
    IO ()

{- |
Throw an exception to /@context@/ using the given error message. The created 'GI.JavaScriptCore.Objects.Exception.Exception'
can be retrieved with 'GI.JavaScriptCore.Objects.Context.contextGetException'.
-}
contextThrow ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> T.Text
    {- ^ /@errorMessage@/: an error message -}
    -> m ()
contextThrow context errorMessage = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    errorMessage' <- textToCString errorMessage
    jsc_context_throw context' errorMessage'
    touchManagedPtr context
    freeMem errorMessage'
    return ()

#if ENABLE_OVERLOADING
data ContextThrowMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsContext a) => O.MethodInfo ContextThrowMethodInfo a signature where
    overloadedMethod _ = contextThrow

#endif

-- method Context::throw_exception
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "exception", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Exception"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCException", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "jsc_context_throw_exception" jsc_context_throw_exception :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    Ptr JavaScriptCore.Exception.Exception -> -- exception : TInterface (Name {namespace = "JavaScriptCore", name = "Exception"})
    IO ()

{- |
Throw /@exception@/ to /@context@/.
-}
contextThrowException ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a, JavaScriptCore.Exception.IsException b) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> b
    {- ^ /@exception@/: a 'GI.JavaScriptCore.Objects.Exception.Exception' -}
    -> m ()
contextThrowException context exception = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    exception' <- unsafeManagedPtrCastPtr exception
    jsc_context_throw_exception context' exception'
    touchManagedPtr context
    touchManagedPtr exception
    return ()

#if ENABLE_OVERLOADING
data ContextThrowExceptionMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsContext a, JavaScriptCore.Exception.IsException b) => O.MethodInfo ContextThrowExceptionMethodInfo a signature where
    overloadedMethod _ = contextThrowException

#endif

-- method Context::throw_with_name
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "error_name", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the error name", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "error_message", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "an error message", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "jsc_context_throw_with_name" jsc_context_throw_with_name :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    CString ->                              -- error_name : TBasicType TUTF8
    CString ->                              -- error_message : TBasicType TUTF8
    IO ()

{- |
Throw an exception to /@context@/ using the given error name and message. The created 'GI.JavaScriptCore.Objects.Exception.Exception'
can be retrieved with 'GI.JavaScriptCore.Objects.Context.contextGetException'.
-}
contextThrowWithName ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> T.Text
    {- ^ /@errorName@/: the error name -}
    -> T.Text
    {- ^ /@errorMessage@/: an error message -}
    -> m ()
contextThrowWithName context errorName errorMessage = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    errorName' <- textToCString errorName
    errorMessage' <- textToCString errorMessage
    jsc_context_throw_with_name context' errorName' errorMessage'
    touchManagedPtr context
    freeMem errorName'
    freeMem errorMessage'
    return ()

#if ENABLE_OVERLOADING
data ContextThrowWithNameMethodInfo
instance (signature ~ (T.Text -> T.Text -> m ()), MonadIO m, IsContext a) => O.MethodInfo ContextThrowWithNameMethodInfo a signature where
    overloadedMethod _ = contextThrowWithName

#endif

-- method Context::get_current
-- method type : MemberFunction
-- Args : []
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Context"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_context_get_current" jsc_context_get_current :: 
    IO (Ptr Context)

{- |
Get the 'GI.JavaScriptCore.Objects.Context.Context' that is currently executing a function. This should only be
called within a function or method callback, otherwise 'Nothing' will be returned.
-}
contextGetCurrent ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m (Maybe Context)
    {- ^ __Returns:__ the 'GI.JavaScriptCore.Objects.Context.Context' that is currently executing. -}
contextGetCurrent  = liftIO $ do
    result <- jsc_context_get_current
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Context) result'
        return result''
    return maybeResult

#if ENABLE_OVERLOADING
#endif


