#define ENABLE_OVERLOADING (MIN_VERSION_haskell_gi_overloading(1,0,0) \
       && !defined(__HADDOCK_VERSION__))
module GI.JavaScriptCore.Objects.Context where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL

newtype Context = Context (ManagedPtr Context)
instance GObject Context where
class (GObject o, O.IsDescendantOf Context o) => IsContext o
instance (GObject o, O.IsDescendantOf Context o) => IsContext o
instance O.HasParentTypes Context
#if ENABLE_OVERLOADING
data ContextVirtualMachinePropertyInfo
#endif
#if ENABLE_OVERLOADING
data ContextCheckSyntaxMethodInfo
#endif
#if ENABLE_OVERLOADING
data ContextClearExceptionMethodInfo
#endif
#if ENABLE_OVERLOADING
data ContextEvaluateMethodInfo
#endif
#if ENABLE_OVERLOADING
data ContextEvaluateInObjectMethodInfo
#endif
#if ENABLE_OVERLOADING
data ContextEvaluateWithSourceUriMethodInfo
#endif
#if ENABLE_OVERLOADING
data ContextGetExceptionMethodInfo
#endif
#if ENABLE_OVERLOADING
data ContextGetGlobalObjectMethodInfo
#endif
#if ENABLE_OVERLOADING
data ContextGetValueMethodInfo
#endif
#if ENABLE_OVERLOADING
data ContextGetVirtualMachineMethodInfo
#endif
#if ENABLE_OVERLOADING
data ContextPopExceptionHandlerMethodInfo
#endif
#if ENABLE_OVERLOADING
data ContextPushExceptionHandlerMethodInfo
#endif
#if ENABLE_OVERLOADING
data ContextRegisterClassMethodInfo
#endif
#if ENABLE_OVERLOADING
data ContextSetValueMethodInfo
#endif
#if ENABLE_OVERLOADING
data ContextThrowMethodInfo
#endif
#if ENABLE_OVERLOADING
data ContextThrowExceptionMethodInfo
#endif
#if ENABLE_OVERLOADING
data ContextThrowWithNameMethodInfo
#endif
