

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (inaki@blueleaf.cc)

/No description available in the introspection data./
-}

#define ENABLE_OVERLOADING (MIN_VERSION_haskell_gi_overloading(1,0,0) \
       && !defined(__HADDOCK_VERSION__))

module GI.JavaScriptCore.Objects.Exception
    ( 

-- * Exported types
    Exception(..)                           ,
    IsException                             ,
    toException                             ,
    noException                             ,


 -- * Methods
-- ** getBacktraceString #method:getBacktraceString#

#if ENABLE_OVERLOADING
    ExceptionGetBacktraceStringMethodInfo   ,
#endif
    exceptionGetBacktraceString             ,


-- ** getColumnNumber #method:getColumnNumber#

#if ENABLE_OVERLOADING
    ExceptionGetColumnNumberMethodInfo      ,
#endif
    exceptionGetColumnNumber                ,


-- ** getLineNumber #method:getLineNumber#

#if ENABLE_OVERLOADING
    ExceptionGetLineNumberMethodInfo        ,
#endif
    exceptionGetLineNumber                  ,


-- ** getMessage #method:getMessage#

#if ENABLE_OVERLOADING
    ExceptionGetMessageMethodInfo           ,
#endif
    exceptionGetMessage                     ,


-- ** getName #method:getName#

#if ENABLE_OVERLOADING
    ExceptionGetNameMethodInfo              ,
#endif
    exceptionGetName                        ,


-- ** getSourceUri #method:getSourceUri#

#if ENABLE_OVERLOADING
    ExceptionGetSourceUriMethodInfo         ,
#endif
    exceptionGetSourceUri                   ,


-- ** new #method:new#

    exceptionNew                            ,


-- ** newWithName #method:newWithName#

    exceptionNewWithName                    ,


-- ** report #method:report#

#if ENABLE_OVERLOADING
    ExceptionReportMethodInfo               ,
#endif
    exceptionReport                         ,


-- ** toString #method:toString#

#if ENABLE_OVERLOADING
    ExceptionToStringMethodInfo             ,
#endif
    exceptionToString                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL

import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.JavaScriptCore.Objects.Context as JavaScriptCore.Context

-- | Memory-managed wrapper type.
newtype Exception = Exception (ManagedPtr Exception)
foreign import ccall "jsc_exception_get_type"
    c_jsc_exception_get_type :: IO GType

instance GObject Exception where
    gobjectType = c_jsc_exception_get_type
    

-- | Type class for types which can be safely cast to `Exception`, for instance with `toException`.
class (GObject o, O.IsDescendantOf Exception o) => IsException o
instance (GObject o, O.IsDescendantOf Exception o) => IsException o

instance O.HasParentTypes Exception
type instance O.ParentTypes Exception = '[GObject.Object.Object]

-- | Cast to `Exception`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toException :: (MonadIO m, IsException o) => o -> m Exception
toException = liftIO . unsafeCastTo Exception

-- | A convenience alias for `Nothing` :: `Maybe` `Exception`.
noException :: Maybe Exception
noException = Nothing

#if ENABLE_OVERLOADING
type family ResolveExceptionMethod (t :: Symbol) (o :: *) :: * where
    ResolveExceptionMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveExceptionMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveExceptionMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveExceptionMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveExceptionMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveExceptionMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveExceptionMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveExceptionMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveExceptionMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveExceptionMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveExceptionMethod "report" o = ExceptionReportMethodInfo
    ResolveExceptionMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveExceptionMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveExceptionMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveExceptionMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveExceptionMethod "toString" o = ExceptionToStringMethodInfo
    ResolveExceptionMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveExceptionMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveExceptionMethod "getBacktraceString" o = ExceptionGetBacktraceStringMethodInfo
    ResolveExceptionMethod "getColumnNumber" o = ExceptionGetColumnNumberMethodInfo
    ResolveExceptionMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveExceptionMethod "getLineNumber" o = ExceptionGetLineNumberMethodInfo
    ResolveExceptionMethod "getMessage" o = ExceptionGetMessageMethodInfo
    ResolveExceptionMethod "getName" o = ExceptionGetNameMethodInfo
    ResolveExceptionMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveExceptionMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveExceptionMethod "getSourceUri" o = ExceptionGetSourceUriMethodInfo
    ResolveExceptionMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveExceptionMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveExceptionMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveExceptionMethod t Exception, O.MethodInfo info Exception p) => OL.IsLabel t (Exception -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod (O.MethodProxy :: O.MethodProxy info)
#else
    fromLabel _ = O.overloadedMethod (O.MethodProxy :: O.MethodProxy info)
#endif

#endif

#if ENABLE_OVERLOADING
instance O.HasAttributeList Exception
type instance O.AttributeList Exception = ExceptionAttributeList
type ExceptionAttributeList = ('[ ] :: [(Symbol, *)])
#endif

#if ENABLE_OVERLOADING
#endif

#if ENABLE_OVERLOADING
type instance O.SignalList Exception = ExceptionSignalList
type ExceptionSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, *)])

#endif

-- method Exception::new
-- method type : Constructor
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "message", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the error message", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Exception"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_exception_new" jsc_exception_new :: 
    Ptr JavaScriptCore.Context.Context ->   -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    CString ->                              -- message : TBasicType TUTF8
    IO (Ptr Exception)

{- |
Create a new 'GI.JavaScriptCore.Objects.Exception.Exception' in /@context@/ with /@message@/.
-}
exceptionNew ::
    (B.CallStack.HasCallStack, MonadIO m, JavaScriptCore.Context.IsContext a) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> T.Text
    {- ^ /@message@/: the error message -}
    -> m Exception
    {- ^ __Returns:__ a new 'GI.JavaScriptCore.Objects.Exception.Exception'. -}
exceptionNew context message = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    message' <- textToCString message
    result <- jsc_exception_new context' message'
    checkUnexpectedReturnNULL "exceptionNew" result
    result' <- (wrapObject Exception) result
    touchManagedPtr context
    freeMem message'
    return result'

#if ENABLE_OVERLOADING
#endif

-- method Exception::new_with_name
-- method type : Constructor
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "name", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the error name", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "message", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the error message", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Exception"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_exception_new_with_name" jsc_exception_new_with_name :: 
    Ptr JavaScriptCore.Context.Context ->   -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- message : TBasicType TUTF8
    IO (Ptr Exception)

{- |
Create a new 'GI.JavaScriptCore.Objects.Exception.Exception' in /@context@/ with /@name@/ and /@message@/.
-}
exceptionNewWithName ::
    (B.CallStack.HasCallStack, MonadIO m, JavaScriptCore.Context.IsContext a) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> T.Text
    {- ^ /@name@/: the error name -}
    -> T.Text
    {- ^ /@message@/: the error message -}
    -> m Exception
    {- ^ __Returns:__ a new 'GI.JavaScriptCore.Objects.Exception.Exception'. -}
exceptionNewWithName context name message = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    name' <- textToCString name
    message' <- textToCString message
    result <- jsc_exception_new_with_name context' name' message'
    checkUnexpectedReturnNULL "exceptionNewWithName" result
    result' <- (wrapObject Exception) result
    touchManagedPtr context
    freeMem name'
    freeMem message'
    return result'

#if ENABLE_OVERLOADING
#endif

-- method Exception::get_backtrace_string
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "exception", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Exception"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCException", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "jsc_exception_get_backtrace_string" jsc_exception_get_backtrace_string :: 
    Ptr Exception ->                        -- exception : TInterface (Name {namespace = "JavaScriptCore", name = "Exception"})
    IO CString

{- |
Get a string with the exception backtrace.
-}
exceptionGetBacktraceString ::
    (B.CallStack.HasCallStack, MonadIO m, IsException a) =>
    a
    {- ^ /@exception@/: a 'GI.JavaScriptCore.Objects.Exception.Exception' -}
    -> m (Maybe T.Text)
    {- ^ __Returns:__ the exception backtrace string or 'Nothing'. -}
exceptionGetBacktraceString exception = liftIO $ do
    exception' <- unsafeManagedPtrCastPtr exception
    result <- jsc_exception_get_backtrace_string exception'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr exception
    return maybeResult

#if ENABLE_OVERLOADING
data ExceptionGetBacktraceStringMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsException a) => O.MethodInfo ExceptionGetBacktraceStringMethodInfo a signature where
    overloadedMethod _ = exceptionGetBacktraceString

#endif

-- method Exception::get_column_number
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "exception", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Exception"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCException", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "jsc_exception_get_column_number" jsc_exception_get_column_number :: 
    Ptr Exception ->                        -- exception : TInterface (Name {namespace = "JavaScriptCore", name = "Exception"})
    IO Word32

{- |
Get the column number at which /@exception@/ happened.
-}
exceptionGetColumnNumber ::
    (B.CallStack.HasCallStack, MonadIO m, IsException a) =>
    a
    {- ^ /@exception@/: a 'GI.JavaScriptCore.Objects.Exception.Exception' -}
    -> m Word32
    {- ^ __Returns:__ the column number of /@exception@/. -}
exceptionGetColumnNumber exception = liftIO $ do
    exception' <- unsafeManagedPtrCastPtr exception
    result <- jsc_exception_get_column_number exception'
    touchManagedPtr exception
    return result

#if ENABLE_OVERLOADING
data ExceptionGetColumnNumberMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsException a) => O.MethodInfo ExceptionGetColumnNumberMethodInfo a signature where
    overloadedMethod _ = exceptionGetColumnNumber

#endif

-- method Exception::get_line_number
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "exception", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Exception"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCException", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "jsc_exception_get_line_number" jsc_exception_get_line_number :: 
    Ptr Exception ->                        -- exception : TInterface (Name {namespace = "JavaScriptCore", name = "Exception"})
    IO Word32

{- |
Get the line number at which /@exception@/ happened.
-}
exceptionGetLineNumber ::
    (B.CallStack.HasCallStack, MonadIO m, IsException a) =>
    a
    {- ^ /@exception@/: a 'GI.JavaScriptCore.Objects.Exception.Exception' -}
    -> m Word32
    {- ^ __Returns:__ the line number of /@exception@/. -}
exceptionGetLineNumber exception = liftIO $ do
    exception' <- unsafeManagedPtrCastPtr exception
    result <- jsc_exception_get_line_number exception'
    touchManagedPtr exception
    return result

#if ENABLE_OVERLOADING
data ExceptionGetLineNumberMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsException a) => O.MethodInfo ExceptionGetLineNumberMethodInfo a signature where
    overloadedMethod _ = exceptionGetLineNumber

#endif

-- method Exception::get_message
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "exception", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Exception"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCException", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "jsc_exception_get_message" jsc_exception_get_message :: 
    Ptr Exception ->                        -- exception : TInterface (Name {namespace = "JavaScriptCore", name = "Exception"})
    IO CString

{- |
Get the error message of /@exception@/.
-}
exceptionGetMessage ::
    (B.CallStack.HasCallStack, MonadIO m, IsException a) =>
    a
    {- ^ /@exception@/: a 'GI.JavaScriptCore.Objects.Exception.Exception' -}
    -> m T.Text
    {- ^ __Returns:__ the /@exception@/ error message. -}
exceptionGetMessage exception = liftIO $ do
    exception' <- unsafeManagedPtrCastPtr exception
    result <- jsc_exception_get_message exception'
    checkUnexpectedReturnNULL "exceptionGetMessage" result
    result' <- cstringToText result
    touchManagedPtr exception
    return result'

#if ENABLE_OVERLOADING
data ExceptionGetMessageMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsException a) => O.MethodInfo ExceptionGetMessageMethodInfo a signature where
    overloadedMethod _ = exceptionGetMessage

#endif

-- method Exception::get_name
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "exception", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Exception"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCException", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "jsc_exception_get_name" jsc_exception_get_name :: 
    Ptr Exception ->                        -- exception : TInterface (Name {namespace = "JavaScriptCore", name = "Exception"})
    IO CString

{- |
Get the error name of /@exception@/
-}
exceptionGetName ::
    (B.CallStack.HasCallStack, MonadIO m, IsException a) =>
    a
    {- ^ /@exception@/: a 'GI.JavaScriptCore.Objects.Exception.Exception' -}
    -> m T.Text
    {- ^ __Returns:__ the /@exception@/ error name. -}
exceptionGetName exception = liftIO $ do
    exception' <- unsafeManagedPtrCastPtr exception
    result <- jsc_exception_get_name exception'
    checkUnexpectedReturnNULL "exceptionGetName" result
    result' <- cstringToText result
    touchManagedPtr exception
    return result'

#if ENABLE_OVERLOADING
data ExceptionGetNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsException a) => O.MethodInfo ExceptionGetNameMethodInfo a signature where
    overloadedMethod _ = exceptionGetName

#endif

-- method Exception::get_source_uri
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "exception", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Exception"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCException", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "jsc_exception_get_source_uri" jsc_exception_get_source_uri :: 
    Ptr Exception ->                        -- exception : TInterface (Name {namespace = "JavaScriptCore", name = "Exception"})
    IO CString

{- |
Get the source URI of /@exception@/.
-}
exceptionGetSourceUri ::
    (B.CallStack.HasCallStack, MonadIO m, IsException a) =>
    a
    {- ^ /@exception@/: a 'GI.JavaScriptCore.Objects.Exception.Exception' -}
    -> m (Maybe T.Text)
    {- ^ __Returns:__ the the source URI of /@exception@/, or 'Nothing'. -}
exceptionGetSourceUri exception = liftIO $ do
    exception' <- unsafeManagedPtrCastPtr exception
    result <- jsc_exception_get_source_uri exception'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr exception
    return maybeResult

#if ENABLE_OVERLOADING
data ExceptionGetSourceUriMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsException a) => O.MethodInfo ExceptionGetSourceUriMethodInfo a signature where
    overloadedMethod _ = exceptionGetSourceUri

#endif

-- method Exception::report
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "exception", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Exception"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCException", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "jsc_exception_report" jsc_exception_report :: 
    Ptr Exception ->                        -- exception : TInterface (Name {namespace = "JavaScriptCore", name = "Exception"})
    IO CString

{- |
Return a report message of /@exception@/, containing all the possible details such us
source URI, line, column and backtrace, and formatted to be printed.
-}
exceptionReport ::
    (B.CallStack.HasCallStack, MonadIO m, IsException a) =>
    a
    {- ^ /@exception@/: a 'GI.JavaScriptCore.Objects.Exception.Exception' -}
    -> m T.Text
    {- ^ __Returns:__ a new string with the exception report -}
exceptionReport exception = liftIO $ do
    exception' <- unsafeManagedPtrCastPtr exception
    result <- jsc_exception_report exception'
    checkUnexpectedReturnNULL "exceptionReport" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr exception
    return result'

#if ENABLE_OVERLOADING
data ExceptionReportMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsException a) => O.MethodInfo ExceptionReportMethodInfo a signature where
    overloadedMethod _ = exceptionReport

#endif

-- method Exception::to_string
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "exception", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Exception"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCException", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "jsc_exception_to_string" jsc_exception_to_string :: 
    Ptr Exception ->                        -- exception : TInterface (Name {namespace = "JavaScriptCore", name = "Exception"})
    IO CString

{- |
Get the string representation of /@exception@/ error.
-}
exceptionToString ::
    (B.CallStack.HasCallStack, MonadIO m, IsException a) =>
    a
    {- ^ /@exception@/: a 'GI.JavaScriptCore.Objects.Exception.Exception' -}
    -> m T.Text
    {- ^ __Returns:__ the string representation of /@exception@/. -}
exceptionToString exception = liftIO $ do
    exception' <- unsafeManagedPtrCastPtr exception
    result <- jsc_exception_to_string exception'
    checkUnexpectedReturnNULL "exceptionToString" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr exception
    return result'

#if ENABLE_OVERLOADING
data ExceptionToStringMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsException a) => O.MethodInfo ExceptionToStringMethodInfo a signature where
    overloadedMethod _ = exceptionToString

#endif


