

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (inaki@blueleaf.cc)

/No description available in the introspection data./
-}

#define ENABLE_OVERLOADING (MIN_VERSION_haskell_gi_overloading(1,0,0) \
       && !defined(__HADDOCK_VERSION__))

module GI.JavaScriptCore.Objects.Value
    ( 

-- * Exported types
    Value(..)                               ,
    IsValue                                 ,
    toValue                                 ,
    noValue                                 ,


 -- * Methods
-- ** constructorCall #method:constructorCall#

#if ENABLE_OVERLOADING
    ValueConstructorCallMethodInfo          ,
#endif
    valueConstructorCall                    ,


-- ** functionCall #method:functionCall#

#if ENABLE_OVERLOADING
    ValueFunctionCallMethodInfo             ,
#endif
    valueFunctionCall                       ,


-- ** getContext #method:getContext#

#if ENABLE_OVERLOADING
    ValueGetContextMethodInfo               ,
#endif
    valueGetContext                         ,


-- ** isArray #method:isArray#

#if ENABLE_OVERLOADING
    ValueIsArrayMethodInfo                  ,
#endif
    valueIsArray                            ,


-- ** isBoolean #method:isBoolean#

#if ENABLE_OVERLOADING
    ValueIsBooleanMethodInfo                ,
#endif
    valueIsBoolean                          ,


-- ** isConstructor #method:isConstructor#

#if ENABLE_OVERLOADING
    ValueIsConstructorMethodInfo            ,
#endif
    valueIsConstructor                      ,


-- ** isFunction #method:isFunction#

#if ENABLE_OVERLOADING
    ValueIsFunctionMethodInfo               ,
#endif
    valueIsFunction                         ,


-- ** isNull #method:isNull#

#if ENABLE_OVERLOADING
    ValueIsNullMethodInfo                   ,
#endif
    valueIsNull                             ,


-- ** isNumber #method:isNumber#

#if ENABLE_OVERLOADING
    ValueIsNumberMethodInfo                 ,
#endif
    valueIsNumber                           ,


-- ** isObject #method:isObject#

#if ENABLE_OVERLOADING
    ValueIsObjectMethodInfo                 ,
#endif
    valueIsObject                           ,


-- ** isString #method:isString#

#if ENABLE_OVERLOADING
    ValueIsStringMethodInfo                 ,
#endif
    valueIsString                           ,


-- ** isUndefined #method:isUndefined#

#if ENABLE_OVERLOADING
    ValueIsUndefinedMethodInfo              ,
#endif
    valueIsUndefined                        ,


-- ** newArrayFromGarray #method:newArrayFromGarray#

    valueNewArrayFromGarray                 ,


-- ** newArrayFromStrv #method:newArrayFromStrv#

    valueNewArrayFromStrv                   ,


-- ** newBoolean #method:newBoolean#

    valueNewBoolean                         ,


-- ** newFunction #method:newFunction#

    valueNewFunction                        ,


-- ** newFunctionVariadic #method:newFunctionVariadic#

    valueNewFunctionVariadic                ,


-- ** newNull #method:newNull#

    valueNewNull                            ,


-- ** newNumber #method:newNumber#

    valueNewNumber                          ,


-- ** newObject #method:newObject#

    valueNewObject                          ,


-- ** newString #method:newString#

    valueNewString                          ,


-- ** newStringFromBytes #method:newStringFromBytes#

    valueNewStringFromBytes                 ,


-- ** newUndefined #method:newUndefined#

    valueNewUndefined                       ,


-- ** objectDefinePropertyAccessor #method:objectDefinePropertyAccessor#

#if ENABLE_OVERLOADING
    ValueObjectDefinePropertyAccessorMethodInfo,
#endif
    valueObjectDefinePropertyAccessor       ,


-- ** objectDefinePropertyData #method:objectDefinePropertyData#

#if ENABLE_OVERLOADING
    ValueObjectDefinePropertyDataMethodInfo ,
#endif
    valueObjectDefinePropertyData           ,


-- ** objectDeleteProperty #method:objectDeleteProperty#

#if ENABLE_OVERLOADING
    ValueObjectDeletePropertyMethodInfo     ,
#endif
    valueObjectDeleteProperty               ,


-- ** objectEnumerateProperties #method:objectEnumerateProperties#

#if ENABLE_OVERLOADING
    ValueObjectEnumeratePropertiesMethodInfo,
#endif
    valueObjectEnumerateProperties          ,


-- ** objectGetProperty #method:objectGetProperty#

#if ENABLE_OVERLOADING
    ValueObjectGetPropertyMethodInfo        ,
#endif
    valueObjectGetProperty                  ,


-- ** objectGetPropertyAtIndex #method:objectGetPropertyAtIndex#

#if ENABLE_OVERLOADING
    ValueObjectGetPropertyAtIndexMethodInfo ,
#endif
    valueObjectGetPropertyAtIndex           ,


-- ** objectHasProperty #method:objectHasProperty#

#if ENABLE_OVERLOADING
    ValueObjectHasPropertyMethodInfo        ,
#endif
    valueObjectHasProperty                  ,


-- ** objectInvokeMethod #method:objectInvokeMethod#

#if ENABLE_OVERLOADING
    ValueObjectInvokeMethodMethodInfo       ,
#endif
    valueObjectInvokeMethod                 ,


-- ** objectIsInstanceOf #method:objectIsInstanceOf#

#if ENABLE_OVERLOADING
    ValueObjectIsInstanceOfMethodInfo       ,
#endif
    valueObjectIsInstanceOf                 ,


-- ** objectSetProperty #method:objectSetProperty#

#if ENABLE_OVERLOADING
    ValueObjectSetPropertyMethodInfo        ,
#endif
    valueObjectSetProperty                  ,


-- ** objectSetPropertyAtIndex #method:objectSetPropertyAtIndex#

#if ENABLE_OVERLOADING
    ValueObjectSetPropertyAtIndexMethodInfo ,
#endif
    valueObjectSetPropertyAtIndex           ,


-- ** toBoolean #method:toBoolean#

#if ENABLE_OVERLOADING
    ValueToBooleanMethodInfo                ,
#endif
    valueToBoolean                          ,


-- ** toDouble #method:toDouble#

#if ENABLE_OVERLOADING
    ValueToDoubleMethodInfo                 ,
#endif
    valueToDouble                           ,


-- ** toInt32 #method:toInt32#

#if ENABLE_OVERLOADING
    ValueToInt32MethodInfo                  ,
#endif
    valueToInt32                            ,


-- ** toString #method:toString#

#if ENABLE_OVERLOADING
    ValueToStringMethodInfo                 ,
#endif
    valueToString                           ,


-- ** toStringAsBytes #method:toStringAsBytes#

#if ENABLE_OVERLOADING
    ValueToStringAsBytesMethodInfo          ,
#endif
    valueToStringAsBytes                    ,




 -- * Properties
-- ** context #attr:context#
{- | The 'GI.JavaScriptCore.Objects.Context.Context' in which the value was created.
-}
#if ENABLE_OVERLOADING
    ValueContextPropertyInfo                ,
#endif
    constructValueContext                   ,
    getValueContext                         ,
#if ENABLE_OVERLOADING
    valueContext                            ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL

import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.JavaScriptCore.Flags as JavaScriptCore.Flags
import {-# SOURCE #-} qualified GI.JavaScriptCore.Objects.Class as JavaScriptCore.Class
import {-# SOURCE #-} qualified GI.JavaScriptCore.Objects.Context as JavaScriptCore.Context

-- | Memory-managed wrapper type.
newtype Value = Value (ManagedPtr Value)
foreign import ccall "jsc_value_get_type"
    c_jsc_value_get_type :: IO GType

instance GObject Value where
    gobjectType = c_jsc_value_get_type
    

-- | Type class for types which can be safely cast to `Value`, for instance with `toValue`.
class (GObject o, O.IsDescendantOf Value o) => IsValue o
instance (GObject o, O.IsDescendantOf Value o) => IsValue o

instance O.HasParentTypes Value
type instance O.ParentTypes Value = '[GObject.Object.Object]

-- | Cast to `Value`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toValue :: (MonadIO m, IsValue o) => o -> m Value
toValue = liftIO . unsafeCastTo Value

-- | A convenience alias for `Nothing` :: `Maybe` `Value`.
noValue :: Maybe Value
noValue = Nothing

#if ENABLE_OVERLOADING
type family ResolveValueMethod (t :: Symbol) (o :: *) :: * where
    ResolveValueMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveValueMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveValueMethod "constructorCall" o = ValueConstructorCallMethodInfo
    ResolveValueMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveValueMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveValueMethod "functionCall" o = ValueFunctionCallMethodInfo
    ResolveValueMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveValueMethod "isArray" o = ValueIsArrayMethodInfo
    ResolveValueMethod "isBoolean" o = ValueIsBooleanMethodInfo
    ResolveValueMethod "isConstructor" o = ValueIsConstructorMethodInfo
    ResolveValueMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveValueMethod "isFunction" o = ValueIsFunctionMethodInfo
    ResolveValueMethod "isNull" o = ValueIsNullMethodInfo
    ResolveValueMethod "isNumber" o = ValueIsNumberMethodInfo
    ResolveValueMethod "isObject" o = ValueIsObjectMethodInfo
    ResolveValueMethod "isString" o = ValueIsStringMethodInfo
    ResolveValueMethod "isUndefined" o = ValueIsUndefinedMethodInfo
    ResolveValueMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveValueMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveValueMethod "objectDefinePropertyAccessor" o = ValueObjectDefinePropertyAccessorMethodInfo
    ResolveValueMethod "objectDefinePropertyData" o = ValueObjectDefinePropertyDataMethodInfo
    ResolveValueMethod "objectDeleteProperty" o = ValueObjectDeletePropertyMethodInfo
    ResolveValueMethod "objectEnumerateProperties" o = ValueObjectEnumeratePropertiesMethodInfo
    ResolveValueMethod "objectGetProperty" o = ValueObjectGetPropertyMethodInfo
    ResolveValueMethod "objectGetPropertyAtIndex" o = ValueObjectGetPropertyAtIndexMethodInfo
    ResolveValueMethod "objectHasProperty" o = ValueObjectHasPropertyMethodInfo
    ResolveValueMethod "objectInvokeMethod" o = ValueObjectInvokeMethodMethodInfo
    ResolveValueMethod "objectIsInstanceOf" o = ValueObjectIsInstanceOfMethodInfo
    ResolveValueMethod "objectSetProperty" o = ValueObjectSetPropertyMethodInfo
    ResolveValueMethod "objectSetPropertyAtIndex" o = ValueObjectSetPropertyAtIndexMethodInfo
    ResolveValueMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveValueMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveValueMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveValueMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveValueMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveValueMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveValueMethod "toBoolean" o = ValueToBooleanMethodInfo
    ResolveValueMethod "toDouble" o = ValueToDoubleMethodInfo
    ResolveValueMethod "toInt32" o = ValueToInt32MethodInfo
    ResolveValueMethod "toString" o = ValueToStringMethodInfo
    ResolveValueMethod "toStringAsBytes" o = ValueToStringAsBytesMethodInfo
    ResolveValueMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveValueMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveValueMethod "getContext" o = ValueGetContextMethodInfo
    ResolveValueMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveValueMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveValueMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveValueMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveValueMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveValueMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveValueMethod t Value, O.MethodInfo info Value p) => OL.IsLabel t (Value -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod (O.MethodProxy :: O.MethodProxy info)
#else
    fromLabel _ = O.overloadedMethod (O.MethodProxy :: O.MethodProxy info)
#endif

#endif

-- VVV Prop "context"
   -- Type: TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

{- |
Get the value of the “@context@” property.
When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to

@
'Data.GI.Base.Attributes.get' value #context
@
-}
getValueContext :: (MonadIO m, IsValue o) => o -> m JavaScriptCore.Context.Context
getValueContext obj = liftIO $ checkUnexpectedNothing "getValueContext" $ B.Properties.getObjectPropertyObject obj "context" JavaScriptCore.Context.Context

{- |
Construct a `GValueConstruct` with valid value for the “@context@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
-}
constructValueContext :: (IsValue o, JavaScriptCore.Context.IsContext a) => a -> IO (GValueConstruct o)
constructValueContext val = B.Properties.constructObjectPropertyObject "context" (Just val)

#if ENABLE_OVERLOADING
data ValueContextPropertyInfo
instance AttrInfo ValueContextPropertyInfo where
    type AttrAllowedOps ValueContextPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ValueContextPropertyInfo = JavaScriptCore.Context.IsContext
    type AttrBaseTypeConstraint ValueContextPropertyInfo = IsValue
    type AttrGetType ValueContextPropertyInfo = JavaScriptCore.Context.Context
    type AttrLabel ValueContextPropertyInfo = "context"
    type AttrOrigin ValueContextPropertyInfo = Value
    attrGet _ = getValueContext
    attrSet _ = undefined
    attrConstruct _ = constructValueContext
    attrClear _ = undefined
#endif

#if ENABLE_OVERLOADING
instance O.HasAttributeList Value
type instance O.AttributeList Value = ValueAttributeList
type ValueAttributeList = ('[ '("context", ValueContextPropertyInfo)] :: [(Symbol, *)])
#endif

#if ENABLE_OVERLOADING
valueContext :: AttrLabelProxy "context"
valueContext = AttrLabelProxy

#endif

#if ENABLE_OVERLOADING
type instance O.SignalList Value = ValueSignalList
type ValueSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, *)])

#endif

-- method Value::new_array_from_garray
-- method type : Constructor
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "array", argType = TPtrArray (TInterface (Name {namespace = "JavaScriptCore", name = "Value"})), direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "a #GPtrArray", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_new_array_from_garray" jsc_value_new_array_from_garray :: 
    Ptr JavaScriptCore.Context.Context ->   -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    Ptr (GPtrArray (Ptr Value)) ->          -- array : TPtrArray (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
    IO (Ptr Value)

{- |
Create a new 'GI.JavaScriptCore.Objects.Value.Value' referencing an array with the items from /@array@/. If /@array@/
is 'Nothing' or empty a new empty array will be created. Elements of /@array@/ should be
pointers to a 'GI.JavaScriptCore.Objects.Value.Value'.
-}
valueNewArrayFromGarray ::
    (B.CallStack.HasCallStack, MonadIO m, JavaScriptCore.Context.IsContext a) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> Maybe ([Value])
    {- ^ /@array@/: a 'GI.GLib.Structs.PtrArray.PtrArray' -}
    -> m Value
    {- ^ __Returns:__ a 'GI.JavaScriptCore.Objects.Value.Value'. -}
valueNewArrayFromGarray context array = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    maybeArray <- case array of
        Nothing -> return nullPtr
        Just jArray -> do
            jArray' <- mapM unsafeManagedPtrCastPtr jArray
            jArray'' <- packGPtrArray jArray'
            return jArray''
    result <- jsc_value_new_array_from_garray context' maybeArray
    checkUnexpectedReturnNULL "valueNewArrayFromGarray" result
    result' <- (wrapObject Value) result
    touchManagedPtr context
    whenJust array (mapM_ touchManagedPtr)
    unrefPtrArray maybeArray
    return result'

#if ENABLE_OVERLOADING
#endif

-- method Value::new_array_from_strv
-- method type : Constructor
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "strv", argType = TCArray True (-1) (-1) (TBasicType TUTF8), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a %NULL-terminated array of strings", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_new_array_from_strv" jsc_value_new_array_from_strv :: 
    Ptr JavaScriptCore.Context.Context ->   -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    Ptr CString ->                          -- strv : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO (Ptr Value)

{- |
Create a new 'GI.JavaScriptCore.Objects.Value.Value' referencing an array of strings with the items from /@strv@/. If /@array@/
is 'Nothing' or empty a new empty array will be created.
-}
valueNewArrayFromStrv ::
    (B.CallStack.HasCallStack, MonadIO m, JavaScriptCore.Context.IsContext a) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> [T.Text]
    {- ^ /@strv@/: a 'Nothing'-terminated array of strings -}
    -> m Value
    {- ^ __Returns:__ a 'GI.JavaScriptCore.Objects.Value.Value'. -}
valueNewArrayFromStrv context strv = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    strv' <- packZeroTerminatedUTF8CArray strv
    result <- jsc_value_new_array_from_strv context' strv'
    checkUnexpectedReturnNULL "valueNewArrayFromStrv" result
    result' <- (wrapObject Value) result
    touchManagedPtr context
    mapZeroTerminatedCArray freeMem strv'
    freeMem strv'
    return result'

#if ENABLE_OVERLOADING
#endif

-- method Value::new_boolean
-- method type : Constructor
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "value", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #gboolean", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_new_boolean" jsc_value_new_boolean :: 
    Ptr JavaScriptCore.Context.Context ->   -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    CInt ->                                 -- value : TBasicType TBoolean
    IO (Ptr Value)

{- |
Create a new 'GI.JavaScriptCore.Objects.Value.Value' from /@value@/
-}
valueNewBoolean ::
    (B.CallStack.HasCallStack, MonadIO m, JavaScriptCore.Context.IsContext a) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> Bool
    {- ^ /@value@/: a 'Bool' -}
    -> m Value
    {- ^ __Returns:__ a 'GI.JavaScriptCore.Objects.Value.Value'. -}
valueNewBoolean context value = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    let value' = (fromIntegral . fromEnum) value
    result <- jsc_value_new_boolean context' value'
    checkUnexpectedReturnNULL "valueNewBoolean" result
    result' <- (wrapObject Value) result
    touchManagedPtr context
    return result'

#if ENABLE_OVERLOADING
#endif

-- method Value::new_function_variadic
-- method type : Constructor
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "name", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "the function name or %NULL", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "callback", argType = TInterface (Name {namespace = "GObject", name = "Callback"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #GCallback.", sinceVersion = Nothing}, argScope = ScopeTypeNotified, argClosure = 3, argDestroy = 4, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "user_data", argType = TBasicType TPtr, direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "user data to pass to @callback.", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "destroy_notify", argType = TInterface (Name {namespace = "GLib", name = "DestroyNotify"}), direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "destroy notifier for @user_data", sinceVersion = Nothing}, argScope = ScopeTypeAsync, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "return_type", argType = TBasicType TGType, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the #GType of the function return value, or %G_TYPE_NONE if the function is void.", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_new_function_variadic" jsc_value_new_function_variadic :: 
    Ptr JavaScriptCore.Context.Context ->   -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    CString ->                              -- name : TBasicType TUTF8
    FunPtr GObject.Callbacks.C_Callback ->  -- callback : TInterface (Name {namespace = "GObject", name = "Callback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy_notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    CGType ->                               -- return_type : TBasicType TGType
    IO (Ptr Value)

{- |
Create a function in /@context@/. If /@name@/ is 'Nothing' an anonymous function will be created.
When the function is called by JavaScript or @/jsc_value_function_call()/@, /@callback@/ is called
receiving an 'GI.GLib.Structs.PtrArray.PtrArray' of 'GI.JavaScriptCore.Objects.Value.Value'\<!-- -->s with the arguments and then /@userData@/ as last parameter.
When the function is cleared in /@context@/, /@destroyNotify@/ is called with /@userData@/ as parameter.

Note that the value returned by /@callback@/ must be fully transferred. In case of boxed types, you could use
@/G_TYPE_POINTER/@ instead of the actual boxed 'GType' to ensure that the instance owned by 'GI.JavaScriptCore.Objects.Class.Class' is used.
If you really want to return a new copy of the boxed type, use @/JSC_TYPE_VALUE/@ and return a 'GI.JavaScriptCore.Objects.Value.Value' created
with 'GI.JavaScriptCore.Objects.Value.valueNewObject' that receives the copy as instance parameter.
-}
valueNewFunctionVariadic ::
    (B.CallStack.HasCallStack, MonadIO m, JavaScriptCore.Context.IsContext a) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> Maybe (T.Text)
    {- ^ /@name@/: the function name or 'Nothing' -}
    -> GObject.Callbacks.Callback
    {- ^ /@callback@/: a 'GI.GObject.Callbacks.Callback'. -}
    -> GType
    {- ^ /@returnType@/: the 'GType' of the function return value, or @/G_TYPE_NONE/@ if the function is void. -}
    -> m Value
    {- ^ __Returns:__ a 'GI.JavaScriptCore.Objects.Value.Value'. -}
valueNewFunctionVariadic context name callback returnType = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    maybeName <- case name of
        Nothing -> return nullPtr
        Just jName -> do
            jName' <- textToCString jName
            return jName'
    callback' <- GObject.Callbacks.mk_Callback (GObject.Callbacks.wrap_Callback Nothing callback)
    let returnType' = gtypeToCGType returnType
    let userData = castFunPtrToPtr callback'
    let destroyNotify = safeFreeFunPtrPtr
    result <- jsc_value_new_function_variadic context' maybeName callback' userData destroyNotify returnType'
    checkUnexpectedReturnNULL "valueNewFunctionVariadic" result
    result' <- (wrapObject Value) result
    touchManagedPtr context
    freeMem maybeName
    return result'

#if ENABLE_OVERLOADING
#endif

-- method Value::new_function
-- method type : Constructor
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "name", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "the function name or %NULL", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "callback", argType = TInterface (Name {namespace = "GObject", name = "Callback"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #GCallback.", sinceVersion = Nothing}, argScope = ScopeTypeNotified, argClosure = 3, argDestroy = 4, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "user_data", argType = TBasicType TPtr, direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "user data to pass to @callback.", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "destroy_notify", argType = TInterface (Name {namespace = "GLib", name = "DestroyNotify"}), direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "destroy notifier for @user_data", sinceVersion = Nothing}, argScope = ScopeTypeAsync, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "return_type", argType = TBasicType TGType, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the #GType of the function return value, or %G_TYPE_NONE if the function is void.", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "n_parameters", argType = TBasicType TUInt, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the number of parameters", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "parameter_types", argType = TCArray False (-1) 6 (TBasicType TGType), direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "a list of #GType<!-- -->s, one for each parameter, or %NULL", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : [Arg {argCName = "n_parameters", argType = TBasicType TUInt, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the number of parameters", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_new_functionv" jsc_value_new_functionv :: 
    Ptr JavaScriptCore.Context.Context ->   -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    CString ->                              -- name : TBasicType TUTF8
    FunPtr GObject.Callbacks.C_Callback ->  -- callback : TInterface (Name {namespace = "GObject", name = "Callback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy_notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    CGType ->                               -- return_type : TBasicType TGType
    Word32 ->                               -- n_parameters : TBasicType TUInt
    Ptr CGType ->                           -- parameter_types : TCArray False (-1) 6 (TBasicType TGType)
    IO (Ptr Value)

{- |
Create a function in /@context@/. If /@name@/ is 'Nothing' an anonymous function will be created.
When the function is called by JavaScript or @/jsc_value_function_call()/@, /@callback@/ is called
receiving the function parameters and then /@userData@/ as last parameter. When the function is
cleared in /@context@/, /@destroyNotify@/ is called with /@userData@/ as parameter.

Note that the value returned by /@callback@/ must be fully transferred. In case of boxed types, you could use
@/G_TYPE_POINTER/@ instead of the actual boxed 'GType' to ensure that the instance owned by 'GI.JavaScriptCore.Objects.Class.Class' is used.
If you really want to return a new copy of the boxed type, use @/JSC_TYPE_VALUE/@ and return a 'GI.JavaScriptCore.Objects.Value.Value' created
with 'GI.JavaScriptCore.Objects.Value.valueNewObject' that receives the copy as instance parameter.
-}
valueNewFunction ::
    (B.CallStack.HasCallStack, MonadIO m, JavaScriptCore.Context.IsContext a) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> Maybe (T.Text)
    {- ^ /@name@/: the function name or 'Nothing' -}
    -> GObject.Callbacks.Callback
    {- ^ /@callback@/: a 'GI.GObject.Callbacks.Callback'. -}
    -> GType
    {- ^ /@returnType@/: the 'GType' of the function return value, or @/G_TYPE_NONE/@ if the function is void. -}
    -> Maybe ([GType])
    {- ^ /@parameterTypes@/: a list of 'GType'\<!-- -->s, one for each parameter, or 'Nothing' -}
    -> m Value
    {- ^ __Returns:__ a 'GI.JavaScriptCore.Objects.Value.Value'. -}
valueNewFunction context name callback returnType parameterTypes = liftIO $ do
    let nParameters = case parameterTypes of
            Nothing -> 0
            Just jParameterTypes -> fromIntegral $ length jParameterTypes
    context' <- unsafeManagedPtrCastPtr context
    maybeName <- case name of
        Nothing -> return nullPtr
        Just jName -> do
            jName' <- textToCString jName
            return jName'
    callback' <- GObject.Callbacks.mk_Callback (GObject.Callbacks.wrap_Callback Nothing callback)
    let returnType' = gtypeToCGType returnType
    maybeParameterTypes <- case parameterTypes of
        Nothing -> return nullPtr
        Just jParameterTypes -> do
            jParameterTypes' <- (packMapStorableArray gtypeToCGType) jParameterTypes
            return jParameterTypes'
    let userData = castFunPtrToPtr callback'
    let destroyNotify = safeFreeFunPtrPtr
    result <- jsc_value_new_functionv context' maybeName callback' userData destroyNotify returnType' nParameters maybeParameterTypes
    checkUnexpectedReturnNULL "valueNewFunction" result
    result' <- (wrapObject Value) result
    touchManagedPtr context
    freeMem maybeName
    freeMem maybeParameterTypes
    return result'

#if ENABLE_OVERLOADING
#endif

-- method Value::new_null
-- method type : Constructor
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_new_null" jsc_value_new_null :: 
    Ptr JavaScriptCore.Context.Context ->   -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    IO (Ptr Value)

{- |
Create a new 'GI.JavaScriptCore.Objects.Value.Value' referencing \<function>null\<\/function> in /@context@/.
-}
valueNewNull ::
    (B.CallStack.HasCallStack, MonadIO m, JavaScriptCore.Context.IsContext a) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> m Value
    {- ^ __Returns:__ a 'GI.JavaScriptCore.Objects.Value.Value'. -}
valueNewNull context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- jsc_value_new_null context'
    checkUnexpectedReturnNULL "valueNewNull" result
    result' <- (wrapObject Value) result
    touchManagedPtr context
    return result'

#if ENABLE_OVERLOADING
#endif

-- method Value::new_number
-- method type : Constructor
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "number", argType = TBasicType TDouble, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a number", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_new_number" jsc_value_new_number :: 
    Ptr JavaScriptCore.Context.Context ->   -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    CDouble ->                              -- number : TBasicType TDouble
    IO (Ptr Value)

{- |
Create a new 'GI.JavaScriptCore.Objects.Value.Value' from /@number@/.
-}
valueNewNumber ::
    (B.CallStack.HasCallStack, MonadIO m, JavaScriptCore.Context.IsContext a) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> Double
    {- ^ /@number@/: a number -}
    -> m Value
    {- ^ __Returns:__ a 'GI.JavaScriptCore.Objects.Value.Value'. -}
valueNewNumber context number = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    let number' = realToFrac number
    result <- jsc_value_new_number context' number'
    checkUnexpectedReturnNULL "valueNewNumber" result
    result' <- (wrapObject Value) result
    touchManagedPtr context
    return result'

#if ENABLE_OVERLOADING
#endif

-- method Value::new_object
-- method type : Constructor
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "instance", argType = TBasicType TPtr, direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "an object instance or %NULL", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferEverything},Arg {argCName = "jsc_class", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Class"}), direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "the #JSCClass of @instance", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_new_object" jsc_value_new_object :: 
    Ptr JavaScriptCore.Context.Context ->   -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    Ptr () ->                               -- instance : TBasicType TPtr
    Ptr JavaScriptCore.Class.Class ->       -- jsc_class : TInterface (Name {namespace = "JavaScriptCore", name = "Class"})
    IO (Ptr Value)

{- |
Create a new 'GI.JavaScriptCore.Objects.Value.Value' from /@instance@/. If /@instance@/ is 'Nothing' a new empty object is created.
When /@instance@/ is provided, /@jscClass@/ must be provided too. /@jscClass@/ takes ownership of
/@instance@/ that will be freed by the 'GI.GLib.Callbacks.DestroyNotify' passed to 'GI.JavaScriptCore.Objects.Context.contextRegisterClass'.
-}
valueNewObject ::
    (B.CallStack.HasCallStack, MonadIO m, JavaScriptCore.Context.IsContext a, JavaScriptCore.Class.IsClass b) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> Ptr ()
    {- ^ /@instance@/: an object instance or 'Nothing' -}
    -> Maybe (b)
    {- ^ /@jscClass@/: the 'GI.JavaScriptCore.Objects.Class.Class' of /@instance@/ -}
    -> m Value
    {- ^ __Returns:__ a 'GI.JavaScriptCore.Objects.Value.Value'. -}
valueNewObject context instance_ jscClass = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    maybeJscClass <- case jscClass of
        Nothing -> return nullPtr
        Just jJscClass -> do
            jJscClass' <- unsafeManagedPtrCastPtr jJscClass
            return jJscClass'
    result <- jsc_value_new_object context' instance_ maybeJscClass
    checkUnexpectedReturnNULL "valueNewObject" result
    result' <- (wrapObject Value) result
    touchManagedPtr context
    whenJust jscClass touchManagedPtr
    return result'

#if ENABLE_OVERLOADING
#endif

-- method Value::new_string
-- method type : Constructor
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "string", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "a null-terminated string", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_new_string" jsc_value_new_string :: 
    Ptr JavaScriptCore.Context.Context ->   -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    CString ->                              -- string : TBasicType TUTF8
    IO (Ptr Value)

{- |
Create a new 'GI.JavaScriptCore.Objects.Value.Value' from /@string@/. If you need to create a 'GI.JavaScriptCore.Objects.Value.Value' from a
string containing null characters, use 'GI.JavaScriptCore.Objects.Value.valueNewStringFromBytes' instead.
-}
valueNewString ::
    (B.CallStack.HasCallStack, MonadIO m, JavaScriptCore.Context.IsContext a) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> Maybe (T.Text)
    {- ^ /@string@/: a null-terminated string -}
    -> m Value
    {- ^ __Returns:__ a 'GI.JavaScriptCore.Objects.Value.Value'. -}
valueNewString context string = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    maybeString <- case string of
        Nothing -> return nullPtr
        Just jString -> do
            jString' <- textToCString jString
            return jString'
    result <- jsc_value_new_string context' maybeString
    checkUnexpectedReturnNULL "valueNewString" result
    result' <- (wrapObject Value) result
    touchManagedPtr context
    freeMem maybeString
    return result'

#if ENABLE_OVERLOADING
#endif

-- method Value::new_string_from_bytes
-- method type : Constructor
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "bytes", argType = TInterface (Name {namespace = "GLib", name = "Bytes"}), direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "a #GBytes", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_new_string_from_bytes" jsc_value_new_string_from_bytes :: 
    Ptr JavaScriptCore.Context.Context ->   -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    Ptr GLib.Bytes.Bytes ->                 -- bytes : TInterface (Name {namespace = "GLib", name = "Bytes"})
    IO (Ptr Value)

{- |
Create a new 'GI.JavaScriptCore.Objects.Value.Value' from /@bytes@/.
-}
valueNewStringFromBytes ::
    (B.CallStack.HasCallStack, MonadIO m, JavaScriptCore.Context.IsContext a) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> Maybe (GLib.Bytes.Bytes)
    {- ^ /@bytes@/: a 'GI.GLib.Structs.Bytes.Bytes' -}
    -> m Value
    {- ^ __Returns:__ a 'GI.JavaScriptCore.Objects.Value.Value'. -}
valueNewStringFromBytes context bytes = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    maybeBytes <- case bytes of
        Nothing -> return nullPtr
        Just jBytes -> do
            jBytes' <- unsafeManagedPtrGetPtr jBytes
            return jBytes'
    result <- jsc_value_new_string_from_bytes context' maybeBytes
    checkUnexpectedReturnNULL "valueNewStringFromBytes" result
    result' <- (wrapObject Value) result
    touchManagedPtr context
    whenJust bytes touchManagedPtr
    return result'

#if ENABLE_OVERLOADING
#endif

-- method Value::new_undefined
-- method type : Constructor
-- Args : [Arg {argCName = "context", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Context"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCContext", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_new_undefined" jsc_value_new_undefined :: 
    Ptr JavaScriptCore.Context.Context ->   -- context : TInterface (Name {namespace = "JavaScriptCore", name = "Context"})
    IO (Ptr Value)

{- |
Create a new 'GI.JavaScriptCore.Objects.Value.Value' referencing \<function>undefined\<\/function> in /@context@/.
-}
valueNewUndefined ::
    (B.CallStack.HasCallStack, MonadIO m, JavaScriptCore.Context.IsContext a) =>
    a
    {- ^ /@context@/: a 'GI.JavaScriptCore.Objects.Context.Context' -}
    -> m Value
    {- ^ __Returns:__ a 'GI.JavaScriptCore.Objects.Value.Value'. -}
valueNewUndefined context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- jsc_value_new_undefined context'
    checkUnexpectedReturnNULL "valueNewUndefined" result
    result' <- (wrapObject Value) result
    touchManagedPtr context
    return result'

#if ENABLE_OVERLOADING
#endif

-- method Value::constructor_call
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "n_parameters", argType = TBasicType TUInt, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the number of parameters", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "parameters", argType = TCArray False (-1) 1 (TInterface (Name {namespace = "JavaScriptCore", name = "Value"})), direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "the #JSCValue<!-- -->s to pass as parameters to the constructor, or %NULL", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : [Arg {argCName = "n_parameters", argType = TBasicType TUInt, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the number of parameters", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_constructor_callv" jsc_value_constructor_callv :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    Word32 ->                               -- n_parameters : TBasicType TUInt
    Ptr (Ptr Value) ->                      -- parameters : TCArray False (-1) 1 (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
    IO (Ptr Value)

{- |
Invoke \<function>new\<\/function> with constructor referenced by /@value@/. If /@nParameters@/
is 0 no parameters will be passed to the constructor.
-}
valueConstructorCall ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> Maybe ([Value])
    {- ^ /@parameters@/: the 'GI.JavaScriptCore.Objects.Value.Value'\<!-- -->s to pass as parameters to the constructor, or 'Nothing' -}
    -> m Value
    {- ^ __Returns:__ a 'GI.JavaScriptCore.Objects.Value.Value' referencing the newly created object instance. -}
valueConstructorCall value parameters = liftIO $ do
    let nParameters = case parameters of
            Nothing -> 0
            Just jParameters -> fromIntegral $ length jParameters
    value' <- unsafeManagedPtrCastPtr value
    maybeParameters <- case parameters of
        Nothing -> return nullPtr
        Just jParameters -> do
            jParameters' <- mapM unsafeManagedPtrCastPtr jParameters
            jParameters'' <- packPtrArray jParameters'
            return jParameters''
    result <- jsc_value_constructor_callv value' nParameters maybeParameters
    checkUnexpectedReturnNULL "valueConstructorCall" result
    result' <- (wrapObject Value) result
    touchManagedPtr value
    whenJust parameters (mapM_ touchManagedPtr)
    freeMem maybeParameters
    return result'

#if ENABLE_OVERLOADING
data ValueConstructorCallMethodInfo
instance (signature ~ (Maybe ([Value]) -> m Value), MonadIO m, IsValue a) => O.MethodInfo ValueConstructorCallMethodInfo a signature where
    overloadedMethod _ = valueConstructorCall

#endif

-- method Value::function_call
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "n_parameters", argType = TBasicType TUInt, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the number of parameters", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "parameters", argType = TCArray False (-1) 1 (TInterface (Name {namespace = "JavaScriptCore", name = "Value"})), direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "the #JSCValue<!-- -->s to pass as parameters to the function, or %NULL", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : [Arg {argCName = "n_parameters", argType = TBasicType TUInt, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the number of parameters", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_function_callv" jsc_value_function_callv :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    Word32 ->                               -- n_parameters : TBasicType TUInt
    Ptr (Ptr Value) ->                      -- parameters : TCArray False (-1) 1 (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
    IO (Ptr Value)

{- |
Call function referenced by /@value@/, passing the given /@parameters@/. If /@nParameters@/
is 0 no parameters will be passed to the function.

This function always returns a 'GI.JavaScriptCore.Objects.Value.Value', in case of void functions a 'GI.JavaScriptCore.Objects.Value.Value' referencing
\<function>undefined\<\/function> is returned
-}
valueFunctionCall ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> Maybe ([Value])
    {- ^ /@parameters@/: the 'GI.JavaScriptCore.Objects.Value.Value'\<!-- -->s to pass as parameters to the function, or 'Nothing' -}
    -> m Value
    {- ^ __Returns:__ a 'GI.JavaScriptCore.Objects.Value.Value' with the return value of the function. -}
valueFunctionCall value parameters = liftIO $ do
    let nParameters = case parameters of
            Nothing -> 0
            Just jParameters -> fromIntegral $ length jParameters
    value' <- unsafeManagedPtrCastPtr value
    maybeParameters <- case parameters of
        Nothing -> return nullPtr
        Just jParameters -> do
            jParameters' <- mapM unsafeManagedPtrCastPtr jParameters
            jParameters'' <- packPtrArray jParameters'
            return jParameters''
    result <- jsc_value_function_callv value' nParameters maybeParameters
    checkUnexpectedReturnNULL "valueFunctionCall" result
    result' <- (wrapObject Value) result
    touchManagedPtr value
    whenJust parameters (mapM_ touchManagedPtr)
    freeMem maybeParameters
    return result'

#if ENABLE_OVERLOADING
data ValueFunctionCallMethodInfo
instance (signature ~ (Maybe ([Value]) -> m Value), MonadIO m, IsValue a) => O.MethodInfo ValueFunctionCallMethodInfo a signature where
    overloadedMethod _ = valueFunctionCall

#endif

-- method Value::get_context
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Context"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_get_context" jsc_value_get_context :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    IO (Ptr JavaScriptCore.Context.Context)

{- |
Get the 'GI.JavaScriptCore.Objects.Context.Context' in which /@value@/ was created.
-}
valueGetContext ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> m JavaScriptCore.Context.Context
    {- ^ __Returns:__ the 'GI.JavaScriptCore.Objects.Value.Value' context. -}
valueGetContext value = liftIO $ do
    value' <- unsafeManagedPtrCastPtr value
    result <- jsc_value_get_context value'
    checkUnexpectedReturnNULL "valueGetContext" result
    result' <- (newObject JavaScriptCore.Context.Context) result
    touchManagedPtr value
    return result'

#if ENABLE_OVERLOADING
data ValueGetContextMethodInfo
instance (signature ~ (m JavaScriptCore.Context.Context), MonadIO m, IsValue a) => O.MethodInfo ValueGetContextMethodInfo a signature where
    overloadedMethod _ = valueGetContext

#endif

-- method Value::is_array
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_is_array" jsc_value_is_array :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    IO CInt

{- |
Get whether the value referenced by /@value@/ is an array.
-}
valueIsArray ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> m Bool
    {- ^ __Returns:__ whether the value is an array. -}
valueIsArray value = liftIO $ do
    value' <- unsafeManagedPtrCastPtr value
    result <- jsc_value_is_array value'
    let result' = (/= 0) result
    touchManagedPtr value
    return result'

#if ENABLE_OVERLOADING
data ValueIsArrayMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsValue a) => O.MethodInfo ValueIsArrayMethodInfo a signature where
    overloadedMethod _ = valueIsArray

#endif

-- method Value::is_boolean
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_is_boolean" jsc_value_is_boolean :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    IO CInt

{- |
Get whether the value referenced by /@value@/ is a boolean.
-}
valueIsBoolean ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> m Bool
    {- ^ __Returns:__ whether the value is a boolean. -}
valueIsBoolean value = liftIO $ do
    value' <- unsafeManagedPtrCastPtr value
    result <- jsc_value_is_boolean value'
    let result' = (/= 0) result
    touchManagedPtr value
    return result'

#if ENABLE_OVERLOADING
data ValueIsBooleanMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsValue a) => O.MethodInfo ValueIsBooleanMethodInfo a signature where
    overloadedMethod _ = valueIsBoolean

#endif

-- method Value::is_constructor
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_is_constructor" jsc_value_is_constructor :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    IO CInt

{- |
Get whether the value referenced by /@value@/ is a constructor.
-}
valueIsConstructor ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> m Bool
    {- ^ __Returns:__ whether the value is a constructor. -}
valueIsConstructor value = liftIO $ do
    value' <- unsafeManagedPtrCastPtr value
    result <- jsc_value_is_constructor value'
    let result' = (/= 0) result
    touchManagedPtr value
    return result'

#if ENABLE_OVERLOADING
data ValueIsConstructorMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsValue a) => O.MethodInfo ValueIsConstructorMethodInfo a signature where
    overloadedMethod _ = valueIsConstructor

#endif

-- method Value::is_function
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_is_function" jsc_value_is_function :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    IO CInt

{- |
Get whether the value referenced by /@value@/ is a function
-}
valueIsFunction ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> m Bool
    {- ^ __Returns:__ whether the value is a function. -}
valueIsFunction value = liftIO $ do
    value' <- unsafeManagedPtrCastPtr value
    result <- jsc_value_is_function value'
    let result' = (/= 0) result
    touchManagedPtr value
    return result'

#if ENABLE_OVERLOADING
data ValueIsFunctionMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsValue a) => O.MethodInfo ValueIsFunctionMethodInfo a signature where
    overloadedMethod _ = valueIsFunction

#endif

-- method Value::is_null
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_is_null" jsc_value_is_null :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    IO CInt

{- |
Get whether the value referenced by /@value@/ is \<function>null\<\/function>.
-}
valueIsNull ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> m Bool
    {- ^ __Returns:__ whether the value is null. -}
valueIsNull value = liftIO $ do
    value' <- unsafeManagedPtrCastPtr value
    result <- jsc_value_is_null value'
    let result' = (/= 0) result
    touchManagedPtr value
    return result'

#if ENABLE_OVERLOADING
data ValueIsNullMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsValue a) => O.MethodInfo ValueIsNullMethodInfo a signature where
    overloadedMethod _ = valueIsNull

#endif

-- method Value::is_number
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_is_number" jsc_value_is_number :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    IO CInt

{- |
Get whether the value referenced by /@value@/ is a number.
-}
valueIsNumber ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> m Bool
    {- ^ __Returns:__ whether the value is a number. -}
valueIsNumber value = liftIO $ do
    value' <- unsafeManagedPtrCastPtr value
    result <- jsc_value_is_number value'
    let result' = (/= 0) result
    touchManagedPtr value
    return result'

#if ENABLE_OVERLOADING
data ValueIsNumberMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsValue a) => O.MethodInfo ValueIsNumberMethodInfo a signature where
    overloadedMethod _ = valueIsNumber

#endif

-- method Value::is_object
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_is_object" jsc_value_is_object :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    IO CInt

{- |
Get whether the value referenced by /@value@/ is an object.
-}
valueIsObject ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> m Bool
    {- ^ __Returns:__ whether the value is an object. -}
valueIsObject value = liftIO $ do
    value' <- unsafeManagedPtrCastPtr value
    result <- jsc_value_is_object value'
    let result' = (/= 0) result
    touchManagedPtr value
    return result'

#if ENABLE_OVERLOADING
data ValueIsObjectMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsValue a) => O.MethodInfo ValueIsObjectMethodInfo a signature where
    overloadedMethod _ = valueIsObject

#endif

-- method Value::is_string
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_is_string" jsc_value_is_string :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    IO CInt

{- |
Get whether the value referenced by /@value@/ is a string
-}
valueIsString ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> m Bool
    {- ^ __Returns:__ whether the value is a string -}
valueIsString value = liftIO $ do
    value' <- unsafeManagedPtrCastPtr value
    result <- jsc_value_is_string value'
    let result' = (/= 0) result
    touchManagedPtr value
    return result'

#if ENABLE_OVERLOADING
data ValueIsStringMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsValue a) => O.MethodInfo ValueIsStringMethodInfo a signature where
    overloadedMethod _ = valueIsString

#endif

-- method Value::is_undefined
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_is_undefined" jsc_value_is_undefined :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    IO CInt

{- |
Get whether the value referenced by /@value@/ is \<function>undefined\<\/function>.
-}
valueIsUndefined ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> m Bool
    {- ^ __Returns:__ whether the value is undefined. -}
valueIsUndefined value = liftIO $ do
    value' <- unsafeManagedPtrCastPtr value
    result <- jsc_value_is_undefined value'
    let result' = (/= 0) result
    touchManagedPtr value
    return result'

#if ENABLE_OVERLOADING
data ValueIsUndefinedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsValue a) => O.MethodInfo ValueIsUndefinedMethodInfo a signature where
    overloadedMethod _ = valueIsUndefined

#endif

-- method Value::object_define_property_accessor
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "property_name", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the name of the property to define", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "flags", argType = TInterface (Name {namespace = "JavaScriptCore", name = "ValuePropertyFlags"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "#JSCValuePropertyFlags", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "property_type", argType = TBasicType TGType, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the #GType of the property", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "getter", argType = TInterface (Name {namespace = "GObject", name = "Callback"}), direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "a #GCallback to be called to get the property value", sinceVersion = Nothing}, argScope = ScopeTypeAsync, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "setter", argType = TInterface (Name {namespace = "GObject", name = "Callback"}), direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "a #GCallback to be called to set the property value", sinceVersion = Nothing}, argScope = ScopeTypeNotified, argClosure = 6, argDestroy = 7, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "user_data", argType = TBasicType TPtr, direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "user data to pass to @getter and @setter", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "destroy_notify", argType = TInterface (Name {namespace = "GLib", name = "DestroyNotify"}), direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "destroy notifier for @user_data", sinceVersion = Nothing}, argScope = ScopeTypeAsync, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_object_define_property_accessor" jsc_value_object_define_property_accessor :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    CString ->                              -- property_name : TBasicType TUTF8
    CUInt ->                                -- flags : TInterface (Name {namespace = "JavaScriptCore", name = "ValuePropertyFlags"})
    CGType ->                               -- property_type : TBasicType TGType
    FunPtr GObject.Callbacks.C_Callback ->  -- getter : TInterface (Name {namespace = "GObject", name = "Callback"})
    FunPtr GObject.Callbacks.C_Callback ->  -- setter : TInterface (Name {namespace = "GObject", name = "Callback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy_notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

{- |
Define or modify a property with /@propertyName@/ in object referenced by /@value@/. When the
property value needs to be getted or set, /@getter@/ and /@setter@/ callbacks will be called.
When the property is cleared in the 'GI.JavaScriptCore.Objects.Class.Class' context, /@destroyNotify@/ is called with
/@userData@/ as parameter. This is equivalent to JavaScript \<function>Object.@/defineProperty()/@\<\/function>
when used with an accessor descriptor.

Note that the value returned by /@getter@/ must be fully transferred. In case of boxed types, you could use
@/G_TYPE_POINTER/@ instead of the actual boxed 'GType' to ensure that the instance owned by 'GI.JavaScriptCore.Objects.Class.Class' is used.
If you really want to return a new copy of the boxed type, use @/JSC_TYPE_VALUE/@ and return a 'GI.JavaScriptCore.Objects.Value.Value' created
with 'GI.JavaScriptCore.Objects.Value.valueNewObject' that receives the copy as instance parameter.
-}
valueObjectDefinePropertyAccessor ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> T.Text
    {- ^ /@propertyName@/: the name of the property to define -}
    -> [JavaScriptCore.Flags.ValuePropertyFlags]
    {- ^ /@flags@/: 'GI.JavaScriptCore.Flags.ValuePropertyFlags' -}
    -> GType
    {- ^ /@propertyType@/: the 'GType' of the property -}
    -> Maybe (GObject.Callbacks.Callback)
    {- ^ /@getter@/: a 'GI.GObject.Callbacks.Callback' to be called to get the property value -}
    -> Maybe (GObject.Callbacks.Callback)
    {- ^ /@setter@/: a 'GI.GObject.Callbacks.Callback' to be called to set the property value -}
    -> m ()
valueObjectDefinePropertyAccessor value propertyName flags propertyType getter setter = liftIO $ do
    value' <- unsafeManagedPtrCastPtr value
    propertyName' <- textToCString propertyName
    let flags' = gflagsToWord flags
    let propertyType' = gtypeToCGType propertyType
    maybeGetter <- case getter of
        Nothing -> return (castPtrToFunPtr nullPtr)
        Just jGetter -> do
            ptrgetter <- callocMem :: IO (Ptr (FunPtr GObject.Callbacks.C_Callback))
            jGetter' <- GObject.Callbacks.mk_Callback (GObject.Callbacks.wrap_Callback (Just ptrgetter) jGetter)
            poke ptrgetter jGetter'
            return jGetter'
    maybeSetter <- case setter of
        Nothing -> return (castPtrToFunPtr nullPtr)
        Just jSetter -> do
            jSetter' <- GObject.Callbacks.mk_Callback (GObject.Callbacks.wrap_Callback Nothing jSetter)
            return jSetter'
    let userData = castFunPtrToPtr maybeSetter
    let destroyNotify = safeFreeFunPtrPtr
    jsc_value_object_define_property_accessor value' propertyName' flags' propertyType' maybeGetter maybeSetter userData destroyNotify
    touchManagedPtr value
    freeMem propertyName'
    return ()

#if ENABLE_OVERLOADING
data ValueObjectDefinePropertyAccessorMethodInfo
instance (signature ~ (T.Text -> [JavaScriptCore.Flags.ValuePropertyFlags] -> GType -> Maybe (GObject.Callbacks.Callback) -> Maybe (GObject.Callbacks.Callback) -> m ()), MonadIO m, IsValue a) => O.MethodInfo ValueObjectDefinePropertyAccessorMethodInfo a signature where
    overloadedMethod _ = valueObjectDefinePropertyAccessor

#endif

-- method Value::object_define_property_data
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "property_name", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the name of the property to define", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "flags", argType = TInterface (Name {namespace = "JavaScriptCore", name = "ValuePropertyFlags"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "#JSCValuePropertyFlags", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "property_value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "the default property value", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_object_define_property_data" jsc_value_object_define_property_data :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    CString ->                              -- property_name : TBasicType TUTF8
    CUInt ->                                -- flags : TInterface (Name {namespace = "JavaScriptCore", name = "ValuePropertyFlags"})
    Ptr Value ->                            -- property_value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    IO ()

{- |
Define or modify a property with /@propertyName@/ in object referenced by /@value@/. This is equivalent to
JavaScript \<function>Object.@/defineProperty()/@\<\/function> when used with a data descriptor.
-}
valueObjectDefinePropertyData ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a, IsValue b) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> T.Text
    {- ^ /@propertyName@/: the name of the property to define -}
    -> [JavaScriptCore.Flags.ValuePropertyFlags]
    {- ^ /@flags@/: 'GI.JavaScriptCore.Flags.ValuePropertyFlags' -}
    -> Maybe (b)
    {- ^ /@propertyValue@/: the default property value -}
    -> m ()
valueObjectDefinePropertyData value propertyName flags propertyValue = liftIO $ do
    value' <- unsafeManagedPtrCastPtr value
    propertyName' <- textToCString propertyName
    let flags' = gflagsToWord flags
    maybePropertyValue <- case propertyValue of
        Nothing -> return nullPtr
        Just jPropertyValue -> do
            jPropertyValue' <- unsafeManagedPtrCastPtr jPropertyValue
            return jPropertyValue'
    jsc_value_object_define_property_data value' propertyName' flags' maybePropertyValue
    touchManagedPtr value
    whenJust propertyValue touchManagedPtr
    freeMem propertyName'
    return ()

#if ENABLE_OVERLOADING
data ValueObjectDefinePropertyDataMethodInfo
instance (signature ~ (T.Text -> [JavaScriptCore.Flags.ValuePropertyFlags] -> Maybe (b) -> m ()), MonadIO m, IsValue a, IsValue b) => O.MethodInfo ValueObjectDefinePropertyDataMethodInfo a signature where
    overloadedMethod _ = valueObjectDefinePropertyData

#endif

-- method Value::object_delete_property
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "name", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the property name", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_object_delete_property" jsc_value_object_delete_property :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    CString ->                              -- name : TBasicType TUTF8
    IO CInt

{- |
Try to delete property with /@name@/ from /@value@/. This function will return 'False' if
the property was defined without 'GI.JavaScriptCore.Flags.ValuePropertyFlagsConfigurable' flag.
-}
valueObjectDeleteProperty ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> T.Text
    {- ^ /@name@/: the property name -}
    -> m Bool
    {- ^ __Returns:__ 'True' if the property was deleted, or 'False' otherwise. -}
valueObjectDeleteProperty value name = liftIO $ do
    value' <- unsafeManagedPtrCastPtr value
    name' <- textToCString name
    result <- jsc_value_object_delete_property value' name'
    let result' = (/= 0) result
    touchManagedPtr value
    freeMem name'
    return result'

#if ENABLE_OVERLOADING
data ValueObjectDeletePropertyMethodInfo
instance (signature ~ (T.Text -> m Bool), MonadIO m, IsValue a) => O.MethodInfo ValueObjectDeletePropertyMethodInfo a signature where
    overloadedMethod _ = valueObjectDeleteProperty

#endif

-- method Value::object_enumerate_properties
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_object_enumerate_properties" jsc_value_object_enumerate_properties :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    IO (Ptr CString)

{- |
Get the list of property names of /@value@/. Only properties defined with 'GI.JavaScriptCore.Flags.ValuePropertyFlagsEnumerable'
flag will be collected.
-}
valueObjectEnumerateProperties ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> m (Maybe [T.Text])
    {- ^ __Returns:__ a 'Nothing'-terminated array of strings containing the
   property names, or 'Nothing' if /@value@/ doesn\'t have enumerable properties.  Use 'GI.GLib.Functions.strfreev' to free. -}
valueObjectEnumerateProperties value = liftIO $ do
    value' <- unsafeManagedPtrCastPtr value
    result <- jsc_value_object_enumerate_properties value'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- unpackZeroTerminatedUTF8CArray result'
        mapZeroTerminatedCArray freeMem result'
        freeMem result'
        return result''
    touchManagedPtr value
    return maybeResult

#if ENABLE_OVERLOADING
data ValueObjectEnumeratePropertiesMethodInfo
instance (signature ~ (m (Maybe [T.Text])), MonadIO m, IsValue a) => O.MethodInfo ValueObjectEnumeratePropertiesMethodInfo a signature where
    overloadedMethod _ = valueObjectEnumerateProperties

#endif

-- method Value::object_get_property
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "name", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the property name", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_object_get_property" jsc_value_object_get_property :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    CString ->                              -- name : TBasicType TUTF8
    IO (Ptr Value)

{- |
Get property with /@name@/ from /@value@/.
-}
valueObjectGetProperty ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> T.Text
    {- ^ /@name@/: the property name -}
    -> m Value
    {- ^ __Returns:__ the property 'GI.JavaScriptCore.Objects.Value.Value'. -}
valueObjectGetProperty value name = liftIO $ do
    value' <- unsafeManagedPtrCastPtr value
    name' <- textToCString name
    result <- jsc_value_object_get_property value' name'
    checkUnexpectedReturnNULL "valueObjectGetProperty" result
    result' <- (wrapObject Value) result
    touchManagedPtr value
    freeMem name'
    return result'

#if ENABLE_OVERLOADING
data ValueObjectGetPropertyMethodInfo
instance (signature ~ (T.Text -> m Value), MonadIO m, IsValue a) => O.MethodInfo ValueObjectGetPropertyMethodInfo a signature where
    overloadedMethod _ = valueObjectGetProperty

#endif

-- method Value::object_get_property_at_index
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "index", argType = TBasicType TUInt, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the property index", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_object_get_property_at_index" jsc_value_object_get_property_at_index :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    Word32 ->                               -- index : TBasicType TUInt
    IO (Ptr Value)

{- |
Get property at /@index@/ from /@value@/.
-}
valueObjectGetPropertyAtIndex ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> Word32
    {- ^ /@index@/: the property index -}
    -> m Value
    {- ^ __Returns:__ the property 'GI.JavaScriptCore.Objects.Value.Value'. -}
valueObjectGetPropertyAtIndex value index = liftIO $ do
    value' <- unsafeManagedPtrCastPtr value
    result <- jsc_value_object_get_property_at_index value' index
    checkUnexpectedReturnNULL "valueObjectGetPropertyAtIndex" result
    result' <- (wrapObject Value) result
    touchManagedPtr value
    return result'

#if ENABLE_OVERLOADING
data ValueObjectGetPropertyAtIndexMethodInfo
instance (signature ~ (Word32 -> m Value), MonadIO m, IsValue a) => O.MethodInfo ValueObjectGetPropertyAtIndexMethodInfo a signature where
    overloadedMethod _ = valueObjectGetPropertyAtIndex

#endif

-- method Value::object_has_property
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "name", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the property name", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_object_has_property" jsc_value_object_has_property :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    CString ->                              -- name : TBasicType TUTF8
    IO CInt

{- |
Get whether /@value@/ has property with /@name@/.
-}
valueObjectHasProperty ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> T.Text
    {- ^ /@name@/: the property name -}
    -> m Bool
    {- ^ __Returns:__ 'True' if /@value@/ has a property with /@name@/, or 'False' otherwise -}
valueObjectHasProperty value name = liftIO $ do
    value' <- unsafeManagedPtrCastPtr value
    name' <- textToCString name
    result <- jsc_value_object_has_property value' name'
    let result' = (/= 0) result
    touchManagedPtr value
    freeMem name'
    return result'

#if ENABLE_OVERLOADING
data ValueObjectHasPropertyMethodInfo
instance (signature ~ (T.Text -> m Bool), MonadIO m, IsValue a) => O.MethodInfo ValueObjectHasPropertyMethodInfo a signature where
    overloadedMethod _ = valueObjectHasProperty

#endif

-- method Value::object_invoke_method
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "name", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the method name", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "n_parameters", argType = TBasicType TUInt, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the number of parameters", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "parameters", argType = TCArray False (-1) 2 (TInterface (Name {namespace = "JavaScriptCore", name = "Value"})), direction = DirectionIn, mayBeNull = True, argDoc = Documentation {rawDocText = Just "the #JSCValue<!-- -->s to pass as parameters to the method, or %NULL", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : [Arg {argCName = "n_parameters", argType = TBasicType TUInt, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the number of parameters", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_object_invoke_methodv" jsc_value_object_invoke_methodv :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    CString ->                              -- name : TBasicType TUTF8
    Word32 ->                               -- n_parameters : TBasicType TUInt
    Ptr (Ptr Value) ->                      -- parameters : TCArray False (-1) 2 (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
    IO (Ptr Value)

{- |
Invoke method with /@name@/ on object referenced by /@value@/, passing the given /@parameters@/. If
/@nParameters@/ is 0 no parameters will be passed to the method.
The object instance will be handled automatically even when the method is a custom one
registered with @/jsc_class_add_method()/@, so it should never be passed explicitly as parameter
of this function.

This function always returns a 'GI.JavaScriptCore.Objects.Value.Value', in case of void methods a 'GI.JavaScriptCore.Objects.Value.Value' referencing
\<function>undefined\<\/function> is returned.
-}
valueObjectInvokeMethod ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> T.Text
    {- ^ /@name@/: the method name -}
    -> Maybe ([Value])
    {- ^ /@parameters@/: the 'GI.JavaScriptCore.Objects.Value.Value'\<!-- -->s to pass as parameters to the method, or 'Nothing' -}
    -> m Value
    {- ^ __Returns:__ a 'GI.JavaScriptCore.Objects.Value.Value' with the return value of the method. -}
valueObjectInvokeMethod value name parameters = liftIO $ do
    let nParameters = case parameters of
            Nothing -> 0
            Just jParameters -> fromIntegral $ length jParameters
    value' <- unsafeManagedPtrCastPtr value
    name' <- textToCString name
    maybeParameters <- case parameters of
        Nothing -> return nullPtr
        Just jParameters -> do
            jParameters' <- mapM unsafeManagedPtrCastPtr jParameters
            jParameters'' <- packPtrArray jParameters'
            return jParameters''
    result <- jsc_value_object_invoke_methodv value' name' nParameters maybeParameters
    checkUnexpectedReturnNULL "valueObjectInvokeMethod" result
    result' <- (wrapObject Value) result
    touchManagedPtr value
    whenJust parameters (mapM_ touchManagedPtr)
    freeMem name'
    freeMem maybeParameters
    return result'

#if ENABLE_OVERLOADING
data ValueObjectInvokeMethodMethodInfo
instance (signature ~ (T.Text -> Maybe ([Value]) -> m Value), MonadIO m, IsValue a) => O.MethodInfo ValueObjectInvokeMethodMethodInfo a signature where
    overloadedMethod _ = valueObjectInvokeMethod

#endif

-- method Value::object_is_instance_of
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "name", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a class name", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_object_is_instance_of" jsc_value_object_is_instance_of :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    CString ->                              -- name : TBasicType TUTF8
    IO CInt

{- |
Get whether the value referenced by /@value@/ is an instance of class /@name@/.
-}
valueObjectIsInstanceOf ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> T.Text
    {- ^ /@name@/: a class name -}
    -> m Bool
    {- ^ __Returns:__ whether the value is an object instance of class /@name@/. -}
valueObjectIsInstanceOf value name = liftIO $ do
    value' <- unsafeManagedPtrCastPtr value
    name' <- textToCString name
    result <- jsc_value_object_is_instance_of value' name'
    let result' = (/= 0) result
    touchManagedPtr value
    freeMem name'
    return result'

#if ENABLE_OVERLOADING
data ValueObjectIsInstanceOfMethodInfo
instance (signature ~ (T.Text -> m Bool), MonadIO m, IsValue a) => O.MethodInfo ValueObjectIsInstanceOfMethodInfo a signature where
    overloadedMethod _ = valueObjectIsInstanceOf

#endif

-- method Value::object_set_property
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "name", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the property name", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "property", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the #JSCValue to set", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_object_set_property" jsc_value_object_set_property :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    CString ->                              -- name : TBasicType TUTF8
    Ptr Value ->                            -- property : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    IO ()

{- |
Set /@property@/ with /@name@/ on /@value@/.
-}
valueObjectSetProperty ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a, IsValue b) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> T.Text
    {- ^ /@name@/: the property name -}
    -> b
    {- ^ /@property@/: the 'GI.JavaScriptCore.Objects.Value.Value' to set -}
    -> m ()
valueObjectSetProperty value name property = liftIO $ do
    value' <- unsafeManagedPtrCastPtr value
    name' <- textToCString name
    property' <- unsafeManagedPtrCastPtr property
    jsc_value_object_set_property value' name' property'
    touchManagedPtr value
    touchManagedPtr property
    freeMem name'
    return ()

#if ENABLE_OVERLOADING
data ValueObjectSetPropertyMethodInfo
instance (signature ~ (T.Text -> b -> m ()), MonadIO m, IsValue a, IsValue b) => O.MethodInfo ValueObjectSetPropertyMethodInfo a signature where
    overloadedMethod _ = valueObjectSetProperty

#endif

-- method Value::object_set_property_at_index
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "index", argType = TBasicType TUInt, direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the property index", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "property", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "the #JSCValue to set", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_object_set_property_at_index" jsc_value_object_set_property_at_index :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    Word32 ->                               -- index : TBasicType TUInt
    Ptr Value ->                            -- property : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    IO ()

{- |
Set /@property@/ at /@index@/ on /@value@/.
-}
valueObjectSetPropertyAtIndex ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a, IsValue b) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> Word32
    {- ^ /@index@/: the property index -}
    -> b
    {- ^ /@property@/: the 'GI.JavaScriptCore.Objects.Value.Value' to set -}
    -> m ()
valueObjectSetPropertyAtIndex value index property = liftIO $ do
    value' <- unsafeManagedPtrCastPtr value
    property' <- unsafeManagedPtrCastPtr property
    jsc_value_object_set_property_at_index value' index property'
    touchManagedPtr value
    touchManagedPtr property
    return ()

#if ENABLE_OVERLOADING
data ValueObjectSetPropertyAtIndexMethodInfo
instance (signature ~ (Word32 -> b -> m ()), MonadIO m, IsValue a, IsValue b) => O.MethodInfo ValueObjectSetPropertyAtIndexMethodInfo a signature where
    overloadedMethod _ = valueObjectSetPropertyAtIndex

#endif

-- method Value::to_boolean
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_to_boolean" jsc_value_to_boolean :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    IO CInt

{- |
Convert /@value@/ to a boolean.
-}
valueToBoolean ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> m Bool
    {- ^ __Returns:__ a 'Bool' result of the conversion. -}
valueToBoolean value = liftIO $ do
    value' <- unsafeManagedPtrCastPtr value
    result <- jsc_value_to_boolean value'
    let result' = (/= 0) result
    touchManagedPtr value
    return result'

#if ENABLE_OVERLOADING
data ValueToBooleanMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsValue a) => O.MethodInfo ValueToBooleanMethodInfo a signature where
    overloadedMethod _ = valueToBoolean

#endif

-- method Value::to_double
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_to_double" jsc_value_to_double :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    IO CDouble

{- |
Convert /@value@/ to a double.
-}
valueToDouble ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> m Double
    {- ^ __Returns:__ a @/gdouble/@ result of the conversion. -}
valueToDouble value = liftIO $ do
    value' <- unsafeManagedPtrCastPtr value
    result <- jsc_value_to_double value'
    let result' = realToFrac result
    touchManagedPtr value
    return result'

#if ENABLE_OVERLOADING
data ValueToDoubleMethodInfo
instance (signature ~ (m Double), MonadIO m, IsValue a) => O.MethodInfo ValueToDoubleMethodInfo a signature where
    overloadedMethod _ = valueToDouble

#endif

-- method Value::to_int32
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TInt32)
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_to_int32" jsc_value_to_int32 :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    IO Int32

{- |
Convert /@value@/ to a @/gint32/@.
-}
valueToInt32 ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> m Int32
    {- ^ __Returns:__ a @/gint32/@ result of the conversion. -}
valueToInt32 value = liftIO $ do
    value' <- unsafeManagedPtrCastPtr value
    result <- jsc_value_to_int32 value'
    touchManagedPtr value
    return result

#if ENABLE_OVERLOADING
data ValueToInt32MethodInfo
instance (signature ~ (m Int32), MonadIO m, IsValue a) => O.MethodInfo ValueToInt32MethodInfo a signature where
    overloadedMethod _ = valueToInt32

#endif

-- method Value::to_string
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_to_string" jsc_value_to_string :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    IO CString

{- |
Convert /@value@/ to a string. Use 'GI.JavaScriptCore.Objects.Value.valueToStringAsBytes' instead, if you need to
handle strings containing null characters.
-}
valueToString ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> m T.Text
    {- ^ __Returns:__ a null-terminated string result of the conversion. -}
valueToString value = liftIO $ do
    value' <- unsafeManagedPtrCastPtr value
    result <- jsc_value_to_string value'
    checkUnexpectedReturnNULL "valueToString" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr value
    return result'

#if ENABLE_OVERLOADING
data ValueToStringMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsValue a) => O.MethodInfo ValueToStringMethodInfo a signature where
    overloadedMethod _ = valueToString

#endif

-- method Value::to_string_as_bytes
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "GLib", name = "Bytes"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_value_to_string_as_bytes" jsc_value_to_string_as_bytes :: 
    Ptr Value ->                            -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    IO (Ptr GLib.Bytes.Bytes)

{- |
Convert /@value@/ to a string and return the results as 'GI.GLib.Structs.Bytes.Bytes'. This is needed
to handle strings with null characters.
-}
valueToStringAsBytes ::
    (B.CallStack.HasCallStack, MonadIO m, IsValue a) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> m GLib.Bytes.Bytes
    {- ^ __Returns:__ a 'GI.GLib.Structs.Bytes.Bytes' with the result of the conversion. -}
valueToStringAsBytes value = liftIO $ do
    value' <- unsafeManagedPtrCastPtr value
    result <- jsc_value_to_string_as_bytes value'
    checkUnexpectedReturnNULL "valueToStringAsBytes" result
    result' <- (wrapBoxed GLib.Bytes.Bytes) result
    touchManagedPtr value
    return result'

#if ENABLE_OVERLOADING
data ValueToStringAsBytesMethodInfo
instance (signature ~ (m GLib.Bytes.Bytes), MonadIO m, IsValue a) => O.MethodInfo ValueToStringAsBytesMethodInfo a signature where
    overloadedMethod _ = valueToStringAsBytes

#endif


