

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (inaki@blueleaf.cc)

/No description available in the introspection data./
-}

#define ENABLE_OVERLOADING (MIN_VERSION_haskell_gi_overloading(1,0,0) \
       && !defined(__HADDOCK_VERSION__))

module GI.JavaScriptCore.Objects.VirtualMachine
    ( 

-- * Exported types
    VirtualMachine(..)                      ,
    IsVirtualMachine                        ,
    toVirtualMachine                        ,
    noVirtualMachine                        ,


 -- * Methods
-- ** new #method:new#

    virtualMachineNew                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL

import qualified GI.GObject.Objects.Object as GObject.Object

-- | Memory-managed wrapper type.
newtype VirtualMachine = VirtualMachine (ManagedPtr VirtualMachine)
foreign import ccall "jsc_virtual_machine_get_type"
    c_jsc_virtual_machine_get_type :: IO GType

instance GObject VirtualMachine where
    gobjectType = c_jsc_virtual_machine_get_type
    

-- | Type class for types which can be safely cast to `VirtualMachine`, for instance with `toVirtualMachine`.
class (GObject o, O.IsDescendantOf VirtualMachine o) => IsVirtualMachine o
instance (GObject o, O.IsDescendantOf VirtualMachine o) => IsVirtualMachine o

instance O.HasParentTypes VirtualMachine
type instance O.ParentTypes VirtualMachine = '[GObject.Object.Object]

-- | Cast to `VirtualMachine`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toVirtualMachine :: (MonadIO m, IsVirtualMachine o) => o -> m VirtualMachine
toVirtualMachine = liftIO . unsafeCastTo VirtualMachine

-- | A convenience alias for `Nothing` :: `Maybe` `VirtualMachine`.
noVirtualMachine :: Maybe VirtualMachine
noVirtualMachine = Nothing

#if ENABLE_OVERLOADING
type family ResolveVirtualMachineMethod (t :: Symbol) (o :: *) :: * where
    ResolveVirtualMachineMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveVirtualMachineMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveVirtualMachineMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveVirtualMachineMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveVirtualMachineMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveVirtualMachineMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveVirtualMachineMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveVirtualMachineMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveVirtualMachineMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveVirtualMachineMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveVirtualMachineMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveVirtualMachineMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveVirtualMachineMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveVirtualMachineMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveVirtualMachineMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveVirtualMachineMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveVirtualMachineMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveVirtualMachineMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveVirtualMachineMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveVirtualMachineMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveVirtualMachineMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveVirtualMachineMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveVirtualMachineMethod t VirtualMachine, O.MethodInfo info VirtualMachine p) => OL.IsLabel t (VirtualMachine -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod (O.MethodProxy :: O.MethodProxy info)
#else
    fromLabel _ = O.overloadedMethod (O.MethodProxy :: O.MethodProxy info)
#endif

#endif

#if ENABLE_OVERLOADING
instance O.HasAttributeList VirtualMachine
type instance O.AttributeList VirtualMachine = VirtualMachineAttributeList
type VirtualMachineAttributeList = ('[ ] :: [(Symbol, *)])
#endif

#if ENABLE_OVERLOADING
#endif

#if ENABLE_OVERLOADING
type instance O.SignalList VirtualMachine = VirtualMachineSignalList
type VirtualMachineSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, *)])

#endif

-- method VirtualMachine::new
-- method type : Constructor
-- Args : []
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "VirtualMachine"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_virtual_machine_new" jsc_virtual_machine_new :: 
    IO (Ptr VirtualMachine)

{- |
Create a new 'GI.JavaScriptCore.Objects.VirtualMachine.VirtualMachine'.
-}
virtualMachineNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m VirtualMachine
    {- ^ __Returns:__ the newly created 'GI.JavaScriptCore.Objects.VirtualMachine.VirtualMachine'. -}
virtualMachineNew  = liftIO $ do
    result <- jsc_virtual_machine_new
    checkUnexpectedReturnNULL "virtualMachineNew" result
    result' <- (wrapObject VirtualMachine) result
    return result'

#if ENABLE_OVERLOADING
#endif


