

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (inaki@blueleaf.cc)

/No description available in the introspection data./
-}

#define ENABLE_OVERLOADING (MIN_VERSION_haskell_gi_overloading(1,0,0) \
       && !defined(__HADDOCK_VERSION__))

module GI.JavaScriptCore.Objects.WeakValue
    ( 

-- * Exported types
    WeakValue(..)                           ,
    IsWeakValue                             ,
    toWeakValue                             ,
    noWeakValue                             ,


 -- * Methods
-- ** getValue #method:getValue#

#if ENABLE_OVERLOADING
    WeakValueGetValueMethodInfo             ,
#endif
    weakValueGetValue                       ,


-- ** new #method:new#

    weakValueNew                            ,




 -- * Properties
-- ** value #attr:value#
{- | The 'GI.JavaScriptCore.Objects.Value.Value' referencing the JavaScript value.
-}
#if ENABLE_OVERLOADING
    WeakValueValuePropertyInfo              ,
#endif
    constructWeakValueValue                 ,
#if ENABLE_OVERLOADING
    weakValueValue                          ,
#endif




 -- * Signals
-- ** cleared #signal:cleared#

    C_WeakValueClearedCallback              ,
    WeakValueClearedCallback                ,
#if ENABLE_OVERLOADING
    WeakValueClearedSignalInfo              ,
#endif
    afterWeakValueCleared                   ,
    genClosure_WeakValueCleared             ,
    mk_WeakValueClearedCallback             ,
    noWeakValueClearedCallback              ,
    onWeakValueCleared                      ,
    wrap_WeakValueClearedCallback           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL

import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.JavaScriptCore.Objects.Value as JavaScriptCore.Value

-- | Memory-managed wrapper type.
newtype WeakValue = WeakValue (ManagedPtr WeakValue)
foreign import ccall "jsc_weak_value_get_type"
    c_jsc_weak_value_get_type :: IO GType

instance GObject WeakValue where
    gobjectType = c_jsc_weak_value_get_type
    

-- | Type class for types which can be safely cast to `WeakValue`, for instance with `toWeakValue`.
class (GObject o, O.IsDescendantOf WeakValue o) => IsWeakValue o
instance (GObject o, O.IsDescendantOf WeakValue o) => IsWeakValue o

instance O.HasParentTypes WeakValue
type instance O.ParentTypes WeakValue = '[GObject.Object.Object]

-- | Cast to `WeakValue`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toWeakValue :: (MonadIO m, IsWeakValue o) => o -> m WeakValue
toWeakValue = liftIO . unsafeCastTo WeakValue

-- | A convenience alias for `Nothing` :: `Maybe` `WeakValue`.
noWeakValue :: Maybe WeakValue
noWeakValue = Nothing

#if ENABLE_OVERLOADING
type family ResolveWeakValueMethod (t :: Symbol) (o :: *) :: * where
    ResolveWeakValueMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveWeakValueMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveWeakValueMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveWeakValueMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveWeakValueMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveWeakValueMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveWeakValueMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveWeakValueMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveWeakValueMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveWeakValueMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveWeakValueMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveWeakValueMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveWeakValueMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveWeakValueMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveWeakValueMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveWeakValueMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveWeakValueMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveWeakValueMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveWeakValueMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveWeakValueMethod "getValue" o = WeakValueGetValueMethodInfo
    ResolveWeakValueMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveWeakValueMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveWeakValueMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveWeakValueMethod t WeakValue, O.MethodInfo info WeakValue p) => OL.IsLabel t (WeakValue -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod (O.MethodProxy :: O.MethodProxy info)
#else
    fromLabel _ = O.overloadedMethod (O.MethodProxy :: O.MethodProxy info)
#endif

#endif

-- signal WeakValue::cleared
{- |
This signal is emitted when the JavaScript value is destroyed.
-}
type WeakValueClearedCallback =
    IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `WeakValueClearedCallback`@.
noWeakValueClearedCallback :: Maybe WeakValueClearedCallback
noWeakValueClearedCallback = Nothing

-- | Type for the callback on the (unwrapped) C side.
type C_WeakValueClearedCallback =
    Ptr () ->                               -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_WeakValueClearedCallback`.
foreign import ccall "wrapper"
    mk_WeakValueClearedCallback :: C_WeakValueClearedCallback -> IO (FunPtr C_WeakValueClearedCallback)

-- | Wrap the callback into a `GClosure`.
genClosure_WeakValueCleared :: MonadIO m => WeakValueClearedCallback -> m (GClosure C_WeakValueClearedCallback)
genClosure_WeakValueCleared cb = liftIO $ do
    let cb' = wrap_WeakValueClearedCallback cb
    mk_WeakValueClearedCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `WeakValueClearedCallback` into a `C_WeakValueClearedCallback`.
wrap_WeakValueClearedCallback ::
    WeakValueClearedCallback ->
    C_WeakValueClearedCallback
wrap_WeakValueClearedCallback _cb _ _ = do
    _cb 


{- |
Connect a signal handler for the “@cleared@” signal, to be run before the default handler.
When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to

@
'Data.GI.Base.Signals.on' weakValue #cleared callback
@
-}
onWeakValueCleared :: (IsWeakValue a, MonadIO m) => a -> WeakValueClearedCallback -> m SignalHandlerId
onWeakValueCleared obj cb = liftIO $ do
    let cb' = wrap_WeakValueClearedCallback cb
    cb'' <- mk_WeakValueClearedCallback cb'
    connectSignalFunPtr obj "cleared" cb'' SignalConnectBefore

{- |
Connect a signal handler for the “@cleared@” signal, to be run after the default handler.
When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to

@
'Data.GI.Base.Signals.after' weakValue #cleared callback
@
-}
afterWeakValueCleared :: (IsWeakValue a, MonadIO m) => a -> WeakValueClearedCallback -> m SignalHandlerId
afterWeakValueCleared obj cb = liftIO $ do
    let cb' = wrap_WeakValueClearedCallback cb
    cb'' <- mk_WeakValueClearedCallback cb'
    connectSignalFunPtr obj "cleared" cb'' SignalConnectAfter


-- VVV Prop "value"
   -- Type: TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
   -- Flags: [PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

{- |
Construct a `GValueConstruct` with valid value for the “@value@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
-}
constructWeakValueValue :: (IsWeakValue o, JavaScriptCore.Value.IsValue a) => a -> IO (GValueConstruct o)
constructWeakValueValue val = B.Properties.constructObjectPropertyObject "value" (Just val)

#if ENABLE_OVERLOADING
data WeakValueValuePropertyInfo
instance AttrInfo WeakValueValuePropertyInfo where
    type AttrAllowedOps WeakValueValuePropertyInfo = '[ 'AttrConstruct, 'AttrClear]
    type AttrSetTypeConstraint WeakValueValuePropertyInfo = JavaScriptCore.Value.IsValue
    type AttrBaseTypeConstraint WeakValueValuePropertyInfo = IsWeakValue
    type AttrGetType WeakValueValuePropertyInfo = ()
    type AttrLabel WeakValueValuePropertyInfo = "value"
    type AttrOrigin WeakValueValuePropertyInfo = WeakValue
    attrGet _ = undefined
    attrSet _ = undefined
    attrConstruct _ = constructWeakValueValue
    attrClear _ = undefined
#endif

#if ENABLE_OVERLOADING
instance O.HasAttributeList WeakValue
type instance O.AttributeList WeakValue = WeakValueAttributeList
type WeakValueAttributeList = ('[ '("value", WeakValueValuePropertyInfo)] :: [(Symbol, *)])
#endif

#if ENABLE_OVERLOADING
weakValueValue :: AttrLabelProxy "value"
weakValueValue = AttrLabelProxy

#endif

#if ENABLE_OVERLOADING
data WeakValueClearedSignalInfo
instance SignalInfo WeakValueClearedSignalInfo where
    type HaskellCallbackType WeakValueClearedSignalInfo = WeakValueClearedCallback
    connectSignal _ obj cb connectMode = do
        let cb' = wrap_WeakValueClearedCallback cb
        cb'' <- mk_WeakValueClearedCallback cb'
        connectSignalFunPtr obj "cleared" cb'' connectMode

type instance O.SignalList WeakValue = WeakValueSignalList
type WeakValueSignalList = ('[ '("cleared", WeakValueClearedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, *)])

#endif

-- method WeakValue::new
-- method type : Constructor
-- Args : [Arg {argCName = "value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "Value"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "WeakValue"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_weak_value_new" jsc_weak_value_new :: 
    Ptr JavaScriptCore.Value.Value ->       -- value : TInterface (Name {namespace = "JavaScriptCore", name = "Value"})
    IO (Ptr WeakValue)

{- |
Create a new 'GI.JavaScriptCore.Objects.WeakValue.WeakValue' for the JavaScript value referenced by /@value@/.
-}
weakValueNew ::
    (B.CallStack.HasCallStack, MonadIO m, JavaScriptCore.Value.IsValue a) =>
    a
    {- ^ /@value@/: a 'GI.JavaScriptCore.Objects.Value.Value' -}
    -> m WeakValue
    {- ^ __Returns:__ a new 'GI.JavaScriptCore.Objects.WeakValue.WeakValue' -}
weakValueNew value = liftIO $ do
    value' <- unsafeManagedPtrCastPtr value
    result <- jsc_weak_value_new value'
    checkUnexpectedReturnNULL "weakValueNew" result
    result' <- (wrapObject WeakValue) result
    touchManagedPtr value
    return result'

#if ENABLE_OVERLOADING
#endif

-- method WeakValue::get_value
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "weak_value", argType = TInterface (Name {namespace = "JavaScriptCore", name = "WeakValue"}), direction = DirectionIn, mayBeNull = False, argDoc = Documentation {rawDocText = Just "a #JSCWeakValue", sinceVersion = Nothing}, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface (Name {namespace = "JavaScriptCore", name = "Value"}))
-- throws : False
-- Skip return : False

foreign import ccall "jsc_weak_value_get_value" jsc_weak_value_get_value :: 
    Ptr WeakValue ->                        -- weak_value : TInterface (Name {namespace = "JavaScriptCore", name = "WeakValue"})
    IO (Ptr JavaScriptCore.Value.Value)

{- |
Get a 'GI.JavaScriptCore.Objects.Value.Value' referencing the JavaScript value of /@weakValue@/.
-}
weakValueGetValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsWeakValue a) =>
    a
    {- ^ /@weakValue@/: a 'GI.JavaScriptCore.Objects.WeakValue.WeakValue' -}
    -> m JavaScriptCore.Value.Value
    {- ^ __Returns:__ a new 'GI.JavaScriptCore.Objects.Value.Value' or 'Nothing' if /@weakValue@/ was cleared. -}
weakValueGetValue weakValue = liftIO $ do
    weakValue' <- unsafeManagedPtrCastPtr weakValue
    result <- jsc_weak_value_get_value weakValue'
    checkUnexpectedReturnNULL "weakValueGetValue" result
    result' <- (wrapObject JavaScriptCore.Value.Value) result
    touchManagedPtr weakValue
    return result'

#if ENABLE_OVERLOADING
data WeakValueGetValueMethodInfo
instance (signature ~ (m JavaScriptCore.Value.Value), MonadIO m, IsWeakValue a) => O.MethodInfo WeakValueGetValueMethodInfo a signature where
    overloadedMethod _ = weakValueGetValue

#endif


