

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Callbacks
    ( 

 -- * Signals
-- ** URISchemeRequestCallback
    URISchemeRequestCallback                ,
    URISchemeRequestCallbackC               ,
    mkURISchemeRequestCallback              ,
    noURISchemeRequestCallback              ,
    uRISchemeRequestCallbackClosure         ,
    uRISchemeRequestCallbackWrapper         ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types


-- callback URISchemeRequestCallback
uRISchemeRequestCallbackClosure :: URISchemeRequestCallback -> IO Closure
uRISchemeRequestCallbackClosure cb = newCClosure =<< mkURISchemeRequestCallback wrapped
    where wrapped = uRISchemeRequestCallbackWrapper Nothing cb

type URISchemeRequestCallbackC =
    Ptr URISchemeRequest ->
    Ptr () ->
    IO ()

foreign import ccall "wrapper"
    mkURISchemeRequestCallback :: URISchemeRequestCallbackC -> IO (FunPtr URISchemeRequestCallbackC)

type URISchemeRequestCallback =
    URISchemeRequest ->
    IO ()

noURISchemeRequestCallback :: Maybe URISchemeRequestCallback
noURISchemeRequestCallback = Nothing

uRISchemeRequestCallbackWrapper ::
    Maybe (Ptr (FunPtr (URISchemeRequestCallbackC))) ->
    URISchemeRequestCallback ->
    Ptr URISchemeRequest ->
    Ptr () ->
    IO ()
uRISchemeRequestCallbackWrapper funptrptr _cb request _ = do
    request' <- (newObject URISchemeRequest) request
    _cb  request'
    maybeReleaseFunPtr funptrptr


