{-# LANGUAGE PatternSynonyms, ScopedTypeVariables, ViewPatterns #-}


{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Constants
    ( 
    pattern MINOR_VERSION                   ,
    pattern MICRO_VERSION                   ,
    pattern MAJOR_VERSION                   ,
    pattern EDITING_COMMAND_UNDO            ,
    pattern EDITING_COMMAND_SELECT_ALL      ,
    pattern EDITING_COMMAND_REDO            ,
    pattern EDITING_COMMAND_PASTE           ,
    pattern EDITING_COMMAND_INSERT_IMAGE    ,
    pattern EDITING_COMMAND_CUT             ,
    pattern EDITING_COMMAND_CREATE_LINK     ,
    pattern EDITING_COMMAND_COPY            ,

    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks


pattern MINOR_VERSION = 12 :: Int32


pattern MICRO_VERSION = 2 :: Int32


pattern MAJOR_VERSION = 2 :: Int32


pattern EDITING_COMMAND_UNDO = "Undo" :: T.Text


pattern EDITING_COMMAND_SELECT_ALL = "SelectAll" :: T.Text


pattern EDITING_COMMAND_REDO = "Redo" :: T.Text


pattern EDITING_COMMAND_PASTE = "Paste" :: T.Text


pattern EDITING_COMMAND_INSERT_IMAGE = "InsertImage" :: T.Text


pattern EDITING_COMMAND_CUT = "Cut" :: T.Text


pattern EDITING_COMMAND_CREATE_LINK = "CreateLink" :: T.Text


pattern EDITING_COMMAND_COPY = "Copy" :: T.Text


