

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Enums
    ( 
    catchSnapshotError                      ,
    handleSnapshotError                     ,
    catchPrintError                         ,
    handlePrintError                        ,
    catchPolicyError                        ,
    handlePolicyError                       ,
    catchPluginError                        ,
    handlePluginError                       ,
    catchNetworkError                       ,
    handleNetworkError                      ,
    catchJavascriptError                    ,
    handleJavascriptError                   ,
    catchFaviconDatabaseError               ,
    handleFaviconDatabaseError              ,
    catchDownloadError                      ,
    handleDownloadError                     ,

-- * Exported types
    UserStyleLevel(..)                      ,
    UserScriptInjectionTime(..)             ,
    UserContentInjectedFrames(..)           ,
    TLSErrorsPolicy(..)                     ,
    SnapshotRegion(..)                      ,
    SnapshotError(..)                       ,
    ScriptDialogType(..)                    ,
    SaveMode(..)                            ,
    ProcessModel(..)                        ,
    PrintOperationResponse(..)              ,
    PrintError(..)                          ,
    PolicyError(..)                         ,
    PolicyDecisionType(..)                  ,
    PluginError(..)                         ,
    NetworkError(..)                        ,
    NavigationType(..)                      ,
    LoadEvent(..)                           ,
    JavascriptError(..)                     ,
    InsecureContentEvent(..)                ,
    FaviconDatabaseError(..)                ,
    DownloadError(..)                       ,
    CredentialPersistence(..)               ,
    CookiePersistentStorage(..)             ,
    CookieAcceptPolicy(..)                  ,
    ContextMenuAction(..)                   ,
    CacheModel(..)                          ,
    AuthenticationScheme(..)                ,


    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map




-- Enum UserStyleLevel

data UserStyleLevel = 
      UserStyleLevelUser
    | UserStyleLevelAuthor
    | AnotherUserStyleLevel Int
    deriving (Show, Eq)

instance Enum UserStyleLevel where
    fromEnum UserStyleLevelUser = 0
    fromEnum UserStyleLevelAuthor = 1
    fromEnum (AnotherUserStyleLevel k) = k

    toEnum 0 = UserStyleLevelUser
    toEnum 1 = UserStyleLevelAuthor
    toEnum k = AnotherUserStyleLevel k

foreign import ccall "webkit_user_style_level_get_type" c_webkit_user_style_level_get_type :: 
    IO GType

instance BoxedEnum UserStyleLevel where
    boxedEnumType _ = c_webkit_user_style_level_get_type

-- Enum UserScriptInjectionTime

data UserScriptInjectionTime = 
      UserScriptInjectionTimeStart
    | UserScriptInjectionTimeEnd
    | AnotherUserScriptInjectionTime Int
    deriving (Show, Eq)

instance Enum UserScriptInjectionTime where
    fromEnum UserScriptInjectionTimeStart = 0
    fromEnum UserScriptInjectionTimeEnd = 1
    fromEnum (AnotherUserScriptInjectionTime k) = k

    toEnum 0 = UserScriptInjectionTimeStart
    toEnum 1 = UserScriptInjectionTimeEnd
    toEnum k = AnotherUserScriptInjectionTime k

foreign import ccall "webkit_user_script_injection_time_get_type" c_webkit_user_script_injection_time_get_type :: 
    IO GType

instance BoxedEnum UserScriptInjectionTime where
    boxedEnumType _ = c_webkit_user_script_injection_time_get_type

-- Enum UserContentInjectedFrames

data UserContentInjectedFrames = 
      UserContentInjectedFramesAllFrames
    | UserContentInjectedFramesTopFrame
    | AnotherUserContentInjectedFrames Int
    deriving (Show, Eq)

instance Enum UserContentInjectedFrames where
    fromEnum UserContentInjectedFramesAllFrames = 0
    fromEnum UserContentInjectedFramesTopFrame = 1
    fromEnum (AnotherUserContentInjectedFrames k) = k

    toEnum 0 = UserContentInjectedFramesAllFrames
    toEnum 1 = UserContentInjectedFramesTopFrame
    toEnum k = AnotherUserContentInjectedFrames k

foreign import ccall "webkit_user_content_injected_frames_get_type" c_webkit_user_content_injected_frames_get_type :: 
    IO GType

instance BoxedEnum UserContentInjectedFrames where
    boxedEnumType _ = c_webkit_user_content_injected_frames_get_type

-- Enum TLSErrorsPolicy

data TLSErrorsPolicy = 
      TLSErrorsPolicyIgnore
    | TLSErrorsPolicyFail
    | AnotherTLSErrorsPolicy Int
    deriving (Show, Eq)

instance Enum TLSErrorsPolicy where
    fromEnum TLSErrorsPolicyIgnore = 0
    fromEnum TLSErrorsPolicyFail = 1
    fromEnum (AnotherTLSErrorsPolicy k) = k

    toEnum 0 = TLSErrorsPolicyIgnore
    toEnum 1 = TLSErrorsPolicyFail
    toEnum k = AnotherTLSErrorsPolicy k

foreign import ccall "webkit_tls_errors_policy_get_type" c_webkit_tls_errors_policy_get_type :: 
    IO GType

instance BoxedEnum TLSErrorsPolicy where
    boxedEnumType _ = c_webkit_tls_errors_policy_get_type

-- Enum SnapshotRegion

data SnapshotRegion = 
      SnapshotRegionVisible
    | SnapshotRegionFullDocument
    | AnotherSnapshotRegion Int
    deriving (Show, Eq)

instance Enum SnapshotRegion where
    fromEnum SnapshotRegionVisible = 0
    fromEnum SnapshotRegionFullDocument = 1
    fromEnum (AnotherSnapshotRegion k) = k

    toEnum 0 = SnapshotRegionVisible
    toEnum 1 = SnapshotRegionFullDocument
    toEnum k = AnotherSnapshotRegion k

foreign import ccall "webkit_snapshot_region_get_type" c_webkit_snapshot_region_get_type :: 
    IO GType

instance BoxedEnum SnapshotRegion where
    boxedEnumType _ = c_webkit_snapshot_region_get_type

-- Enum SnapshotError

data SnapshotError = 
      SnapshotErrorCreate
    | AnotherSnapshotError Int
    deriving (Show, Eq)

instance Enum SnapshotError where
    fromEnum SnapshotErrorCreate = 799
    fromEnum (AnotherSnapshotError k) = k

    toEnum 799 = SnapshotErrorCreate
    toEnum k = AnotherSnapshotError k

instance GErrorClass SnapshotError where
    gerrorClassDomain _ = "WebKitSnapshotError"

catchSnapshotError ::
    IO a ->
    (SnapshotError -> GErrorMessage -> IO a) ->
    IO a
catchSnapshotError = catchGErrorJustDomain

handleSnapshotError ::
    (SnapshotError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleSnapshotError = handleGErrorJustDomain

foreign import ccall "webkit_snapshot_error_get_type" c_webkit_snapshot_error_get_type :: 
    IO GType

instance BoxedEnum SnapshotError where
    boxedEnumType _ = c_webkit_snapshot_error_get_type

-- Enum ScriptDialogType

data ScriptDialogType = 
      ScriptDialogTypeAlert
    | ScriptDialogTypeConfirm
    | ScriptDialogTypePrompt
    | ScriptDialogTypeBeforeUnloadConfirm
    | AnotherScriptDialogType Int
    deriving (Show, Eq)

instance Enum ScriptDialogType where
    fromEnum ScriptDialogTypeAlert = 0
    fromEnum ScriptDialogTypeConfirm = 1
    fromEnum ScriptDialogTypePrompt = 2
    fromEnum ScriptDialogTypeBeforeUnloadConfirm = 3
    fromEnum (AnotherScriptDialogType k) = k

    toEnum 0 = ScriptDialogTypeAlert
    toEnum 1 = ScriptDialogTypeConfirm
    toEnum 2 = ScriptDialogTypePrompt
    toEnum 3 = ScriptDialogTypeBeforeUnloadConfirm
    toEnum k = AnotherScriptDialogType k

foreign import ccall "webkit_script_dialog_type_get_type" c_webkit_script_dialog_type_get_type :: 
    IO GType

instance BoxedEnum ScriptDialogType where
    boxedEnumType _ = c_webkit_script_dialog_type_get_type

-- Enum SaveMode

data SaveMode = 
      SaveModeMhtml
    | AnotherSaveMode Int
    deriving (Show, Eq)

instance Enum SaveMode where
    fromEnum SaveModeMhtml = 0
    fromEnum (AnotherSaveMode k) = k

    toEnum 0 = SaveModeMhtml
    toEnum k = AnotherSaveMode k

foreign import ccall "webkit_save_mode_get_type" c_webkit_save_mode_get_type :: 
    IO GType

instance BoxedEnum SaveMode where
    boxedEnumType _ = c_webkit_save_mode_get_type

-- Enum ProcessModel

data ProcessModel = 
      ProcessModelSharedSecondaryProcess
    | ProcessModelMultipleSecondaryProcesses
    | AnotherProcessModel Int
    deriving (Show, Eq)

instance Enum ProcessModel where
    fromEnum ProcessModelSharedSecondaryProcess = 0
    fromEnum ProcessModelMultipleSecondaryProcesses = 1
    fromEnum (AnotherProcessModel k) = k

    toEnum 0 = ProcessModelSharedSecondaryProcess
    toEnum 1 = ProcessModelMultipleSecondaryProcesses
    toEnum k = AnotherProcessModel k

foreign import ccall "webkit_process_model_get_type" c_webkit_process_model_get_type :: 
    IO GType

instance BoxedEnum ProcessModel where
    boxedEnumType _ = c_webkit_process_model_get_type

-- Enum PrintOperationResponse

data PrintOperationResponse = 
      PrintOperationResponsePrint
    | PrintOperationResponseCancel
    | AnotherPrintOperationResponse Int
    deriving (Show, Eq)

instance Enum PrintOperationResponse where
    fromEnum PrintOperationResponsePrint = 0
    fromEnum PrintOperationResponseCancel = 1
    fromEnum (AnotherPrintOperationResponse k) = k

    toEnum 0 = PrintOperationResponsePrint
    toEnum 1 = PrintOperationResponseCancel
    toEnum k = AnotherPrintOperationResponse k

foreign import ccall "webkit_print_operation_response_get_type" c_webkit_print_operation_response_get_type :: 
    IO GType

instance BoxedEnum PrintOperationResponse where
    boxedEnumType _ = c_webkit_print_operation_response_get_type

-- Enum PrintError

data PrintError = 
      PrintErrorGeneral
    | PrintErrorPrinterNotFound
    | PrintErrorInvalidPageRange
    | AnotherPrintError Int
    deriving (Show, Eq)

instance Enum PrintError where
    fromEnum PrintErrorGeneral = 599
    fromEnum PrintErrorPrinterNotFound = 500
    fromEnum PrintErrorInvalidPageRange = 501
    fromEnum (AnotherPrintError k) = k

    toEnum 500 = PrintErrorPrinterNotFound
    toEnum 501 = PrintErrorInvalidPageRange
    toEnum 599 = PrintErrorGeneral
    toEnum k = AnotherPrintError k

instance GErrorClass PrintError where
    gerrorClassDomain _ = "WebKitPrintError"

catchPrintError ::
    IO a ->
    (PrintError -> GErrorMessage -> IO a) ->
    IO a
catchPrintError = catchGErrorJustDomain

handlePrintError ::
    (PrintError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handlePrintError = handleGErrorJustDomain

foreign import ccall "webkit_print_error_get_type" c_webkit_print_error_get_type :: 
    IO GType

instance BoxedEnum PrintError where
    boxedEnumType _ = c_webkit_print_error_get_type

-- Enum PolicyError

data PolicyError = 
      PolicyErrorFailed
    | PolicyErrorCannotShowMimeType
    | PolicyErrorCannotShowUri
    | PolicyErrorFrameLoadInterruptedByPolicyChange
    | PolicyErrorCannotUseRestrictedPort
    | AnotherPolicyError Int
    deriving (Show, Eq)

instance Enum PolicyError where
    fromEnum PolicyErrorFailed = 199
    fromEnum PolicyErrorCannotShowMimeType = 100
    fromEnum PolicyErrorCannotShowUri = 101
    fromEnum PolicyErrorFrameLoadInterruptedByPolicyChange = 102
    fromEnum PolicyErrorCannotUseRestrictedPort = 103
    fromEnum (AnotherPolicyError k) = k

    toEnum 100 = PolicyErrorCannotShowMimeType
    toEnum 101 = PolicyErrorCannotShowUri
    toEnum 102 = PolicyErrorFrameLoadInterruptedByPolicyChange
    toEnum 103 = PolicyErrorCannotUseRestrictedPort
    toEnum 199 = PolicyErrorFailed
    toEnum k = AnotherPolicyError k

instance GErrorClass PolicyError where
    gerrorClassDomain _ = "WebKitPolicyError"

catchPolicyError ::
    IO a ->
    (PolicyError -> GErrorMessage -> IO a) ->
    IO a
catchPolicyError = catchGErrorJustDomain

handlePolicyError ::
    (PolicyError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handlePolicyError = handleGErrorJustDomain

foreign import ccall "webkit_policy_error_get_type" c_webkit_policy_error_get_type :: 
    IO GType

instance BoxedEnum PolicyError where
    boxedEnumType _ = c_webkit_policy_error_get_type

-- Enum PolicyDecisionType

data PolicyDecisionType = 
      PolicyDecisionTypeNavigationAction
    | PolicyDecisionTypeNewWindowAction
    | PolicyDecisionTypeResponse
    | AnotherPolicyDecisionType Int
    deriving (Show, Eq)

instance Enum PolicyDecisionType where
    fromEnum PolicyDecisionTypeNavigationAction = 0
    fromEnum PolicyDecisionTypeNewWindowAction = 1
    fromEnum PolicyDecisionTypeResponse = 2
    fromEnum (AnotherPolicyDecisionType k) = k

    toEnum 0 = PolicyDecisionTypeNavigationAction
    toEnum 1 = PolicyDecisionTypeNewWindowAction
    toEnum 2 = PolicyDecisionTypeResponse
    toEnum k = AnotherPolicyDecisionType k

foreign import ccall "webkit_policy_decision_type_get_type" c_webkit_policy_decision_type_get_type :: 
    IO GType

instance BoxedEnum PolicyDecisionType where
    boxedEnumType _ = c_webkit_policy_decision_type_get_type

-- Enum PluginError

data PluginError = 
      PluginErrorFailed
    | PluginErrorCannotFindPlugin
    | PluginErrorCannotLoadPlugin
    | PluginErrorJavaUnavailable
    | PluginErrorConnectionCancelled
    | PluginErrorWillHandleLoad
    | AnotherPluginError Int
    deriving (Show, Eq)

instance Enum PluginError where
    fromEnum PluginErrorFailed = 299
    fromEnum PluginErrorCannotFindPlugin = 200
    fromEnum PluginErrorCannotLoadPlugin = 201
    fromEnum PluginErrorJavaUnavailable = 202
    fromEnum PluginErrorConnectionCancelled = 203
    fromEnum PluginErrorWillHandleLoad = 204
    fromEnum (AnotherPluginError k) = k

    toEnum 200 = PluginErrorCannotFindPlugin
    toEnum 201 = PluginErrorCannotLoadPlugin
    toEnum 202 = PluginErrorJavaUnavailable
    toEnum 203 = PluginErrorConnectionCancelled
    toEnum 204 = PluginErrorWillHandleLoad
    toEnum 299 = PluginErrorFailed
    toEnum k = AnotherPluginError k

instance GErrorClass PluginError where
    gerrorClassDomain _ = "WebKitPluginError"

catchPluginError ::
    IO a ->
    (PluginError -> GErrorMessage -> IO a) ->
    IO a
catchPluginError = catchGErrorJustDomain

handlePluginError ::
    (PluginError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handlePluginError = handleGErrorJustDomain

foreign import ccall "webkit_plugin_error_get_type" c_webkit_plugin_error_get_type :: 
    IO GType

instance BoxedEnum PluginError where
    boxedEnumType _ = c_webkit_plugin_error_get_type

-- Enum NetworkError

data NetworkError = 
      NetworkErrorFailed
    | NetworkErrorTransport
    | NetworkErrorUnknownProtocol
    | NetworkErrorCancelled
    | NetworkErrorFileDoesNotExist
    | AnotherNetworkError Int
    deriving (Show, Eq)

instance Enum NetworkError where
    fromEnum NetworkErrorFailed = 399
    fromEnum NetworkErrorTransport = 300
    fromEnum NetworkErrorUnknownProtocol = 301
    fromEnum NetworkErrorCancelled = 302
    fromEnum NetworkErrorFileDoesNotExist = 303
    fromEnum (AnotherNetworkError k) = k

    toEnum 300 = NetworkErrorTransport
    toEnum 301 = NetworkErrorUnknownProtocol
    toEnum 302 = NetworkErrorCancelled
    toEnum 303 = NetworkErrorFileDoesNotExist
    toEnum 399 = NetworkErrorFailed
    toEnum k = AnotherNetworkError k

instance GErrorClass NetworkError where
    gerrorClassDomain _ = "WebKitNetworkError"

catchNetworkError ::
    IO a ->
    (NetworkError -> GErrorMessage -> IO a) ->
    IO a
catchNetworkError = catchGErrorJustDomain

handleNetworkError ::
    (NetworkError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleNetworkError = handleGErrorJustDomain

foreign import ccall "webkit_network_error_get_type" c_webkit_network_error_get_type :: 
    IO GType

instance BoxedEnum NetworkError where
    boxedEnumType _ = c_webkit_network_error_get_type

-- Enum NavigationType

data NavigationType = 
      NavigationTypeLinkClicked
    | NavigationTypeFormSubmitted
    | NavigationTypeBackForward
    | NavigationTypeReload
    | NavigationTypeFormResubmitted
    | NavigationTypeOther
    | AnotherNavigationType Int
    deriving (Show, Eq)

instance Enum NavigationType where
    fromEnum NavigationTypeLinkClicked = 0
    fromEnum NavigationTypeFormSubmitted = 1
    fromEnum NavigationTypeBackForward = 2
    fromEnum NavigationTypeReload = 3
    fromEnum NavigationTypeFormResubmitted = 4
    fromEnum NavigationTypeOther = 5
    fromEnum (AnotherNavigationType k) = k

    toEnum 0 = NavigationTypeLinkClicked
    toEnum 1 = NavigationTypeFormSubmitted
    toEnum 2 = NavigationTypeBackForward
    toEnum 3 = NavigationTypeReload
    toEnum 4 = NavigationTypeFormResubmitted
    toEnum 5 = NavigationTypeOther
    toEnum k = AnotherNavigationType k

foreign import ccall "webkit_navigation_type_get_type" c_webkit_navigation_type_get_type :: 
    IO GType

instance BoxedEnum NavigationType where
    boxedEnumType _ = c_webkit_navigation_type_get_type

-- Enum LoadEvent

data LoadEvent = 
      LoadEventStarted
    | LoadEventRedirected
    | LoadEventCommitted
    | LoadEventFinished
    | AnotherLoadEvent Int
    deriving (Show, Eq)

instance Enum LoadEvent where
    fromEnum LoadEventStarted = 0
    fromEnum LoadEventRedirected = 1
    fromEnum LoadEventCommitted = 2
    fromEnum LoadEventFinished = 3
    fromEnum (AnotherLoadEvent k) = k

    toEnum 0 = LoadEventStarted
    toEnum 1 = LoadEventRedirected
    toEnum 2 = LoadEventCommitted
    toEnum 3 = LoadEventFinished
    toEnum k = AnotherLoadEvent k

foreign import ccall "webkit_load_event_get_type" c_webkit_load_event_get_type :: 
    IO GType

instance BoxedEnum LoadEvent where
    boxedEnumType _ = c_webkit_load_event_get_type

-- Enum JavascriptError

data JavascriptError = 
      JavascriptErrorFailed
    | AnotherJavascriptError Int
    deriving (Show, Eq)

instance Enum JavascriptError where
    fromEnum JavascriptErrorFailed = 699
    fromEnum (AnotherJavascriptError k) = k

    toEnum 699 = JavascriptErrorFailed
    toEnum k = AnotherJavascriptError k

instance GErrorClass JavascriptError where
    gerrorClassDomain _ = "WebKitJavascriptError"

catchJavascriptError ::
    IO a ->
    (JavascriptError -> GErrorMessage -> IO a) ->
    IO a
catchJavascriptError = catchGErrorJustDomain

handleJavascriptError ::
    (JavascriptError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleJavascriptError = handleGErrorJustDomain

foreign import ccall "webkit_javascript_error_get_type" c_webkit_javascript_error_get_type :: 
    IO GType

instance BoxedEnum JavascriptError where
    boxedEnumType _ = c_webkit_javascript_error_get_type

-- Enum InsecureContentEvent

data InsecureContentEvent = 
      InsecureContentEventRun
    | InsecureContentEventDisplayed
    | AnotherInsecureContentEvent Int
    deriving (Show, Eq)

instance Enum InsecureContentEvent where
    fromEnum InsecureContentEventRun = 0
    fromEnum InsecureContentEventDisplayed = 1
    fromEnum (AnotherInsecureContentEvent k) = k

    toEnum 0 = InsecureContentEventRun
    toEnum 1 = InsecureContentEventDisplayed
    toEnum k = AnotherInsecureContentEvent k

foreign import ccall "webkit_insecure_content_event_get_type" c_webkit_insecure_content_event_get_type :: 
    IO GType

instance BoxedEnum InsecureContentEvent where
    boxedEnumType _ = c_webkit_insecure_content_event_get_type

-- Enum FaviconDatabaseError

data FaviconDatabaseError = 
      FaviconDatabaseErrorNotInitialized
    | FaviconDatabaseErrorFaviconNotFound
    | FaviconDatabaseErrorFaviconUnknown
    | AnotherFaviconDatabaseError Int
    deriving (Show, Eq)

instance Enum FaviconDatabaseError where
    fromEnum FaviconDatabaseErrorNotInitialized = 0
    fromEnum FaviconDatabaseErrorFaviconNotFound = 1
    fromEnum FaviconDatabaseErrorFaviconUnknown = 2
    fromEnum (AnotherFaviconDatabaseError k) = k

    toEnum 0 = FaviconDatabaseErrorNotInitialized
    toEnum 1 = FaviconDatabaseErrorFaviconNotFound
    toEnum 2 = FaviconDatabaseErrorFaviconUnknown
    toEnum k = AnotherFaviconDatabaseError k

instance GErrorClass FaviconDatabaseError where
    gerrorClassDomain _ = "WebKitFaviconDatabaseError"

catchFaviconDatabaseError ::
    IO a ->
    (FaviconDatabaseError -> GErrorMessage -> IO a) ->
    IO a
catchFaviconDatabaseError = catchGErrorJustDomain

handleFaviconDatabaseError ::
    (FaviconDatabaseError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleFaviconDatabaseError = handleGErrorJustDomain

foreign import ccall "webkit_favicon_database_error_get_type" c_webkit_favicon_database_error_get_type :: 
    IO GType

instance BoxedEnum FaviconDatabaseError where
    boxedEnumType _ = c_webkit_favicon_database_error_get_type

-- Enum DownloadError

data DownloadError = 
      DownloadErrorNetwork
    | DownloadErrorCancelledByUser
    | DownloadErrorDestination
    | AnotherDownloadError Int
    deriving (Show, Eq)

instance Enum DownloadError where
    fromEnum DownloadErrorNetwork = 499
    fromEnum DownloadErrorCancelledByUser = 400
    fromEnum DownloadErrorDestination = 401
    fromEnum (AnotherDownloadError k) = k

    toEnum 400 = DownloadErrorCancelledByUser
    toEnum 401 = DownloadErrorDestination
    toEnum 499 = DownloadErrorNetwork
    toEnum k = AnotherDownloadError k

instance GErrorClass DownloadError where
    gerrorClassDomain _ = "WebKitDownloadError"

catchDownloadError ::
    IO a ->
    (DownloadError -> GErrorMessage -> IO a) ->
    IO a
catchDownloadError = catchGErrorJustDomain

handleDownloadError ::
    (DownloadError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleDownloadError = handleGErrorJustDomain

foreign import ccall "webkit_download_error_get_type" c_webkit_download_error_get_type :: 
    IO GType

instance BoxedEnum DownloadError where
    boxedEnumType _ = c_webkit_download_error_get_type

-- Enum CredentialPersistence

data CredentialPersistence = 
      CredentialPersistenceNone
    | CredentialPersistenceForSession
    | CredentialPersistencePermanent
    | AnotherCredentialPersistence Int
    deriving (Show, Eq)

instance Enum CredentialPersistence where
    fromEnum CredentialPersistenceNone = 0
    fromEnum CredentialPersistenceForSession = 1
    fromEnum CredentialPersistencePermanent = 2
    fromEnum (AnotherCredentialPersistence k) = k

    toEnum 0 = CredentialPersistenceNone
    toEnum 1 = CredentialPersistenceForSession
    toEnum 2 = CredentialPersistencePermanent
    toEnum k = AnotherCredentialPersistence k

foreign import ccall "webkit_credential_persistence_get_type" c_webkit_credential_persistence_get_type :: 
    IO GType

instance BoxedEnum CredentialPersistence where
    boxedEnumType _ = c_webkit_credential_persistence_get_type

-- Enum CookiePersistentStorage

data CookiePersistentStorage = 
      CookiePersistentStorageText
    | CookiePersistentStorageSqlite
    | AnotherCookiePersistentStorage Int
    deriving (Show, Eq)

instance Enum CookiePersistentStorage where
    fromEnum CookiePersistentStorageText = 0
    fromEnum CookiePersistentStorageSqlite = 1
    fromEnum (AnotherCookiePersistentStorage k) = k

    toEnum 0 = CookiePersistentStorageText
    toEnum 1 = CookiePersistentStorageSqlite
    toEnum k = AnotherCookiePersistentStorage k

foreign import ccall "webkit_cookie_persistent_storage_get_type" c_webkit_cookie_persistent_storage_get_type :: 
    IO GType

instance BoxedEnum CookiePersistentStorage where
    boxedEnumType _ = c_webkit_cookie_persistent_storage_get_type

-- Enum CookieAcceptPolicy

data CookieAcceptPolicy = 
      CookieAcceptPolicyAlways
    | CookieAcceptPolicyNever
    | CookieAcceptPolicyNoThirdParty
    | AnotherCookieAcceptPolicy Int
    deriving (Show, Eq)

instance Enum CookieAcceptPolicy where
    fromEnum CookieAcceptPolicyAlways = 0
    fromEnum CookieAcceptPolicyNever = 1
    fromEnum CookieAcceptPolicyNoThirdParty = 2
    fromEnum (AnotherCookieAcceptPolicy k) = k

    toEnum 0 = CookieAcceptPolicyAlways
    toEnum 1 = CookieAcceptPolicyNever
    toEnum 2 = CookieAcceptPolicyNoThirdParty
    toEnum k = AnotherCookieAcceptPolicy k

foreign import ccall "webkit_cookie_accept_policy_get_type" c_webkit_cookie_accept_policy_get_type :: 
    IO GType

instance BoxedEnum CookieAcceptPolicy where
    boxedEnumType _ = c_webkit_cookie_accept_policy_get_type

-- Enum ContextMenuAction

data ContextMenuAction = 
      ContextMenuActionNoAction
    | ContextMenuActionOpenLink
    | ContextMenuActionOpenLinkInNewWindow
    | ContextMenuActionDownloadLinkToDisk
    | ContextMenuActionCopyLinkToClipboard
    | ContextMenuActionOpenImageInNewWindow
    | ContextMenuActionDownloadImageToDisk
    | ContextMenuActionCopyImageToClipboard
    | ContextMenuActionCopyImageUrlToClipboard
    | ContextMenuActionOpenFrameInNewWindow
    | ContextMenuActionGoBack
    | ContextMenuActionGoForward
    | ContextMenuActionStop
    | ContextMenuActionReload
    | ContextMenuActionCopy
    | ContextMenuActionCut
    | ContextMenuActionPaste
    | ContextMenuActionDelete
    | ContextMenuActionSelectAll
    | ContextMenuActionInputMethods
    | ContextMenuActionUnicode
    | ContextMenuActionSpellingGuess
    | ContextMenuActionNoGuessesFound
    | ContextMenuActionIgnoreSpelling
    | ContextMenuActionLearnSpelling
    | ContextMenuActionIgnoreGrammar
    | ContextMenuActionFontMenu
    | ContextMenuActionBold
    | ContextMenuActionItalic
    | ContextMenuActionUnderline
    | ContextMenuActionOutline
    | ContextMenuActionInspectElement
    | ContextMenuActionOpenVideoInNewWindow
    | ContextMenuActionOpenAudioInNewWindow
    | ContextMenuActionCopyVideoLinkToClipboard
    | ContextMenuActionCopyAudioLinkToClipboard
    | ContextMenuActionToggleMediaControls
    | ContextMenuActionToggleMediaLoop
    | ContextMenuActionEnterVideoFullscreen
    | ContextMenuActionMediaPlay
    | ContextMenuActionMediaPause
    | ContextMenuActionMediaMute
    | ContextMenuActionDownloadVideoToDisk
    | ContextMenuActionDownloadAudioToDisk
    | ContextMenuActionCustom
    | AnotherContextMenuAction Int
    deriving (Show, Eq)

instance Enum ContextMenuAction where
    fromEnum ContextMenuActionNoAction = 0
    fromEnum ContextMenuActionOpenLink = 1
    fromEnum ContextMenuActionOpenLinkInNewWindow = 2
    fromEnum ContextMenuActionDownloadLinkToDisk = 3
    fromEnum ContextMenuActionCopyLinkToClipboard = 4
    fromEnum ContextMenuActionOpenImageInNewWindow = 5
    fromEnum ContextMenuActionDownloadImageToDisk = 6
    fromEnum ContextMenuActionCopyImageToClipboard = 7
    fromEnum ContextMenuActionCopyImageUrlToClipboard = 8
    fromEnum ContextMenuActionOpenFrameInNewWindow = 9
    fromEnum ContextMenuActionGoBack = 10
    fromEnum ContextMenuActionGoForward = 11
    fromEnum ContextMenuActionStop = 12
    fromEnum ContextMenuActionReload = 13
    fromEnum ContextMenuActionCopy = 14
    fromEnum ContextMenuActionCut = 15
    fromEnum ContextMenuActionPaste = 16
    fromEnum ContextMenuActionDelete = 17
    fromEnum ContextMenuActionSelectAll = 18
    fromEnum ContextMenuActionInputMethods = 19
    fromEnum ContextMenuActionUnicode = 20
    fromEnum ContextMenuActionSpellingGuess = 21
    fromEnum ContextMenuActionNoGuessesFound = 22
    fromEnum ContextMenuActionIgnoreSpelling = 23
    fromEnum ContextMenuActionLearnSpelling = 24
    fromEnum ContextMenuActionIgnoreGrammar = 25
    fromEnum ContextMenuActionFontMenu = 26
    fromEnum ContextMenuActionBold = 27
    fromEnum ContextMenuActionItalic = 28
    fromEnum ContextMenuActionUnderline = 29
    fromEnum ContextMenuActionOutline = 30
    fromEnum ContextMenuActionInspectElement = 31
    fromEnum ContextMenuActionOpenVideoInNewWindow = 32
    fromEnum ContextMenuActionOpenAudioInNewWindow = 33
    fromEnum ContextMenuActionCopyVideoLinkToClipboard = 34
    fromEnum ContextMenuActionCopyAudioLinkToClipboard = 35
    fromEnum ContextMenuActionToggleMediaControls = 36
    fromEnum ContextMenuActionToggleMediaLoop = 37
    fromEnum ContextMenuActionEnterVideoFullscreen = 38
    fromEnum ContextMenuActionMediaPlay = 39
    fromEnum ContextMenuActionMediaPause = 40
    fromEnum ContextMenuActionMediaMute = 41
    fromEnum ContextMenuActionDownloadVideoToDisk = 42
    fromEnum ContextMenuActionDownloadAudioToDisk = 43
    fromEnum ContextMenuActionCustom = 10000
    fromEnum (AnotherContextMenuAction k) = k

    toEnum 0 = ContextMenuActionNoAction
    toEnum 1 = ContextMenuActionOpenLink
    toEnum 2 = ContextMenuActionOpenLinkInNewWindow
    toEnum 3 = ContextMenuActionDownloadLinkToDisk
    toEnum 4 = ContextMenuActionCopyLinkToClipboard
    toEnum 5 = ContextMenuActionOpenImageInNewWindow
    toEnum 6 = ContextMenuActionDownloadImageToDisk
    toEnum 7 = ContextMenuActionCopyImageToClipboard
    toEnum 8 = ContextMenuActionCopyImageUrlToClipboard
    toEnum 9 = ContextMenuActionOpenFrameInNewWindow
    toEnum 10 = ContextMenuActionGoBack
    toEnum 11 = ContextMenuActionGoForward
    toEnum 12 = ContextMenuActionStop
    toEnum 13 = ContextMenuActionReload
    toEnum 14 = ContextMenuActionCopy
    toEnum 15 = ContextMenuActionCut
    toEnum 16 = ContextMenuActionPaste
    toEnum 17 = ContextMenuActionDelete
    toEnum 18 = ContextMenuActionSelectAll
    toEnum 19 = ContextMenuActionInputMethods
    toEnum 20 = ContextMenuActionUnicode
    toEnum 21 = ContextMenuActionSpellingGuess
    toEnum 22 = ContextMenuActionNoGuessesFound
    toEnum 23 = ContextMenuActionIgnoreSpelling
    toEnum 24 = ContextMenuActionLearnSpelling
    toEnum 25 = ContextMenuActionIgnoreGrammar
    toEnum 26 = ContextMenuActionFontMenu
    toEnum 27 = ContextMenuActionBold
    toEnum 28 = ContextMenuActionItalic
    toEnum 29 = ContextMenuActionUnderline
    toEnum 30 = ContextMenuActionOutline
    toEnum 31 = ContextMenuActionInspectElement
    toEnum 32 = ContextMenuActionOpenVideoInNewWindow
    toEnum 33 = ContextMenuActionOpenAudioInNewWindow
    toEnum 34 = ContextMenuActionCopyVideoLinkToClipboard
    toEnum 35 = ContextMenuActionCopyAudioLinkToClipboard
    toEnum 36 = ContextMenuActionToggleMediaControls
    toEnum 37 = ContextMenuActionToggleMediaLoop
    toEnum 38 = ContextMenuActionEnterVideoFullscreen
    toEnum 39 = ContextMenuActionMediaPlay
    toEnum 40 = ContextMenuActionMediaPause
    toEnum 41 = ContextMenuActionMediaMute
    toEnum 42 = ContextMenuActionDownloadVideoToDisk
    toEnum 43 = ContextMenuActionDownloadAudioToDisk
    toEnum 10000 = ContextMenuActionCustom
    toEnum k = AnotherContextMenuAction k

foreign import ccall "webkit_context_menu_action_get_type" c_webkit_context_menu_action_get_type :: 
    IO GType

instance BoxedEnum ContextMenuAction where
    boxedEnumType _ = c_webkit_context_menu_action_get_type

-- Enum CacheModel

data CacheModel = 
      CacheModelDocumentViewer
    | CacheModelWebBrowser
    | CacheModelDocumentBrowser
    | AnotherCacheModel Int
    deriving (Show, Eq)

instance Enum CacheModel where
    fromEnum CacheModelDocumentViewer = 0
    fromEnum CacheModelWebBrowser = 1
    fromEnum CacheModelDocumentBrowser = 2
    fromEnum (AnotherCacheModel k) = k

    toEnum 0 = CacheModelDocumentViewer
    toEnum 1 = CacheModelWebBrowser
    toEnum 2 = CacheModelDocumentBrowser
    toEnum k = AnotherCacheModel k

foreign import ccall "webkit_cache_model_get_type" c_webkit_cache_model_get_type :: 
    IO GType

instance BoxedEnum CacheModel where
    boxedEnumType _ = c_webkit_cache_model_get_type

-- Enum AuthenticationScheme

data AuthenticationScheme = 
      AuthenticationSchemeDefault
    | AuthenticationSchemeHttpBasic
    | AuthenticationSchemeHttpDigest
    | AuthenticationSchemeHtmlForm
    | AuthenticationSchemeNtlm
    | AuthenticationSchemeNegotiate
    | AuthenticationSchemeClientCertificateRequested
    | AuthenticationSchemeServerTrustEvaluationRequested
    | AuthenticationSchemeUnknown
    | AnotherAuthenticationScheme Int
    deriving (Show, Eq)

instance Enum AuthenticationScheme where
    fromEnum AuthenticationSchemeDefault = 1
    fromEnum AuthenticationSchemeHttpBasic = 2
    fromEnum AuthenticationSchemeHttpDigest = 3
    fromEnum AuthenticationSchemeHtmlForm = 4
    fromEnum AuthenticationSchemeNtlm = 5
    fromEnum AuthenticationSchemeNegotiate = 6
    fromEnum AuthenticationSchemeClientCertificateRequested = 7
    fromEnum AuthenticationSchemeServerTrustEvaluationRequested = 8
    fromEnum AuthenticationSchemeUnknown = 100
    fromEnum (AnotherAuthenticationScheme k) = k

    toEnum 1 = AuthenticationSchemeDefault
    toEnum 2 = AuthenticationSchemeHttpBasic
    toEnum 3 = AuthenticationSchemeHttpDigest
    toEnum 4 = AuthenticationSchemeHtmlForm
    toEnum 5 = AuthenticationSchemeNtlm
    toEnum 6 = AuthenticationSchemeNegotiate
    toEnum 7 = AuthenticationSchemeClientCertificateRequested
    toEnum 8 = AuthenticationSchemeServerTrustEvaluationRequested
    toEnum 100 = AuthenticationSchemeUnknown
    toEnum k = AnotherAuthenticationScheme k

foreign import ccall "webkit_authentication_scheme_get_type" c_webkit_authentication_scheme_get_type :: 
    IO GType

instance BoxedEnum AuthenticationScheme where
    boxedEnumType _ = c_webkit_authentication_scheme_get_type


