

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Flags
    ( 

-- * Exported types
    SnapshotOptions(..)                     ,
    HitTestResultContext(..)                ,
    FindOptions(..)                         ,
    EditorTypingAttributes(..)              ,


    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map




-- Flags SnapshotOptions

data SnapshotOptions = 
      SnapshotOptionsNone
    | SnapshotOptionsIncludeSelectionHighlighting
    | SnapshotOptionsTransparentBackground
    | AnotherSnapshotOptions Int
    deriving (Show, Eq)

instance Enum SnapshotOptions where
    fromEnum SnapshotOptionsNone = 0
    fromEnum SnapshotOptionsIncludeSelectionHighlighting = 1
    fromEnum SnapshotOptionsTransparentBackground = 2
    fromEnum (AnotherSnapshotOptions k) = k

    toEnum 0 = SnapshotOptionsNone
    toEnum 1 = SnapshotOptionsIncludeSelectionHighlighting
    toEnum 2 = SnapshotOptionsTransparentBackground
    toEnum k = AnotherSnapshotOptions k

foreign import ccall "webkit_snapshot_options_get_type" c_webkit_snapshot_options_get_type :: 
    IO GType

instance BoxedFlags SnapshotOptions where
    boxedFlagsType _ = c_webkit_snapshot_options_get_type

instance IsGFlag SnapshotOptions

-- Flags HitTestResultContext

data HitTestResultContext = 
      HitTestResultContextDocument
    | HitTestResultContextLink
    | HitTestResultContextImage
    | HitTestResultContextMedia
    | HitTestResultContextEditable
    | HitTestResultContextScrollbar
    | HitTestResultContextSelection
    | AnotherHitTestResultContext Int
    deriving (Show, Eq)

instance Enum HitTestResultContext where
    fromEnum HitTestResultContextDocument = 2
    fromEnum HitTestResultContextLink = 4
    fromEnum HitTestResultContextImage = 8
    fromEnum HitTestResultContextMedia = 16
    fromEnum HitTestResultContextEditable = 32
    fromEnum HitTestResultContextScrollbar = 64
    fromEnum HitTestResultContextSelection = 128
    fromEnum (AnotherHitTestResultContext k) = k

    toEnum 2 = HitTestResultContextDocument
    toEnum 4 = HitTestResultContextLink
    toEnum 8 = HitTestResultContextImage
    toEnum 16 = HitTestResultContextMedia
    toEnum 32 = HitTestResultContextEditable
    toEnum 64 = HitTestResultContextScrollbar
    toEnum 128 = HitTestResultContextSelection
    toEnum k = AnotherHitTestResultContext k

foreign import ccall "webkit_hit_test_result_context_get_type" c_webkit_hit_test_result_context_get_type :: 
    IO GType

instance BoxedFlags HitTestResultContext where
    boxedFlagsType _ = c_webkit_hit_test_result_context_get_type

instance IsGFlag HitTestResultContext

-- Flags FindOptions

data FindOptions = 
      FindOptionsNone
    | FindOptionsCaseInsensitive
    | FindOptionsAtWordStarts
    | FindOptionsTreatMedialCapitalAsWordStart
    | FindOptionsBackwards
    | FindOptionsWrapAround
    | AnotherFindOptions Int
    deriving (Show, Eq)

instance Enum FindOptions where
    fromEnum FindOptionsNone = 0
    fromEnum FindOptionsCaseInsensitive = 1
    fromEnum FindOptionsAtWordStarts = 2
    fromEnum FindOptionsTreatMedialCapitalAsWordStart = 4
    fromEnum FindOptionsBackwards = 8
    fromEnum FindOptionsWrapAround = 16
    fromEnum (AnotherFindOptions k) = k

    toEnum 0 = FindOptionsNone
    toEnum 1 = FindOptionsCaseInsensitive
    toEnum 2 = FindOptionsAtWordStarts
    toEnum 4 = FindOptionsTreatMedialCapitalAsWordStart
    toEnum 8 = FindOptionsBackwards
    toEnum 16 = FindOptionsWrapAround
    toEnum k = AnotherFindOptions k

foreign import ccall "webkit_find_options_get_type" c_webkit_find_options_get_type :: 
    IO GType

instance BoxedFlags FindOptions where
    boxedFlagsType _ = c_webkit_find_options_get_type

instance IsGFlag FindOptions

-- Flags EditorTypingAttributes

data EditorTypingAttributes = 
      EditorTypingAttributesNone
    | EditorTypingAttributesBold
    | EditorTypingAttributesItalic
    | EditorTypingAttributesUnderline
    | EditorTypingAttributesStrikethrough
    | AnotherEditorTypingAttributes Int
    deriving (Show, Eq)

instance Enum EditorTypingAttributes where
    fromEnum EditorTypingAttributesNone = 2
    fromEnum EditorTypingAttributesBold = 4
    fromEnum EditorTypingAttributesItalic = 8
    fromEnum EditorTypingAttributesUnderline = 16
    fromEnum EditorTypingAttributesStrikethrough = 32
    fromEnum (AnotherEditorTypingAttributes k) = k

    toEnum 2 = EditorTypingAttributesNone
    toEnum 4 = EditorTypingAttributesBold
    toEnum 8 = EditorTypingAttributesItalic
    toEnum 16 = EditorTypingAttributesUnderline
    toEnum 32 = EditorTypingAttributesStrikethrough
    toEnum k = AnotherEditorTypingAttributes k

foreign import ccall "webkit_editor_typing_attributes_get_type" c_webkit_editor_typing_attributes_get_type :: 
    IO GType

instance BoxedFlags EditorTypingAttributes where
    boxedFlagsType _ = c_webkit_editor_typing_attributes_get_type

instance IsGFlag EditorTypingAttributes


