

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Functions
    ( 

 -- * Methods
-- ** getMajorVersion
    getMajorVersion                         ,


-- ** getMicroVersion
    getMicroVersion                         ,


-- ** getMinorVersion
    getMinorVersion                         ,


-- ** userMediaPermissionIsForAudioDevice
    userMediaPermissionIsForAudioDevice     ,


-- ** userMediaPermissionIsForVideoDevice
    userMediaPermissionIsForVideoDevice     ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks

-- function webkit_user_media_permission_is_for_video_device
-- Args : [Arg {argCName = "request", argType = TInterface "WebKit2" "UserMediaPermissionRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_user_media_permission_is_for_video_device" webkit_user_media_permission_is_for_video_device :: 
    Ptr UserMediaPermissionRequest ->       -- request : TInterface "WebKit2" "UserMediaPermissionRequest"
    IO CInt


userMediaPermissionIsForVideoDevice ::
    (MonadIO m, UserMediaPermissionRequestK a) =>
    a                                       -- request
    -> m Bool                               -- result
userMediaPermissionIsForVideoDevice request = liftIO $ do
    let request' = unsafeManagedPtrCastPtr request
    result <- webkit_user_media_permission_is_for_video_device request'
    let result' = (/= 0) result
    touchManagedPtr request
    return result'


-- function webkit_user_media_permission_is_for_audio_device
-- Args : [Arg {argCName = "request", argType = TInterface "WebKit2" "UserMediaPermissionRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_user_media_permission_is_for_audio_device" webkit_user_media_permission_is_for_audio_device :: 
    Ptr UserMediaPermissionRequest ->       -- request : TInterface "WebKit2" "UserMediaPermissionRequest"
    IO CInt


userMediaPermissionIsForAudioDevice ::
    (MonadIO m, UserMediaPermissionRequestK a) =>
    a                                       -- request
    -> m Bool                               -- result
userMediaPermissionIsForAudioDevice request = liftIO $ do
    let request' = unsafeManagedPtrCastPtr request
    result <- webkit_user_media_permission_is_for_audio_device request'
    let result' = (/= 0) result
    touchManagedPtr request
    return result'


-- function webkit_get_minor_version
-- Args : []
-- Lengths : []
-- returnType : Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_get_minor_version" webkit_get_minor_version :: 
    IO Word32


getMinorVersion ::
    (MonadIO m) =>
    m Word32                                -- result
getMinorVersion  = liftIO $ do
    result <- webkit_get_minor_version
    return result


-- function webkit_get_micro_version
-- Args : []
-- Lengths : []
-- returnType : Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_get_micro_version" webkit_get_micro_version :: 
    IO Word32


getMicroVersion ::
    (MonadIO m) =>
    m Word32                                -- result
getMicroVersion  = liftIO $ do
    result <- webkit_get_micro_version
    return result


-- function webkit_get_major_version
-- Args : []
-- Lengths : []
-- returnType : Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_get_major_version" webkit_get_major_version :: 
    IO Word32


getMajorVersion ::
    (MonadIO m) =>
    m Word32                                -- result
getMajorVersion  = liftIO $ do
    result <- webkit_get_major_version
    return result



