

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Interfaces.PermissionRequest
    ( 

-- * Exported types
    PermissionRequest(..)                   ,
    noPermissionRequest                     ,
    PermissionRequestK                      ,
    toPermissionRequest                     ,


 -- * Methods
-- ** permissionRequestAllow
    PermissionRequestAllowMethodInfo        ,
    permissionRequestAllow                  ,


-- ** permissionRequestDeny
    PermissionRequestDenyMethodInfo         ,
    permissionRequestDeny                   ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject

-- interface PermissionRequest 

newtype PermissionRequest = PermissionRequest (ForeignPtr PermissionRequest)
noPermissionRequest :: Maybe PermissionRequest
noPermissionRequest = Nothing

type family ResolvePermissionRequestMethod (t :: Symbol) (o :: *) :: * where
    ResolvePermissionRequestMethod "allow" o = PermissionRequestAllowMethodInfo
    ResolvePermissionRequestMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolvePermissionRequestMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolvePermissionRequestMethod "deny" o = PermissionRequestDenyMethodInfo
    ResolvePermissionRequestMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolvePermissionRequestMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolvePermissionRequestMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolvePermissionRequestMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolvePermissionRequestMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolvePermissionRequestMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolvePermissionRequestMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolvePermissionRequestMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolvePermissionRequestMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolvePermissionRequestMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolvePermissionRequestMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolvePermissionRequestMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolvePermissionRequestMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolvePermissionRequestMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolvePermissionRequestMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolvePermissionRequestMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolvePermissionRequestMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolvePermissionRequestMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolvePermissionRequestMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolvePermissionRequestMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolvePermissionRequestMethod l o = MethodResolutionFailed l o

instance (info ~ ResolvePermissionRequestMethod t PermissionRequest, MethodInfo info PermissionRequest p) => IsLabelProxy t (PermissionRequest -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolvePermissionRequestMethod t PermissionRequest, MethodInfo info PermissionRequest p) => IsLabel t (PermissionRequest -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

type instance AttributeList PermissionRequest = PermissionRequestAttributeList
type PermissionRequestAttributeList = ('[ ] :: [(Symbol, *)])

type instance SignalList PermissionRequest = PermissionRequestSignalList
type PermissionRequestSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

foreign import ccall "webkit_permission_request_get_type"
    c_webkit_permission_request_get_type :: IO GType

type instance ParentTypes PermissionRequest = PermissionRequestParentTypes
type PermissionRequestParentTypes = '[GObject.Object]

instance GObject PermissionRequest where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_permission_request_get_type
    

class GObject o => PermissionRequestK o
instance (GObject o, IsDescendantOf PermissionRequest o) => PermissionRequestK o

toPermissionRequest :: PermissionRequestK o => o -> IO PermissionRequest
toPermissionRequest = unsafeCastTo PermissionRequest

-- method PermissionRequest::allow
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "PermissionRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_permission_request_allow" webkit_permission_request_allow :: 
    Ptr PermissionRequest ->                -- _obj : TInterface "WebKit2" "PermissionRequest"
    IO ()


permissionRequestAllow ::
    (MonadIO m, PermissionRequestK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
permissionRequestAllow _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_permission_request_allow _obj'
    touchManagedPtr _obj
    return ()

data PermissionRequestAllowMethodInfo
instance (signature ~ (m ()), MonadIO m, PermissionRequestK a) => MethodInfo PermissionRequestAllowMethodInfo a signature where
    overloadedMethod _ = permissionRequestAllow

-- method PermissionRequest::deny
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "PermissionRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_permission_request_deny" webkit_permission_request_deny :: 
    Ptr PermissionRequest ->                -- _obj : TInterface "WebKit2" "PermissionRequest"
    IO ()


permissionRequestDeny ::
    (MonadIO m, PermissionRequestK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
permissionRequestDeny _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_permission_request_deny _obj'
    touchManagedPtr _obj
    return ()

data PermissionRequestDenyMethodInfo
instance (signature ~ (m ()), MonadIO m, PermissionRequestK a) => MethodInfo PermissionRequestDenyMethodInfo a signature where
    overloadedMethod _ = permissionRequestDeny


