

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.AuthenticationRequest
    ( 

-- * Exported types
    AuthenticationRequest(..)               ,
    AuthenticationRequestK                  ,
    toAuthenticationRequest                 ,
    noAuthenticationRequest                 ,


 -- * Methods
-- ** authenticationRequestAuthenticate
    AuthenticationRequestAuthenticateMethodInfo,
    authenticationRequestAuthenticate       ,


-- ** authenticationRequestCanSaveCredentials
    AuthenticationRequestCanSaveCredentialsMethodInfo,
    authenticationRequestCanSaveCredentials ,


-- ** authenticationRequestCancel
    AuthenticationRequestCancelMethodInfo   ,
    authenticationRequestCancel             ,


-- ** authenticationRequestGetHost
    AuthenticationRequestGetHostMethodInfo  ,
    authenticationRequestGetHost            ,


-- ** authenticationRequestGetPort
    AuthenticationRequestGetPortMethodInfo  ,
    authenticationRequestGetPort            ,


-- ** authenticationRequestGetProposedCredential
    AuthenticationRequestGetProposedCredentialMethodInfo,
    authenticationRequestGetProposedCredential,


-- ** authenticationRequestGetRealm
    AuthenticationRequestGetRealmMethodInfo ,
    authenticationRequestGetRealm           ,


-- ** authenticationRequestGetScheme
    AuthenticationRequestGetSchemeMethodInfo,
    authenticationRequestGetScheme          ,


-- ** authenticationRequestIsForProxy
    AuthenticationRequestIsForProxyMethodInfo,
    authenticationRequestIsForProxy         ,


-- ** authenticationRequestIsRetry
    AuthenticationRequestIsRetryMethodInfo  ,
    authenticationRequestIsRetry            ,




 -- * Signals
-- ** Cancelled
    AuthenticationRequestCancelledCallback  ,
    AuthenticationRequestCancelledCallbackC ,
    AuthenticationRequestCancelledSignalInfo,
    afterAuthenticationRequestCancelled     ,
    authenticationRequestCancelledCallbackWrapper,
    authenticationRequestCancelledClosure   ,
    mkAuthenticationRequestCancelledCallback,
    noAuthenticationRequestCancelledCallback,
    onAuthenticationRequestCancelled        ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject

newtype AuthenticationRequest = AuthenticationRequest (ForeignPtr AuthenticationRequest)
foreign import ccall "webkit_authentication_request_get_type"
    c_webkit_authentication_request_get_type :: IO GType

type instance ParentTypes AuthenticationRequest = AuthenticationRequestParentTypes
type AuthenticationRequestParentTypes = '[GObject.Object]

instance GObject AuthenticationRequest where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_authentication_request_get_type
    

class GObject o => AuthenticationRequestK o
instance (GObject o, IsDescendantOf AuthenticationRequest o) => AuthenticationRequestK o

toAuthenticationRequest :: AuthenticationRequestK o => o -> IO AuthenticationRequest
toAuthenticationRequest = unsafeCastTo AuthenticationRequest

noAuthenticationRequest :: Maybe AuthenticationRequest
noAuthenticationRequest = Nothing

type family ResolveAuthenticationRequestMethod (t :: Symbol) (o :: *) :: * where
    ResolveAuthenticationRequestMethod "authenticate" o = AuthenticationRequestAuthenticateMethodInfo
    ResolveAuthenticationRequestMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveAuthenticationRequestMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveAuthenticationRequestMethod "canSaveCredentials" o = AuthenticationRequestCanSaveCredentialsMethodInfo
    ResolveAuthenticationRequestMethod "cancel" o = AuthenticationRequestCancelMethodInfo
    ResolveAuthenticationRequestMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveAuthenticationRequestMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveAuthenticationRequestMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveAuthenticationRequestMethod "isForProxy" o = AuthenticationRequestIsForProxyMethodInfo
    ResolveAuthenticationRequestMethod "isRetry" o = AuthenticationRequestIsRetryMethodInfo
    ResolveAuthenticationRequestMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveAuthenticationRequestMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveAuthenticationRequestMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveAuthenticationRequestMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveAuthenticationRequestMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveAuthenticationRequestMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveAuthenticationRequestMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveAuthenticationRequestMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveAuthenticationRequestMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveAuthenticationRequestMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveAuthenticationRequestMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveAuthenticationRequestMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveAuthenticationRequestMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveAuthenticationRequestMethod "getHost" o = AuthenticationRequestGetHostMethodInfo
    ResolveAuthenticationRequestMethod "getPort" o = AuthenticationRequestGetPortMethodInfo
    ResolveAuthenticationRequestMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveAuthenticationRequestMethod "getProposedCredential" o = AuthenticationRequestGetProposedCredentialMethodInfo
    ResolveAuthenticationRequestMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveAuthenticationRequestMethod "getRealm" o = AuthenticationRequestGetRealmMethodInfo
    ResolveAuthenticationRequestMethod "getScheme" o = AuthenticationRequestGetSchemeMethodInfo
    ResolveAuthenticationRequestMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveAuthenticationRequestMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveAuthenticationRequestMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveAuthenticationRequestMethod t AuthenticationRequest, MethodInfo info AuthenticationRequest p) => IsLabelProxy t (AuthenticationRequest -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveAuthenticationRequestMethod t AuthenticationRequest, MethodInfo info AuthenticationRequest p) => IsLabel t (AuthenticationRequest -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- signal AuthenticationRequest::cancelled
type AuthenticationRequestCancelledCallback =
    IO ()

noAuthenticationRequestCancelledCallback :: Maybe AuthenticationRequestCancelledCallback
noAuthenticationRequestCancelledCallback = Nothing

type AuthenticationRequestCancelledCallbackC =
    Ptr () ->                               -- object
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkAuthenticationRequestCancelledCallback :: AuthenticationRequestCancelledCallbackC -> IO (FunPtr AuthenticationRequestCancelledCallbackC)

authenticationRequestCancelledClosure :: AuthenticationRequestCancelledCallback -> IO Closure
authenticationRequestCancelledClosure cb = newCClosure =<< mkAuthenticationRequestCancelledCallback wrapped
    where wrapped = authenticationRequestCancelledCallbackWrapper cb

authenticationRequestCancelledCallbackWrapper ::
    AuthenticationRequestCancelledCallback ->
    Ptr () ->
    Ptr () ->
    IO ()
authenticationRequestCancelledCallbackWrapper _cb _ _ = do
    _cb 

onAuthenticationRequestCancelled :: (GObject a, MonadIO m) => a -> AuthenticationRequestCancelledCallback -> m SignalHandlerId
onAuthenticationRequestCancelled obj cb = liftIO $ connectAuthenticationRequestCancelled obj cb SignalConnectBefore
afterAuthenticationRequestCancelled :: (GObject a, MonadIO m) => a -> AuthenticationRequestCancelledCallback -> m SignalHandlerId
afterAuthenticationRequestCancelled obj cb = connectAuthenticationRequestCancelled obj cb SignalConnectAfter

connectAuthenticationRequestCancelled :: (GObject a, MonadIO m) =>
                                         a -> AuthenticationRequestCancelledCallback -> SignalConnectMode -> m SignalHandlerId
connectAuthenticationRequestCancelled obj cb after = liftIO $ do
    cb' <- mkAuthenticationRequestCancelledCallback (authenticationRequestCancelledCallbackWrapper cb)
    connectSignalFunPtr obj "cancelled" cb' after

type instance AttributeList AuthenticationRequest = AuthenticationRequestAttributeList
type AuthenticationRequestAttributeList = ('[ ] :: [(Symbol, *)])

data AuthenticationRequestCancelledSignalInfo
instance SignalInfo AuthenticationRequestCancelledSignalInfo where
    type HaskellCallbackType AuthenticationRequestCancelledSignalInfo = AuthenticationRequestCancelledCallback
    connectSignal _ = connectAuthenticationRequestCancelled

type instance SignalList AuthenticationRequest = AuthenticationRequestSignalList
type AuthenticationRequestSignalList = ('[ '("cancelled", AuthenticationRequestCancelledSignalInfo), '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method AuthenticationRequest::authenticate
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "AuthenticationRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "credential", argType = TInterface "WebKit2" "Credential", direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_authentication_request_authenticate" webkit_authentication_request_authenticate :: 
    Ptr AuthenticationRequest ->            -- _obj : TInterface "WebKit2" "AuthenticationRequest"
    Ptr Credential ->                       -- credential : TInterface "WebKit2" "Credential"
    IO ()


authenticationRequestAuthenticate ::
    (MonadIO m, AuthenticationRequestK a) =>
    a                                       -- _obj
    -> Maybe (Credential)                   -- credential
    -> m ()                                 -- result
authenticationRequestAuthenticate _obj credential = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    maybeCredential <- case credential of
        Nothing -> return nullPtr
        Just jCredential -> do
            let jCredential' = unsafeManagedPtrGetPtr jCredential
            return jCredential'
    webkit_authentication_request_authenticate _obj' maybeCredential
    touchManagedPtr _obj
    whenJust credential touchManagedPtr
    return ()

data AuthenticationRequestAuthenticateMethodInfo
instance (signature ~ (Maybe (Credential) -> m ()), MonadIO m, AuthenticationRequestK a) => MethodInfo AuthenticationRequestAuthenticateMethodInfo a signature where
    overloadedMethod _ = authenticationRequestAuthenticate

-- method AuthenticationRequest::can_save_credentials
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "AuthenticationRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_authentication_request_can_save_credentials" webkit_authentication_request_can_save_credentials :: 
    Ptr AuthenticationRequest ->            -- _obj : TInterface "WebKit2" "AuthenticationRequest"
    IO CInt


authenticationRequestCanSaveCredentials ::
    (MonadIO m, AuthenticationRequestK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
authenticationRequestCanSaveCredentials _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_authentication_request_can_save_credentials _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data AuthenticationRequestCanSaveCredentialsMethodInfo
instance (signature ~ (m Bool), MonadIO m, AuthenticationRequestK a) => MethodInfo AuthenticationRequestCanSaveCredentialsMethodInfo a signature where
    overloadedMethod _ = authenticationRequestCanSaveCredentials

-- method AuthenticationRequest::cancel
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "AuthenticationRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_authentication_request_cancel" webkit_authentication_request_cancel :: 
    Ptr AuthenticationRequest ->            -- _obj : TInterface "WebKit2" "AuthenticationRequest"
    IO ()


authenticationRequestCancel ::
    (MonadIO m, AuthenticationRequestK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
authenticationRequestCancel _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_authentication_request_cancel _obj'
    touchManagedPtr _obj
    return ()

data AuthenticationRequestCancelMethodInfo
instance (signature ~ (m ()), MonadIO m, AuthenticationRequestK a) => MethodInfo AuthenticationRequestCancelMethodInfo a signature where
    overloadedMethod _ = authenticationRequestCancel

-- method AuthenticationRequest::get_host
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "AuthenticationRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_authentication_request_get_host" webkit_authentication_request_get_host :: 
    Ptr AuthenticationRequest ->            -- _obj : TInterface "WebKit2" "AuthenticationRequest"
    IO CString


authenticationRequestGetHost ::
    (MonadIO m, AuthenticationRequestK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
authenticationRequestGetHost _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_authentication_request_get_host _obj'
    checkUnexpectedReturnNULL "webkit_authentication_request_get_host" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data AuthenticationRequestGetHostMethodInfo
instance (signature ~ (m T.Text), MonadIO m, AuthenticationRequestK a) => MethodInfo AuthenticationRequestGetHostMethodInfo a signature where
    overloadedMethod _ = authenticationRequestGetHost

-- method AuthenticationRequest::get_port
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "AuthenticationRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_authentication_request_get_port" webkit_authentication_request_get_port :: 
    Ptr AuthenticationRequest ->            -- _obj : TInterface "WebKit2" "AuthenticationRequest"
    IO Word32


authenticationRequestGetPort ::
    (MonadIO m, AuthenticationRequestK a) =>
    a                                       -- _obj
    -> m Word32                             -- result
authenticationRequestGetPort _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_authentication_request_get_port _obj'
    touchManagedPtr _obj
    return result

data AuthenticationRequestGetPortMethodInfo
instance (signature ~ (m Word32), MonadIO m, AuthenticationRequestK a) => MethodInfo AuthenticationRequestGetPortMethodInfo a signature where
    overloadedMethod _ = authenticationRequestGetPort

-- method AuthenticationRequest::get_proposed_credential
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "AuthenticationRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "Credential")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_authentication_request_get_proposed_credential" webkit_authentication_request_get_proposed_credential :: 
    Ptr AuthenticationRequest ->            -- _obj : TInterface "WebKit2" "AuthenticationRequest"
    IO (Ptr Credential)


authenticationRequestGetProposedCredential ::
    (MonadIO m, AuthenticationRequestK a) =>
    a                                       -- _obj
    -> m Credential                         -- result
authenticationRequestGetProposedCredential _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_authentication_request_get_proposed_credential _obj'
    checkUnexpectedReturnNULL "webkit_authentication_request_get_proposed_credential" result
    result' <- (wrapBoxed Credential) result
    touchManagedPtr _obj
    return result'

data AuthenticationRequestGetProposedCredentialMethodInfo
instance (signature ~ (m Credential), MonadIO m, AuthenticationRequestK a) => MethodInfo AuthenticationRequestGetProposedCredentialMethodInfo a signature where
    overloadedMethod _ = authenticationRequestGetProposedCredential

-- method AuthenticationRequest::get_realm
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "AuthenticationRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_authentication_request_get_realm" webkit_authentication_request_get_realm :: 
    Ptr AuthenticationRequest ->            -- _obj : TInterface "WebKit2" "AuthenticationRequest"
    IO CString


authenticationRequestGetRealm ::
    (MonadIO m, AuthenticationRequestK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
authenticationRequestGetRealm _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_authentication_request_get_realm _obj'
    checkUnexpectedReturnNULL "webkit_authentication_request_get_realm" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data AuthenticationRequestGetRealmMethodInfo
instance (signature ~ (m T.Text), MonadIO m, AuthenticationRequestK a) => MethodInfo AuthenticationRequestGetRealmMethodInfo a signature where
    overloadedMethod _ = authenticationRequestGetRealm

-- method AuthenticationRequest::get_scheme
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "AuthenticationRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "AuthenticationScheme")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_authentication_request_get_scheme" webkit_authentication_request_get_scheme :: 
    Ptr AuthenticationRequest ->            -- _obj : TInterface "WebKit2" "AuthenticationRequest"
    IO CUInt


authenticationRequestGetScheme ::
    (MonadIO m, AuthenticationRequestK a) =>
    a                                       -- _obj
    -> m AuthenticationScheme               -- result
authenticationRequestGetScheme _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_authentication_request_get_scheme _obj'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr _obj
    return result'

data AuthenticationRequestGetSchemeMethodInfo
instance (signature ~ (m AuthenticationScheme), MonadIO m, AuthenticationRequestK a) => MethodInfo AuthenticationRequestGetSchemeMethodInfo a signature where
    overloadedMethod _ = authenticationRequestGetScheme

-- method AuthenticationRequest::is_for_proxy
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "AuthenticationRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_authentication_request_is_for_proxy" webkit_authentication_request_is_for_proxy :: 
    Ptr AuthenticationRequest ->            -- _obj : TInterface "WebKit2" "AuthenticationRequest"
    IO CInt


authenticationRequestIsForProxy ::
    (MonadIO m, AuthenticationRequestK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
authenticationRequestIsForProxy _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_authentication_request_is_for_proxy _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data AuthenticationRequestIsForProxyMethodInfo
instance (signature ~ (m Bool), MonadIO m, AuthenticationRequestK a) => MethodInfo AuthenticationRequestIsForProxyMethodInfo a signature where
    overloadedMethod _ = authenticationRequestIsForProxy

-- method AuthenticationRequest::is_retry
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "AuthenticationRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_authentication_request_is_retry" webkit_authentication_request_is_retry :: 
    Ptr AuthenticationRequest ->            -- _obj : TInterface "WebKit2" "AuthenticationRequest"
    IO CInt


authenticationRequestIsRetry ::
    (MonadIO m, AuthenticationRequestK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
authenticationRequestIsRetry _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_authentication_request_is_retry _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data AuthenticationRequestIsRetryMethodInfo
instance (signature ~ (m Bool), MonadIO m, AuthenticationRequestK a) => MethodInfo AuthenticationRequestIsRetryMethodInfo a signature where
    overloadedMethod _ = authenticationRequestIsRetry


