

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.BackForwardList
    ( 

-- * Exported types
    BackForwardList(..)                     ,
    BackForwardListK                        ,
    toBackForwardList                       ,
    noBackForwardList                       ,


 -- * Methods
-- ** backForwardListGetBackItem
    BackForwardListGetBackItemMethodInfo    ,
    backForwardListGetBackItem              ,


-- ** backForwardListGetBackList
    BackForwardListGetBackListMethodInfo    ,
    backForwardListGetBackList              ,


-- ** backForwardListGetBackListWithLimit
    BackForwardListGetBackListWithLimitMethodInfo,
    backForwardListGetBackListWithLimit     ,


-- ** backForwardListGetCurrentItem
    BackForwardListGetCurrentItemMethodInfo ,
    backForwardListGetCurrentItem           ,


-- ** backForwardListGetForwardItem
    BackForwardListGetForwardItemMethodInfo ,
    backForwardListGetForwardItem           ,


-- ** backForwardListGetForwardList
    BackForwardListGetForwardListMethodInfo ,
    backForwardListGetForwardList           ,


-- ** backForwardListGetForwardListWithLimit
    BackForwardListGetForwardListWithLimitMethodInfo,
    backForwardListGetForwardListWithLimit  ,


-- ** backForwardListGetLength
    BackForwardListGetLengthMethodInfo      ,
    backForwardListGetLength                ,


-- ** backForwardListGetNthItem
    BackForwardListGetNthItemMethodInfo     ,
    backForwardListGetNthItem               ,




 -- * Signals
-- ** Changed
    BackForwardListChangedCallback          ,
    BackForwardListChangedCallbackC         ,
    BackForwardListChangedSignalInfo        ,
    afterBackForwardListChanged             ,
    backForwardListChangedCallbackWrapper   ,
    backForwardListChangedClosure           ,
    mkBackForwardListChangedCallback        ,
    noBackForwardListChangedCallback        ,
    onBackForwardListChanged                ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject

newtype BackForwardList = BackForwardList (ForeignPtr BackForwardList)
foreign import ccall "webkit_back_forward_list_get_type"
    c_webkit_back_forward_list_get_type :: IO GType

type instance ParentTypes BackForwardList = BackForwardListParentTypes
type BackForwardListParentTypes = '[GObject.Object]

instance GObject BackForwardList where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_back_forward_list_get_type
    

class GObject o => BackForwardListK o
instance (GObject o, IsDescendantOf BackForwardList o) => BackForwardListK o

toBackForwardList :: BackForwardListK o => o -> IO BackForwardList
toBackForwardList = unsafeCastTo BackForwardList

noBackForwardList :: Maybe BackForwardList
noBackForwardList = Nothing

type family ResolveBackForwardListMethod (t :: Symbol) (o :: *) :: * where
    ResolveBackForwardListMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveBackForwardListMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveBackForwardListMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveBackForwardListMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveBackForwardListMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveBackForwardListMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveBackForwardListMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveBackForwardListMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveBackForwardListMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveBackForwardListMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveBackForwardListMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveBackForwardListMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveBackForwardListMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveBackForwardListMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveBackForwardListMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveBackForwardListMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveBackForwardListMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveBackForwardListMethod "getBackItem" o = BackForwardListGetBackItemMethodInfo
    ResolveBackForwardListMethod "getBackList" o = BackForwardListGetBackListMethodInfo
    ResolveBackForwardListMethod "getBackListWithLimit" o = BackForwardListGetBackListWithLimitMethodInfo
    ResolveBackForwardListMethod "getCurrentItem" o = BackForwardListGetCurrentItemMethodInfo
    ResolveBackForwardListMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveBackForwardListMethod "getForwardItem" o = BackForwardListGetForwardItemMethodInfo
    ResolveBackForwardListMethod "getForwardList" o = BackForwardListGetForwardListMethodInfo
    ResolveBackForwardListMethod "getForwardListWithLimit" o = BackForwardListGetForwardListWithLimitMethodInfo
    ResolveBackForwardListMethod "getLength" o = BackForwardListGetLengthMethodInfo
    ResolveBackForwardListMethod "getNthItem" o = BackForwardListGetNthItemMethodInfo
    ResolveBackForwardListMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveBackForwardListMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveBackForwardListMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveBackForwardListMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveBackForwardListMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveBackForwardListMethod t BackForwardList, MethodInfo info BackForwardList p) => IsLabelProxy t (BackForwardList -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveBackForwardListMethod t BackForwardList, MethodInfo info BackForwardList p) => IsLabel t (BackForwardList -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- signal BackForwardList::changed
type BackForwardListChangedCallback =
    Maybe BackForwardListItem ->
    Ptr () ->
    IO ()

noBackForwardListChangedCallback :: Maybe BackForwardListChangedCallback
noBackForwardListChangedCallback = Nothing

type BackForwardListChangedCallbackC =
    Ptr () ->                               -- object
    Ptr BackForwardListItem ->
    Ptr () ->
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkBackForwardListChangedCallback :: BackForwardListChangedCallbackC -> IO (FunPtr BackForwardListChangedCallbackC)

backForwardListChangedClosure :: BackForwardListChangedCallback -> IO Closure
backForwardListChangedClosure cb = newCClosure =<< mkBackForwardListChangedCallback wrapped
    where wrapped = backForwardListChangedCallbackWrapper cb

backForwardListChangedCallbackWrapper ::
    BackForwardListChangedCallback ->
    Ptr () ->
    Ptr BackForwardListItem ->
    Ptr () ->
    Ptr () ->
    IO ()
backForwardListChangedCallbackWrapper _cb _ itemAdded itemsRemoved _ = do
    maybeItemAdded <-
        if itemAdded == nullPtr
        then return Nothing
        else do
            itemAdded' <- (newObject BackForwardListItem) itemAdded
            return $ Just itemAdded'
    _cb  maybeItemAdded itemsRemoved

onBackForwardListChanged :: (GObject a, MonadIO m) => a -> BackForwardListChangedCallback -> m SignalHandlerId
onBackForwardListChanged obj cb = liftIO $ connectBackForwardListChanged obj cb SignalConnectBefore
afterBackForwardListChanged :: (GObject a, MonadIO m) => a -> BackForwardListChangedCallback -> m SignalHandlerId
afterBackForwardListChanged obj cb = connectBackForwardListChanged obj cb SignalConnectAfter

connectBackForwardListChanged :: (GObject a, MonadIO m) =>
                                 a -> BackForwardListChangedCallback -> SignalConnectMode -> m SignalHandlerId
connectBackForwardListChanged obj cb after = liftIO $ do
    cb' <- mkBackForwardListChangedCallback (backForwardListChangedCallbackWrapper cb)
    connectSignalFunPtr obj "changed" cb' after

type instance AttributeList BackForwardList = BackForwardListAttributeList
type BackForwardListAttributeList = ('[ ] :: [(Symbol, *)])

data BackForwardListChangedSignalInfo
instance SignalInfo BackForwardListChangedSignalInfo where
    type HaskellCallbackType BackForwardListChangedSignalInfo = BackForwardListChangedCallback
    connectSignal _ = connectBackForwardListChanged

type instance SignalList BackForwardList = BackForwardListSignalList
type BackForwardListSignalList = ('[ '("changed", BackForwardListChangedSignalInfo), '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method BackForwardList::get_back_item
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "BackForwardList", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "BackForwardListItem")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_back_forward_list_get_back_item" webkit_back_forward_list_get_back_item :: 
    Ptr BackForwardList ->                  -- _obj : TInterface "WebKit2" "BackForwardList"
    IO (Ptr BackForwardListItem)


backForwardListGetBackItem ::
    (MonadIO m, BackForwardListK a) =>
    a                                       -- _obj
    -> m BackForwardListItem                -- result
backForwardListGetBackItem _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_back_forward_list_get_back_item _obj'
    checkUnexpectedReturnNULL "webkit_back_forward_list_get_back_item" result
    result' <- (newObject BackForwardListItem) result
    touchManagedPtr _obj
    return result'

data BackForwardListGetBackItemMethodInfo
instance (signature ~ (m BackForwardListItem), MonadIO m, BackForwardListK a) => MethodInfo BackForwardListGetBackItemMethodInfo a signature where
    overloadedMethod _ = backForwardListGetBackItem

-- method BackForwardList::get_back_list
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "BackForwardList", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TGList (TInterface "WebKit2" "BackForwardListItem"))
-- throws : False
-- Skip return : False

foreign import ccall "webkit_back_forward_list_get_back_list" webkit_back_forward_list_get_back_list :: 
    Ptr BackForwardList ->                  -- _obj : TInterface "WebKit2" "BackForwardList"
    IO (Ptr (GList (Ptr BackForwardListItem)))


backForwardListGetBackList ::
    (MonadIO m, BackForwardListK a) =>
    a                                       -- _obj
    -> m [BackForwardListItem]              -- result
backForwardListGetBackList _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_back_forward_list_get_back_list _obj'
    result' <- unpackGList result
    result'' <- mapM (newObject BackForwardListItem) result'
    g_list_free result
    touchManagedPtr _obj
    return result''

data BackForwardListGetBackListMethodInfo
instance (signature ~ (m [BackForwardListItem]), MonadIO m, BackForwardListK a) => MethodInfo BackForwardListGetBackListMethodInfo a signature where
    overloadedMethod _ = backForwardListGetBackList

-- method BackForwardList::get_back_list_with_limit
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "BackForwardList", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "limit", argType = TBasicType TUInt, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TGList (TInterface "WebKit2" "BackForwardListItem"))
-- throws : False
-- Skip return : False

foreign import ccall "webkit_back_forward_list_get_back_list_with_limit" webkit_back_forward_list_get_back_list_with_limit :: 
    Ptr BackForwardList ->                  -- _obj : TInterface "WebKit2" "BackForwardList"
    Word32 ->                               -- limit : TBasicType TUInt
    IO (Ptr (GList (Ptr BackForwardListItem)))


backForwardListGetBackListWithLimit ::
    (MonadIO m, BackForwardListK a) =>
    a                                       -- _obj
    -> Word32                               -- limit
    -> m [BackForwardListItem]              -- result
backForwardListGetBackListWithLimit _obj limit = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_back_forward_list_get_back_list_with_limit _obj' limit
    result' <- unpackGList result
    result'' <- mapM (newObject BackForwardListItem) result'
    g_list_free result
    touchManagedPtr _obj
    return result''

data BackForwardListGetBackListWithLimitMethodInfo
instance (signature ~ (Word32 -> m [BackForwardListItem]), MonadIO m, BackForwardListK a) => MethodInfo BackForwardListGetBackListWithLimitMethodInfo a signature where
    overloadedMethod _ = backForwardListGetBackListWithLimit

-- method BackForwardList::get_current_item
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "BackForwardList", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "BackForwardListItem")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_back_forward_list_get_current_item" webkit_back_forward_list_get_current_item :: 
    Ptr BackForwardList ->                  -- _obj : TInterface "WebKit2" "BackForwardList"
    IO (Ptr BackForwardListItem)


backForwardListGetCurrentItem ::
    (MonadIO m, BackForwardListK a) =>
    a                                       -- _obj
    -> m BackForwardListItem                -- result
backForwardListGetCurrentItem _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_back_forward_list_get_current_item _obj'
    checkUnexpectedReturnNULL "webkit_back_forward_list_get_current_item" result
    result' <- (newObject BackForwardListItem) result
    touchManagedPtr _obj
    return result'

data BackForwardListGetCurrentItemMethodInfo
instance (signature ~ (m BackForwardListItem), MonadIO m, BackForwardListK a) => MethodInfo BackForwardListGetCurrentItemMethodInfo a signature where
    overloadedMethod _ = backForwardListGetCurrentItem

-- method BackForwardList::get_forward_item
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "BackForwardList", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "BackForwardListItem")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_back_forward_list_get_forward_item" webkit_back_forward_list_get_forward_item :: 
    Ptr BackForwardList ->                  -- _obj : TInterface "WebKit2" "BackForwardList"
    IO (Ptr BackForwardListItem)


backForwardListGetForwardItem ::
    (MonadIO m, BackForwardListK a) =>
    a                                       -- _obj
    -> m BackForwardListItem                -- result
backForwardListGetForwardItem _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_back_forward_list_get_forward_item _obj'
    checkUnexpectedReturnNULL "webkit_back_forward_list_get_forward_item" result
    result' <- (newObject BackForwardListItem) result
    touchManagedPtr _obj
    return result'

data BackForwardListGetForwardItemMethodInfo
instance (signature ~ (m BackForwardListItem), MonadIO m, BackForwardListK a) => MethodInfo BackForwardListGetForwardItemMethodInfo a signature where
    overloadedMethod _ = backForwardListGetForwardItem

-- method BackForwardList::get_forward_list
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "BackForwardList", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TGList (TInterface "WebKit2" "BackForwardListItem"))
-- throws : False
-- Skip return : False

foreign import ccall "webkit_back_forward_list_get_forward_list" webkit_back_forward_list_get_forward_list :: 
    Ptr BackForwardList ->                  -- _obj : TInterface "WebKit2" "BackForwardList"
    IO (Ptr (GList (Ptr BackForwardListItem)))


backForwardListGetForwardList ::
    (MonadIO m, BackForwardListK a) =>
    a                                       -- _obj
    -> m [BackForwardListItem]              -- result
backForwardListGetForwardList _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_back_forward_list_get_forward_list _obj'
    result' <- unpackGList result
    result'' <- mapM (newObject BackForwardListItem) result'
    g_list_free result
    touchManagedPtr _obj
    return result''

data BackForwardListGetForwardListMethodInfo
instance (signature ~ (m [BackForwardListItem]), MonadIO m, BackForwardListK a) => MethodInfo BackForwardListGetForwardListMethodInfo a signature where
    overloadedMethod _ = backForwardListGetForwardList

-- method BackForwardList::get_forward_list_with_limit
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "BackForwardList", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "limit", argType = TBasicType TUInt, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TGList (TInterface "WebKit2" "BackForwardListItem"))
-- throws : False
-- Skip return : False

foreign import ccall "webkit_back_forward_list_get_forward_list_with_limit" webkit_back_forward_list_get_forward_list_with_limit :: 
    Ptr BackForwardList ->                  -- _obj : TInterface "WebKit2" "BackForwardList"
    Word32 ->                               -- limit : TBasicType TUInt
    IO (Ptr (GList (Ptr BackForwardListItem)))


backForwardListGetForwardListWithLimit ::
    (MonadIO m, BackForwardListK a) =>
    a                                       -- _obj
    -> Word32                               -- limit
    -> m [BackForwardListItem]              -- result
backForwardListGetForwardListWithLimit _obj limit = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_back_forward_list_get_forward_list_with_limit _obj' limit
    result' <- unpackGList result
    result'' <- mapM (newObject BackForwardListItem) result'
    g_list_free result
    touchManagedPtr _obj
    return result''

data BackForwardListGetForwardListWithLimitMethodInfo
instance (signature ~ (Word32 -> m [BackForwardListItem]), MonadIO m, BackForwardListK a) => MethodInfo BackForwardListGetForwardListWithLimitMethodInfo a signature where
    overloadedMethod _ = backForwardListGetForwardListWithLimit

-- method BackForwardList::get_length
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "BackForwardList", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_back_forward_list_get_length" webkit_back_forward_list_get_length :: 
    Ptr BackForwardList ->                  -- _obj : TInterface "WebKit2" "BackForwardList"
    IO Word32


backForwardListGetLength ::
    (MonadIO m, BackForwardListK a) =>
    a                                       -- _obj
    -> m Word32                             -- result
backForwardListGetLength _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_back_forward_list_get_length _obj'
    touchManagedPtr _obj
    return result

data BackForwardListGetLengthMethodInfo
instance (signature ~ (m Word32), MonadIO m, BackForwardListK a) => MethodInfo BackForwardListGetLengthMethodInfo a signature where
    overloadedMethod _ = backForwardListGetLength

-- method BackForwardList::get_nth_item
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "BackForwardList", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "index", argType = TBasicType TInt, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "BackForwardListItem")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_back_forward_list_get_nth_item" webkit_back_forward_list_get_nth_item :: 
    Ptr BackForwardList ->                  -- _obj : TInterface "WebKit2" "BackForwardList"
    Int32 ->                                -- index : TBasicType TInt
    IO (Ptr BackForwardListItem)


backForwardListGetNthItem ::
    (MonadIO m, BackForwardListK a) =>
    a                                       -- _obj
    -> Int32                                -- index
    -> m BackForwardListItem                -- result
backForwardListGetNthItem _obj index = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_back_forward_list_get_nth_item _obj' index
    checkUnexpectedReturnNULL "webkit_back_forward_list_get_nth_item" result
    result' <- (newObject BackForwardListItem) result
    touchManagedPtr _obj
    return result'

data BackForwardListGetNthItemMethodInfo
instance (signature ~ (Int32 -> m BackForwardListItem), MonadIO m, BackForwardListK a) => MethodInfo BackForwardListGetNthItemMethodInfo a signature where
    overloadedMethod _ = backForwardListGetNthItem


