

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.BackForwardListItem
    ( 

-- * Exported types
    BackForwardListItem(..)                 ,
    BackForwardListItemK                    ,
    toBackForwardListItem                   ,
    noBackForwardListItem                   ,


 -- * Methods
-- ** backForwardListItemGetOriginalUri
    BackForwardListItemGetOriginalUriMethodInfo,
    backForwardListItemGetOriginalUri       ,


-- ** backForwardListItemGetTitle
    BackForwardListItemGetTitleMethodInfo   ,
    backForwardListItemGetTitle             ,


-- ** backForwardListItemGetUri
    BackForwardListItemGetUriMethodInfo     ,
    backForwardListItemGetUri               ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject

newtype BackForwardListItem = BackForwardListItem (ForeignPtr BackForwardListItem)
foreign import ccall "webkit_back_forward_list_item_get_type"
    c_webkit_back_forward_list_item_get_type :: IO GType

type instance ParentTypes BackForwardListItem = BackForwardListItemParentTypes
type BackForwardListItemParentTypes = '[GObject.Object]

instance GObject BackForwardListItem where
    gobjectIsInitiallyUnowned _ = True
    gobjectType _ = c_webkit_back_forward_list_item_get_type
    

class GObject o => BackForwardListItemK o
instance (GObject o, IsDescendantOf BackForwardListItem o) => BackForwardListItemK o

toBackForwardListItem :: BackForwardListItemK o => o -> IO BackForwardListItem
toBackForwardListItem = unsafeCastTo BackForwardListItem

noBackForwardListItem :: Maybe BackForwardListItem
noBackForwardListItem = Nothing

type family ResolveBackForwardListItemMethod (t :: Symbol) (o :: *) :: * where
    ResolveBackForwardListItemMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveBackForwardListItemMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveBackForwardListItemMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveBackForwardListItemMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveBackForwardListItemMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveBackForwardListItemMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveBackForwardListItemMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveBackForwardListItemMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveBackForwardListItemMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveBackForwardListItemMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveBackForwardListItemMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveBackForwardListItemMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveBackForwardListItemMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveBackForwardListItemMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveBackForwardListItemMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveBackForwardListItemMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveBackForwardListItemMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveBackForwardListItemMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveBackForwardListItemMethod "getOriginalUri" o = BackForwardListItemGetOriginalUriMethodInfo
    ResolveBackForwardListItemMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveBackForwardListItemMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveBackForwardListItemMethod "getTitle" o = BackForwardListItemGetTitleMethodInfo
    ResolveBackForwardListItemMethod "getUri" o = BackForwardListItemGetUriMethodInfo
    ResolveBackForwardListItemMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveBackForwardListItemMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveBackForwardListItemMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveBackForwardListItemMethod t BackForwardListItem, MethodInfo info BackForwardListItem p) => IsLabelProxy t (BackForwardListItem -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveBackForwardListItemMethod t BackForwardListItem, MethodInfo info BackForwardListItem p) => IsLabel t (BackForwardListItem -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

type instance AttributeList BackForwardListItem = BackForwardListItemAttributeList
type BackForwardListItemAttributeList = ('[ ] :: [(Symbol, *)])

type instance SignalList BackForwardListItem = BackForwardListItemSignalList
type BackForwardListItemSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method BackForwardListItem::get_original_uri
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "BackForwardListItem", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_back_forward_list_item_get_original_uri" webkit_back_forward_list_item_get_original_uri :: 
    Ptr BackForwardListItem ->              -- _obj : TInterface "WebKit2" "BackForwardListItem"
    IO CString


backForwardListItemGetOriginalUri ::
    (MonadIO m, BackForwardListItemK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
backForwardListItemGetOriginalUri _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_back_forward_list_item_get_original_uri _obj'
    checkUnexpectedReturnNULL "webkit_back_forward_list_item_get_original_uri" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data BackForwardListItemGetOriginalUriMethodInfo
instance (signature ~ (m T.Text), MonadIO m, BackForwardListItemK a) => MethodInfo BackForwardListItemGetOriginalUriMethodInfo a signature where
    overloadedMethod _ = backForwardListItemGetOriginalUri

-- method BackForwardListItem::get_title
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "BackForwardListItem", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_back_forward_list_item_get_title" webkit_back_forward_list_item_get_title :: 
    Ptr BackForwardListItem ->              -- _obj : TInterface "WebKit2" "BackForwardListItem"
    IO CString


backForwardListItemGetTitle ::
    (MonadIO m, BackForwardListItemK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
backForwardListItemGetTitle _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_back_forward_list_item_get_title _obj'
    checkUnexpectedReturnNULL "webkit_back_forward_list_item_get_title" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data BackForwardListItemGetTitleMethodInfo
instance (signature ~ (m T.Text), MonadIO m, BackForwardListItemK a) => MethodInfo BackForwardListItemGetTitleMethodInfo a signature where
    overloadedMethod _ = backForwardListItemGetTitle

-- method BackForwardListItem::get_uri
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "BackForwardListItem", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_back_forward_list_item_get_uri" webkit_back_forward_list_item_get_uri :: 
    Ptr BackForwardListItem ->              -- _obj : TInterface "WebKit2" "BackForwardListItem"
    IO CString


backForwardListItemGetUri ::
    (MonadIO m, BackForwardListItemK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
backForwardListItemGetUri _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_back_forward_list_item_get_uri _obj'
    checkUnexpectedReturnNULL "webkit_back_forward_list_item_get_uri" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data BackForwardListItemGetUriMethodInfo
instance (signature ~ (m T.Text), MonadIO m, BackForwardListItemK a) => MethodInfo BackForwardListItemGetUriMethodInfo a signature where
    overloadedMethod _ = backForwardListItemGetUri


