

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.ColorChooserRequest
    ( 

-- * Exported types
    ColorChooserRequest(..)                 ,
    ColorChooserRequestK                    ,
    toColorChooserRequest                   ,
    noColorChooserRequest                   ,


 -- * Methods
-- ** colorChooserRequestCancel
    ColorChooserRequestCancelMethodInfo     ,
    colorChooserRequestCancel               ,


-- ** colorChooserRequestFinish
    ColorChooserRequestFinishMethodInfo     ,
    colorChooserRequestFinish               ,


-- ** colorChooserRequestGetElementRectangle
    ColorChooserRequestGetElementRectangleMethodInfo,
    colorChooserRequestGetElementRectangle  ,


-- ** colorChooserRequestGetRgba
    ColorChooserRequestGetRgbaMethodInfo    ,
    colorChooserRequestGetRgba              ,


-- ** colorChooserRequestSetRgba
    ColorChooserRequestSetRgbaMethodInfo    ,
    colorChooserRequestSetRgba              ,




 -- * Properties
-- ** Rgba
    ColorChooserRequestRgbaPropertyInfo     ,
    colorChooserRequestRgba                 ,
    constructColorChooserRequestRgba        ,
    getColorChooserRequestRgba              ,
    setColorChooserRequestRgba              ,




 -- * Signals
-- ** Finished
    ColorChooserRequestFinishedCallback     ,
    ColorChooserRequestFinishedCallbackC    ,
    ColorChooserRequestFinishedSignalInfo   ,
    afterColorChooserRequestFinished        ,
    colorChooserRequestFinishedCallbackWrapper,
    colorChooserRequestFinishedClosure      ,
    mkColorChooserRequestFinishedCallback   ,
    noColorChooserRequestFinishedCallback   ,
    onColorChooserRequestFinished           ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject
import qualified GI.Gdk as Gdk

newtype ColorChooserRequest = ColorChooserRequest (ForeignPtr ColorChooserRequest)
foreign import ccall "webkit_color_chooser_request_get_type"
    c_webkit_color_chooser_request_get_type :: IO GType

type instance ParentTypes ColorChooserRequest = ColorChooserRequestParentTypes
type ColorChooserRequestParentTypes = '[GObject.Object]

instance GObject ColorChooserRequest where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_color_chooser_request_get_type
    

class GObject o => ColorChooserRequestK o
instance (GObject o, IsDescendantOf ColorChooserRequest o) => ColorChooserRequestK o

toColorChooserRequest :: ColorChooserRequestK o => o -> IO ColorChooserRequest
toColorChooserRequest = unsafeCastTo ColorChooserRequest

noColorChooserRequest :: Maybe ColorChooserRequest
noColorChooserRequest = Nothing

type family ResolveColorChooserRequestMethod (t :: Symbol) (o :: *) :: * where
    ResolveColorChooserRequestMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveColorChooserRequestMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveColorChooserRequestMethod "cancel" o = ColorChooserRequestCancelMethodInfo
    ResolveColorChooserRequestMethod "finish" o = ColorChooserRequestFinishMethodInfo
    ResolveColorChooserRequestMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveColorChooserRequestMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveColorChooserRequestMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveColorChooserRequestMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveColorChooserRequestMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveColorChooserRequestMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveColorChooserRequestMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveColorChooserRequestMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveColorChooserRequestMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveColorChooserRequestMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveColorChooserRequestMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveColorChooserRequestMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveColorChooserRequestMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveColorChooserRequestMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveColorChooserRequestMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveColorChooserRequestMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveColorChooserRequestMethod "getElementRectangle" o = ColorChooserRequestGetElementRectangleMethodInfo
    ResolveColorChooserRequestMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveColorChooserRequestMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveColorChooserRequestMethod "getRgba" o = ColorChooserRequestGetRgbaMethodInfo
    ResolveColorChooserRequestMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveColorChooserRequestMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveColorChooserRequestMethod "setRgba" o = ColorChooserRequestSetRgbaMethodInfo
    ResolveColorChooserRequestMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveColorChooserRequestMethod t ColorChooserRequest, MethodInfo info ColorChooserRequest p) => IsLabelProxy t (ColorChooserRequest -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveColorChooserRequestMethod t ColorChooserRequest, MethodInfo info ColorChooserRequest p) => IsLabel t (ColorChooserRequest -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- signal ColorChooserRequest::finished
type ColorChooserRequestFinishedCallback =
    IO ()

noColorChooserRequestFinishedCallback :: Maybe ColorChooserRequestFinishedCallback
noColorChooserRequestFinishedCallback = Nothing

type ColorChooserRequestFinishedCallbackC =
    Ptr () ->                               -- object
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkColorChooserRequestFinishedCallback :: ColorChooserRequestFinishedCallbackC -> IO (FunPtr ColorChooserRequestFinishedCallbackC)

colorChooserRequestFinishedClosure :: ColorChooserRequestFinishedCallback -> IO Closure
colorChooserRequestFinishedClosure cb = newCClosure =<< mkColorChooserRequestFinishedCallback wrapped
    where wrapped = colorChooserRequestFinishedCallbackWrapper cb

colorChooserRequestFinishedCallbackWrapper ::
    ColorChooserRequestFinishedCallback ->
    Ptr () ->
    Ptr () ->
    IO ()
colorChooserRequestFinishedCallbackWrapper _cb _ _ = do
    _cb 

onColorChooserRequestFinished :: (GObject a, MonadIO m) => a -> ColorChooserRequestFinishedCallback -> m SignalHandlerId
onColorChooserRequestFinished obj cb = liftIO $ connectColorChooserRequestFinished obj cb SignalConnectBefore
afterColorChooserRequestFinished :: (GObject a, MonadIO m) => a -> ColorChooserRequestFinishedCallback -> m SignalHandlerId
afterColorChooserRequestFinished obj cb = connectColorChooserRequestFinished obj cb SignalConnectAfter

connectColorChooserRequestFinished :: (GObject a, MonadIO m) =>
                                      a -> ColorChooserRequestFinishedCallback -> SignalConnectMode -> m SignalHandlerId
connectColorChooserRequestFinished obj cb after = liftIO $ do
    cb' <- mkColorChooserRequestFinishedCallback (colorChooserRequestFinishedCallbackWrapper cb)
    connectSignalFunPtr obj "finished" cb' after

-- VVV Prop "rgba"
   -- Type: TInterface "Gdk" "RGBA"
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Nothing,Just False)

getColorChooserRequestRgba :: (MonadIO m, ColorChooserRequestK o) => o -> m (Maybe Gdk.RGBA)
getColorChooserRequestRgba obj = liftIO $ getObjectPropertyBoxed obj "rgba" Gdk.RGBA

setColorChooserRequestRgba :: (MonadIO m, ColorChooserRequestK o) => o -> Gdk.RGBA -> m ()
setColorChooserRequestRgba obj val = liftIO $ setObjectPropertyBoxed obj "rgba" (Just val)

constructColorChooserRequestRgba :: Gdk.RGBA -> IO ([Char], GValue)
constructColorChooserRequestRgba val = constructObjectPropertyBoxed "rgba" (Just val)

data ColorChooserRequestRgbaPropertyInfo
instance AttrInfo ColorChooserRequestRgbaPropertyInfo where
    type AttrAllowedOps ColorChooserRequestRgbaPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint ColorChooserRequestRgbaPropertyInfo = (~) Gdk.RGBA
    type AttrBaseTypeConstraint ColorChooserRequestRgbaPropertyInfo = ColorChooserRequestK
    type AttrGetType ColorChooserRequestRgbaPropertyInfo = (Maybe Gdk.RGBA)
    type AttrLabel ColorChooserRequestRgbaPropertyInfo = "rgba"
    attrGet _ = getColorChooserRequestRgba
    attrSet _ = setColorChooserRequestRgba
    attrConstruct _ = constructColorChooserRequestRgba
    attrClear _ = undefined

type instance AttributeList ColorChooserRequest = ColorChooserRequestAttributeList
type ColorChooserRequestAttributeList = ('[ '("rgba", ColorChooserRequestRgbaPropertyInfo)] :: [(Symbol, *)])

colorChooserRequestRgba :: AttrLabelProxy "rgba"
colorChooserRequestRgba = AttrLabelProxy

data ColorChooserRequestFinishedSignalInfo
instance SignalInfo ColorChooserRequestFinishedSignalInfo where
    type HaskellCallbackType ColorChooserRequestFinishedSignalInfo = ColorChooserRequestFinishedCallback
    connectSignal _ = connectColorChooserRequestFinished

type instance SignalList ColorChooserRequest = ColorChooserRequestSignalList
type ColorChooserRequestSignalList = ('[ '("finished", ColorChooserRequestFinishedSignalInfo), '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method ColorChooserRequest::cancel
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "ColorChooserRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_color_chooser_request_cancel" webkit_color_chooser_request_cancel :: 
    Ptr ColorChooserRequest ->              -- _obj : TInterface "WebKit2" "ColorChooserRequest"
    IO ()


colorChooserRequestCancel ::
    (MonadIO m, ColorChooserRequestK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
colorChooserRequestCancel _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_color_chooser_request_cancel _obj'
    touchManagedPtr _obj
    return ()

data ColorChooserRequestCancelMethodInfo
instance (signature ~ (m ()), MonadIO m, ColorChooserRequestK a) => MethodInfo ColorChooserRequestCancelMethodInfo a signature where
    overloadedMethod _ = colorChooserRequestCancel

-- method ColorChooserRequest::finish
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "ColorChooserRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_color_chooser_request_finish" webkit_color_chooser_request_finish :: 
    Ptr ColorChooserRequest ->              -- _obj : TInterface "WebKit2" "ColorChooserRequest"
    IO ()


colorChooserRequestFinish ::
    (MonadIO m, ColorChooserRequestK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
colorChooserRequestFinish _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_color_chooser_request_finish _obj'
    touchManagedPtr _obj
    return ()

data ColorChooserRequestFinishMethodInfo
instance (signature ~ (m ()), MonadIO m, ColorChooserRequestK a) => MethodInfo ColorChooserRequestFinishMethodInfo a signature where
    overloadedMethod _ = colorChooserRequestFinish

-- method ColorChooserRequest::get_element_rectangle
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "ColorChooserRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "rect", argType = TInterface "Gdk" "Rectangle", direction = DirectionOut, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = True, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_color_chooser_request_get_element_rectangle" webkit_color_chooser_request_get_element_rectangle :: 
    Ptr ColorChooserRequest ->              -- _obj : TInterface "WebKit2" "ColorChooserRequest"
    Ptr Gdk.Rectangle ->                    -- rect : TInterface "Gdk" "Rectangle"
    IO ()


colorChooserRequestGetElementRectangle ::
    (MonadIO m, ColorChooserRequestK a) =>
    a                                       -- _obj
    -> m (Gdk.Rectangle)                    -- result
colorChooserRequestGetElementRectangle _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    rect <- callocBoxedBytes 16 :: IO (Ptr Gdk.Rectangle)
    webkit_color_chooser_request_get_element_rectangle _obj' rect
    rect' <- (wrapBoxed Gdk.Rectangle) rect
    touchManagedPtr _obj
    return rect'

data ColorChooserRequestGetElementRectangleMethodInfo
instance (signature ~ (m (Gdk.Rectangle)), MonadIO m, ColorChooserRequestK a) => MethodInfo ColorChooserRequestGetElementRectangleMethodInfo a signature where
    overloadedMethod _ = colorChooserRequestGetElementRectangle

-- method ColorChooserRequest::get_rgba
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "ColorChooserRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "rgba", argType = TInterface "Gdk" "RGBA", direction = DirectionOut, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = True, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_color_chooser_request_get_rgba" webkit_color_chooser_request_get_rgba :: 
    Ptr ColorChooserRequest ->              -- _obj : TInterface "WebKit2" "ColorChooserRequest"
    Ptr Gdk.RGBA ->                         -- rgba : TInterface "Gdk" "RGBA"
    IO ()


colorChooserRequestGetRgba ::
    (MonadIO m, ColorChooserRequestK a) =>
    a                                       -- _obj
    -> m (Gdk.RGBA)                         -- result
colorChooserRequestGetRgba _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    rgba <- callocBoxedBytes 32 :: IO (Ptr Gdk.RGBA)
    webkit_color_chooser_request_get_rgba _obj' rgba
    rgba' <- (wrapBoxed Gdk.RGBA) rgba
    touchManagedPtr _obj
    return rgba'

data ColorChooserRequestGetRgbaMethodInfo
instance (signature ~ (m (Gdk.RGBA)), MonadIO m, ColorChooserRequestK a) => MethodInfo ColorChooserRequestGetRgbaMethodInfo a signature where
    overloadedMethod _ = colorChooserRequestGetRgba

-- method ColorChooserRequest::set_rgba
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "ColorChooserRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "rgba", argType = TInterface "Gdk" "RGBA", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_color_chooser_request_set_rgba" webkit_color_chooser_request_set_rgba :: 
    Ptr ColorChooserRequest ->              -- _obj : TInterface "WebKit2" "ColorChooserRequest"
    Ptr Gdk.RGBA ->                         -- rgba : TInterface "Gdk" "RGBA"
    IO ()


colorChooserRequestSetRgba ::
    (MonadIO m, ColorChooserRequestK a) =>
    a                                       -- _obj
    -> Gdk.RGBA                             -- rgba
    -> m ()                                 -- result
colorChooserRequestSetRgba _obj rgba = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let rgba' = unsafeManagedPtrGetPtr rgba
    webkit_color_chooser_request_set_rgba _obj' rgba'
    touchManagedPtr _obj
    touchManagedPtr rgba
    return ()

data ColorChooserRequestSetRgbaMethodInfo
instance (signature ~ (Gdk.RGBA -> m ()), MonadIO m, ColorChooserRequestK a) => MethodInfo ColorChooserRequestSetRgbaMethodInfo a signature where
    overloadedMethod _ = colorChooserRequestSetRgba


