

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.ContextMenuItem
    ( 

-- * Exported types
    ContextMenuItem(..)                     ,
    ContextMenuItemK                        ,
    toContextMenuItem                       ,
    noContextMenuItem                       ,


 -- * Methods
-- ** contextMenuItemGetAction
    ContextMenuItemGetActionMethodInfo      ,
    contextMenuItemGetAction                ,


-- ** contextMenuItemGetStockAction
    ContextMenuItemGetStockActionMethodInfo ,
    contextMenuItemGetStockAction           ,


-- ** contextMenuItemGetSubmenu
    ContextMenuItemGetSubmenuMethodInfo     ,
    contextMenuItemGetSubmenu               ,


-- ** contextMenuItemIsSeparator
    ContextMenuItemIsSeparatorMethodInfo    ,
    contextMenuItemIsSeparator              ,


-- ** contextMenuItemNew
    contextMenuItemNew                      ,


-- ** contextMenuItemNewFromStockAction
    contextMenuItemNewFromStockAction       ,


-- ** contextMenuItemNewFromStockActionWithLabel
    contextMenuItemNewFromStockActionWithLabel,


-- ** contextMenuItemNewSeparator
    contextMenuItemNewSeparator             ,


-- ** contextMenuItemNewWithSubmenu
    contextMenuItemNewWithSubmenu           ,


-- ** contextMenuItemSetSubmenu
    ContextMenuItemSetSubmenuMethodInfo     ,
    contextMenuItemSetSubmenu               ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject
import qualified GI.Gtk as Gtk

newtype ContextMenuItem = ContextMenuItem (ForeignPtr ContextMenuItem)
foreign import ccall "webkit_context_menu_item_get_type"
    c_webkit_context_menu_item_get_type :: IO GType

type instance ParentTypes ContextMenuItem = ContextMenuItemParentTypes
type ContextMenuItemParentTypes = '[GObject.Object]

instance GObject ContextMenuItem where
    gobjectIsInitiallyUnowned _ = True
    gobjectType _ = c_webkit_context_menu_item_get_type
    

class GObject o => ContextMenuItemK o
instance (GObject o, IsDescendantOf ContextMenuItem o) => ContextMenuItemK o

toContextMenuItem :: ContextMenuItemK o => o -> IO ContextMenuItem
toContextMenuItem = unsafeCastTo ContextMenuItem

noContextMenuItem :: Maybe ContextMenuItem
noContextMenuItem = Nothing

type family ResolveContextMenuItemMethod (t :: Symbol) (o :: *) :: * where
    ResolveContextMenuItemMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveContextMenuItemMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveContextMenuItemMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveContextMenuItemMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveContextMenuItemMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveContextMenuItemMethod "isSeparator" o = ContextMenuItemIsSeparatorMethodInfo
    ResolveContextMenuItemMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveContextMenuItemMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveContextMenuItemMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveContextMenuItemMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveContextMenuItemMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveContextMenuItemMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveContextMenuItemMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveContextMenuItemMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveContextMenuItemMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveContextMenuItemMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveContextMenuItemMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveContextMenuItemMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveContextMenuItemMethod "getAction" o = ContextMenuItemGetActionMethodInfo
    ResolveContextMenuItemMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveContextMenuItemMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveContextMenuItemMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveContextMenuItemMethod "getStockAction" o = ContextMenuItemGetStockActionMethodInfo
    ResolveContextMenuItemMethod "getSubmenu" o = ContextMenuItemGetSubmenuMethodInfo
    ResolveContextMenuItemMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveContextMenuItemMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveContextMenuItemMethod "setSubmenu" o = ContextMenuItemSetSubmenuMethodInfo
    ResolveContextMenuItemMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveContextMenuItemMethod t ContextMenuItem, MethodInfo info ContextMenuItem p) => IsLabelProxy t (ContextMenuItem -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveContextMenuItemMethod t ContextMenuItem, MethodInfo info ContextMenuItem p) => IsLabel t (ContextMenuItem -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

type instance AttributeList ContextMenuItem = ContextMenuItemAttributeList
type ContextMenuItemAttributeList = ('[ ] :: [(Symbol, *)])

type instance SignalList ContextMenuItem = ContextMenuItemSignalList
type ContextMenuItemSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method ContextMenuItem::new
-- method type : Constructor
-- Args : [Arg {argCName = "action", argType = TInterface "Gtk" "Action", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "ContextMenuItem")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_context_menu_item_new" webkit_context_menu_item_new :: 
    Ptr Gtk.Action ->                       -- action : TInterface "Gtk" "Action"
    IO (Ptr ContextMenuItem)


contextMenuItemNew ::
    (MonadIO m, Gtk.ActionK a) =>
    a                                       -- action
    -> m ContextMenuItem                    -- result
contextMenuItemNew action = liftIO $ do
    let action' = unsafeManagedPtrCastPtr action
    result <- webkit_context_menu_item_new action'
    checkUnexpectedReturnNULL "webkit_context_menu_item_new" result
    result' <- (newObject ContextMenuItem) result
    touchManagedPtr action
    return result'

-- method ContextMenuItem::new_from_stock_action
-- method type : Constructor
-- Args : [Arg {argCName = "action", argType = TInterface "WebKit2" "ContextMenuAction", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "ContextMenuItem")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_context_menu_item_new_from_stock_action" webkit_context_menu_item_new_from_stock_action :: 
    CUInt ->                                -- action : TInterface "WebKit2" "ContextMenuAction"
    IO (Ptr ContextMenuItem)


contextMenuItemNewFromStockAction ::
    (MonadIO m) =>
    ContextMenuAction                       -- action
    -> m ContextMenuItem                    -- result
contextMenuItemNewFromStockAction action = liftIO $ do
    let action' = (fromIntegral . fromEnum) action
    result <- webkit_context_menu_item_new_from_stock_action action'
    checkUnexpectedReturnNULL "webkit_context_menu_item_new_from_stock_action" result
    result' <- (newObject ContextMenuItem) result
    return result'

-- method ContextMenuItem::new_from_stock_action_with_label
-- method type : Constructor
-- Args : [Arg {argCName = "action", argType = TInterface "WebKit2" "ContextMenuAction", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "label", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "ContextMenuItem")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_context_menu_item_new_from_stock_action_with_label" webkit_context_menu_item_new_from_stock_action_with_label :: 
    CUInt ->                                -- action : TInterface "WebKit2" "ContextMenuAction"
    CString ->                              -- label : TBasicType TUTF8
    IO (Ptr ContextMenuItem)


contextMenuItemNewFromStockActionWithLabel ::
    (MonadIO m) =>
    ContextMenuAction                       -- action
    -> T.Text                               -- label
    -> m ContextMenuItem                    -- result
contextMenuItemNewFromStockActionWithLabel action label = liftIO $ do
    let action' = (fromIntegral . fromEnum) action
    label' <- textToCString label
    result <- webkit_context_menu_item_new_from_stock_action_with_label action' label'
    checkUnexpectedReturnNULL "webkit_context_menu_item_new_from_stock_action_with_label" result
    result' <- (newObject ContextMenuItem) result
    freeMem label'
    return result'

-- method ContextMenuItem::new_separator
-- method type : Constructor
-- Args : []
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "ContextMenuItem")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_context_menu_item_new_separator" webkit_context_menu_item_new_separator :: 
    IO (Ptr ContextMenuItem)


contextMenuItemNewSeparator ::
    (MonadIO m) =>
    m ContextMenuItem                       -- result
contextMenuItemNewSeparator  = liftIO $ do
    result <- webkit_context_menu_item_new_separator
    checkUnexpectedReturnNULL "webkit_context_menu_item_new_separator" result
    result' <- (newObject ContextMenuItem) result
    return result'

-- method ContextMenuItem::new_with_submenu
-- method type : Constructor
-- Args : [Arg {argCName = "label", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "submenu", argType = TInterface "WebKit2" "ContextMenu", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "ContextMenuItem")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_context_menu_item_new_with_submenu" webkit_context_menu_item_new_with_submenu :: 
    CString ->                              -- label : TBasicType TUTF8
    Ptr ContextMenu ->                      -- submenu : TInterface "WebKit2" "ContextMenu"
    IO (Ptr ContextMenuItem)


contextMenuItemNewWithSubmenu ::
    (MonadIO m, ContextMenuK a) =>
    T.Text                                  -- label
    -> a                                    -- submenu
    -> m ContextMenuItem                    -- result
contextMenuItemNewWithSubmenu label submenu = liftIO $ do
    label' <- textToCString label
    let submenu' = unsafeManagedPtrCastPtr submenu
    result <- webkit_context_menu_item_new_with_submenu label' submenu'
    checkUnexpectedReturnNULL "webkit_context_menu_item_new_with_submenu" result
    result' <- (newObject ContextMenuItem) result
    touchManagedPtr submenu
    freeMem label'
    return result'

-- method ContextMenuItem::get_action
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "ContextMenuItem", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "Gtk" "Action")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_context_menu_item_get_action" webkit_context_menu_item_get_action :: 
    Ptr ContextMenuItem ->                  -- _obj : TInterface "WebKit2" "ContextMenuItem"
    IO (Ptr Gtk.Action)


contextMenuItemGetAction ::
    (MonadIO m, ContextMenuItemK a) =>
    a                                       -- _obj
    -> m Gtk.Action                         -- result
contextMenuItemGetAction _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_context_menu_item_get_action _obj'
    checkUnexpectedReturnNULL "webkit_context_menu_item_get_action" result
    result' <- (newObject Gtk.Action) result
    touchManagedPtr _obj
    return result'

data ContextMenuItemGetActionMethodInfo
instance (signature ~ (m Gtk.Action), MonadIO m, ContextMenuItemK a) => MethodInfo ContextMenuItemGetActionMethodInfo a signature where
    overloadedMethod _ = contextMenuItemGetAction

-- method ContextMenuItem::get_stock_action
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "ContextMenuItem", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "ContextMenuAction")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_context_menu_item_get_stock_action" webkit_context_menu_item_get_stock_action :: 
    Ptr ContextMenuItem ->                  -- _obj : TInterface "WebKit2" "ContextMenuItem"
    IO CUInt


contextMenuItemGetStockAction ::
    (MonadIO m, ContextMenuItemK a) =>
    a                                       -- _obj
    -> m ContextMenuAction                  -- result
contextMenuItemGetStockAction _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_context_menu_item_get_stock_action _obj'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr _obj
    return result'

data ContextMenuItemGetStockActionMethodInfo
instance (signature ~ (m ContextMenuAction), MonadIO m, ContextMenuItemK a) => MethodInfo ContextMenuItemGetStockActionMethodInfo a signature where
    overloadedMethod _ = contextMenuItemGetStockAction

-- method ContextMenuItem::get_submenu
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "ContextMenuItem", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "ContextMenu")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_context_menu_item_get_submenu" webkit_context_menu_item_get_submenu :: 
    Ptr ContextMenuItem ->                  -- _obj : TInterface "WebKit2" "ContextMenuItem"
    IO (Ptr ContextMenu)


contextMenuItemGetSubmenu ::
    (MonadIO m, ContextMenuItemK a) =>
    a                                       -- _obj
    -> m ContextMenu                        -- result
contextMenuItemGetSubmenu _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_context_menu_item_get_submenu _obj'
    checkUnexpectedReturnNULL "webkit_context_menu_item_get_submenu" result
    result' <- (newObject ContextMenu) result
    touchManagedPtr _obj
    return result'

data ContextMenuItemGetSubmenuMethodInfo
instance (signature ~ (m ContextMenu), MonadIO m, ContextMenuItemK a) => MethodInfo ContextMenuItemGetSubmenuMethodInfo a signature where
    overloadedMethod _ = contextMenuItemGetSubmenu

-- method ContextMenuItem::is_separator
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "ContextMenuItem", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_context_menu_item_is_separator" webkit_context_menu_item_is_separator :: 
    Ptr ContextMenuItem ->                  -- _obj : TInterface "WebKit2" "ContextMenuItem"
    IO CInt


contextMenuItemIsSeparator ::
    (MonadIO m, ContextMenuItemK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
contextMenuItemIsSeparator _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_context_menu_item_is_separator _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data ContextMenuItemIsSeparatorMethodInfo
instance (signature ~ (m Bool), MonadIO m, ContextMenuItemK a) => MethodInfo ContextMenuItemIsSeparatorMethodInfo a signature where
    overloadedMethod _ = contextMenuItemIsSeparator

-- method ContextMenuItem::set_submenu
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "ContextMenuItem", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "submenu", argType = TInterface "WebKit2" "ContextMenu", direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_context_menu_item_set_submenu" webkit_context_menu_item_set_submenu :: 
    Ptr ContextMenuItem ->                  -- _obj : TInterface "WebKit2" "ContextMenuItem"
    Ptr ContextMenu ->                      -- submenu : TInterface "WebKit2" "ContextMenu"
    IO ()


contextMenuItemSetSubmenu ::
    (MonadIO m, ContextMenuItemK a, ContextMenuK b) =>
    a                                       -- _obj
    -> Maybe (b)                            -- submenu
    -> m ()                                 -- result
contextMenuItemSetSubmenu _obj submenu = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    maybeSubmenu <- case submenu of
        Nothing -> return nullPtr
        Just jSubmenu -> do
            let jSubmenu' = unsafeManagedPtrCastPtr jSubmenu
            return jSubmenu'
    webkit_context_menu_item_set_submenu _obj' maybeSubmenu
    touchManagedPtr _obj
    whenJust submenu touchManagedPtr
    return ()

data ContextMenuItemSetSubmenuMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, ContextMenuItemK a, ContextMenuK b) => MethodInfo ContextMenuItemSetSubmenuMethodInfo a signature where
    overloadedMethod _ = contextMenuItemSetSubmenu


