

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.CookieManager
    ( 

-- * Exported types
    CookieManager(..)                       ,
    CookieManagerK                          ,
    toCookieManager                         ,
    noCookieManager                         ,


 -- * Methods
-- ** cookieManagerDeleteAllCookies
    CookieManagerDeleteAllCookiesMethodInfo ,
    cookieManagerDeleteAllCookies           ,


-- ** cookieManagerDeleteCookiesForDomain
    CookieManagerDeleteCookiesForDomainMethodInfo,
    cookieManagerDeleteCookiesForDomain     ,


-- ** cookieManagerGetAcceptPolicy
    CookieManagerGetAcceptPolicyMethodInfo  ,
    cookieManagerGetAcceptPolicy            ,


-- ** cookieManagerGetAcceptPolicyFinish
    CookieManagerGetAcceptPolicyFinishMethodInfo,
    cookieManagerGetAcceptPolicyFinish      ,


-- ** cookieManagerGetDomainsWithCookies
    CookieManagerGetDomainsWithCookiesMethodInfo,
    cookieManagerGetDomainsWithCookies      ,


-- ** cookieManagerGetDomainsWithCookiesFinish
    CookieManagerGetDomainsWithCookiesFinishMethodInfo,
    cookieManagerGetDomainsWithCookiesFinish,


-- ** cookieManagerSetAcceptPolicy
    CookieManagerSetAcceptPolicyMethodInfo  ,
    cookieManagerSetAcceptPolicy            ,


-- ** cookieManagerSetPersistentStorage
    CookieManagerSetPersistentStorageMethodInfo,
    cookieManagerSetPersistentStorage       ,




 -- * Signals
-- ** Changed
    CookieManagerChangedCallback            ,
    CookieManagerChangedCallbackC           ,
    CookieManagerChangedSignalInfo          ,
    afterCookieManagerChanged               ,
    cookieManagerChangedCallbackWrapper     ,
    cookieManagerChangedClosure             ,
    mkCookieManagerChangedCallback          ,
    noCookieManagerChangedCallback          ,
    onCookieManagerChanged                  ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject
import qualified GI.Gio as Gio

newtype CookieManager = CookieManager (ForeignPtr CookieManager)
foreign import ccall "webkit_cookie_manager_get_type"
    c_webkit_cookie_manager_get_type :: IO GType

type instance ParentTypes CookieManager = CookieManagerParentTypes
type CookieManagerParentTypes = '[GObject.Object]

instance GObject CookieManager where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_cookie_manager_get_type
    

class GObject o => CookieManagerK o
instance (GObject o, IsDescendantOf CookieManager o) => CookieManagerK o

toCookieManager :: CookieManagerK o => o -> IO CookieManager
toCookieManager = unsafeCastTo CookieManager

noCookieManager :: Maybe CookieManager
noCookieManager = Nothing

type family ResolveCookieManagerMethod (t :: Symbol) (o :: *) :: * where
    ResolveCookieManagerMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveCookieManagerMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveCookieManagerMethod "deleteAllCookies" o = CookieManagerDeleteAllCookiesMethodInfo
    ResolveCookieManagerMethod "deleteCookiesForDomain" o = CookieManagerDeleteCookiesForDomainMethodInfo
    ResolveCookieManagerMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveCookieManagerMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveCookieManagerMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveCookieManagerMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveCookieManagerMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveCookieManagerMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveCookieManagerMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveCookieManagerMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveCookieManagerMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveCookieManagerMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveCookieManagerMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveCookieManagerMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveCookieManagerMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveCookieManagerMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveCookieManagerMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveCookieManagerMethod "getAcceptPolicy" o = CookieManagerGetAcceptPolicyMethodInfo
    ResolveCookieManagerMethod "getAcceptPolicyFinish" o = CookieManagerGetAcceptPolicyFinishMethodInfo
    ResolveCookieManagerMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveCookieManagerMethod "getDomainsWithCookies" o = CookieManagerGetDomainsWithCookiesMethodInfo
    ResolveCookieManagerMethod "getDomainsWithCookiesFinish" o = CookieManagerGetDomainsWithCookiesFinishMethodInfo
    ResolveCookieManagerMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveCookieManagerMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveCookieManagerMethod "setAcceptPolicy" o = CookieManagerSetAcceptPolicyMethodInfo
    ResolveCookieManagerMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveCookieManagerMethod "setPersistentStorage" o = CookieManagerSetPersistentStorageMethodInfo
    ResolveCookieManagerMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveCookieManagerMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveCookieManagerMethod t CookieManager, MethodInfo info CookieManager p) => IsLabelProxy t (CookieManager -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveCookieManagerMethod t CookieManager, MethodInfo info CookieManager p) => IsLabel t (CookieManager -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- signal CookieManager::changed
type CookieManagerChangedCallback =
    IO ()

noCookieManagerChangedCallback :: Maybe CookieManagerChangedCallback
noCookieManagerChangedCallback = Nothing

type CookieManagerChangedCallbackC =
    Ptr () ->                               -- object
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkCookieManagerChangedCallback :: CookieManagerChangedCallbackC -> IO (FunPtr CookieManagerChangedCallbackC)

cookieManagerChangedClosure :: CookieManagerChangedCallback -> IO Closure
cookieManagerChangedClosure cb = newCClosure =<< mkCookieManagerChangedCallback wrapped
    where wrapped = cookieManagerChangedCallbackWrapper cb

cookieManagerChangedCallbackWrapper ::
    CookieManagerChangedCallback ->
    Ptr () ->
    Ptr () ->
    IO ()
cookieManagerChangedCallbackWrapper _cb _ _ = do
    _cb 

onCookieManagerChanged :: (GObject a, MonadIO m) => a -> CookieManagerChangedCallback -> m SignalHandlerId
onCookieManagerChanged obj cb = liftIO $ connectCookieManagerChanged obj cb SignalConnectBefore
afterCookieManagerChanged :: (GObject a, MonadIO m) => a -> CookieManagerChangedCallback -> m SignalHandlerId
afterCookieManagerChanged obj cb = connectCookieManagerChanged obj cb SignalConnectAfter

connectCookieManagerChanged :: (GObject a, MonadIO m) =>
                               a -> CookieManagerChangedCallback -> SignalConnectMode -> m SignalHandlerId
connectCookieManagerChanged obj cb after = liftIO $ do
    cb' <- mkCookieManagerChangedCallback (cookieManagerChangedCallbackWrapper cb)
    connectSignalFunPtr obj "changed" cb' after

type instance AttributeList CookieManager = CookieManagerAttributeList
type CookieManagerAttributeList = ('[ ] :: [(Symbol, *)])

data CookieManagerChangedSignalInfo
instance SignalInfo CookieManagerChangedSignalInfo where
    type HaskellCallbackType CookieManagerChangedSignalInfo = CookieManagerChangedCallback
    connectSignal _ = connectCookieManagerChanged

type instance SignalList CookieManager = CookieManagerSignalList
type CookieManagerSignalList = ('[ '("changed", CookieManagerChangedSignalInfo), '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method CookieManager::delete_all_cookies
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "CookieManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_cookie_manager_delete_all_cookies" webkit_cookie_manager_delete_all_cookies :: 
    Ptr CookieManager ->                    -- _obj : TInterface "WebKit2" "CookieManager"
    IO ()


cookieManagerDeleteAllCookies ::
    (MonadIO m, CookieManagerK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
cookieManagerDeleteAllCookies _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_cookie_manager_delete_all_cookies _obj'
    touchManagedPtr _obj
    return ()

data CookieManagerDeleteAllCookiesMethodInfo
instance (signature ~ (m ()), MonadIO m, CookieManagerK a) => MethodInfo CookieManagerDeleteAllCookiesMethodInfo a signature where
    overloadedMethod _ = cookieManagerDeleteAllCookies

-- method CookieManager::delete_cookies_for_domain
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "CookieManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "domain", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_cookie_manager_delete_cookies_for_domain" webkit_cookie_manager_delete_cookies_for_domain :: 
    Ptr CookieManager ->                    -- _obj : TInterface "WebKit2" "CookieManager"
    CString ->                              -- domain : TBasicType TUTF8
    IO ()


cookieManagerDeleteCookiesForDomain ::
    (MonadIO m, CookieManagerK a) =>
    a                                       -- _obj
    -> T.Text                               -- domain
    -> m ()                                 -- result
cookieManagerDeleteCookiesForDomain _obj domain = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    domain' <- textToCString domain
    webkit_cookie_manager_delete_cookies_for_domain _obj' domain'
    touchManagedPtr _obj
    freeMem domain'
    return ()

data CookieManagerDeleteCookiesForDomainMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, CookieManagerK a) => MethodInfo CookieManagerDeleteCookiesForDomainMethodInfo a signature where
    overloadedMethod _ = cookieManagerDeleteCookiesForDomain

-- method CookieManager::get_accept_policy
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "CookieManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "cancellable", argType = TInterface "Gio" "Cancellable", direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "callback", argType = TInterface "Gio" "AsyncReadyCallback", direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeAsync, argClosure = 3, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "user_data", argType = TBasicType TPtr, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_cookie_manager_get_accept_policy" webkit_cookie_manager_get_accept_policy :: 
    Ptr CookieManager ->                    -- _obj : TInterface "WebKit2" "CookieManager"
    Ptr Gio.Cancellable ->                  -- cancellable : TInterface "Gio" "Cancellable"
    FunPtr Gio.AsyncReadyCallbackC ->       -- callback : TInterface "Gio" "AsyncReadyCallback"
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()


cookieManagerGetAcceptPolicy ::
    (MonadIO m, CookieManagerK a, Gio.CancellableK b) =>
    a                                       -- _obj
    -> Maybe (b)                            -- cancellable
    -> Maybe (Gio.AsyncReadyCallback)       -- callback
    -> m ()                                 -- result
cookieManagerGetAcceptPolicy _obj cancellable callback = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    maybeCancellable <- case cancellable of
        Nothing -> return nullPtr
        Just jCancellable -> do
            let jCancellable' = unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.AsyncReadyCallbackC))
    maybeCallback <- case callback of
        Nothing -> return (castPtrToFunPtr nullPtr)
        Just jCallback -> do
            jCallback' <- Gio.mkAsyncReadyCallback (Gio.asyncReadyCallbackWrapper (Just ptrcallback) jCallback)
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    webkit_cookie_manager_get_accept_policy _obj' maybeCancellable maybeCallback userData
    touchManagedPtr _obj
    whenJust cancellable touchManagedPtr
    return ()

data CookieManagerGetAcceptPolicyMethodInfo
instance (signature ~ (Maybe (b) -> Maybe (Gio.AsyncReadyCallback) -> m ()), MonadIO m, CookieManagerK a, Gio.CancellableK b) => MethodInfo CookieManagerGetAcceptPolicyMethodInfo a signature where
    overloadedMethod _ = cookieManagerGetAcceptPolicy

-- method CookieManager::get_accept_policy_finish
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "CookieManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "result", argType = TInterface "Gio" "AsyncResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "CookieAcceptPolicy")
-- throws : True
-- Skip return : False

foreign import ccall "webkit_cookie_manager_get_accept_policy_finish" webkit_cookie_manager_get_accept_policy_finish :: 
    Ptr CookieManager ->                    -- _obj : TInterface "WebKit2" "CookieManager"
    Ptr Gio.AsyncResult ->                  -- result : TInterface "Gio" "AsyncResult"
    Ptr (Ptr GError) ->                     -- error
    IO CUInt


cookieManagerGetAcceptPolicyFinish ::
    (MonadIO m, CookieManagerK a, Gio.AsyncResultK b) =>
    a                                       -- _obj
    -> b                                    -- result_
    -> m CookieAcceptPolicy                 -- result
cookieManagerGetAcceptPolicyFinish _obj result_ = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let result_' = unsafeManagedPtrCastPtr result_
    onException (do
        result <- propagateGError $ webkit_cookie_manager_get_accept_policy_finish _obj' result_'
        let result' = (toEnum . fromIntegral) result
        touchManagedPtr _obj
        touchManagedPtr result_
        return result'
     ) (do
        return ()
     )

data CookieManagerGetAcceptPolicyFinishMethodInfo
instance (signature ~ (b -> m CookieAcceptPolicy), MonadIO m, CookieManagerK a, Gio.AsyncResultK b) => MethodInfo CookieManagerGetAcceptPolicyFinishMethodInfo a signature where
    overloadedMethod _ = cookieManagerGetAcceptPolicyFinish

-- method CookieManager::get_domains_with_cookies
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "CookieManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "cancellable", argType = TInterface "Gio" "Cancellable", direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "callback", argType = TInterface "Gio" "AsyncReadyCallback", direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeAsync, argClosure = 3, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "user_data", argType = TBasicType TPtr, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_cookie_manager_get_domains_with_cookies" webkit_cookie_manager_get_domains_with_cookies :: 
    Ptr CookieManager ->                    -- _obj : TInterface "WebKit2" "CookieManager"
    Ptr Gio.Cancellable ->                  -- cancellable : TInterface "Gio" "Cancellable"
    FunPtr Gio.AsyncReadyCallbackC ->       -- callback : TInterface "Gio" "AsyncReadyCallback"
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()


cookieManagerGetDomainsWithCookies ::
    (MonadIO m, CookieManagerK a, Gio.CancellableK b) =>
    a                                       -- _obj
    -> Maybe (b)                            -- cancellable
    -> Maybe (Gio.AsyncReadyCallback)       -- callback
    -> m ()                                 -- result
cookieManagerGetDomainsWithCookies _obj cancellable callback = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    maybeCancellable <- case cancellable of
        Nothing -> return nullPtr
        Just jCancellable -> do
            let jCancellable' = unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.AsyncReadyCallbackC))
    maybeCallback <- case callback of
        Nothing -> return (castPtrToFunPtr nullPtr)
        Just jCallback -> do
            jCallback' <- Gio.mkAsyncReadyCallback (Gio.asyncReadyCallbackWrapper (Just ptrcallback) jCallback)
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    webkit_cookie_manager_get_domains_with_cookies _obj' maybeCancellable maybeCallback userData
    touchManagedPtr _obj
    whenJust cancellable touchManagedPtr
    return ()

data CookieManagerGetDomainsWithCookiesMethodInfo
instance (signature ~ (Maybe (b) -> Maybe (Gio.AsyncReadyCallback) -> m ()), MonadIO m, CookieManagerK a, Gio.CancellableK b) => MethodInfo CookieManagerGetDomainsWithCookiesMethodInfo a signature where
    overloadedMethod _ = cookieManagerGetDomainsWithCookies

-- method CookieManager::get_domains_with_cookies_finish
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "CookieManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "result", argType = TInterface "Gio" "AsyncResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : True
-- Skip return : False

foreign import ccall "webkit_cookie_manager_get_domains_with_cookies_finish" webkit_cookie_manager_get_domains_with_cookies_finish :: 
    Ptr CookieManager ->                    -- _obj : TInterface "WebKit2" "CookieManager"
    Ptr Gio.AsyncResult ->                  -- result : TInterface "Gio" "AsyncResult"
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr CString)


cookieManagerGetDomainsWithCookiesFinish ::
    (MonadIO m, CookieManagerK a, Gio.AsyncResultK b) =>
    a                                       -- _obj
    -> b                                    -- result_
    -> m [T.Text]                           -- result
cookieManagerGetDomainsWithCookiesFinish _obj result_ = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let result_' = unsafeManagedPtrCastPtr result_
    onException (do
        result <- propagateGError $ webkit_cookie_manager_get_domains_with_cookies_finish _obj' result_'
        checkUnexpectedReturnNULL "webkit_cookie_manager_get_domains_with_cookies_finish" result
        result' <- unpackZeroTerminatedUTF8CArray result
        mapZeroTerminatedCArray freeMem result
        freeMem result
        touchManagedPtr _obj
        touchManagedPtr result_
        return result'
     ) (do
        return ()
     )

data CookieManagerGetDomainsWithCookiesFinishMethodInfo
instance (signature ~ (b -> m [T.Text]), MonadIO m, CookieManagerK a, Gio.AsyncResultK b) => MethodInfo CookieManagerGetDomainsWithCookiesFinishMethodInfo a signature where
    overloadedMethod _ = cookieManagerGetDomainsWithCookiesFinish

-- method CookieManager::set_accept_policy
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "CookieManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "policy", argType = TInterface "WebKit2" "CookieAcceptPolicy", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_cookie_manager_set_accept_policy" webkit_cookie_manager_set_accept_policy :: 
    Ptr CookieManager ->                    -- _obj : TInterface "WebKit2" "CookieManager"
    CUInt ->                                -- policy : TInterface "WebKit2" "CookieAcceptPolicy"
    IO ()


cookieManagerSetAcceptPolicy ::
    (MonadIO m, CookieManagerK a) =>
    a                                       -- _obj
    -> CookieAcceptPolicy                   -- policy
    -> m ()                                 -- result
cookieManagerSetAcceptPolicy _obj policy = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let policy' = (fromIntegral . fromEnum) policy
    webkit_cookie_manager_set_accept_policy _obj' policy'
    touchManagedPtr _obj
    return ()

data CookieManagerSetAcceptPolicyMethodInfo
instance (signature ~ (CookieAcceptPolicy -> m ()), MonadIO m, CookieManagerK a) => MethodInfo CookieManagerSetAcceptPolicyMethodInfo a signature where
    overloadedMethod _ = cookieManagerSetAcceptPolicy

-- method CookieManager::set_persistent_storage
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "CookieManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "filename", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "storage", argType = TInterface "WebKit2" "CookiePersistentStorage", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_cookie_manager_set_persistent_storage" webkit_cookie_manager_set_persistent_storage :: 
    Ptr CookieManager ->                    -- _obj : TInterface "WebKit2" "CookieManager"
    CString ->                              -- filename : TBasicType TUTF8
    CUInt ->                                -- storage : TInterface "WebKit2" "CookiePersistentStorage"
    IO ()


cookieManagerSetPersistentStorage ::
    (MonadIO m, CookieManagerK a) =>
    a                                       -- _obj
    -> T.Text                               -- filename
    -> CookiePersistentStorage              -- storage
    -> m ()                                 -- result
cookieManagerSetPersistentStorage _obj filename storage = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    filename' <- textToCString filename
    let storage' = (fromIntegral . fromEnum) storage
    webkit_cookie_manager_set_persistent_storage _obj' filename' storage'
    touchManagedPtr _obj
    freeMem filename'
    return ()

data CookieManagerSetPersistentStorageMethodInfo
instance (signature ~ (T.Text -> CookiePersistentStorage -> m ()), MonadIO m, CookieManagerK a) => MethodInfo CookieManagerSetPersistentStorageMethodInfo a signature where
    overloadedMethod _ = cookieManagerSetPersistentStorage


