

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.Download
    ( 

-- * Exported types
    Download(..)                            ,
    DownloadK                               ,
    toDownload                              ,
    noDownload                              ,


 -- * Methods
-- ** downloadCancel
    DownloadCancelMethodInfo                ,
    downloadCancel                          ,


-- ** downloadGetAllowOverwrite
    DownloadGetAllowOverwriteMethodInfo     ,
    downloadGetAllowOverwrite               ,


-- ** downloadGetDestination
    DownloadGetDestinationMethodInfo        ,
    downloadGetDestination                  ,


-- ** downloadGetElapsedTime
    DownloadGetElapsedTimeMethodInfo        ,
    downloadGetElapsedTime                  ,


-- ** downloadGetEstimatedProgress
    DownloadGetEstimatedProgressMethodInfo  ,
    downloadGetEstimatedProgress            ,


-- ** downloadGetReceivedDataLength
    DownloadGetReceivedDataLengthMethodInfo ,
    downloadGetReceivedDataLength           ,


-- ** downloadGetRequest
    DownloadGetRequestMethodInfo            ,
    downloadGetRequest                      ,


-- ** downloadGetResponse
    DownloadGetResponseMethodInfo           ,
    downloadGetResponse                     ,


-- ** downloadGetWebView
    DownloadGetWebViewMethodInfo            ,
    downloadGetWebView                      ,


-- ** downloadSetAllowOverwrite
    DownloadSetAllowOverwriteMethodInfo     ,
    downloadSetAllowOverwrite               ,


-- ** downloadSetDestination
    DownloadSetDestinationMethodInfo        ,
    downloadSetDestination                  ,




 -- * Properties
-- ** AllowOverwrite
    DownloadAllowOverwritePropertyInfo      ,
    constructDownloadAllowOverwrite         ,
    downloadAllowOverwrite                  ,
    getDownloadAllowOverwrite               ,
    setDownloadAllowOverwrite               ,


-- ** Destination
    DownloadDestinationPropertyInfo         ,
    downloadDestination                     ,
    getDownloadDestination                  ,


-- ** EstimatedProgress
    DownloadEstimatedProgressPropertyInfo   ,
    downloadEstimatedProgress               ,
    getDownloadEstimatedProgress            ,


-- ** Response
    DownloadResponsePropertyInfo            ,
    downloadResponse                        ,
    getDownloadResponse                     ,




 -- * Signals
-- ** CreatedDestination
    DownloadCreatedDestinationCallback      ,
    DownloadCreatedDestinationCallbackC     ,
    DownloadCreatedDestinationSignalInfo    ,
    afterDownloadCreatedDestination         ,
    downloadCreatedDestinationCallbackWrapper,
    downloadCreatedDestinationClosure       ,
    mkDownloadCreatedDestinationCallback    ,
    noDownloadCreatedDestinationCallback    ,
    onDownloadCreatedDestination            ,


-- ** DecideDestination
    DownloadDecideDestinationCallback       ,
    DownloadDecideDestinationCallbackC      ,
    DownloadDecideDestinationSignalInfo     ,
    afterDownloadDecideDestination          ,
    downloadDecideDestinationCallbackWrapper,
    downloadDecideDestinationClosure        ,
    mkDownloadDecideDestinationCallback     ,
    noDownloadDecideDestinationCallback     ,
    onDownloadDecideDestination             ,


-- ** Failed
    DownloadFailedCallback                  ,
    DownloadFailedCallbackC                 ,
    DownloadFailedSignalInfo                ,
    afterDownloadFailed                     ,
    downloadFailedCallbackWrapper           ,
    downloadFailedClosure                   ,
    mkDownloadFailedCallback                ,
    noDownloadFailedCallback                ,
    onDownloadFailed                        ,


-- ** Finished
    DownloadFinishedCallback                ,
    DownloadFinishedCallbackC               ,
    DownloadFinishedSignalInfo              ,
    afterDownloadFinished                   ,
    downloadFinishedCallbackWrapper         ,
    downloadFinishedClosure                 ,
    mkDownloadFinishedCallback              ,
    noDownloadFinishedCallback              ,
    onDownloadFinished                      ,


-- ** ReceivedData
    DownloadReceivedDataCallback            ,
    DownloadReceivedDataCallbackC           ,
    DownloadReceivedDataSignalInfo          ,
    afterDownloadReceivedData               ,
    downloadReceivedDataCallbackWrapper     ,
    downloadReceivedDataClosure             ,
    mkDownloadReceivedDataCallback          ,
    noDownloadReceivedDataCallback          ,
    onDownloadReceivedData                  ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject

newtype Download = Download (ForeignPtr Download)
foreign import ccall "webkit_download_get_type"
    c_webkit_download_get_type :: IO GType

type instance ParentTypes Download = DownloadParentTypes
type DownloadParentTypes = '[GObject.Object]

instance GObject Download where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_download_get_type
    

class GObject o => DownloadK o
instance (GObject o, IsDescendantOf Download o) => DownloadK o

toDownload :: DownloadK o => o -> IO Download
toDownload = unsafeCastTo Download

noDownload :: Maybe Download
noDownload = Nothing

type family ResolveDownloadMethod (t :: Symbol) (o :: *) :: * where
    ResolveDownloadMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveDownloadMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveDownloadMethod "cancel" o = DownloadCancelMethodInfo
    ResolveDownloadMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveDownloadMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveDownloadMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveDownloadMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveDownloadMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveDownloadMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveDownloadMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveDownloadMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveDownloadMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveDownloadMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveDownloadMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveDownloadMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveDownloadMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveDownloadMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveDownloadMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveDownloadMethod "getAllowOverwrite" o = DownloadGetAllowOverwriteMethodInfo
    ResolveDownloadMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveDownloadMethod "getDestination" o = DownloadGetDestinationMethodInfo
    ResolveDownloadMethod "getElapsedTime" o = DownloadGetElapsedTimeMethodInfo
    ResolveDownloadMethod "getEstimatedProgress" o = DownloadGetEstimatedProgressMethodInfo
    ResolveDownloadMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveDownloadMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveDownloadMethod "getReceivedDataLength" o = DownloadGetReceivedDataLengthMethodInfo
    ResolveDownloadMethod "getRequest" o = DownloadGetRequestMethodInfo
    ResolveDownloadMethod "getResponse" o = DownloadGetResponseMethodInfo
    ResolveDownloadMethod "getWebView" o = DownloadGetWebViewMethodInfo
    ResolveDownloadMethod "setAllowOverwrite" o = DownloadSetAllowOverwriteMethodInfo
    ResolveDownloadMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveDownloadMethod "setDestination" o = DownloadSetDestinationMethodInfo
    ResolveDownloadMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveDownloadMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveDownloadMethod t Download, MethodInfo info Download p) => IsLabelProxy t (Download -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveDownloadMethod t Download, MethodInfo info Download p) => IsLabel t (Download -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- signal Download::created-destination
type DownloadCreatedDestinationCallback =
    T.Text ->
    IO ()

noDownloadCreatedDestinationCallback :: Maybe DownloadCreatedDestinationCallback
noDownloadCreatedDestinationCallback = Nothing

type DownloadCreatedDestinationCallbackC =
    Ptr () ->                               -- object
    CString ->
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkDownloadCreatedDestinationCallback :: DownloadCreatedDestinationCallbackC -> IO (FunPtr DownloadCreatedDestinationCallbackC)

downloadCreatedDestinationClosure :: DownloadCreatedDestinationCallback -> IO Closure
downloadCreatedDestinationClosure cb = newCClosure =<< mkDownloadCreatedDestinationCallback wrapped
    where wrapped = downloadCreatedDestinationCallbackWrapper cb

downloadCreatedDestinationCallbackWrapper ::
    DownloadCreatedDestinationCallback ->
    Ptr () ->
    CString ->
    Ptr () ->
    IO ()
downloadCreatedDestinationCallbackWrapper _cb _ destination _ = do
    destination' <- cstringToText destination
    _cb  destination'

onDownloadCreatedDestination :: (GObject a, MonadIO m) => a -> DownloadCreatedDestinationCallback -> m SignalHandlerId
onDownloadCreatedDestination obj cb = liftIO $ connectDownloadCreatedDestination obj cb SignalConnectBefore
afterDownloadCreatedDestination :: (GObject a, MonadIO m) => a -> DownloadCreatedDestinationCallback -> m SignalHandlerId
afterDownloadCreatedDestination obj cb = connectDownloadCreatedDestination obj cb SignalConnectAfter

connectDownloadCreatedDestination :: (GObject a, MonadIO m) =>
                                     a -> DownloadCreatedDestinationCallback -> SignalConnectMode -> m SignalHandlerId
connectDownloadCreatedDestination obj cb after = liftIO $ do
    cb' <- mkDownloadCreatedDestinationCallback (downloadCreatedDestinationCallbackWrapper cb)
    connectSignalFunPtr obj "created-destination" cb' after

-- signal Download::decide-destination
type DownloadDecideDestinationCallback =
    T.Text ->
    IO Bool

noDownloadDecideDestinationCallback :: Maybe DownloadDecideDestinationCallback
noDownloadDecideDestinationCallback = Nothing

type DownloadDecideDestinationCallbackC =
    Ptr () ->                               -- object
    CString ->
    Ptr () ->                               -- user_data
    IO CInt

foreign import ccall "wrapper"
    mkDownloadDecideDestinationCallback :: DownloadDecideDestinationCallbackC -> IO (FunPtr DownloadDecideDestinationCallbackC)

downloadDecideDestinationClosure :: DownloadDecideDestinationCallback -> IO Closure
downloadDecideDestinationClosure cb = newCClosure =<< mkDownloadDecideDestinationCallback wrapped
    where wrapped = downloadDecideDestinationCallbackWrapper cb

downloadDecideDestinationCallbackWrapper ::
    DownloadDecideDestinationCallback ->
    Ptr () ->
    CString ->
    Ptr () ->
    IO CInt
downloadDecideDestinationCallbackWrapper _cb _ suggestedFilename _ = do
    suggestedFilename' <- cstringToText suggestedFilename
    result <- _cb  suggestedFilename'
    let result' = (fromIntegral . fromEnum) result
    return result'

onDownloadDecideDestination :: (GObject a, MonadIO m) => a -> DownloadDecideDestinationCallback -> m SignalHandlerId
onDownloadDecideDestination obj cb = liftIO $ connectDownloadDecideDestination obj cb SignalConnectBefore
afterDownloadDecideDestination :: (GObject a, MonadIO m) => a -> DownloadDecideDestinationCallback -> m SignalHandlerId
afterDownloadDecideDestination obj cb = connectDownloadDecideDestination obj cb SignalConnectAfter

connectDownloadDecideDestination :: (GObject a, MonadIO m) =>
                                    a -> DownloadDecideDestinationCallback -> SignalConnectMode -> m SignalHandlerId
connectDownloadDecideDestination obj cb after = liftIO $ do
    cb' <- mkDownloadDecideDestinationCallback (downloadDecideDestinationCallbackWrapper cb)
    connectSignalFunPtr obj "decide-destination" cb' after

-- signal Download::failed
type DownloadFailedCallback =
    GError ->
    IO ()

noDownloadFailedCallback :: Maybe DownloadFailedCallback
noDownloadFailedCallback = Nothing

type DownloadFailedCallbackC =
    Ptr () ->                               -- object
    Ptr GError ->
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkDownloadFailedCallback :: DownloadFailedCallbackC -> IO (FunPtr DownloadFailedCallbackC)

downloadFailedClosure :: DownloadFailedCallback -> IO Closure
downloadFailedClosure cb = newCClosure =<< mkDownloadFailedCallback wrapped
    where wrapped = downloadFailedCallbackWrapper cb

downloadFailedCallbackWrapper ::
    DownloadFailedCallback ->
    Ptr () ->
    Ptr GError ->
    Ptr () ->
    IO ()
downloadFailedCallbackWrapper _cb _ error_ _ = do
    error_' <- (newBoxed GError) error_
    _cb  error_'

onDownloadFailed :: (GObject a, MonadIO m) => a -> DownloadFailedCallback -> m SignalHandlerId
onDownloadFailed obj cb = liftIO $ connectDownloadFailed obj cb SignalConnectBefore
afterDownloadFailed :: (GObject a, MonadIO m) => a -> DownloadFailedCallback -> m SignalHandlerId
afterDownloadFailed obj cb = connectDownloadFailed obj cb SignalConnectAfter

connectDownloadFailed :: (GObject a, MonadIO m) =>
                         a -> DownloadFailedCallback -> SignalConnectMode -> m SignalHandlerId
connectDownloadFailed obj cb after = liftIO $ do
    cb' <- mkDownloadFailedCallback (downloadFailedCallbackWrapper cb)
    connectSignalFunPtr obj "failed" cb' after

-- signal Download::finished
type DownloadFinishedCallback =
    IO ()

noDownloadFinishedCallback :: Maybe DownloadFinishedCallback
noDownloadFinishedCallback = Nothing

type DownloadFinishedCallbackC =
    Ptr () ->                               -- object
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkDownloadFinishedCallback :: DownloadFinishedCallbackC -> IO (FunPtr DownloadFinishedCallbackC)

downloadFinishedClosure :: DownloadFinishedCallback -> IO Closure
downloadFinishedClosure cb = newCClosure =<< mkDownloadFinishedCallback wrapped
    where wrapped = downloadFinishedCallbackWrapper cb

downloadFinishedCallbackWrapper ::
    DownloadFinishedCallback ->
    Ptr () ->
    Ptr () ->
    IO ()
downloadFinishedCallbackWrapper _cb _ _ = do
    _cb 

onDownloadFinished :: (GObject a, MonadIO m) => a -> DownloadFinishedCallback -> m SignalHandlerId
onDownloadFinished obj cb = liftIO $ connectDownloadFinished obj cb SignalConnectBefore
afterDownloadFinished :: (GObject a, MonadIO m) => a -> DownloadFinishedCallback -> m SignalHandlerId
afterDownloadFinished obj cb = connectDownloadFinished obj cb SignalConnectAfter

connectDownloadFinished :: (GObject a, MonadIO m) =>
                           a -> DownloadFinishedCallback -> SignalConnectMode -> m SignalHandlerId
connectDownloadFinished obj cb after = liftIO $ do
    cb' <- mkDownloadFinishedCallback (downloadFinishedCallbackWrapper cb)
    connectSignalFunPtr obj "finished" cb' after

-- signal Download::received-data
type DownloadReceivedDataCallback =
    Word64 ->
    IO ()

noDownloadReceivedDataCallback :: Maybe DownloadReceivedDataCallback
noDownloadReceivedDataCallback = Nothing

type DownloadReceivedDataCallbackC =
    Ptr () ->                               -- object
    Word64 ->
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkDownloadReceivedDataCallback :: DownloadReceivedDataCallbackC -> IO (FunPtr DownloadReceivedDataCallbackC)

downloadReceivedDataClosure :: DownloadReceivedDataCallback -> IO Closure
downloadReceivedDataClosure cb = newCClosure =<< mkDownloadReceivedDataCallback wrapped
    where wrapped = downloadReceivedDataCallbackWrapper cb

downloadReceivedDataCallbackWrapper ::
    DownloadReceivedDataCallback ->
    Ptr () ->
    Word64 ->
    Ptr () ->
    IO ()
downloadReceivedDataCallbackWrapper _cb _ dataLength _ = do
    _cb  dataLength

onDownloadReceivedData :: (GObject a, MonadIO m) => a -> DownloadReceivedDataCallback -> m SignalHandlerId
onDownloadReceivedData obj cb = liftIO $ connectDownloadReceivedData obj cb SignalConnectBefore
afterDownloadReceivedData :: (GObject a, MonadIO m) => a -> DownloadReceivedDataCallback -> m SignalHandlerId
afterDownloadReceivedData obj cb = connectDownloadReceivedData obj cb SignalConnectAfter

connectDownloadReceivedData :: (GObject a, MonadIO m) =>
                               a -> DownloadReceivedDataCallback -> SignalConnectMode -> m SignalHandlerId
connectDownloadReceivedData obj cb after = liftIO $ do
    cb' <- mkDownloadReceivedDataCallback (downloadReceivedDataCallbackWrapper cb)
    connectSignalFunPtr obj "received-data" cb' after

-- VVV Prop "allow-overwrite"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

getDownloadAllowOverwrite :: (MonadIO m, DownloadK o) => o -> m Bool
getDownloadAllowOverwrite obj = liftIO $ getObjectPropertyBool obj "allow-overwrite"

setDownloadAllowOverwrite :: (MonadIO m, DownloadK o) => o -> Bool -> m ()
setDownloadAllowOverwrite obj val = liftIO $ setObjectPropertyBool obj "allow-overwrite" val

constructDownloadAllowOverwrite :: Bool -> IO ([Char], GValue)
constructDownloadAllowOverwrite val = constructObjectPropertyBool "allow-overwrite" val

data DownloadAllowOverwritePropertyInfo
instance AttrInfo DownloadAllowOverwritePropertyInfo where
    type AttrAllowedOps DownloadAllowOverwritePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint DownloadAllowOverwritePropertyInfo = (~) Bool
    type AttrBaseTypeConstraint DownloadAllowOverwritePropertyInfo = DownloadK
    type AttrGetType DownloadAllowOverwritePropertyInfo = Bool
    type AttrLabel DownloadAllowOverwritePropertyInfo = "allow-overwrite"
    attrGet _ = getDownloadAllowOverwrite
    attrSet _ = setDownloadAllowOverwrite
    attrConstruct _ = constructDownloadAllowOverwrite
    attrClear _ = undefined

-- VVV Prop "destination"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Just False)

getDownloadDestination :: (MonadIO m, DownloadK o) => o -> m T.Text
getDownloadDestination obj = liftIO $ checkUnexpectedNothing "getDownloadDestination" $ getObjectPropertyString obj "destination"

data DownloadDestinationPropertyInfo
instance AttrInfo DownloadDestinationPropertyInfo where
    type AttrAllowedOps DownloadDestinationPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DownloadDestinationPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DownloadDestinationPropertyInfo = DownloadK
    type AttrGetType DownloadDestinationPropertyInfo = T.Text
    type AttrLabel DownloadDestinationPropertyInfo = "destination"
    attrGet _ = getDownloadDestination
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "estimated-progress"
   -- Type: TBasicType TDouble
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getDownloadEstimatedProgress :: (MonadIO m, DownloadK o) => o -> m Double
getDownloadEstimatedProgress obj = liftIO $ getObjectPropertyDouble obj "estimated-progress"

data DownloadEstimatedProgressPropertyInfo
instance AttrInfo DownloadEstimatedProgressPropertyInfo where
    type AttrAllowedOps DownloadEstimatedProgressPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint DownloadEstimatedProgressPropertyInfo = (~) ()
    type AttrBaseTypeConstraint DownloadEstimatedProgressPropertyInfo = DownloadK
    type AttrGetType DownloadEstimatedProgressPropertyInfo = Double
    type AttrLabel DownloadEstimatedProgressPropertyInfo = "estimated-progress"
    attrGet _ = getDownloadEstimatedProgress
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "response"
   -- Type: TInterface "WebKit2" "URIResponse"
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getDownloadResponse :: (MonadIO m, DownloadK o) => o -> m URIResponse
getDownloadResponse obj = liftIO $ checkUnexpectedNothing "getDownloadResponse" $ getObjectPropertyObject obj "response" URIResponse

data DownloadResponsePropertyInfo
instance AttrInfo DownloadResponsePropertyInfo where
    type AttrAllowedOps DownloadResponsePropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DownloadResponsePropertyInfo = (~) ()
    type AttrBaseTypeConstraint DownloadResponsePropertyInfo = DownloadK
    type AttrGetType DownloadResponsePropertyInfo = URIResponse
    type AttrLabel DownloadResponsePropertyInfo = "response"
    attrGet _ = getDownloadResponse
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

type instance AttributeList Download = DownloadAttributeList
type DownloadAttributeList = ('[ '("allowOverwrite", DownloadAllowOverwritePropertyInfo), '("destination", DownloadDestinationPropertyInfo), '("estimatedProgress", DownloadEstimatedProgressPropertyInfo), '("response", DownloadResponsePropertyInfo)] :: [(Symbol, *)])

downloadAllowOverwrite :: AttrLabelProxy "allowOverwrite"
downloadAllowOverwrite = AttrLabelProxy

downloadDestination :: AttrLabelProxy "destination"
downloadDestination = AttrLabelProxy

downloadEstimatedProgress :: AttrLabelProxy "estimatedProgress"
downloadEstimatedProgress = AttrLabelProxy

downloadResponse :: AttrLabelProxy "response"
downloadResponse = AttrLabelProxy

data DownloadCreatedDestinationSignalInfo
instance SignalInfo DownloadCreatedDestinationSignalInfo where
    type HaskellCallbackType DownloadCreatedDestinationSignalInfo = DownloadCreatedDestinationCallback
    connectSignal _ = connectDownloadCreatedDestination

data DownloadDecideDestinationSignalInfo
instance SignalInfo DownloadDecideDestinationSignalInfo where
    type HaskellCallbackType DownloadDecideDestinationSignalInfo = DownloadDecideDestinationCallback
    connectSignal _ = connectDownloadDecideDestination

data DownloadFailedSignalInfo
instance SignalInfo DownloadFailedSignalInfo where
    type HaskellCallbackType DownloadFailedSignalInfo = DownloadFailedCallback
    connectSignal _ = connectDownloadFailed

data DownloadFinishedSignalInfo
instance SignalInfo DownloadFinishedSignalInfo where
    type HaskellCallbackType DownloadFinishedSignalInfo = DownloadFinishedCallback
    connectSignal _ = connectDownloadFinished

data DownloadReceivedDataSignalInfo
instance SignalInfo DownloadReceivedDataSignalInfo where
    type HaskellCallbackType DownloadReceivedDataSignalInfo = DownloadReceivedDataCallback
    connectSignal _ = connectDownloadReceivedData

type instance SignalList Download = DownloadSignalList
type DownloadSignalList = ('[ '("createdDestination", DownloadCreatedDestinationSignalInfo), '("decideDestination", DownloadDecideDestinationSignalInfo), '("failed", DownloadFailedSignalInfo), '("finished", DownloadFinishedSignalInfo), '("notify", GObject.ObjectNotifySignalInfo), '("receivedData", DownloadReceivedDataSignalInfo)] :: [(Symbol, *)])

-- method Download::cancel
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Download", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_download_cancel" webkit_download_cancel :: 
    Ptr Download ->                         -- _obj : TInterface "WebKit2" "Download"
    IO ()


downloadCancel ::
    (MonadIO m, DownloadK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
downloadCancel _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_download_cancel _obj'
    touchManagedPtr _obj
    return ()

data DownloadCancelMethodInfo
instance (signature ~ (m ()), MonadIO m, DownloadK a) => MethodInfo DownloadCancelMethodInfo a signature where
    overloadedMethod _ = downloadCancel

-- method Download::get_allow_overwrite
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Download", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_download_get_allow_overwrite" webkit_download_get_allow_overwrite :: 
    Ptr Download ->                         -- _obj : TInterface "WebKit2" "Download"
    IO CInt


downloadGetAllowOverwrite ::
    (MonadIO m, DownloadK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
downloadGetAllowOverwrite _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_download_get_allow_overwrite _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data DownloadGetAllowOverwriteMethodInfo
instance (signature ~ (m Bool), MonadIO m, DownloadK a) => MethodInfo DownloadGetAllowOverwriteMethodInfo a signature where
    overloadedMethod _ = downloadGetAllowOverwrite

-- method Download::get_destination
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Download", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_download_get_destination" webkit_download_get_destination :: 
    Ptr Download ->                         -- _obj : TInterface "WebKit2" "Download"
    IO CString


downloadGetDestination ::
    (MonadIO m, DownloadK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
downloadGetDestination _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_download_get_destination _obj'
    checkUnexpectedReturnNULL "webkit_download_get_destination" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data DownloadGetDestinationMethodInfo
instance (signature ~ (m T.Text), MonadIO m, DownloadK a) => MethodInfo DownloadGetDestinationMethodInfo a signature where
    overloadedMethod _ = downloadGetDestination

-- method Download::get_elapsed_time
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Download", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_download_get_elapsed_time" webkit_download_get_elapsed_time :: 
    Ptr Download ->                         -- _obj : TInterface "WebKit2" "Download"
    IO CDouble


downloadGetElapsedTime ::
    (MonadIO m, DownloadK a) =>
    a                                       -- _obj
    -> m Double                             -- result
downloadGetElapsedTime _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_download_get_elapsed_time _obj'
    let result' = realToFrac result
    touchManagedPtr _obj
    return result'

data DownloadGetElapsedTimeMethodInfo
instance (signature ~ (m Double), MonadIO m, DownloadK a) => MethodInfo DownloadGetElapsedTimeMethodInfo a signature where
    overloadedMethod _ = downloadGetElapsedTime

-- method Download::get_estimated_progress
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Download", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_download_get_estimated_progress" webkit_download_get_estimated_progress :: 
    Ptr Download ->                         -- _obj : TInterface "WebKit2" "Download"
    IO CDouble


downloadGetEstimatedProgress ::
    (MonadIO m, DownloadK a) =>
    a                                       -- _obj
    -> m Double                             -- result
downloadGetEstimatedProgress _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_download_get_estimated_progress _obj'
    let result' = realToFrac result
    touchManagedPtr _obj
    return result'

data DownloadGetEstimatedProgressMethodInfo
instance (signature ~ (m Double), MonadIO m, DownloadK a) => MethodInfo DownloadGetEstimatedProgressMethodInfo a signature where
    overloadedMethod _ = downloadGetEstimatedProgress

-- method Download::get_received_data_length
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Download", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUInt64)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_download_get_received_data_length" webkit_download_get_received_data_length :: 
    Ptr Download ->                         -- _obj : TInterface "WebKit2" "Download"
    IO Word64


downloadGetReceivedDataLength ::
    (MonadIO m, DownloadK a) =>
    a                                       -- _obj
    -> m Word64                             -- result
downloadGetReceivedDataLength _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_download_get_received_data_length _obj'
    touchManagedPtr _obj
    return result

data DownloadGetReceivedDataLengthMethodInfo
instance (signature ~ (m Word64), MonadIO m, DownloadK a) => MethodInfo DownloadGetReceivedDataLengthMethodInfo a signature where
    overloadedMethod _ = downloadGetReceivedDataLength

-- method Download::get_request
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Download", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "URIRequest")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_download_get_request" webkit_download_get_request :: 
    Ptr Download ->                         -- _obj : TInterface "WebKit2" "Download"
    IO (Ptr URIRequest)


downloadGetRequest ::
    (MonadIO m, DownloadK a) =>
    a                                       -- _obj
    -> m URIRequest                         -- result
downloadGetRequest _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_download_get_request _obj'
    checkUnexpectedReturnNULL "webkit_download_get_request" result
    result' <- (newObject URIRequest) result
    touchManagedPtr _obj
    return result'

data DownloadGetRequestMethodInfo
instance (signature ~ (m URIRequest), MonadIO m, DownloadK a) => MethodInfo DownloadGetRequestMethodInfo a signature where
    overloadedMethod _ = downloadGetRequest

-- method Download::get_response
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Download", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "URIResponse")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_download_get_response" webkit_download_get_response :: 
    Ptr Download ->                         -- _obj : TInterface "WebKit2" "Download"
    IO (Ptr URIResponse)


downloadGetResponse ::
    (MonadIO m, DownloadK a) =>
    a                                       -- _obj
    -> m URIResponse                        -- result
downloadGetResponse _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_download_get_response _obj'
    checkUnexpectedReturnNULL "webkit_download_get_response" result
    result' <- (newObject URIResponse) result
    touchManagedPtr _obj
    return result'

data DownloadGetResponseMethodInfo
instance (signature ~ (m URIResponse), MonadIO m, DownloadK a) => MethodInfo DownloadGetResponseMethodInfo a signature where
    overloadedMethod _ = downloadGetResponse

-- method Download::get_web_view
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Download", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "WebView")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_download_get_web_view" webkit_download_get_web_view :: 
    Ptr Download ->                         -- _obj : TInterface "WebKit2" "Download"
    IO (Ptr WebView)


downloadGetWebView ::
    (MonadIO m, DownloadK a) =>
    a                                       -- _obj
    -> m WebView                            -- result
downloadGetWebView _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_download_get_web_view _obj'
    checkUnexpectedReturnNULL "webkit_download_get_web_view" result
    result' <- (newObject WebView) result
    touchManagedPtr _obj
    return result'

data DownloadGetWebViewMethodInfo
instance (signature ~ (m WebView), MonadIO m, DownloadK a) => MethodInfo DownloadGetWebViewMethodInfo a signature where
    overloadedMethod _ = downloadGetWebView

-- method Download::set_allow_overwrite
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Download", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "allowed", argType = TBasicType TBoolean, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_download_set_allow_overwrite" webkit_download_set_allow_overwrite :: 
    Ptr Download ->                         -- _obj : TInterface "WebKit2" "Download"
    CInt ->                                 -- allowed : TBasicType TBoolean
    IO ()


downloadSetAllowOverwrite ::
    (MonadIO m, DownloadK a) =>
    a                                       -- _obj
    -> Bool                                 -- allowed
    -> m ()                                 -- result
downloadSetAllowOverwrite _obj allowed = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let allowed' = (fromIntegral . fromEnum) allowed
    webkit_download_set_allow_overwrite _obj' allowed'
    touchManagedPtr _obj
    return ()

data DownloadSetAllowOverwriteMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, DownloadK a) => MethodInfo DownloadSetAllowOverwriteMethodInfo a signature where
    overloadedMethod _ = downloadSetAllowOverwrite

-- method Download::set_destination
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Download", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "uri", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_download_set_destination" webkit_download_set_destination :: 
    Ptr Download ->                         -- _obj : TInterface "WebKit2" "Download"
    CString ->                              -- uri : TBasicType TUTF8
    IO ()


downloadSetDestination ::
    (MonadIO m, DownloadK a) =>
    a                                       -- _obj
    -> T.Text                               -- uri
    -> m ()                                 -- result
downloadSetDestination _obj uri = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    uri' <- textToCString uri
    webkit_download_set_destination _obj' uri'
    touchManagedPtr _obj
    freeMem uri'
    return ()

data DownloadSetDestinationMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, DownloadK a) => MethodInfo DownloadSetDestinationMethodInfo a signature where
    overloadedMethod _ = downloadSetDestination


