

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.EditorState
    ( 

-- * Exported types
    EditorState(..)                         ,
    EditorStateK                            ,
    toEditorState                           ,
    noEditorState                           ,


 -- * Methods
-- ** editorStateGetTypingAttributes
    EditorStateGetTypingAttributesMethodInfo,
    editorStateGetTypingAttributes          ,




 -- * Properties
-- ** TypingAttributes
    EditorStateTypingAttributesPropertyInfo ,
    editorStateTypingAttributes             ,
    getEditorStateTypingAttributes          ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject

newtype EditorState = EditorState (ForeignPtr EditorState)
foreign import ccall "webkit_editor_state_get_type"
    c_webkit_editor_state_get_type :: IO GType

type instance ParentTypes EditorState = EditorStateParentTypes
type EditorStateParentTypes = '[GObject.Object]

instance GObject EditorState where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_editor_state_get_type
    

class GObject o => EditorStateK o
instance (GObject o, IsDescendantOf EditorState o) => EditorStateK o

toEditorState :: EditorStateK o => o -> IO EditorState
toEditorState = unsafeCastTo EditorState

noEditorState :: Maybe EditorState
noEditorState = Nothing

type family ResolveEditorStateMethod (t :: Symbol) (o :: *) :: * where
    ResolveEditorStateMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveEditorStateMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveEditorStateMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveEditorStateMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveEditorStateMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveEditorStateMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveEditorStateMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveEditorStateMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveEditorStateMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveEditorStateMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveEditorStateMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveEditorStateMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveEditorStateMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveEditorStateMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveEditorStateMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveEditorStateMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveEditorStateMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveEditorStateMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveEditorStateMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveEditorStateMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveEditorStateMethod "getTypingAttributes" o = EditorStateGetTypingAttributesMethodInfo
    ResolveEditorStateMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveEditorStateMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveEditorStateMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveEditorStateMethod t EditorState, MethodInfo info EditorState p) => IsLabelProxy t (EditorState -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveEditorStateMethod t EditorState, MethodInfo info EditorState p) => IsLabel t (EditorState -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- VVV Prop "typing-attributes"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getEditorStateTypingAttributes :: (MonadIO m, EditorStateK o) => o -> m Word32
getEditorStateTypingAttributes obj = liftIO $ getObjectPropertyUInt32 obj "typing-attributes"

data EditorStateTypingAttributesPropertyInfo
instance AttrInfo EditorStateTypingAttributesPropertyInfo where
    type AttrAllowedOps EditorStateTypingAttributesPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EditorStateTypingAttributesPropertyInfo = (~) ()
    type AttrBaseTypeConstraint EditorStateTypingAttributesPropertyInfo = EditorStateK
    type AttrGetType EditorStateTypingAttributesPropertyInfo = Word32
    type AttrLabel EditorStateTypingAttributesPropertyInfo = "typing-attributes"
    attrGet _ = getEditorStateTypingAttributes
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

type instance AttributeList EditorState = EditorStateAttributeList
type EditorStateAttributeList = ('[ '("typingAttributes", EditorStateTypingAttributesPropertyInfo)] :: [(Symbol, *)])

editorStateTypingAttributes :: AttrLabelProxy "typingAttributes"
editorStateTypingAttributes = AttrLabelProxy

type instance SignalList EditorState = EditorStateSignalList
type EditorStateSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method EditorState::get_typing_attributes
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "EditorState", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_editor_state_get_typing_attributes" webkit_editor_state_get_typing_attributes :: 
    Ptr EditorState ->                      -- _obj : TInterface "WebKit2" "EditorState"
    IO Word32


editorStateGetTypingAttributes ::
    (MonadIO m, EditorStateK a) =>
    a                                       -- _obj
    -> m Word32                             -- result
editorStateGetTypingAttributes _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_editor_state_get_typing_attributes _obj'
    touchManagedPtr _obj
    return result

data EditorStateGetTypingAttributesMethodInfo
instance (signature ~ (m Word32), MonadIO m, EditorStateK a) => MethodInfo EditorStateGetTypingAttributesMethodInfo a signature where
    overloadedMethod _ = editorStateGetTypingAttributes


