

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.FaviconDatabase
    ( 

-- * Exported types
    FaviconDatabase(..)                     ,
    FaviconDatabaseK                        ,
    toFaviconDatabase                       ,
    noFaviconDatabase                       ,


 -- * Methods
-- ** faviconDatabaseClear
    FaviconDatabaseClearMethodInfo          ,
    faviconDatabaseClear                    ,


-- ** faviconDatabaseGetFavicon
    FaviconDatabaseGetFaviconMethodInfo     ,
    faviconDatabaseGetFavicon               ,


-- ** faviconDatabaseGetFaviconFinish
    FaviconDatabaseGetFaviconFinishMethodInfo,
    faviconDatabaseGetFaviconFinish         ,


-- ** faviconDatabaseGetFaviconUri
    FaviconDatabaseGetFaviconUriMethodInfo  ,
    faviconDatabaseGetFaviconUri            ,




 -- * Signals
-- ** FaviconChanged
    FaviconDatabaseFaviconChangedCallback   ,
    FaviconDatabaseFaviconChangedCallbackC  ,
    FaviconDatabaseFaviconChangedSignalInfo ,
    afterFaviconDatabaseFaviconChanged      ,
    faviconDatabaseFaviconChangedCallbackWrapper,
    faviconDatabaseFaviconChangedClosure    ,
    mkFaviconDatabaseFaviconChangedCallback ,
    noFaviconDatabaseFaviconChangedCallback ,
    onFaviconDatabaseFaviconChanged         ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject
import qualified GI.Gio as Gio
import qualified GI.Cairo as Cairo

newtype FaviconDatabase = FaviconDatabase (ForeignPtr FaviconDatabase)
foreign import ccall "webkit_favicon_database_get_type"
    c_webkit_favicon_database_get_type :: IO GType

type instance ParentTypes FaviconDatabase = FaviconDatabaseParentTypes
type FaviconDatabaseParentTypes = '[GObject.Object]

instance GObject FaviconDatabase where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_favicon_database_get_type
    

class GObject o => FaviconDatabaseK o
instance (GObject o, IsDescendantOf FaviconDatabase o) => FaviconDatabaseK o

toFaviconDatabase :: FaviconDatabaseK o => o -> IO FaviconDatabase
toFaviconDatabase = unsafeCastTo FaviconDatabase

noFaviconDatabase :: Maybe FaviconDatabase
noFaviconDatabase = Nothing

type family ResolveFaviconDatabaseMethod (t :: Symbol) (o :: *) :: * where
    ResolveFaviconDatabaseMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveFaviconDatabaseMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveFaviconDatabaseMethod "clear" o = FaviconDatabaseClearMethodInfo
    ResolveFaviconDatabaseMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveFaviconDatabaseMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveFaviconDatabaseMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveFaviconDatabaseMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveFaviconDatabaseMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveFaviconDatabaseMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveFaviconDatabaseMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveFaviconDatabaseMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveFaviconDatabaseMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveFaviconDatabaseMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveFaviconDatabaseMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveFaviconDatabaseMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveFaviconDatabaseMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveFaviconDatabaseMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveFaviconDatabaseMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveFaviconDatabaseMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveFaviconDatabaseMethod "getFavicon" o = FaviconDatabaseGetFaviconMethodInfo
    ResolveFaviconDatabaseMethod "getFaviconFinish" o = FaviconDatabaseGetFaviconFinishMethodInfo
    ResolveFaviconDatabaseMethod "getFaviconUri" o = FaviconDatabaseGetFaviconUriMethodInfo
    ResolveFaviconDatabaseMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveFaviconDatabaseMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveFaviconDatabaseMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveFaviconDatabaseMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveFaviconDatabaseMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveFaviconDatabaseMethod t FaviconDatabase, MethodInfo info FaviconDatabase p) => IsLabelProxy t (FaviconDatabase -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveFaviconDatabaseMethod t FaviconDatabase, MethodInfo info FaviconDatabase p) => IsLabel t (FaviconDatabase -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- signal FaviconDatabase::favicon-changed
type FaviconDatabaseFaviconChangedCallback =
    T.Text ->
    T.Text ->
    IO ()

noFaviconDatabaseFaviconChangedCallback :: Maybe FaviconDatabaseFaviconChangedCallback
noFaviconDatabaseFaviconChangedCallback = Nothing

type FaviconDatabaseFaviconChangedCallbackC =
    Ptr () ->                               -- object
    CString ->
    CString ->
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkFaviconDatabaseFaviconChangedCallback :: FaviconDatabaseFaviconChangedCallbackC -> IO (FunPtr FaviconDatabaseFaviconChangedCallbackC)

faviconDatabaseFaviconChangedClosure :: FaviconDatabaseFaviconChangedCallback -> IO Closure
faviconDatabaseFaviconChangedClosure cb = newCClosure =<< mkFaviconDatabaseFaviconChangedCallback wrapped
    where wrapped = faviconDatabaseFaviconChangedCallbackWrapper cb

faviconDatabaseFaviconChangedCallbackWrapper ::
    FaviconDatabaseFaviconChangedCallback ->
    Ptr () ->
    CString ->
    CString ->
    Ptr () ->
    IO ()
faviconDatabaseFaviconChangedCallbackWrapper _cb _ pageUri faviconUri _ = do
    pageUri' <- cstringToText pageUri
    faviconUri' <- cstringToText faviconUri
    _cb  pageUri' faviconUri'

onFaviconDatabaseFaviconChanged :: (GObject a, MonadIO m) => a -> FaviconDatabaseFaviconChangedCallback -> m SignalHandlerId
onFaviconDatabaseFaviconChanged obj cb = liftIO $ connectFaviconDatabaseFaviconChanged obj cb SignalConnectBefore
afterFaviconDatabaseFaviconChanged :: (GObject a, MonadIO m) => a -> FaviconDatabaseFaviconChangedCallback -> m SignalHandlerId
afterFaviconDatabaseFaviconChanged obj cb = connectFaviconDatabaseFaviconChanged obj cb SignalConnectAfter

connectFaviconDatabaseFaviconChanged :: (GObject a, MonadIO m) =>
                                        a -> FaviconDatabaseFaviconChangedCallback -> SignalConnectMode -> m SignalHandlerId
connectFaviconDatabaseFaviconChanged obj cb after = liftIO $ do
    cb' <- mkFaviconDatabaseFaviconChangedCallback (faviconDatabaseFaviconChangedCallbackWrapper cb)
    connectSignalFunPtr obj "favicon-changed" cb' after

type instance AttributeList FaviconDatabase = FaviconDatabaseAttributeList
type FaviconDatabaseAttributeList = ('[ ] :: [(Symbol, *)])

data FaviconDatabaseFaviconChangedSignalInfo
instance SignalInfo FaviconDatabaseFaviconChangedSignalInfo where
    type HaskellCallbackType FaviconDatabaseFaviconChangedSignalInfo = FaviconDatabaseFaviconChangedCallback
    connectSignal _ = connectFaviconDatabaseFaviconChanged

type instance SignalList FaviconDatabase = FaviconDatabaseSignalList
type FaviconDatabaseSignalList = ('[ '("faviconChanged", FaviconDatabaseFaviconChangedSignalInfo), '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method FaviconDatabase::clear
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "FaviconDatabase", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_favicon_database_clear" webkit_favicon_database_clear :: 
    Ptr FaviconDatabase ->                  -- _obj : TInterface "WebKit2" "FaviconDatabase"
    IO ()


faviconDatabaseClear ::
    (MonadIO m, FaviconDatabaseK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
faviconDatabaseClear _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_favicon_database_clear _obj'
    touchManagedPtr _obj
    return ()

data FaviconDatabaseClearMethodInfo
instance (signature ~ (m ()), MonadIO m, FaviconDatabaseK a) => MethodInfo FaviconDatabaseClearMethodInfo a signature where
    overloadedMethod _ = faviconDatabaseClear

-- method FaviconDatabase::get_favicon
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "FaviconDatabase", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "page_uri", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "cancellable", argType = TInterface "Gio" "Cancellable", direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "callback", argType = TInterface "Gio" "AsyncReadyCallback", direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeAsync, argClosure = 4, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "user_data", argType = TBasicType TPtr, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_favicon_database_get_favicon" webkit_favicon_database_get_favicon :: 
    Ptr FaviconDatabase ->                  -- _obj : TInterface "WebKit2" "FaviconDatabase"
    CString ->                              -- page_uri : TBasicType TUTF8
    Ptr Gio.Cancellable ->                  -- cancellable : TInterface "Gio" "Cancellable"
    FunPtr Gio.AsyncReadyCallbackC ->       -- callback : TInterface "Gio" "AsyncReadyCallback"
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()


faviconDatabaseGetFavicon ::
    (MonadIO m, FaviconDatabaseK a, Gio.CancellableK b) =>
    a                                       -- _obj
    -> T.Text                               -- pageUri
    -> Maybe (b)                            -- cancellable
    -> Maybe (Gio.AsyncReadyCallback)       -- callback
    -> m ()                                 -- result
faviconDatabaseGetFavicon _obj pageUri cancellable callback = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    pageUri' <- textToCString pageUri
    maybeCancellable <- case cancellable of
        Nothing -> return nullPtr
        Just jCancellable -> do
            let jCancellable' = unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.AsyncReadyCallbackC))
    maybeCallback <- case callback of
        Nothing -> return (castPtrToFunPtr nullPtr)
        Just jCallback -> do
            jCallback' <- Gio.mkAsyncReadyCallback (Gio.asyncReadyCallbackWrapper (Just ptrcallback) jCallback)
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    webkit_favicon_database_get_favicon _obj' pageUri' maybeCancellable maybeCallback userData
    touchManagedPtr _obj
    whenJust cancellable touchManagedPtr
    freeMem pageUri'
    return ()

data FaviconDatabaseGetFaviconMethodInfo
instance (signature ~ (T.Text -> Maybe (b) -> Maybe (Gio.AsyncReadyCallback) -> m ()), MonadIO m, FaviconDatabaseK a, Gio.CancellableK b) => MethodInfo FaviconDatabaseGetFaviconMethodInfo a signature where
    overloadedMethod _ = faviconDatabaseGetFavicon

-- method FaviconDatabase::get_favicon_finish
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "FaviconDatabase", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "result", argType = TInterface "Gio" "AsyncResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "cairo" "Surface")
-- throws : True
-- Skip return : False

foreign import ccall "webkit_favicon_database_get_favicon_finish" webkit_favicon_database_get_favicon_finish :: 
    Ptr FaviconDatabase ->                  -- _obj : TInterface "WebKit2" "FaviconDatabase"
    Ptr Gio.AsyncResult ->                  -- result : TInterface "Gio" "AsyncResult"
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Cairo.Surface)


faviconDatabaseGetFaviconFinish ::
    (MonadIO m, FaviconDatabaseK a, Gio.AsyncResultK b) =>
    a                                       -- _obj
    -> b                                    -- result_
    -> m Cairo.Surface                      -- result
faviconDatabaseGetFaviconFinish _obj result_ = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let result_' = unsafeManagedPtrCastPtr result_
    onException (do
        result <- propagateGError $ webkit_favicon_database_get_favicon_finish _obj' result_'
        checkUnexpectedReturnNULL "webkit_favicon_database_get_favicon_finish" result
        result' <- (wrapBoxed Cairo.Surface) result
        touchManagedPtr _obj
        touchManagedPtr result_
        return result'
     ) (do
        return ()
     )

data FaviconDatabaseGetFaviconFinishMethodInfo
instance (signature ~ (b -> m Cairo.Surface), MonadIO m, FaviconDatabaseK a, Gio.AsyncResultK b) => MethodInfo FaviconDatabaseGetFaviconFinishMethodInfo a signature where
    overloadedMethod _ = faviconDatabaseGetFaviconFinish

-- method FaviconDatabase::get_favicon_uri
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "FaviconDatabase", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "page_uri", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_favicon_database_get_favicon_uri" webkit_favicon_database_get_favicon_uri :: 
    Ptr FaviconDatabase ->                  -- _obj : TInterface "WebKit2" "FaviconDatabase"
    CString ->                              -- page_uri : TBasicType TUTF8
    IO CString


faviconDatabaseGetFaviconUri ::
    (MonadIO m, FaviconDatabaseK a) =>
    a                                       -- _obj
    -> T.Text                               -- pageUri
    -> m T.Text                             -- result
faviconDatabaseGetFaviconUri _obj pageUri = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    pageUri' <- textToCString pageUri
    result <- webkit_favicon_database_get_favicon_uri _obj' pageUri'
    checkUnexpectedReturnNULL "webkit_favicon_database_get_favicon_uri" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr _obj
    freeMem pageUri'
    return result'

data FaviconDatabaseGetFaviconUriMethodInfo
instance (signature ~ (T.Text -> m T.Text), MonadIO m, FaviconDatabaseK a) => MethodInfo FaviconDatabaseGetFaviconUriMethodInfo a signature where
    overloadedMethod _ = faviconDatabaseGetFaviconUri


