

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.FindController
    ( 

-- * Exported types
    FindController(..)                      ,
    FindControllerK                         ,
    toFindController                        ,
    noFindController                        ,


 -- * Methods
-- ** findControllerCountMatches
    FindControllerCountMatchesMethodInfo    ,
    findControllerCountMatches              ,


-- ** findControllerGetMaxMatchCount
    FindControllerGetMaxMatchCountMethodInfo,
    findControllerGetMaxMatchCount          ,


-- ** findControllerGetOptions
    FindControllerGetOptionsMethodInfo      ,
    findControllerGetOptions                ,


-- ** findControllerGetSearchText
    FindControllerGetSearchTextMethodInfo   ,
    findControllerGetSearchText             ,


-- ** findControllerGetWebView
    FindControllerGetWebViewMethodInfo      ,
    findControllerGetWebView                ,


-- ** findControllerSearch
    FindControllerSearchMethodInfo          ,
    findControllerSearch                    ,


-- ** findControllerSearchFinish
    FindControllerSearchFinishMethodInfo    ,
    findControllerSearchFinish              ,


-- ** findControllerSearchNext
    FindControllerSearchNextMethodInfo      ,
    findControllerSearchNext                ,


-- ** findControllerSearchPrevious
    FindControllerSearchPreviousMethodInfo  ,
    findControllerSearchPrevious            ,




 -- * Properties
-- ** MaxMatchCount
    FindControllerMaxMatchCountPropertyInfo ,
    findControllerMaxMatchCount             ,
    getFindControllerMaxMatchCount          ,


-- ** Options
    FindControllerOptionsPropertyInfo       ,
    findControllerOptions                   ,
    getFindControllerOptions                ,


-- ** Text
    FindControllerTextPropertyInfo          ,
    findControllerText                      ,
    getFindControllerText                   ,


-- ** WebView
    FindControllerWebViewPropertyInfo       ,
    constructFindControllerWebView          ,
    findControllerWebView                   ,
    getFindControllerWebView                ,




 -- * Signals
-- ** CountedMatches
    FindControllerCountedMatchesCallback    ,
    FindControllerCountedMatchesCallbackC   ,
    FindControllerCountedMatchesSignalInfo  ,
    afterFindControllerCountedMatches       ,
    findControllerCountedMatchesCallbackWrapper,
    findControllerCountedMatchesClosure     ,
    mkFindControllerCountedMatchesCallback  ,
    noFindControllerCountedMatchesCallback  ,
    onFindControllerCountedMatches          ,


-- ** FailedToFindText
    FindControllerFailedToFindTextCallback  ,
    FindControllerFailedToFindTextCallbackC ,
    FindControllerFailedToFindTextSignalInfo,
    afterFindControllerFailedToFindText     ,
    findControllerFailedToFindTextCallbackWrapper,
    findControllerFailedToFindTextClosure   ,
    mkFindControllerFailedToFindTextCallback,
    noFindControllerFailedToFindTextCallback,
    onFindControllerFailedToFindText        ,


-- ** FoundText
    FindControllerFoundTextCallback         ,
    FindControllerFoundTextCallbackC        ,
    FindControllerFoundTextSignalInfo       ,
    afterFindControllerFoundText            ,
    findControllerFoundTextCallbackWrapper  ,
    findControllerFoundTextClosure          ,
    mkFindControllerFoundTextCallback       ,
    noFindControllerFoundTextCallback       ,
    onFindControllerFoundText               ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject

newtype FindController = FindController (ForeignPtr FindController)
foreign import ccall "webkit_find_controller_get_type"
    c_webkit_find_controller_get_type :: IO GType

type instance ParentTypes FindController = FindControllerParentTypes
type FindControllerParentTypes = '[GObject.Object]

instance GObject FindController where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_find_controller_get_type
    

class GObject o => FindControllerK o
instance (GObject o, IsDescendantOf FindController o) => FindControllerK o

toFindController :: FindControllerK o => o -> IO FindController
toFindController = unsafeCastTo FindController

noFindController :: Maybe FindController
noFindController = Nothing

type family ResolveFindControllerMethod (t :: Symbol) (o :: *) :: * where
    ResolveFindControllerMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveFindControllerMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveFindControllerMethod "countMatches" o = FindControllerCountMatchesMethodInfo
    ResolveFindControllerMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveFindControllerMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveFindControllerMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveFindControllerMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveFindControllerMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveFindControllerMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveFindControllerMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveFindControllerMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveFindControllerMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveFindControllerMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveFindControllerMethod "search" o = FindControllerSearchMethodInfo
    ResolveFindControllerMethod "searchFinish" o = FindControllerSearchFinishMethodInfo
    ResolveFindControllerMethod "searchNext" o = FindControllerSearchNextMethodInfo
    ResolveFindControllerMethod "searchPrevious" o = FindControllerSearchPreviousMethodInfo
    ResolveFindControllerMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveFindControllerMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveFindControllerMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveFindControllerMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveFindControllerMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveFindControllerMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveFindControllerMethod "getMaxMatchCount" o = FindControllerGetMaxMatchCountMethodInfo
    ResolveFindControllerMethod "getOptions" o = FindControllerGetOptionsMethodInfo
    ResolveFindControllerMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveFindControllerMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveFindControllerMethod "getSearchText" o = FindControllerGetSearchTextMethodInfo
    ResolveFindControllerMethod "getWebView" o = FindControllerGetWebViewMethodInfo
    ResolveFindControllerMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveFindControllerMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveFindControllerMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveFindControllerMethod t FindController, MethodInfo info FindController p) => IsLabelProxy t (FindController -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveFindControllerMethod t FindController, MethodInfo info FindController p) => IsLabel t (FindController -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- signal FindController::counted-matches
type FindControllerCountedMatchesCallback =
    Word32 ->
    IO ()

noFindControllerCountedMatchesCallback :: Maybe FindControllerCountedMatchesCallback
noFindControllerCountedMatchesCallback = Nothing

type FindControllerCountedMatchesCallbackC =
    Ptr () ->                               -- object
    Word32 ->
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkFindControllerCountedMatchesCallback :: FindControllerCountedMatchesCallbackC -> IO (FunPtr FindControllerCountedMatchesCallbackC)

findControllerCountedMatchesClosure :: FindControllerCountedMatchesCallback -> IO Closure
findControllerCountedMatchesClosure cb = newCClosure =<< mkFindControllerCountedMatchesCallback wrapped
    where wrapped = findControllerCountedMatchesCallbackWrapper cb

findControllerCountedMatchesCallbackWrapper ::
    FindControllerCountedMatchesCallback ->
    Ptr () ->
    Word32 ->
    Ptr () ->
    IO ()
findControllerCountedMatchesCallbackWrapper _cb _ matchCount _ = do
    _cb  matchCount

onFindControllerCountedMatches :: (GObject a, MonadIO m) => a -> FindControllerCountedMatchesCallback -> m SignalHandlerId
onFindControllerCountedMatches obj cb = liftIO $ connectFindControllerCountedMatches obj cb SignalConnectBefore
afterFindControllerCountedMatches :: (GObject a, MonadIO m) => a -> FindControllerCountedMatchesCallback -> m SignalHandlerId
afterFindControllerCountedMatches obj cb = connectFindControllerCountedMatches obj cb SignalConnectAfter

connectFindControllerCountedMatches :: (GObject a, MonadIO m) =>
                                       a -> FindControllerCountedMatchesCallback -> SignalConnectMode -> m SignalHandlerId
connectFindControllerCountedMatches obj cb after = liftIO $ do
    cb' <- mkFindControllerCountedMatchesCallback (findControllerCountedMatchesCallbackWrapper cb)
    connectSignalFunPtr obj "counted-matches" cb' after

-- signal FindController::failed-to-find-text
type FindControllerFailedToFindTextCallback =
    IO ()

noFindControllerFailedToFindTextCallback :: Maybe FindControllerFailedToFindTextCallback
noFindControllerFailedToFindTextCallback = Nothing

type FindControllerFailedToFindTextCallbackC =
    Ptr () ->                               -- object
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkFindControllerFailedToFindTextCallback :: FindControllerFailedToFindTextCallbackC -> IO (FunPtr FindControllerFailedToFindTextCallbackC)

findControllerFailedToFindTextClosure :: FindControllerFailedToFindTextCallback -> IO Closure
findControllerFailedToFindTextClosure cb = newCClosure =<< mkFindControllerFailedToFindTextCallback wrapped
    where wrapped = findControllerFailedToFindTextCallbackWrapper cb

findControllerFailedToFindTextCallbackWrapper ::
    FindControllerFailedToFindTextCallback ->
    Ptr () ->
    Ptr () ->
    IO ()
findControllerFailedToFindTextCallbackWrapper _cb _ _ = do
    _cb 

onFindControllerFailedToFindText :: (GObject a, MonadIO m) => a -> FindControllerFailedToFindTextCallback -> m SignalHandlerId
onFindControllerFailedToFindText obj cb = liftIO $ connectFindControllerFailedToFindText obj cb SignalConnectBefore
afterFindControllerFailedToFindText :: (GObject a, MonadIO m) => a -> FindControllerFailedToFindTextCallback -> m SignalHandlerId
afterFindControllerFailedToFindText obj cb = connectFindControllerFailedToFindText obj cb SignalConnectAfter

connectFindControllerFailedToFindText :: (GObject a, MonadIO m) =>
                                         a -> FindControllerFailedToFindTextCallback -> SignalConnectMode -> m SignalHandlerId
connectFindControllerFailedToFindText obj cb after = liftIO $ do
    cb' <- mkFindControllerFailedToFindTextCallback (findControllerFailedToFindTextCallbackWrapper cb)
    connectSignalFunPtr obj "failed-to-find-text" cb' after

-- signal FindController::found-text
type FindControllerFoundTextCallback =
    Word32 ->
    IO ()

noFindControllerFoundTextCallback :: Maybe FindControllerFoundTextCallback
noFindControllerFoundTextCallback = Nothing

type FindControllerFoundTextCallbackC =
    Ptr () ->                               -- object
    Word32 ->
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkFindControllerFoundTextCallback :: FindControllerFoundTextCallbackC -> IO (FunPtr FindControllerFoundTextCallbackC)

findControllerFoundTextClosure :: FindControllerFoundTextCallback -> IO Closure
findControllerFoundTextClosure cb = newCClosure =<< mkFindControllerFoundTextCallback wrapped
    where wrapped = findControllerFoundTextCallbackWrapper cb

findControllerFoundTextCallbackWrapper ::
    FindControllerFoundTextCallback ->
    Ptr () ->
    Word32 ->
    Ptr () ->
    IO ()
findControllerFoundTextCallbackWrapper _cb _ matchCount _ = do
    _cb  matchCount

onFindControllerFoundText :: (GObject a, MonadIO m) => a -> FindControllerFoundTextCallback -> m SignalHandlerId
onFindControllerFoundText obj cb = liftIO $ connectFindControllerFoundText obj cb SignalConnectBefore
afterFindControllerFoundText :: (GObject a, MonadIO m) => a -> FindControllerFoundTextCallback -> m SignalHandlerId
afterFindControllerFoundText obj cb = connectFindControllerFoundText obj cb SignalConnectAfter

connectFindControllerFoundText :: (GObject a, MonadIO m) =>
                                  a -> FindControllerFoundTextCallback -> SignalConnectMode -> m SignalHandlerId
connectFindControllerFoundText obj cb after = liftIO $ do
    cb' <- mkFindControllerFoundTextCallback (findControllerFoundTextCallbackWrapper cb)
    connectSignalFunPtr obj "found-text" cb' after

-- VVV Prop "max-match-count"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getFindControllerMaxMatchCount :: (MonadIO m, FindControllerK o) => o -> m Word32
getFindControllerMaxMatchCount obj = liftIO $ getObjectPropertyUInt32 obj "max-match-count"

data FindControllerMaxMatchCountPropertyInfo
instance AttrInfo FindControllerMaxMatchCountPropertyInfo where
    type AttrAllowedOps FindControllerMaxMatchCountPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint FindControllerMaxMatchCountPropertyInfo = (~) ()
    type AttrBaseTypeConstraint FindControllerMaxMatchCountPropertyInfo = FindControllerK
    type AttrGetType FindControllerMaxMatchCountPropertyInfo = Word32
    type AttrLabel FindControllerMaxMatchCountPropertyInfo = "max-match-count"
    attrGet _ = getFindControllerMaxMatchCount
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "options"
   -- Type: TInterface "WebKit2" "FindOptions"
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getFindControllerOptions :: (MonadIO m, FindControllerK o) => o -> m [FindOptions]
getFindControllerOptions obj = liftIO $ getObjectPropertyFlags obj "options"

data FindControllerOptionsPropertyInfo
instance AttrInfo FindControllerOptionsPropertyInfo where
    type AttrAllowedOps FindControllerOptionsPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint FindControllerOptionsPropertyInfo = (~) ()
    type AttrBaseTypeConstraint FindControllerOptionsPropertyInfo = FindControllerK
    type AttrGetType FindControllerOptionsPropertyInfo = [FindOptions]
    type AttrLabel FindControllerOptionsPropertyInfo = "options"
    attrGet _ = getFindControllerOptions
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "text"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

getFindControllerText :: (MonadIO m, FindControllerK o) => o -> m (Maybe T.Text)
getFindControllerText obj = liftIO $ getObjectPropertyString obj "text"

data FindControllerTextPropertyInfo
instance AttrInfo FindControllerTextPropertyInfo where
    type AttrAllowedOps FindControllerTextPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint FindControllerTextPropertyInfo = (~) ()
    type AttrBaseTypeConstraint FindControllerTextPropertyInfo = FindControllerK
    type AttrGetType FindControllerTextPropertyInfo = (Maybe T.Text)
    type AttrLabel FindControllerTextPropertyInfo = "text"
    attrGet _ = getFindControllerText
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "web-view"
   -- Type: TInterface "WebKit2" "WebView"
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

getFindControllerWebView :: (MonadIO m, FindControllerK o) => o -> m WebView
getFindControllerWebView obj = liftIO $ checkUnexpectedNothing "getFindControllerWebView" $ getObjectPropertyObject obj "web-view" WebView

constructFindControllerWebView :: (WebViewK a) => a -> IO ([Char], GValue)
constructFindControllerWebView val = constructObjectPropertyObject "web-view" (Just val)

data FindControllerWebViewPropertyInfo
instance AttrInfo FindControllerWebViewPropertyInfo where
    type AttrAllowedOps FindControllerWebViewPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint FindControllerWebViewPropertyInfo = WebViewK
    type AttrBaseTypeConstraint FindControllerWebViewPropertyInfo = FindControllerK
    type AttrGetType FindControllerWebViewPropertyInfo = WebView
    type AttrLabel FindControllerWebViewPropertyInfo = "web-view"
    attrGet _ = getFindControllerWebView
    attrSet _ = undefined
    attrConstruct _ = constructFindControllerWebView
    attrClear _ = undefined

type instance AttributeList FindController = FindControllerAttributeList
type FindControllerAttributeList = ('[ '("maxMatchCount", FindControllerMaxMatchCountPropertyInfo), '("options", FindControllerOptionsPropertyInfo), '("text", FindControllerTextPropertyInfo), '("webView", FindControllerWebViewPropertyInfo)] :: [(Symbol, *)])

findControllerMaxMatchCount :: AttrLabelProxy "maxMatchCount"
findControllerMaxMatchCount = AttrLabelProxy

findControllerOptions :: AttrLabelProxy "options"
findControllerOptions = AttrLabelProxy

findControllerText :: AttrLabelProxy "text"
findControllerText = AttrLabelProxy

findControllerWebView :: AttrLabelProxy "webView"
findControllerWebView = AttrLabelProxy

data FindControllerCountedMatchesSignalInfo
instance SignalInfo FindControllerCountedMatchesSignalInfo where
    type HaskellCallbackType FindControllerCountedMatchesSignalInfo = FindControllerCountedMatchesCallback
    connectSignal _ = connectFindControllerCountedMatches

data FindControllerFailedToFindTextSignalInfo
instance SignalInfo FindControllerFailedToFindTextSignalInfo where
    type HaskellCallbackType FindControllerFailedToFindTextSignalInfo = FindControllerFailedToFindTextCallback
    connectSignal _ = connectFindControllerFailedToFindText

data FindControllerFoundTextSignalInfo
instance SignalInfo FindControllerFoundTextSignalInfo where
    type HaskellCallbackType FindControllerFoundTextSignalInfo = FindControllerFoundTextCallback
    connectSignal _ = connectFindControllerFoundText

type instance SignalList FindController = FindControllerSignalList
type FindControllerSignalList = ('[ '("countedMatches", FindControllerCountedMatchesSignalInfo), '("failedToFindText", FindControllerFailedToFindTextSignalInfo), '("foundText", FindControllerFoundTextSignalInfo), '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method FindController::count_matches
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "FindController", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "search_text", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "find_options", argType = TBasicType TUInt32, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "max_match_count", argType = TBasicType TUInt, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_find_controller_count_matches" webkit_find_controller_count_matches :: 
    Ptr FindController ->                   -- _obj : TInterface "WebKit2" "FindController"
    CString ->                              -- search_text : TBasicType TUTF8
    Word32 ->                               -- find_options : TBasicType TUInt32
    Word32 ->                               -- max_match_count : TBasicType TUInt
    IO ()


findControllerCountMatches ::
    (MonadIO m, FindControllerK a) =>
    a                                       -- _obj
    -> T.Text                               -- searchText
    -> Word32                               -- findOptions
    -> Word32                               -- maxMatchCount
    -> m ()                                 -- result
findControllerCountMatches _obj searchText findOptions maxMatchCount = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    searchText' <- textToCString searchText
    webkit_find_controller_count_matches _obj' searchText' findOptions maxMatchCount
    touchManagedPtr _obj
    freeMem searchText'
    return ()

data FindControllerCountMatchesMethodInfo
instance (signature ~ (T.Text -> Word32 -> Word32 -> m ()), MonadIO m, FindControllerK a) => MethodInfo FindControllerCountMatchesMethodInfo a signature where
    overloadedMethod _ = findControllerCountMatches

-- method FindController::get_max_match_count
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "FindController", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_find_controller_get_max_match_count" webkit_find_controller_get_max_match_count :: 
    Ptr FindController ->                   -- _obj : TInterface "WebKit2" "FindController"
    IO Word32


findControllerGetMaxMatchCount ::
    (MonadIO m, FindControllerK a) =>
    a                                       -- _obj
    -> m Word32                             -- result
findControllerGetMaxMatchCount _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_find_controller_get_max_match_count _obj'
    touchManagedPtr _obj
    return result

data FindControllerGetMaxMatchCountMethodInfo
instance (signature ~ (m Word32), MonadIO m, FindControllerK a) => MethodInfo FindControllerGetMaxMatchCountMethodInfo a signature where
    overloadedMethod _ = findControllerGetMaxMatchCount

-- method FindController::get_options
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "FindController", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_find_controller_get_options" webkit_find_controller_get_options :: 
    Ptr FindController ->                   -- _obj : TInterface "WebKit2" "FindController"
    IO Word32


findControllerGetOptions ::
    (MonadIO m, FindControllerK a) =>
    a                                       -- _obj
    -> m Word32                             -- result
findControllerGetOptions _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_find_controller_get_options _obj'
    touchManagedPtr _obj
    return result

data FindControllerGetOptionsMethodInfo
instance (signature ~ (m Word32), MonadIO m, FindControllerK a) => MethodInfo FindControllerGetOptionsMethodInfo a signature where
    overloadedMethod _ = findControllerGetOptions

-- method FindController::get_search_text
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "FindController", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_find_controller_get_search_text" webkit_find_controller_get_search_text :: 
    Ptr FindController ->                   -- _obj : TInterface "WebKit2" "FindController"
    IO CString


findControllerGetSearchText ::
    (MonadIO m, FindControllerK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
findControllerGetSearchText _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_find_controller_get_search_text _obj'
    checkUnexpectedReturnNULL "webkit_find_controller_get_search_text" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data FindControllerGetSearchTextMethodInfo
instance (signature ~ (m T.Text), MonadIO m, FindControllerK a) => MethodInfo FindControllerGetSearchTextMethodInfo a signature where
    overloadedMethod _ = findControllerGetSearchText

-- method FindController::get_web_view
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "FindController", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "WebView")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_find_controller_get_web_view" webkit_find_controller_get_web_view :: 
    Ptr FindController ->                   -- _obj : TInterface "WebKit2" "FindController"
    IO (Ptr WebView)


findControllerGetWebView ::
    (MonadIO m, FindControllerK a) =>
    a                                       -- _obj
    -> m WebView                            -- result
findControllerGetWebView _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_find_controller_get_web_view _obj'
    checkUnexpectedReturnNULL "webkit_find_controller_get_web_view" result
    result' <- (newObject WebView) result
    touchManagedPtr _obj
    return result'

data FindControllerGetWebViewMethodInfo
instance (signature ~ (m WebView), MonadIO m, FindControllerK a) => MethodInfo FindControllerGetWebViewMethodInfo a signature where
    overloadedMethod _ = findControllerGetWebView

-- method FindController::search
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "FindController", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "search_text", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "find_options", argType = TBasicType TUInt32, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "max_match_count", argType = TBasicType TUInt, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_find_controller_search" webkit_find_controller_search :: 
    Ptr FindController ->                   -- _obj : TInterface "WebKit2" "FindController"
    CString ->                              -- search_text : TBasicType TUTF8
    Word32 ->                               -- find_options : TBasicType TUInt32
    Word32 ->                               -- max_match_count : TBasicType TUInt
    IO ()


findControllerSearch ::
    (MonadIO m, FindControllerK a) =>
    a                                       -- _obj
    -> T.Text                               -- searchText
    -> Word32                               -- findOptions
    -> Word32                               -- maxMatchCount
    -> m ()                                 -- result
findControllerSearch _obj searchText findOptions maxMatchCount = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    searchText' <- textToCString searchText
    webkit_find_controller_search _obj' searchText' findOptions maxMatchCount
    touchManagedPtr _obj
    freeMem searchText'
    return ()

data FindControllerSearchMethodInfo
instance (signature ~ (T.Text -> Word32 -> Word32 -> m ()), MonadIO m, FindControllerK a) => MethodInfo FindControllerSearchMethodInfo a signature where
    overloadedMethod _ = findControllerSearch

-- method FindController::search_finish
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "FindController", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_find_controller_search_finish" webkit_find_controller_search_finish :: 
    Ptr FindController ->                   -- _obj : TInterface "WebKit2" "FindController"
    IO ()


findControllerSearchFinish ::
    (MonadIO m, FindControllerK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
findControllerSearchFinish _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_find_controller_search_finish _obj'
    touchManagedPtr _obj
    return ()

data FindControllerSearchFinishMethodInfo
instance (signature ~ (m ()), MonadIO m, FindControllerK a) => MethodInfo FindControllerSearchFinishMethodInfo a signature where
    overloadedMethod _ = findControllerSearchFinish

-- method FindController::search_next
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "FindController", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_find_controller_search_next" webkit_find_controller_search_next :: 
    Ptr FindController ->                   -- _obj : TInterface "WebKit2" "FindController"
    IO ()


findControllerSearchNext ::
    (MonadIO m, FindControllerK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
findControllerSearchNext _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_find_controller_search_next _obj'
    touchManagedPtr _obj
    return ()

data FindControllerSearchNextMethodInfo
instance (signature ~ (m ()), MonadIO m, FindControllerK a) => MethodInfo FindControllerSearchNextMethodInfo a signature where
    overloadedMethod _ = findControllerSearchNext

-- method FindController::search_previous
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "FindController", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_find_controller_search_previous" webkit_find_controller_search_previous :: 
    Ptr FindController ->                   -- _obj : TInterface "WebKit2" "FindController"
    IO ()


findControllerSearchPrevious ::
    (MonadIO m, FindControllerK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
findControllerSearchPrevious _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_find_controller_search_previous _obj'
    touchManagedPtr _obj
    return ()

data FindControllerSearchPreviousMethodInfo
instance (signature ~ (m ()), MonadIO m, FindControllerK a) => MethodInfo FindControllerSearchPreviousMethodInfo a signature where
    overloadedMethod _ = findControllerSearchPrevious


