

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.FormSubmissionRequest
    ( 

-- * Exported types
    FormSubmissionRequest(..)               ,
    FormSubmissionRequestK                  ,
    toFormSubmissionRequest                 ,
    noFormSubmissionRequest                 ,


 -- * Methods
-- ** formSubmissionRequestGetTextFields
    FormSubmissionRequestGetTextFieldsMethodInfo,
    formSubmissionRequestGetTextFields      ,


-- ** formSubmissionRequestSubmit
    FormSubmissionRequestSubmitMethodInfo   ,
    formSubmissionRequestSubmit             ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject

newtype FormSubmissionRequest = FormSubmissionRequest (ForeignPtr FormSubmissionRequest)
foreign import ccall "webkit_form_submission_request_get_type"
    c_webkit_form_submission_request_get_type :: IO GType

type instance ParentTypes FormSubmissionRequest = FormSubmissionRequestParentTypes
type FormSubmissionRequestParentTypes = '[GObject.Object]

instance GObject FormSubmissionRequest where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_form_submission_request_get_type
    

class GObject o => FormSubmissionRequestK o
instance (GObject o, IsDescendantOf FormSubmissionRequest o) => FormSubmissionRequestK o

toFormSubmissionRequest :: FormSubmissionRequestK o => o -> IO FormSubmissionRequest
toFormSubmissionRequest = unsafeCastTo FormSubmissionRequest

noFormSubmissionRequest :: Maybe FormSubmissionRequest
noFormSubmissionRequest = Nothing

type family ResolveFormSubmissionRequestMethod (t :: Symbol) (o :: *) :: * where
    ResolveFormSubmissionRequestMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveFormSubmissionRequestMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveFormSubmissionRequestMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveFormSubmissionRequestMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveFormSubmissionRequestMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveFormSubmissionRequestMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveFormSubmissionRequestMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveFormSubmissionRequestMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveFormSubmissionRequestMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveFormSubmissionRequestMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveFormSubmissionRequestMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveFormSubmissionRequestMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveFormSubmissionRequestMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveFormSubmissionRequestMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveFormSubmissionRequestMethod "submit" o = FormSubmissionRequestSubmitMethodInfo
    ResolveFormSubmissionRequestMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveFormSubmissionRequestMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveFormSubmissionRequestMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveFormSubmissionRequestMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveFormSubmissionRequestMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveFormSubmissionRequestMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveFormSubmissionRequestMethod "getTextFields" o = FormSubmissionRequestGetTextFieldsMethodInfo
    ResolveFormSubmissionRequestMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveFormSubmissionRequestMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveFormSubmissionRequestMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveFormSubmissionRequestMethod t FormSubmissionRequest, MethodInfo info FormSubmissionRequest p) => IsLabelProxy t (FormSubmissionRequest -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveFormSubmissionRequestMethod t FormSubmissionRequest, MethodInfo info FormSubmissionRequest p) => IsLabel t (FormSubmissionRequest -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

type instance AttributeList FormSubmissionRequest = FormSubmissionRequestAttributeList
type FormSubmissionRequestAttributeList = ('[ ] :: [(Symbol, *)])

type instance SignalList FormSubmissionRequest = FormSubmissionRequestSignalList
type FormSubmissionRequestSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method FormSubmissionRequest::get_text_fields
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "FormSubmissionRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TGHash (TBasicType TPtr) (TBasicType TPtr))
-- throws : False
-- Skip return : False

foreign import ccall "webkit_form_submission_request_get_text_fields" webkit_form_submission_request_get_text_fields :: 
    Ptr FormSubmissionRequest ->            -- _obj : TInterface "WebKit2" "FormSubmissionRequest"
    IO (Ptr (GHashTable (Ptr ()) (Ptr ())))


formSubmissionRequestGetTextFields ::
    (MonadIO m, FormSubmissionRequestK a) =>
    a                                       -- _obj
    -> m (Map.Map (Ptr ()) (Ptr ()))        -- result
formSubmissionRequestGetTextFields _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_form_submission_request_get_text_fields _obj'
    checkUnexpectedReturnNULL "webkit_form_submission_request_get_text_fields" result
    result' <- unpackGHashTable result
    let result'' = mapFirst ptrUnpackPtr result'
    let result''' = mapSecond ptrUnpackPtr result''
    let result'''' = Map.fromList result'''
    touchManagedPtr _obj
    return result''''

data FormSubmissionRequestGetTextFieldsMethodInfo
instance (signature ~ (m (Map.Map (Ptr ()) (Ptr ()))), MonadIO m, FormSubmissionRequestK a) => MethodInfo FormSubmissionRequestGetTextFieldsMethodInfo a signature where
    overloadedMethod _ = formSubmissionRequestGetTextFields

-- method FormSubmissionRequest::submit
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "FormSubmissionRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_form_submission_request_submit" webkit_form_submission_request_submit :: 
    Ptr FormSubmissionRequest ->            -- _obj : TInterface "WebKit2" "FormSubmissionRequest"
    IO ()


formSubmissionRequestSubmit ::
    (MonadIO m, FormSubmissionRequestK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
formSubmissionRequestSubmit _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_form_submission_request_submit _obj'
    touchManagedPtr _obj
    return ()

data FormSubmissionRequestSubmitMethodInfo
instance (signature ~ (m ()), MonadIO m, FormSubmissionRequestK a) => MethodInfo FormSubmissionRequestSubmitMethodInfo a signature where
    overloadedMethod _ = formSubmissionRequestSubmit


