

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.GeolocationPermissionRequest
    ( 

-- * Exported types
    GeolocationPermissionRequest(..)        ,
    GeolocationPermissionRequestK           ,
    toGeolocationPermissionRequest          ,
    noGeolocationPermissionRequest          ,


    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject

newtype GeolocationPermissionRequest = GeolocationPermissionRequest (ForeignPtr GeolocationPermissionRequest)
foreign import ccall "webkit_geolocation_permission_request_get_type"
    c_webkit_geolocation_permission_request_get_type :: IO GType

type instance ParentTypes GeolocationPermissionRequest = GeolocationPermissionRequestParentTypes
type GeolocationPermissionRequestParentTypes = '[GObject.Object, PermissionRequest]

instance GObject GeolocationPermissionRequest where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_geolocation_permission_request_get_type
    

class GObject o => GeolocationPermissionRequestK o
instance (GObject o, IsDescendantOf GeolocationPermissionRequest o) => GeolocationPermissionRequestK o

toGeolocationPermissionRequest :: GeolocationPermissionRequestK o => o -> IO GeolocationPermissionRequest
toGeolocationPermissionRequest = unsafeCastTo GeolocationPermissionRequest

noGeolocationPermissionRequest :: Maybe GeolocationPermissionRequest
noGeolocationPermissionRequest = Nothing

type family ResolveGeolocationPermissionRequestMethod (t :: Symbol) (o :: *) :: * where
    ResolveGeolocationPermissionRequestMethod "allow" o = PermissionRequestAllowMethodInfo
    ResolveGeolocationPermissionRequestMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveGeolocationPermissionRequestMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveGeolocationPermissionRequestMethod "deny" o = PermissionRequestDenyMethodInfo
    ResolveGeolocationPermissionRequestMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveGeolocationPermissionRequestMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveGeolocationPermissionRequestMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveGeolocationPermissionRequestMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveGeolocationPermissionRequestMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveGeolocationPermissionRequestMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveGeolocationPermissionRequestMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveGeolocationPermissionRequestMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveGeolocationPermissionRequestMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveGeolocationPermissionRequestMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveGeolocationPermissionRequestMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveGeolocationPermissionRequestMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveGeolocationPermissionRequestMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveGeolocationPermissionRequestMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveGeolocationPermissionRequestMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveGeolocationPermissionRequestMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveGeolocationPermissionRequestMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveGeolocationPermissionRequestMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveGeolocationPermissionRequestMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveGeolocationPermissionRequestMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveGeolocationPermissionRequestMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveGeolocationPermissionRequestMethod t GeolocationPermissionRequest, MethodInfo info GeolocationPermissionRequest p) => IsLabelProxy t (GeolocationPermissionRequest -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveGeolocationPermissionRequestMethod t GeolocationPermissionRequest, MethodInfo info GeolocationPermissionRequest p) => IsLabel t (GeolocationPermissionRequest -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

type instance AttributeList GeolocationPermissionRequest = GeolocationPermissionRequestAttributeList
type GeolocationPermissionRequestAttributeList = ('[ ] :: [(Symbol, *)])

type instance SignalList GeolocationPermissionRequest = GeolocationPermissionRequestSignalList
type GeolocationPermissionRequestSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])


