

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.HitTestResult
    ( 

-- * Exported types
    HitTestResult(..)                       ,
    HitTestResultK                          ,
    toHitTestResult                         ,
    noHitTestResult                         ,


 -- * Methods
-- ** hitTestResultContextIsEditable
    HitTestResultContextIsEditableMethodInfo,
    hitTestResultContextIsEditable          ,


-- ** hitTestResultContextIsImage
    HitTestResultContextIsImageMethodInfo   ,
    hitTestResultContextIsImage             ,


-- ** hitTestResultContextIsLink
    HitTestResultContextIsLinkMethodInfo    ,
    hitTestResultContextIsLink              ,


-- ** hitTestResultContextIsMedia
    HitTestResultContextIsMediaMethodInfo   ,
    hitTestResultContextIsMedia             ,


-- ** hitTestResultContextIsScrollbar
    HitTestResultContextIsScrollbarMethodInfo,
    hitTestResultContextIsScrollbar         ,


-- ** hitTestResultContextIsSelection
    HitTestResultContextIsSelectionMethodInfo,
    hitTestResultContextIsSelection         ,


-- ** hitTestResultGetContext
    HitTestResultGetContextMethodInfo       ,
    hitTestResultGetContext                 ,


-- ** hitTestResultGetImageUri
    HitTestResultGetImageUriMethodInfo      ,
    hitTestResultGetImageUri                ,


-- ** hitTestResultGetLinkLabel
    HitTestResultGetLinkLabelMethodInfo     ,
    hitTestResultGetLinkLabel               ,


-- ** hitTestResultGetLinkTitle
    HitTestResultGetLinkTitleMethodInfo     ,
    hitTestResultGetLinkTitle               ,


-- ** hitTestResultGetLinkUri
    HitTestResultGetLinkUriMethodInfo       ,
    hitTestResultGetLinkUri                 ,


-- ** hitTestResultGetMediaUri
    HitTestResultGetMediaUriMethodInfo      ,
    hitTestResultGetMediaUri                ,




 -- * Properties
-- ** Context
    HitTestResultContextPropertyInfo        ,
    constructHitTestResultContext           ,
    getHitTestResultContext                 ,
    hitTestResultContext                    ,


-- ** ImageUri
    HitTestResultImageUriPropertyInfo       ,
    constructHitTestResultImageUri          ,
    getHitTestResultImageUri                ,
    hitTestResultImageUri                   ,


-- ** LinkLabel
    HitTestResultLinkLabelPropertyInfo      ,
    constructHitTestResultLinkLabel         ,
    getHitTestResultLinkLabel               ,
    hitTestResultLinkLabel                  ,


-- ** LinkTitle
    HitTestResultLinkTitlePropertyInfo      ,
    constructHitTestResultLinkTitle         ,
    getHitTestResultLinkTitle               ,
    hitTestResultLinkTitle                  ,


-- ** LinkUri
    HitTestResultLinkUriPropertyInfo        ,
    constructHitTestResultLinkUri           ,
    getHitTestResultLinkUri                 ,
    hitTestResultLinkUri                    ,


-- ** MediaUri
    HitTestResultMediaUriPropertyInfo       ,
    constructHitTestResultMediaUri          ,
    getHitTestResultMediaUri                ,
    hitTestResultMediaUri                   ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject

newtype HitTestResult = HitTestResult (ForeignPtr HitTestResult)
foreign import ccall "webkit_hit_test_result_get_type"
    c_webkit_hit_test_result_get_type :: IO GType

type instance ParentTypes HitTestResult = HitTestResultParentTypes
type HitTestResultParentTypes = '[GObject.Object]

instance GObject HitTestResult where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_hit_test_result_get_type
    

class GObject o => HitTestResultK o
instance (GObject o, IsDescendantOf HitTestResult o) => HitTestResultK o

toHitTestResult :: HitTestResultK o => o -> IO HitTestResult
toHitTestResult = unsafeCastTo HitTestResult

noHitTestResult :: Maybe HitTestResult
noHitTestResult = Nothing

type family ResolveHitTestResultMethod (t :: Symbol) (o :: *) :: * where
    ResolveHitTestResultMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveHitTestResultMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveHitTestResultMethod "contextIsEditable" o = HitTestResultContextIsEditableMethodInfo
    ResolveHitTestResultMethod "contextIsImage" o = HitTestResultContextIsImageMethodInfo
    ResolveHitTestResultMethod "contextIsLink" o = HitTestResultContextIsLinkMethodInfo
    ResolveHitTestResultMethod "contextIsMedia" o = HitTestResultContextIsMediaMethodInfo
    ResolveHitTestResultMethod "contextIsScrollbar" o = HitTestResultContextIsScrollbarMethodInfo
    ResolveHitTestResultMethod "contextIsSelection" o = HitTestResultContextIsSelectionMethodInfo
    ResolveHitTestResultMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveHitTestResultMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveHitTestResultMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveHitTestResultMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveHitTestResultMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveHitTestResultMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveHitTestResultMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveHitTestResultMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveHitTestResultMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveHitTestResultMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveHitTestResultMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveHitTestResultMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveHitTestResultMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveHitTestResultMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveHitTestResultMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveHitTestResultMethod "getContext" o = HitTestResultGetContextMethodInfo
    ResolveHitTestResultMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveHitTestResultMethod "getImageUri" o = HitTestResultGetImageUriMethodInfo
    ResolveHitTestResultMethod "getLinkLabel" o = HitTestResultGetLinkLabelMethodInfo
    ResolveHitTestResultMethod "getLinkTitle" o = HitTestResultGetLinkTitleMethodInfo
    ResolveHitTestResultMethod "getLinkUri" o = HitTestResultGetLinkUriMethodInfo
    ResolveHitTestResultMethod "getMediaUri" o = HitTestResultGetMediaUriMethodInfo
    ResolveHitTestResultMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveHitTestResultMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveHitTestResultMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveHitTestResultMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveHitTestResultMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveHitTestResultMethod t HitTestResult, MethodInfo info HitTestResult p) => IsLabelProxy t (HitTestResult -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveHitTestResultMethod t HitTestResult, MethodInfo info HitTestResult p) => IsLabel t (HitTestResult -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- VVV Prop "context"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

getHitTestResultContext :: (MonadIO m, HitTestResultK o) => o -> m Word32
getHitTestResultContext obj = liftIO $ getObjectPropertyUInt32 obj "context"

constructHitTestResultContext :: Word32 -> IO ([Char], GValue)
constructHitTestResultContext val = constructObjectPropertyUInt32 "context" val

data HitTestResultContextPropertyInfo
instance AttrInfo HitTestResultContextPropertyInfo where
    type AttrAllowedOps HitTestResultContextPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint HitTestResultContextPropertyInfo = (~) Word32
    type AttrBaseTypeConstraint HitTestResultContextPropertyInfo = HitTestResultK
    type AttrGetType HitTestResultContextPropertyInfo = Word32
    type AttrLabel HitTestResultContextPropertyInfo = "context"
    attrGet _ = getHitTestResultContext
    attrSet _ = undefined
    attrConstruct _ = constructHitTestResultContext
    attrClear _ = undefined

-- VVV Prop "image-uri"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

getHitTestResultImageUri :: (MonadIO m, HitTestResultK o) => o -> m T.Text
getHitTestResultImageUri obj = liftIO $ checkUnexpectedNothing "getHitTestResultImageUri" $ getObjectPropertyString obj "image-uri"

constructHitTestResultImageUri :: T.Text -> IO ([Char], GValue)
constructHitTestResultImageUri val = constructObjectPropertyString "image-uri" (Just val)

data HitTestResultImageUriPropertyInfo
instance AttrInfo HitTestResultImageUriPropertyInfo where
    type AttrAllowedOps HitTestResultImageUriPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint HitTestResultImageUriPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint HitTestResultImageUriPropertyInfo = HitTestResultK
    type AttrGetType HitTestResultImageUriPropertyInfo = T.Text
    type AttrLabel HitTestResultImageUriPropertyInfo = "image-uri"
    attrGet _ = getHitTestResultImageUri
    attrSet _ = undefined
    attrConstruct _ = constructHitTestResultImageUri
    attrClear _ = undefined

-- VVV Prop "link-label"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

getHitTestResultLinkLabel :: (MonadIO m, HitTestResultK o) => o -> m T.Text
getHitTestResultLinkLabel obj = liftIO $ checkUnexpectedNothing "getHitTestResultLinkLabel" $ getObjectPropertyString obj "link-label"

constructHitTestResultLinkLabel :: T.Text -> IO ([Char], GValue)
constructHitTestResultLinkLabel val = constructObjectPropertyString "link-label" (Just val)

data HitTestResultLinkLabelPropertyInfo
instance AttrInfo HitTestResultLinkLabelPropertyInfo where
    type AttrAllowedOps HitTestResultLinkLabelPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint HitTestResultLinkLabelPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint HitTestResultLinkLabelPropertyInfo = HitTestResultK
    type AttrGetType HitTestResultLinkLabelPropertyInfo = T.Text
    type AttrLabel HitTestResultLinkLabelPropertyInfo = "link-label"
    attrGet _ = getHitTestResultLinkLabel
    attrSet _ = undefined
    attrConstruct _ = constructHitTestResultLinkLabel
    attrClear _ = undefined

-- VVV Prop "link-title"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

getHitTestResultLinkTitle :: (MonadIO m, HitTestResultK o) => o -> m T.Text
getHitTestResultLinkTitle obj = liftIO $ checkUnexpectedNothing "getHitTestResultLinkTitle" $ getObjectPropertyString obj "link-title"

constructHitTestResultLinkTitle :: T.Text -> IO ([Char], GValue)
constructHitTestResultLinkTitle val = constructObjectPropertyString "link-title" (Just val)

data HitTestResultLinkTitlePropertyInfo
instance AttrInfo HitTestResultLinkTitlePropertyInfo where
    type AttrAllowedOps HitTestResultLinkTitlePropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint HitTestResultLinkTitlePropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint HitTestResultLinkTitlePropertyInfo = HitTestResultK
    type AttrGetType HitTestResultLinkTitlePropertyInfo = T.Text
    type AttrLabel HitTestResultLinkTitlePropertyInfo = "link-title"
    attrGet _ = getHitTestResultLinkTitle
    attrSet _ = undefined
    attrConstruct _ = constructHitTestResultLinkTitle
    attrClear _ = undefined

-- VVV Prop "link-uri"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

getHitTestResultLinkUri :: (MonadIO m, HitTestResultK o) => o -> m T.Text
getHitTestResultLinkUri obj = liftIO $ checkUnexpectedNothing "getHitTestResultLinkUri" $ getObjectPropertyString obj "link-uri"

constructHitTestResultLinkUri :: T.Text -> IO ([Char], GValue)
constructHitTestResultLinkUri val = constructObjectPropertyString "link-uri" (Just val)

data HitTestResultLinkUriPropertyInfo
instance AttrInfo HitTestResultLinkUriPropertyInfo where
    type AttrAllowedOps HitTestResultLinkUriPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint HitTestResultLinkUriPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint HitTestResultLinkUriPropertyInfo = HitTestResultK
    type AttrGetType HitTestResultLinkUriPropertyInfo = T.Text
    type AttrLabel HitTestResultLinkUriPropertyInfo = "link-uri"
    attrGet _ = getHitTestResultLinkUri
    attrSet _ = undefined
    attrConstruct _ = constructHitTestResultLinkUri
    attrClear _ = undefined

-- VVV Prop "media-uri"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

getHitTestResultMediaUri :: (MonadIO m, HitTestResultK o) => o -> m T.Text
getHitTestResultMediaUri obj = liftIO $ checkUnexpectedNothing "getHitTestResultMediaUri" $ getObjectPropertyString obj "media-uri"

constructHitTestResultMediaUri :: T.Text -> IO ([Char], GValue)
constructHitTestResultMediaUri val = constructObjectPropertyString "media-uri" (Just val)

data HitTestResultMediaUriPropertyInfo
instance AttrInfo HitTestResultMediaUriPropertyInfo where
    type AttrAllowedOps HitTestResultMediaUriPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint HitTestResultMediaUriPropertyInfo = (~) T.Text
    type AttrBaseTypeConstraint HitTestResultMediaUriPropertyInfo = HitTestResultK
    type AttrGetType HitTestResultMediaUriPropertyInfo = T.Text
    type AttrLabel HitTestResultMediaUriPropertyInfo = "media-uri"
    attrGet _ = getHitTestResultMediaUri
    attrSet _ = undefined
    attrConstruct _ = constructHitTestResultMediaUri
    attrClear _ = undefined

type instance AttributeList HitTestResult = HitTestResultAttributeList
type HitTestResultAttributeList = ('[ '("context", HitTestResultContextPropertyInfo), '("imageUri", HitTestResultImageUriPropertyInfo), '("linkLabel", HitTestResultLinkLabelPropertyInfo), '("linkTitle", HitTestResultLinkTitlePropertyInfo), '("linkUri", HitTestResultLinkUriPropertyInfo), '("mediaUri", HitTestResultMediaUriPropertyInfo)] :: [(Symbol, *)])

hitTestResultContext :: AttrLabelProxy "context"
hitTestResultContext = AttrLabelProxy

hitTestResultImageUri :: AttrLabelProxy "imageUri"
hitTestResultImageUri = AttrLabelProxy

hitTestResultLinkLabel :: AttrLabelProxy "linkLabel"
hitTestResultLinkLabel = AttrLabelProxy

hitTestResultLinkTitle :: AttrLabelProxy "linkTitle"
hitTestResultLinkTitle = AttrLabelProxy

hitTestResultLinkUri :: AttrLabelProxy "linkUri"
hitTestResultLinkUri = AttrLabelProxy

hitTestResultMediaUri :: AttrLabelProxy "mediaUri"
hitTestResultMediaUri = AttrLabelProxy

type instance SignalList HitTestResult = HitTestResultSignalList
type HitTestResultSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method HitTestResult::context_is_editable
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "HitTestResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_hit_test_result_context_is_editable" webkit_hit_test_result_context_is_editable :: 
    Ptr HitTestResult ->                    -- _obj : TInterface "WebKit2" "HitTestResult"
    IO CInt


hitTestResultContextIsEditable ::
    (MonadIO m, HitTestResultK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
hitTestResultContextIsEditable _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_hit_test_result_context_is_editable _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data HitTestResultContextIsEditableMethodInfo
instance (signature ~ (m Bool), MonadIO m, HitTestResultK a) => MethodInfo HitTestResultContextIsEditableMethodInfo a signature where
    overloadedMethod _ = hitTestResultContextIsEditable

-- method HitTestResult::context_is_image
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "HitTestResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_hit_test_result_context_is_image" webkit_hit_test_result_context_is_image :: 
    Ptr HitTestResult ->                    -- _obj : TInterface "WebKit2" "HitTestResult"
    IO CInt


hitTestResultContextIsImage ::
    (MonadIO m, HitTestResultK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
hitTestResultContextIsImage _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_hit_test_result_context_is_image _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data HitTestResultContextIsImageMethodInfo
instance (signature ~ (m Bool), MonadIO m, HitTestResultK a) => MethodInfo HitTestResultContextIsImageMethodInfo a signature where
    overloadedMethod _ = hitTestResultContextIsImage

-- method HitTestResult::context_is_link
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "HitTestResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_hit_test_result_context_is_link" webkit_hit_test_result_context_is_link :: 
    Ptr HitTestResult ->                    -- _obj : TInterface "WebKit2" "HitTestResult"
    IO CInt


hitTestResultContextIsLink ::
    (MonadIO m, HitTestResultK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
hitTestResultContextIsLink _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_hit_test_result_context_is_link _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data HitTestResultContextIsLinkMethodInfo
instance (signature ~ (m Bool), MonadIO m, HitTestResultK a) => MethodInfo HitTestResultContextIsLinkMethodInfo a signature where
    overloadedMethod _ = hitTestResultContextIsLink

-- method HitTestResult::context_is_media
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "HitTestResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_hit_test_result_context_is_media" webkit_hit_test_result_context_is_media :: 
    Ptr HitTestResult ->                    -- _obj : TInterface "WebKit2" "HitTestResult"
    IO CInt


hitTestResultContextIsMedia ::
    (MonadIO m, HitTestResultK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
hitTestResultContextIsMedia _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_hit_test_result_context_is_media _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data HitTestResultContextIsMediaMethodInfo
instance (signature ~ (m Bool), MonadIO m, HitTestResultK a) => MethodInfo HitTestResultContextIsMediaMethodInfo a signature where
    overloadedMethod _ = hitTestResultContextIsMedia

-- method HitTestResult::context_is_scrollbar
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "HitTestResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_hit_test_result_context_is_scrollbar" webkit_hit_test_result_context_is_scrollbar :: 
    Ptr HitTestResult ->                    -- _obj : TInterface "WebKit2" "HitTestResult"
    IO CInt


hitTestResultContextIsScrollbar ::
    (MonadIO m, HitTestResultK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
hitTestResultContextIsScrollbar _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_hit_test_result_context_is_scrollbar _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data HitTestResultContextIsScrollbarMethodInfo
instance (signature ~ (m Bool), MonadIO m, HitTestResultK a) => MethodInfo HitTestResultContextIsScrollbarMethodInfo a signature where
    overloadedMethod _ = hitTestResultContextIsScrollbar

-- method HitTestResult::context_is_selection
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "HitTestResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_hit_test_result_context_is_selection" webkit_hit_test_result_context_is_selection :: 
    Ptr HitTestResult ->                    -- _obj : TInterface "WebKit2" "HitTestResult"
    IO CInt


hitTestResultContextIsSelection ::
    (MonadIO m, HitTestResultK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
hitTestResultContextIsSelection _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_hit_test_result_context_is_selection _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data HitTestResultContextIsSelectionMethodInfo
instance (signature ~ (m Bool), MonadIO m, HitTestResultK a) => MethodInfo HitTestResultContextIsSelectionMethodInfo a signature where
    overloadedMethod _ = hitTestResultContextIsSelection

-- method HitTestResult::get_context
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "HitTestResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_hit_test_result_get_context" webkit_hit_test_result_get_context :: 
    Ptr HitTestResult ->                    -- _obj : TInterface "WebKit2" "HitTestResult"
    IO Word32


hitTestResultGetContext ::
    (MonadIO m, HitTestResultK a) =>
    a                                       -- _obj
    -> m Word32                             -- result
hitTestResultGetContext _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_hit_test_result_get_context _obj'
    touchManagedPtr _obj
    return result

data HitTestResultGetContextMethodInfo
instance (signature ~ (m Word32), MonadIO m, HitTestResultK a) => MethodInfo HitTestResultGetContextMethodInfo a signature where
    overloadedMethod _ = hitTestResultGetContext

-- method HitTestResult::get_image_uri
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "HitTestResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_hit_test_result_get_image_uri" webkit_hit_test_result_get_image_uri :: 
    Ptr HitTestResult ->                    -- _obj : TInterface "WebKit2" "HitTestResult"
    IO CString


hitTestResultGetImageUri ::
    (MonadIO m, HitTestResultK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
hitTestResultGetImageUri _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_hit_test_result_get_image_uri _obj'
    checkUnexpectedReturnNULL "webkit_hit_test_result_get_image_uri" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data HitTestResultGetImageUriMethodInfo
instance (signature ~ (m T.Text), MonadIO m, HitTestResultK a) => MethodInfo HitTestResultGetImageUriMethodInfo a signature where
    overloadedMethod _ = hitTestResultGetImageUri

-- method HitTestResult::get_link_label
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "HitTestResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_hit_test_result_get_link_label" webkit_hit_test_result_get_link_label :: 
    Ptr HitTestResult ->                    -- _obj : TInterface "WebKit2" "HitTestResult"
    IO CString


hitTestResultGetLinkLabel ::
    (MonadIO m, HitTestResultK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
hitTestResultGetLinkLabel _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_hit_test_result_get_link_label _obj'
    checkUnexpectedReturnNULL "webkit_hit_test_result_get_link_label" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data HitTestResultGetLinkLabelMethodInfo
instance (signature ~ (m T.Text), MonadIO m, HitTestResultK a) => MethodInfo HitTestResultGetLinkLabelMethodInfo a signature where
    overloadedMethod _ = hitTestResultGetLinkLabel

-- method HitTestResult::get_link_title
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "HitTestResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_hit_test_result_get_link_title" webkit_hit_test_result_get_link_title :: 
    Ptr HitTestResult ->                    -- _obj : TInterface "WebKit2" "HitTestResult"
    IO CString


hitTestResultGetLinkTitle ::
    (MonadIO m, HitTestResultK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
hitTestResultGetLinkTitle _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_hit_test_result_get_link_title _obj'
    checkUnexpectedReturnNULL "webkit_hit_test_result_get_link_title" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data HitTestResultGetLinkTitleMethodInfo
instance (signature ~ (m T.Text), MonadIO m, HitTestResultK a) => MethodInfo HitTestResultGetLinkTitleMethodInfo a signature where
    overloadedMethod _ = hitTestResultGetLinkTitle

-- method HitTestResult::get_link_uri
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "HitTestResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_hit_test_result_get_link_uri" webkit_hit_test_result_get_link_uri :: 
    Ptr HitTestResult ->                    -- _obj : TInterface "WebKit2" "HitTestResult"
    IO CString


hitTestResultGetLinkUri ::
    (MonadIO m, HitTestResultK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
hitTestResultGetLinkUri _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_hit_test_result_get_link_uri _obj'
    checkUnexpectedReturnNULL "webkit_hit_test_result_get_link_uri" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data HitTestResultGetLinkUriMethodInfo
instance (signature ~ (m T.Text), MonadIO m, HitTestResultK a) => MethodInfo HitTestResultGetLinkUriMethodInfo a signature where
    overloadedMethod _ = hitTestResultGetLinkUri

-- method HitTestResult::get_media_uri
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "HitTestResult", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_hit_test_result_get_media_uri" webkit_hit_test_result_get_media_uri :: 
    Ptr HitTestResult ->                    -- _obj : TInterface "WebKit2" "HitTestResult"
    IO CString


hitTestResultGetMediaUri ::
    (MonadIO m, HitTestResultK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
hitTestResultGetMediaUri _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_hit_test_result_get_media_uri _obj'
    checkUnexpectedReturnNULL "webkit_hit_test_result_get_media_uri" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data HitTestResultGetMediaUriMethodInfo
instance (signature ~ (m T.Text), MonadIO m, HitTestResultK a) => MethodInfo HitTestResultGetMediaUriMethodInfo a signature where
    overloadedMethod _ = hitTestResultGetMediaUri


