

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.InstallMissingMediaPluginsPermissionRequest
    ( 

-- * Exported types
    InstallMissingMediaPluginsPermissionRequest(..),
    InstallMissingMediaPluginsPermissionRequestK,
    toInstallMissingMediaPluginsPermissionRequest,
    noInstallMissingMediaPluginsPermissionRequest,


 -- * Methods
-- ** installMissingMediaPluginsPermissionRequestGetDescription
    InstallMissingMediaPluginsPermissionRequestGetDescriptionMethodInfo,
    installMissingMediaPluginsPermissionRequestGetDescription,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject

newtype InstallMissingMediaPluginsPermissionRequest = InstallMissingMediaPluginsPermissionRequest (ForeignPtr InstallMissingMediaPluginsPermissionRequest)
foreign import ccall "webkit_install_missing_media_plugins_permission_request_get_type"
    c_webkit_install_missing_media_plugins_permission_request_get_type :: IO GType

type instance ParentTypes InstallMissingMediaPluginsPermissionRequest = InstallMissingMediaPluginsPermissionRequestParentTypes
type InstallMissingMediaPluginsPermissionRequestParentTypes = '[GObject.Object, PermissionRequest]

instance GObject InstallMissingMediaPluginsPermissionRequest where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_install_missing_media_plugins_permission_request_get_type
    

class GObject o => InstallMissingMediaPluginsPermissionRequestK o
instance (GObject o, IsDescendantOf InstallMissingMediaPluginsPermissionRequest o) => InstallMissingMediaPluginsPermissionRequestK o

toInstallMissingMediaPluginsPermissionRequest :: InstallMissingMediaPluginsPermissionRequestK o => o -> IO InstallMissingMediaPluginsPermissionRequest
toInstallMissingMediaPluginsPermissionRequest = unsafeCastTo InstallMissingMediaPluginsPermissionRequest

noInstallMissingMediaPluginsPermissionRequest :: Maybe InstallMissingMediaPluginsPermissionRequest
noInstallMissingMediaPluginsPermissionRequest = Nothing

type family ResolveInstallMissingMediaPluginsPermissionRequestMethod (t :: Symbol) (o :: *) :: * where
    ResolveInstallMissingMediaPluginsPermissionRequestMethod "allow" o = PermissionRequestAllowMethodInfo
    ResolveInstallMissingMediaPluginsPermissionRequestMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveInstallMissingMediaPluginsPermissionRequestMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveInstallMissingMediaPluginsPermissionRequestMethod "deny" o = PermissionRequestDenyMethodInfo
    ResolveInstallMissingMediaPluginsPermissionRequestMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveInstallMissingMediaPluginsPermissionRequestMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveInstallMissingMediaPluginsPermissionRequestMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveInstallMissingMediaPluginsPermissionRequestMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveInstallMissingMediaPluginsPermissionRequestMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveInstallMissingMediaPluginsPermissionRequestMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveInstallMissingMediaPluginsPermissionRequestMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveInstallMissingMediaPluginsPermissionRequestMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveInstallMissingMediaPluginsPermissionRequestMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveInstallMissingMediaPluginsPermissionRequestMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveInstallMissingMediaPluginsPermissionRequestMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveInstallMissingMediaPluginsPermissionRequestMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveInstallMissingMediaPluginsPermissionRequestMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveInstallMissingMediaPluginsPermissionRequestMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveInstallMissingMediaPluginsPermissionRequestMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveInstallMissingMediaPluginsPermissionRequestMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveInstallMissingMediaPluginsPermissionRequestMethod "getDescription" o = InstallMissingMediaPluginsPermissionRequestGetDescriptionMethodInfo
    ResolveInstallMissingMediaPluginsPermissionRequestMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveInstallMissingMediaPluginsPermissionRequestMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveInstallMissingMediaPluginsPermissionRequestMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveInstallMissingMediaPluginsPermissionRequestMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveInstallMissingMediaPluginsPermissionRequestMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveInstallMissingMediaPluginsPermissionRequestMethod t InstallMissingMediaPluginsPermissionRequest, MethodInfo info InstallMissingMediaPluginsPermissionRequest p) => IsLabelProxy t (InstallMissingMediaPluginsPermissionRequest -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveInstallMissingMediaPluginsPermissionRequestMethod t InstallMissingMediaPluginsPermissionRequest, MethodInfo info InstallMissingMediaPluginsPermissionRequest p) => IsLabel t (InstallMissingMediaPluginsPermissionRequest -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

type instance AttributeList InstallMissingMediaPluginsPermissionRequest = InstallMissingMediaPluginsPermissionRequestAttributeList
type InstallMissingMediaPluginsPermissionRequestAttributeList = ('[ ] :: [(Symbol, *)])

type instance SignalList InstallMissingMediaPluginsPermissionRequest = InstallMissingMediaPluginsPermissionRequestSignalList
type InstallMissingMediaPluginsPermissionRequestSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method InstallMissingMediaPluginsPermissionRequest::get_description
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "InstallMissingMediaPluginsPermissionRequest", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_install_missing_media_plugins_permission_request_get_description" webkit_install_missing_media_plugins_permission_request_get_description :: 
    Ptr InstallMissingMediaPluginsPermissionRequest -> -- _obj : TInterface "WebKit2" "InstallMissingMediaPluginsPermissionRequest"
    IO CString


installMissingMediaPluginsPermissionRequestGetDescription ::
    (MonadIO m, InstallMissingMediaPluginsPermissionRequestK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
installMissingMediaPluginsPermissionRequestGetDescription _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_install_missing_media_plugins_permission_request_get_description _obj'
    checkUnexpectedReturnNULL "webkit_install_missing_media_plugins_permission_request_get_description" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data InstallMissingMediaPluginsPermissionRequestGetDescriptionMethodInfo
instance (signature ~ (m T.Text), MonadIO m, InstallMissingMediaPluginsPermissionRequestK a) => MethodInfo InstallMissingMediaPluginsPermissionRequestGetDescriptionMethodInfo a signature where
    overloadedMethod _ = installMissingMediaPluginsPermissionRequestGetDescription


