

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.NavigationPolicyDecision
    ( 

-- * Exported types
    NavigationPolicyDecision(..)            ,
    NavigationPolicyDecisionK               ,
    toNavigationPolicyDecision              ,
    noNavigationPolicyDecision              ,


 -- * Methods
-- ** navigationPolicyDecisionGetFrameName
    NavigationPolicyDecisionGetFrameNameMethodInfo,
    navigationPolicyDecisionGetFrameName    ,


-- ** navigationPolicyDecisionGetModifiers
    NavigationPolicyDecisionGetModifiersMethodInfo,
    navigationPolicyDecisionGetModifiers    ,


-- ** navigationPolicyDecisionGetMouseButton
    NavigationPolicyDecisionGetMouseButtonMethodInfo,
    navigationPolicyDecisionGetMouseButton  ,


-- ** navigationPolicyDecisionGetNavigationAction
    NavigationPolicyDecisionGetNavigationActionMethodInfo,
    navigationPolicyDecisionGetNavigationAction,


-- ** navigationPolicyDecisionGetNavigationType
    NavigationPolicyDecisionGetNavigationTypeMethodInfo,
    navigationPolicyDecisionGetNavigationType,


-- ** navigationPolicyDecisionGetRequest
    NavigationPolicyDecisionGetRequestMethodInfo,
    navigationPolicyDecisionGetRequest      ,




 -- * Properties
-- ** FrameName
    NavigationPolicyDecisionFrameNamePropertyInfo,
    getNavigationPolicyDecisionFrameName    ,
    navigationPolicyDecisionFrameName       ,


-- ** Modifiers
    NavigationPolicyDecisionModifiersPropertyInfo,
    getNavigationPolicyDecisionModifiers    ,
    navigationPolicyDecisionModifiers       ,


-- ** MouseButton
    NavigationPolicyDecisionMouseButtonPropertyInfo,
    getNavigationPolicyDecisionMouseButton  ,
    navigationPolicyDecisionMouseButton     ,


-- ** NavigationAction
    NavigationPolicyDecisionNavigationActionPropertyInfo,
    getNavigationPolicyDecisionNavigationAction,
    navigationPolicyDecisionNavigationAction,


-- ** NavigationType
    NavigationPolicyDecisionNavigationTypePropertyInfo,
    getNavigationPolicyDecisionNavigationType,
    navigationPolicyDecisionNavigationType  ,


-- ** Request
    NavigationPolicyDecisionRequestPropertyInfo,
    getNavigationPolicyDecisionRequest      ,
    navigationPolicyDecisionRequest         ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject

newtype NavigationPolicyDecision = NavigationPolicyDecision (ForeignPtr NavigationPolicyDecision)
foreign import ccall "webkit_navigation_policy_decision_get_type"
    c_webkit_navigation_policy_decision_get_type :: IO GType

type instance ParentTypes NavigationPolicyDecision = NavigationPolicyDecisionParentTypes
type NavigationPolicyDecisionParentTypes = '[PolicyDecision, GObject.Object]

instance GObject NavigationPolicyDecision where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_navigation_policy_decision_get_type
    

class GObject o => NavigationPolicyDecisionK o
instance (GObject o, IsDescendantOf NavigationPolicyDecision o) => NavigationPolicyDecisionK o

toNavigationPolicyDecision :: NavigationPolicyDecisionK o => o -> IO NavigationPolicyDecision
toNavigationPolicyDecision = unsafeCastTo NavigationPolicyDecision

noNavigationPolicyDecision :: Maybe NavigationPolicyDecision
noNavigationPolicyDecision = Nothing

type family ResolveNavigationPolicyDecisionMethod (t :: Symbol) (o :: *) :: * where
    ResolveNavigationPolicyDecisionMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveNavigationPolicyDecisionMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveNavigationPolicyDecisionMethod "download" o = PolicyDecisionDownloadMethodInfo
    ResolveNavigationPolicyDecisionMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveNavigationPolicyDecisionMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveNavigationPolicyDecisionMethod "ignore" o = PolicyDecisionIgnoreMethodInfo
    ResolveNavigationPolicyDecisionMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveNavigationPolicyDecisionMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveNavigationPolicyDecisionMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveNavigationPolicyDecisionMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveNavigationPolicyDecisionMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveNavigationPolicyDecisionMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveNavigationPolicyDecisionMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveNavigationPolicyDecisionMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveNavigationPolicyDecisionMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveNavigationPolicyDecisionMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveNavigationPolicyDecisionMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveNavigationPolicyDecisionMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveNavigationPolicyDecisionMethod "use" o = PolicyDecisionUseMethodInfo
    ResolveNavigationPolicyDecisionMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveNavigationPolicyDecisionMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveNavigationPolicyDecisionMethod "getFrameName" o = NavigationPolicyDecisionGetFrameNameMethodInfo
    ResolveNavigationPolicyDecisionMethod "getModifiers" o = NavigationPolicyDecisionGetModifiersMethodInfo
    ResolveNavigationPolicyDecisionMethod "getMouseButton" o = NavigationPolicyDecisionGetMouseButtonMethodInfo
    ResolveNavigationPolicyDecisionMethod "getNavigationAction" o = NavigationPolicyDecisionGetNavigationActionMethodInfo
    ResolveNavigationPolicyDecisionMethod "getNavigationType" o = NavigationPolicyDecisionGetNavigationTypeMethodInfo
    ResolveNavigationPolicyDecisionMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveNavigationPolicyDecisionMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveNavigationPolicyDecisionMethod "getRequest" o = NavigationPolicyDecisionGetRequestMethodInfo
    ResolveNavigationPolicyDecisionMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveNavigationPolicyDecisionMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveNavigationPolicyDecisionMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveNavigationPolicyDecisionMethod t NavigationPolicyDecision, MethodInfo info NavigationPolicyDecision p) => IsLabelProxy t (NavigationPolicyDecision -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveNavigationPolicyDecisionMethod t NavigationPolicyDecision, MethodInfo info NavigationPolicyDecision p) => IsLabel t (NavigationPolicyDecision -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- VVV Prop "frame-name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getNavigationPolicyDecisionFrameName :: (MonadIO m, NavigationPolicyDecisionK o) => o -> m T.Text
getNavigationPolicyDecisionFrameName obj = liftIO $ checkUnexpectedNothing "getNavigationPolicyDecisionFrameName" $ getObjectPropertyString obj "frame-name"

data NavigationPolicyDecisionFrameNamePropertyInfo
instance AttrInfo NavigationPolicyDecisionFrameNamePropertyInfo where
    type AttrAllowedOps NavigationPolicyDecisionFrameNamePropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint NavigationPolicyDecisionFrameNamePropertyInfo = (~) ()
    type AttrBaseTypeConstraint NavigationPolicyDecisionFrameNamePropertyInfo = NavigationPolicyDecisionK
    type AttrGetType NavigationPolicyDecisionFrameNamePropertyInfo = T.Text
    type AttrLabel NavigationPolicyDecisionFrameNamePropertyInfo = "frame-name"
    attrGet _ = getNavigationPolicyDecisionFrameName
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "modifiers"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getNavigationPolicyDecisionModifiers :: (MonadIO m, NavigationPolicyDecisionK o) => o -> m Word32
getNavigationPolicyDecisionModifiers obj = liftIO $ getObjectPropertyUInt32 obj "modifiers"

data NavigationPolicyDecisionModifiersPropertyInfo
instance AttrInfo NavigationPolicyDecisionModifiersPropertyInfo where
    type AttrAllowedOps NavigationPolicyDecisionModifiersPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint NavigationPolicyDecisionModifiersPropertyInfo = (~) ()
    type AttrBaseTypeConstraint NavigationPolicyDecisionModifiersPropertyInfo = NavigationPolicyDecisionK
    type AttrGetType NavigationPolicyDecisionModifiersPropertyInfo = Word32
    type AttrLabel NavigationPolicyDecisionModifiersPropertyInfo = "modifiers"
    attrGet _ = getNavigationPolicyDecisionModifiers
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "mouse-button"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getNavigationPolicyDecisionMouseButton :: (MonadIO m, NavigationPolicyDecisionK o) => o -> m Word32
getNavigationPolicyDecisionMouseButton obj = liftIO $ getObjectPropertyUInt32 obj "mouse-button"

data NavigationPolicyDecisionMouseButtonPropertyInfo
instance AttrInfo NavigationPolicyDecisionMouseButtonPropertyInfo where
    type AttrAllowedOps NavigationPolicyDecisionMouseButtonPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint NavigationPolicyDecisionMouseButtonPropertyInfo = (~) ()
    type AttrBaseTypeConstraint NavigationPolicyDecisionMouseButtonPropertyInfo = NavigationPolicyDecisionK
    type AttrGetType NavigationPolicyDecisionMouseButtonPropertyInfo = Word32
    type AttrLabel NavigationPolicyDecisionMouseButtonPropertyInfo = "mouse-button"
    attrGet _ = getNavigationPolicyDecisionMouseButton
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "navigation-action"
   -- Type: TInterface "WebKit2" "NavigationAction"
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getNavigationPolicyDecisionNavigationAction :: (MonadIO m, NavigationPolicyDecisionK o) => o -> m NavigationAction
getNavigationPolicyDecisionNavigationAction obj = liftIO $ checkUnexpectedNothing "getNavigationPolicyDecisionNavigationAction" $ getObjectPropertyBoxed obj "navigation-action" NavigationAction

data NavigationPolicyDecisionNavigationActionPropertyInfo
instance AttrInfo NavigationPolicyDecisionNavigationActionPropertyInfo where
    type AttrAllowedOps NavigationPolicyDecisionNavigationActionPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint NavigationPolicyDecisionNavigationActionPropertyInfo = (~) ()
    type AttrBaseTypeConstraint NavigationPolicyDecisionNavigationActionPropertyInfo = NavigationPolicyDecisionK
    type AttrGetType NavigationPolicyDecisionNavigationActionPropertyInfo = NavigationAction
    type AttrLabel NavigationPolicyDecisionNavigationActionPropertyInfo = "navigation-action"
    attrGet _ = getNavigationPolicyDecisionNavigationAction
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "navigation-type"
   -- Type: TInterface "WebKit2" "NavigationType"
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getNavigationPolicyDecisionNavigationType :: (MonadIO m, NavigationPolicyDecisionK o) => o -> m NavigationType
getNavigationPolicyDecisionNavigationType obj = liftIO $ getObjectPropertyEnum obj "navigation-type"

data NavigationPolicyDecisionNavigationTypePropertyInfo
instance AttrInfo NavigationPolicyDecisionNavigationTypePropertyInfo where
    type AttrAllowedOps NavigationPolicyDecisionNavigationTypePropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint NavigationPolicyDecisionNavigationTypePropertyInfo = (~) ()
    type AttrBaseTypeConstraint NavigationPolicyDecisionNavigationTypePropertyInfo = NavigationPolicyDecisionK
    type AttrGetType NavigationPolicyDecisionNavigationTypePropertyInfo = NavigationType
    type AttrLabel NavigationPolicyDecisionNavigationTypePropertyInfo = "navigation-type"
    attrGet _ = getNavigationPolicyDecisionNavigationType
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "request"
   -- Type: TInterface "WebKit2" "URIRequest"
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getNavigationPolicyDecisionRequest :: (MonadIO m, NavigationPolicyDecisionK o) => o -> m URIRequest
getNavigationPolicyDecisionRequest obj = liftIO $ checkUnexpectedNothing "getNavigationPolicyDecisionRequest" $ getObjectPropertyObject obj "request" URIRequest

data NavigationPolicyDecisionRequestPropertyInfo
instance AttrInfo NavigationPolicyDecisionRequestPropertyInfo where
    type AttrAllowedOps NavigationPolicyDecisionRequestPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint NavigationPolicyDecisionRequestPropertyInfo = (~) ()
    type AttrBaseTypeConstraint NavigationPolicyDecisionRequestPropertyInfo = NavigationPolicyDecisionK
    type AttrGetType NavigationPolicyDecisionRequestPropertyInfo = URIRequest
    type AttrLabel NavigationPolicyDecisionRequestPropertyInfo = "request"
    attrGet _ = getNavigationPolicyDecisionRequest
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

type instance AttributeList NavigationPolicyDecision = NavigationPolicyDecisionAttributeList
type NavigationPolicyDecisionAttributeList = ('[ '("frameName", NavigationPolicyDecisionFrameNamePropertyInfo), '("modifiers", NavigationPolicyDecisionModifiersPropertyInfo), '("mouseButton", NavigationPolicyDecisionMouseButtonPropertyInfo), '("navigationAction", NavigationPolicyDecisionNavigationActionPropertyInfo), '("navigationType", NavigationPolicyDecisionNavigationTypePropertyInfo), '("request", NavigationPolicyDecisionRequestPropertyInfo)] :: [(Symbol, *)])

navigationPolicyDecisionFrameName :: AttrLabelProxy "frameName"
navigationPolicyDecisionFrameName = AttrLabelProxy

navigationPolicyDecisionModifiers :: AttrLabelProxy "modifiers"
navigationPolicyDecisionModifiers = AttrLabelProxy

navigationPolicyDecisionMouseButton :: AttrLabelProxy "mouseButton"
navigationPolicyDecisionMouseButton = AttrLabelProxy

navigationPolicyDecisionNavigationAction :: AttrLabelProxy "navigationAction"
navigationPolicyDecisionNavigationAction = AttrLabelProxy

navigationPolicyDecisionNavigationType :: AttrLabelProxy "navigationType"
navigationPolicyDecisionNavigationType = AttrLabelProxy

navigationPolicyDecisionRequest :: AttrLabelProxy "request"
navigationPolicyDecisionRequest = AttrLabelProxy

type instance SignalList NavigationPolicyDecision = NavigationPolicyDecisionSignalList
type NavigationPolicyDecisionSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method NavigationPolicyDecision::get_frame_name
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "NavigationPolicyDecision", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_navigation_policy_decision_get_frame_name" webkit_navigation_policy_decision_get_frame_name :: 
    Ptr NavigationPolicyDecision ->         -- _obj : TInterface "WebKit2" "NavigationPolicyDecision"
    IO CString


navigationPolicyDecisionGetFrameName ::
    (MonadIO m, NavigationPolicyDecisionK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
navigationPolicyDecisionGetFrameName _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_navigation_policy_decision_get_frame_name _obj'
    checkUnexpectedReturnNULL "webkit_navigation_policy_decision_get_frame_name" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data NavigationPolicyDecisionGetFrameNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m, NavigationPolicyDecisionK a) => MethodInfo NavigationPolicyDecisionGetFrameNameMethodInfo a signature where
    overloadedMethod _ = navigationPolicyDecisionGetFrameName

-- method NavigationPolicyDecision::get_modifiers
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "NavigationPolicyDecision", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_navigation_policy_decision_get_modifiers" webkit_navigation_policy_decision_get_modifiers :: 
    Ptr NavigationPolicyDecision ->         -- _obj : TInterface "WebKit2" "NavigationPolicyDecision"
    IO Word32

{-# DEPRECATED navigationPolicyDecisionGetModifiers ["(Since version 2.6)","Use webkit_navigation_policy_decision_get_navigation_action() instead."]#-}
navigationPolicyDecisionGetModifiers ::
    (MonadIO m, NavigationPolicyDecisionK a) =>
    a                                       -- _obj
    -> m Word32                             -- result
navigationPolicyDecisionGetModifiers _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_navigation_policy_decision_get_modifiers _obj'
    touchManagedPtr _obj
    return result

data NavigationPolicyDecisionGetModifiersMethodInfo
instance (signature ~ (m Word32), MonadIO m, NavigationPolicyDecisionK a) => MethodInfo NavigationPolicyDecisionGetModifiersMethodInfo a signature where
    overloadedMethod _ = navigationPolicyDecisionGetModifiers

-- method NavigationPolicyDecision::get_mouse_button
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "NavigationPolicyDecision", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_navigation_policy_decision_get_mouse_button" webkit_navigation_policy_decision_get_mouse_button :: 
    Ptr NavigationPolicyDecision ->         -- _obj : TInterface "WebKit2" "NavigationPolicyDecision"
    IO Word32

{-# DEPRECATED navigationPolicyDecisionGetMouseButton ["(Since version 2.6)","Use webkit_navigation_policy_decision_get_navigation_action() instead."]#-}
navigationPolicyDecisionGetMouseButton ::
    (MonadIO m, NavigationPolicyDecisionK a) =>
    a                                       -- _obj
    -> m Word32                             -- result
navigationPolicyDecisionGetMouseButton _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_navigation_policy_decision_get_mouse_button _obj'
    touchManagedPtr _obj
    return result

data NavigationPolicyDecisionGetMouseButtonMethodInfo
instance (signature ~ (m Word32), MonadIO m, NavigationPolicyDecisionK a) => MethodInfo NavigationPolicyDecisionGetMouseButtonMethodInfo a signature where
    overloadedMethod _ = navigationPolicyDecisionGetMouseButton

-- method NavigationPolicyDecision::get_navigation_action
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "NavigationPolicyDecision", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "NavigationAction")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_navigation_policy_decision_get_navigation_action" webkit_navigation_policy_decision_get_navigation_action :: 
    Ptr NavigationPolicyDecision ->         -- _obj : TInterface "WebKit2" "NavigationPolicyDecision"
    IO (Ptr NavigationAction)


navigationPolicyDecisionGetNavigationAction ::
    (MonadIO m, NavigationPolicyDecisionK a) =>
    a                                       -- _obj
    -> m NavigationAction                   -- result
navigationPolicyDecisionGetNavigationAction _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_navigation_policy_decision_get_navigation_action _obj'
    checkUnexpectedReturnNULL "webkit_navigation_policy_decision_get_navigation_action" result
    result' <- (newBoxed NavigationAction) result
    touchManagedPtr _obj
    return result'

data NavigationPolicyDecisionGetNavigationActionMethodInfo
instance (signature ~ (m NavigationAction), MonadIO m, NavigationPolicyDecisionK a) => MethodInfo NavigationPolicyDecisionGetNavigationActionMethodInfo a signature where
    overloadedMethod _ = navigationPolicyDecisionGetNavigationAction

-- method NavigationPolicyDecision::get_navigation_type
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "NavigationPolicyDecision", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "NavigationType")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_navigation_policy_decision_get_navigation_type" webkit_navigation_policy_decision_get_navigation_type :: 
    Ptr NavigationPolicyDecision ->         -- _obj : TInterface "WebKit2" "NavigationPolicyDecision"
    IO CUInt

{-# DEPRECATED navigationPolicyDecisionGetNavigationType ["(Since version 2.6)","Use webkit_navigation_policy_decision_get_navigation_action() instead."]#-}
navigationPolicyDecisionGetNavigationType ::
    (MonadIO m, NavigationPolicyDecisionK a) =>
    a                                       -- _obj
    -> m NavigationType                     -- result
navigationPolicyDecisionGetNavigationType _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_navigation_policy_decision_get_navigation_type _obj'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr _obj
    return result'

data NavigationPolicyDecisionGetNavigationTypeMethodInfo
instance (signature ~ (m NavigationType), MonadIO m, NavigationPolicyDecisionK a) => MethodInfo NavigationPolicyDecisionGetNavigationTypeMethodInfo a signature where
    overloadedMethod _ = navigationPolicyDecisionGetNavigationType

-- method NavigationPolicyDecision::get_request
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "NavigationPolicyDecision", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "URIRequest")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_navigation_policy_decision_get_request" webkit_navigation_policy_decision_get_request :: 
    Ptr NavigationPolicyDecision ->         -- _obj : TInterface "WebKit2" "NavigationPolicyDecision"
    IO (Ptr URIRequest)

{-# DEPRECATED navigationPolicyDecisionGetRequest ["(Since version 2.6)","Use webkit_navigation_policy_decision_get_navigation_action() instead."]#-}
navigationPolicyDecisionGetRequest ::
    (MonadIO m, NavigationPolicyDecisionK a) =>
    a                                       -- _obj
    -> m URIRequest                         -- result
navigationPolicyDecisionGetRequest _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_navigation_policy_decision_get_request _obj'
    checkUnexpectedReturnNULL "webkit_navigation_policy_decision_get_request" result
    result' <- (newObject URIRequest) result
    touchManagedPtr _obj
    return result'

data NavigationPolicyDecisionGetRequestMethodInfo
instance (signature ~ (m URIRequest), MonadIO m, NavigationPolicyDecisionK a) => MethodInfo NavigationPolicyDecisionGetRequestMethodInfo a signature where
    overloadedMethod _ = navigationPolicyDecisionGetRequest


