

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.Notification
    ( 

-- * Exported types
    Notification(..)                        ,
    NotificationK                           ,
    toNotification                          ,
    noNotification                          ,


 -- * Methods
-- ** notificationClicked
    NotificationClickedMethodInfo           ,
    notificationClicked                     ,


-- ** notificationClose
    NotificationCloseMethodInfo             ,
    notificationClose                       ,


-- ** notificationGetBody
    NotificationGetBodyMethodInfo           ,
    notificationGetBody                     ,


-- ** notificationGetId
    NotificationGetIdMethodInfo             ,
    notificationGetId                       ,


-- ** notificationGetTitle
    NotificationGetTitleMethodInfo          ,
    notificationGetTitle                    ,




 -- * Properties
-- ** Body
    NotificationBodyPropertyInfo            ,
    getNotificationBody                     ,
    notificationBody                        ,


-- ** Id
    NotificationIdPropertyInfo              ,
    getNotificationId                       ,
    notificationId                          ,


-- ** Title
    NotificationTitlePropertyInfo           ,
    getNotificationTitle                    ,
    notificationTitle                       ,




 -- * Signals
-- ** Clicked
    NotificationClickedCallback             ,
    NotificationClickedCallbackC            ,
    NotificationClickedSignalInfo           ,
    afterNotificationClicked                ,
    mkNotificationClickedCallback           ,
    noNotificationClickedCallback           ,
    notificationClickedCallbackWrapper      ,
    notificationClickedClosure              ,
    onNotificationClicked                   ,


-- ** Closed
    NotificationClosedCallback              ,
    NotificationClosedCallbackC             ,
    NotificationClosedSignalInfo            ,
    afterNotificationClosed                 ,
    mkNotificationClosedCallback            ,
    noNotificationClosedCallback            ,
    notificationClosedCallbackWrapper       ,
    notificationClosedClosure               ,
    onNotificationClosed                    ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject

newtype Notification = Notification (ForeignPtr Notification)
foreign import ccall "webkit_notification_get_type"
    c_webkit_notification_get_type :: IO GType

type instance ParentTypes Notification = NotificationParentTypes
type NotificationParentTypes = '[GObject.Object]

instance GObject Notification where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_notification_get_type
    

class GObject o => NotificationK o
instance (GObject o, IsDescendantOf Notification o) => NotificationK o

toNotification :: NotificationK o => o -> IO Notification
toNotification = unsafeCastTo Notification

noNotification :: Maybe Notification
noNotification = Nothing

type family ResolveNotificationMethod (t :: Symbol) (o :: *) :: * where
    ResolveNotificationMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveNotificationMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveNotificationMethod "clicked" o = NotificationClickedMethodInfo
    ResolveNotificationMethod "close" o = NotificationCloseMethodInfo
    ResolveNotificationMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveNotificationMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveNotificationMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveNotificationMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveNotificationMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveNotificationMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveNotificationMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveNotificationMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveNotificationMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveNotificationMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveNotificationMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveNotificationMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveNotificationMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveNotificationMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveNotificationMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveNotificationMethod "getBody" o = NotificationGetBodyMethodInfo
    ResolveNotificationMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveNotificationMethod "getId" o = NotificationGetIdMethodInfo
    ResolveNotificationMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveNotificationMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveNotificationMethod "getTitle" o = NotificationGetTitleMethodInfo
    ResolveNotificationMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveNotificationMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveNotificationMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveNotificationMethod t Notification, MethodInfo info Notification p) => IsLabelProxy t (Notification -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveNotificationMethod t Notification, MethodInfo info Notification p) => IsLabel t (Notification -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- signal Notification::clicked
type NotificationClickedCallback =
    IO ()

noNotificationClickedCallback :: Maybe NotificationClickedCallback
noNotificationClickedCallback = Nothing

type NotificationClickedCallbackC =
    Ptr () ->                               -- object
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkNotificationClickedCallback :: NotificationClickedCallbackC -> IO (FunPtr NotificationClickedCallbackC)

notificationClickedClosure :: NotificationClickedCallback -> IO Closure
notificationClickedClosure cb = newCClosure =<< mkNotificationClickedCallback wrapped
    where wrapped = notificationClickedCallbackWrapper cb

notificationClickedCallbackWrapper ::
    NotificationClickedCallback ->
    Ptr () ->
    Ptr () ->
    IO ()
notificationClickedCallbackWrapper _cb _ _ = do
    _cb 

onNotificationClicked :: (GObject a, MonadIO m) => a -> NotificationClickedCallback -> m SignalHandlerId
onNotificationClicked obj cb = liftIO $ connectNotificationClicked obj cb SignalConnectBefore
afterNotificationClicked :: (GObject a, MonadIO m) => a -> NotificationClickedCallback -> m SignalHandlerId
afterNotificationClicked obj cb = connectNotificationClicked obj cb SignalConnectAfter

connectNotificationClicked :: (GObject a, MonadIO m) =>
                              a -> NotificationClickedCallback -> SignalConnectMode -> m SignalHandlerId
connectNotificationClicked obj cb after = liftIO $ do
    cb' <- mkNotificationClickedCallback (notificationClickedCallbackWrapper cb)
    connectSignalFunPtr obj "clicked" cb' after

-- signal Notification::closed
type NotificationClosedCallback =
    IO ()

noNotificationClosedCallback :: Maybe NotificationClosedCallback
noNotificationClosedCallback = Nothing

type NotificationClosedCallbackC =
    Ptr () ->                               -- object
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkNotificationClosedCallback :: NotificationClosedCallbackC -> IO (FunPtr NotificationClosedCallbackC)

notificationClosedClosure :: NotificationClosedCallback -> IO Closure
notificationClosedClosure cb = newCClosure =<< mkNotificationClosedCallback wrapped
    where wrapped = notificationClosedCallbackWrapper cb

notificationClosedCallbackWrapper ::
    NotificationClosedCallback ->
    Ptr () ->
    Ptr () ->
    IO ()
notificationClosedCallbackWrapper _cb _ _ = do
    _cb 

onNotificationClosed :: (GObject a, MonadIO m) => a -> NotificationClosedCallback -> m SignalHandlerId
onNotificationClosed obj cb = liftIO $ connectNotificationClosed obj cb SignalConnectBefore
afterNotificationClosed :: (GObject a, MonadIO m) => a -> NotificationClosedCallback -> m SignalHandlerId
afterNotificationClosed obj cb = connectNotificationClosed obj cb SignalConnectAfter

connectNotificationClosed :: (GObject a, MonadIO m) =>
                             a -> NotificationClosedCallback -> SignalConnectMode -> m SignalHandlerId
connectNotificationClosed obj cb after = liftIO $ do
    cb' <- mkNotificationClosedCallback (notificationClosedCallbackWrapper cb)
    connectSignalFunPtr obj "closed" cb' after

-- VVV Prop "body"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getNotificationBody :: (MonadIO m, NotificationK o) => o -> m T.Text
getNotificationBody obj = liftIO $ checkUnexpectedNothing "getNotificationBody" $ getObjectPropertyString obj "body"

data NotificationBodyPropertyInfo
instance AttrInfo NotificationBodyPropertyInfo where
    type AttrAllowedOps NotificationBodyPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint NotificationBodyPropertyInfo = (~) ()
    type AttrBaseTypeConstraint NotificationBodyPropertyInfo = NotificationK
    type AttrGetType NotificationBodyPropertyInfo = T.Text
    type AttrLabel NotificationBodyPropertyInfo = "body"
    attrGet _ = getNotificationBody
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "id"
   -- Type: TBasicType TUInt64
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getNotificationId :: (MonadIO m, NotificationK o) => o -> m Word64
getNotificationId obj = liftIO $ getObjectPropertyUInt64 obj "id"

data NotificationIdPropertyInfo
instance AttrInfo NotificationIdPropertyInfo where
    type AttrAllowedOps NotificationIdPropertyInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint NotificationIdPropertyInfo = (~) ()
    type AttrBaseTypeConstraint NotificationIdPropertyInfo = NotificationK
    type AttrGetType NotificationIdPropertyInfo = Word64
    type AttrLabel NotificationIdPropertyInfo = "id"
    attrGet _ = getNotificationId
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "title"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getNotificationTitle :: (MonadIO m, NotificationK o) => o -> m T.Text
getNotificationTitle obj = liftIO $ checkUnexpectedNothing "getNotificationTitle" $ getObjectPropertyString obj "title"

data NotificationTitlePropertyInfo
instance AttrInfo NotificationTitlePropertyInfo where
    type AttrAllowedOps NotificationTitlePropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint NotificationTitlePropertyInfo = (~) ()
    type AttrBaseTypeConstraint NotificationTitlePropertyInfo = NotificationK
    type AttrGetType NotificationTitlePropertyInfo = T.Text
    type AttrLabel NotificationTitlePropertyInfo = "title"
    attrGet _ = getNotificationTitle
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

type instance AttributeList Notification = NotificationAttributeList
type NotificationAttributeList = ('[ '("body", NotificationBodyPropertyInfo), '("id", NotificationIdPropertyInfo), '("title", NotificationTitlePropertyInfo)] :: [(Symbol, *)])

notificationBody :: AttrLabelProxy "body"
notificationBody = AttrLabelProxy

notificationId :: AttrLabelProxy "id"
notificationId = AttrLabelProxy

notificationTitle :: AttrLabelProxy "title"
notificationTitle = AttrLabelProxy

data NotificationClickedSignalInfo
instance SignalInfo NotificationClickedSignalInfo where
    type HaskellCallbackType NotificationClickedSignalInfo = NotificationClickedCallback
    connectSignal _ = connectNotificationClicked

data NotificationClosedSignalInfo
instance SignalInfo NotificationClosedSignalInfo where
    type HaskellCallbackType NotificationClosedSignalInfo = NotificationClosedCallback
    connectSignal _ = connectNotificationClosed

type instance SignalList Notification = NotificationSignalList
type NotificationSignalList = ('[ '("clicked", NotificationClickedSignalInfo), '("closed", NotificationClosedSignalInfo), '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method Notification::clicked
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Notification", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_notification_clicked" webkit_notification_clicked :: 
    Ptr Notification ->                     -- _obj : TInterface "WebKit2" "Notification"
    IO ()


notificationClicked ::
    (MonadIO m, NotificationK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
notificationClicked _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_notification_clicked _obj'
    touchManagedPtr _obj
    return ()

data NotificationClickedMethodInfo
instance (signature ~ (m ()), MonadIO m, NotificationK a) => MethodInfo NotificationClickedMethodInfo a signature where
    overloadedMethod _ = notificationClicked

-- method Notification::close
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Notification", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_notification_close" webkit_notification_close :: 
    Ptr Notification ->                     -- _obj : TInterface "WebKit2" "Notification"
    IO ()


notificationClose ::
    (MonadIO m, NotificationK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
notificationClose _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_notification_close _obj'
    touchManagedPtr _obj
    return ()

data NotificationCloseMethodInfo
instance (signature ~ (m ()), MonadIO m, NotificationK a) => MethodInfo NotificationCloseMethodInfo a signature where
    overloadedMethod _ = notificationClose

-- method Notification::get_body
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Notification", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_notification_get_body" webkit_notification_get_body :: 
    Ptr Notification ->                     -- _obj : TInterface "WebKit2" "Notification"
    IO CString


notificationGetBody ::
    (MonadIO m, NotificationK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
notificationGetBody _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_notification_get_body _obj'
    checkUnexpectedReturnNULL "webkit_notification_get_body" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data NotificationGetBodyMethodInfo
instance (signature ~ (m T.Text), MonadIO m, NotificationK a) => MethodInfo NotificationGetBodyMethodInfo a signature where
    overloadedMethod _ = notificationGetBody

-- method Notification::get_id
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Notification", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUInt64)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_notification_get_id" webkit_notification_get_id :: 
    Ptr Notification ->                     -- _obj : TInterface "WebKit2" "Notification"
    IO Word64


notificationGetId ::
    (MonadIO m, NotificationK a) =>
    a                                       -- _obj
    -> m Word64                             -- result
notificationGetId _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_notification_get_id _obj'
    touchManagedPtr _obj
    return result

data NotificationGetIdMethodInfo
instance (signature ~ (m Word64), MonadIO m, NotificationK a) => MethodInfo NotificationGetIdMethodInfo a signature where
    overloadedMethod _ = notificationGetId

-- method Notification::get_title
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Notification", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_notification_get_title" webkit_notification_get_title :: 
    Ptr Notification ->                     -- _obj : TInterface "WebKit2" "Notification"
    IO CString


notificationGetTitle ::
    (MonadIO m, NotificationK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
notificationGetTitle _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_notification_get_title _obj'
    checkUnexpectedReturnNULL "webkit_notification_get_title" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data NotificationGetTitleMethodInfo
instance (signature ~ (m T.Text), MonadIO m, NotificationK a) => MethodInfo NotificationGetTitleMethodInfo a signature where
    overloadedMethod _ = notificationGetTitle


