

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.NotificationPermissionRequest
    ( 

-- * Exported types
    NotificationPermissionRequest(..)       ,
    NotificationPermissionRequestK          ,
    toNotificationPermissionRequest         ,
    noNotificationPermissionRequest         ,


    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject

newtype NotificationPermissionRequest = NotificationPermissionRequest (ForeignPtr NotificationPermissionRequest)
foreign import ccall "webkit_notification_permission_request_get_type"
    c_webkit_notification_permission_request_get_type :: IO GType

type instance ParentTypes NotificationPermissionRequest = NotificationPermissionRequestParentTypes
type NotificationPermissionRequestParentTypes = '[GObject.Object, PermissionRequest]

instance GObject NotificationPermissionRequest where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_notification_permission_request_get_type
    

class GObject o => NotificationPermissionRequestK o
instance (GObject o, IsDescendantOf NotificationPermissionRequest o) => NotificationPermissionRequestK o

toNotificationPermissionRequest :: NotificationPermissionRequestK o => o -> IO NotificationPermissionRequest
toNotificationPermissionRequest = unsafeCastTo NotificationPermissionRequest

noNotificationPermissionRequest :: Maybe NotificationPermissionRequest
noNotificationPermissionRequest = Nothing

type family ResolveNotificationPermissionRequestMethod (t :: Symbol) (o :: *) :: * where
    ResolveNotificationPermissionRequestMethod "allow" o = PermissionRequestAllowMethodInfo
    ResolveNotificationPermissionRequestMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveNotificationPermissionRequestMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveNotificationPermissionRequestMethod "deny" o = PermissionRequestDenyMethodInfo
    ResolveNotificationPermissionRequestMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveNotificationPermissionRequestMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveNotificationPermissionRequestMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveNotificationPermissionRequestMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveNotificationPermissionRequestMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveNotificationPermissionRequestMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveNotificationPermissionRequestMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveNotificationPermissionRequestMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveNotificationPermissionRequestMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveNotificationPermissionRequestMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveNotificationPermissionRequestMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveNotificationPermissionRequestMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveNotificationPermissionRequestMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveNotificationPermissionRequestMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveNotificationPermissionRequestMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveNotificationPermissionRequestMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveNotificationPermissionRequestMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveNotificationPermissionRequestMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveNotificationPermissionRequestMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveNotificationPermissionRequestMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveNotificationPermissionRequestMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveNotificationPermissionRequestMethod t NotificationPermissionRequest, MethodInfo info NotificationPermissionRequest p) => IsLabelProxy t (NotificationPermissionRequest -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveNotificationPermissionRequestMethod t NotificationPermissionRequest, MethodInfo info NotificationPermissionRequest p) => IsLabel t (NotificationPermissionRequest -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

type instance AttributeList NotificationPermissionRequest = NotificationPermissionRequestAttributeList
type NotificationPermissionRequestAttributeList = ('[ ] :: [(Symbol, *)])

type instance SignalList NotificationPermissionRequest = NotificationPermissionRequestSignalList
type NotificationPermissionRequestSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])


