

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.Plugin
    ( 

-- * Exported types
    Plugin(..)                              ,
    PluginK                                 ,
    toPlugin                                ,
    noPlugin                                ,


 -- * Methods
-- ** pluginGetDescription
    PluginGetDescriptionMethodInfo          ,
    pluginGetDescription                    ,


-- ** pluginGetMimeInfoList
    PluginGetMimeInfoListMethodInfo         ,
    pluginGetMimeInfoList                   ,


-- ** pluginGetName
    PluginGetNameMethodInfo                 ,
    pluginGetName                           ,


-- ** pluginGetPath
    PluginGetPathMethodInfo                 ,
    pluginGetPath                           ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject

newtype Plugin = Plugin (ForeignPtr Plugin)
foreign import ccall "webkit_plugin_get_type"
    c_webkit_plugin_get_type :: IO GType

type instance ParentTypes Plugin = PluginParentTypes
type PluginParentTypes = '[GObject.Object]

instance GObject Plugin where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_plugin_get_type
    

class GObject o => PluginK o
instance (GObject o, IsDescendantOf Plugin o) => PluginK o

toPlugin :: PluginK o => o -> IO Plugin
toPlugin = unsafeCastTo Plugin

noPlugin :: Maybe Plugin
noPlugin = Nothing

type family ResolvePluginMethod (t :: Symbol) (o :: *) :: * where
    ResolvePluginMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolvePluginMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolvePluginMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolvePluginMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolvePluginMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolvePluginMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolvePluginMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolvePluginMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolvePluginMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolvePluginMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolvePluginMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolvePluginMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolvePluginMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolvePluginMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolvePluginMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolvePluginMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolvePluginMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolvePluginMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolvePluginMethod "getDescription" o = PluginGetDescriptionMethodInfo
    ResolvePluginMethod "getMimeInfoList" o = PluginGetMimeInfoListMethodInfo
    ResolvePluginMethod "getName" o = PluginGetNameMethodInfo
    ResolvePluginMethod "getPath" o = PluginGetPathMethodInfo
    ResolvePluginMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolvePluginMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolvePluginMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolvePluginMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolvePluginMethod l o = MethodResolutionFailed l o

instance (info ~ ResolvePluginMethod t Plugin, MethodInfo info Plugin p) => IsLabelProxy t (Plugin -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolvePluginMethod t Plugin, MethodInfo info Plugin p) => IsLabel t (Plugin -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

type instance AttributeList Plugin = PluginAttributeList
type PluginAttributeList = ('[ ] :: [(Symbol, *)])

type instance SignalList Plugin = PluginSignalList
type PluginSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method Plugin::get_description
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Plugin", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_plugin_get_description" webkit_plugin_get_description :: 
    Ptr Plugin ->                           -- _obj : TInterface "WebKit2" "Plugin"
    IO CString


pluginGetDescription ::
    (MonadIO m, PluginK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
pluginGetDescription _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_plugin_get_description _obj'
    checkUnexpectedReturnNULL "webkit_plugin_get_description" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data PluginGetDescriptionMethodInfo
instance (signature ~ (m T.Text), MonadIO m, PluginK a) => MethodInfo PluginGetDescriptionMethodInfo a signature where
    overloadedMethod _ = pluginGetDescription

-- method Plugin::get_mime_info_list
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Plugin", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TGList (TInterface "WebKit2" "MimeInfo"))
-- throws : False
-- Skip return : False

foreign import ccall "webkit_plugin_get_mime_info_list" webkit_plugin_get_mime_info_list :: 
    Ptr Plugin ->                           -- _obj : TInterface "WebKit2" "Plugin"
    IO (Ptr (GList (Ptr MimeInfo)))


pluginGetMimeInfoList ::
    (MonadIO m, PluginK a) =>
    a                                       -- _obj
    -> m [MimeInfo]                         -- result
pluginGetMimeInfoList _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_plugin_get_mime_info_list _obj'
    result' <- unpackGList result
    result'' <- mapM (newBoxed MimeInfo) result'
    touchManagedPtr _obj
    return result''

data PluginGetMimeInfoListMethodInfo
instance (signature ~ (m [MimeInfo]), MonadIO m, PluginK a) => MethodInfo PluginGetMimeInfoListMethodInfo a signature where
    overloadedMethod _ = pluginGetMimeInfoList

-- method Plugin::get_name
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Plugin", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_plugin_get_name" webkit_plugin_get_name :: 
    Ptr Plugin ->                           -- _obj : TInterface "WebKit2" "Plugin"
    IO CString


pluginGetName ::
    (MonadIO m, PluginK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
pluginGetName _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_plugin_get_name _obj'
    checkUnexpectedReturnNULL "webkit_plugin_get_name" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data PluginGetNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m, PluginK a) => MethodInfo PluginGetNameMethodInfo a signature where
    overloadedMethod _ = pluginGetName

-- method Plugin::get_path
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "Plugin", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_plugin_get_path" webkit_plugin_get_path :: 
    Ptr Plugin ->                           -- _obj : TInterface "WebKit2" "Plugin"
    IO CString


pluginGetPath ::
    (MonadIO m, PluginK a) =>
    a                                       -- _obj
    -> m T.Text                             -- result
pluginGetPath _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_plugin_get_path _obj'
    checkUnexpectedReturnNULL "webkit_plugin_get_path" result
    result' <- cstringToText result
    touchManagedPtr _obj
    return result'

data PluginGetPathMethodInfo
instance (signature ~ (m T.Text), MonadIO m, PluginK a) => MethodInfo PluginGetPathMethodInfo a signature where
    overloadedMethod _ = pluginGetPath


