

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.PolicyDecision
    ( 

-- * Exported types
    PolicyDecision(..)                      ,
    PolicyDecisionK                         ,
    toPolicyDecision                        ,
    noPolicyDecision                        ,


 -- * Methods
-- ** policyDecisionDownload
    PolicyDecisionDownloadMethodInfo        ,
    policyDecisionDownload                  ,


-- ** policyDecisionIgnore
    PolicyDecisionIgnoreMethodInfo          ,
    policyDecisionIgnore                    ,


-- ** policyDecisionUse
    PolicyDecisionUseMethodInfo             ,
    policyDecisionUse                       ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject

newtype PolicyDecision = PolicyDecision (ForeignPtr PolicyDecision)
foreign import ccall "webkit_policy_decision_get_type"
    c_webkit_policy_decision_get_type :: IO GType

type instance ParentTypes PolicyDecision = PolicyDecisionParentTypes
type PolicyDecisionParentTypes = '[GObject.Object]

instance GObject PolicyDecision where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_policy_decision_get_type
    

class GObject o => PolicyDecisionK o
instance (GObject o, IsDescendantOf PolicyDecision o) => PolicyDecisionK o

toPolicyDecision :: PolicyDecisionK o => o -> IO PolicyDecision
toPolicyDecision = unsafeCastTo PolicyDecision

noPolicyDecision :: Maybe PolicyDecision
noPolicyDecision = Nothing

type family ResolvePolicyDecisionMethod (t :: Symbol) (o :: *) :: * where
    ResolvePolicyDecisionMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolvePolicyDecisionMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolvePolicyDecisionMethod "download" o = PolicyDecisionDownloadMethodInfo
    ResolvePolicyDecisionMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolvePolicyDecisionMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolvePolicyDecisionMethod "ignore" o = PolicyDecisionIgnoreMethodInfo
    ResolvePolicyDecisionMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolvePolicyDecisionMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolvePolicyDecisionMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolvePolicyDecisionMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolvePolicyDecisionMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolvePolicyDecisionMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolvePolicyDecisionMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolvePolicyDecisionMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolvePolicyDecisionMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolvePolicyDecisionMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolvePolicyDecisionMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolvePolicyDecisionMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolvePolicyDecisionMethod "use" o = PolicyDecisionUseMethodInfo
    ResolvePolicyDecisionMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolvePolicyDecisionMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolvePolicyDecisionMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolvePolicyDecisionMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolvePolicyDecisionMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolvePolicyDecisionMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolvePolicyDecisionMethod l o = MethodResolutionFailed l o

instance (info ~ ResolvePolicyDecisionMethod t PolicyDecision, MethodInfo info PolicyDecision p) => IsLabelProxy t (PolicyDecision -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolvePolicyDecisionMethod t PolicyDecision, MethodInfo info PolicyDecision p) => IsLabel t (PolicyDecision -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

type instance AttributeList PolicyDecision = PolicyDecisionAttributeList
type PolicyDecisionAttributeList = ('[ ] :: [(Symbol, *)])

type instance SignalList PolicyDecision = PolicyDecisionSignalList
type PolicyDecisionSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method PolicyDecision::download
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "PolicyDecision", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_policy_decision_download" webkit_policy_decision_download :: 
    Ptr PolicyDecision ->                   -- _obj : TInterface "WebKit2" "PolicyDecision"
    IO ()


policyDecisionDownload ::
    (MonadIO m, PolicyDecisionK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
policyDecisionDownload _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_policy_decision_download _obj'
    touchManagedPtr _obj
    return ()

data PolicyDecisionDownloadMethodInfo
instance (signature ~ (m ()), MonadIO m, PolicyDecisionK a) => MethodInfo PolicyDecisionDownloadMethodInfo a signature where
    overloadedMethod _ = policyDecisionDownload

-- method PolicyDecision::ignore
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "PolicyDecision", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_policy_decision_ignore" webkit_policy_decision_ignore :: 
    Ptr PolicyDecision ->                   -- _obj : TInterface "WebKit2" "PolicyDecision"
    IO ()


policyDecisionIgnore ::
    (MonadIO m, PolicyDecisionK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
policyDecisionIgnore _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_policy_decision_ignore _obj'
    touchManagedPtr _obj
    return ()

data PolicyDecisionIgnoreMethodInfo
instance (signature ~ (m ()), MonadIO m, PolicyDecisionK a) => MethodInfo PolicyDecisionIgnoreMethodInfo a signature where
    overloadedMethod _ = policyDecisionIgnore

-- method PolicyDecision::use
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "PolicyDecision", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_policy_decision_use" webkit_policy_decision_use :: 
    Ptr PolicyDecision ->                   -- _obj : TInterface "WebKit2" "PolicyDecision"
    IO ()


policyDecisionUse ::
    (MonadIO m, PolicyDecisionK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
policyDecisionUse _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_policy_decision_use _obj'
    touchManagedPtr _obj
    return ()

data PolicyDecisionUseMethodInfo
instance (signature ~ (m ()), MonadIO m, PolicyDecisionK a) => MethodInfo PolicyDecisionUseMethodInfo a signature where
    overloadedMethod _ = policyDecisionUse


