

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.PrintOperation
    ( 

-- * Exported types
    PrintOperation(..)                      ,
    PrintOperationK                         ,
    toPrintOperation                        ,
    noPrintOperation                        ,


 -- * Methods
-- ** printOperationGetPageSetup
    PrintOperationGetPageSetupMethodInfo    ,
    printOperationGetPageSetup              ,


-- ** printOperationGetPrintSettings
    PrintOperationGetPrintSettingsMethodInfo,
    printOperationGetPrintSettings          ,


-- ** printOperationNew
    printOperationNew                       ,


-- ** printOperationPrint
    PrintOperationPrintMethodInfo           ,
    printOperationPrint                     ,


-- ** printOperationRunDialog
    PrintOperationRunDialogMethodInfo       ,
    printOperationRunDialog                 ,


-- ** printOperationSetPageSetup
    PrintOperationSetPageSetupMethodInfo    ,
    printOperationSetPageSetup              ,


-- ** printOperationSetPrintSettings
    PrintOperationSetPrintSettingsMethodInfo,
    printOperationSetPrintSettings          ,




 -- * Properties
-- ** PageSetup
    PrintOperationPageSetupPropertyInfo     ,
    constructPrintOperationPageSetup        ,
    getPrintOperationPageSetup              ,
    printOperationPageSetup                 ,
    setPrintOperationPageSetup              ,


-- ** PrintSettings
    PrintOperationPrintSettingsPropertyInfo ,
    constructPrintOperationPrintSettings    ,
    getPrintOperationPrintSettings          ,
    printOperationPrintSettings             ,
    setPrintOperationPrintSettings          ,


-- ** WebView
    PrintOperationWebViewPropertyInfo       ,
    constructPrintOperationWebView          ,
    getPrintOperationWebView                ,
    printOperationWebView                   ,




 -- * Signals
-- ** Failed
    PrintOperationFailedCallback            ,
    PrintOperationFailedCallbackC           ,
    PrintOperationFailedSignalInfo          ,
    afterPrintOperationFailed               ,
    mkPrintOperationFailedCallback          ,
    noPrintOperationFailedCallback          ,
    onPrintOperationFailed                  ,
    printOperationFailedCallbackWrapper     ,
    printOperationFailedClosure             ,


-- ** Finished
    PrintOperationFinishedCallback          ,
    PrintOperationFinishedCallbackC         ,
    PrintOperationFinishedSignalInfo        ,
    afterPrintOperationFinished             ,
    mkPrintOperationFinishedCallback        ,
    noPrintOperationFinishedCallback        ,
    onPrintOperationFinished                ,
    printOperationFinishedCallbackWrapper   ,
    printOperationFinishedClosure           ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject
import qualified GI.Gtk as Gtk

newtype PrintOperation = PrintOperation (ForeignPtr PrintOperation)
foreign import ccall "webkit_print_operation_get_type"
    c_webkit_print_operation_get_type :: IO GType

type instance ParentTypes PrintOperation = PrintOperationParentTypes
type PrintOperationParentTypes = '[GObject.Object]

instance GObject PrintOperation where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_print_operation_get_type
    

class GObject o => PrintOperationK o
instance (GObject o, IsDescendantOf PrintOperation o) => PrintOperationK o

toPrintOperation :: PrintOperationK o => o -> IO PrintOperation
toPrintOperation = unsafeCastTo PrintOperation

noPrintOperation :: Maybe PrintOperation
noPrintOperation = Nothing

type family ResolvePrintOperationMethod (t :: Symbol) (o :: *) :: * where
    ResolvePrintOperationMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolvePrintOperationMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolvePrintOperationMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolvePrintOperationMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolvePrintOperationMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolvePrintOperationMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolvePrintOperationMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolvePrintOperationMethod "print" o = PrintOperationPrintMethodInfo
    ResolvePrintOperationMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolvePrintOperationMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolvePrintOperationMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolvePrintOperationMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolvePrintOperationMethod "runDialog" o = PrintOperationRunDialogMethodInfo
    ResolvePrintOperationMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolvePrintOperationMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolvePrintOperationMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolvePrintOperationMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolvePrintOperationMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolvePrintOperationMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolvePrintOperationMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolvePrintOperationMethod "getPageSetup" o = PrintOperationGetPageSetupMethodInfo
    ResolvePrintOperationMethod "getPrintSettings" o = PrintOperationGetPrintSettingsMethodInfo
    ResolvePrintOperationMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolvePrintOperationMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolvePrintOperationMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolvePrintOperationMethod "setPageSetup" o = PrintOperationSetPageSetupMethodInfo
    ResolvePrintOperationMethod "setPrintSettings" o = PrintOperationSetPrintSettingsMethodInfo
    ResolvePrintOperationMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolvePrintOperationMethod l o = MethodResolutionFailed l o

instance (info ~ ResolvePrintOperationMethod t PrintOperation, MethodInfo info PrintOperation p) => IsLabelProxy t (PrintOperation -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolvePrintOperationMethod t PrintOperation, MethodInfo info PrintOperation p) => IsLabel t (PrintOperation -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- signal PrintOperation::failed
type PrintOperationFailedCallback =
    GError ->
    IO ()

noPrintOperationFailedCallback :: Maybe PrintOperationFailedCallback
noPrintOperationFailedCallback = Nothing

type PrintOperationFailedCallbackC =
    Ptr () ->                               -- object
    Ptr GError ->
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkPrintOperationFailedCallback :: PrintOperationFailedCallbackC -> IO (FunPtr PrintOperationFailedCallbackC)

printOperationFailedClosure :: PrintOperationFailedCallback -> IO Closure
printOperationFailedClosure cb = newCClosure =<< mkPrintOperationFailedCallback wrapped
    where wrapped = printOperationFailedCallbackWrapper cb

printOperationFailedCallbackWrapper ::
    PrintOperationFailedCallback ->
    Ptr () ->
    Ptr GError ->
    Ptr () ->
    IO ()
printOperationFailedCallbackWrapper _cb _ error_ _ = do
    error_' <- (newBoxed GError) error_
    _cb  error_'

onPrintOperationFailed :: (GObject a, MonadIO m) => a -> PrintOperationFailedCallback -> m SignalHandlerId
onPrintOperationFailed obj cb = liftIO $ connectPrintOperationFailed obj cb SignalConnectBefore
afterPrintOperationFailed :: (GObject a, MonadIO m) => a -> PrintOperationFailedCallback -> m SignalHandlerId
afterPrintOperationFailed obj cb = connectPrintOperationFailed obj cb SignalConnectAfter

connectPrintOperationFailed :: (GObject a, MonadIO m) =>
                               a -> PrintOperationFailedCallback -> SignalConnectMode -> m SignalHandlerId
connectPrintOperationFailed obj cb after = liftIO $ do
    cb' <- mkPrintOperationFailedCallback (printOperationFailedCallbackWrapper cb)
    connectSignalFunPtr obj "failed" cb' after

-- signal PrintOperation::finished
type PrintOperationFinishedCallback =
    IO ()

noPrintOperationFinishedCallback :: Maybe PrintOperationFinishedCallback
noPrintOperationFinishedCallback = Nothing

type PrintOperationFinishedCallbackC =
    Ptr () ->                               -- object
    Ptr () ->                               -- user_data
    IO ()

foreign import ccall "wrapper"
    mkPrintOperationFinishedCallback :: PrintOperationFinishedCallbackC -> IO (FunPtr PrintOperationFinishedCallbackC)

printOperationFinishedClosure :: PrintOperationFinishedCallback -> IO Closure
printOperationFinishedClosure cb = newCClosure =<< mkPrintOperationFinishedCallback wrapped
    where wrapped = printOperationFinishedCallbackWrapper cb

printOperationFinishedCallbackWrapper ::
    PrintOperationFinishedCallback ->
    Ptr () ->
    Ptr () ->
    IO ()
printOperationFinishedCallbackWrapper _cb _ _ = do
    _cb 

onPrintOperationFinished :: (GObject a, MonadIO m) => a -> PrintOperationFinishedCallback -> m SignalHandlerId
onPrintOperationFinished obj cb = liftIO $ connectPrintOperationFinished obj cb SignalConnectBefore
afterPrintOperationFinished :: (GObject a, MonadIO m) => a -> PrintOperationFinishedCallback -> m SignalHandlerId
afterPrintOperationFinished obj cb = connectPrintOperationFinished obj cb SignalConnectAfter

connectPrintOperationFinished :: (GObject a, MonadIO m) =>
                                 a -> PrintOperationFinishedCallback -> SignalConnectMode -> m SignalHandlerId
connectPrintOperationFinished obj cb after = liftIO $ do
    cb' <- mkPrintOperationFinishedCallback (printOperationFinishedCallbackWrapper cb)
    connectSignalFunPtr obj "finished" cb' after

-- VVV Prop "page-setup"
   -- Type: TInterface "Gtk" "PageSetup"
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

getPrintOperationPageSetup :: (MonadIO m, PrintOperationK o) => o -> m Gtk.PageSetup
getPrintOperationPageSetup obj = liftIO $ checkUnexpectedNothing "getPrintOperationPageSetup" $ getObjectPropertyObject obj "page-setup" Gtk.PageSetup

setPrintOperationPageSetup :: (MonadIO m, PrintOperationK o, Gtk.PageSetupK a) => o -> a -> m ()
setPrintOperationPageSetup obj val = liftIO $ setObjectPropertyObject obj "page-setup" (Just val)

constructPrintOperationPageSetup :: (Gtk.PageSetupK a) => a -> IO ([Char], GValue)
constructPrintOperationPageSetup val = constructObjectPropertyObject "page-setup" (Just val)

data PrintOperationPageSetupPropertyInfo
instance AttrInfo PrintOperationPageSetupPropertyInfo where
    type AttrAllowedOps PrintOperationPageSetupPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint PrintOperationPageSetupPropertyInfo = Gtk.PageSetupK
    type AttrBaseTypeConstraint PrintOperationPageSetupPropertyInfo = PrintOperationK
    type AttrGetType PrintOperationPageSetupPropertyInfo = Gtk.PageSetup
    type AttrLabel PrintOperationPageSetupPropertyInfo = "page-setup"
    attrGet _ = getPrintOperationPageSetup
    attrSet _ = setPrintOperationPageSetup
    attrConstruct _ = constructPrintOperationPageSetup
    attrClear _ = undefined

-- VVV Prop "print-settings"
   -- Type: TInterface "Gtk" "PrintSettings"
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

getPrintOperationPrintSettings :: (MonadIO m, PrintOperationK o) => o -> m Gtk.PrintSettings
getPrintOperationPrintSettings obj = liftIO $ checkUnexpectedNothing "getPrintOperationPrintSettings" $ getObjectPropertyObject obj "print-settings" Gtk.PrintSettings

setPrintOperationPrintSettings :: (MonadIO m, PrintOperationK o, Gtk.PrintSettingsK a) => o -> a -> m ()
setPrintOperationPrintSettings obj val = liftIO $ setObjectPropertyObject obj "print-settings" (Just val)

constructPrintOperationPrintSettings :: (Gtk.PrintSettingsK a) => a -> IO ([Char], GValue)
constructPrintOperationPrintSettings val = constructObjectPropertyObject "print-settings" (Just val)

data PrintOperationPrintSettingsPropertyInfo
instance AttrInfo PrintOperationPrintSettingsPropertyInfo where
    type AttrAllowedOps PrintOperationPrintSettingsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrSetTypeConstraint PrintOperationPrintSettingsPropertyInfo = Gtk.PrintSettingsK
    type AttrBaseTypeConstraint PrintOperationPrintSettingsPropertyInfo = PrintOperationK
    type AttrGetType PrintOperationPrintSettingsPropertyInfo = Gtk.PrintSettings
    type AttrLabel PrintOperationPrintSettingsPropertyInfo = "print-settings"
    attrGet _ = getPrintOperationPrintSettings
    attrSet _ = setPrintOperationPrintSettings
    attrConstruct _ = constructPrintOperationPrintSettings
    attrClear _ = undefined

-- VVV Prop "web-view"
   -- Type: TInterface "WebKit2" "WebView"
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

getPrintOperationWebView :: (MonadIO m, PrintOperationK o) => o -> m (Maybe WebView)
getPrintOperationWebView obj = liftIO $ getObjectPropertyObject obj "web-view" WebView

constructPrintOperationWebView :: (WebViewK a) => a -> IO ([Char], GValue)
constructPrintOperationWebView val = constructObjectPropertyObject "web-view" (Just val)

data PrintOperationWebViewPropertyInfo
instance AttrInfo PrintOperationWebViewPropertyInfo where
    type AttrAllowedOps PrintOperationWebViewPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint PrintOperationWebViewPropertyInfo = WebViewK
    type AttrBaseTypeConstraint PrintOperationWebViewPropertyInfo = PrintOperationK
    type AttrGetType PrintOperationWebViewPropertyInfo = (Maybe WebView)
    type AttrLabel PrintOperationWebViewPropertyInfo = "web-view"
    attrGet _ = getPrintOperationWebView
    attrSet _ = undefined
    attrConstruct _ = constructPrintOperationWebView
    attrClear _ = undefined

type instance AttributeList PrintOperation = PrintOperationAttributeList
type PrintOperationAttributeList = ('[ '("pageSetup", PrintOperationPageSetupPropertyInfo), '("printSettings", PrintOperationPrintSettingsPropertyInfo), '("webView", PrintOperationWebViewPropertyInfo)] :: [(Symbol, *)])

printOperationPageSetup :: AttrLabelProxy "pageSetup"
printOperationPageSetup = AttrLabelProxy

printOperationPrintSettings :: AttrLabelProxy "printSettings"
printOperationPrintSettings = AttrLabelProxy

printOperationWebView :: AttrLabelProxy "webView"
printOperationWebView = AttrLabelProxy

data PrintOperationFailedSignalInfo
instance SignalInfo PrintOperationFailedSignalInfo where
    type HaskellCallbackType PrintOperationFailedSignalInfo = PrintOperationFailedCallback
    connectSignal _ = connectPrintOperationFailed

data PrintOperationFinishedSignalInfo
instance SignalInfo PrintOperationFinishedSignalInfo where
    type HaskellCallbackType PrintOperationFinishedSignalInfo = PrintOperationFinishedCallback
    connectSignal _ = connectPrintOperationFinished

type instance SignalList PrintOperation = PrintOperationSignalList
type PrintOperationSignalList = ('[ '("failed", PrintOperationFailedSignalInfo), '("finished", PrintOperationFinishedSignalInfo), '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method PrintOperation::new
-- method type : Constructor
-- Args : [Arg {argCName = "web_view", argType = TInterface "WebKit2" "WebView", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "PrintOperation")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_print_operation_new" webkit_print_operation_new :: 
    Ptr WebView ->                          -- web_view : TInterface "WebKit2" "WebView"
    IO (Ptr PrintOperation)


printOperationNew ::
    (MonadIO m, WebViewK a) =>
    a                                       -- webView
    -> m PrintOperation                     -- result
printOperationNew webView = liftIO $ do
    let webView' = unsafeManagedPtrCastPtr webView
    result <- webkit_print_operation_new webView'
    checkUnexpectedReturnNULL "webkit_print_operation_new" result
    result' <- (wrapObject PrintOperation) result
    touchManagedPtr webView
    return result'

-- method PrintOperation::get_page_setup
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "PrintOperation", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "Gtk" "PageSetup")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_print_operation_get_page_setup" webkit_print_operation_get_page_setup :: 
    Ptr PrintOperation ->                   -- _obj : TInterface "WebKit2" "PrintOperation"
    IO (Ptr Gtk.PageSetup)


printOperationGetPageSetup ::
    (MonadIO m, PrintOperationK a) =>
    a                                       -- _obj
    -> m Gtk.PageSetup                      -- result
printOperationGetPageSetup _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_print_operation_get_page_setup _obj'
    checkUnexpectedReturnNULL "webkit_print_operation_get_page_setup" result
    result' <- (newObject Gtk.PageSetup) result
    touchManagedPtr _obj
    return result'

data PrintOperationGetPageSetupMethodInfo
instance (signature ~ (m Gtk.PageSetup), MonadIO m, PrintOperationK a) => MethodInfo PrintOperationGetPageSetupMethodInfo a signature where
    overloadedMethod _ = printOperationGetPageSetup

-- method PrintOperation::get_print_settings
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "PrintOperation", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "Gtk" "PrintSettings")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_print_operation_get_print_settings" webkit_print_operation_get_print_settings :: 
    Ptr PrintOperation ->                   -- _obj : TInterface "WebKit2" "PrintOperation"
    IO (Ptr Gtk.PrintSettings)


printOperationGetPrintSettings ::
    (MonadIO m, PrintOperationK a) =>
    a                                       -- _obj
    -> m Gtk.PrintSettings                  -- result
printOperationGetPrintSettings _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_print_operation_get_print_settings _obj'
    checkUnexpectedReturnNULL "webkit_print_operation_get_print_settings" result
    result' <- (newObject Gtk.PrintSettings) result
    touchManagedPtr _obj
    return result'

data PrintOperationGetPrintSettingsMethodInfo
instance (signature ~ (m Gtk.PrintSettings), MonadIO m, PrintOperationK a) => MethodInfo PrintOperationGetPrintSettingsMethodInfo a signature where
    overloadedMethod _ = printOperationGetPrintSettings

-- method PrintOperation::print
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "PrintOperation", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_print_operation_print" webkit_print_operation_print :: 
    Ptr PrintOperation ->                   -- _obj : TInterface "WebKit2" "PrintOperation"
    IO ()


printOperationPrint ::
    (MonadIO m, PrintOperationK a) =>
    a                                       -- _obj
    -> m ()                                 -- result
printOperationPrint _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    webkit_print_operation_print _obj'
    touchManagedPtr _obj
    return ()

data PrintOperationPrintMethodInfo
instance (signature ~ (m ()), MonadIO m, PrintOperationK a) => MethodInfo PrintOperationPrintMethodInfo a signature where
    overloadedMethod _ = printOperationPrint

-- method PrintOperation::run_dialog
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "PrintOperation", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "parent", argType = TInterface "Gtk" "Window", direction = DirectionIn, mayBeNull = True, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "PrintOperationResponse")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_print_operation_run_dialog" webkit_print_operation_run_dialog :: 
    Ptr PrintOperation ->                   -- _obj : TInterface "WebKit2" "PrintOperation"
    Ptr Gtk.Window ->                       -- parent : TInterface "Gtk" "Window"
    IO CUInt


printOperationRunDialog ::
    (MonadIO m, PrintOperationK a, Gtk.WindowK b) =>
    a                                       -- _obj
    -> Maybe (b)                            -- parent
    -> m PrintOperationResponse             -- result
printOperationRunDialog _obj parent = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    maybeParent <- case parent of
        Nothing -> return nullPtr
        Just jParent -> do
            let jParent' = unsafeManagedPtrCastPtr jParent
            return jParent'
    result <- webkit_print_operation_run_dialog _obj' maybeParent
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr _obj
    whenJust parent touchManagedPtr
    return result'

data PrintOperationRunDialogMethodInfo
instance (signature ~ (Maybe (b) -> m PrintOperationResponse), MonadIO m, PrintOperationK a, Gtk.WindowK b) => MethodInfo PrintOperationRunDialogMethodInfo a signature where
    overloadedMethod _ = printOperationRunDialog

-- method PrintOperation::set_page_setup
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "PrintOperation", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "page_setup", argType = TInterface "Gtk" "PageSetup", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_print_operation_set_page_setup" webkit_print_operation_set_page_setup :: 
    Ptr PrintOperation ->                   -- _obj : TInterface "WebKit2" "PrintOperation"
    Ptr Gtk.PageSetup ->                    -- page_setup : TInterface "Gtk" "PageSetup"
    IO ()


printOperationSetPageSetup ::
    (MonadIO m, PrintOperationK a, Gtk.PageSetupK b) =>
    a                                       -- _obj
    -> b                                    -- pageSetup
    -> m ()                                 -- result
printOperationSetPageSetup _obj pageSetup = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let pageSetup' = unsafeManagedPtrCastPtr pageSetup
    webkit_print_operation_set_page_setup _obj' pageSetup'
    touchManagedPtr _obj
    touchManagedPtr pageSetup
    return ()

data PrintOperationSetPageSetupMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, PrintOperationK a, Gtk.PageSetupK b) => MethodInfo PrintOperationSetPageSetupMethodInfo a signature where
    overloadedMethod _ = printOperationSetPageSetup

-- method PrintOperation::set_print_settings
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "PrintOperation", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "print_settings", argType = TInterface "Gtk" "PrintSettings", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_print_operation_set_print_settings" webkit_print_operation_set_print_settings :: 
    Ptr PrintOperation ->                   -- _obj : TInterface "WebKit2" "PrintOperation"
    Ptr Gtk.PrintSettings ->                -- print_settings : TInterface "Gtk" "PrintSettings"
    IO ()


printOperationSetPrintSettings ::
    (MonadIO m, PrintOperationK a, Gtk.PrintSettingsK b) =>
    a                                       -- _obj
    -> b                                    -- printSettings
    -> m ()                                 -- result
printOperationSetPrintSettings _obj printSettings = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    let printSettings' = unsafeManagedPtrCastPtr printSettings
    webkit_print_operation_set_print_settings _obj' printSettings'
    touchManagedPtr _obj
    touchManagedPtr printSettings
    return ()

data PrintOperationSetPrintSettingsMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, PrintOperationK a, Gtk.PrintSettingsK b) => MethodInfo PrintOperationSetPrintSettingsMethodInfo a signature where
    overloadedMethod _ = printOperationSetPrintSettings


