

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.ResponsePolicyDecision
    ( 

-- * Exported types
    ResponsePolicyDecision(..)              ,
    ResponsePolicyDecisionK                 ,
    toResponsePolicyDecision                ,
    noResponsePolicyDecision                ,


 -- * Methods
-- ** responsePolicyDecisionGetRequest
    ResponsePolicyDecisionGetRequestMethodInfo,
    responsePolicyDecisionGetRequest        ,


-- ** responsePolicyDecisionGetResponse
    ResponsePolicyDecisionGetResponseMethodInfo,
    responsePolicyDecisionGetResponse       ,


-- ** responsePolicyDecisionIsMimeTypeSupported
    ResponsePolicyDecisionIsMimeTypeSupportedMethodInfo,
    responsePolicyDecisionIsMimeTypeSupported,




 -- * Properties
-- ** Request
    ResponsePolicyDecisionRequestPropertyInfo,
    getResponsePolicyDecisionRequest        ,
    responsePolicyDecisionRequest           ,


-- ** Response
    ResponsePolicyDecisionResponsePropertyInfo,
    getResponsePolicyDecisionResponse       ,
    responsePolicyDecisionResponse          ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject

newtype ResponsePolicyDecision = ResponsePolicyDecision (ForeignPtr ResponsePolicyDecision)
foreign import ccall "webkit_response_policy_decision_get_type"
    c_webkit_response_policy_decision_get_type :: IO GType

type instance ParentTypes ResponsePolicyDecision = ResponsePolicyDecisionParentTypes
type ResponsePolicyDecisionParentTypes = '[PolicyDecision, GObject.Object]

instance GObject ResponsePolicyDecision where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_response_policy_decision_get_type
    

class GObject o => ResponsePolicyDecisionK o
instance (GObject o, IsDescendantOf ResponsePolicyDecision o) => ResponsePolicyDecisionK o

toResponsePolicyDecision :: ResponsePolicyDecisionK o => o -> IO ResponsePolicyDecision
toResponsePolicyDecision = unsafeCastTo ResponsePolicyDecision

noResponsePolicyDecision :: Maybe ResponsePolicyDecision
noResponsePolicyDecision = Nothing

type family ResolveResponsePolicyDecisionMethod (t :: Symbol) (o :: *) :: * where
    ResolveResponsePolicyDecisionMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveResponsePolicyDecisionMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveResponsePolicyDecisionMethod "download" o = PolicyDecisionDownloadMethodInfo
    ResolveResponsePolicyDecisionMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveResponsePolicyDecisionMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveResponsePolicyDecisionMethod "ignore" o = PolicyDecisionIgnoreMethodInfo
    ResolveResponsePolicyDecisionMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveResponsePolicyDecisionMethod "isMimeTypeSupported" o = ResponsePolicyDecisionIsMimeTypeSupportedMethodInfo
    ResolveResponsePolicyDecisionMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveResponsePolicyDecisionMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveResponsePolicyDecisionMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveResponsePolicyDecisionMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveResponsePolicyDecisionMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveResponsePolicyDecisionMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveResponsePolicyDecisionMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveResponsePolicyDecisionMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveResponsePolicyDecisionMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveResponsePolicyDecisionMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveResponsePolicyDecisionMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveResponsePolicyDecisionMethod "use" o = PolicyDecisionUseMethodInfo
    ResolveResponsePolicyDecisionMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveResponsePolicyDecisionMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveResponsePolicyDecisionMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveResponsePolicyDecisionMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveResponsePolicyDecisionMethod "getRequest" o = ResponsePolicyDecisionGetRequestMethodInfo
    ResolveResponsePolicyDecisionMethod "getResponse" o = ResponsePolicyDecisionGetResponseMethodInfo
    ResolveResponsePolicyDecisionMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveResponsePolicyDecisionMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveResponsePolicyDecisionMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveResponsePolicyDecisionMethod t ResponsePolicyDecision, MethodInfo info ResponsePolicyDecision p) => IsLabelProxy t (ResponsePolicyDecision -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveResponsePolicyDecisionMethod t ResponsePolicyDecision, MethodInfo info ResponsePolicyDecision p) => IsLabel t (ResponsePolicyDecision -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

-- VVV Prop "request"
   -- Type: TInterface "WebKit2" "URIRequest"
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getResponsePolicyDecisionRequest :: (MonadIO m, ResponsePolicyDecisionK o) => o -> m URIRequest
getResponsePolicyDecisionRequest obj = liftIO $ checkUnexpectedNothing "getResponsePolicyDecisionRequest" $ getObjectPropertyObject obj "request" URIRequest

data ResponsePolicyDecisionRequestPropertyInfo
instance AttrInfo ResponsePolicyDecisionRequestPropertyInfo where
    type AttrAllowedOps ResponsePolicyDecisionRequestPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ResponsePolicyDecisionRequestPropertyInfo = (~) ()
    type AttrBaseTypeConstraint ResponsePolicyDecisionRequestPropertyInfo = ResponsePolicyDecisionK
    type AttrGetType ResponsePolicyDecisionRequestPropertyInfo = URIRequest
    type AttrLabel ResponsePolicyDecisionRequestPropertyInfo = "request"
    attrGet _ = getResponsePolicyDecisionRequest
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

-- VVV Prop "response"
   -- Type: TInterface "WebKit2" "URIResponse"
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

getResponsePolicyDecisionResponse :: (MonadIO m, ResponsePolicyDecisionK o) => o -> m URIResponse
getResponsePolicyDecisionResponse obj = liftIO $ checkUnexpectedNothing "getResponsePolicyDecisionResponse" $ getObjectPropertyObject obj "response" URIResponse

data ResponsePolicyDecisionResponsePropertyInfo
instance AttrInfo ResponsePolicyDecisionResponsePropertyInfo where
    type AttrAllowedOps ResponsePolicyDecisionResponsePropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ResponsePolicyDecisionResponsePropertyInfo = (~) ()
    type AttrBaseTypeConstraint ResponsePolicyDecisionResponsePropertyInfo = ResponsePolicyDecisionK
    type AttrGetType ResponsePolicyDecisionResponsePropertyInfo = URIResponse
    type AttrLabel ResponsePolicyDecisionResponsePropertyInfo = "response"
    attrGet _ = getResponsePolicyDecisionResponse
    attrSet _ = undefined
    attrConstruct _ = undefined
    attrClear _ = undefined

type instance AttributeList ResponsePolicyDecision = ResponsePolicyDecisionAttributeList
type ResponsePolicyDecisionAttributeList = ('[ '("request", ResponsePolicyDecisionRequestPropertyInfo), '("response", ResponsePolicyDecisionResponsePropertyInfo)] :: [(Symbol, *)])

responsePolicyDecisionRequest :: AttrLabelProxy "request"
responsePolicyDecisionRequest = AttrLabelProxy

responsePolicyDecisionResponse :: AttrLabelProxy "response"
responsePolicyDecisionResponse = AttrLabelProxy

type instance SignalList ResponsePolicyDecision = ResponsePolicyDecisionSignalList
type ResponsePolicyDecisionSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method ResponsePolicyDecision::get_request
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "ResponsePolicyDecision", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "URIRequest")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_response_policy_decision_get_request" webkit_response_policy_decision_get_request :: 
    Ptr ResponsePolicyDecision ->           -- _obj : TInterface "WebKit2" "ResponsePolicyDecision"
    IO (Ptr URIRequest)


responsePolicyDecisionGetRequest ::
    (MonadIO m, ResponsePolicyDecisionK a) =>
    a                                       -- _obj
    -> m URIRequest                         -- result
responsePolicyDecisionGetRequest _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_response_policy_decision_get_request _obj'
    checkUnexpectedReturnNULL "webkit_response_policy_decision_get_request" result
    result' <- (newObject URIRequest) result
    touchManagedPtr _obj
    return result'

data ResponsePolicyDecisionGetRequestMethodInfo
instance (signature ~ (m URIRequest), MonadIO m, ResponsePolicyDecisionK a) => MethodInfo ResponsePolicyDecisionGetRequestMethodInfo a signature where
    overloadedMethod _ = responsePolicyDecisionGetRequest

-- method ResponsePolicyDecision::get_response
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "ResponsePolicyDecision", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TInterface "WebKit2" "URIResponse")
-- throws : False
-- Skip return : False

foreign import ccall "webkit_response_policy_decision_get_response" webkit_response_policy_decision_get_response :: 
    Ptr ResponsePolicyDecision ->           -- _obj : TInterface "WebKit2" "ResponsePolicyDecision"
    IO (Ptr URIResponse)


responsePolicyDecisionGetResponse ::
    (MonadIO m, ResponsePolicyDecisionK a) =>
    a                                       -- _obj
    -> m URIResponse                        -- result
responsePolicyDecisionGetResponse _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_response_policy_decision_get_response _obj'
    checkUnexpectedReturnNULL "webkit_response_policy_decision_get_response" result
    result' <- (newObject URIResponse) result
    touchManagedPtr _obj
    return result'

data ResponsePolicyDecisionGetResponseMethodInfo
instance (signature ~ (m URIResponse), MonadIO m, ResponsePolicyDecisionK a) => MethodInfo ResponsePolicyDecisionGetResponseMethodInfo a signature where
    overloadedMethod _ = responsePolicyDecisionGetResponse

-- method ResponsePolicyDecision::is_mime_type_supported
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "ResponsePolicyDecision", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_response_policy_decision_is_mime_type_supported" webkit_response_policy_decision_is_mime_type_supported :: 
    Ptr ResponsePolicyDecision ->           -- _obj : TInterface "WebKit2" "ResponsePolicyDecision"
    IO CInt


responsePolicyDecisionIsMimeTypeSupported ::
    (MonadIO m, ResponsePolicyDecisionK a) =>
    a                                       -- _obj
    -> m Bool                               -- result
responsePolicyDecisionIsMimeTypeSupported _obj = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    result <- webkit_response_policy_decision_is_mime_type_supported _obj'
    let result' = (/= 0) result
    touchManagedPtr _obj
    return result'

data ResponsePolicyDecisionIsMimeTypeSupportedMethodInfo
instance (signature ~ (m Bool), MonadIO m, ResponsePolicyDecisionK a) => MethodInfo ResponsePolicyDecisionIsMimeTypeSupportedMethodInfo a signature where
    overloadedMethod _ = responsePolicyDecisionIsMimeTypeSupported


