

{- |
Copyright  : Will Thompson, Iñaki García Etxebarria and Jonas Platte
License    : LGPL-2.1
Maintainer : Iñaki García Etxebarria (garetxe@gmail.com)
-}

module GI.WebKit2.Objects.SecurityManager
    ( 

-- * Exported types
    SecurityManager(..)                     ,
    SecurityManagerK                        ,
    toSecurityManager                       ,
    noSecurityManager                       ,


 -- * Methods
-- ** securityManagerRegisterUriSchemeAsCorsEnabled
    SecurityManagerRegisterUriSchemeAsCorsEnabledMethodInfo,
    securityManagerRegisterUriSchemeAsCorsEnabled,


-- ** securityManagerRegisterUriSchemeAsDisplayIsolated
    SecurityManagerRegisterUriSchemeAsDisplayIsolatedMethodInfo,
    securityManagerRegisterUriSchemeAsDisplayIsolated,


-- ** securityManagerRegisterUriSchemeAsEmptyDocument
    SecurityManagerRegisterUriSchemeAsEmptyDocumentMethodInfo,
    securityManagerRegisterUriSchemeAsEmptyDocument,


-- ** securityManagerRegisterUriSchemeAsLocal
    SecurityManagerRegisterUriSchemeAsLocalMethodInfo,
    securityManagerRegisterUriSchemeAsLocal ,


-- ** securityManagerRegisterUriSchemeAsNoAccess
    SecurityManagerRegisterUriSchemeAsNoAccessMethodInfo,
    securityManagerRegisterUriSchemeAsNoAccess,


-- ** securityManagerRegisterUriSchemeAsSecure
    SecurityManagerRegisterUriSchemeAsSecureMethodInfo,
    securityManagerRegisterUriSchemeAsSecure,


-- ** securityManagerUriSchemeIsCorsEnabled
    SecurityManagerUriSchemeIsCorsEnabledMethodInfo,
    securityManagerUriSchemeIsCorsEnabled   ,


-- ** securityManagerUriSchemeIsDisplayIsolated
    SecurityManagerUriSchemeIsDisplayIsolatedMethodInfo,
    securityManagerUriSchemeIsDisplayIsolated,


-- ** securityManagerUriSchemeIsEmptyDocument
    SecurityManagerUriSchemeIsEmptyDocumentMethodInfo,
    securityManagerUriSchemeIsEmptyDocument ,


-- ** securityManagerUriSchemeIsLocal
    SecurityManagerUriSchemeIsLocalMethodInfo,
    securityManagerUriSchemeIsLocal         ,


-- ** securityManagerUriSchemeIsNoAccess
    SecurityManagerUriSchemeIsNoAccessMethodInfo,
    securityManagerUriSchemeIsNoAccess      ,


-- ** securityManagerUriSchemeIsSecure
    SecurityManagerUriSchemeIsSecureMethodInfo,
    securityManagerUriSchemeIsSecure        ,




    ) where

import Data.GI.Base.ShortPrelude

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.Text as T
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map

import GI.WebKit2.Types
import GI.WebKit2.Callbacks
import qualified GI.GObject as GObject

newtype SecurityManager = SecurityManager (ForeignPtr SecurityManager)
foreign import ccall "webkit_security_manager_get_type"
    c_webkit_security_manager_get_type :: IO GType

type instance ParentTypes SecurityManager = SecurityManagerParentTypes
type SecurityManagerParentTypes = '[GObject.Object]

instance GObject SecurityManager where
    gobjectIsInitiallyUnowned _ = False
    gobjectType _ = c_webkit_security_manager_get_type
    

class GObject o => SecurityManagerK o
instance (GObject o, IsDescendantOf SecurityManager o) => SecurityManagerK o

toSecurityManager :: SecurityManagerK o => o -> IO SecurityManager
toSecurityManager = unsafeCastTo SecurityManager

noSecurityManager :: Maybe SecurityManager
noSecurityManager = Nothing

type family ResolveSecurityManagerMethod (t :: Symbol) (o :: *) :: * where
    ResolveSecurityManagerMethod "bindProperty" o = GObject.ObjectBindPropertyMethodInfo
    ResolveSecurityManagerMethod "bindPropertyFull" o = GObject.ObjectBindPropertyFullMethodInfo
    ResolveSecurityManagerMethod "forceFloating" o = GObject.ObjectForceFloatingMethodInfo
    ResolveSecurityManagerMethod "freezeNotify" o = GObject.ObjectFreezeNotifyMethodInfo
    ResolveSecurityManagerMethod "isFloating" o = GObject.ObjectIsFloatingMethodInfo
    ResolveSecurityManagerMethod "notify" o = GObject.ObjectNotifyMethodInfo
    ResolveSecurityManagerMethod "notifyByPspec" o = GObject.ObjectNotifyByPspecMethodInfo
    ResolveSecurityManagerMethod "ref" o = GObject.ObjectRefMethodInfo
    ResolveSecurityManagerMethod "refSink" o = GObject.ObjectRefSinkMethodInfo
    ResolveSecurityManagerMethod "registerUriSchemeAsCorsEnabled" o = SecurityManagerRegisterUriSchemeAsCorsEnabledMethodInfo
    ResolveSecurityManagerMethod "registerUriSchemeAsDisplayIsolated" o = SecurityManagerRegisterUriSchemeAsDisplayIsolatedMethodInfo
    ResolveSecurityManagerMethod "registerUriSchemeAsEmptyDocument" o = SecurityManagerRegisterUriSchemeAsEmptyDocumentMethodInfo
    ResolveSecurityManagerMethod "registerUriSchemeAsLocal" o = SecurityManagerRegisterUriSchemeAsLocalMethodInfo
    ResolveSecurityManagerMethod "registerUriSchemeAsNoAccess" o = SecurityManagerRegisterUriSchemeAsNoAccessMethodInfo
    ResolveSecurityManagerMethod "registerUriSchemeAsSecure" o = SecurityManagerRegisterUriSchemeAsSecureMethodInfo
    ResolveSecurityManagerMethod "replaceData" o = GObject.ObjectReplaceDataMethodInfo
    ResolveSecurityManagerMethod "replaceQdata" o = GObject.ObjectReplaceQdataMethodInfo
    ResolveSecurityManagerMethod "runDispose" o = GObject.ObjectRunDisposeMethodInfo
    ResolveSecurityManagerMethod "stealData" o = GObject.ObjectStealDataMethodInfo
    ResolveSecurityManagerMethod "stealQdata" o = GObject.ObjectStealQdataMethodInfo
    ResolveSecurityManagerMethod "thawNotify" o = GObject.ObjectThawNotifyMethodInfo
    ResolveSecurityManagerMethod "unref" o = GObject.ObjectUnrefMethodInfo
    ResolveSecurityManagerMethod "uriSchemeIsCorsEnabled" o = SecurityManagerUriSchemeIsCorsEnabledMethodInfo
    ResolveSecurityManagerMethod "uriSchemeIsDisplayIsolated" o = SecurityManagerUriSchemeIsDisplayIsolatedMethodInfo
    ResolveSecurityManagerMethod "uriSchemeIsEmptyDocument" o = SecurityManagerUriSchemeIsEmptyDocumentMethodInfo
    ResolveSecurityManagerMethod "uriSchemeIsLocal" o = SecurityManagerUriSchemeIsLocalMethodInfo
    ResolveSecurityManagerMethod "uriSchemeIsNoAccess" o = SecurityManagerUriSchemeIsNoAccessMethodInfo
    ResolveSecurityManagerMethod "uriSchemeIsSecure" o = SecurityManagerUriSchemeIsSecureMethodInfo
    ResolveSecurityManagerMethod "watchClosure" o = GObject.ObjectWatchClosureMethodInfo
    ResolveSecurityManagerMethod "getData" o = GObject.ObjectGetDataMethodInfo
    ResolveSecurityManagerMethod "getProperty" o = GObject.ObjectGetPropertyMethodInfo
    ResolveSecurityManagerMethod "getQdata" o = GObject.ObjectGetQdataMethodInfo
    ResolveSecurityManagerMethod "setData" o = GObject.ObjectSetDataMethodInfo
    ResolveSecurityManagerMethod "setProperty" o = GObject.ObjectSetPropertyMethodInfo
    ResolveSecurityManagerMethod l o = MethodResolutionFailed l o

instance (info ~ ResolveSecurityManagerMethod t SecurityManager, MethodInfo info SecurityManager p) => IsLabelProxy t (SecurityManager -> p) where
    fromLabelProxy _ = overloadedMethod (MethodProxy :: MethodProxy info)

#if MIN_VERSION_base(4,9,0)
instance (info ~ ResolveSecurityManagerMethod t SecurityManager, MethodInfo info SecurityManager p) => IsLabel t (SecurityManager -> p) where
    fromLabel _ = overloadedMethod (MethodProxy :: MethodProxy info)
#endif

type instance AttributeList SecurityManager = SecurityManagerAttributeList
type SecurityManagerAttributeList = ('[ ] :: [(Symbol, *)])

type instance SignalList SecurityManager = SecurityManagerSignalList
type SecurityManagerSignalList = ('[ '("notify", GObject.ObjectNotifySignalInfo)] :: [(Symbol, *)])

-- method SecurityManager::register_uri_scheme_as_cors_enabled
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "SecurityManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "scheme", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_security_manager_register_uri_scheme_as_cors_enabled" webkit_security_manager_register_uri_scheme_as_cors_enabled :: 
    Ptr SecurityManager ->                  -- _obj : TInterface "WebKit2" "SecurityManager"
    CString ->                              -- scheme : TBasicType TUTF8
    IO ()


securityManagerRegisterUriSchemeAsCorsEnabled ::
    (MonadIO m, SecurityManagerK a) =>
    a                                       -- _obj
    -> T.Text                               -- scheme
    -> m ()                                 -- result
securityManagerRegisterUriSchemeAsCorsEnabled _obj scheme = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    scheme' <- textToCString scheme
    webkit_security_manager_register_uri_scheme_as_cors_enabled _obj' scheme'
    touchManagedPtr _obj
    freeMem scheme'
    return ()

data SecurityManagerRegisterUriSchemeAsCorsEnabledMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, SecurityManagerK a) => MethodInfo SecurityManagerRegisterUriSchemeAsCorsEnabledMethodInfo a signature where
    overloadedMethod _ = securityManagerRegisterUriSchemeAsCorsEnabled

-- method SecurityManager::register_uri_scheme_as_display_isolated
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "SecurityManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "scheme", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_security_manager_register_uri_scheme_as_display_isolated" webkit_security_manager_register_uri_scheme_as_display_isolated :: 
    Ptr SecurityManager ->                  -- _obj : TInterface "WebKit2" "SecurityManager"
    CString ->                              -- scheme : TBasicType TUTF8
    IO ()


securityManagerRegisterUriSchemeAsDisplayIsolated ::
    (MonadIO m, SecurityManagerK a) =>
    a                                       -- _obj
    -> T.Text                               -- scheme
    -> m ()                                 -- result
securityManagerRegisterUriSchemeAsDisplayIsolated _obj scheme = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    scheme' <- textToCString scheme
    webkit_security_manager_register_uri_scheme_as_display_isolated _obj' scheme'
    touchManagedPtr _obj
    freeMem scheme'
    return ()

data SecurityManagerRegisterUriSchemeAsDisplayIsolatedMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, SecurityManagerK a) => MethodInfo SecurityManagerRegisterUriSchemeAsDisplayIsolatedMethodInfo a signature where
    overloadedMethod _ = securityManagerRegisterUriSchemeAsDisplayIsolated

-- method SecurityManager::register_uri_scheme_as_empty_document
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "SecurityManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "scheme", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_security_manager_register_uri_scheme_as_empty_document" webkit_security_manager_register_uri_scheme_as_empty_document :: 
    Ptr SecurityManager ->                  -- _obj : TInterface "WebKit2" "SecurityManager"
    CString ->                              -- scheme : TBasicType TUTF8
    IO ()


securityManagerRegisterUriSchemeAsEmptyDocument ::
    (MonadIO m, SecurityManagerK a) =>
    a                                       -- _obj
    -> T.Text                               -- scheme
    -> m ()                                 -- result
securityManagerRegisterUriSchemeAsEmptyDocument _obj scheme = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    scheme' <- textToCString scheme
    webkit_security_manager_register_uri_scheme_as_empty_document _obj' scheme'
    touchManagedPtr _obj
    freeMem scheme'
    return ()

data SecurityManagerRegisterUriSchemeAsEmptyDocumentMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, SecurityManagerK a) => MethodInfo SecurityManagerRegisterUriSchemeAsEmptyDocumentMethodInfo a signature where
    overloadedMethod _ = securityManagerRegisterUriSchemeAsEmptyDocument

-- method SecurityManager::register_uri_scheme_as_local
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "SecurityManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "scheme", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_security_manager_register_uri_scheme_as_local" webkit_security_manager_register_uri_scheme_as_local :: 
    Ptr SecurityManager ->                  -- _obj : TInterface "WebKit2" "SecurityManager"
    CString ->                              -- scheme : TBasicType TUTF8
    IO ()


securityManagerRegisterUriSchemeAsLocal ::
    (MonadIO m, SecurityManagerK a) =>
    a                                       -- _obj
    -> T.Text                               -- scheme
    -> m ()                                 -- result
securityManagerRegisterUriSchemeAsLocal _obj scheme = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    scheme' <- textToCString scheme
    webkit_security_manager_register_uri_scheme_as_local _obj' scheme'
    touchManagedPtr _obj
    freeMem scheme'
    return ()

data SecurityManagerRegisterUriSchemeAsLocalMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, SecurityManagerK a) => MethodInfo SecurityManagerRegisterUriSchemeAsLocalMethodInfo a signature where
    overloadedMethod _ = securityManagerRegisterUriSchemeAsLocal

-- method SecurityManager::register_uri_scheme_as_no_access
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "SecurityManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "scheme", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_security_manager_register_uri_scheme_as_no_access" webkit_security_manager_register_uri_scheme_as_no_access :: 
    Ptr SecurityManager ->                  -- _obj : TInterface "WebKit2" "SecurityManager"
    CString ->                              -- scheme : TBasicType TUTF8
    IO ()


securityManagerRegisterUriSchemeAsNoAccess ::
    (MonadIO m, SecurityManagerK a) =>
    a                                       -- _obj
    -> T.Text                               -- scheme
    -> m ()                                 -- result
securityManagerRegisterUriSchemeAsNoAccess _obj scheme = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    scheme' <- textToCString scheme
    webkit_security_manager_register_uri_scheme_as_no_access _obj' scheme'
    touchManagedPtr _obj
    freeMem scheme'
    return ()

data SecurityManagerRegisterUriSchemeAsNoAccessMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, SecurityManagerK a) => MethodInfo SecurityManagerRegisterUriSchemeAsNoAccessMethodInfo a signature where
    overloadedMethod _ = securityManagerRegisterUriSchemeAsNoAccess

-- method SecurityManager::register_uri_scheme_as_secure
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "SecurityManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "scheme", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Nothing
-- throws : False
-- Skip return : False

foreign import ccall "webkit_security_manager_register_uri_scheme_as_secure" webkit_security_manager_register_uri_scheme_as_secure :: 
    Ptr SecurityManager ->                  -- _obj : TInterface "WebKit2" "SecurityManager"
    CString ->                              -- scheme : TBasicType TUTF8
    IO ()


securityManagerRegisterUriSchemeAsSecure ::
    (MonadIO m, SecurityManagerK a) =>
    a                                       -- _obj
    -> T.Text                               -- scheme
    -> m ()                                 -- result
securityManagerRegisterUriSchemeAsSecure _obj scheme = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    scheme' <- textToCString scheme
    webkit_security_manager_register_uri_scheme_as_secure _obj' scheme'
    touchManagedPtr _obj
    freeMem scheme'
    return ()

data SecurityManagerRegisterUriSchemeAsSecureMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, SecurityManagerK a) => MethodInfo SecurityManagerRegisterUriSchemeAsSecureMethodInfo a signature where
    overloadedMethod _ = securityManagerRegisterUriSchemeAsSecure

-- method SecurityManager::uri_scheme_is_cors_enabled
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "SecurityManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "scheme", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_security_manager_uri_scheme_is_cors_enabled" webkit_security_manager_uri_scheme_is_cors_enabled :: 
    Ptr SecurityManager ->                  -- _obj : TInterface "WebKit2" "SecurityManager"
    CString ->                              -- scheme : TBasicType TUTF8
    IO CInt


securityManagerUriSchemeIsCorsEnabled ::
    (MonadIO m, SecurityManagerK a) =>
    a                                       -- _obj
    -> T.Text                               -- scheme
    -> m Bool                               -- result
securityManagerUriSchemeIsCorsEnabled _obj scheme = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    scheme' <- textToCString scheme
    result <- webkit_security_manager_uri_scheme_is_cors_enabled _obj' scheme'
    let result' = (/= 0) result
    touchManagedPtr _obj
    freeMem scheme'
    return result'

data SecurityManagerUriSchemeIsCorsEnabledMethodInfo
instance (signature ~ (T.Text -> m Bool), MonadIO m, SecurityManagerK a) => MethodInfo SecurityManagerUriSchemeIsCorsEnabledMethodInfo a signature where
    overloadedMethod _ = securityManagerUriSchemeIsCorsEnabled

-- method SecurityManager::uri_scheme_is_display_isolated
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "SecurityManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "scheme", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_security_manager_uri_scheme_is_display_isolated" webkit_security_manager_uri_scheme_is_display_isolated :: 
    Ptr SecurityManager ->                  -- _obj : TInterface "WebKit2" "SecurityManager"
    CString ->                              -- scheme : TBasicType TUTF8
    IO CInt


securityManagerUriSchemeIsDisplayIsolated ::
    (MonadIO m, SecurityManagerK a) =>
    a                                       -- _obj
    -> T.Text                               -- scheme
    -> m Bool                               -- result
securityManagerUriSchemeIsDisplayIsolated _obj scheme = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    scheme' <- textToCString scheme
    result <- webkit_security_manager_uri_scheme_is_display_isolated _obj' scheme'
    let result' = (/= 0) result
    touchManagedPtr _obj
    freeMem scheme'
    return result'

data SecurityManagerUriSchemeIsDisplayIsolatedMethodInfo
instance (signature ~ (T.Text -> m Bool), MonadIO m, SecurityManagerK a) => MethodInfo SecurityManagerUriSchemeIsDisplayIsolatedMethodInfo a signature where
    overloadedMethod _ = securityManagerUriSchemeIsDisplayIsolated

-- method SecurityManager::uri_scheme_is_empty_document
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "SecurityManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "scheme", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_security_manager_uri_scheme_is_empty_document" webkit_security_manager_uri_scheme_is_empty_document :: 
    Ptr SecurityManager ->                  -- _obj : TInterface "WebKit2" "SecurityManager"
    CString ->                              -- scheme : TBasicType TUTF8
    IO CInt


securityManagerUriSchemeIsEmptyDocument ::
    (MonadIO m, SecurityManagerK a) =>
    a                                       -- _obj
    -> T.Text                               -- scheme
    -> m Bool                               -- result
securityManagerUriSchemeIsEmptyDocument _obj scheme = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    scheme' <- textToCString scheme
    result <- webkit_security_manager_uri_scheme_is_empty_document _obj' scheme'
    let result' = (/= 0) result
    touchManagedPtr _obj
    freeMem scheme'
    return result'

data SecurityManagerUriSchemeIsEmptyDocumentMethodInfo
instance (signature ~ (T.Text -> m Bool), MonadIO m, SecurityManagerK a) => MethodInfo SecurityManagerUriSchemeIsEmptyDocumentMethodInfo a signature where
    overloadedMethod _ = securityManagerUriSchemeIsEmptyDocument

-- method SecurityManager::uri_scheme_is_local
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "SecurityManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "scheme", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_security_manager_uri_scheme_is_local" webkit_security_manager_uri_scheme_is_local :: 
    Ptr SecurityManager ->                  -- _obj : TInterface "WebKit2" "SecurityManager"
    CString ->                              -- scheme : TBasicType TUTF8
    IO CInt


securityManagerUriSchemeIsLocal ::
    (MonadIO m, SecurityManagerK a) =>
    a                                       -- _obj
    -> T.Text                               -- scheme
    -> m Bool                               -- result
securityManagerUriSchemeIsLocal _obj scheme = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    scheme' <- textToCString scheme
    result <- webkit_security_manager_uri_scheme_is_local _obj' scheme'
    let result' = (/= 0) result
    touchManagedPtr _obj
    freeMem scheme'
    return result'

data SecurityManagerUriSchemeIsLocalMethodInfo
instance (signature ~ (T.Text -> m Bool), MonadIO m, SecurityManagerK a) => MethodInfo SecurityManagerUriSchemeIsLocalMethodInfo a signature where
    overloadedMethod _ = securityManagerUriSchemeIsLocal

-- method SecurityManager::uri_scheme_is_no_access
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "SecurityManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "scheme", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_security_manager_uri_scheme_is_no_access" webkit_security_manager_uri_scheme_is_no_access :: 
    Ptr SecurityManager ->                  -- _obj : TInterface "WebKit2" "SecurityManager"
    CString ->                              -- scheme : TBasicType TUTF8
    IO CInt


securityManagerUriSchemeIsNoAccess ::
    (MonadIO m, SecurityManagerK a) =>
    a                                       -- _obj
    -> T.Text                               -- scheme
    -> m Bool                               -- result
securityManagerUriSchemeIsNoAccess _obj scheme = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    scheme' <- textToCString scheme
    result <- webkit_security_manager_uri_scheme_is_no_access _obj' scheme'
    let result' = (/= 0) result
    touchManagedPtr _obj
    freeMem scheme'
    return result'

data SecurityManagerUriSchemeIsNoAccessMethodInfo
instance (signature ~ (T.Text -> m Bool), MonadIO m, SecurityManagerK a) => MethodInfo SecurityManagerUriSchemeIsNoAccessMethodInfo a signature where
    overloadedMethod _ = securityManagerUriSchemeIsNoAccess

-- method SecurityManager::uri_scheme_is_secure
-- method type : OrdinaryMethod
-- Args : [Arg {argCName = "_obj", argType = TInterface "WebKit2" "SecurityManager", direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing},Arg {argCName = "scheme", argType = TBasicType TUTF8, direction = DirectionIn, mayBeNull = False, argScope = ScopeTypeInvalid, argClosure = -1, argDestroy = -1, argCallerAllocates = False, transfer = TransferNothing}]
-- Lengths : []
-- returnType : Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "webkit_security_manager_uri_scheme_is_secure" webkit_security_manager_uri_scheme_is_secure :: 
    Ptr SecurityManager ->                  -- _obj : TInterface "WebKit2" "SecurityManager"
    CString ->                              -- scheme : TBasicType TUTF8
    IO CInt


securityManagerUriSchemeIsSecure ::
    (MonadIO m, SecurityManagerK a) =>
    a                                       -- _obj
    -> T.Text                               -- scheme
    -> m Bool                               -- result
securityManagerUriSchemeIsSecure _obj scheme = liftIO $ do
    let _obj' = unsafeManagedPtrCastPtr _obj
    scheme' <- textToCString scheme
    result <- webkit_security_manager_uri_scheme_is_secure _obj' scheme'
    let result' = (/= 0) result
    touchManagedPtr _obj
    freeMem scheme'
    return result'

data SecurityManagerUriSchemeIsSecureMethodInfo
instance (signature ~ (T.Text -> m Bool), MonadIO m, SecurityManagerK a) => MethodInfo SecurityManagerUriSchemeIsSecureMethodInfo a signature where
    overloadedMethod _ = securityManagerUriSchemeIsSecure


